/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qcluster.h
 * AUTHOR:       Gerry Lachac x6193
 * ORG:          Intel Corporation
 * ORIG-DATE:    27-Jun-96 at 10:00:43
 * LAST-MOD:     15-Oct-97 at 14:55:45 by Gerry Lachac
 * PURPOSE:
 *    This module equates and prototypes relating to clusters
 *
 * HISTORY:
 * Date                 Who     Description
 * 20-Jun-96            GL      Creation date.
 ***************************************************************************/

#ifndef __QCLUSTER_H__
#define __QCLUSTER_H__

/* Cluster types */
typedef UInt24 QPortDef;

/* Attribute type so apps can allocate SCBus resources */
#define QSCRES_Std_ComponentType   0x100
#define QSCRES_Std_Component_Type  QSCRES_Std_ComponentType
#define QCLUST_Std_ComponentType    0x101


/* TDM Stream types (peripheral attached to stream) */
typedef enum {
	QTS_TYPE_ANY =	0,		/* Wildcard						*/
	QTS_TYPE_NONE=	0,		/* No device					*/
	QTS_TYPE_MMA = 1,		/* MMA TDM Bus					*/
	QTS_TYPE_SCBUS,		/* SCBus							*/
	QTS_TYPE_NET,			/* Network Interface TDM	*/
	QTS_TYPE_RESERVE1,	/* Reserved for future     */
	QTS_TYPE_RESERVE2 	/* Reserved for future     */
} enum_QTStreamType;

/* Stream type aliases */
#define QTS_TYPE_RESOURCE	QTS_TYPE_MMA
#define QTS_TYPE_NETWORK	QTS_TYPE_NET


/* Timeslot data directions */
typedef enum {
	QTS_DIR_ANY	= 0,			/* Direction wildcard				*/
	QTS_DIR_IN	= 1,			/* Data flows into peripheral		*/
	QTS_DIR_OUT	= 2,			/* Data flows out of peripheral	*/
	QTS_DIR_BOTH = 3			/* Creation request - IN and OUT	*/
} enum_QTSlotDir;


/*
 *  Some convenient defines for qClusterTSAssign  to use in
 *  scPortID argument.
 */
#define QSCBUS_PORT_IN   (QClusterDefinePort( 0, SCBUS, IN, 1 ))
#define QSCBUS_PORT_OUT  (QClusterDefinePort( 0, SCBUS, OUT, 1 ))

/* Defines for the encoding argument */
#define QSCBUS_ENCODING_ALAW   0x1
#define QSCBUS_ENCODING_MULAW  0x2

/* Defines for default idle pattern  argument*/
#define QSCBUS_IDLE_ALAW   0xD5
#define QSCBUS_IDLE_MULAW  0x7F




/* For our C++ friends */
#ifdef __cplusplus
extern "C"{
#endif



/* Prototypes */
QStatus qClusterActivate(QHandle,QTrans,QCompDesc,QCompDesc,QCompDesc,
                         QPortDef,QCompDesc,UInt8);
QStatus qClusterCompByAttr(QHandle,QTrans,QCompDesc,QCompDesc,QCompAttr *);
QStatus qClusterByComp(QHandle,QTrans,QCompDesc,QCompDesc);
QStatus qClusterConnect(QHandle,QTrans,QCompDesc,QCompDesc,QCompDesc,
                        QPortDef, QCompDesc, QPortDef);
QStatus qClusterCreate(QHandle,QCompDesc,QTrans,QCompDesc,QCompAttr *);
QStatus qClusterDeactivate(QHandle,QTrans,QCompDesc,QCompDesc,
                           QCompDesc, QPortDef);
QStatus qClusterDestroy(QHandle,QTrans,QCompDesc,QCompDesc);
QStatus qClusterDisconnect(QHandle,QTrans,QCompDesc,QCompDesc,QCompDesc,
                           QPortDef,QCompDesc,QPortDef);
QStatus qClusterTSAssign(QHandle,QTrans,QCompDesc,QCompDesc,QCompDesc,
                         QPortDef,UInt8,UInt8,UInt8,UInt16 *);
QStatus qClusterTSUnassign(QHandle,QTrans,QCompDesc,QCompDesc,QCompDesc,
                           QPortDef);
QStatus qClusterSlotInfo(QHandle,QTrans,QCompDesc,QCompDesc,QCompDesc,QPortDef);
QStatus qClusterAllocate(QHandle,QTrans,QCompDesc,QCompDesc,QCompAttr *);
QStatus qClusterFree(QHandle,QTrans,QCompDesc,QCompDesc);
QStatus qClusterFind(QHandle,QTrans,QCompDesc,QCompDesc, QCompAttr *);
QStatus qClusterConfigLock(QHandle,QTrans,QCompDesc,QCompDesc);
QStatus qClusterConfigUnlock(QHandle,QTrans,QCompDesc,QCompDesc);





#ifdef __cplusplus
}
#endif

#endif /* __Q_CLUSTER_H__*/
