/******************************************************************************
*     Copyright (c) 1995-2001 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*  
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/

/****************************************************************************
 * FILE:         qcomplib.h
 * AUTHOR:       puppalag
 * ORG:          Intel Corporation
 * ORIG-DATE:    10-Jun-95 at 13:01:23
 * LAST-MOD:      8-May-01 at 15:25:46 by Larry Kolakowski  x6221
 * PURPOSE:
 *    This module contains all the equates for component specific
 *    information  
 *
 * HISTORY:
 * Date        Who   Description
 * 06-Nov-98   DEH   Added IC Resource to Kernel Components
 * 15-Oct-94   GP    Initial Creation.
 ***************************************************************************/

/***************************************************************************/
/***************************** IMPORTANT NOTE ******************************/
/***************************************************************************/
/*                                                                         */
/* This file belongs to the kernel group and must not be modified by any   */
/* other group.                                                            */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/***************************************************************************/
/********************************* NOTE ************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This file is part of the system release. Please try not to add kernel   */
/* specific stuff to this file. However, if you must, it should be         */
/* included in if (QCPU < QHOST) section.                                  */
/***************************************************************************/

#ifndef __QCOMP_H__
#define __QCOMP_H__

#include "qoscommon.h"

#ifndef QCPU
#error QCPU is not defined
#endif

/* This header file should only be included for kernel build */
#if (QCPU < QHOST)
#include <qkercfgs.h>
#endif

#ifndef QINST_WIDTH
#error Undefined QINST_WIDTH
#if (((QCPU == QXSCALE)) && (KERNEL_RTK)) || (QCPU >= QHOST)
#define QINST_WIDTH 16
#else
#define QINST_WIDTH 8
#endif
#endif

#if (QINST_WIDTH == 16)
/* Definitions for 16 bit instances */
#define QMAX_NODE 0xff
#define QMAX_INST 0xffff
#define QCOMP_N_NIL 255    /* Standard Node Identifiers            */
typedef UInt16 QInstNum;   /* Use this data type for all instances */
typedef UInt8  QNodeNum;   /* Use this data type for all nodes     */
#else
/* Definitions for 8 bit instances  */
#define QMAX_NODE 0xffff
#define QMAX_INST 0x0ff
#define QCOMP_N_NIL 65535   /* Standard Node Identifiers            */
typedef UInt8  QInstNum;    /* Use this data type for all instances */
typedef UInt16 QNodeNum;    /* Use this data type for all nodes     */
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* kernel specific defines */
#if (QCPU < QHOST)
#define QCOMP_N_SELF          (QNodeNum)(qKerId->node)
#define QCOMP_B_SELF          (Uint8)(qKerId->board)
#define QCOMP_P_SELF          (Uint8)(qKerId->processor)
#else /* host specific defines */
#define QCOMP_N_SELF          qSelf.node
#define QCOMP_B_SELF          qSelf.board
#define QCOMP_P_SELF
#endif


/* standard Board Identifiers */
#define QCOMP_B_HOST
#define QCOMP_B_NIL           255

/*Standard Processors Identifiers */
#define QCOMP_P_HOST          0
#define QCOMP_P_CP            1
#define QCOMP_P_SP            
#define QCOMP_P_NIL           255

/* Standard Component Identifiers */
#define QCOMP_C_SYS_SERVICE   0
#define QCOMP_C_SYS_SERVICE_MAX_INSTANCE QCOMP_I_LAST_STD_INST+1
#define QCOMP_C_TASK          1
#define QCOMP_C_TASK_MAX_INSTANCE QT_MAX_INSTANCE+1
#define QCOMP_C_STREAM        2
#define QCOMP_C_STREAM_MAX_INSTANCE 1 /* seems not being used */ 
#define QCOMP_C_LAST_STD_COMP 2  /* must be updated if more stand component added, also update Kernel Component Idenntifiers as well */

/* Kernel Component Identifiers */
#if KERNEL_CP || (QCPU >= QHOST)
#define QCOMP_C_CLUSTERMGR              3
#define QCOMP_C_TDMRES                  4
#define QCOMP_C_ICRES                   5
#define QCOMP_C_LAST_KERNEL_COMP        5          /* must be updated if more kernel component added */

#define QCOMP_C_KERNEL 0x52 /* Standard Component attribute number used
                             * by qagent to receive generic kernel parms
                             * commands from the host/downloader. This
                             * standard component attribute is an alias
                             * for QCOMP_C_SYS_SERVICE and is not an 
                             * independent instance of a component.
                             */

#if (QCPU == QXSCALE)
/* RIM - Max number of instances of clusters in DTI 16 
         Based on 30 channels * 16 trunks =           
         480 + 16 for possible signaling channel = 496 rounded to 500    */
/* MAG - Multiplied by 2 for DS3 support */
#define QCOMP_C_CLUSTERMGR_MAX_INSTANCE 1000 /* max inst of clusters     */
#define QCOMP_C_TDMRES_MAX_INSTANCE     1000 /* max inst of TDM resource */
#define QCOMP_C_ICRES_MAX_INSTANCE         0 /* max inst of ICP resource: NOT USED */
#elif ((QCPU == QI960) && (QCPUREV == QI960HD))
#define QCOMP_C_CLUSTERMGR_MAX_INSTANCE 480  /* max inst of clusters     */
#define QCOMP_C_TDMRES_MAX_INSTANCE     596  /* max inst of TDM resource */
#define QCOMP_C_ICRES_MAX_INSTANCE         0 /* max inst of ICP resource: NOT USED */
#else
#define QCOMP_C_CLUSTERMGR_MAX_INSTANCE 255  /* max inst of clusters     */
#define QCOMP_C_TDMRES_MAX_INSTANCE     255  /* max inst of TDM resource */
#define QCOMP_C_ICRES_MAX_INSTANCE        0  /* max inst of ICP resource: NOT USED */
#endif

#elif KERNEL_SP
#define QCOMP_C_LAST_KERNEL_COMP        QCOMP_C_LAST_STD_COMP  /* SP doesn't need cluster components */
#define QCOMP_C_CLUSTERMGR_MAX_INSTANCE 255  
#else
#error KERNEL error
#endif

#define QCOMP_C_INVALID       
#define QCOMP_C_NIL           255
/* Standard Instance Identifiers */
#define QCOMP_I_COMPONENT     0
#define QCOMP_I_HMSGDRIVER    1
#define QCOMP_I_HSTREAMDRV    2
#define QCOMP_I_IPCDRIVER     3
#define QCOMP_I_CONFIGMGR     4          
#define QCOMP_I_RESOURCEMGR   5
#define QCOMP_I_SMP           6
#define QCOMP_I_BSTREAM_TSK   7
#define QCOMP_I_CLUSTERMGR    8
#define QCOMP_I_SRAM          9
#define QCOMP_I_IDLE_TSK      10
#define QCOMP_I_FTIMER        11
#define QCOMP_I_QAGENT        12
#define QCOMP_I_FLASHWRITE    13   /* This is only for flashwrite_rtk.mlm */
#define QCOMP_I_SHREMOTECLIENT 14
#define QCOMP_I_HDLC          15
#define QCOMP_I_DELAYEDMSGHANDLER 16
#define QCOMP_I_LAST_STD_INST 16   /* must be updated if more std inst added */

#define QCOMP_I_NIL           QMAX_INST

/* Component state */
#define QCOMPSTATE_UNREGISTERED  1
#define QCOMPSTATE_REGISTERED    2
#define QCOMPSTATE_ALLOCATED     3
#define QCOMPSTATE_FREE          4
#define QCOMPSTATE_RESERVED      5
#define QCOMPSTATE_RESTRICTED    6
#define QCOMPSTATE_FREEPENDING   7
#define QCOMPSTATE_ALLOCATING    8
#define QCOMPSTATE_FREEING       9



#if (QCPU >= QHOST) 
typedef  struct{
   UInt16   node;
   UInt8    board;
   Uint8    pad1;
   UInt8    processor;
   UInt8    component;
   UInt8    instance;
   Uint8    pad2;
}QBootCompDesc;
#endif


#if (QINST_WIDTH == 16)

#if (QCPU >= QHOST) 
typedef  struct{
   UInt16   instance;
   UInt8    board;
   Uint8    pad1;
   UInt8    processor;
   UInt8    component;
   UInt8    node;
   Uint8    pad2;
}QCompDesc;

#elif (QCPU == QM56301)
typedef    struct{
   unsigned   instance:16;
   unsigned   board:8;
   unsigned   processor:8;
   unsigned   component:8;
   unsigned   node:8;
}QCompDesc;

#elif (QCPU == QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU == QARM) || (QCPU == QXSCALE)
typedef   struct{
   UInt16    instance;
   UInt8     board;
   Uint8     pad1;
   UInt8     processor;
   UInt8     component;
   UInt8     node;
   Uint8     pad2;
}QCompDesc;

#elif (QCPU == QPPC603) || (QCPU == QMPC8260)
/* Note board is now before node to maintain proper word alignment.
   This prevents the structure from being padded by another byte */
typedef   struct{
   Uint8     pad1;
   UInt8     board;
   UInt16    instance;
   Uint8     pad2;
   UInt8     node;
   UInt8     component;
   UInt8     processor;
}QCompDesc;


#else
#error QCPU selection error
#endif

#define QSysCompDesc2CompDesc(sysCompDesc, compDesc) { \
   (compDesc).node = QCOMP_N_SELF; \
   (compDesc).board = QCOMP_B_SELF; \
   (compDesc).processor = QCOMP_P_SELF; \
   (compDesc).component = (sysCompDesc).component; \
   (compDesc).instance = (Uint16)((sysCompDesc).instance); \
}

#elif (QINST_WIDTH == 8)

#if (QCPU >= QHOST) 
#if (QCPU == QHOST )
typedef  struct{
   UInt16   node;
   UInt8    board;
   Uint8    pad1;
   UInt8    processor;
   UInt8    component;
   UInt8    instance;
   Uint8    pad2;
}QCompDesc;
#else /* Uinx Specific declaration for maintaining backward compatibility */
typedef  struct{
   UInt16   node;
   UInt8    board;
   UInt8    processor;
   UInt8    component;
   UInt8    instance;
}QCompDesc;
#endif

#elif (QCPU == QM56301)
typedef    struct{
   unsigned   node:16;
   unsigned   board:8;
   unsigned   processor:8;
   unsigned   component:8;
   unsigned   instance:8;
}QCompDesc;

#elif (QCPU == QI960) || (QCPU == QC6X) || (QCPU == QX86) || (QCPU == QARM) || (QCPU == QXSCALE)
typedef    struct{
   UInt16     node;
   UInt8      board;
   Uint8      pad1;
   UInt8      processor;
   UInt8      component;
   UInt8      instance;
   Uint8      pad2;
}QCompDesc;

#elif (QCPU == QPPC603) || (QCPU == QMPC8260)
/* Note board is now before node to maintain proper word alignment.
   This prevents the structure from being padded by another byte */
typedef  struct{
   Uint8    pad1;
   UInt8    board;
   UInt16   node;
   Uint8    pad2;
   UInt8    instance;
   UInt8    component;
   UInt8    processor;
}QCompDesc;

#else
#error QCPU selection error
#endif

#define QSysCompDesc2CompDesc(sysCompDesc, compDesc) { \
   (compDesc).node = QCOMP_N_SELF; \
   (compDesc).board = QCOMP_B_SELF; \
   (compDesc).processor = QCOMP_P_SELF; \
   (compDesc).component = (sysCompDesc).component; \
   (compDesc).instance = (Uint8)((sysCompDesc).instance); \
}

#else
#error BAD QINST_WIDTH
#endif

#define qCompDescIsNull(compDesc)			\
	(((compDesc).instance == 0) &&					\
	 ((compDesc).component == 0) &&				\
	 ((compDesc).processor == 0) &&			\
	 ((compDesc).board == 0) &&			\
	 ((compDesc).node == 0))

#define qCompDescEqual(desc1,desc2)								\
	(((desc1).instance == (desc2).instance) &&							\
	 ((desc1).component == (desc2).component) &&						\
	 ((desc1).processor == (desc2).processor) &&				\
	 ((desc1).board == (desc2).board) &&				\
	 ((desc1).node == (desc2).node))


typedef    struct{
   UInt8   component;
   UInt16  instance;
}QSysCompDesc;

#define QCompDesc2SysCompDesc(compDesc, sysCompDesc) { \
   (sysCompDesc).component = (compDesc).component; \
   (sysCompDesc).instance = (compDesc).instance; \
}

typedef enum{QCOMP_PRIMARY=(1<<0),
             QCOMP_NOTIFY=(1<<1),
             QCOMP_ALLOCACK=(1<<2),
             QCOMP_SHAREABLE=(1<<3),
             QCOMP_CLIENTEXIT=(1<<4),
             QCOMP_SUBEXIT=(1<<5),
             QCOMP_DOWNLOADCOMPLETE=(1<<6)
}QCompOptions;

typedef struct {
    UInt32  key;
    Int32  value;
}QCompAttr;


typedef QCompAttr QAttribute;

/* 
 * Maximum number of attributes per component 
 * Dynamic sizing to be done later
 */
#define MAXATTRS   (10+1)
/*
 *  Standard values for the key Field 
 */

typedef enum {QATTR_UNIQUE,QATTR_SHARED}QCompAttrType;

   
#define QCOMPATTR_UNIQUEKEY_RANGE 0x800000

/*
 * Special Values for the key field
 */
#define QATTRKEY_OPERATORMASK 0xFFFFFFFC
#define QATTRKEY_OPERATOR     0xFFFFFFFC /* All values above 252 are operators */

#define QATTR_NULL 0xFFFFFFFF   
#define QATTR_AND  0xFFFFFFFE  
#define QATTR_OR   0xFFFFFFFD 
#define QATTR_NOT  0xFFFFFFFC 
/*
 *  Special Values for the value field
 */
#define QATTR_ANY  0xFFFFFFFF

#ifdef __cplusplus
}
#endif

#endif
