/******************************************************************************
*     Copyright (c) 1995-2001 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*  
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/


/****************************************************************************
 * FILE:         qcpu.h
 * AUTHOR:       puppalag
 * ORG:          Intel Corporation
 * ORIG-DATE:     5-Aug-95 at 17:48:31
 * LAST-MOD:      8-Sep-95 at 08:32:08 by puppalag
 * PURPOSE: This file contains the Target CPU specific 
 *             equates and selection criteria
 *
 * HISTORY:
 * Date        Who   Description
 * 07-Aug-95      GP    Initial Creation.
 ***************************************************************************/
 /*
 *   Mercury processor specific options
 */
#ifndef _QCPU_H__
#define _QCPU_H__ 

#ifdef __cplusplus
extern "C" {
#endif

#ifdef  QCPU
#define QI960        10       /* I960 CA/CF/HA processor */
#define QSIMSPARC    11       /* Simulator on a SUN sparc worksation */
#define QM56301      12       /* Motorola ONYX  Fixed point */
#define QTC31        13       /* Texas Instruments C31 Floating point */
#define QPPC603      14       /* Motorola Power PC 603EV */
#define QC6X         15       /* IT C6X processor */
#define QX86         16       /* Intel x86 Architecture */
#define QARM         17       /* ARM processor */
#define QMPC8260     18       /* Motorola MPC8260, PPC603 core */
#define QXSCALE      19       /* SA2/Coy Xscale 80200 Intel Processor */
/* The QI960 defines that the processor is from the I960 family,
 * but the QCPUREV defines as to whether the CPU is an HA/HD or an
 * CF 
 */
#define QI960HD		20			/* I960 HD processor */
#define QI960CF		21			/* I960 CF processor */
#define QHOST        250      /* HOST setting for including our header files 
                                 in their build environment */

#define QHOST_LITTLE_ENDIAN   QHOST /* HOST setting for Little Endian Host */
#define QHOST_BIG_ENDIAN      QHOST_LITTLE_ENDIAN+1 /* HOST setting for 
                                                       Big Endian Host  */

#if (QCPU==QI960)
#define QCHAR_BIT    8        /* 8 bit Byte addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "qi960.h" 

#elif (QCPU==QM56301)
#define QCHAR_BIT    24       /* 24 bit Word addressable */
#define QCHAR_BYTE   3        /* Number of bytes per character(word) */
#include "onyx.h"

#elif (QCPU==QSIMSPARC)
#define QCHAR_BIT    8        /* 8 bit Byte addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "simsparc.h"

#elif (QCPU==QTC31)
#define QCHAR_BIT    32       /* 32 bit Word addressable */
#define QCHAR_BYTE   4        /* Number of bytes per character(word) */
#include "c31.h"

#elif (QCPU==QPPC603) 
#define QCHAR_BIT    8       /* 8 bit BYTE addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "qppcdb.h"

#elif (QCPU == QMPC8260)
#define QCHAR_BIT    8       /* 8 bit BYTE addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "q8260db.h"

#elif (QCPU==QC6X)
#define QCHAR_BIT    8       /* 8 bit Word addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "qc6x.h"

#elif (QCPU==QX86)
#define QCHAR_BIT    8       /* 8 bit Word addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "qx86.h"

#elif (QCPU==QARM)
#define QCHAR_BIT    8       /* 8 bit Word addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "qarm.h"            /* ARM based products */

#elif (QCPU==QXSCALE)
#define QCHAR_BIT    8       /* 8 bit Word addressable */
#define QCHAR_BYTE   1        /* Number of bytes per character(word) */
#include "qxscale.h"            /* Xscale based products */

#else
#error QCPU selection error 
#endif
#else
#error QCPU not defined 
#endif

#ifdef __cplusplus
}
#endif

#endif
