/****************************************************************************
 *		Copyright (c) 1995 Intel Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qerror.h
 * AUTHOR:       Gerry Lachac
 * ORG:          Intel Corporation
 * ORIG-DATE:    17-Apr-95 at 21:17:42
 * LAST-MOD:     19-Jan-98 at 16:57:43 by Gerry Lachac
 * PURPOSE:
 *    Contains public structures, typedefs and defines for the Mercury
 *    Host Library.
 *
 * HISTORY:
 * Date			Who	Description
 * 17-Apr-95   GL 	Initial Creation.
 * 
 * 30-Jul-98	P.Heimlich	Adding GStream support.
 *
 ***************************************************************************/

#ifndef __QHLIBERR_H__
#define __QHLIBERR_H__

/* Typedefs */
#if 0
typedef UInt32    QError;
#endif


/* Error Defines */

#define QLIB            QERR_SYSTEM_HOSTLIB  /* Short alias for system define */
#define QDRIVER_ERROR_MASK 0xF0000000     /* High order 4 bits used for */
                                          /* driver errors */
/* Modules in library */
#define  GENERIC     0x00000000
#define  MEMORY      0x00010000
#define  ACCESS      0x00020000
#define  STREAMS     0x00030000
#define  MESSAGE     0x00040000
#define  PARM        0x00050000
#define  TRANS       0x00060000
#define  DNLD        0x00070000


/* Errors codes */
#define  QERR_HLIB_NULL_PTR    (QLIB|GENERIC|0x01)  /* null ptr passed to function */
#define  QERR_HLIB_OS          (QLIB|GENERIC|0x02)  /* Operating system error */
#define  QERR_HLIB_BIND        (QLIB|GENERIC|0x03)  /* bind alloc error */
#define  QERR_HLIB_MALLOC      (QLIB|GENERIC|0x04)  /* Memory alloc error */
#define  QERR_HLIB_NORESPONSE  (QLIB|GENERIC|0x05)  /* Board not responding */
#define  QERR_HLIB_INITIALIZED (QLIB|GENERIC|0x06)  /* library already
                                                       initialized */
#define  QERR_HLIB_QDNLDBIN    (QLIB|GENERIC|0x07)  /* Var not set */
#define  QERR_HLIB_BOARDLIST   (QLIB|GENERIC|0x08)  /* boards in list don't
                                                        match qCompUse/Unuse */
#define  QERR_HLIB_BADBOARD    (QLIB|GENERIC|0x09)  /* Invalid board
                                                       specified  usually in
                                                       compdesc */
#define  QERR_HLIB_DRVSYNC     (QLIB|GENERIC|0x0A)  /* Library not compiled
                                                       to handle this driver */
#define  QERR_HLIB_NOTINITIALIZED     (QLIB|GENERIC|0x0B)  /* Library not initialised*/
#define  QERR_HLIB_POLLTIMEOUT       (QLIB|GENERIC|0x0C)  /* Poll Timed out */
#define  QERR_HLIB_GROUPAPINOTINIT   (QLIB|GENERIC|0x0D)  /* Group Api not initialised */


#define  QERR_HLIB_NOMOREHANDLES  (QLIB|ACCESS|0x01)  /* Out of file handles */
#define  QERR_HLIB_BADINTERFACE   (QLIB|ACCESS|0x02)  /* Unsupported transport */

#define  QERR_HLIB_MSGSIZE    (QLIB|MESSAGE|0x01)   /* Msg size too large */
#define  QERR_HLIB_MSGFREE    (QLIB|MESSAGE|0x02)   /* Msg already free */
#define  QERR_HLIB_BADDATATYPE (QLIB|MESSAGE|0x03)  /* Unknown datatype passed
                                                      to qMsgVarFieldPut/Get */
#define  QERR_HLIB_UNSUP_DATATYPE (QLIB|MESSAGE|0x04)  /* Unsupported datatype
                                               passed to qMsgVarFieldPut/Get */


#define  QERR_HLIB_NULL_BINFO   (QLIB|STREAMS|0x01)   /* Null bufinfo field */
#define  QERR_HLIB_NOT_READDATA (QLIB|STREAMS|0x02)   /* Bad msg passed to
                                                         qBlockInfoGet */
#define  QERR_HLIB_NOTCLOSEACK    (QLIB|STREAMS|0x03)   /* Not a close message */
#define  QERR_HLIB_NOTOPENACK     (QLIB|STREAMS|0x04)   /* Not a open message */
#define  QERR_HLIB_NOTCANTAKE     (QLIB|STREAMS|0x05)   /* Not a cantake message */
#define  QERR_HLIB_NOTRECEIVE     (QLIB|STREAMS|0x06)   /* Not receive data */
#define  QERR_HLIB_BADOPENMODE    (QLIB|STREAMS|0x07)   /* Stream in
                                                           incorrect mode for
                                                           function */
#define  QERR_HLIB_BUFFERTOOSMALL (QLIB|STREAMS|0x08)   /* BLOCK size too small */
#define  QERR_HLIB_STREAMBLKSIZE (QLIB|STREAMS|0x09)   /* Illegal block size */
#define  QERR_HLIB_CANTAKERCVD  (QLIB|STREAMS|0x0A)   /* Rcvd cantake at bad time */
#define  QERR_HLIB_STREAMBROKEN (QLIB|STREAMS|0x0B)   /* Broken stream */
#define  QERR_HLIB_STREAMTABLE  (QLIB|STREAMS|0x0C)   /* Stream table array
                                                         too small */
#define  QERR_HLIB_TOOMANYBLKS  (QLIB|STREAMS|0x0D)   /* library cant handle
                                                         this many blocks in
                                                         a WriteMulti */ 
#define  QERR_HLIB_BLKDATASIZE  (QLIB|STREAMS|0x0E)   /* datasize specified
                                                         is illegal -
                                                         probably bigger than
                                                         block size */
#define  QERR_HLIB_BADSTREAMHANDLE (QLIB|STREAMS|0x0F)   /* Bad stream Handle */
#define  QERR_HLIB_DATABLOCKRCVD   (QLIB|STREAMS|0x10)   /* Datablock
                                                            received during
                                                            disconnect */
#define  QERR_HLIB_MIXEDBSTREAMMODE (QLIB|STREAMS|0x11)   /* In both cases, */
#define  QERR_HLIB_MIXEDGSTREAMMODE (QLIB|STREAMS|0x12)   /* the appl code */
							/* is mixing B and */
							/* GStreams calls. */
							/* For example, */
							/* using GStreams */
							/* calls on a B */
							/* Stream. */
#define  QERR_HLIB_INVALIDOSHANDLE (QLIB|STREAMS|0x13)   /* IsNotABStream */
							/* and IsNotAGStream */

//WW support
#define QERR_HLIB_WW_TIMEOUT_EXPIRED (QLIB|STREAMS|0x14) /* ioctl for MercWWModeOperational */
#define QERR_HLIB_KERSTRM_EMPTY (QLIB|STREAMS|0x15) /* ioctl for Stream Empty */

#define  QERR_HLIB_BADPARM   (QLIB|PARM|0x01)   /* Invalid parameter */
#define  QERR_HLIB_READONLY  (QLIB|PARM|0x02)   /* Parameter is read only */

#define  QERR_HLIB_CTLOVERFLOW  (QLIB|TRANS|0x01)   /* Ctrl buffer overflow */
#define  QERR_HLIB_DATAOVERFLOW (QLIB|TRANS|0x02)   /* Data buffer overflow */
#define  QERR_HLIB_BADBLOCKSIZE (QLIB|TRANS|0x03)   /* Library block size wrong */
#define  QERR_HLIB_DRVREPLY     (QLIB|TRANS|0x04)   /* Unexpected driver msg */ 
#define  QERR_HLIB_BADCFGID     (QLIB|TRANS|0x05)   /* illegal config id     */
#define  QERR_HLIB_BADBRDNUMBER (QLIB|TRANS|0x06)   /* brd number out of 
                                                       range */
#define  QERR_HLIB_DRVPARM (QLIB|TRANS|0x07)   /* Error retrieving driver
                                                  parm */

#define  QERR_HLIB_ASYNC_UNSUPPORTED (QLIB|TRANS|0x08)
                                                    /* aysnc mode unsupported */
#define  QERR_HLIB_EXITNOTIFYBIND (QLIB|TRANS|0x09) /* Bad driver ACK     */


#define  QERR_HLIB_DNLDMASK    (QLIB|DNLD|0x01)  /* illegal mask for module load */

#endif /* __QHLIBERR_H__ */






