/******************************************************************************
*     Copyright (c) 2001 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*  
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/

/****************************************************************************
 * FILE:         qmmdlpack.h
 * AUTHOR:       feghhij
 * ORG:          Intel Corporation
 * ORIG-DATE:    21-May-01 at 17:48:31
 * LAST-MOD:    
 * PURPOSE:
 *
 * HISTORY:
 * Date        Who   Description
 * 21-May-01   JF    Initial Creation.
 ***************************************************************************/

/***************************************************************************/
/***************************** IMPORTANT NOTE ******************************/
/***************************************************************************/
/*                                                                         */
/* This file belongs to the kernel group and must not be modified by any   */
/* other group.                                                            */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/***************************************************************************/
/********************************* NOTE ************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This file is part of the system release. Please try not to add kernel   */
/* specific stuff to this file.                                            */
/***************************************************************************/

#ifndef __QMMDLPACK_H__
#define __QMMDLPACK_H__

#ifdef __cplusplus
extern "C" {
#endif


/* 
 * Processor Independent datatypes
 */
enum QDatatype{
QT_INT8, 
QT_INT16,      
QT_INT24,         
QT_INT32,         
QT_UINT8,      
QT_UINT16,        
QT_UINT24,   
QT_UINT32,    
QT_FRAC16,           
QT_FRAC24,        
QT_CHAR,       
QT_CHAR_PACKED,  
QT_MEMREF,           
QT_BUFREF,           
QT_STREAMREF,  
QT_ATTR,      
QT_COMPDESC,     
QT_PARM,      
QT_NULL=-1        
};

#define QT_INT8_SIZE          1
#define QT_INT16_SIZE         2
#define QT_INT24_SIZE         3 
#define QT_INT32_SIZE         4
#define QT_UINT8_SIZE         1
#define QT_UINT16_SIZE        2 
#define QT_UINT24_SIZE        3 
#define QT_UINT32_SIZE        4
#define QT_FRAC16_SIZE        2 
#define QT_FRAC24_SIZE        3
#define QT_CHAR_SIZE          1
#define QT_CHAR_PACKED_SIZE   1
#define QT_MEMREF_SIZE        4
#define QT_BUFREF_SIZE        4
#define QT_STREAMREF_SIZE     11
#define QT_ATTR_SIZE          8
#define QT_COMPDESC_SIZE      6
#define QT_PARM_SIZE          4


#define QFIELDDEF_OFFSET         0      
#define QFIELDDEF_COUNT          11
#define QFIELDDEF_DATATYPE       19
#define QFIELDDEF_OFFSETMASK     0x0007ff  /* 11bits: large offset */
#define QFIELDDEF_COUNTMASK      0x07f800  /* 8 bits: 256 bytes */
#define QFIELDDEF_DATATYPEMASK   0xf80000  /* 5 bits: 32 types  */

#define QFieldDefSet(fieldDef, offset, count, type) \
{ \
   fieldDef = ((offset) << QFIELDDEF_OFFSET) | \
              (((count)-1) << QFIELDDEF_COUNT) | \
              ((type) << QFIELDDEF_DATATYPE); \
}

#define QFieldDef_GetOffset(fieldDef,value) \
(value = ((fieldDef & QFIELDDEF_OFFSETMASK) >> QFIELDDEF_OFFSET))
#define QFieldDef_GetCount(fieldDef,count) \
(count = ((fieldDef & QFIELDDEF_COUNTMASK) >> QFIELDDEF_COUNT) + 1)
#define QFieldDef_GetDatatype(fieldDef,value) \
(value = ((fieldDef & QFIELDDEF_DATATYPEMASK) >> QFIELDDEF_DATATYPE))
#define QFieldDef_PutOffset(fieldDef,value) \
(fieldDef |= ((value  << QFIELDDEF_OFFSET)& QFIELDDEF_OFFSETMASK))
#define QFieldDef_PutCount(fieldDef,count) \
(fieldDef |= (((count - 1)  << QFIELDDEF_COUNT)& QFIELDDEF_COUNTMASK))
#define QFieldDef_PutDatatype(fieldDef,value) \
(fieldDef |= ((value  << QFIELDDEF_DATATYPE)& QFIELDDEF_DATATYPEMASK))

#ifdef __cplusplus
}
#endif

#endif /* #ifndef __QMMDLPACK_H__ */
