/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qmodels.h
 * AUTHOR:       Gerry Lachac
 * ORG:          Intel Corporation
 * ORIG-DATE:    29-Sep-97 at 15:38:13
 * LAST-MOD:     13-Oct-97 at 16:50:39 by Gerry Lachac
 * PURPOSE:
 *    This module contains all the defines to specify which model DM3 card.
 *    These are the OR'ed values of the hp1 and hp0 fields in the DM3 config
 *    ROM.  Rever to the DM3 Product ID Functional SRS (SYS-FR-056)
 *
 * HISTORY:
 * Date                 Who      Description
 * 29-Sep-97            GL       Initial creation
 ***************************************************************************/

#ifndef _qmodel_h_
#define _qmodel_h_

/* You can get these numbers by doing the following OR */
/* (board_id_pri_1)<< 8) | (board_id_pri_0) */

#define  GET_MODEL_FROM_ROM(pRom) ((((pRom)->board_id_pri_1)<< 8) | \
                                   ((pRom)->board_id_pri_0))

#define  MODEL_UNIVERSAL   0x0000   /* V/MDP  Board */
#define  MODEL_QVST1       0x0100   /* QVS-T1 Board */
#define  MODEL_QVSE1       0x0200   /* QVS-E1 Board */
#define  MODEL_FAX         0x0300   /* FAX 24/30 Board */

#define  MODEL_VOIPT1      0x0400   /* DM/IPLINK-T1 Board */
#define  MODEL_VOIPE1      0x0500   /* DM/IPLINK-E1 Board */
#define  MODEL_WALT1       0x0600   /* DM/IPLINK-T1_NIC Board */
#define  MODEL_WALE1       0x0700   /* DM/IPLINK-E1_NIC Board */

#endif




