/****************************************************************************
 *		Copyright (c) 1994 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

#ifndef __QMSG_H__
#define __QMSG_H__

#if 1
#include "qhosttypes.h"
#endif
#include "qtypes.h"
#include "qcomplib.h"
#if 0
#include "qhosttypes.h"
#endif
#include "qmsghi.h"
#include "qmmdlpack.h"

/* 
 * These type definitions are for the local resource message format
 */

typedef UInt8		QByteOrder;
typedef UInt8 		QBufferType;
typedef UInt8 		QMsgPriority;
typedef UInt8 		QMsgVersion;
typedef UInt24    QTrans;
typedef UInt24    QMsgSize;


/* Message encoding  */
#define  QMSGENCODING_BIG        0x00
#define  QMSGENCODING_LITTLE     0x80
#define  QMSGENCODING_MASK       0X80

/* Message Priority */
#define  QMSG_NORMAL          0x00
#define  QMSG_URGENT          0x08
#define  QMSGPRI_MASK         0x08

/* Message Version */
#define  QMSGVERSION             0x00
#define  QMSGVERSION_MASK        0x07


/* Message class */
#define	QMSGCLASS_DRIVER        0xC00000 /* 3 */


/* Message type  */
#define  QMSGTYPE_SYS            0       /* System Messages seen by the API */
#define  QMSGTYPE_STREAMS        1
#define  QMSGTYPE_POOLS          2
#define  QMSGTYPE_RSRCMGMT       3
#define  QMSGTYPE_TSMGMT         4
#define  QMSGTYPE_COMPMGMT       5
#define  QMSGTYPE_MMA            6
#define  QMSGTYPE_SRAM				7
#define  QMSGTYPE_MMAREQ         8
#define  QMSGTYPE_STRMMGR        9       /* Stream manager messages */



typedef UInt24 QMsgtype;

typedef QMsg *    QMsgRef;


/*
 * Defines to access QMsg header
 */

#define QMSG_SET_ENDIAN(pMsg,x)   ((pMsg)->flags |= (x))
#define QMSG_SET_BUFTYPE(pMsg,x)  ((pMsg)->flags |= (x))
#define QMSG_SET_PRIORITY(pMsg,x) ((pMsg)->flags |= (x))
#define QMSG_SET_VERSION(pMsg,x)  ((pMsg)->flags |= (x))
#define QMSG_SET_FLAGS(pMsg,x)    ((pMsg)->flags = (x))
#define QMSG_SET_TRANS(pMsg,x)    ((pMsg)->transaction = (x))
#define QMSG_SET_MSGTYPE(pMsg,x)  ((pMsg)->type = (UInt32)(x))
#define QMSG_SET_SRCADDR(pMsg,x)  ((pMsg)->srcNode = ((x))->node);\
                              ((pMsg)->srcBoard =((x))->board);\
                              ((pMsg)->srcProcessor = ((x))->processor);\
                              ((pMsg)->srcComponent = ((x))->component);\
                              ((pMsg)->srcInstance = ((x))->instance)
#define QMSG_SET_DESTADDR(pMsg,pDesc) ((pMsg)->destNode = (pDesc)->node);\
                              ((pMsg)->destBoard = (pDesc)->board);\
                              ((pMsg)->destProcessor = (pDesc)->processor);\
                              ((pMsg)->destComponent = (pDesc)->component);\
                              ((pMsg)->destInstance = (pDesc)->instance)

#define QMSG_SET_MSGSIZE(pMsg,x)  ((pMsg)->msgsize = (UInt32)(x))

#define QMSG_GET_ENDIAN(pMsg,x)   (*(x) = (QByteOrder)((pMsg)->flags & QMSGENCODING_MASK ))
#define QMSG_GET_BUFTYPE(pMsg,x)  (*(x) = (QBufferType)((pMsg)->flags & QMSGBUF_MASK ))
#define QMSG_GET_PRIORITY(pMsg,x) (*(x) = (QMsgPriority)((pMsg)->flags & QMSGPRI_MASK ))
#define QMSG_GET_VERSION(pMsg,x)  (*(x) = (QMsgVersion)((pMsg)->flags & QMSGVERSION_MASK ))
#define QMSG_GET_TRANS(pMsg,x)    (*(x) =(QTrans)((pMsg)->transaction))
#define QMSG_GET_MSGTYPE(pMsg,x)  (*(x) =(pMsg->type))
#define QMSG_GET_SRCADDR(pMsg,pDesc)  ((pDesc)->node = (pMsg)->srcNode);\
                                      ((pDesc)->board = (pMsg)->srcBoard);\
                                      ((pDesc)->processor = (pMsg)->srcProcessor);\
                                      ((pDesc)->component = (pMsg)->srcComponent);\
                                      ((pDesc)->instance = (pMsg)->srcInstance)
#define QMSG_GET_DESTADDR(pMsg,pDesc) ((pDesc)->node = (pMsg)->destNode);\
                                      ((pDesc)->board = (pMsg)->destBoard);\
                                      ((pDesc)->processor = (pMsg)->destProcessor);\
                                      ((pDesc)->component = (pMsg)->destComponent);\
                                      ((pDesc)->instance = (pMsg)->destInstance)
#define QMSG_GET_MSGSIZE(pMsg,x)  (*(x) = (Int32)((pMsg)->msgsize))


/* 
 * Processor Independent datatypes
 */

typedef UInt24 QMsgField;

typedef UInt16	QInstance;




/* Function Prototypes for the Message functions */

#ifdef __cplusplus
extern "C"{
#endif
QStatus	qMsgAllocate(UInt32,QMsgRef *);
QStatus	qMsgReallocate(UInt32,QMsgRef *);
QStatus	qMsgFree(QMsgRef Msg);
QStatus	qMsgRead(QHandle , QMsgRef exchange, QMsgRef *Msg);
QStatus	qMsgWrite(QHandle, QMsgRef Msg, QMsgRef * pNewMsgRef);
QStatus	qMsgFieldGet(QMsgRef Message,QMsgField fieldDef, void * pTarget);
QStatus	qMsgFieldPut(QMsgRef Message,QMsgField fieldDef, void * pSource);
QStatus	qMsgVarFieldGet(QMsgRef,unsigned int,unsigned int * ,QMsgField , 
								 void * , ...);
QStatus	qMsgVarFieldPut(QMsgRef, unsigned int, unsigned int *,QMsgField, 
								 void * , ...);
int qEpoll( struct pollfd pfd[], int nfd, int timeOut );

#ifdef __cplusplus
}
#endif

#endif
