/******************************************************************************
*     Copyright (c) 2001 Intel Corporation. All Rights Reserved.
*
*     All names, products, and services mentioned herein are the trademarks
*     or registered trademarks of their respective organizations and are the
*     sole property of their respective owners.
*  
*
*     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation.
*     The copyright notice above does not evidence any actual or
*     intended publication of such source code.
******************************************************************************/

/****************************************************************************
 * FILE:         qmsghi.h
 * AUTHOR:       feghhij
 * ORG:          Intel Corporation
 * ORIG-DATE:    21-May-01 at 17:48:31
 * LAST-MOD:    
 * PURPOSE:
 *
 * HISTORY:
 * Date        Who   Description
 * 21-May-01   JF    Initial Creation.
 ***************************************************************************/

/***************************************************************************/
/***************************** IMPORTANT NOTE ******************************/
/***************************************************************************/
/*                                                                         */
/* This file belongs to the kernel group and must not be modified by any   */
/* other group.                                                            */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/***************************************************************************/
/********************************* NOTE ************************************/
/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/* This file is part of the system release. Please try not to add kernel   */
/* specific stuff to this file.                                            */
/***************************************************************************/

#ifndef __QMSGHI_H__
#define __QMSGHI_H__

#include "qoscommon.h"

#ifndef QCPU
#error QCPU is not defined
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef QINST_WIDTH
#error QINST_WIDTH not defined
#if (QCPU == QXSCALE) || (QCPU >= QHOST)
#define QINST_WIDTH 16
#else
#define QINST_WIDTH 8
#endif
#endif


/* Masks for the flags field in 32 bit message format */
#define  SRAM32_ENCODING   0x80
#define  SRAM32_RESERVED   0x70
#define  SRAM32_PRIORITY   0x08
#define  SRAM32_VERSION    0x07

#define  SRAM32_LITTLE     0x80
#define  SRAM32_BIG        0x0

/* Message class (most significant bits of type field in message structure) */
#define  QMSGCLASS_MASK          0xC00000 /* upper 2bits in a 24 bit word */

#define  QMSGCLASS_SYSTEM_INTS   0xC00000 /* 3 */
#define  QMSGCLASS_SYSTEM        0x800000 /* 2 */
#define  QMSGCLASS_RESOURCE_INTS 0x400000 /* 1 */
#define  QMSGCLASS_RESOURCE      0x000000 /* 0 */
#define  QMSGTYPE_DRIVER         0xC00000 /* for messaging with host driver */

/* Message type */
#define  QMSGTYPE_MASK           0x3f0000
#define  QMSGMESSAGE_MASK        0x00ffff /* Last 16 bits */
/********************************** 8 BIT ONLY BEGIN**************************/
#if (QINST_WIDTH == 8)
#if (QCPU >= QHOST)
#if defined (QBIGENDIAN) && defined (VME)
 typedef  struct {
  UInt32           transaction:24;
  UInt32           flags:8;
  UInt32           type;
  UInt32           srcProcessor:8;
  UInt32           srcBoard:8;
  UInt32           srcNode:16;
  UInt32           destProcessor:8;
  UInt32           destBoard:8;
  UInt32           destNode:16;
  UInt32           destComponent:8;
  UInt32           destInstance:8;
  UInt32           srcComponent:8;
  UInt32           srcInstance:8;
  UInt32           msgsize;
#if (QCHAR_BIT == 8)
  UInt8            data[24];
#elif (QCHAR_BIT == 24)
  UInt24           data[8];
#elif (QCHAR_BIT == 32)
  UInt32           data[6];
#else
#endif  /* (QCHAR_BIT == 8) */
} QMsg32Bit;

typedef QMsg32Bit QMsg;

#elif defined (QLITTLEENDIAN)
 typedef  struct {
  UInt32           flags:8;
  UInt32           transaction:24;
  UInt32           type;
  UInt32           srcNode:16;
  UInt32           srcBoard:8;
  UInt32           srcProcessor:8;
  UInt32           destNode:16;
  UInt32           destBoard:8;
  UInt32           destProcessor:8;
  UInt32           srcInstance:8;
  UInt32           srcComponent:8;
  UInt32           destInstance:8;
  UInt32           destComponent:8;
  UInt32           msgsize;
#if (QCHAR_BIT == 8)
  UInt8            data[24];
#elif (QCHAR_BIT == 24)
  UInt24           data[8];
#elif (QCHAR_BIT == 32)
  UInt32           data[6];
#endif /* (QCHAR_BIT == 8) */
} QMsg32Bit;
typedef QMsg32Bit QMsg;

#else
   /* NT side host shared ram message structure */
typedef  struct {
  ULONG           flags:8;
  ULONG           transaction:24;
  ULONG           type;
  ULONG           srcNode:16;
  ULONG           srcBoard:8;
  ULONG           srcProcessor:8;
  ULONG           destNode:16;
  ULONG           destBoard:8;
  ULONG           destProcessor:8;
  ULONG           srcInstance:8;
  ULONG           srcComponent:8;
  ULONG           destInstance:8;
  ULONG           destComponent:8;
  ULONG           msgsize;
} QMsg32Bit;
typedef QMsg32Bit QMsg;
#endif /* defined (QBIGENDIAN) && defined (VME) */

 


#else /* (QCPU < QHOST)  */

/* kernel host shared ram message structure */
typedef struct {
   UInt32   flags_trans;
   UInt32   type;
   UInt32   sourceLoc;
   UInt32   destLoc;
   UInt32   compInstAdr;
   UInt32   size;       /* Could be used for pointer if msg is in 4k buffer */
   UInt8    data[24];   /* 24 bytes becomes more bytes if msg is in 4k buffer */
} QMsg32Bit;

#endif /* (QCPU >= QHOST)  */
#endif /* QINST_WIDTH == 8 */
/********************************** 8 BIT ONLY END****************************/



/**********************************16 BIT ONLY BEGIN**************************/
#if (QINST_WIDTH == 16)
#if (QCPU >= QHOST)
#if defined (QBIGENDIAN) && defined (VME)
 typedef  struct {
  UInt32           transaction:24;
  UInt32           flags:8;
  UInt32           type;
  UInt32           srcProcessor:8;
  UInt32           srcBoard:8;
  UInt32           srcInstance:16;
  UInt32           destProcessor:8;
  UInt32           destBoard:8;
  UInt32           destInstance:16;
  UInt32           destComponent:8;
  UInt32           destNode:8;
  UInt32           srcComponent:8;
  UInt32           srcNode:8;
  UInt32           msgsize;
#if (QCHAR_BIT == 8)
  UInt8            data[24];
#elif (QCHAR_BIT == 24)
  UInt24           data[8];
#elif (QCHAR_BIT == 32)
  UInt32           data[6];
#else
#endif  /* (QCHAR_BIT == 8) */
} QMsg32Bit;
typedef QMsg32Bit QMsg;

#elif defined (QLITTLEENDIAN)
 typedef  struct {
  UInt32           flags:8;
  UInt32           transaction:24;
  UInt32           type;
  UInt32           srcInstance:16;
  UInt32           srcBoard:8;
  UInt32           srcProcessor:8;
  UInt32           destInstance:16;
  UInt32           destBoard:8;
  UInt32           destProcessor:8;
  UInt32           srcNode:8;
  UInt32           srcComponent:8;
  UInt32           destNode:8;
  UInt32           destComponent:8;
  UInt32           msgsize;
#if (QCHAR_BIT == 8)
  UInt8            data[24];
#elif (QCHAR_BIT == 24)
  UInt24           data[8];
#elif (QCHAR_BIT == 32)
  UInt32           data[6];
#endif /* (QCHAR_BIT == 8) */
} QMsg32Bit;
typedef QMsg32Bit QMsg;

#else
   /* NT side host shared ram message structure */
typedef  struct {
  ULONG           flags:8;
  ULONG           transaction:24;
  ULONG           type;
  ULONG           srcInstance:16;
  ULONG           srcBoard:8;
  ULONG           srcProcessor:8;
  ULONG           destInstance:16;
  ULONG           destBoard:8;
  ULONG           destProcessor:8;
  ULONG           srcNode:8;
  ULONG           srcComponent:8;
  ULONG           destNode:8;
  ULONG           destComponent:8;
  ULONG           msgsize;
} QMsg32Bit;
typedef QMsg32Bit QMsg;

#endif /* defined (QBIGENDIAN) && defined (VME) */


#else /* (QCPU < QHOST)  */

/* kernel host shared ram message structure */
typedef struct {
   UInt32   flags_trans;
   UInt32   type;
   UInt32   sourceLoc;
   UInt32   destLoc;
   UInt32   compInstAdr;
   UInt32   size;       /* Could be used for pointer if msg is in 4k buffer */
   UInt8    data[24];   /* 24 bytes becomes more bytes if msg is in 4k buffer */
} QMsg32Bit;


#endif /* (QCPU >= QHOST)  */
#endif /* QINST_WIDTH == 16 */
/********************************** 16 BIT ONLY END***************************/




#ifdef __cplusplus
}
#endif

#endif /* #ifndef __QMSGHI_H__ */
