#ifndef  _R2_H__
#define  _R2_H__
/****************************************************************************
 *		Copyright (c) 1998 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Tyshaun Hawkins
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    25-Oct-98 at 15:01:00
 * LAST-MOD:      2-Mar-99 at 10:36:05 by Tyshaun Hawkins
 * PURPOSE:
 *    This module facilitates the creation of all the siganl ID's for the 
 *    R2 MF digits.
 *    
 * HISTORY:
 * Date        Who   Description
 * 10/25/98    TLH   Origination date
 ***************************************************************************/

#include <sdsignal.h>
/*
 * The R2 MF Signal's
 */
/*
 * This is the ID portion of all the R2 MF sets
 */
enum {
   ID_R2MFF1=1,
   ID_R2MFF2,
   ID_R2MFF3,
   ID_R2MFF4,
   ID_R2MFF5,
   ID_R2MFF6,
   ID_R2MFF7,
   ID_R2MFF8,
   ID_R2MFF9,
   ID_R2MFFA,
   ID_R2MFFB,
   ID_R2MFFC,
   ID_R2MFFD,
   ID_R2MFFE,
   ID_R2MFFF
};

enum {
   ID_R2MFB1 = 1,
   ID_R2MFB2,
   ID_R2MFB3,
   ID_R2MFB4,
   ID_R2MFB5,
   ID_R2MFB6,
   ID_R2MFB7,
   ID_R2MFB8,
   ID_R2MFB9,
   ID_R2MFBA,
   ID_R2MFBB,
   ID_R2MFBC,
   ID_R2MFBD,
   ID_R2MFBE,
   ID_R2MFBF
};

/*
 * This macro allows for creation of the MF signal ID's for all countries
 * using the ISO two letter country code.
 * CreateMfSet(US, 'U', 'S') will create ...
 * US_R2MFF_SET, US_R2MFF1, US_R2MFF2, etc ...
 */
#define  CreateR2MffSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_R2MFF_SET =CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2), \
   PREFIX##_R2MFF1 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF1, \
   PREFIX##_R2MFF2 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF2, \
   PREFIX##_R2MFF3 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF3, \
   PREFIX##_R2MFF4 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF4, \
   PREFIX##_R2MFF5 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF5, \
   PREFIX##_R2MFF6 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF6, \
   PREFIX##_R2MFF7 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF7, \
   PREFIX##_R2MFF8 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF8, \
   PREFIX##_R2MFF9 = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFF9, \
   PREFIX##_R2MFFA = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFFA, \
   PREFIX##_R2MFFB = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFFB, \
   PREFIX##_R2MFFC = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFFC, \
   PREFIX##_R2MFFD = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFFD, \
   PREFIX##_R2MFFE = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFFE, \
   PREFIX##_R2MFFF = CreateCountrySet(SD_R2MFF_START,LETTER1, LETTER2) \
                     + ID_R2MFFF \
};

/*
 * This macro allows for creation of the MF signal ID's for all countries
 * using the ISO two letter country code.
 * CreateMfbSet(US, 'U', 'S') will create ...
 * US_R2MFB_SET, US_R2MFB1, US_R2MFB2, etc ...
 */
#define  CreateR2MfbSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_R2MFB_SET =CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2), \
   PREFIX##_R2MFB1 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB1, \
   PREFIX##_R2MFB2 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB2, \
   PREFIX##_R2MFB3 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB3, \
   PREFIX##_R2MFB4 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB4, \
   PREFIX##_R2MFB5 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB5, \
   PREFIX##_R2MFB6 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB6, \
   PREFIX##_R2MFB7 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB7, \
   PREFIX##_R2MFB8 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB8, \
   PREFIX##_R2MFB9 = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFB9, \
   PREFIX##_R2MFBA = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFBA, \
   PREFIX##_R2MFBB = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFBB, \
   PREFIX##_R2MFBC = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFBC, \
   PREFIX##_R2MFBD = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFBD, \
   PREFIX##_R2MFBE = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFBE, \
   PREFIX##_R2MFBF = CreateCountrySet(SD_R2MFB_START,LETTER1, LETTER2) \
                     + ID_R2MFBF \
};

CreateR2MffSet(Dm3_XX,'X','X')
CreateR2MfbSet(Dm3_XX,'X','X')

/* forward tone definitions */
#define Dm3_R2MFF_SET Dm3_XX_R2MFF_SET  /* Used for set operations */
#define Dm3_R2MFF1  Dm3_XX_R2MFF1
#define Dm3_R2MFF2  Dm3_XX_R2MFF2
#define Dm3_R2MFF3  Dm3_XX_R2MFF3
#define Dm3_R2MFF4  Dm3_XX_R2MFF4
#define Dm3_R2MFF5  Dm3_XX_R2MFF5
#define Dm3_R2MFF6  Dm3_XX_R2MFF6
#define Dm3_R2MFF7  Dm3_XX_R2MFF7
#define Dm3_R2MFF8  Dm3_XX_R2MFF8
#define Dm3_R2MFF9  Dm3_XX_R2MFF9
#define Dm3_R2MFFA  Dm3_XX_R2MFFA
#define Dm3_R2MFFB  Dm3_XX_R2MFFB
#define Dm3_R2MFFC  Dm3_XX_R2MFFC
#define Dm3_R2MFFD  Dm3_XX_R2MFFD
#define Dm3_R2MFFE  Dm3_XX_R2MFFE
#define Dm3_R2MFFF  Dm3_XX_R2MFFF

/* backward tone definitions */
#define Dm3_R2MFB_SET Dm3_XX_R2MFB_SET  /* Used for set operations */
#define Dm3_R2MFB1  Dm3_XX_R2MFB1
#define Dm3_R2MFB2  Dm3_XX_R2MFB2
#define Dm3_R2MFB3  Dm3_XX_R2MFB3
#define Dm3_R2MFB4  Dm3_XX_R2MFB4
#define Dm3_R2MFB5  Dm3_XX_R2MFB5
#define Dm3_R2MFB6  Dm3_XX_R2MFB6
#define Dm3_R2MFB7  Dm3_XX_R2MFB7
#define Dm3_R2MFB8  Dm3_XX_R2MFB8
#define Dm3_R2MFB9  Dm3_XX_R2MFB9
#define Dm3_R2MFBA  Dm3_XX_R2MFBA
#define Dm3_R2MFBB  Dm3_XX_R2MFBB
#define Dm3_R2MFBC  Dm3_XX_R2MFBC
#define Dm3_R2MFBD  Dm3_XX_R2MFBD
#define Dm3_R2MFBE  Dm3_XX_R2MFBE
#define Dm3_R2MFBF  Dm3_XX_R2MFBF

#endif
