
/*
 * This file was automatically generated from recdefs.txt.
 * Author: "Luke Kiernan"
 * Version: "Revision A0.21"
 * Date: Wed Nov 27 12:08:00 2002
 * The output was written to recdefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_recdefs_h_)
#define _recdefs_h_ 1
/* This file describes the list of Mercury messages, parameters and equates 
 * supported by the Mercury Recorder Component and its Instances. */
/*
 * Recorder Component Definition
 */
/* The Recorder uses messages from the Standard Kernel Message Set, the 
 * Standard Component Message Set and the Standard Audio Encoder Component 
 * Message Set. */
/*
 * 	Mercury Kernel Standard Message Set defined in mercdefs.doc
 * 	*/
/*
 * 	Standard Component Message Set defined in stddefs.doc.
 * 	*/
/*
 * 	Audio Encoder Component Message Set defined in (TBD)
 * 	*/
/*
 * 	Encoder Component Type used when trying to allocate an Encoder Instance (TBD)
 * 	*/
/* 
 * Recorder Message Definitions
 */

#define Recorder_MsgStart_StreamID	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgStart_StreamID_t;

#define Recorder_MsgStart_Encoding	0x380004	/* 3670020 */
typedef	UInt32	Recorder_MsgStart_Encoding_t;

#define Recorder_MsgStart_StartMode_NORMAL	0	/* 0 */

#define Recorder_MsgStart_StartMode_PAUSED	0x1	/* 1 */

#define Recorder_MsgStart_StartMode_TIMED	0x2	/* 2 */

#define Recorder_MsgStart_StartMode_BEEPINIT	0x4	/* 4 */

#define Recorder_MsgStart_StartMode_SYNCH	0x8	/* 8 */

#define Recorder_MsgStart_StartMode_TRANSACTION	0x10	/* 16 */

#define Recorder_MsgStart_StartMode	0x380008	/* 3670024 */
typedef	UInt32	Recorder_MsgStart_StartMode_t;

/*
 * Recorder_MsgStart (value = 0x200) is an input message
 * for component Recorder.
 */


typedef struct {
	UInt32	StreamID;
	UInt32	Encoding;
	UInt32	StartMode;
} Recorder_MsgStart_t;

#define Recorder_MsgStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Recorder_MsgStart_StreamID), &((structAddr)->StreamID),	\
			(Recorder_MsgStart_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgStart_StartMode), &((structAddr)->StartMode))


#define Recorder_MsgStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Recorder_MsgStart_StreamID), &((structAddr)->StreamID),	\
			(Recorder_MsgStart_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgStart_StartMode), &((structAddr)->StartMode))


#define Recorder_MsgStart_Size		12

#define Recorder_MsgStart	0x200	/* 512 */
/* The MsgStart message is sent as a command to initiate recording of data 
 * from the network interface to a specified stream using a specified encoding 
 * algorithm. The EvtRecording event message may be returned in addition to the 
 * MsgStartCmplt message if this event was enabled. StreamID - stream 
 * identifier for record. Encoding - encoding to use. Values: Defined in the 
 * Coders Definition File "coders.h". StartMode - starting mode. This is a bit 
 * map in that all of the modes may be OR'd together and set simultaneously.. */
/* The MsgStartCmplt message is sent as a response to the MsgStart command 
 * when record has started. */

/*
 * Recorder_MsgStartCmplt (value = 0x201) is an output message
 * for component Recorder.
 */

#define Recorder_MsgStartCmplt_Size		0

#define Recorder_MsgStartCmplt	0x201	/* 513 */
/* The MsgStop message is sent to stop an ongoing record. The EvtStopped event 
 * message may be returned in addition to the MsgStopped message if this event 
 * was enabled. */

/*
 * Recorder_MsgStop (value = 0x202) is an input message
 * for component Recorder.
 */

#define Recorder_MsgStop_Size		0

#define Recorder_MsgStop	0x202	/* 514 */

#define Recorder_MsgStopped_Reason_UserStop	0x1	/* 1 */

#define Recorder_MsgStopped_Reason_Rtc	0x2	/* 2 */

#define Recorder_MsgStopped_Reason_Timeout	0x3	/* 3 */

#define Recorder_MsgStopped_Reason_TranscodingStop	0x4	/* 4 */

#define Recorder_MsgStopped_Reason_MaxBytes	0x5	/* 5 */

#define Recorder_MsgStopped_Reason_BeepToneError	0x261	/* 609 */

#define Recorder_MsgStopped_Reason_InvalidEncoder	0x271	/* 625 */

#define Recorder_MsgStopped_Reason_Deallocated	0x272	/* 626 */

#define Recorder_MsgStopped_Reason_EncoderExited	0x273	/* 627 */

#define Recorder_MsgStopped_Reason_StreamError	0x274	/* 628 */

#define Recorder_MsgStopped_Reason	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgStopped_Reason_t;

#define Recorder_MsgStopped_RtcLabel	0x380004	/* 3670020 */
typedef	UInt32	Recorder_MsgStopped_RtcLabel_t;

#define Recorder_MsgStopped_TimeRecorded	0x380008	/* 3670024 */
typedef	UInt32	Recorder_MsgStopped_TimeRecorded_t;

#define Recorder_MsgStopped_BytesRecorded	0x38000c	/* 3670028 */
typedef	UInt32	Recorder_MsgStopped_BytesRecorded_t;

/*
 * Recorder_MsgStopped (value = 0x203) is an output message
 * for component Recorder.
 */


typedef struct {
	UInt32	Reason;
	UInt32	RtcLabel;
	UInt32	TimeRecorded;
	UInt32	BytesRecorded;
} Recorder_MsgStopped_t;

#define Recorder_MsgStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Recorder_MsgStopped_Reason), &((structAddr)->Reason),	\
			(Recorder_MsgStopped_RtcLabel), &((structAddr)->RtcLabel),	\
			(Recorder_MsgStopped_TimeRecorded), &((structAddr)->TimeRecorded),	\
			(Recorder_MsgStopped_BytesRecorded), &((structAddr)->BytesRecorded))


#define Recorder_MsgStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Recorder_MsgStopped_Reason), &((structAddr)->Reason),	\
			(Recorder_MsgStopped_RtcLabel), &((structAddr)->RtcLabel),	\
			(Recorder_MsgStopped_TimeRecorded), &((structAddr)->TimeRecorded),	\
			(Recorder_MsgStopped_BytesRecorded), &((structAddr)->BytesRecorded))


#define Recorder_MsgStopped_Size		16

#define Recorder_MsgStopped	0x203	/* 515 */
/* The MsgStopped message is sent as a response to the MsgStop command when 
 * record has stopped. It is also sent asynchronously if record was stopped due 
 * to Run Time Control. The EvtStopped event message may be returned in 
 * addition to the MsgStopped message if this event was enabled. Reason - 
 * reason why record stopped. RtcLabel - if Reason is Rtc then this is the 
 * EventLabel of the event which caused the record to stop. TimeRecorded - 
 * length of time recorded before stopping, in milliseconds. BytesRecorded - 
 * number of bytes recorded before stopping. */
/* The MsgPause message is sent to pause an ongoing record. The EvtPaused 
 * event message may returned in addition to the MsgPauseCmplt message if this 
 * event was enabled. */

/*
 * Recorder_MsgPause (value = 0x204) is an input message
 * for component Recorder.
 */

#define Recorder_MsgPause_Size		0

#define Recorder_MsgPause	0x204	/* 516 */
/* The MsgPauseCmplt message is sent as a response to the MsgPause command 
 * when record has paused. */

/*
 * Recorder_MsgPauseCmplt (value = 0x205) is an output message
 * for component Recorder.
 */

#define Recorder_MsgPauseCmplt_Size		0

#define Recorder_MsgPauseCmplt	0x205	/* 517 */
/* The MsgResume message is sent to resume a paused record. The EvtRecording 
 * event message may be returned in addition to the MsgResumeCmplt message if 
 * this event was enabled. */

/*
 * Recorder_MsgResume (value = 0x206) is an input message
 * for component Recorder.
 */

#define Recorder_MsgResume_Size		0

#define Recorder_MsgResume	0x206	/* 518 */
/* The MsgResumeCmplt message is sent as a response to the MsgResume command 
 * when record has resumed. */

/*
 * Recorder_MsgResumeCmplt (value = 0x207) is an output message
 * for component Recorder.
 */

#define Recorder_MsgResumeCmplt_Size		0

#define Recorder_MsgResumeCmplt	0x207	/* 519 */

#define Recorder_MsgAllocateEncoder_CoderBundleAttribute	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgAllocateEncoder_CoderBundleAttribute_t;

#define Recorder_MsgAllocateEncoder_VendorId	0x380004	/* 3670020 */
typedef	UInt32	Recorder_MsgAllocateEncoder_VendorId_t;

/*
 * Recorder_MsgAllocateEncoder (value = 0x208) is an output message
 * for component Recorder.
 */


typedef struct {
	UInt32	CoderBundleAttribute;
	UInt32	VendorId;
} Recorder_MsgAllocateEncoder_t;

#define Recorder_MsgAllocateEncoder_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Recorder_MsgAllocateEncoder_CoderBundleAttribute), &((structAddr)->CoderBundleAttribute),	\
			(Recorder_MsgAllocateEncoder_VendorId), &((structAddr)->VendorId))


#define Recorder_MsgAllocateEncoder_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Recorder_MsgAllocateEncoder_CoderBundleAttribute), &((structAddr)->CoderBundleAttribute),	\
			(Recorder_MsgAllocateEncoder_VendorId), &((structAddr)->VendorId))


#define Recorder_MsgAllocateEncoder_Size		8

#define Recorder_MsgAllocateEncoder	0x208	/* 520 */
/* The MsgAllocateEncoder message is used allocate a new Encoder to the 
 * Recorder. It may be used as a component message, before the Std_MsgInit 
 * (before initialization time) or as an instance message after initialization 
 * time. When used as a component message, the allocation of the Encoder will 
 * be propagated, at initialization time, to each Recorder instance. The use of 
 * the MsgAllocateEncoder message as a component message indicates that only 
 * the encoders specified through the use of MsgAllocateEncoder messages be 
 * allocated. If this message is not used, the Dialogic Standard Audio Encoder 
 * will be allocated for each Recorder instance, at initialization time. 
 * CoderBundleAttribute - The Encoder Bundle attribute value (used with the 
 * Std_CoderBundle key). VendorId - the Vendor ID attribute */
/* The MsgAllocateEncoderCmplt message is sent as a response to the 
 * MsgAllocateEncoder command when the message has been received and processed. */

/*
 * Recorder_MsgAllocateEncoderCmplt (value = 0x209) is an output message
 * for component Recorder.
 */

#define Recorder_MsgAllocateEncoderCmplt_Size		0

#define Recorder_MsgAllocateEncoderCmplt	0x209	/* 521 */

#define Recorder_MsgEncoderQuery_Encoding	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderQuery_Encoding_t;

/*
 * Recorder_MsgEncoderQuery (value = 0x20a) is an input message
 * for component Recorder.
 */


typedef struct {
	UInt32	Encoding;
} Recorder_MsgEncoderQuery_t;

#define Recorder_MsgEncoderQuery_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderQuery_Encoding), &((structAddr)->Encoding))


#define Recorder_MsgEncoderQuery_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderQuery_Encoding), &((structAddr)->Encoding))


#define Recorder_MsgEncoderQuery_Size		4

#define Recorder_MsgEncoderQuery	0x20a	/* 522 */
/* The MsgEncoderQuery message is sent to query the recorder about coders 
 * which the recorder can allocate. The MsgEncoderQueryCmplt message is 
 * returned with the coder's attribute if it is valid. Encoding - encoding type 
 * values, such as G.711 or OKI ADPCM: Defined in Coders Definition File 
 * "coders.h". */

#define Recorder_MsgEncoderQueryCmplt_Encoding	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderQueryCmplt_Encoding_t;

#define Recorder_MsgEncoderQueryCmplt_isValid_false	0	/* 0 */

#define Recorder_MsgEncoderQueryCmplt_isValid_true	0x1	/* 1 */

#define Recorder_MsgEncoderQueryCmplt_isValid	0x380004	/* 3670020 */
typedef	UInt32	Recorder_MsgEncoderQueryCmplt_isValid_t;

#define Recorder_MsgEncoderQueryCmplt_FrameSize	0x380008	/* 3670024 */
typedef	UInt32	Recorder_MsgEncoderQueryCmplt_FrameSize_t;

#define Recorder_MsgEncoderQueryCmplt_maxEncBytesPerBlock	0x38000c	/* 3670028 */
typedef	UInt32	Recorder_MsgEncoderQueryCmplt_maxEncBytesPerBlock_t;

/*
 * Recorder_MsgEncoderQueryCmplt (value = 0x20b) is an output message
 * for component Recorder.
 */


typedef struct {
	UInt32	Encoding;
	UInt32	isValid;
	UInt32	FrameSize;
	UInt32	maxEncBytesPerBlock;
} Recorder_MsgEncoderQueryCmplt_t;

#define Recorder_MsgEncoderQueryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Recorder_MsgEncoderQueryCmplt_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgEncoderQueryCmplt_isValid), &((structAddr)->isValid),	\
			(Recorder_MsgEncoderQueryCmplt_FrameSize), &((structAddr)->FrameSize),	\
			(Recorder_MsgEncoderQueryCmplt_maxEncBytesPerBlock), &((structAddr)->maxEncBytesPerBlock))


#define Recorder_MsgEncoderQueryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Recorder_MsgEncoderQueryCmplt_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgEncoderQueryCmplt_isValid), &((structAddr)->isValid),	\
			(Recorder_MsgEncoderQueryCmplt_FrameSize), &((structAddr)->FrameSize),	\
			(Recorder_MsgEncoderQueryCmplt_maxEncBytesPerBlock), &((structAddr)->maxEncBytesPerBlock))


#define Recorder_MsgEncoderQueryCmplt_Size		16

#define Recorder_MsgEncoderQueryCmplt	0x20b	/* 523 */
/* The MsgEncoderQueryCmplt message is sent in response to the MsgEncoderQuery 
 * command when the message has been received and processed. Encoding This is a 
 * returned from the query message. isValid - This returns if the coding type 
 * specified is supported by this Instance. FrameSize - The frame size in 
 * bytes. For waveform codec, it depends on which task period of this codec is 
 * running on. E.g. For Mulaw64, it is 96 bytes if running on the 12ms task 
 * period.. MaxEncBytesPerBlock - The maximum number of bytes in a block that 
 * the host can expect from the resource for Record/Encode. */

#define Recorder_MsgStartTransaction_StreamID	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgStartTransaction_StreamID_t;

#define Recorder_MsgStartTransaction_Encoding	0x380004	/* 3670020 */
typedef	UInt32	Recorder_MsgStartTransaction_Encoding_t;

#define Recorder_MsgStartTransaction_StartMode_NORMAL	0	/* 0 */

#define Recorder_MsgStartTransaction_StartMode_PAUSED	0x1	/* 1 */

#define Recorder_MsgStartTransaction_StartMode_TIMED	0x2	/* 2 */

#define Recorder_MsgStartTransaction_StartMode_BEEPINIT	0x4	/* 4 */

#define Recorder_MsgStartTransaction_StartMode	0x380008	/* 3670024 */
typedef	UInt32	Recorder_MsgStartTransaction_StartMode_t;

/*
 * Recorder_MsgStartTransaction (value = 0x20c) is an input message
 * for component Recorder.
 */


typedef struct {
	UInt32	StreamID;
	UInt32	Encoding;
	UInt32	StartMode;
} Recorder_MsgStartTransaction_t;

#define Recorder_MsgStartTransaction_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Recorder_MsgStartTransaction_StreamID), &((structAddr)->StreamID),	\
			(Recorder_MsgStartTransaction_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgStartTransaction_StartMode), &((structAddr)->StartMode))


#define Recorder_MsgStartTransaction_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Recorder_MsgStartTransaction_StreamID), &((structAddr)->StreamID),	\
			(Recorder_MsgStartTransaction_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgStartTransaction_StartMode), &((structAddr)->StartMode))


#define Recorder_MsgStartTransaction_Size		12

#define Recorder_MsgStartTransaction	0x20c	/* 524 */

/*
 * Recorder_MsgStartTransactionCmplt (value = 0x20d) is an output message
 * for component Recorder.
 */

#define Recorder_MsgStartTransactionCmplt_Size		0

#define Recorder_MsgStartTransactionCmplt	0x20d	/* 525 */

#define Recorder_MsgEncoderXQuery_Count	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQuery_Count_t;

#define Recorder_MsgEncoderXQuery_varStart	0x4

#define Recorder_MsgEncoderXQuery_CoderList_Encoding	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQuery_CoderList_Encoding_t;


typedef struct {
	UInt32	Encoding;
} Recorder_MsgEncoderXQuery_CoderList_t;

#define Recorder_MsgEncoderXQuery_CoderList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderXQuery_CoderList_Encoding), &((structAddr)->Encoding))


#define Recorder_MsgEncoderXQuery_CoderList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderXQuery_CoderList_Encoding), &((structAddr)->Encoding))


#define Recorder_MsgEncoderXQuery_CoderList_Size		4

#define Recorder_MsgEncoderXQuery_CoderList	0	/* 0 */

/*
 * Recorder_MsgEncoderXQuery (value = 0x20e) is an input message
 * for component Recorder.
 */


typedef struct {
	UInt32	Count;
} Recorder_MsgEncoderXQuery_t;

#define Recorder_MsgEncoderXQuery_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderXQuery_Count), &((structAddr)->Count))


#define Recorder_MsgEncoderXQuery_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderXQuery_Count), &((structAddr)->Count))


#define Recorder_MsgEncoderXQuery_Size		4

#define Recorder_MsgEncoderXQuery	0x20e	/* 526 */
/* The MsgEncoderQuery message is sent to query the recorder about multiple 
 * coders which the recorder can allocate. The MsgEncoderQueryCmplt message is 
 * returned with the coder's attribute if it is valid. Count Number of coders 
 * to be queried Encoding - encoding type values, such as G.711 or OKI ADPCM: 
 * Defined in Coders Definition File "coders.h". */

#define Recorder_MsgEncoderXQueryCmplt_Count	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQueryCmplt_Count_t;

#define Recorder_MsgEncoderXQueryCmplt_varStart	0x4

#define Recorder_MsgEncoderXQueryCmplt_CoderList_Encoding	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQueryCmplt_CoderList_Encoding_t;

#define Recorder_MsgEncoderXQueryCmplt_CoderList_isValid_false	0	/* 0 */

#define Recorder_MsgEncoderXQueryCmplt_CoderList_isValid_true	0x1	/* 1 */

#define Recorder_MsgEncoderXQueryCmplt_CoderList_isValid	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQueryCmplt_CoderList_isValid_t;

#define Recorder_MsgEncoderXQueryCmplt_CoderList_FrameSize	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQueryCmplt_CoderList_FrameSize_t;

#define Recorder_MsgEncoderXQueryCmplt_CoderList_maxEncBytesPerBlock	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgEncoderXQueryCmplt_CoderList_maxEncBytesPerBlock_t;


typedef struct {
	UInt32	Encoding;
	UInt32	isValid;
	UInt32	FrameSize;
	UInt32	maxEncBytesPerBlock;
} Recorder_MsgEncoderXQueryCmplt_CoderList_t;

#define Recorder_MsgEncoderXQueryCmplt_CoderList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_isValid), &((structAddr)->isValid),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_FrameSize), &((structAddr)->FrameSize),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_maxEncBytesPerBlock), &((structAddr)->maxEncBytesPerBlock))


#define Recorder_MsgEncoderXQueryCmplt_CoderList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_isValid), &((structAddr)->isValid),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_FrameSize), &((structAddr)->FrameSize),	\
			(Recorder_MsgEncoderXQueryCmplt_CoderList_maxEncBytesPerBlock), &((structAddr)->maxEncBytesPerBlock))


#define Recorder_MsgEncoderXQueryCmplt_CoderList_Size		16

#define Recorder_MsgEncoderXQueryCmplt_CoderList	0x1	/* 1 */

/*
 * Recorder_MsgEncoderXQueryCmplt (value = 0x20f) is an output message
 * for component Recorder.
 */


typedef struct {
	UInt32	Count;
} Recorder_MsgEncoderXQueryCmplt_t;

#define Recorder_MsgEncoderXQueryCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderXQueryCmplt_Count), &((structAddr)->Count))


#define Recorder_MsgEncoderXQueryCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Recorder_MsgEncoderXQueryCmplt_Count), &((structAddr)->Count))


#define Recorder_MsgEncoderXQueryCmplt_Size		4

#define Recorder_MsgEncoderXQueryCmplt	0x20f	/* 527 */
/* The MsgEncoderQueryCmplt message is sent in response to the MsgEncoderQuery 
 * command when the message has been received and processed. Count The number 
 * of coders covered in this message. CoderList - The structure consist of 
 * Encoding The specified coder type isValid Indication that the coding type 
 * specified is supported by this Instance. FrameSize - The frame size in 
 * bytes. For waveform codec, it depends on which task period of this codec is 
 * running on. E.g. For Mulaw64, it is 96 bytes if running on the 12ms task 
 * period.. MaxEncBytesPerBlock - The maximum number of bytes in a block that 
 * the host can expect from the resource for Record/Encode. */

#define Recorder_MsgStartx_StreamID	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgStartx_StreamID_t;

#define Recorder_MsgStartx_Encoding	0x380004	/* 3670020 */
typedef	UInt32	Recorder_MsgStartx_Encoding_t;

#define Recorder_MsgStartx_StartMode_NORMAL	0	/* 0 */

#define Recorder_MsgStartx_StartMode_PAUSED	0x1	/* 1 */

#define Recorder_MsgStartx_StartMode_TIMED	0x2	/* 2 */

#define Recorder_MsgStartx_StartMode_BEEPINIT	0x4	/* 4 */

#define Recorder_MsgStartx_StartMode_SYNCH	0x8	/* 8 */

#define Recorder_MsgStartx_StartMode_TRANSACTION	0x10	/* 16 */

#define Recorder_MsgStartx_StartMode	0x380008	/* 3670024 */
typedef	UInt32	Recorder_MsgStartx_StartMode_t;

#define Recorder_MsgStartx_ParmCount	0x38000c	/* 3670028 */
typedef	UInt32	Recorder_MsgStartx_ParmCount_t;

#define Recorder_MsgStartx_RTCCount	0x380010	/* 3670032 */
typedef	UInt32	Recorder_MsgStartx_RTCCount_t;

#define Recorder_MsgStartx_DetCount	0x380014	/* 3670036 */
typedef	UInt32	Recorder_MsgStartx_DetCount_t;

#define Recorder_MsgStartx_varStart	0x18

#define Recorder_MsgStartx_ParmList_Num	0x880000	/* 8912896 */
typedef	QParm	Recorder_MsgStartx_ParmList_Num_t;

#define Recorder_MsgStartx_ParmList_Val	0x380000	/* 3670016 */
typedef	UInt32	Recorder_MsgStartx_ParmList_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Recorder_MsgStartx_ParmList_t;

#define Recorder_MsgStartx_ParmList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Recorder_MsgStartx_ParmList_Num), &((structAddr)->Num),	\
			(Recorder_MsgStartx_ParmList_Val), &((structAddr)->Val))


#define Recorder_MsgStartx_ParmList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Recorder_MsgStartx_ParmList_Num), &((structAddr)->Num),	\
			(Recorder_MsgStartx_ParmList_Val), &((structAddr)->Val))


#define Recorder_MsgStartx_ParmList_Size		8

#define Recorder_MsgStartx_ParmList	0x2	/* 2 */

/*
 * Recorder_MsgStartx (value = 0x210) is an input message
 * for component Recorder.
 */


typedef struct {
	UInt32	StreamID;
	UInt32	Encoding;
	UInt32	StartMode;
	UInt32	ParmCount;
	UInt32	RTCCount;
	UInt32	DetCount;
} Recorder_MsgStartx_t;

#define Recorder_MsgStartx_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(Recorder_MsgStartx_StreamID), &((structAddr)->StreamID),	\
			(Recorder_MsgStartx_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgStartx_StartMode), &((structAddr)->StartMode),	\
			(Recorder_MsgStartx_ParmCount), &((structAddr)->ParmCount),	\
			(Recorder_MsgStartx_RTCCount), &((structAddr)->RTCCount),	\
			(Recorder_MsgStartx_DetCount), &((structAddr)->DetCount))


#define Recorder_MsgStartx_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(Recorder_MsgStartx_StreamID), &((structAddr)->StreamID),	\
			(Recorder_MsgStartx_Encoding), &((structAddr)->Encoding),	\
			(Recorder_MsgStartx_StartMode), &((structAddr)->StartMode),	\
			(Recorder_MsgStartx_ParmCount), &((structAddr)->ParmCount),	\
			(Recorder_MsgStartx_RTCCount), &((structAddr)->RTCCount),	\
			(Recorder_MsgStartx_DetCount), &((structAddr)->DetCount))


#define Recorder_MsgStartx_Size		24

#define Recorder_MsgStartx	0x210	/* 528 */
/* The MsgStartx message is sent as a command to initiate recording of data 
 * from the network interface to a specified stream using a specified encoding 
 * algorithm. MsgStartx is an extension of the MsgStart message in which the 
 * ability to set parameters at start time is provided. The EvtRecording event 
 * message may be returned in addition to the MsgStartCmplt message if this 
 * event was enabled. StreamID - stream identifier for record. Encoding - 
 * encoding to use. Values: Defined in the Coders Definition File "coders.h". 
 * StartMode - starting mode. This is a bit map in that all of the modes may be 
 * OR'd together and set simultaneously.. Parameters are expressed as tuples of 
 * Num and Val in List. ParmCount - number of parameters to set RTCCount - for 
 * future expansion, should be set to zero DetCount - for future expansion, 
 * should be set to zero ParmList - parameter list. Num - parameter number(s). 
 * Val - parameter value(s). */
/* 
 * 7.1 Recorder Parameter Definitions
 */
/*
 * The duration for which to record.
 * (msecs). Default = 0 (i.e. no timeout).
 */

#define Recorder_ParmDuration	0x200	/* 512 */
typedef	UInt32	Recorder_ParmDuration_t;
/* This parameter is not implemented. An "unknown Parameter" error will be 
 * returned, if used. The amount of data (in msecs) to buffer before sending to 
 * host. Default = TBD. */

#define Recorder_ParmBufferSize	0x201	/* 513 */
typedef	UInt32	Recorder_ParmBufferSize_t;
/* The amount of data (in msecs) to truncate from buffer at the end of a 
 * recording. Default = TBD. */

#define Recorder_ParmBufferTruncate	0x202	/* 514 */
typedef	UInt32	Recorder_ParmBufferTruncate_t;
/*
 * The Signal Id of the preceding beep. 
 * Default =  BEEP_DLGC (0x71835E02)
 */

#define Recorder_ParmBeepSignalId	0x203	/* 515 */
typedef	UInt32	Recorder_ParmBeepSignalId_t;
/* This parameter is not implemented. An "unknown Parameter" error will be 
 * returned, if used. The number of bytes recorded after which a EvtStatus 
 * message will be sent. Default = 4000 */

#define Recorder_ParmBytesRecorded	0x204	/* 516 */
typedef	UInt32	Recorder_ParmBytesRecorded_t;

#define Recorder_ParmAGCOnOff_OFF	0	/* 0 */

#define Recorder_ParmAGCOnOff_ON	0x1	/* 1 */
/*
 * AGC on/off. Default = ON.
 */

#define Recorder_ParmAGCOnOff	0x205	/* 517 */
typedef	UInt24	Recorder_ParmAGCOnOff_t;

#define Recorder_ParmState_INIT	0	/* 0 */

#define Recorder_ParmState_DEALLOCATED	0x1	/* 1 */

#define Recorder_ParmState_IDLE	0x2	/* 2 */

#define Recorder_ParmState_RECORDING	0x3	/* 3 */

#define Recorder_ParmState_PAUSED	0x4	/* 4 */

#define Recorder_ParmState_STOPPING	0x5	/* 5 */

#define Recorder_ParmState_EXITING	0x6	/* 6 */
/*
 * The state of the recorder instance.
 */

#define Recorder_ParmState	0x206	/* 518 */
typedef	UInt24	Recorder_ParmState_t;

#define Recorder_ParmRtcStopBuffering_ENABLE	0x1	/* 1 */

#define Recorder_ParmRtcStopBuffering_DISABLE	0	/* 0 */
/*
 * The RTC stop buffering parameter.
 * 1= Buffering Enabled (Default)
 * 0 = Buffering Disabled
 */

#define Recorder_ParmRtcStopBuffering	0x207	/* 519 */
typedef	UInt32	Recorder_ParmRtcStopBuffering_t;
/* This parameter has been replaced by a start mode. This entry is here to 
 * preserve compatibility. */

#define Recorder_ParmSyncRecordNotUsed	0x208	/* 520 */
typedef	UInt24	Recorder_ParmSyncRecordNotUsed_t;

#define Recorder_ParmSCR_SCR	0x1	/* 1 */

#define Recorder_ParmSCR_NOSCR	0	/* 0 */
/*
 * Perform recording in silence compressed recording mode.
 */

#define Recorder_ParmSCR	0x209	/* 521 */
typedef	UInt24	Recorder_ParmSCR_t;
/*
 * The byte count to record, if non-zero. Default = zero (i.e. no count limit).
 */

#define Recorder_ParmMaxBytes	0x20a	/* 522 */
typedef	UInt24	Recorder_ParmMaxBytes_t;
/* This parameter is not implemented. An "unknown Parameter" error will be 
 * returned, if used. The Signal Id of the notification tone. Default = 
 * BEEP_DLGC (0x71835E02) */

#define Recorder_ParmNotifyToneSignalId	0x20b	/* 523 */
typedef	UInt32	Recorder_ParmNotifyToneSignalId_t;

#define Recorder_ParmMaxRtcs_Initial	0xe	/* 14 */
/* The number of RTC events and actions to allocate space for. This may only 
 * be changed before the component is initialized. (Default = 14) */

#define Recorder_ParmMaxRtcs	0x20c	/* 524 */
typedef	UInt24	Recorder_ParmMaxRtcs_t;
/* Not used */

#define Recorder_ParmAGC00	0x250	/* 592 */
typedef	UInt24	Recorder_ParmAGC00_t;
/*The target output level to the TDM bus divided by 32 (to limit K to the 
 * range 0 to -1). Note that K is the average level for the output. PrmAGC_K is 
 * defined as: K * 223 where K is defined as follows: (10(output level in 
 * dB)/20)/32 Note: Multiplying by 223 converts the value into a linear 24-bit 
 * value that accommodates the 24-bit DSPs used on the DM3 boards. Therefore, K 
 * = 0.006529 corresponds to -13.6 dB average since 0.006529 = 
 * (10(-13.6/20))/32 Note that -13.6 dB average would result in -6.6 dBm level 
 * of the analog output signal. Here is a sample calculation to obtain a 
 * hexadecimal value of PrmAGC_K for an output level of -19.6 dB: 
 * (10(-19.6/20))/32 * 223 = 0x006b39 It is recommended that the value be set 
 * in the range of -20.6 dB to -10.6 dB. Higher values may result in strong 
 * peak to average compression if it is enabled or just severe clipping if peak 
 * to average compression is disabled. */

#define Recorder_ParmAGC_K	0x251	/* 593 */
typedef	UInt24	Recorder_ParmAGC_K_t;
/* AGC_CLIPLIM is not supported */

#define Recorder_ParmAGC_CLIPLIM	0x252	/* 594 */
typedef	UInt24	Recorder_ParmAGC_CLIPLIM_t;
/* The size of the memory (in msec) after each long silence between words or 
 * sentences. This controls how fast the gain varies at the beginning of each 
 * sentence except for the very first one. Note that this parameter is actually 
 * an inverse of the memory size. For example, 0.01 corresponds to 100 msec 
 * size. Possible Values: Any in the range from Mem_init(usually set to 1/10) 
 * up to Mem_max_size(described below). It is however, recommended to keep it 
 * in the range from 1/50 to 1/1000 (50 msec - 1sec). */

#define Recorder_ParmAGC_MEM_SIL_RESET	0x253	/* 595 */
typedef	UInt24	Recorder_ParmAGC_MEM_SIL_RESET_t;
/* The maximum size of the memory (in msec). This controls how fast the gain 
 * varies within one sentence. Note that this parameter is also an inverse of 
 * the memory size. For example, 0.01 corresponds to 100 msec size. Possible 
 * Values: Any value above Mem_sil_reset(actually it should be less than 
 * Mem_sil_reset since both are inverses). It is recommended to have it within 
 * 1/300 -1/3000 (300msec - 3sec) range. When tones are not expected or the 
 * tone protection is enabled, then this parameter can be set to 2 sec. 
 * Otherwise, it should be close to 300msecs. */

#define Recorder_ParmAGC_MEM_MAX_SIZE	0x254	/* 596 */
typedef	UInt24	Recorder_ParmAGC_MEM_MAX_SIZE_t;
/* The upper threshold for noise level estimate. Any signal above this 
 * threshold will be considered as speech. Thus, this threshold should be set 
 * quite high in order to let the AGC itself figure out when there are voiced 
 * and unvoiced periods. The parameter is given in terms of the average level. 
 * Example: Low_threshold = 0.0100 corresponds to -40dBaverage(or -33dBm analog 
 * input) since 0.01 = 10^(-40/20) Possible Values: Any threshold between 
 * nflor_low_threshold given below and high Threshold which is given by 
 * AGC_K/Max_gain. Thus, it usually recommended to keep it in the range of 
 * -60dB to -40dB. */

#define Recorder_ParmAGC_LO_AGC_THRESHOLD	0x255	/* 597 */
typedef	UInt24	Recorder_ParmAGC_LO_AGC_THRESHOLD_t;
/* The lower threshold for the noise level estimate. Any signal with an 
 * average level below this threshold will be considered a background noise. 
 * Thus, the threshold should be set very low. If however, a fixed noise to 
 * speech threshold is required, then nflor_low_threshold and Low_threshold 
 * should both be set to the desired threshold divided over loth_factor. 
 * Possible Values: Any threshold below low_threshold. It is usually 
 * recommended though to keep it below -70dB. */

#define Recorder_ParmAGC_NFLOR_LOW_THRESH	0x256	/* 598 */
typedef	UInt24	Recorder_ParmAGC_NFLOR_LOW_THRESH_t;
/* AGC_QUANTLEV_SCALE is not supported*/

#define Recorder_ParmAGC_QUANTLEV_SCALE	0x257	/* 599 */
typedef	UInt24	Recorder_ParmAGC_QUANTLEV_SCALE_t;
/* The maximum gain divided by 32. This parameter controls the maximum 
 * possible gain applied by the AGC algorithm. It also implies the High 
 * Threshold Level above which all the inputs produce the target output levels 
 * and below which produce the levels linearly decreasing with their input 
 * level. AGC_MAX_GAIN is defined as: ((10((maximum gain in dB)/20))/32) * 223 
 * Note: Multiplying by 223 converts the value into a linear 24-bit value that 
 * accommodates the 24-bit DSPs used on the DM3 boards. Here is a sample 
 * calculation to obtain a hexadecimal value of AGC_MAX_GAIN for a maximum gain 
 * of 21 dB: ((10(21/20))/32) * 223 It is recommended that the value be set in 
 * the range of 0 dB to 30 dB. Values: 0x040000 to 0x7e7db9 (0 dB to 30 dB) */

#define Recorder_ParmAGC_MAX_GAIN	0x258	/* 600 */
typedef	UInt24	Recorder_ParmAGC_MAX_GAIN_t;
/*AGC_GATE_HANG is not supported */

#define Recorder_ParmAGC_GATE_HANG	0x259	/* 601 */
typedef	UInt24	Recorder_ParmAGC_GATE_HANG_t;
/* AGC_NF_ATTSLOW is not supported */

#define Recorder_ParmAGC_NF_ATTSLOW	0x25a	/* 602 */
typedef	UInt24	Recorder_ParmAGC_NF_ATTSLOW_t;
/* AGC_NF_ATTFAST is not supported */

#define Recorder_ParmAGC_NF_ATTFAST	0x25b	/* 603 */
typedef	UInt24	Recorder_ParmAGC_NF_ATTFAST_t;
/* This parameter controls at what rate the gain should increase. It is the 
 * fraction by which the current gain is to be incremented. It does not control 
 * the rate with which gain decreases. It should be in order of 0.01. */
/* 
 * Recorder Error Code Definitions
 */

#define Recorder_ParmAGC_GAIN_INC_SPEECH	0x25c	/* 604 */
typedef	UInt24	Recorder_ParmAGC_GAIN_INC_SPEECH_t;
/*
 * Invalid StreamId was specified.
 */

#define Recorder_ErrStreamID	0x200	/* 512 */
/*
 * Cluster could not be activated.
 */

#define Recorder_ErrClusterActivate	0x201	/* 513 */
/*
 * Cluster information could not be obtained.
 */

#define Recorder_ErrClusterInfo	0x202	/* 514 */
/*
 * Invalid Encoder was specified.
 */

#define Recorder_ErrEncoder	0x203	/* 515 */
/*
 * No tone generator available for beep-initiated record.
 */

#define Recorder_ErrNoToneGen	0x204	/* 516 */
/*
 * Invalid start mode specified when starting record. 
 */

#define Recorder_ErrStartMode	0x205	/* 517 */
/*
 * The requested encoder is not avalaible.
 */

#define Recorder_ErrEncoderNotAvailable	0x206	/* 518 */
/*
 * The number of encoders has exceeded the maximum allowable.
 */

#define Recorder_ErrTooManyEncoders	0x207	/* 519 */
/*
 * Overrun detected. Stream full.
 */

#define Recorder_ErrOverrun	0x208	/* 520 */
/*
 * qFTimerSet failed, caused from invalid duration parameter.
 */

#define Recorder_ErrFTimer	0x209	/* 521 */
/*
 * The specified parameter is not supported.
 */
/*
 * Standard Attribute Definition
 */

#define Recorder_ErrParmNotSupported	0x20a	/* 522 */

#define Recorder_Std_ComponentType	0x2	/* 2 */
/*
 * Recorder features.
 */

#define Recorder_DIALOGIC	0x1	/* 1 */
/*
 * Dialogic Id.
 */
/*
 * Recorder Specific Attributes
 */

#define Recorder_Feature_BeepInit	0x1	/* 1 */

#define Recorder_Feature_AGC	0x2	/* 2 */
/*
 * Recorder features.
 */
/* 
 * Recorder Event Type Definitions. 
 */

#define Recorder_Feature	0x3	/* 3 */
typedef	QCompAttr	Recorder_Feature_t;

#define Recorder_Event_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	Recorder_Event_ReturnAddress_t;

#define Recorder_Event_Type_EvtRecording	0x250	/* 592 */

#define Recorder_Event_Type_EvtPaused	0x251	/* 593 */

#define Recorder_Event_Type_EvtStopped	0x252	/* 594 */

#define Recorder_Event_Type_EvtStatus	0x253	/* 595 */

#define Recorder_Event_Type	0x380006	/* 3670022 */
typedef	UInt32	Recorder_Event_Type_t;

#define Recorder_Event_Label	0x38000a	/* 3670026 */
typedef	UInt32	Recorder_Event_Label_t;

/*
 * Recorder_Event (value = generic) is a message
 * for component Recorder.
 */


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Type;
	UInt32	Label;
} Recorder_Event_t;

#define Recorder_Event_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Recorder_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(Recorder_Event_Type), &((structAddr)->Type),	\
			(Recorder_Event_Label), &((structAddr)->Label))


#define Recorder_Event_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Recorder_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(Recorder_Event_Type), &((structAddr)->Type),	\
			(Recorder_Event_Label), &((structAddr)->Label))


#define Recorder_Event_Size		14
/*
 * EvtRecording is generated when record has started.
 */
/*
 * EvtPaused is generated when record has been paused. 
 */

#define Recorder_EvtStopped_Label	0x380000	/* 3670016 */
typedef	UInt32	Recorder_EvtStopped_Label_t;

#define Recorder_EvtStopped_Reason_UserStop	0x1	/* 1 */

#define Recorder_EvtStopped_Reason_Rtc	0x2	/* 2 */

#define Recorder_EvtStopped_Reason_Timeout	0x3	/* 3 */

#define Recorder_EvtStopped_Reason_TranscodingStop	0x4	/* 4 */

#define Recorder_EvtStopped_Reason_MaxBytes	0x5	/* 5 */

#define Recorder_EvtStopped_Reason	0x380004	/* 3670020 */
typedef	UInt32	Recorder_EvtStopped_Reason_t;

#define Recorder_EvtStopped_RtcLabel	0x380008	/* 3670024 */
typedef	UInt32	Recorder_EvtStopped_RtcLabel_t;

/*
 * Recorder_EvtStopped (value = generic) is a message
 * for component Recorder.
 */


typedef struct {
	UInt32	Label;
	UInt32	Reason;
	UInt32	RtcLabel;
} Recorder_EvtStopped_t;

#define Recorder_EvtStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Recorder_EvtStopped_Label), &((structAddr)->Label),	\
			(Recorder_EvtStopped_Reason), &((structAddr)->Reason),	\
			(Recorder_EvtStopped_RtcLabel), &((structAddr)->RtcLabel))


#define Recorder_EvtStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Recorder_EvtStopped_Label), &((structAddr)->Label),	\
			(Recorder_EvtStopped_Reason), &((structAddr)->Reason),	\
			(Recorder_EvtStopped_RtcLabel), &((structAddr)->RtcLabel))


#define Recorder_EvtStopped_Size		12
/* EvtStopped is generated when record has stopped. The reason for stopping is 
 * in the data field of the message. */

#define Recorder_EvtStatus_Label	0x380000	/* 3670016 */
typedef	UInt32	Recorder_EvtStatus_Label_t;

#define Recorder_EvtStatus_BytesRecorded	0x380004	/* 3670020 */
typedef	UInt32	Recorder_EvtStatus_BytesRecorded_t;

/*
 * Recorder_EvtStatus (value = generic) is an input or output message
 * for component Recorder.
 */


typedef struct {
	UInt32	Label;
	UInt32	BytesRecorded;
} Recorder_EvtStatus_t;

#define Recorder_EvtStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Recorder_EvtStatus_Label), &((structAddr)->Label),	\
			(Recorder_EvtStatus_BytesRecorded), &((structAddr)->BytesRecorded))


#define Recorder_EvtStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Recorder_EvtStatus_Label), &((structAddr)->Label),	\
			(Recorder_EvtStatus_BytesRecorded), &((structAddr)->BytesRecorded))


#define Recorder_EvtStatus_Size		8
/* EvtStatus is generated evert time the number of bytes specified by the 
 * ParmBytesRecorded parameter have been recorded. The number of bytes recorded 
 * is reported in this message. */
/* 
 * Recorder Run Time Control Actions Definitions
 */

#define Recorder_Action_Label	0x380000	/* 3670016 */
typedef	UInt32	Recorder_Action_Label_t;

#define Recorder_Action_Type_RtcStop	0x270	/* 624 */

#define Recorder_Action_Type_RtcPause	0x271	/* 625 */

#define Recorder_Action_Type_RtcResume	0x272	/* 626 */

#define Recorder_Action_Type_RtcStopDTMF	0x273	/* 627 */

#define Recorder_Action_Type	0x380004	/* 3670020 */
typedef	UInt32	Recorder_Action_Type_t;

/*
 * Recorder_Action (value = generic) is a message
 * for component Recorder.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
} Recorder_Action_t;

#define Recorder_Action_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Recorder_Action_Label), &((structAddr)->Label),	\
			(Recorder_Action_Type), &((structAddr)->Type))


#define Recorder_Action_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Recorder_Action_Label), &((structAddr)->Label),	\
			(Recorder_Action_Type), &((structAddr)->Type))


#define Recorder_Action_Size		8
/*
 * RtcStop is a RTC Action to stop record.
 */
/*
 * RtcPause is a RTC Action to pause record. 
 */
/*
 * RtcResume is a RTC Action to resume record.
 */
/* RtcStopDTMF is a RTC Action to stop record and apply the ParmBufferTruncate 
 * backspace paramter to erase the termminating digit. */
/*
 * End of all Mercury Recorder Component Definitions
 */

#define Recorder	0x2	/* 2 */

typedef struct {
	UInt32		ParmDuration;
	UInt32		ParmBufferSize;
	UInt32		ParmBufferTruncate;
	UInt32		ParmBeepSignalId;
	UInt32		ParmBytesRecorded;
	UInt24		ParmAGCOnOff;
	UInt24		ParmState;
	UInt32		ParmRtcStopBuffering;
	UInt24		ParmSyncRecordNotUsed;
	UInt24		ParmSCR;
	UInt24		ParmMaxBytes;
	UInt32		ParmNotifyToneSignalId;
	UInt24		ParmMaxRtcs;
	UInt24		ParmAGC00;
	UInt24		ParmAGC_K;
	UInt24		ParmAGC_CLIPLIM;
	UInt24		ParmAGC_MEM_SIL_RESET;
	UInt24		ParmAGC_MEM_MAX_SIZE;
	UInt24		ParmAGC_LO_AGC_THRESHOLD;
	UInt24		ParmAGC_NFLOR_LOW_THRESH;
	UInt24		ParmAGC_QUANTLEV_SCALE;
	UInt24		ParmAGC_MAX_GAIN;
	UInt24		ParmAGC_GATE_HANG;
	UInt24		ParmAGC_NF_ATTSLOW;
	UInt24		ParmAGC_NF_ATTFAST;
	UInt24		ParmAGC_GAIN_INC_SPEECH;

} Recorderparm_t;

#if defined ( Recorder_DEFINED )

ParmStruct RecorderParmTab []= {
{Recorder_ParmDuration, 26, 0, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmDuration), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmBufferSize), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmBufferTruncate), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmBeepSignalId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmBytesRecorded), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGCOnOff), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmState), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmRtcStopBuffering), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmSyncRecordNotUsed), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmSCR), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmMaxBytes), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Recorderparm_t, ParmNotifyToneSignalId), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmMaxRtcs), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC00), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_K), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_CLIPLIM), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_MEM_SIL_RESET), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_MEM_MAX_SIZE), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_LO_AGC_THRESHOLD), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_NFLOR_LOW_THRESH), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_QUANTLEV_SCALE), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_MAX_GAIN), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_GATE_HANG), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_NF_ATTSLOW), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_NF_ATTFAST), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(Recorderparm_t, ParmAGC_GAIN_INC_SPEECH), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_recdefs_h_) */
