#ifndef _SC4KAPI_H
#define _SC4KAPI_H    /* MULTIPLE INCLUSION PROTECTION */

/* This line is included to allow this document to be saved as text-only for use as a C header file.





SC4000 Interface Library 
from Summary Info dialog box title  field

Specification


Sign Off Authorization


_____________________________	__________________________________	Date:	__________
Author	Signature

Luke Kiernan_________________	__________________________________	Date:	__________
Mercury Firmware Group Leader	Signature
























	Date:	2/27/96
	Revision	Bfrom Summary Info dialog box Subject  field
	Filename: 	SC4KAPI.DOC
	Author: 	Arthur F. Elwellfrom Summary Info dialog box Author field
	Document #:	SWS-0312 from Summary Info dialog box Keywords field


Intel Confidential

TABLE OF CONTENTS
1. Overview	
1.1 Revision History	
1.2 Purpose	
1.3 Scope	
1.4 References	
2. Theory of Operation	
2.1 Introduction	
3. Environmental Requirements	
3.1 Hardware	
3.2 Intel(r) Dialogic(r) Software	
3.3 File Names	
4. Communication Protocol	
4.1 Component Interface	
4.2 Error Handling	
5. Application Overview	
5.1 Setup	
5.2 Diagnostic Mode	
5.3 Switching	
5.4 Clock Master	
5.5 Parallel Access	
6. Function Set	
6.1 sh_connectToExternal	
6.2 sh_connectToLocal	
6.3 sh_disableDiagnosticMode	
6.4 sh_disableParallelAccess	
6.5 sh_disconnectExternal	
6.6 sh_disconnectLocal	
6.7 sh_enableDiagnosticMode	
6.8 sh_enableParallelAccess	
6.9 sh_init	
6.10 sh_open	
6.11 sh_readBusConfig	
6.12 sh_readClockMode	
6.13 sh_readExternalConnection	
6.14 sh_readLocalConnection	
6.15 sh_readParallelAccess	
6.16 sh_readParm	
6.17 sh_setBusConfig	
6.18 sh_setClockMode	
6.19 sh_version	
6.20 sh_writeParallelAccess	
6.21 sh_writeParm	
7. Runtime Firmware Open Hook Routine Interfaces	
7.1 oh_enterCriticalRegion	
7.2 oh_exitCriticalRegion	
7.3 oh_writeRegister	
7.4 oh_readRegister	
8. 	
8. Definitions	
8.1 Configuration Definitions	
8.2 Return Status Codes	
8.3 General Definitions	
8.4 Data Types	
8.5 Function Prototypes	

Overview
The SC4000 Interface Library routines provide a user-friendly interface to the SCSA Switching Handler hardware (SH).  The major requirement of the library design is to maintain an open interface that minimizes SH dependencies in order to simplify the porting efforts of technology developers. This document describes the interfaces and data structures which provide firmware access to these services.
In addition to the written descriptions of the switching handler interface, there are C-language codes in this document which allow it to become a C header file of equates and definitions for the SC4000 Interface Library, when the document is saved as a Text-Only file.
Revision History

REVISION HISTORY

Rev.
Date of Change
Description of Change
Rev Originator

1.0
11/16/95
Initial Release
Arthur F. Elwell

1.1
11/27/95
Incorporated suggestions from Review; alphabetized functions; add examples; deleted sh_init, sh_setloc, added sh_open; split sh_connect, sh_disconnect into local and external versions of each; expanded parameter table;
Arthur F. Elwell

A
11/30/95
Corrected typos in C-language syntax.; added typedef for SH_ID; added new sh_init; expanded examples;
Arthur F. Elwell

A.1
1/30/96
Changed SH_BYTE and SH_WRD to SH_UINT8 and SH_UINT16; corrected configuration definitions; added definitions for LOCTS_TO_LOCTS and EXTTS_TO_LOCTS; Added sh_idLookup; removed oh_checkClock, oh_isBusy;
Arthur F. Elwell

B
2/22/96
Changed protoype arguments for oh_readRegister and oh_writeRegister; removed sh_idLookup; removed cautions regarding oh_enterCriticalRegion and oh_exitCriticalRegion from sh routines and added same to oh_readRegister and oh_writeRegister
Arthur F. Elwell






Purpose
This purpose of this document is to describe the functional interface to the SC4000. The function definition set is the means by which telephony applications communicate with the SC4000. This document will be used by developers of firmware for the SC4000 Interface 
Scope
This document defines the functional interface to the SC4000 Interface Library routines.
References

TBD
"SC4000 Design Specification", by J. Gerbehy


 TBD
"SC4000  Developer's Kit", Intel Corp.


Theory of Operation
Introduction
The SC4000 Interface Library provides a functional method for initializing, setting and controlling data flow through SC4000  hardware. Results of the operation are returned to the invoking process.
Environmental Requirements
Hardware
The hardware accessed by the SC4000 Interface Library is:
SC4000 chip
Intel(r) Dialogic(r) Software
As with other low-level drivers, at downloading time, the downloading software will test for the existence of referenced hardware and copy the appropriate driver functions  to main memory. Once downloaded its functions are called by the runtime firmware.
File Names
The sc4kapi.h file will contain the definitions of all SC4000 Interface Library parameters and equates.
Communication Protocol
Component Interface
The SC4000 Interface Library is a set of synchronous functions which are callable from firmware Components.
Error Handling
All error conditions are returned using status return codes. A listing of status return codes is given in section 8.2.
Application Overview
This section explains how the SC4000 Interface Driver Library is  used to implement various features visible to the firmware.
Setup
Before any of the switching functions may be exercised, the interface must be configured. The function sh_open is used to register the switching handler for any firmware which will access it. Registration returns an identifier, necessary for further interaction with the switch handler. Once registered, sh_init resets the interface, and enforces several parameter defaults (see section 8.1 for a list of default parameter settings). Bus configuration is performed using sh_setBusConfig. Parameters which must differ from the defaults must be set using sh_writeParm. 
A typical initial sequence, for the following platform variables:
	Local bus clock polarity = inverted
	Local bus frame sync position = L_FS occurs during the first clock of the frame
	Master Clock Input Frequency = 65.536 MHz
	SCbus Clock Master
	
sh_open( &id_1, (SH_ADDR *)0x5c000000);
sh_setBusConfig(id_1, SH_SCBUS_PRIMARY, SH_DIAG_DISABLED, SH_SCBUS_2048KBPS,
 			SH_LOCBUS_2048KBPS, SH_MCLK_65536KHZ);
sh_setParm( id_1, LOCBUS_L_CLK_POLARITY, SH_L_CLK_INVERTED);
sh_setParm( id_1, LOCBUS_L_FS_POSITION, SH_L_FS_FIRST_CLOCK);
sh_setClockMode( id_1, SH_CLOCK_PRIMARY);
Diagnostic Mode
Diagnostic mode is the internal connection of local timeslots so that data transmitted from local timeslot appears to have been transmitted to its destination external timeslot, looped back throuogh the corresponding source (receive) external timeslot and delivered to the receive local timeslot connected to it. In diagnostic mode, no data are transferred to or from the external bus. To use Diagnostic mode, a clock must be present, therefore, the SC4000 must be declared to be in Primary clock mode, since it is disconnected from the external bus. The default for Diagnostic Mode is Enabled.



As an example, all local timeslots connected to their corresponding external timeslots, in diagnostic mode would appear as shown in the diagram:
sh_enableDiagnosticMode(id);
sh_setClockMode(id, SH_CLOCK_PRIMARY);
for (ts=0; ts<128; ts++) {
	sh_connectToExternal (id, ts, ts);
	sh_connectToLocal (id, ts, ts, EXTTS_TO_LOCTS);
}




Switching
After initial setup, switching is performed using sh_connectToLocal, sh_connectToExternal sh_disconnectLocal and sh_disconnectExternal. Connections are made between the local bus and the external bus, or, through internal connections, from a timeslot on a local bus to another timeslot on the local bus. 
As an example, an application needs to, initially, make local connections for all local timeslots. The connections will be from timeslot (ts) 0 to ts 64, ts 1 to ts 65,  , ts 63 to ts 127, ts 64 to ts 0,  , ts 127 to ts 63. This would be accomplished by:
for (locts=0; locts<128; locts++) {
	sh_connectToLocal (id, locts, (locts+64)%128, LOCTS_TO_LOCTS);
}


Using that initial setup, the application requires that a two-way connection be made from between timeslot 0 and SCbus timeslot 132, with the continued local connection from local timeslot 0 to local timeslot 64:

sh_connectToExternal (id, 0, 132);
sh_connectToLocal (id, 0, 132, EXTTS_TO_LOCTS);



When the connection is no longer needed, the timeslots may either be returned to their original configurations by:

sh_disconnectExternal (id, 0);
sh_connectToLocal (id, 0, 64, LOCTS_TO_LOCTS);

or,  simply disconnected from the external bus:

sh_disconnectExternal (id, 0);
sh_disconnectLocal (id, 0);

Note that by disconnecting, data transmitted on timeslot 0 will still be received on timeslot 64 due to the initial local connection of timeslot 64 to timeslot 0.
Clock Master
The SC4000 can be made to be the SCbus Clock Master. The sh_setClockMode function will set the specified SC4000 to be the Clock Master (primary mode) or arm it to become the next Clock Master (secondary mode). When the SC4000 is armed and a clock failure occurs the Clock Master bit is automatically set. The SC4000 begins driving the SCbus within 4 Clocks.
Parallel Access
The SC4000 allows access to the data passing through it, via parallel access registers, which would normally pass to or from the local bus on a timeslot basis. Data from the external bus to the local bus may be read using the sh_readParallelAccess function, without any special setup. Data written to the parallel access registers, by the sh_writeParallelAccess function will be sent to the external bus, for the specified timeslot, if parallel access has been enabled, for that timeslot, using the sh_enableParallelAccess function. Once parallel access has been enabled, the pattern written by the sh_parallelWrite function will continue to be sent until it is changed or parallel access disabled using the sh_disableParallelAccess function.
As an example, an application which performs all of its data transfers through parallel access, sets up a transmit (to the external bus) pattern:
sh_writeParallelAccess( id, locts, idlePattern);
sh_enableParallelAccess( id, locts);

The application reads the data from the external bus:
sh_readParallelAccess ( id, locts, SH_PARALLEL_RECEIVE, &receiveData);

and decides that data should be transmitted:
sh_writeParallelAccess ( id, locts, transmitData);


Function Set

 sh_connectToExternal
	Connect a local timeslot to an external expansion bus timeslot
	

	Name	SH_STATUS sh_connectToExternal ( SH_ID id, SH_UINT8 localTs, SH_UINT16 extts)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.

		SH_UINT16  extts	External expansion bus timeslot.
0 = External expansion bus time slot 0.
1 = External expansion bus time slot 1.
.
.
.
2047 = External expansion bus time slot 2047
	Outputs:	none
	Returns:	SH_STATUS_DONE  			success
		SH_SHLIB_BUSY 			SH library is busy processing  another request.
		SH_BAD_SH_ID 			Invalid SH identifier.
		SH_NO_SH_PRESENT 			SH is not present.
		SH_INVALID_LOCAL_TIMESLOT 	Invalid local timeslot parameter.
		SH_INVALID_EXTERNAL_TIMESLOT 	Invalid external timeslot parameter.
		SH_INVALID_TYPE 			Invalid connection type.
		SH_LOCAL_TS_CONNECTED 		Local timeslot already connected.

	
Description
This library routine provides the functionality of connecting a local timeslot to an external expansion bus timeslot.  The connection of a local timeslot to an external timeslot is made based on the local timeslot being the transmitter. 
Example
The following shows how sh_connectExternal might be used:
The application then needs to make a connection from local timeslot 4 to SCbus timeslot 132.
sh_connectToExternal(id, 4, 132);

It is not required to disconnect a previous connection from the local timeslot before connecting it to a new external timeslot.

Cautions
Firmware must never connect an external expansion bus timeslot to more than one local transmit timeslot since the SCbus mode uses tri-state output drivers.  The firmware in this context could be resident on different Modules (e.g.. Network or Resource).

sh_connectToLocal
	Connect a local or external bus timeslot to a local bus timeslot
	

	Name	SH_STATUS sh_connectToLocal ( SH_ID id, SH_UINT8 localTs,  SH_UINT16 sourceTs, SH_UINT8 sourceType)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.

		SH_UINT8 sourceType	Defines the type of connection to be made,  with sourceTs to be either a local bus or external bus timeslot.
LOCTS_TO_LOCTS = Connection is from a local timeslot to a local bus timeslot.
EXTTS_TO_LOCTS = Connection is made from an external bus timeslot to a local bus timeslot.

		SH_UINT16 sourceTs	External expansion bus timeslot (if sourceTS= EXTTS_TO_LOCTS).
0 = External expansion bus time slot 0.
1 = External expansion bus time slot 1.
.
.
.
2047 = External expansion bus time slot 2047

			or Local timeslot (if sourceTS= LOCTS_TO_LOCTS).
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.

	Outputs:	none
	Returns:	SH_STATUS_DONE  			success
		SH_SHLIB_BUSY 			SH library is busy processing  another request.
		SH_BAD_SH_ID 			Invalid SH identifier.
		SH_NO_SH_PRESENT 			SH is not present.
		SH_INVALID_LOCAL_TIMESLOT 	Invalid local timeslot parameter.
		SH_INVALID_EXTERNAL_TIMESLOT  Source timeslot is out of range.
		SH_INVALID_TYPE 			Invalid connection type.

	
Description
This library routine provides the functionality of connecting a local timeslot to receive input from an external expansion bus timeslot or from another local bus timeslot. The type of connection between a local timeslot and its source is specified by sourceType (EXTTS_TO_LOCTS or LOCTS_TO_LOCTS ).
Note:
When making a local connection (LOCTS_TO_LOCTS) the transmitting timeslot, sourceTs,  may have been connected to an external timeslot. Completing the local connection does not alter the delivery of data to that external timeslot, i.e., data are received, both, at the receiving local timeslot and the destination external timeslot.

sh_disableDiagnosticMode
	Disable the SC4000 Diagnostic Mode
	

	Name	SH_STATUS sh_disableDiagnosticMode (SH_ID id)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
	Outputs:	none
	Returns:	SH_STATUS_DONE  	success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
	
	
Description
This function sets the SC4000 interface  out of diagnostic mode. When diagnostic mode is disabled, data transmitted from local timeslot n is not internally looped back, but, proceeds along the path configured by sh_connectToExternal and sh_connectToLocal. 


sh_disableParallelAccess
	Disallow Parallel Access channel to be output in place of local timeslot
	

	Name	SH_STATUS sh_disableParallelAccess (SH_ID id, SH_UINT8 localTs)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.
SH_ALL_TIMESLOTS = local timeslots 0 through 127
	Outputs:	none
	Returns:	SH_STATUS_DONE  	success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
	
	
Description
This function disables the Destination Parallel Access channel from being output in place of the input local bus timeslot. The local bus timeslot input, therefore, will be delivered. Using SH_ALL_TIMESLOTS as the timeslot specifier will cause disabling of Parallel Access output for all timeslots.
Note: This affects the data going to the external bus only. Data in the other direction may be read on the local serial bus or the parallel access registers without any special manipulation.

sh_disconnectExternal
	Disconnect a local (transmit) timeslot from the external bus timeslot.
	

	Name	SH_STATUS sh_disconnectExternal (SH_ID id, SH_UINT8 localTs)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.
	
	Outputs:	none
	Returns:	SH_STATUS_DONE 			success
		SH_SHLIB_BUSY 			SH library is busy processing  another request.
		SH_BAD_SH_ID 			Invalid SH identifier.
		SH_NO_SH_PRESENT 			SH is not present.
		SH_NO_CLOCK. 			No clock.
		SH_INVALID_LOCAL_TIMESLOT 	Invalid local timeslot parameter.
		SH_LOCAL_TS_DISCONNECTED 	Local timeslot disconnected.

	
Description
This library routine provides the functionality of disconnecting a local timeslot from the external expansion bus timeslot.
Note
Disconnecting a connection to an external bus timeslot does not affect any connection made using sh_connectToLocal, consequently, a local connection made to a local timeslot from a timeslot which is having its connection to an external bus timeslot disconnected, will continue the data transfer through the local connection. For example:

sh_connectToExternal(id, 9, 9);
sh_connectToLocal(id, 17, 9, LOCTS_TO_LOCTS);
sh_disconnectExternal(id, 9);
will set up a transmission connection between local timeslot 9 and external timeslot 9, and a reception connection between local timeslot 9 and local timeslot 17. The disconnect will break the connection from local timeslot 9 to external timeslot 9, but, the local connection between timeslots 9 and 17 will continue.

sh_disconnectLocal
	Disconnect a local (receive) timeslot from its source timeslot.
	

	Name	SH_STATUS sh_disconnectLocal (SH_ID id, SH_UINT8 localTs)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.
	Outputs:	none
	Returns:	SH_STATUS_DONE 			success
		SH_SHLIB_BUSY 			SH library is busy processing  another request.
		SH_BAD_SH_ID 			Invalid SH identifier.
		SH_NO_SH_PRESENT 			SH is not present.
		SH_NO_CLOCK. 			No clock.
		SH_INVALID_LOCAL_TIMESLOT 	Invalid local timeslot parameter.
		SH_LOCAL_TS_DISCONNECTED 	Local timeslot disconnected.

	
Description
This library routine provides the functionality of disconnecting a local (receive) timeslot from its source timeslot.

sh_enableDiagnosticMode
	Initialize the SC4000 Interface hardware
	

	Name	SH_STATUS sh_enableDiagnosticMode (SH_ID id)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
	Outputs:	none
	Returns:	SH_STATUS_DONE  	success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
	
	
Description
This function sets the SC4000 interface  into diagnostic mode. When diagnostic mode is enabled, data transmitted from local timeslot n is internally looped back to be received as if it had received from external timeslot n. In diagnostic mode, no data are transferred to or from the external bus.


sh_enableParallelAccess
	Allow Parallel Access channel to be output in place of local timeslot
	

	Name	SH_STATUS sh_enableParallelAccess (SH_ID id, SH_UINT8 localTs)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.
SH_ALL_TIMESLOTS = local timeslots 0 through 127
	Outputs:	none
	Returns:	SH_STATUS_DONE  	success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
	
	
Description
This function enables the Destination Parallel Access channel to be output in place of the input local bus timeslot. The local bus timeslot input, therefore, will be ignored. Using SH_ALL_TIMESLOTS as the timeslot specifier will cause enabling of Parallel Access output for all timeslots. The Parallel Access channels are read from and written to by the sh_readParallel and sh_writeParallel functions. 
Note: This affects the data going to the external bus only. Data in the other direction may be read on the local serial bus or the parallel access registers without any special manipulation.

sh_init
	Initialize the SC4000 Interface hardware
	

	Name	SH_STATUS sh_init (SH_ID id)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
	Outputs:	none
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_STATUS_ERROR 	Can not initialize SH hardware. 

	
Description
This library routine is used to reset the SH and set up the SH to its software default settings (refer to section 8.1 for a full listing of software default settings). This must be followed by bus configuration which is performed using sh_setBusConfig. Parameters which must differ from the defaults must be set using sh_writeParm.

Cautions
This routine should be called only once for each device.

sh_open
	Open the SC4000 Interface hardware
	

	Name	SH_STATUS sh_open (SH_ID * pId, SH_ADDR sh_baseAddress)
	Inputs:	SH_ADDR sh_baseAddress	Base address of the switching handler being opened.
	Outputs:	SH_ID * pId	Pointer to identifier of opened switching handler.
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_STATUS_ERROR 	Can not open SH hardware. 

	
Description
This library routine is used to register the SH. The location pointed to by pId contains an identifier returned after a successful opening. This identifier is used to refer to the device in all subsequent SH Library calls.

Cautions
Must be called prior to calling any other SH Library routines for a specific device.

sh_readBusConfig
	Read bus configuration parameters.
	

	Name	SH_STATUS sh_readBusConfig (SH_ID id, SH_UINT8  * pSCbusMode, SH_UINT8  * pDiagMode, 
SH_UINT8  * pSCbusFrMode, SH_UINT8  * pLocBusFrMode, 
SH_UINT8  * pInputClockFreq)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.

	Outputs:	SH_UINT8  * pSCbusMode	Pointer to the memory location to store the SCbus mode value. 
		SH_UINT8  * pDiagMode	Pointer to the memory location to store the Diagnostic mode value.
		SH_UINT8  * pSCbusFrMode	Pointer to the memory location to store the SCbus Framing mode value.
		SH_UINT8  * pLocBusFrMode	Pointer to the memory location to store the Local bus framing mode value.
		SH_UINT8  * pInputClockFreq	Pointer to the memory location to store the Master clock input frequency value.

	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.

	
Description
This library routine is used to read all SCbus parameters which are set via the sh_setBusConfig routine.
Details
The bus parameters are stored in the memory locations pointed to. For a list of valid symbolic values for the parameters, refer to section 8.1.

sh_readClockMode
	Read the Clock Mode
	

	Name	SH_STATUS sh_readClockMode (SH_ID id, SH_CLOCKMODE * pClockMode)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_CLOCKMODE * pClockMode	  Clock mode:
SH_CLOCK_SLAVE
SH_CLOCK_PRIMARY
SH_CLOCK_SECONDARY	
SH_CLOCK_NEW_PRIMARY
	Outputs:	none
	Returns:	SH_STATUS_DONE  	Success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.

	
Description
This library routine is used to read the mode of the specified clock, which may be primary, secondary or slave mode.
Cautions
A fourth mode, represented by SH_CLOCK_NEW_PRIMARY indicates that a secondary clock has been made primary due to a clock failure and it has the SCbus Clock Master bit and the SCbus Clock Master Arm bit set. This clock should be set as the primary clock using the sh_setClockMode routine before choosing a new secondary clock.

sh_readExternalConnection
	Inquire about the connection to an external timeslot.
	

	Name	SH_STATUS sh_readExternalConnection (SH_ID id, SH_UINT8 localTs, SH_UINT16 * pExtts)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.

	Outputs:	SH_UINT16  * pExtts	External expansion bus timeslot.
0 = External expansion bus time slot 0.
1 = External expansion bus time slot 1.
.
.
.
2047 = External expansion bus time slot 2047 

	Returns:	SH_STATUS_DONE  			success
		SH_SHLIB_BUSY 			SH library is busy processing  another request.
		SH_BAD_SH_ID 			Invalid SH identifier.
		SH_NO_SH_PRESENT 			SH is not present.
		SH_NO_CLOCK. 			No clock.
		SH_INVALID_LOCAL_TIMESLOT 	Invalid local timeslot parameter.
		SH_LOCAL_TS_DISCONNECTED 	Local timeslot disconnected.

	
Description
This library routine is used to inquire about the connection of a local (transmit) timeslot to an external bus timeslot.

sh_readLocalConnection
	Inquire about the connection of a local (receive) timeslot.
	
	Name	SH_STATUS sh_readLocalConnection (SH_ID id, SH_UINT8 localTs, SH_UINT16 * pSourceTs, 
SH_UINT8 * pSourceType)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.

	Outputs:	SH_UINT16  * pSourceTs	External expansion bus timeslot (if sourceTS= EXTTS_TO_LOCTS).
0 = External expansion bus time slot 0.
1 = External expansion bus time slot 1.
.
.
.
2047 = External expansion bus time slot 2047

			or Local timeslot (if sourceTS= LOCTS_TO_LOCTS).
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.

		SH_UINT8 * pSourceType	Pointer to value which specifies the type of connection made: LOCTS_TO_LOCTS = Connection is from a local timeslot to a local bus timeslot.
EXTTS_TO_LOCTS = Connection is made from an external bus timeslot to a local bus timeslot.


	Returns:	SH_STATUS_DONE  			success
		SH_SHLIB_BUSY 			SH library is busy processing  another request.
		SH_BAD_SH_ID 			Invalid SH identifier.
		SH_NO_SH_PRESENT 			SH is not present.
		SH_NO_CLOCK. 			No clock.
		SH_INVALID_LOCAL_TIMESLOT 	Invalid local timeslot parameter.
		SH_INVALID_TYPE 			Invalid connection type.
		SH_LOCAL_TS_DISCONNECTED 	Local timeslot disconnected.

	
Description
This library routine is used to inquire about the connection of a local timeslot.

sh_readParallelAccess
	Read data from the Parallel Access channel
	

	Name	SH_STATUS sh_readParallelAccess (SH_ID id, SH_UINT8 localTs, SH_UINT8 read_type,
SH_UINT8 * pdata)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.
		SH_UINT8  read_type	Specifies whether the read is from the transmit (destination) or the receive (source) Parallel Access register.
SH_PARALLEL_TRANSMIT = Transmit Parallel Access register
SH_PARALLEL_RECEIVE = Receive Parallel Access register
		SH_UINT8  * pdata	Pointer to memory location, data,  in which to return data read.
	Outputs:	SH_UINT8 data	Value from Parallel Access register.
	Returns:	SH_STATUS_DONE  	success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
	
	
Description
This function reads from the specified Parallel Access channel. The Parallel Access channels provide an alternate to the serial means of accessing data. The transmit channel is read/write and is written to with the sh_writeParallel function. Reading from the transmit channel yields the last data written by the sh_writeParallel function. The receive channel is read-only and reading from it yields the data currently being received from its source.
Cautions
The routines sh_readParallelAccess and sh_writeParallelAccess use the indirect method to access the parallel registers. This method does not require synchronization with the Frame Synch. It is applicable to sending a pattern, such as IDLE, or other similar functions, but, may not be appropriate for large data throughput. These applications may require an interrupt-driven routine using the direct access method (see the "SC4000 Developer's Kit" reference #2).

sh_readParm 
	Read SH parameters
	

	Name	SH_STATUS sh_readParm ( SH_ID id, SH_UINT16 parameter_id, SH_UINT8 * pvalue)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT16  parameter_id 	Parameter number (refer to section 8.1).
		SH_UINT8  *  pvalue 	Pointer to memory location to store the parameter value.
	Outputs:	SH_UINT8  value 	Parameter value (refer to section 8.1)
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_BAD_PARMID	Invalid parameter id.

	
Description
This library routine is used to read SH parameters that are SH-specific.
Details
The requested parameter value is returned. For a list of the parameter ids and their valid values see section 8.1.
Cautions
Technology developers must devise an appropriate set of parameters specific to their SH hardware.

sh_setBusConfig
	Set up bus configuration
	

	Name	SH_STATUS sh_setBusConfig (SH_ID id,  SH_UINT8 SCbusMode, SH_UINT8 diagMode, SH_UINT8 SCbusFrMode,
SH_UINT8 locBusFrMode,SH_UINT8 mclkInpFreq)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8 SCbusMode	SCbus mode value
SH_SCBUS_PRIMARY 	= Primary SCbus Signals selected
SH_SCBUS_ALTERNATE. 	= Alternate SCbus Signals selected
		SH_UINT8 diagMode	Diagnostic mode value.
SH_DIAG_ENABLED	= Diagnostic mode enabled
SH_DIAG_DISABLED	= Diagnostic mode disabled
		SH_UINT8 SCbusFrMode	SCbus Framing mode value.
SH_SCBUS_2048KBPS 	
	= 2.048 Mb/s, 256 Bits/Frame, 32 Time-Slots/Frame
SH_SCBUS_4096KBPS 2
	= 4.096 Mb/s, 512 Bits/Frame, 64 Time-Slots/Frame
SH_SCBUS_8192KBPS
	= 8.192 Mb/s, 1024 Bits/Frame, 128 Time-Slots/Frame
		SH_UINT8 locBusFrMode	Local bus framing mode value. 
SH_LOCBUS_2048KBPS 	
	= 2.048 Mb/s, 256 Bits/Frame, 32 Time-Slots/Frame
SH_LOCBUS_4096KBPS 2
	= 4.096 Mb/s, 512 Bits/Frame, 64 Time-Slots/Frame
SH_LOCBUS_8192KBPS
	= 8.192 Mb/s, 1024 Bits/Frame, 128 Time-Slots/Frame
		SH_UINT8 mclkInpFreq	Master clock input frequency value.
SH_MCLK_2048KHZ 	= 2.048 MHz
SH_MCLK_4096KHZ 	= 4.096 MHz
SH_MCLK_8192KHZ 	= 8.192 MHz
SH_MCLK_16384KHZ 	= 16.384 MHz
SH_MCLK_32768KHZ 	= 32.768 MHz
SH_MCLK_65536KHZ	= 65.536 MHz
	Outputs:	none
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_BAD_SCBUS_MODE	SCbus mode value out-of-range.
		SH_BAD_DIAG_MODE	Diagnostic mode value out-of-range.
		SH_BAD_SCBUS_FR_MODE		SCbus framing mode value out-of-range.
		SH_BAD_LOCBUS_FR_MODE	Local bus framing mode value out-of-range.
		SH_BAD_MCLK_INP_FREQ	Master clock input frequency value out-of-range.

	
Description
This library routine is used to initialize all SCbus parameters which are SH independent. The bus configuration parameters are set to the values supplied. For a list of valid symbolic values, refer to section 8.1.
Cautions
Only one master should be set per SCbus.
There are parameters which are dependent upon the values of other parameters to be valid. See the "SC4000 Developer's Kit" for parameter interdependencies. 

sh_setClockMode
	Set the Primary or Secondary Clock Mode
	

	Name	SH_STATUS sh_setClockMode (SH_ID id, SH_UINT8 clksrc, SH_CLOCKMODE clockMode)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8 clksrc 	Clock source
				0 = Internal ( default on-board clock source).
				1 = External ( default off-board clock source).
				2 - 9 = Other board-specific clock sources.
		SH_CLOCKMODE clockMode	  Clock mode
SH_CLOCK_SLAVE
SH_CLOCK_PRIMARY
SH_CLOCK_SECONDARY	
	Outputs:	none
	Returns:	SH_STATUS_DONE  	Success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_PREVIOUS_CLOCK_PRIMARY  Another clock has already been set to primary mode.
		SH_NO_SH_PRESENT 	SH is not present.

	
Description
This library routine is used to select the specified clock source to function as the primary or secondary clock source, or to deselect the specified clock (set to slave mode).
Details
The sh_setClockMode routine uses the Arm for SCbus Master bit to set Primary Mode. Absence of a clock will cause the armed SC4000 to begin driving the SCbus within 4 clock pulses. The Arm for SCbus Master bit will be reset after the clock has become master.
Cautions
The user must ensure that only one clock is specified as primary on any SCbus, and no more than one clock is specified as secondary on any SCbus.
This library routine calls the user open hook routine oh_checkClock described in section 7.  This routine must be called only after the sh_open, sh_setBusConfig, and sh_writeParm (if necessary) have been called.

sh_version
	Access the SH version/revision number.
	

	Name	SH_STATUS sh_version (SH_ID id, SH_UINT8 * pVersion)
	Inputs:	SH_ID  id 	Identifier for the specific SH registered via the sh_open routine.
	Outputs:	SH_UINT8  *pVersion	Pointer to the version/revision number of the SH.
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.

	
Description
This library routine is used to access the SH version/revision number.
Details
The version/revision value is eight bits, where the high nibble, bits 7:4, contains the version field, and the low nibble, bits 3:0 contain the revision field.
Cautions
It is recommended that this field be tested to validate that the proper SH LIB is used with the appropriate SH.

sh_writeParallelAccess
	Write data to the Parallel Access channel
	

	Name	SH_STATUS sh_writeParallelAccess (SH_ID id, SH_UINT8 localTs,  SH_UINT8 data)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT8  localTs 	Local timeslot.
0 = Local timeslot 0.
1 = Local timeslot 1.
.
.
.
127 = Local timeslot 127.
SH_ALL_TIMESLOTS = local timeslots 0 through 127
		SH_UINT8  data	Value to be written to Parallel Access Register.
	Outputs:	none
	Returns:	SH_STATUS_DONE  	success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
	
	
Description
This function writes data to the specified Parallel Access channel. The transmit channel is read/write and is read by the sh_readParallel function. Using SH_ALL_TIMESLOTS as the timeslot specifier will cause the same data pattern to be set on all timeslots.
Cautions
The routines sh_readParallelAccess and sh_writeParallelAccess use the indirect method to access the parallel registers. This method does not require synchronization with the Frame Synch. It is applicable to sending a pattern, such as IDLE, or other similar functions, but, may not be appropriate for large data throughput. These applications may require an interrupt-driven routine using the direct access method (see the "SC4000 Developer's Kit" reference #2).
Note
Writing to the Parallel Access channel does not cause the data to be transmitted unless the Parallel Access Enable bit of the Channel Specific Registers has been set for the desired timeslot. This bit is set by calling sh_enableParallelAccess. 
Once the data has been set for a particular timeslot, and the Parallel Access Enable bit set for that timeslot, that data is transmitted for that timeslot in each subsequent frame.


sh_writeParm
	Update SH parameters
	

	Name	SH_STATUS sh_writeParm ( SH_ID id, SH_UINT16 parameter_id, SH_UINT8 value)
	Inputs:	SH_ID id 	Identifier for the specific SH registered via the sh_open routine.
		SH_UINT16 parameter_id 	Parameter number (refer to section 8.1).
		SH_UINT8 value 	Parameter value (refer to section 8.1).
	Outputs:	none
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_BAD_PARMID	Invalid parameter id.
		SH_BAD_PARMVAL	Invalid value for parameter id.
	
Description
This library routine is used to update SH parameters that are SH-specific.
Details
The input value of the parameter replaces the parameter's value in its control register. Adjacent parameters in the same control register are unchanged. For a list of valid parameter ids and the corresponding symbolic value items, refer to the list in section 8.1.
Cautions
Technology developers must devise an appropriate set of parameters specific to their SH hardware.  Refer to the "SC4000 Developer's Kit" for the use of the SC4000 parameters.
Runtime Firmware Open Hook Routine Interfaces 
The user is provided with customizable functions, the Open Hook Routines, with which, specifics of the users environment, beyond the scope of the SH Library, may be taken into account. Standard implementations or function stubs are provided as a starting point.
Cautions
Note that on memory segmented processors (i.e. 80x86), the open hook routines should be compiled using a large memory model (or equivalent) and that the data segment register value is indeterminate upon entry to the open hook routines.

 oh_enterCriticalRegion 
	Enter a critical code region
	

	Name	void oh_enterCriticalRegion ()
	Inputs:	none
	Outputs:	none
	Returns:	none
	
	
Description
This user provided open hook routine is called by all SH LIB routines when entering a critical code region within the SHLIB.  This routine must prevent potentially conflicting routines from being invoked while a SH LIB routine is executing the critical region code.


oh_exitCriticalRegion 
	Exit a critical code region
	

	Name	void oh_exitCriticalRegion()
	Inputs:	none
	Outputs:	none
	Returns:	none
	
	
Description
This user provided open hook routine is called by all SH LIB routines when exiting a critical code region to re-enable the execution of potentially conflicting routines.

oh_writeRegister 
	Write Byte into specified SH hardware register.
	

	Name	SH_STATUS oh_writeRegister (sc4000_type sc4000, SH_UINT8 iar, SH_UINT8 csr, SH_UINT8 lbdr, SH_UINT8 hbdr)
	Inputs:	sc4000_type sc4000 	Identifier (base address) for the specific SH registered via the sh_open routine.
		SH_UINT8 iar	Value for the internal address register. 
		SH_UINT8 csr 	Value for the configuration status register.
		SH_UINT8 lbdr	Value to be written to the SH microprocessor interface low byte data register.
		SH_UINT8 hbdr	Value to be written to the SH microprocessor interface high byte data register.
	Outputs:	none
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_BAD_REG_ID	Invalid register id.

	
	
Description
This user provided open hook routine is called by other SH LIB routines to write into the specified microprocessor interface registers of the SH hardware.
Note:  
The SH library provides this function for hardware platforms which has designed the SH hardware microprocessor interface register as memory mapped addresses.  For other designs such as memory mapped I/O, the user must code their specific oh_writeRegister function and generate the SH library object files.
This routine calls the user open hook routines oh_enterCriticalRegion and oh_exitCriticalRegion in order to delay the execution of potentially conflicting routines while it is executing critical region code.

oh_readRegister
	Read from specified SH hardware register.
	

	Name	SH_STATUS oh_readRegister(sc4000_type sc4000, SH_UINT8 iar, SH_UINT8 csr, SH_UINT8 *lbdr, SH_UINT8 *hbdr)
	Inputs:	sc4000_type sc4000 	Identifier (base address) for the specific SH registered via the sh_open routine.
		SH_UINT8 iar	Value for the internal address register. 
		SH_UINT8 csr 	Value for the configuration status register.
	Outputs:	SH_UINT8 * lbdr	Contents of SH microprocessor interface low byte data register.
		SH_UINT8 * hbdr	Contents of SH microprocessor interface high byte data register.
	Returns:	SH_STATUS_DONE  	if success
		SH_SHLIB_BUSY 	SH library is busy processing  another request.
		SH_BAD_SH_ID 	Invalid SH identifier.
		SH_NO_SH_PRESENT 	SH is not present.
		SH_BAD_REG_ID	Invalid register id.

	
	
Description
This user provided open hook routine is called by other SH LIB routines to read from the specified microprocessor interface registers of the SH hardware.
Note:  
The SH library provides this function for hardware platforms which has designed the SH hardware microprocessor interface register as memory mapped addresses.  For other designs such as memory mapped I/O, the user must code their specific function and generate the SH library object files. 
This routine calls the user open hook routines oh_enterCriticalRegion and oh_exitCriticalRegion in order to delay the execution of potentially conflicting routines while it is executing critical region code.


Definitions
Configuration Definitions

Configuration parameter definitions are used with the sh_writeParm function. 
Note: The default values and value settings are enforced by the SH LIB software and do not necessarily correspond to hardware defaults.

		

*/
	
/* Configuration Parameter Definitions */

/* Description
Parameter ID
Valid Values */

/*  Enables the SC4000 to start or stop being the SCbus Clock Master. */
#define SCBUS_CLK_MASTER (0+(1<<8))
/* Default = Disabled */
#define SH_DISABLED 0
#define SH_ENABLED 1

/* Arm for SCbus Master. When a SC4000 is armed and CLKFAIL =1 the C_0 bit is automatically set. The SC4000 begins driving the SCbus within 4 Clocks of CLKFAIL going high. */
#define SCBUS_CLK_MASTER_ARM (1+(1<<8))
/* Default = Disarmed */
#define SH_MCLK_DISARM 0
#define SH_MCLK_ARM 1

/* SCbus Clock incorporates the two parameters SCbus Clock Master and Arm for SCbus Master */
#define SCBUS_CLOCK (0+(2<<8))
#define SH_CLOCK_SLAVE 0
#define SH_CLOCK_PRIMARY 1
#define SH_CLOCK_SECONDARY 2
#define SH_CLOCK_NEW_PRIMARY 3

/* SCbus Primary/Alternate Select. The SC4000 provides Alternate SCbus signals for fault tolerance. Selection of which signals are used internally by the SC4000 is controlled by this bit. */
#define SCBUS_PRI_ALT_SELECT (2+(1<<8))
/* Default = Primary */
#define SH_SCBUS_PRIMARY 0
#define SH_SCBUS_ALTERNATE 1

/* In Diagnostic Mode the SCbus output drivers and receivers are electrically disconnected from the SCbus and internally the SCbus outputs are looped back to their corresponding inputs. */
#define DIAGNOSTIC_MODE (3+(1<<8))
/* Default = Enabled */
#define SH_DIAG_DISABLED  SH_DISABLED 
#define SH_DIAG_ENABLED SH_ENABLED 

/* SCbus Framing Mode */
#define SCBUS_FRAMING (4+(2<<8))
/* Default = 2.048 Mb/s, 256 Bits/Frame, 32 Time-Slots/Frame */
#define SH_SCBUS_2048KBPS 0
#define SH_SCBUS_4096KBPS 2
#define SH_SCBUS_8192KBPS 3

/* Local Bus Framing Mode */
#define LOCBUS_FRAMING (6+(2<<8))
/* Default = 2.048 Mb/s, 256 Bits/Frame, 32 Time-Slots/Frame */
#define SH_LOCBUS_2048KBPS 0
#define SH_LOCBUS_4096KBPS 2
#define SH_LOCBUS_8192KBPS 3

/* Master Clock Input Frequency Select  */
#define MASTCLK_INP_FREQ (8+(3<<8))
/* Default = 2.048 Mhz*/
#define SH_MCLK_2048KHZ 0
#define SH_MCLK_4096KHZ 1
#define SH_MCLK_8192KHZ 2 
#define SH_MCLK_16384KHZ 3
#define SH_MCLK_32768KHZ 4
#define SH_MCLK_65536KHZ 5

/*Direct R/W to Parallel Access Registers Enable */
#define RW_PARALLEL_ACCESS (11+(1<<8))
/* Default = Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Message Channel Registered TXD Enable */
#define MC_REGISTERED_TXD (12+(1<<8))
/* Default = TXD Passed Through onto MC */
#define SH_TXD_PASSED_THRU 0
#define SH_TXD_REGISTERED 1

/* Message Channel TXD_0 (External HDLC Controller) or TXD_1 (Future Internal HDLC Controller) Select */
#define MC_TXD_SELECT (13+(1<<8))
/* Default = TXD_0 External HDLC Controller */
#define SH_TXD_0  0
#define SH_TXD_1  1

/* Message Channel Clock Duty Cycle Select */
#define MC_CLOCK_DUTY_CYCLE (14+(1<<8))
/* Default = 50% */
#define SH_50_PERCENT_DUTY 0
#define SH_75_PERCENT_DUTY 1

/* Message Channel Output Disable (W/ Loopback) */
#define MC_OUTPUT_DISABLE (15+(1<<8))
/* Default = Message Channel Output Enabled */
#define SH_MC_OUT_ENABLE 0
#define SH_MC_OUT_DISABLE 1

/* SCbus SD Sample Position */
#define SCBUS_SAMPLE_POSITION (16+(1<<8))
/* Default = 50% */
#define SH_SAMPLE_50_PERCENT 0
#define SH_SAMPLE_75_PERCENT 1

/* Local Bus SI Sample Position  */
#define LOCBUS_SAMPLE_POSITION (17+(1<<8))
/* Default = 50% */
#define SH_SAMPLE_50_PERCENT 0
#define SH_SAMPLE_75_PERCENT 1

/* SCbus SD Output Delay Enable - When enabled SCbus SD Outputs are delayed when coming out of tri-state to avoid bus contention. */
#define SCBUS_SD_OUTPUT_DELAY (18+(1<<8))
/* Default = SCbus SD Output Delay Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Local bus SO Output Delay Enable - When enabled Local bus SO Outputs are delayed when coming out of tri-state to avoid bus contention.*/
#define LOCBUS_SO_OUTPUT_DELAY (19+(1<<8))
/* Default = Local bus SO Output Delay Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus FSYNCN Sample Position */
#define FSYNCN_SAMPLE_POSITION (20+(1<<8))
/* Sample at rising edge of SCLK (Default) */
#define SH_RISING_EDGE_SCLK 0 
/* Sample at rising edge of SCLKX2N with SCLK high */
#define  SH_RISING_EDGE_SCLKX2N 1

/* SCbus FSYNCN Rate determines the clock with which the FSYNCN signal is generated. */
#define FSYNCN RATE (21+(1<<8))
/* Default = SCLK period */
#define SH_SCLK_PERIOD  0 
#define SH_SCLKX2N_PERIOD 1

/* SCbus SCLKX2N, SCLKX2NA Output Disable - This bit Disables the SCLKX2N and SCLKX2NA Outputs when they are not required. When disabled the Outputs are tri-stated.*/
#define SCLKX2N_SCLKX2NA_OUTPUT (22+(1<<8))
/* Default = SCLKX2N and SCLKX2NA Outputs Enabled */
#define SH_SCLKX2N_SCLKX2NA_ENABLE 0 
#define SH_SCLKX2N_SCLKX2NA_DISABLE 1

/* SCbus Alternate ("A") Signals Output Enable - This bit Enables  the SCbus Alternate ("A") Signals Output when required. When disabled the Outputs are tri-stated. */
#define SCBUS_ALT_SIGNALS_OUTPUT (23+(1<<8))
/* Default = SCbus Alternate ("A") Signals Output Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Local bus L_CLK Polarity */
#define LOCBUS_L_CLK_POLARITY (24+(1<<8))
/* Default = L_CLK Non-Inverted */
#define SH_L_CLK_NON_INVERTED 0
#define SH_L_CLK_INVERTED 1

/* Local bus L_FS Polarity */
#define LOCBUS_L_FS_POLARITY (25+(1<<8))
/* Default = L_FS Non-Inverted */
#define SH_L_FS_NON_INVERTED 0
#define SH_L_FS_INVERTED 1

/* Local bus L_FS Position */
#define LOCBUS_L_FS_POSITION (26+(2<<8))
/* L_FS occurs during the last clock period of the frame (Default) */
#define SH_L_FS_LAST_CLOCK 0
/* L_FS straddles the frame boundary */
#define SH_L_FS_STRADDLES 1
/* L_FS occurs during the first clock period of the frame */
#define SH_L_FS_FIRST_CLOCK 2

/* Local bus L_CLK & L_FS Rate */
#define LOCBUS_L_CLK_L_FS_RATE (28+(1<<8))
/* L_CLK & L_FS equal to the Local bus data rate (Default) */
#define SH_L_CLK_AT_LOCBUS_RATE 0
/* L_CLK & L_FS equal to 2 times the Local bus data rate */
#define SH_L_CLK_AT_2X_LOCBUS_RATE 1

/* Local bus L_CLK DPLL Enable - This mode is provided to maintain a continuous L_CLK for Network Interfaces during a Clock Fail condition. */
#define LOCBUS_L_CLK_DPLL (29+(1<<8))
/* Default = L_CLK DPLL disabled */
#define SH_L_CLK_DPLL_DISABLED 0
#define SH_L_CLK_DPLL_ENABLED 1

/* Local bus L_CLK 8.192 MHz 62.5% Duty Cycle */
#define L_CLK_8192_625_DUTY_CYCLE (30+(1<<8))
/*L_CLK 8.192 MHz 62.5% Duty Cycle Disabled (Default) */
#define SH_L_CLK_62_5_DUTY_DISABLED 0
/* L_CLK 8.192 MHz 62.5% Duty Cycle Enabled */
#define SH_L_CLK_62_5_DUTY_ENABLED 1

/* Version Field-Revision Field - The Version/Revision Register is a Read Only Register. It intended to be used to identify SCxxxx devices. This field would be changed on future SCxxxx designs. It is recommended that a test of this field be included in all firmware interface code. */
#define SH_REVISION_FIELD (32+(4<<8))
#define SH_VERSION_FIELD (36+(4<<8))
#define SH_VERSION_REVISION_REG 32+(8<<8)


/* Master PLL Reference Select */
#define MASTER_PLL_REF_SELECT (40+(4<<8))
/* Default = Internal Master PLL Free-Run */
/* for the selection of Internal Master PLL */
#define SH_INT_PLL_FREE_RUN 0
#define SH_INT_PLL_SREF_8K    3
#define SH_INT_PLL_REF_8K_0   4
#define SH_INT_PLL_REF_8K_1   5
#define SH_INT_PLL_REF_8K_2   6
#define SH_INT_PLL_REF_8K_3   7
/* For the selection of External Master PLL which is output on REF_8K_Out pin 7.*/
#define SH_EXT_PLL_FREE_RUN   8
#define SH_EXT_PLL_SREF_8K   11
#define SH_EXT_PLL_REF_8K_0   12
#define SH_EXT_PLL_REF_8K_1   13
#define SH_EXT_PLL_TRI_STATE   14

/* SCbus SREF_8K Source Select */
#define SCbus_SREF_8K_Source  (44+(2<<8))
/* Default value is REF_8K_0 */
#define REF_8K_0    0
#define REF_8K_1    1
#define REF_8K_2    2
#define REF_8K_3    3

/* SCbus SREF_8K Output Enable */
#define SCbus_SREF_8K_Output   (46+(1<<8))
/* Default value is SH_SREF_8K_DISABLED */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SCLK 8.192 MHz 62.5% Duty Cycle */
#define SCLK_8192_625_DUTY_CYCLE (47+(1<<8))
/* Default = L_CLK 8.192 MHz 62.5% Duty Cycle Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Clock Watchdog Enable - When enabled the Clock Watchdog will read-back a 1 until the Master PLL clocks for 125us(+/- 50%) then it will read-back a 0. This mode is provided to allow the detection of a missing PLL clock. This information can then be used to take a master off the bus or remove a secondary clock master from the fallback list. The Clock Watchdog must be rearmed after each test. To rearm the Clock Watchdog  must be cleared  (disabled) and then reset (enabled).*/
#define CLOCK_WATCHDOG    (48+(1<<8))
/* Default = Clock Watchdog Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Micro Processor Watchdog Enable - When enabled the SC4000 will be put into reset after the Master PLL clocks for 256ms (+/- 50%). This mode is provided to force an SC4000 off the SCbus when it's controlling Micro Processor fails to reset the watchdog. Each time the watchdog is cleared  (disabled) and then set (enabled), the watchdog count is reset. */
#define MICRO_PROCESSOR_WATCHDOG (49+(1<<8))
/* Default value is SH_MP_WATCHDOG_DISABLED */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus CLKFAIL Latch Set Polarity Select - This bit selects the Polarity of the SCbus CLKFAIL signal that will set the CLKFAIL Latch. */
#define CLKFAIL_LATCH_POLARITY (50+(1<<8))
/* Default value is SH_CLKFAIL_LATCH_LOW */
/* CLKFAIL Latch set when CLKFAIL = 0 */
#define SH_CLKFAIL_LATCH_LOW    0
/* CLKFAIL Latch set when CLKFAIL = 1 */
#define SH_CLKFAIL_LATCH_HIGH    1

/* SCbus CLKFAIL Latch Debounce Enable */
#define CLKFAIL_LATCH_DEBOUNCE (51+(1<<8))
/* Default = CLKFAIL Latch Debounce Disabled */
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Frame Boundary Latch Set Delay Enable - With Direct W/R to Parallel Access Registers Enabled, using the delayed frame boundary interrupt indicates that it is now safe to read and write to the Parallel Access Registers. All access must be complete 8 internal clocks before the next delayed frame boundary interrupt to avoid data corruption. */
#define FRAME_BOUNDARY_LATCH_DELAY  ((52+1<<8))
/* Default value is Frame Boundary Latch Set at frame boundary - no delay */
#define SH_FB_LATCH_SET_NO_DELAY    0
/* Frame Boundary Latch Set is delayed until after the input buffer to output buffer transfer is complete (4 internal clocks after frame boundary). */


/* INT_0 Mask_N - Clearing this bit ("0") masks INT_0. INT_0 is the logical OR of CLKFAIL (C_56), Frame Boundary (C_57), Internal Master PLL Error (C_58) Latches and SCbus Error (C_59) Indicator. 
The INT_0 Mask bit can be used to globally disable Interrupt generation while the state of the Latch's can continue to be polled through the Microprocessor interface. This bit can also be used to create edge triggered interrupts.*/

#define INT_0_MASK_N    (53+(1<<8))
/* Default value is INT_0 Masked (Disabled)*/
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* INT_0 Output Polarity */
#define INT0_OUTPUT_POLARITY (54+(1<<8))
/* Default = INT_0 Active Low */
#define SH_INT0_ACTIVE_LOW 0
#define SH_INT0_ACTIVE_HIGH 1

/* INT_0 Output Driver */
#define INT0_OUTPUT_DRIVER (55+(1<<8))
/* Default = Open Collector INT_0 Output Driver */
#define SH_Open_Collector  0
#define SH_Totem_Pole 1

/* SCbus CLKFAIL Latch (read only)*/
#define SCBUS_CLKFAIL (56+(1<<8))
#define SH_ERR_LATCH_CLEAR 0
#define SH_ERR_LATCH_SET 1

/* Frame Boundary Latch (read only)*/
#define FRAME_BOUNDARY (57+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* Internal Master PLL Error Latch (read only) */
#define MASTER_PLL_ERR (58+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus Error Indicator - (read only) This is the logical OR of the eleven error latch bits: C_[67:64], C_[74:72] and C_[83:80] */
#define SCBUS_ERR_INDICATOR (59+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus CLKFAIL Latch Clear - When disabled, this holds the SCbus CLKFAIL latch in the clear state. When enabled, the SCbus CLKFAIL latch is set if a clock failure occurs. */
#define SCBUS_CLKFAIL_LATCH (60+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Frame Boundary Latch Clear - When disabled, this holds the Frame Boundary latch in the clear state. When enabled, the Frame Boundary latch is set if a frame boundary error occurs. */
#define FRAME_BOUNDARY_LATCH  (61+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* Master PLL Error Latch Clear - When disabled, this holds the SCbus CLKFAIL latch in the clear state. When enabled, the SCbus CLKFAIL latch is set if a clock failure occurs. */
#define MASTER_PLL_ERR_LATCH (62+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SCLKX2N Error Latch - (read only) The SCbus SCLKX2N Error Latch is set when SCLKX2N does not transition during the equivalent Master PLL clock period */
#define SCLKX2N_ERR (64+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus SCLKX2NA Error Latch - (read only) The SCbus SCLKX2NA Error Latch is set when SCLKX2NA does not transition during the equivalent Master PLL clock period. */
#define SCLKX2NA_ERR (65+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus SCLK Error Latch - (read only) The SCbus SCLK Error Latch is set when SCLK does not transition during the equivalent Master PLL clock period. */
#define SCLK_ERR (66+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus SCLKA Error Latch - (read only) The SCbus SCLKA Error Latch is set when SCLKA does not transition during the equivalent Master PLL clock period. */
#define SCLKA_ERR (67+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus SCLKX2N Error  Latch Clear - When disabled, this holds the SCbus SCLKX2N Error latch in the clear state. When enabled, the SCbus SCLKX2N Error latch is set if an SCLKX2N Error occurs. */
#define SCLKX2N_ERR_LATCH (68+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SCLKX2NA Error  Latch Clear - When disabled, this holds the SCbus SCLKX2NA Error latch in the clear state. When enabled, the SCbus SCLKX2NA Error latch is set if an SCLKX2NA Error occurs. */
#define SCLKX2NA_ERR_LATCH (69+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SCLK Error  Latch Clear - When disabled, this holds the SCbus SCLK Error latch in the clear state. When enabled, the SCbus SCLK Error latch is set if an SCLK Error occurs. */
#define SCLK_ERR_LATCH (70+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SCLKA Error  Latch Clear - When disabled, this holds the SCbus SCLKA Error latch in the clear state. When enabled, the SCbus SCLKA Error latch is set if an SCLKA Error occurs. */
#define SCLKA_ERR_LATCH (71+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus FSYNCN Error Latch - (read only) The SCbus FSYNCN Error Latch is set when FSYNCN does not transition during the equivalent Master PLL clock period */
#define FSYNCN_ERR (72+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus FSYNCNA Error Latch - (read only) The SCbus FSYNCNA Error Latch is set when FSYNCNA does not transition during the equivalent Master PLL clock period */
#define FSYNCNA_ERR (73+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* The SCbus Clock Master Error Latch (read only) is set when the SC4000 is configured to be Clock Master and the internally generated frame sync signal and SCbus FSYNCN do not compare. This feature is provided to detect when more than 1 SCbus device is enabled as Clock Master (i.e. 2 devices driving FSYNCN). */
#define CLOCK_MASTER_ERR  (74+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus FSYNCN Error  Latch Clear - When disabled, this holds the SCbus FSYNCN Error latch in the clear state. When enabled, the SCbus FSYNCN Error latch is set if an FSYNCN Error occurs. */
#define FSYNCN_ERR_LATCH (76+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus FSYNCNA Error  Latch Clear - When disabled, this holds the SCbus FSYNCNA Error latch in the clear state. When enabled, the SCbus FSYNCNA Error latch is set if an FSYNCNA Error occurs. */
#define FSYNCNA_ERR_LATCH (77+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus Clock Master Error  Latch Clear - When disabled, this holds the SCbus Clock Master Error latch in the clear state. When enabled, the SCbus Clock Master Error latch is set if an Clock Master Error occurs. */
#define CLOCK_MASTER_ERR_LATCH (78+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SREF_8K NE SREF_8KA Error Latch - (read only) The SCbus SREF_8K NE SREF_8KA Error Latch is set when SREF_8K and SREF_8KA do not compare for three consecutive Master PLL clocks.*/
#define SREF_8K_NE_SREF_8KA_ERR (80+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus CLKFAIL NE CLKFAILA Error Latch - (read only) The SCbus CLKFAIL NE CLKFAILA Error Latch is set when CLKFAIL and CLKFAILA do not compare for three consecutive Master PLL clocks.*/
#define CLKFAIL_NE_CLKFAILA_ERR (81+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus MC NE MCA Error Latch - (read only) The SCbus MC NE MCA Error Latch is set when MC and MCA do not compare. MC_CLK is used to sample the comparison. */
#define MC_NE_MCA_ERR (82+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus SD Error Indicator - (read only) This indicator is set when one or more of the SD Error Latches are set */
#define SD_ERROR_INDICATOR (83+(1<<8))
/* Valid values are:
      SH_ERR_LATCH_CLEAR
      SH_ERR_LATCH_SET 
*/

/* SCbus SREF_8K NE SREF_8KA Error  Latch Clear - When disabled, this holds the SCbus SREF_8K NE SREF_8KA Error latch in the clear state. When enabled, the SCbus SREF_8K NE SREF_8KA Error latch is set if an SREF_8K NE SREF_8KA Error occurs. */
#define SREF_8K_ERR_LATCH_ENABLE (84+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus CLKFAIL NE CLKFAILA Error  Latch Clear - When disabled, this holds the SCbus CLKFAIL NE CLKFAILA Error latch in the clear state. When enabled, the SCbus CLKFAIL NE CLKFAILA Error latch is set if an CLKFAIL NE CLKFAILA Error occurs. */
#define CLKFAIL_ERR_LATCH_ENABLE (84+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus MC NE MCA Error  Latch Clear - When disabled, this holds the SCbus MC NE MCA Error latch in the clear state. When enabled, the SCbus MC NE MCA Error latch is set if an MC NE MCA Error occurs. */
#define MC_ERR_LATCH_ENABLE (84+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SD Error Latch Clear - When disabled, this holds all sixteen SD Error latches in the clear state. When enabled, the particular SD Error latch is set if a corresponding error occurs. */
#define SD_ERR_LATCH_ENABLE (84+(1<<8))
/* Valid values are:
      SH_DISABLED 
      SH_ENABLED 
*/

/* SCbus SD_[15:0] Error Latch - The sixteen read-only bits, corresponding to the sixteen SD Error latches are accessed by the parameter ids SD_7_0_ERR_LATCHES for latches 0 to 7 and SD_15_8_ERR_LATCHES for latches 8 to 15. An SCbus SD Error Latch is set when an SD output timeslot is enabled and the internally generated SD signal and SCbus SD do not compare. This feature is provided to detect when more than 1 SCbus device is enabled on the same timeslot. All SCbus SD Error Latches are enabled and cleared by SCbus SD Error Latch Clear. */
#define SD_7_0_ERR_LATCHES  (88+(8<<8))
#define SD_15_8_ERR_LATCHES  (96+(8<<8))
/* A value of zero indicates that no error has been detected. Any other value indicates an error. */






/*


Return Status Codes
*/
/* Return Status Codes */

typedef enum {

/* Successful completion */
SH_STATUS_DONE,

/* Diagnostic mode value out-of-range. */
SH_BAD_DIAG_MODE,

/* Local bus framing mode value out-of-range. */
SH_BAD_LOCBUS_FR_MODE,

/* Master clock input frequency value out-of-range. */
SH_BAD_MCLK_INP_FREQ,

/* Invalid parameter id. */
SH_BAD_PARMID,

/* Invalid parameter value */
SH_BAD_PARMVAL,

/* SCbus framing mode value out-of-range. */
SH_BAD_SCBUS_FR_MODE,

/* SCbus mode value out-of-range. */
SH_BAD_SCBUS_MODE,

/* Invalid SH identifier. */
SH_BAD_SH_ID,

/* Invalid external timeslot parameter. */
SH_INVALID_EXTERNAL_TIMESLOT,

/* Invalid local timeslot parameter. */
SH_INVALID_LOCAL_TIMESLOT,

/* Invalid parallel access readconnection type. */
SH_INVALID_READ_TYPE,

/* Invalid connection type. */
SH_INVALID_TYPE,

/* Local timeslot already connected. */
SH_LOCAL_TS_CONNECTED,

/* SH is currently not a primary or secondary clock master */
SH_MCLK_NOT_ENABLED,

/* SH is not present. */
SH_NO_SH_PRESENT,

/* Another clock has already been set to primary mode */
SH_PREVIOUS_CLOCK_PRIMARY,

/* Invalid clock mode selected */
SH_BAD_CLOCK_MODE,

/* Clock Reference out-of-range */
SH_BAD_CLOCK_REF,

/* 	SH library is busy processing  another request. */
SH_SHLIB_BUSY,

/* Can not reset SH hardware. */
SH_STATUS_ERROR,

/* SH hardware busy status bit does not reset */
SH_BUSY_RESET_ERROR

} SH_STATUS;


/*
General Definitions
*/
/* General Definitions */

/* Specify all timeslots. This definition is used by sh_enableParallelAccess and sh_disableParallelAccess */
#define  SH_ALL_TIMESLOTS  0xff

/* Local Connection indicator. This definition is used by sh_connectToLocal  and sh_readLocalConnection. */
#define LOCTS_TO_LOCTS 0x10

/* External to Local Connection indicator. This definition is used by sh_connectToLocal  and sh_readLocalConnection. */
#define EXTTS_TO_LOCTS 0x20

/* Parallel Access read-type indicator, for either the Transmit Parallel Access register or the Receive Parallel Access register. This definition is used by sh_readParallelAccess. */
#define SH_PARALLEL_TRANSMIT  0xc0
#define SH_PARALLEL_RECEIVE  0xe0

/* Destination Routing Memory Registers base address */
#define DESTINATION_ROUTING_MEMORY 0x80

/* Source Routing Memory Registers base address */
#define SOURCE_ROUTING_MEMORY 0xA0

/* Destination Parallel Access Registers base address */
#define DESTINATION_PARALLEL_ACCESS 0xC0

/* Source Parallel Access Register base address */
#define SOURCE_PARALLEL_ACCESS 0xE0

/* Configuration Status Register busy bit mask */
#define CSR_BUSY_BIT 0x01

/* Configuration Status Register read command bit mask */
#define CSR_READ_COMMAND 0x02

/* Configuration Status Register write command bit mask */
#define CSR_WRITE_COMMAND 0x04

/* Channel Bank Select Regeister Enable bit mask */
#define CSR_CBSR_ENABLE 0x40

/* Configurarion Status Register Reset bit mask */
#define CSR_RESET_BIT 0x80

/* Channel Bank Select Register bit mask */
#define CSR_CBSR 0x30













 
  

/*
Data Types
*/
typedef unsigned char		SH_UINT8;
typedef unsigned char		*SH_ADDR;
typedef unsigned int 		SH_UINT16;
typedef unsigned int 		SH_ID;
typedef struct {
   volatile SH_UINT8   csr;
   volatile SH_UINT8   iar;
   volatile SH_UINT8   lbdr;
   volatile SH_UINT8   hbdr;
} sc4000_type;
typedef sc4000_type * p_sc4000_type;
/* (Note: On memory segmented processors, pointers must be declared to be of the type "far" if the large 			memory model is not selected for the user's firmware compilation.) 
Function Prototypes
*/
SH_STATUS sh_connectToExternal ( SH_ID id, SH_UINT8 localTs, SH_UINT16 extts);
SH_STATUS sh_connectToLocal ( SH_ID id, SH_UINT8 localTs,  SH_UINT16 sourceTs, SH_UINT8 sourceType);
SH_STATUS sh_disableDiagnosticMode (SH_ID id);
SH_STATUS sh_disableParallelAccess (SH_ID id, SH_UINT8 localTs);
SH_STATUS sh_disconnectExternal (SH_ID id, SH_UINT8 localTs);
SH_STATUS sh_disconnectLocal (SH_ID id, SH_UINT8 localTs);
SH_STATUS sh_enableDiagnosticMode (SH_ID id);
SH_STATUS sh_enableParallelAccess (SH_ID id, SH_UINT8 localTs);
SH_STATUS sh_init (SH_ID id);
SH_STATUS sh_open (SH_ID * pId, SH_ADDR sh_baseAddress);
SH_STATUS sh_readBusConfig (SH_ID id, SH_UINT8  * pSCbusMode, SH_UINT8  * pDiagMode, 
	SH_UINT8  * pSCbusFrMode, SH_UINT8  * pLocBusFrMode, 
	SH_UINT8  * pInputClockFreq);
SH_STATUS sh_readClockMode (SH_ID id, SH_UINT8 * pClockMode);
SH_STATUS sh_readClockRef (SH_ID id, SH_UINT8 * pClockRef);
SH_STATUS sh_readSREFOut (SH_ID id, SH_UINT8 * pMode, SH_UINT8 * pClockRef);
SH_STATUS sh_readExternalConnection (SH_ID id, SH_UINT8 localTs, SH_UINT16 * pExtts);
SH_STATUS sh_readLocalConnection (SH_ID id, SH_UINT8 localTs, SH_UINT16 * pSourceTs, 
	SH_UINT8 * pSourceType);
SH_STATUS sh_readParallelAccess (SH_ID id, SH_UINT8 read_type, SH_UINT8 localTs, 
	SH_UINT8 * pdata);
SH_STATUS sh_readParm ( SH_ID id, SH_UINT16 parameter_id, SH_UINT8 * pvalue);
SH_STATUS sh_setBusConfig (SH_ID id,  SH_UINT8 SCbusMode, SH_UINT8 diagMode, SH_UINT8 SCbusFrMode,
	SH_UINT8 locBusFrMode,SH_UINT8 mclkInpFreq);
SH_STATUS sh_setClockMode (SH_ID id, SH_UINT8 clockMode);
SH_STATUS sh_setClockRef  (SH_ID id, SH_UINT8 clockRef);
SH_STATUS sh_enableSREFOut(SH_ID id, SH_UINT8 clockRef);
SH_STATUS sh_disableSREFOut(SH_ID id);
SH_STATUS sh_version (SH_ID id, SH_UINT8 * pVersion);
SH_STATUS sh_writeParallelAccess (SH_ID id, SH_UINT8 localTs,  SH_UINT8 data);
SH_STATUS sh_writeParm ( SH_ID id, SH_UINT16 parameter_id, SH_UINT8 value);
SH_STATUS oh_checkClock (SH_UINT8 clksrc);
void oh_enterCriticalRegion ();
void oh_exitCriticalRegion ();
SH_STATUS oh_writeRegister (sc4000_type *sc4000, SH_UINT8 iar, SH_UINT8 csr, SH_UINT8 lbdr, SH_UINT8 hbdr);
SH_STATUS oh_readRegister (sc4000_type *sc4000, SH_UINT8 iar, SH_UINT8 csr, SH_UINT8 *lbdr, SH_UINT8 *hbdr);
SH_STATUS oh_writeRegisterBusy (sc4000_type *sc4000, SH_UINT8 iar, SH_UINT8 csr, SH_UINT8 lbdr, SH_UINT8 hbdr);
SH_STATUS oh_readRegisterBusy (sc4000_type *sc4000, SH_UINT8 iar, SH_UINT8 csr, SH_UINT8 *lbdr, SH_UINT8 *hbdr);

/*SC4000 Interface Library  
Revision  SWS-0312 - B*/


/*Intel Confidential
35 of 58*/


#endif  /* _SC4KAPI_H */

