/*****************************************************************************
 * FILE:  scroute.h
 * ***************************************************************************/

#ifndef __SCROUTE__
#define __SCROUTE__

#define MAXTSLOTSPERB  128

/*
 * Type definition for SCBus Timeslots information structure.
 */
#ifndef __SC_TSINFO__
#define __SC_TSINFO__
typedef struct sc_tsinfo {
   unsigned long  sc_numts;
   long          *sc_tsarrayp;
} SC_TSINFO;
#endif

typedef struct _dcd_gettslots {
  int        gt_number;
  SC_TSINFO  gt_tslots[MAXTSLOTSPERB];
} sc_tslot_t;

/* 
 * Routeing function interface for libscroute
 */
int sc_register(int *, char *, int (*)(void *, SC_TSINFO *), int (*)(void *, SC_TSINFO *),
		int (*)(void *, SC_TSINFO *), int (*)(void *), int (*)(void *, void *));
int sc_getxmitslot(void *, int, SC_TSINFO *);
int sc_listen(void *, int, SC_TSINFO *);
int sc_unlisten(void *, int);
int sc_route(void *, int, void *, int, int);

/*
 * Time slot allocation and deallocation functions
 */
int sc_alloctimeslot(SC_TSINFO *);
int sc_alloctimeslots(int Count, sc_tslot_t *);
int sc_dealloctimeslot(SC_TSINFO *);
int sc_dealloctimeslots(int Count, sc_tslot_t *);

#endif /*  __SCROUTE__ */


