
/*
 * This file was automatically generated from sd_defs.txt.
 * Author: "Chris Chuba"
 * Version: "Revision 23"
 * Date: Tue Mar 11 10:32:29 2003
 * The output was written to sd_defs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_sd_defs_h_)
#define _sd_defs_h_ 1
/* This file describes the list of Mercury messages, parameters and equates 
 * supported by the Mercury Signal Event Detector Component and its Instances. */
/*
 * Mercury Component Type Definition
 */
/*
 * The Signal Event Detector uses messages from the standard Kernel message set
 * and the standard Component message set.  The terse name sd (Signal Detector) 
 * is used because many field definitions in the generated .H file have the 
 * following format: compName_messageName_fieldName while there is a 
 * 32 character limit for the entire string.
 */
/*
 * 	Standard Component message set. These are documented in stddefs.doc.
 * 	*/

/*
 * COMPONENT SD (value = 0x7) uses:
 *	MESSAGE Std_MsgArmRTC
 *	MESSAGE Std_MsgArmRTCCmplt
 *	MESSAGE Std_MsgDisarmRTC
 *	MESSAGE Std_MsgDisarmRTCCmplt
 *	MESSAGE Std_MsgDetectEvt
 *	MESSAGE Std_MsgDetectxEvts
 *	MESSAGE Std_MsgDetectEvtCmplt
 *	MESSAGE Std_MsgDetectxEvtsCmplt
 *	MESSAGE Std_MsgEvtDetected
 *	MESSAGE Std_MsgCancelEvt
 *	MESSAGE Std_MsgCancelxEvts
 *	MESSAGE Std_MsgCancelEvtCmplt
 *	MESSAGE Std_MsgCancelxEvtsCmplt
 *	MESSAGE Std_MsgError
 *	MESSAGE Std_MsgInit
 *	MESSAGE Std_MsgInitCmplt
 *	MESSAGE Std_MsgSetParm
 *	MESSAGE Std_MsgSetParmCmplt
 *	MESSAGE Std_MsgGetParm
 *	MESSAGE Std_MsgGetParmCmplt
 *	MESSAGE Std_MsgComtest
 *	MESSAGE Std_MsgComtestCmplt
 */
/* 
 * Signal Event Detector Message Definitions
 */

/*
 * SD_MsgFlushSignals (value = 0x700) is an output message
 * for component SD.
 */

#define SD_MsgFlushSignals_Size		0

#define SD_MsgFlushSignals	0x700	/* 1792 */

/*
 * SD_MsgFlushSignalsCmplt (value = 0x701) is an output message
 * for component SD.
 */

#define SD_MsgFlushSignalsCmplt_Size		0

#define SD_MsgFlushSignalsCmplt	0x701	/* 1793 */
/* The 32-bit signal Id */

#define SD_MsgCreateTone_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateTone_Id_t;
/* The signal label */

#define SD_MsgCreateTone_label	0x201804	/* 2103300 */
typedef	UInt8	SD_MsgCreateTone_label_t[4];
/* The number of times the segment list must repeat before signal on event*/

#define SD_MsgCreateTone_repCount	0x200008	/* 2097160 */
typedef	UInt8	SD_MsgCreateTone_repCount_t;
/* The number of defined tone template segments.  Must be less than 5  */

#define SD_MsgCreateTone_numOfSegs	0x200009	/* 2097161 */
typedef	UInt8	SD_MsgCreateTone_numOfSegs_t;
/* Reserved.  Must be 0 */

#define SD_MsgCreateTone_rsvd	0x28000a	/* 2621450 */
typedef	UInt16	SD_MsgCreateTone_rsvd_t;
/* handle needed to delete a tone.  Set to 0 to allow anyone to delete tone */

#define SD_MsgCreateTone_DeleteHndl	0x38000c	/* 3670028 */
typedef	UInt32	SD_MsgCreateTone_DeleteHndl_t;

#define SD_MsgCreateTone_varStart	0x10

#define SD_MsgCreateTone_ToneSeg_mask_DualTone	0x1	/* 1 */

#define SD_MsgCreateTone_ToneSeg_mask_Ring	0x2	/* 2 */

#define SD_MsgCreateTone_ToneSeg_mask_Silence	0x4	/* 4 */

#define SD_MsgCreateTone_ToneSeg_mask_DialTone	0x8	/* 8 */

#define SD_MsgCreateTone_ToneSeg_mask_Silence_Postpone	0x10	/* 16 */

#define SD_MsgCreateTone_ToneSeg_mask_Silence_Initial_Time	0x20	/* 32 */
/*Unused bits must be 0.*/
/*SD_ToneSeg_DualTone - If not set, tone will be treated as single tone*/
/*SD_ToneSeg_Ring - This identifies a template used for ring detection for PVD */
/*SD_ToneSeg_Silence - This is a silence on / off template, only the timing 
 * values are relevant */

#define SD_MsgCreateTone_ToneSeg_mask	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_mask_t;
/* The qualification template to use, see SD_SetQualTmplt. */

#define SD_MsgCreateTone_ToneSeg_qtmplt	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgCreateTone_ToneSeg_qtmplt_t;
/* The qualification template to use during playback.*/

#define SD_MsgCreateTone_ToneSeg_pqtmplt	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgCreateTone_ToneSeg_pqtmplt_t;
/* The first tone, the units are in Hz */

#define SD_MsgCreateTone_ToneSeg_tone1MinFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_tone1MinFrq_t;
/* The units are in Hz */

#define SD_MsgCreateTone_ToneSeg_tone1MaxFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_tone1MaxFrq_t;
/* The units are in dBm, lower boundary, values below SD_ParmMinergy are 
 * irrelevant */

#define SD_MsgCreateTone_ToneSeg_tone1MinAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateTone_ToneSeg_tone1MinAmp_t;
/* The units are in dBm , upper boundary*/

#define SD_MsgCreateTone_ToneSeg_tone1MaxAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateTone_ToneSeg_tone1MaxAmp_t;
/* The second tone, the units are in Hz */

#define SD_MsgCreateTone_ToneSeg_tone2MinFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_tone2MinFrq_t;
/* The units are in Hz */

#define SD_MsgCreateTone_ToneSeg_tone2MaxFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_tone2MaxFrq_t;
/* The units are in dBm */

#define SD_MsgCreateTone_ToneSeg_tone2MinAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateTone_ToneSeg_tone2MinAmp_t;
/* The units are in dBm */

#define SD_MsgCreateTone_ToneSeg_tone2MaxAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateTone_ToneSeg_tone2MaxAmp_t;
/* Should be 0 for future compatibility, Expert feature units in Hz*/

#define SD_MsgCreateTone_ToneSeg_fTwinMin	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_fTwinMin_t;
/* Should be 0 .*/

#define SD_MsgCreateTone_ToneSeg_fTwinMax	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_fTwinMax_t;
/* Time in 10ms units, on duration required for tone*/

#define SD_MsgCreateTone_ToneSeg_minOnDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_minOnDuration_t;
/* Time in 10ms units, max. on duration allowed for tone*/

#define SD_MsgCreateTone_ToneSeg_maxOnDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_maxOnDuration_t;
/* Time in 10ms units, off duration required for tone*/

#define SD_MsgCreateTone_ToneSeg_minOffDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_minOffDuration_t;
/* Time in 10ms units, max off duration allowed for tone*/

#define SD_MsgCreateTone_ToneSeg_maxOffDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateTone_ToneSeg_maxOffDuration_t;


typedef struct {
	UInt16	mask;
	UInt8	qtmplt;
	UInt8	pqtmplt;
	UInt16	tone1MinFrq;
	UInt16	tone1MaxFrq;
	Int8	tone1MinAmp;
	Int8	tone1MaxAmp;
	UInt16	tone2MinFrq;
	UInt16	tone2MaxFrq;
	Int8	tone2MinAmp;
	Int8	tone2MaxAmp;
	UInt16	fTwinMin;
	UInt16	fTwinMax;
	UInt16	minOnDuration;
	UInt16	maxOnDuration;
	UInt16	minOffDuration;
	UInt16	maxOffDuration;
} SD_MsgCreateTone_ToneSeg_t;

#define SD_MsgCreateTone_ToneSeg_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 17, &(offset),	\
			(SD_MsgCreateTone_ToneSeg_mask), &((structAddr)->mask),	\
			(SD_MsgCreateTone_ToneSeg_qtmplt), &((structAddr)->qtmplt),	\
			(SD_MsgCreateTone_ToneSeg_pqtmplt), &((structAddr)->pqtmplt),	\
			(SD_MsgCreateTone_ToneSeg_tone1MinFrq), &((structAddr)->tone1MinFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone1MaxFrq), &((structAddr)->tone1MaxFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone1MinAmp), &((structAddr)->tone1MinAmp),	\
			(SD_MsgCreateTone_ToneSeg_tone1MaxAmp), &((structAddr)->tone1MaxAmp),	\
			(SD_MsgCreateTone_ToneSeg_tone2MinFrq), &((structAddr)->tone2MinFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone2MaxFrq), &((structAddr)->tone2MaxFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone2MinAmp), &((structAddr)->tone2MinAmp),	\
			(SD_MsgCreateTone_ToneSeg_tone2MaxAmp), &((structAddr)->tone2MaxAmp),	\
			(SD_MsgCreateTone_ToneSeg_fTwinMin), &((structAddr)->fTwinMin),	\
			(SD_MsgCreateTone_ToneSeg_fTwinMax), &((structAddr)->fTwinMax),	\
			(SD_MsgCreateTone_ToneSeg_minOnDuration), &((structAddr)->minOnDuration),	\
			(SD_MsgCreateTone_ToneSeg_maxOnDuration), &((structAddr)->maxOnDuration),	\
			(SD_MsgCreateTone_ToneSeg_minOffDuration), &((structAddr)->minOffDuration),	\
			(SD_MsgCreateTone_ToneSeg_maxOffDuration), &((structAddr)->maxOffDuration))


#define SD_MsgCreateTone_ToneSeg_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 17, &(offset),	\
			(SD_MsgCreateTone_ToneSeg_mask), &((structAddr)->mask),	\
			(SD_MsgCreateTone_ToneSeg_qtmplt), &((structAddr)->qtmplt),	\
			(SD_MsgCreateTone_ToneSeg_pqtmplt), &((structAddr)->pqtmplt),	\
			(SD_MsgCreateTone_ToneSeg_tone1MinFrq), &((structAddr)->tone1MinFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone1MaxFrq), &((structAddr)->tone1MaxFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone1MinAmp), &((structAddr)->tone1MinAmp),	\
			(SD_MsgCreateTone_ToneSeg_tone1MaxAmp), &((structAddr)->tone1MaxAmp),	\
			(SD_MsgCreateTone_ToneSeg_tone2MinFrq), &((structAddr)->tone2MinFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone2MaxFrq), &((structAddr)->tone2MaxFrq),	\
			(SD_MsgCreateTone_ToneSeg_tone2MinAmp), &((structAddr)->tone2MinAmp),	\
			(SD_MsgCreateTone_ToneSeg_tone2MaxAmp), &((structAddr)->tone2MaxAmp),	\
			(SD_MsgCreateTone_ToneSeg_fTwinMin), &((structAddr)->fTwinMin),	\
			(SD_MsgCreateTone_ToneSeg_fTwinMax), &((structAddr)->fTwinMax),	\
			(SD_MsgCreateTone_ToneSeg_minOnDuration), &((structAddr)->minOnDuration),	\
			(SD_MsgCreateTone_ToneSeg_maxOnDuration), &((structAddr)->maxOnDuration),	\
			(SD_MsgCreateTone_ToneSeg_minOffDuration), &((structAddr)->minOffDuration),	\
			(SD_MsgCreateTone_ToneSeg_maxOffDuration), &((structAddr)->maxOffDuration))


#define SD_MsgCreateTone_ToneSeg_Size		28

#define SD_MsgCreateTone_ToneSeg	0	/* 0 */

/*
 * SD_MsgCreateTone (value = 0x702) is an input message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
	UInt8	label[4];
	UInt8	repCount;
	UInt8	numOfSegs;
	UInt16	rsvd;
	UInt32	DeleteHndl;
} SD_MsgCreateTone_t;

#define SD_MsgCreateTone_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(SD_MsgCreateTone_Id), &((structAddr)->Id),	\
			(SD_MsgCreateTone_label), &((structAddr)->label),	\
			(SD_MsgCreateTone_repCount), &((structAddr)->repCount),	\
			(SD_MsgCreateTone_numOfSegs), &((structAddr)->numOfSegs),	\
			(SD_MsgCreateTone_rsvd), &((structAddr)->rsvd),	\
			(SD_MsgCreateTone_DeleteHndl), &((structAddr)->DeleteHndl))


#define SD_MsgCreateTone_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(SD_MsgCreateTone_Id), &((structAddr)->Id),	\
			(SD_MsgCreateTone_label), &((structAddr)->label),	\
			(SD_MsgCreateTone_repCount), &((structAddr)->repCount),	\
			(SD_MsgCreateTone_numOfSegs), &((structAddr)->numOfSegs),	\
			(SD_MsgCreateTone_rsvd), &((structAddr)->rsvd),	\
			(SD_MsgCreateTone_DeleteHndl), &((structAddr)->DeleteHndl))


#define SD_MsgCreateTone_Size		16

#define SD_MsgCreateTone	0x702	/* 1794 */

#define	SD_MAXNUMSEGS    4
#define	SD_MAXLABELSIZE  4

/*{*/
/*}*/
/*Signal ID*/

#define SD_MsgCreateToneCmplt_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateToneCmplt_Id_t;
/*Signal Set ID*/

#define SD_MsgCreateToneCmplt_setId	0x380004	/* 3670020 */
typedef	UInt32	SD_MsgCreateToneCmplt_setId_t;

/*
 * SD_MsgCreateToneCmplt (value = 0x703) is an output message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
	UInt32	setId;
} SD_MsgCreateToneCmplt_t;

#define SD_MsgCreateToneCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_MsgCreateToneCmplt_Id), &((structAddr)->Id),	\
			(SD_MsgCreateToneCmplt_setId), &((structAddr)->setId))


#define SD_MsgCreateToneCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_MsgCreateToneCmplt_Id), &((structAddr)->Id),	\
			(SD_MsgCreateToneCmplt_setId), &((structAddr)->setId))


#define SD_MsgCreateToneCmplt_Size		8

#define SD_MsgCreateToneCmplt	0x703	/* 1795 */

#define SD_MsgDeleteTone_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeleteTone_Id_t;

#define SD_MsgDeleteTone_DeleteHndl	0x380004	/* 3670020 */
typedef	UInt32	SD_MsgDeleteTone_DeleteHndl_t;

/*
 * SD_MsgDeleteTone (value = 0x704) is an input message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
	UInt32	DeleteHndl;
} SD_MsgDeleteTone_t;

#define SD_MsgDeleteTone_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_MsgDeleteTone_Id), &((structAddr)->Id),	\
			(SD_MsgDeleteTone_DeleteHndl), &((structAddr)->DeleteHndl))


#define SD_MsgDeleteTone_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_MsgDeleteTone_Id), &((structAddr)->Id),	\
			(SD_MsgDeleteTone_DeleteHndl), &((structAddr)->DeleteHndl))


#define SD_MsgDeleteTone_Size		8

#define SD_MsgDeleteTone	0x704	/* 1796 */

/*
 * SD_MsgDeleteToneCmplt (value = 0x705) is an output message
 * for component SD.
 */

#define SD_MsgDeleteToneCmplt_Size		0

#define SD_MsgDeleteToneCmplt	0x705	/* 1797 */

#define SD_MsgSetQualTmplt_QualTmpltId	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgSetQualTmplt_QualTmpltId_t;

#define SD_MsgSetQualTmplt_varStart	0x2

/*
 * SD_MsgSetQualTmplt (value = 0x706) is an input message
 * for component SD.
 */


typedef struct {
	UInt16	QualTmpltId;
} SD_MsgSetQualTmplt_t;

#define SD_MsgSetQualTmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgSetQualTmplt_QualTmpltId), &((structAddr)->QualTmpltId))


#define SD_MsgSetQualTmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgSetQualTmplt_QualTmpltId), &((structAddr)->QualTmpltId))


#define SD_MsgSetQualTmplt_Size		2

#define SD_MsgSetQualTmplt	0x706	/* 1798 */
/* The number of frames needed before reporting a tone*/

#define SD_QualTmplt_nfrm	0x280000	/* 2621440 */
typedef	UInt16	SD_QualTmplt_nfrm_t;
/* The Signal/Noise ratio of the first frame to start verification*/

#define SD_QualTmplt_snr0	0x280002	/* 2621442 */
typedef	UInt16	SD_QualTmplt_snr0_t;
/* The Signal/Noise ratio for each subsequent frame after snr0*/

#define SD_QualTmplt_snr1	0x280004	/* 2621444 */
typedef	UInt16	SD_QualTmplt_snr1_t;
/* The broad value necessary to begin tone detection*/

#define SD_QualTmplt_b0	0x280006	/* 2621446 */
typedef	UInt16	SD_QualTmplt_b0_t;
/* The broad value necessary for all subsequent frames*/

#define SD_QualTmplt_b1	0x280008	/* 2621448 */
typedef	UInt16	SD_QualTmplt_b1_t;
/* maximum value of twist allowed*/

#define SD_QualTmplt_trat	0x28000a	/* 2621450 */
typedef	UInt16	SD_QualTmplt_trat_t;

#define SD_QualTmplt_qmax_def	0x4	/* 4 */
/* Part of the anti-talkoff algorithm */

#define SD_QualTmplt_qmax	0x28000c	/* 2621452 */
typedef	UInt16	SD_QualTmplt_qmax_t;

#define SD_QualTmplt_tnfrm_Max	0x7	/* 7 */
/* Part of the anti-talkoff algoritm */

#define SD_QualTmplt_tnfrm	0x28000e	/* 2621454 */
typedef	UInt16	SD_QualTmplt_tnfrm_t;

#define SD_QualTmplt_mask_TALK_OFF	0x1	/* 1 */
/*Use anti-talkoff algorithm*/

#define SD_QualTmplt_mask	0x280010	/* 2621456 */
typedef	UInt16	SD_QualTmplt_mask_t;
/* minimum number of frames a tone must be present to verify*/

#define SD_QualTmplt_minfrm	0x280012	/* 2621458 */
typedef	UInt16	SD_QualTmplt_minfrm_t;

#define SD_QualTmplt_killparm_def	0x3	/* 3 */
/*The minimum number of frames a tone must be absent before ending a tone*/

#define SD_QualTmplt_killparm	0x280014	/* 2621460 */
typedef	UInt16	SD_QualTmplt_killparm_t;
/* Used instead of killparm if the tone is absent but the total energy is greater */
/* than the original tone when it was first detected */

#define SD_QualTmplt_longkill	0x280016	/* 2621462 */
typedef	UInt16	SD_QualTmplt_longkill_t;
/* Reserved for future use must be 0. */

#define SD_QualTmplt_rsvd	0x280018	/* 2621464 */
typedef	UInt16	SD_QualTmplt_rsvd_t;


typedef struct {
	UInt16	nfrm;
	UInt16	snr0;
	UInt16	snr1;
	UInt16	b0;
	UInt16	b1;
	UInt16	trat;
	UInt16	qmax;
	UInt16	tnfrm;
	UInt16	mask;
	UInt16	minfrm;
	UInt16	killparm;
	UInt16	longkill;
	UInt16	rsvd;
} SD_QualTmplt_t;

#define SD_QualTmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 13, &(offset),	\
			(SD_QualTmplt_nfrm), &((structAddr)->nfrm),	\
			(SD_QualTmplt_snr0), &((structAddr)->snr0),	\
			(SD_QualTmplt_snr1), &((structAddr)->snr1),	\
			(SD_QualTmplt_b0), &((structAddr)->b0),	\
			(SD_QualTmplt_b1), &((structAddr)->b1),	\
			(SD_QualTmplt_trat), &((structAddr)->trat),	\
			(SD_QualTmplt_qmax), &((structAddr)->qmax),	\
			(SD_QualTmplt_tnfrm), &((structAddr)->tnfrm),	\
			(SD_QualTmplt_mask), &((structAddr)->mask),	\
			(SD_QualTmplt_minfrm), &((structAddr)->minfrm),	\
			(SD_QualTmplt_killparm), &((structAddr)->killparm),	\
			(SD_QualTmplt_longkill), &((structAddr)->longkill),	\
			(SD_QualTmplt_rsvd), &((structAddr)->rsvd))


#define SD_QualTmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 13, &(offset),	\
			(SD_QualTmplt_nfrm), &((structAddr)->nfrm),	\
			(SD_QualTmplt_snr0), &((structAddr)->snr0),	\
			(SD_QualTmplt_snr1), &((structAddr)->snr1),	\
			(SD_QualTmplt_b0), &((structAddr)->b0),	\
			(SD_QualTmplt_b1), &((structAddr)->b1),	\
			(SD_QualTmplt_trat), &((structAddr)->trat),	\
			(SD_QualTmplt_qmax), &((structAddr)->qmax),	\
			(SD_QualTmplt_tnfrm), &((structAddr)->tnfrm),	\
			(SD_QualTmplt_mask), &((structAddr)->mask),	\
			(SD_QualTmplt_minfrm), &((structAddr)->minfrm),	\
			(SD_QualTmplt_killparm), &((structAddr)->killparm),	\
			(SD_QualTmplt_longkill), &((structAddr)->longkill),	\
			(SD_QualTmplt_rsvd), &((structAddr)->rsvd))


#define SD_QualTmplt_Size		26

#define SD_QualTmplt	0x1	/* 1 */
/* Note the qualification template ID's are identical to R4 Springware, not very creative but hopefully easier to use. */
enum { 
	SD_QualTmplt_DTMF = 0,		/* Used for basic DTMF detection */
	SD_QualTmplt_MF,			/* Used for MF tone detection */
	SD_QualTmplt_DTMF_PLAY,	/* Used for DTMF detection during playback for better cut through */
	SD_QualTmplt_MF_LKP,		/* Used for detecting the Long Key Pulse MF digit. */
	SD_QualTmplt_SIT,			/* Used for the Special information tone- operator intercept. */
	SD_QualTmplt_PVD,			/* Not used, see SD_CreatePvdSig */
	SD_QualTmplt_DEFAULT,		/* Used for general tone detection by applications in R4 Springware */
	SD_QualTmplt_LearnMode1,		/* Used for learn mode */
	SD_QualTmplt_LearnMode2,
	SD_QualTmplt_LearnMode3,
	SD_QualTmplt_LearnMode4,
	SD_QualTmplt_CALLP,		/* Used for ringback, busy, & dialtone detection for Call Analysis */
	SD_QualTmplt_PAMD1,		/* Not used, see SD_CreatePamdSig */
	SD_QualTmplt_PAMD2,		/* Not used, see SD_CreatPamdSig */
	SD_QualTmplt_GTD_EXCEPT1,
	SD_QualTmplt_GTD_EXCEPT2,
	SD_QualTmplt_GTD_EXCEPT3,
	SD_QualTmplt_GTD_EXCEPT4,
	SD_QualTmplt_R2MF
};

/*{*/
/*}*/

/*
 * SD_MsgSetQualTmpltCmplt (value = 0x707) is an output message
 * for component SD.
 */

#define SD_MsgSetQualTmpltCmplt_Size		0

#define SD_MsgSetQualTmpltCmplt	0x707	/* 1799 */

#define SD_MsgGetQualTmplt_QualTmpltId	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgGetQualTmplt_QualTmpltId_t;

/*
 * SD_MsgGetQualTmplt (value = 0x708) is an input message
 * for component SD.
 */


typedef struct {
	UInt16	QualTmpltId;
} SD_MsgGetQualTmplt_t;

#define SD_MsgGetQualTmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgGetQualTmplt_QualTmpltId), &((structAddr)->QualTmpltId))


#define SD_MsgGetQualTmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgGetQualTmplt_QualTmpltId), &((structAddr)->QualTmpltId))


#define SD_MsgGetQualTmplt_Size		2

#define SD_MsgGetQualTmplt	0x708	/* 1800 */

#define SD_MsgGetQualTmpltCmplt_QualTmpltId	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgGetQualTmpltCmplt_QualTmpltId_t;

#define SD_MsgGetQualTmpltCmplt_varStart	0x2

/*
 * SD_MsgGetQualTmpltCmplt (value = 0x709) is an output message
 * for component SD.
 */


typedef struct {
	UInt16	QualTmpltId;
} SD_MsgGetQualTmpltCmplt_t;

#define SD_MsgGetQualTmpltCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgGetQualTmpltCmplt_QualTmpltId), &((structAddr)->QualTmpltId))


#define SD_MsgGetQualTmpltCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgGetQualTmpltCmplt_QualTmpltId), &((structAddr)->QualTmpltId))


#define SD_MsgGetQualTmpltCmplt_Size		2

#define SD_MsgGetQualTmpltCmplt	0x709	/* 1801 */

#define SD_MsgCreatePvdSignal_signalId	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreatePvdSignal_signalId_t;
/*reserved for future use */

#define SD_MsgCreatePvdSignal_signalLabel	0x201804	/* 2103300 */
typedef	UInt8	SD_MsgCreatePvdSignal_signalLabel_t[4];

#define SD_MsgCreatePvdSignal_pvdTmplt_minSnr	0x280008	/* 2621448 */
typedef	UInt16	SD_MsgCreatePvdSignal_pvdTmplt_minSnr_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_maxSnr	0x30000a	/* 3145738 */
typedef	UInt24	SD_MsgCreatePvdSignal_pvdTmplt_maxSnr_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_maxPk	0x28000d	/* 2621453 */
typedef	UInt16	SD_MsgCreatePvdSignal_pvdTmplt_maxPk_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_maxRing	0x28000f	/* 2621455 */
typedef	UInt16	SD_MsgCreatePvdSignal_pvdTmplt_maxRing_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_ringThresh	0x300011	/* 3145745 */
typedef	UInt24	SD_MsgCreatePvdSignal_pvdTmplt_ringThresh_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_pvdWin	0x280014	/* 2621460 */
typedef	UInt16	SD_MsgCreatePvdSignal_pvdTmplt_pvdWin_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_pvdVThresh	0x300016	/* 3145750 */
typedef	UInt24	SD_MsgCreatePvdSignal_pvdTmplt_pvdVThresh_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_pvdRbLow	0x280019	/* 2621465 */
typedef	UInt16	SD_MsgCreatePvdSignal_pvdTmplt_pvdRbLow_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_pvdRbHigh	0x28001b	/* 2621467 */
typedef	UInt16	SD_MsgCreatePvdSignal_pvdTmplt_pvdRbHigh_t;


typedef struct {
	UInt16	minSnr;
	UInt24	maxSnr;
	UInt16	maxPk;
	UInt16	maxRing;
	UInt24	ringThresh;
	UInt16	pvdWin;
	UInt24	pvdVThresh;
	UInt16	pvdRbLow;
	UInt16	pvdRbHigh;
} SD_MsgCreatePvdSignal_pvdTmplt_t;

#define SD_MsgCreatePvdSignal_pvdTmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_minSnr), &((structAddr)->minSnr),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_maxSnr), &((structAddr)->maxSnr),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_maxPk), &((structAddr)->maxPk),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_maxRing), &((structAddr)->maxRing),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_ringThresh), &((structAddr)->ringThresh),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdWin), &((structAddr)->pvdWin),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdVThresh), &((structAddr)->pvdVThresh),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdRbLow), &((structAddr)->pvdRbLow),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdRbHigh), &((structAddr)->pvdRbHigh))


#define SD_MsgCreatePvdSignal_pvdTmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_minSnr), &((structAddr)->minSnr),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_maxSnr), &((structAddr)->maxSnr),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_maxPk), &((structAddr)->maxPk),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_maxRing), &((structAddr)->maxRing),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_ringThresh), &((structAddr)->ringThresh),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdWin), &((structAddr)->pvdWin),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdVThresh), &((structAddr)->pvdVThresh),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdRbLow), &((structAddr)->pvdRbLow),	\
			(SD_MsgCreatePvdSignal_pvdTmplt_pvdRbHigh), &((structAddr)->pvdRbHigh))


#define SD_MsgCreatePvdSignal_pvdTmplt_Size		21

#define SD_MsgCreatePvdSignal_pvdTmplt	0x2	/* 2 */

/*
 * SD_MsgCreatePvdSignal (value = 0x70a) is an input message
 * for component SD.
 */


typedef struct {
	UInt32	signalId;
	UInt8	signalLabel[4];
	SD_MsgCreatePvdSignal_pvdTmplt_t	SD_MsgCreatePvdSignal_pvdTmplt_i;
} SD_MsgCreatePvdSignal_t;

#define SD_MsgCreatePvdSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_MsgCreatePvdSignal_signalId), &((structAddr)->signalId),	\
			(SD_MsgCreatePvdSignal_signalLabel), &((structAddr)->signalLabel));	\
		    SD_MsgCreatePvdSignal_pvdTmplt_get(msgPtr, &((structAddr)->SD_MsgCreatePvdSignal_pvdTmplt_i), offset)


#define SD_MsgCreatePvdSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_MsgCreatePvdSignal_signalId), &((structAddr)->signalId),	\
			(SD_MsgCreatePvdSignal_signalLabel), &((structAddr)->signalLabel));	\
		    SD_MsgCreatePvdSignal_pvdTmplt_put(msgPtr, &((structAddr)->SD_MsgCreatePvdSignal_pvdTmplt_i), offset)


#define SD_MsgCreatePvdSignal_Size		29

#define SD_MsgCreatePvdSignal	0x70a	/* 1802 */

#define SD_MsgCreatePvdSigCmplt_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreatePvdSigCmplt_Id_t;

/*
 * SD_MsgCreatePvdSigCmplt (value = 0x70b) is an output message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
} SD_MsgCreatePvdSigCmplt_t;

#define SD_MsgCreatePvdSigCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgCreatePvdSigCmplt_Id), &((structAddr)->Id))


#define SD_MsgCreatePvdSigCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgCreatePvdSigCmplt_Id), &((structAddr)->Id))


#define SD_MsgCreatePvdSigCmplt_Size		4

#define SD_MsgCreatePvdSigCmplt	0x70b	/* 1803 */

#define SD_MsgCreatePamdSig_signalId	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreatePamdSig_signalId_t;
/*reserved for future use. */

#define SD_MsgCreatePamdSig_signalLabel	0x201804	/* 2103300 */
typedef	UInt8	SD_MsgCreatePamdSig_signalLabel_t[4];

#define SD_MsgCreatePamdSig_pamdTmplt_minRing	0x280008	/* 2621448 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_minRing_t;

#define SD_MsgCreatePamdSig_pamdTmplt_mask_FULL_DECISION	0x1	/* 1 */

#define SD_MsgCreatePamdSig_pamdTmplt_mask	0x28000a	/* 2621450 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_mask_t;

#define SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz1	0x28000c	/* 2621452 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz1_t;

#define SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz2	0x28000e	/* 2621454 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz2_t;

#define SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz3	0x280010	/* 2621456 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz3_t;

#define SD_MsgCreatePamdSig_pamdTmplt_loHiss	0x280012	/* 2621458 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_loHiss_t;

#define SD_MsgCreatePamdSig_pamdTmplt_hiHiss	0x280014	/* 2621460 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_hiHiss_t;

#define SD_MsgCreatePamdSig_pamdTmplt_bhParm	0x280016	/* 2621462 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_bhParm_t;

#define SD_MsgCreatePamdSig_pamdTmplt_cvThresh1	0x280018	/* 2621464 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_cvThresh1_t;

#define SD_MsgCreatePamdSig_pamdTmplt_cvThresh2	0x28001a	/* 2621466 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_cvThresh2_t;

#define SD_MsgCreatePamdSig_pamdTmplt_maxCvThresh	0x28001c	/* 2621468 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_maxCvThresh_t;

#define SD_MsgCreatePamdSig_pamdTmplt_nMaxBroad	0x28001e	/* 2621470 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_nMaxBroad_t;

#define SD_MsgCreatePamdSig_pamdTmplt_nMaxErg	0x280020	/* 2621472 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_nMaxErg_t;

#define SD_MsgCreatePamdSig_pamdTmplt_maxSilence	0x280022	/* 2621474 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_maxSilence_t;

#define SD_MsgCreatePamdSig_pamdTmplt_voiceThresh	0x280024	/* 2621476 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_voiceThresh_t;

#define SD_MsgCreatePamdSig_pamdTmplt_silenceThresh	0x280026	/* 2621478 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_silenceThresh_t;

#define SD_MsgCreatePamdSig_pamdTmplt_rjFbandLow	0x280028	/* 2621480 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_rjFbandLow_t;

#define SD_MsgCreatePamdSig_pamdTmplt_rjFbandHigh	0x28002a	/* 2621482 */
typedef	UInt16	SD_MsgCreatePamdSig_pamdTmplt_rjFbandHigh_t;


typedef struct {
	UInt16	minRing;
	UInt16	mask;
	UInt16	maxAnsiz1;
	UInt16	maxAnsiz2;
	UInt16	maxAnsiz3;
	UInt16	loHiss;
	UInt16	hiHiss;
	UInt16	bhParm;
	UInt16	cvThresh1;
	UInt16	cvThresh2;
	UInt16	maxCvThresh;
	UInt16	nMaxBroad;
	UInt16	nMaxErg;
	UInt16	maxSilence;
	UInt16	voiceThresh;
	UInt16	silenceThresh;
	UInt16	rjFbandLow;
	UInt16	rjFbandHigh;
} SD_MsgCreatePamdSig_pamdTmplt_t;

#define SD_MsgCreatePamdSig_pamdTmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 18, &(offset),	\
			(SD_MsgCreatePamdSig_pamdTmplt_minRing), &((structAddr)->minRing),	\
			(SD_MsgCreatePamdSig_pamdTmplt_mask), &((structAddr)->mask),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz1), &((structAddr)->maxAnsiz1),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz2), &((structAddr)->maxAnsiz2),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz3), &((structAddr)->maxAnsiz3),	\
			(SD_MsgCreatePamdSig_pamdTmplt_loHiss), &((structAddr)->loHiss),	\
			(SD_MsgCreatePamdSig_pamdTmplt_hiHiss), &((structAddr)->hiHiss),	\
			(SD_MsgCreatePamdSig_pamdTmplt_bhParm), &((structAddr)->bhParm),	\
			(SD_MsgCreatePamdSig_pamdTmplt_cvThresh1), &((structAddr)->cvThresh1),	\
			(SD_MsgCreatePamdSig_pamdTmplt_cvThresh2), &((structAddr)->cvThresh2),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxCvThresh), &((structAddr)->maxCvThresh),	\
			(SD_MsgCreatePamdSig_pamdTmplt_nMaxBroad), &((structAddr)->nMaxBroad),	\
			(SD_MsgCreatePamdSig_pamdTmplt_nMaxErg), &((structAddr)->nMaxErg),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxSilence), &((structAddr)->maxSilence),	\
			(SD_MsgCreatePamdSig_pamdTmplt_voiceThresh), &((structAddr)->voiceThresh),	\
			(SD_MsgCreatePamdSig_pamdTmplt_silenceThresh), &((structAddr)->silenceThresh),	\
			(SD_MsgCreatePamdSig_pamdTmplt_rjFbandLow), &((structAddr)->rjFbandLow),	\
			(SD_MsgCreatePamdSig_pamdTmplt_rjFbandHigh), &((structAddr)->rjFbandHigh))


#define SD_MsgCreatePamdSig_pamdTmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 18, &(offset),	\
			(SD_MsgCreatePamdSig_pamdTmplt_minRing), &((structAddr)->minRing),	\
			(SD_MsgCreatePamdSig_pamdTmplt_mask), &((structAddr)->mask),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz1), &((structAddr)->maxAnsiz1),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz2), &((structAddr)->maxAnsiz2),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxAnsiz3), &((structAddr)->maxAnsiz3),	\
			(SD_MsgCreatePamdSig_pamdTmplt_loHiss), &((structAddr)->loHiss),	\
			(SD_MsgCreatePamdSig_pamdTmplt_hiHiss), &((structAddr)->hiHiss),	\
			(SD_MsgCreatePamdSig_pamdTmplt_bhParm), &((structAddr)->bhParm),	\
			(SD_MsgCreatePamdSig_pamdTmplt_cvThresh1), &((structAddr)->cvThresh1),	\
			(SD_MsgCreatePamdSig_pamdTmplt_cvThresh2), &((structAddr)->cvThresh2),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxCvThresh), &((structAddr)->maxCvThresh),	\
			(SD_MsgCreatePamdSig_pamdTmplt_nMaxBroad), &((structAddr)->nMaxBroad),	\
			(SD_MsgCreatePamdSig_pamdTmplt_nMaxErg), &((structAddr)->nMaxErg),	\
			(SD_MsgCreatePamdSig_pamdTmplt_maxSilence), &((structAddr)->maxSilence),	\
			(SD_MsgCreatePamdSig_pamdTmplt_voiceThresh), &((structAddr)->voiceThresh),	\
			(SD_MsgCreatePamdSig_pamdTmplt_silenceThresh), &((structAddr)->silenceThresh),	\
			(SD_MsgCreatePamdSig_pamdTmplt_rjFbandLow), &((structAddr)->rjFbandLow),	\
			(SD_MsgCreatePamdSig_pamdTmplt_rjFbandHigh), &((structAddr)->rjFbandHigh))


#define SD_MsgCreatePamdSig_pamdTmplt_Size		36

#define SD_MsgCreatePamdSig_pamdTmplt	0x3	/* 3 */

/*
 * SD_MsgCreatePamdSig (value = 0x70c) is an input message
 * for component SD.
 */


typedef struct {
	UInt32	signalId;
	UInt8	signalLabel[4];
	SD_MsgCreatePamdSig_pamdTmplt_t	SD_MsgCreatePamdSig_pamdTmplt_i;
} SD_MsgCreatePamdSig_t;

#define SD_MsgCreatePamdSig_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_MsgCreatePamdSig_signalId), &((structAddr)->signalId),	\
			(SD_MsgCreatePamdSig_signalLabel), &((structAddr)->signalLabel));	\
		    SD_MsgCreatePamdSig_pamdTmplt_get(msgPtr, &((structAddr)->SD_MsgCreatePamdSig_pamdTmplt_i), offset)


#define SD_MsgCreatePamdSig_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_MsgCreatePamdSig_signalId), &((structAddr)->signalId),	\
			(SD_MsgCreatePamdSig_signalLabel), &((structAddr)->signalLabel));	\
		    SD_MsgCreatePamdSig_pamdTmplt_put(msgPtr, &((structAddr)->SD_MsgCreatePamdSig_pamdTmplt_i), offset)


#define SD_MsgCreatePamdSig_Size		44

#define SD_MsgCreatePamdSig	0x70c	/* 1804 */

#define SD_MsgCreatePamdSigCmplt_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreatePamdSigCmplt_Id_t;

/*
 * SD_MsgCreatePamdSigCmplt (value = 0x70d) is an output message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
} SD_MsgCreatePamdSigCmplt_t;

#define SD_MsgCreatePamdSigCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgCreatePamdSigCmplt_Id), &((structAddr)->Id))


#define SD_MsgCreatePamdSigCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgCreatePamdSigCmplt_Id), &((structAddr)->Id))


#define SD_MsgCreatePamdSigCmplt_Size		4

#define SD_MsgCreatePamdSigCmplt	0x70d	/* 1805 */
/* A request to get the wave analyzer address associated with a signal 
 * detector instance */

/*
 * SD_MsgWAInfo (value = 0x70e) is an input message
 * for component SD.
 */

#define SD_MsgWAInfo_Size		0

#define SD_MsgWAInfo	0x70e	/* 1806 */

#define SD_MsgWAInfoCmplt_Node	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgWAInfoCmplt_Node_t;

#define SD_MsgWAInfoCmplt_Board	0x200001	/* 2097153 */
typedef	UInt8	SD_MsgWAInfoCmplt_Board_t;

#define SD_MsgWAInfoCmplt_Processor	0x200002	/* 2097154 */
typedef	UInt8	SD_MsgWAInfoCmplt_Processor_t;

#define SD_MsgWAInfoCmplt_Component	0x200003	/* 2097155 */
typedef	UInt8	SD_MsgWAInfoCmplt_Component_t;

#define SD_MsgWAInfoCmplt_Instance	0x280004	/* 2621444 */
typedef	UInt16	SD_MsgWAInfoCmplt_Instance_t;

/*
 * SD_MsgWAInfoCmplt (value = 0x70f) is an output message
 * for component SD.
 */


typedef struct {
	UInt8	Node;
	UInt8	Board;
	UInt8	Processor;
	UInt8	Component;
	UInt16	Instance;
} SD_MsgWAInfoCmplt_t;

#define SD_MsgWAInfoCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(SD_MsgWAInfoCmplt_Node), &((structAddr)->Node),	\
			(SD_MsgWAInfoCmplt_Board), &((structAddr)->Board),	\
			(SD_MsgWAInfoCmplt_Processor), &((structAddr)->Processor),	\
			(SD_MsgWAInfoCmplt_Component), &((structAddr)->Component),	\
			(SD_MsgWAInfoCmplt_Instance), &((structAddr)->Instance))


#define SD_MsgWAInfoCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(SD_MsgWAInfoCmplt_Node), &((structAddr)->Node),	\
			(SD_MsgWAInfoCmplt_Board), &((structAddr)->Board),	\
			(SD_MsgWAInfoCmplt_Processor), &((structAddr)->Processor),	\
			(SD_MsgWAInfoCmplt_Component), &((structAddr)->Component),	\
			(SD_MsgWAInfoCmplt_Instance), &((structAddr)->Instance))


#define SD_MsgWAInfoCmplt_Size		6

#define SD_MsgWAInfoCmplt	0x70f	/* 1807 */
/* Returns the actual wave analyzer address associated with an instance of the 
 * signal detector. Sent in response to a WAInfo message. */

#define SD_MsgDeletePvd_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeletePvd_Id_t;

/*
 * SD_MsgDeletePvd (value = 0x710) is an input message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
} SD_MsgDeletePvd_t;

#define SD_MsgDeletePvd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgDeletePvd_Id), &((structAddr)->Id))


#define SD_MsgDeletePvd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgDeletePvd_Id), &((structAddr)->Id))


#define SD_MsgDeletePvd_Size		4

#define SD_MsgDeletePvd	0x710	/* 1808 */

/*
 * SD_MsgDeletePvdCmplt (value = 0x711) is an output message
 * for component SD.
 */

#define SD_MsgDeletePvdCmplt_Size		0

#define SD_MsgDeletePvdCmplt	0x711	/* 1809 */

#define SD_MsgDeletePamd_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeletePamd_Id_t;

/*
 * SD_MsgDeletePamd (value = 0x712) is an input message
 * for component SD.
 */


typedef struct {
	UInt32	Id;
} SD_MsgDeletePamd_t;

#define SD_MsgDeletePamd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgDeletePamd_Id), &((structAddr)->Id))


#define SD_MsgDeletePamd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgDeletePamd_Id), &((structAddr)->Id))


#define SD_MsgDeletePamd_Size		4

#define SD_MsgDeletePamd	0x712	/* 1810 */

/*
 * SD_MsgDeletePamdCmplt (value = 0x713) is an output message
 * for component SD.
 */

#define SD_MsgDeletePamdCmplt_Size		0

#define SD_MsgDeletePamdCmplt	0x713	/* 1811 */
/*This field defines number of tones to be created.*/

#define SD_MsgCreateXTones_numOfTones	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_numOfTones_t;

#define SD_MsgCreateXTones_varStart	0x2
/* The 32-bit signal Id */

#define SD_MsgCreateXTones_ToneInfo_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTones_ToneInfo_Id_t;
/* The signal label */

#define SD_MsgCreateXTones_ToneInfo_label	0x201800	/* 2103296 */
typedef	UInt8	SD_MsgCreateXTones_ToneInfo_label_t[4];
/* The number of times the segment list must repeat before signal on event*/

#define SD_MsgCreateXTones_ToneInfo_repCount	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgCreateXTones_ToneInfo_repCount_t;
/* The number of defined tone template segments.  Must be less than 5  */

#define SD_MsgCreateXTones_ToneInfo_numOfSegs	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgCreateXTones_ToneInfo_numOfSegs_t;
/* Reserved.  Must be 0 */

#define SD_MsgCreateXTones_ToneInfo_rsvd	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneInfo_rsvd_t;
/* handle needed to delete a tone.  Set to 0 to allow anyone to delete tone */

#define SD_MsgCreateXTones_ToneInfo_DeleteHndl	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTones_ToneInfo_DeleteHndl_t;
/* Number of event to be enabled for this tone*/

#define SD_MsgCreateXTones_ToneInfo_numEvents	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneInfo_numEvents_t;


typedef struct {
	UInt32	Id;
	UInt8	label[4];
	UInt8	repCount;
	UInt8	numOfSegs;
	UInt16	rsvd;
	UInt32	DeleteHndl;
	UInt16	numEvents;
} SD_MsgCreateXTones_ToneInfo_t;

#define SD_MsgCreateXTones_ToneInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(SD_MsgCreateXTones_ToneInfo_Id), &((structAddr)->Id),	\
			(SD_MsgCreateXTones_ToneInfo_label), &((structAddr)->label),	\
			(SD_MsgCreateXTones_ToneInfo_repCount), &((structAddr)->repCount),	\
			(SD_MsgCreateXTones_ToneInfo_numOfSegs), &((structAddr)->numOfSegs),	\
			(SD_MsgCreateXTones_ToneInfo_rsvd), &((structAddr)->rsvd),	\
			(SD_MsgCreateXTones_ToneInfo_DeleteHndl), &((structAddr)->DeleteHndl),	\
			(SD_MsgCreateXTones_ToneInfo_numEvents), &((structAddr)->numEvents))


#define SD_MsgCreateXTones_ToneInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(SD_MsgCreateXTones_ToneInfo_Id), &((structAddr)->Id),	\
			(SD_MsgCreateXTones_ToneInfo_label), &((structAddr)->label),	\
			(SD_MsgCreateXTones_ToneInfo_repCount), &((structAddr)->repCount),	\
			(SD_MsgCreateXTones_ToneInfo_numOfSegs), &((structAddr)->numOfSegs),	\
			(SD_MsgCreateXTones_ToneInfo_rsvd), &((structAddr)->rsvd),	\
			(SD_MsgCreateXTones_ToneInfo_DeleteHndl), &((structAddr)->DeleteHndl),	\
			(SD_MsgCreateXTones_ToneInfo_numEvents), &((structAddr)->numEvents))


#define SD_MsgCreateXTones_ToneInfo_Size		18

#define SD_MsgCreateXTones_ToneInfo	0x4	/* 4 */

#define SD_MsgCreateXTones_ToneSeg_mask_DualTone	0x1	/* 1 */

#define SD_MsgCreateXTones_ToneSeg_mask_Ring	0x2	/* 2 */

#define SD_MsgCreateXTones_ToneSeg_mask_Silence	0x4	/* 4 */
/*Unused bits must be 0.*/
/*SD_ToneSeg_DualTone - If not set, tone will be treated as single tone*/
/*SD_ToneSeg_Ring - This identifies a template used for ring detection for PVD */
/*SD_ToneSeg_Silence - This is a silence on / off template, only the timing 
 * values are relevant */

#define SD_MsgCreateXTones_ToneSeg_mask	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_mask_t;
/* The qualification template to use, see SD_SetQualTmplt. */

#define SD_MsgCreateXTones_ToneSeg_qtmplt	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgCreateXTones_ToneSeg_qtmplt_t;
/* The qualification template to use during playback.*/

#define SD_MsgCreateXTones_ToneSeg_pqtmplt	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgCreateXTones_ToneSeg_pqtmplt_t;
/* The first tone, the units are in Hz */

#define SD_MsgCreateXTones_ToneSeg_tone1MinFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_tone1MinFrq_t;
/* The units are in Hz */

#define SD_MsgCreateXTones_ToneSeg_tone1MaxFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_tone1MaxFrq_t;
/* The units are in dBm, lower boundary, values below SD_ParmMinergy are 
 * irrelevant */

#define SD_MsgCreateXTones_ToneSeg_tone1MinAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateXTones_ToneSeg_tone1MinAmp_t;
/* The units are in dBm , upper boundary*/

#define SD_MsgCreateXTones_ToneSeg_tone1MaxAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateXTones_ToneSeg_tone1MaxAmp_t;
/* The second tone, the units are in Hz */

#define SD_MsgCreateXTones_ToneSeg_tone2MinFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_tone2MinFrq_t;
/* The units are in Hz */

#define SD_MsgCreateXTones_ToneSeg_tone2MaxFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_tone2MaxFrq_t;
/* The units are in dBm */

#define SD_MsgCreateXTones_ToneSeg_tone2MinAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateXTones_ToneSeg_tone2MinAmp_t;
/* The units are in dBm */

#define SD_MsgCreateXTones_ToneSeg_tone2MaxAmp	0	/* 0 */
typedef	Int8	SD_MsgCreateXTones_ToneSeg_tone2MaxAmp_t;
/* Should be 0 for future compatibility, Expert feature units in Hz*/

#define SD_MsgCreateXTones_ToneSeg_fTwinMin	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_fTwinMin_t;
/* Should be 0 .*/

#define SD_MsgCreateXTones_ToneSeg_fTwinMax	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_fTwinMax_t;
/* Time in 10ms units, on duration required for tone*/

#define SD_MsgCreateXTones_ToneSeg_minOnDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_minOnDuration_t;
/* Time in 10ms units, max. on duration allowed for tone*/

#define SD_MsgCreateXTones_ToneSeg_maxOnDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_maxOnDuration_t;
/* Time in 10ms units, off duration required for tone*/

#define SD_MsgCreateXTones_ToneSeg_minOffDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_minOffDuration_t;
/* Time in 10ms units, max off duration allowed for tone*/

#define SD_MsgCreateXTones_ToneSeg_maxOffDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTones_ToneSeg_maxOffDuration_t;


typedef struct {
	UInt16	mask;
	UInt8	qtmplt;
	UInt8	pqtmplt;
	UInt16	tone1MinFrq;
	UInt16	tone1MaxFrq;
	Int8	tone1MinAmp;
	Int8	tone1MaxAmp;
	UInt16	tone2MinFrq;
	UInt16	tone2MaxFrq;
	Int8	tone2MinAmp;
	Int8	tone2MaxAmp;
	UInt16	fTwinMin;
	UInt16	fTwinMax;
	UInt16	minOnDuration;
	UInt16	maxOnDuration;
	UInt16	minOffDuration;
	UInt16	maxOffDuration;
} SD_MsgCreateXTones_ToneSeg_t;

#define SD_MsgCreateXTones_ToneSeg_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 17, &(offset),	\
			(SD_MsgCreateXTones_ToneSeg_mask), &((structAddr)->mask),	\
			(SD_MsgCreateXTones_ToneSeg_qtmplt), &((structAddr)->qtmplt),	\
			(SD_MsgCreateXTones_ToneSeg_pqtmplt), &((structAddr)->pqtmplt),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MinFrq), &((structAddr)->tone1MinFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MaxFrq), &((structAddr)->tone1MaxFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MinAmp), &((structAddr)->tone1MinAmp),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MaxAmp), &((structAddr)->tone1MaxAmp),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MinFrq), &((structAddr)->tone2MinFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MaxFrq), &((structAddr)->tone2MaxFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MinAmp), &((structAddr)->tone2MinAmp),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MaxAmp), &((structAddr)->tone2MaxAmp),	\
			(SD_MsgCreateXTones_ToneSeg_fTwinMin), &((structAddr)->fTwinMin),	\
			(SD_MsgCreateXTones_ToneSeg_fTwinMax), &((structAddr)->fTwinMax),	\
			(SD_MsgCreateXTones_ToneSeg_minOnDuration), &((structAddr)->minOnDuration),	\
			(SD_MsgCreateXTones_ToneSeg_maxOnDuration), &((structAddr)->maxOnDuration),	\
			(SD_MsgCreateXTones_ToneSeg_minOffDuration), &((structAddr)->minOffDuration),	\
			(SD_MsgCreateXTones_ToneSeg_maxOffDuration), &((structAddr)->maxOffDuration))


#define SD_MsgCreateXTones_ToneSeg_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 17, &(offset),	\
			(SD_MsgCreateXTones_ToneSeg_mask), &((structAddr)->mask),	\
			(SD_MsgCreateXTones_ToneSeg_qtmplt), &((structAddr)->qtmplt),	\
			(SD_MsgCreateXTones_ToneSeg_pqtmplt), &((structAddr)->pqtmplt),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MinFrq), &((structAddr)->tone1MinFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MaxFrq), &((structAddr)->tone1MaxFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MinAmp), &((structAddr)->tone1MinAmp),	\
			(SD_MsgCreateXTones_ToneSeg_tone1MaxAmp), &((structAddr)->tone1MaxAmp),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MinFrq), &((structAddr)->tone2MinFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MaxFrq), &((structAddr)->tone2MaxFrq),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MinAmp), &((structAddr)->tone2MinAmp),	\
			(SD_MsgCreateXTones_ToneSeg_tone2MaxAmp), &((structAddr)->tone2MaxAmp),	\
			(SD_MsgCreateXTones_ToneSeg_fTwinMin), &((structAddr)->fTwinMin),	\
			(SD_MsgCreateXTones_ToneSeg_fTwinMax), &((structAddr)->fTwinMax),	\
			(SD_MsgCreateXTones_ToneSeg_minOnDuration), &((structAddr)->minOnDuration),	\
			(SD_MsgCreateXTones_ToneSeg_maxOnDuration), &((structAddr)->maxOnDuration),	\
			(SD_MsgCreateXTones_ToneSeg_minOffDuration), &((structAddr)->minOffDuration),	\
			(SD_MsgCreateXTones_ToneSeg_maxOffDuration), &((structAddr)->maxOffDuration))


#define SD_MsgCreateXTones_ToneSeg_Size		28

#define SD_MsgCreateXTones_ToneSeg	0x5	/* 5 */
/*Where to send the event notification upon detection of the event*/

#define SD_MsgCreateXTones_ToneDetectEvent_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	SD_MsgCreateXTones_ToneDetectEvent_ReturnAddress_t;

#define SD_MsgCreateXTones_ToneDetectEvent_Type_SignalOn	0x700	/* 1792 */

#define SD_MsgCreateXTones_ToneDetectEvent_Type_SignalOff	0x701	/* 1793 */

#define SD_MsgCreateXTones_ToneDetectEvent_Type	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTones_ToneDetectEvent_Type_t;

#define SD_MsgCreateXTones_ToneDetectEvent_Label	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTones_ToneDetectEvent_Label_t;
/*Transaction Id used in adding the event. Same must be used for Cancelling evt*/

#define SD_MsgCreateXTones_ToneDetectEvent_EventTID	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTones_ToneDetectEvent_EventTID_t;


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Type;
	UInt32	Label;
	UInt32	EventTID;
} SD_MsgCreateXTones_ToneDetectEvent_t;

#define SD_MsgCreateXTones_ToneDetectEvent_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(SD_MsgCreateXTones_ToneDetectEvent_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(SD_MsgCreateXTones_ToneDetectEvent_Type), &((structAddr)->Type),	\
			(SD_MsgCreateXTones_ToneDetectEvent_Label), &((structAddr)->Label),	\
			(SD_MsgCreateXTones_ToneDetectEvent_EventTID), &((structAddr)->EventTID))


#define SD_MsgCreateXTones_ToneDetectEvent_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(SD_MsgCreateXTones_ToneDetectEvent_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(SD_MsgCreateXTones_ToneDetectEvent_Type), &((structAddr)->Type),	\
			(SD_MsgCreateXTones_ToneDetectEvent_Label), &((structAddr)->Label),	\
			(SD_MsgCreateXTones_ToneDetectEvent_EventTID), &((structAddr)->EventTID))


#define SD_MsgCreateXTones_ToneDetectEvent_Size		18

#define SD_MsgCreateXTones_ToneDetectEvent	0x6	/* 6 */

/*
 * SD_MsgCreateXTones (value = 0x714) is an input message
 * for component SD.
 */


typedef struct {
	UInt16	numOfTones;
} SD_MsgCreateXTones_t;

#define SD_MsgCreateXTones_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgCreateXTones_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgCreateXTones_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgCreateXTones_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgCreateXTones_Size		2

#define SD_MsgCreateXTones	0x714	/* 1812 */
/*This field defines number of tones to be created.*/

#define SD_MsgCreateXTonesCmplt_numOfTones	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgCreateXTonesCmplt_numOfTones_t;

#define SD_MsgCreateXTonesCmplt_varStart	0x2
/* The 32-bit signal Id */

#define SD_MsgCreateXTonesCmplt_ToneIDInfo_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTonesCmplt_ToneIDInfo_Id_t;
/* The 32-bit set Id returned by the firmware */

#define SD_MsgCreateXTonesCmplt_ToneIDInfo_SetId	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgCreateXTonesCmplt_ToneIDInfo_SetId_t;


typedef struct {
	UInt32	Id;
	UInt32	SetId;
} SD_MsgCreateXTonesCmplt_ToneIDInfo_t;

#define SD_MsgCreateXTonesCmplt_ToneIDInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_MsgCreateXTonesCmplt_ToneIDInfo_Id), &((structAddr)->Id),	\
			(SD_MsgCreateXTonesCmplt_ToneIDInfo_SetId), &((structAddr)->SetId))


#define SD_MsgCreateXTonesCmplt_ToneIDInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_MsgCreateXTonesCmplt_ToneIDInfo_Id), &((structAddr)->Id),	\
			(SD_MsgCreateXTonesCmplt_ToneIDInfo_SetId), &((structAddr)->SetId))


#define SD_MsgCreateXTonesCmplt_ToneIDInfo_Size		8

#define SD_MsgCreateXTonesCmplt_ToneIDInfo	0x7	/* 7 */

/*
 * SD_MsgCreateXTonesCmplt (value = 0x715) is an output message
 * for component SD.
 */


typedef struct {
	UInt16	numOfTones;
} SD_MsgCreateXTonesCmplt_t;

#define SD_MsgCreateXTonesCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgCreateXTonesCmplt_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgCreateXTonesCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgCreateXTonesCmplt_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgCreateXTonesCmplt_Size		2

#define SD_MsgCreateXTonesCmplt	0x715	/* 1813 */
/*This field defines number of tone templates to be deleted.*/

#define SD_MsgDeleteXTones_numOfTmplts	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgDeleteXTones_numOfTmplts_t;
/*start of first variable portion of the message - controlled by numOfTmplts field*/

#define SD_MsgDeleteXTones_varStart	0x2
/* The 32-bit signal Id to be deleted */

#define SD_MsgDeleteXTones_ToneInfo_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeleteXTones_ToneInfo_Id_t;
/* The delete handle */

#define SD_MsgDeleteXTones_ToneInfo_DeleteHndl	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeleteXTones_ToneInfo_DeleteHndl_t;
/* Number of event to be enabled for this tone*/

#define SD_MsgDeleteXTones_ToneInfo_numEvents	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgDeleteXTones_ToneInfo_numEvents_t;
/*can assume 0- meaning only disable events. 1- disable and delete*/

#define SD_MsgDeleteXTones_ToneInfo_deleteFlag	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgDeleteXTones_ToneInfo_deleteFlag_t;


typedef struct {
	UInt32	Id;
	UInt32	DeleteHndl;
	UInt16	numEvents;
	UInt8	deleteFlag;
} SD_MsgDeleteXTones_ToneInfo_t;

#define SD_MsgDeleteXTones_ToneInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(SD_MsgDeleteXTones_ToneInfo_Id), &((structAddr)->Id),	\
			(SD_MsgDeleteXTones_ToneInfo_DeleteHndl), &((structAddr)->DeleteHndl),	\
			(SD_MsgDeleteXTones_ToneInfo_numEvents), &((structAddr)->numEvents),	\
			(SD_MsgDeleteXTones_ToneInfo_deleteFlag), &((structAddr)->deleteFlag))


#define SD_MsgDeleteXTones_ToneInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(SD_MsgDeleteXTones_ToneInfo_Id), &((structAddr)->Id),	\
			(SD_MsgDeleteXTones_ToneInfo_DeleteHndl), &((structAddr)->DeleteHndl),	\
			(SD_MsgDeleteXTones_ToneInfo_numEvents), &((structAddr)->numEvents),	\
			(SD_MsgDeleteXTones_ToneInfo_deleteFlag), &((structAddr)->deleteFlag))


#define SD_MsgDeleteXTones_ToneInfo_Size		11

#define SD_MsgDeleteXTones_ToneInfo	0x8	/* 8 */

#define SD_MsgDeleteXTones_ToneCancelEvent_Type_SignalOn	0x700	/* 1792 */

#define SD_MsgDeleteXTones_ToneCancelEvent_Type_SignalOff	0x701	/* 1793 */

#define SD_MsgDeleteXTones_ToneCancelEvent_Type	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeleteXTones_ToneCancelEvent_Type_t;
/*same as EventTID used in Detecting Event.*/

#define SD_MsgDeleteXTones_ToneCancelEvent_EventTID	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgDeleteXTones_ToneCancelEvent_EventTID_t;


typedef struct {
	UInt32	Type;
	UInt32	EventTID;
} SD_MsgDeleteXTones_ToneCancelEvent_t;

#define SD_MsgDeleteXTones_ToneCancelEvent_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_MsgDeleteXTones_ToneCancelEvent_Type), &((structAddr)->Type),	\
			(SD_MsgDeleteXTones_ToneCancelEvent_EventTID), &((structAddr)->EventTID))


#define SD_MsgDeleteXTones_ToneCancelEvent_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_MsgDeleteXTones_ToneCancelEvent_Type), &((structAddr)->Type),	\
			(SD_MsgDeleteXTones_ToneCancelEvent_EventTID), &((structAddr)->EventTID))


#define SD_MsgDeleteXTones_ToneCancelEvent_Size		8

#define SD_MsgDeleteXTones_ToneCancelEvent	0x9	/* 9 */

/*
 * SD_MsgDeleteXTones (value = 0x716) is an input message
 * for component SD.
 */


typedef struct {
	UInt16	numOfTmplts;
} SD_MsgDeleteXTones_t;

#define SD_MsgDeleteXTones_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgDeleteXTones_numOfTmplts), &((structAddr)->numOfTmplts))


#define SD_MsgDeleteXTones_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgDeleteXTones_numOfTmplts), &((structAddr)->numOfTmplts))


#define SD_MsgDeleteXTones_Size		2

#define SD_MsgDeleteXTones	0x716	/* 1814 */

/*
 * SD_MsgDeleteXTonesCmplt (value = 0x717) is an output message
 * for component SD.
 */

#define SD_MsgDeleteXTonesCmplt_Size		0

#define SD_MsgDeleteXTonesCmplt	0x717	/* 1815 */
/*This field defines number of tones to be queried.*/

#define SD_MsgQueryXTones_numOfTones	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTones_numOfTones_t;

#define SD_MsgQueryXTones_varStart	0x2
/* The 32-bit signal Id */

#define SD_MsgQueryXTones_ToneInfo_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgQueryXTones_ToneInfo_Id_t;


typedef struct {
	UInt32	Id;
} SD_MsgQueryXTones_ToneInfo_t;

#define SD_MsgQueryXTones_ToneInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgQueryXTones_ToneInfo_Id), &((structAddr)->Id))


#define SD_MsgQueryXTones_ToneInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgQueryXTones_ToneInfo_Id), &((structAddr)->Id))


#define SD_MsgQueryXTones_ToneInfo_Size		4

#define SD_MsgQueryXTones_ToneInfo	0xa	/* 10 */

/*
 * SD_MsgQueryXTones (value = 0x718) is an input message
 * for component SD.
 */


typedef struct {
	UInt16	numOfTones;
} SD_MsgQueryXTones_t;

#define SD_MsgQueryXTones_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgQueryXTones_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgQueryXTones_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgQueryXTones_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgQueryXTones_Size		2

#define SD_MsgQueryXTones	0x718	/* 1816 */
/*This field defines number of tones to be queried.*/

#define SD_MsgQueryXTonesCmplt_numOfTones	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_numOfTones_t;

#define SD_MsgQueryXTonesCmplt_varStart	0x2
/* The 32-bit signal Id */

#define SD_MsgQueryXTonesCmplt_ToneInfo_Id	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgQueryXTonesCmplt_ToneInfo_Id_t;
/* The signal label */

#define SD_MsgQueryXTonesCmplt_ToneInfo_label	0x201800	/* 2103296 */
typedef	UInt8	SD_MsgQueryXTonesCmplt_ToneInfo_label_t[4];
/* The number of times the segment list must repeat before signal on event*/

#define SD_MsgQueryXTonesCmplt_ToneInfo_repCount	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgQueryXTonesCmplt_ToneInfo_repCount_t;
/* The number of defined tone template segments.  */

#define SD_MsgQueryXTonesCmplt_ToneInfo_numOfSegs	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgQueryXTonesCmplt_ToneInfo_numOfSegs_t;
/* Reserved.  will be 0 */

#define SD_MsgQueryXTonesCmplt_ToneInfo_rsvd	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneInfo_rsvd_t;
/* handle needed to delete a tone.   */

#define SD_MsgQueryXTonesCmplt_ToneInfo_DeleteHndl	0x380000	/* 3670016 */
typedef	UInt32	SD_MsgQueryXTonesCmplt_ToneInfo_DeleteHndl_t;


typedef struct {
	UInt32	Id;
	UInt8	label[4];
	UInt8	repCount;
	UInt8	numOfSegs;
	UInt16	rsvd;
	UInt32	DeleteHndl;
} SD_MsgQueryXTonesCmplt_ToneInfo_t;

#define SD_MsgQueryXTonesCmplt_ToneInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_Id), &((structAddr)->Id),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_label), &((structAddr)->label),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_repCount), &((structAddr)->repCount),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_numOfSegs), &((structAddr)->numOfSegs),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_rsvd), &((structAddr)->rsvd),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_DeleteHndl), &((structAddr)->DeleteHndl))


#define SD_MsgQueryXTonesCmplt_ToneInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_Id), &((structAddr)->Id),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_label), &((structAddr)->label),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_repCount), &((structAddr)->repCount),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_numOfSegs), &((structAddr)->numOfSegs),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_rsvd), &((structAddr)->rsvd),	\
			(SD_MsgQueryXTonesCmplt_ToneInfo_DeleteHndl), &((structAddr)->DeleteHndl))


#define SD_MsgQueryXTonesCmplt_ToneInfo_Size		16

#define SD_MsgQueryXTonesCmplt_ToneInfo	0xb	/* 11 */
/*SD_ToneSeg_DualTone */
/*SD_ToneSeg_Ring */
/*SD_ToneSeg_Silence */

#define SD_MsgQueryXTonesCmplt_ToneSeg_mask	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_mask_t;
/* The qualification template used, see SD_SetQualTmplt. */

#define SD_MsgQueryXTonesCmplt_ToneSeg_qtmplt	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgQueryXTonesCmplt_ToneSeg_qtmplt_t;
/* The qualification template used during playback.*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_pqtmplt	0x200000	/* 2097152 */
typedef	UInt8	SD_MsgQueryXTonesCmplt_ToneSeg_pqtmplt_t;
/* The first tone, the units are in Hz */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinFrq_t;
/* The units are in Hz */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxFrq_t;
/* The units are in dBm, lower boundary, values below SD_ParmMinergy are 
 * irrelevant */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinAmp	0	/* 0 */
typedef	Int8	SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinAmp_t;
/* The units are in dBm , upper boundary*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxAmp	0	/* 0 */
typedef	Int8	SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxAmp_t;
/* The second tone, the units are in Hz */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinFrq_t;
/* The units are in Hz */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxFrq	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxFrq_t;
/* The units are in dBm */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinAmp	0	/* 0 */
typedef	Int8	SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinAmp_t;
/* The units are in dBm */

#define SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxAmp	0	/* 0 */
typedef	Int8	SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxAmp_t;
/* will be 0 for future compatibility, Expert feature units in Hz*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMin	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMin_t;
/* will be 0 .*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMax	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMax_t;
/* Time in 10ms units, on duration required for tone*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_minOnDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_minOnDuration_t;
/* Time in 10ms units, max. on duration allowed for tone*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_maxOnDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_maxOnDuration_t;
/* Time in 10ms units, off duration required for tone*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_minOffDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_minOffDuration_t;
/* Time in 10ms units, max off duration allowed for tone*/

#define SD_MsgQueryXTonesCmplt_ToneSeg_maxOffDuration	0x280000	/* 2621440 */
typedef	UInt16	SD_MsgQueryXTonesCmplt_ToneSeg_maxOffDuration_t;


typedef struct {
	UInt16	mask;
	UInt8	qtmplt;
	UInt8	pqtmplt;
	UInt16	tone1MinFrq;
	UInt16	tone1MaxFrq;
	Int8	tone1MinAmp;
	Int8	tone1MaxAmp;
	UInt16	tone2MinFrq;
	UInt16	tone2MaxFrq;
	Int8	tone2MinAmp;
	Int8	tone2MaxAmp;
	UInt16	fTwinMin;
	UInt16	fTwinMax;
	UInt16	minOnDuration;
	UInt16	maxOnDuration;
	UInt16	minOffDuration;
	UInt16	maxOffDuration;
} SD_MsgQueryXTonesCmplt_ToneSeg_t;

#define SD_MsgQueryXTonesCmplt_ToneSeg_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 17, &(offset),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_mask), &((structAddr)->mask),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_qtmplt), &((structAddr)->qtmplt),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_pqtmplt), &((structAddr)->pqtmplt),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinFrq), &((structAddr)->tone1MinFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxFrq), &((structAddr)->tone1MaxFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinAmp), &((structAddr)->tone1MinAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxAmp), &((structAddr)->tone1MaxAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinFrq), &((structAddr)->tone2MinFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxFrq), &((structAddr)->tone2MaxFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinAmp), &((structAddr)->tone2MinAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxAmp), &((structAddr)->tone2MaxAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMin), &((structAddr)->fTwinMin),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMax), &((structAddr)->fTwinMax),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_minOnDuration), &((structAddr)->minOnDuration),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_maxOnDuration), &((structAddr)->maxOnDuration),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_minOffDuration), &((structAddr)->minOffDuration),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_maxOffDuration), &((structAddr)->maxOffDuration))


#define SD_MsgQueryXTonesCmplt_ToneSeg_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 17, &(offset),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_mask), &((structAddr)->mask),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_qtmplt), &((structAddr)->qtmplt),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_pqtmplt), &((structAddr)->pqtmplt),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinFrq), &((structAddr)->tone1MinFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxFrq), &((structAddr)->tone1MaxFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MinAmp), &((structAddr)->tone1MinAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone1MaxAmp), &((structAddr)->tone1MaxAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinFrq), &((structAddr)->tone2MinFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxFrq), &((structAddr)->tone2MaxFrq),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MinAmp), &((structAddr)->tone2MinAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_tone2MaxAmp), &((structAddr)->tone2MaxAmp),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMin), &((structAddr)->fTwinMin),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_fTwinMax), &((structAddr)->fTwinMax),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_minOnDuration), &((structAddr)->minOnDuration),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_maxOnDuration), &((structAddr)->maxOnDuration),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_minOffDuration), &((structAddr)->minOffDuration),	\
			(SD_MsgQueryXTonesCmplt_ToneSeg_maxOffDuration), &((structAddr)->maxOffDuration))


#define SD_MsgQueryXTonesCmplt_ToneSeg_Size		28

#define SD_MsgQueryXTonesCmplt_ToneSeg	0xc	/* 12 */

/*
 * SD_MsgQueryXTonesCmplt (value = 0x719) is an output message
 * for component SD.
 */


typedef struct {
	UInt16	numOfTones;
} SD_MsgQueryXTonesCmplt_t;

#define SD_MsgQueryXTonesCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_MsgQueryXTonesCmplt_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgQueryXTonesCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_MsgQueryXTonesCmplt_numOfTones), &((structAddr)->numOfTones))


#define SD_MsgQueryXTonesCmplt_Size		2

#define SD_MsgQueryXTonesCmplt	0x719	/* 1817 */

#define SD_ParmMaxTnTmpts_def	0xc8	/* 200 */

#define SD_ParmMaxTnTmpts	0x700	/* 1792 */
typedef	UInt32	SD_ParmMaxTnTmpts_t;

#define SD_ParmMaxTnDefs_def	0xff	/* 255 */

#define SD_ParmMaxTnDefs	0x701	/* 1793 */
typedef	UInt32	SD_ParmMaxTnDefs_t;

#define SD_ParmMaxGroupCnt_def	0x14	/* 20 */

#define SD_ParmMaxGroupCnt	0x702	/* 1794 */
typedef	UInt32	SD_ParmMaxGroupCnt_t;

#define SD_ParmEchoDefault_def	0x1	/* 1 */

#define SD_ParmEchoDefault	0x703	/* 1795 */
typedef	UInt32	SD_ParmEchoDefault_t;

#define SD_ParmMaxSigsPerInst_def	0x14	/* 20 */

#define SD_ParmMaxSigsPerInst	0x704	/* 1796 */
typedef	UInt32	SD_ParmMaxSigsPerInst_t;

#define SD_ParmDtmfTalkOffFlag_def	0	/* 0 */

#define SD_ParmDtmfTalkOffFlag	0x705	/* 1797 */
typedef	UInt32	SD_ParmDtmfTalkOffFlag_t;

#define SD_ParmEchoDelayFactor_def	0	/* 0 */

#define SD_ParmEchoDelayFactor	0x706	/* 1798 */
typedef	UInt32	SD_ParmEchoDelayFactor_t;

#define SD_ParmModel_Trc	0	/* 0 */

#define SD_ParmModel_Roc501	0x1	/* 1 */

#define SD_ParmModel_def	0	/* 0 */

#define SD_ParmModel	0x707	/* 1799 */
typedef	UInt32	SD_ParmModel_t;

#define SD_ParmLastCompParm	0x708	/* 1800 */
typedef	UInt32	SD_ParmLastCompParm_t;

#define SD_ParmWaitForDnldCmplt_def	0	/* 0 */

#define SD_ParmWaitForDnldCmplt	0x709	/* 1801 */
typedef	UInt32	SD_ParmWaitForDnldCmplt_t;

#define SD_ParmLowWall_def	0x12c	/* 300 */

#define SD_ParmLowWall	0x70a	/* 1802 */
typedef	UInt32	SD_ParmLowWall_t;

#define SD_ParmMinEnergy_def	0xffffffd5	/* -43 */

#define SD_ParmMinEnergy	0x70b	/* 1803 */
typedef	UInt32	SD_ParmMinEnergy_t;

#define SD_ParmDefDomain_def	0	/* 0 */

#define SD_ParmDefDomain	0x70c	/* 1804 */
typedef	UInt32	SD_ParmDefDomain_t;

#define SD_ParmTwistMax_def	0xa	/* 10 */

#define SD_ParmTwistMax	0x70d	/* 1805 */
typedef	UInt32	SD_ParmTwistMax_t;

#define SD_ParmSuspendId_def	0	/* 0 */

#define SD_ParmSuspendId	0x70e	/* 1806 */
typedef	UInt32	SD_ParmSuspendId_t;

#define SD_ParmLastInstParm	0x70f	/* 1807 */
typedef	UInt32	SD_ParmLastInstParm_t;

#define SD_ErrInvTnTmplt	0x700	/* 1792 */

#define SD_ErrMaxTnDef	0x701	/* 1793 */

#define SD_ErrMask	0x702	/* 1794 */

#define SD_ErrMaxTnTmplt	0x703	/* 1795 */

#define SD_ErrDuplicateSigId	0x704	/* 1796 */

#define SD_ErrInvPamdTmplt	0x705	/* 1797 */

#define SD_ErrInvPvdTmplt	0x706	/* 1798 */

#define SD_ErrInvSilenceTmplt	0x707	/* 1799 */

#define SD_ErrSigId	0x708	/* 1800 */

#define SD_ErrDeleteHandle	0x709	/* 1801 */

#define SD_ErrQualTmpltId	0x70a	/* 1802 */

#define SD_ErrMaxGtdDef	0x70b	/* 1803 */

#define SD_ErrMaxSetDef	0x70c	/* 1804 */

#define SD_ErrMaxPamdDef	0x70d	/* 1805 */

#define SD_ErrMaxPvdDef	0x70e	/* 1806 */

#define SD_ErrMaxPamdQtDef	0x70f	/* 1807 */

#define SD_ErrToneNotFound	0x710	/* 1808 */

#define SD_ErrSetNotFound	0x711	/* 1809 */

#define SD_ErrInvEntry	0x712	/* 1810 */

#define SD_ErrInvNumTmplts	0x713	/* 1811 */

#define SD_ErrInvNumSegs	0x714	/* 1812 */

#define SD_ErrEvtEnable	0x715	/* 1813 */

#define SD_ErrEvtDisable	0x716	/* 1814 */

#define SD_DetectEvt_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	SD_DetectEvt_ReturnAddress_t;

#define SD_DetectEvt_Type_SignalOn	0x700	/* 1792 */

#define SD_DetectEvt_Type_SignalOff	0x701	/* 1793 */

#define SD_DetectEvt_Type	0x380006	/* 3670022 */
typedef	UInt32	SD_DetectEvt_Type_t;

#define SD_DetectEvt_Label	0x38000a	/* 3670026 */
typedef	UInt32	SD_DetectEvt_Label_t;

#define SD_DetectEvt_signalId	0x38000e	/* 3670030 */
typedef	UInt32	SD_DetectEvt_signalId_t;

/*
 * SD_DetectEvt (value = generic) is a message
 * for component SD.
 */


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Type;
	UInt32	Label;
	UInt32	signalId;
} SD_DetectEvt_t;

#define SD_DetectEvt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(SD_DetectEvt_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(SD_DetectEvt_Type), &((structAddr)->Type),	\
			(SD_DetectEvt_Label), &((structAddr)->Label),	\
			(SD_DetectEvt_signalId), &((structAddr)->signalId))


#define SD_DetectEvt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(SD_DetectEvt_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(SD_DetectEvt_Type), &((structAddr)->Type),	\
			(SD_DetectEvt_Label), &((structAddr)->Label),	\
			(SD_DetectEvt_signalId), &((structAddr)->signalId))


#define SD_DetectEvt_Size		18

#define SD_CancelEvt_Type	0x380000	/* 3670016 */
typedef	UInt32	SD_CancelEvt_Type_t;

#define SD_CancelEvt_signalId	0x380004	/* 3670020 */
typedef	UInt32	SD_CancelEvt_signalId_t;

/*
 * SD_CancelEvt (value = generic) is a message
 * for component SD.
 */


typedef struct {
	UInt32	Type;
	UInt32	signalId;
} SD_CancelEvt_t;

#define SD_CancelEvt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_CancelEvt_Type), &((structAddr)->Type),	\
			(SD_CancelEvt_signalId), &((structAddr)->signalId))


#define SD_CancelEvt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_CancelEvt_Type), &((structAddr)->Type),	\
			(SD_CancelEvt_signalId), &((structAddr)->signalId))


#define SD_CancelEvt_Size		8

#define SD_EvtSignalOn_EventLabel	0x380000	/* 3670016 */
typedef	UInt32	SD_EvtSignalOn_EventLabel_t;

#define SD_EvtSignalOn_signalId	0x380004	/* 3670020 */
typedef	UInt32	SD_EvtSignalOn_signalId_t;

#define SD_EvtSignalOn_signalLabel	0x201808	/* 2103304 */
typedef	UInt8	SD_EvtSignalOn_signalLabel_t[4];

#define SD_EvtSignalOn_labelSize	0x20000c	/* 2097164 */
typedef	UInt8	SD_EvtSignalOn_labelSize_t;

#define SD_EvtSignalOn_repCount	0x20000d	/* 2097165 */
typedef	UInt8	SD_EvtSignalOn_repCount_t;

#define SD_EvtSignalOn_freq1	0x28000e	/* 2621454 */
typedef	UInt16	SD_EvtSignalOn_freq1_t;

#define SD_EvtSignalOn_freq2	0x280010	/* 2621456 */
typedef	UInt16	SD_EvtSignalOn_freq2_t;

#define SD_EvtSignalOn_onTime	0x380012	/* 3670034 */
typedef	UInt32	SD_EvtSignalOn_onTime_t;

#define SD_EvtSignalOn_offTime	0x380016	/* 3670038 */
typedef	UInt32	SD_EvtSignalOn_offTime_t;

/*
 * SD_EvtSignalOn (value = generic) is a message
 * for component SD.
 */


typedef struct {
	UInt32	EventLabel;
	UInt32	signalId;
	UInt8	signalLabel[4];
	UInt8	labelSize;
	UInt8	repCount;
	UInt16	freq1;
	UInt16	freq2;
	UInt32	onTime;
	UInt32	offTime;
} SD_EvtSignalOn_t;

#define SD_EvtSignalOn_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(SD_EvtSignalOn_EventLabel), &((structAddr)->EventLabel),	\
			(SD_EvtSignalOn_signalId), &((structAddr)->signalId),	\
			(SD_EvtSignalOn_signalLabel), &((structAddr)->signalLabel),	\
			(SD_EvtSignalOn_labelSize), &((structAddr)->labelSize),	\
			(SD_EvtSignalOn_repCount), &((structAddr)->repCount),	\
			(SD_EvtSignalOn_freq1), &((structAddr)->freq1),	\
			(SD_EvtSignalOn_freq2), &((structAddr)->freq2),	\
			(SD_EvtSignalOn_onTime), &((structAddr)->onTime),	\
			(SD_EvtSignalOn_offTime), &((structAddr)->offTime))


#define SD_EvtSignalOn_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(SD_EvtSignalOn_EventLabel), &((structAddr)->EventLabel),	\
			(SD_EvtSignalOn_signalId), &((structAddr)->signalId),	\
			(SD_EvtSignalOn_signalLabel), &((structAddr)->signalLabel),	\
			(SD_EvtSignalOn_labelSize), &((structAddr)->labelSize),	\
			(SD_EvtSignalOn_repCount), &((structAddr)->repCount),	\
			(SD_EvtSignalOn_freq1), &((structAddr)->freq1),	\
			(SD_EvtSignalOn_freq2), &((structAddr)->freq2),	\
			(SD_EvtSignalOn_onTime), &((structAddr)->onTime),	\
			(SD_EvtSignalOn_offTime), &((structAddr)->offTime))


#define SD_EvtSignalOn_Size		26
/* When a signal on condition has been detected then the body of the 
 * Std_MsgEvtDetected message has this format. EventLabel - Standard RTC label 
 * signalId - Identifies the signal that triggered. signalLabel - Identifies 
 * the signal that triggered. labelSize - The number of valid uint8's in 
 * signalLabel freq1 - Actual Frequency in Hz of tone 1 detected freq2 - Actual 
 * frequency in Hz of tone 2 detected (This parameter will be 0 for single 
 * frequency tones) onTime- Actual On time in 10 ms units offTime- Actual Off 
 * time in 10 ms units repCount - the number of times this tone was detected. 
 * For the first time this tone is detected, the count will be 1 and will 
 * increase with subsequent tone detections. */

#define SD_EvtSignalOff_EventLabel	0x380000	/* 3670016 */
typedef	UInt32	SD_EvtSignalOff_EventLabel_t;

#define SD_EvtSignalOff_signalId	0x380004	/* 3670020 */
typedef	UInt32	SD_EvtSignalOff_signalId_t;

#define SD_EvtSignalOff_signalLabel	0x201808	/* 2103304 */
typedef	UInt8	SD_EvtSignalOff_signalLabel_t[4];

#define SD_EvtSignalOff_labelSize	0x20000c	/* 2097164 */
typedef	UInt8	SD_EvtSignalOff_labelSize_t;

/*
 * SD_EvtSignalOff (value = generic) is a message
 * for component SD.
 */


typedef struct {
	UInt32	EventLabel;
	UInt32	signalId;
	UInt8	signalLabel[4];
	UInt8	labelSize;
} SD_EvtSignalOff_t;

#define SD_EvtSignalOff_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(SD_EvtSignalOff_EventLabel), &((structAddr)->EventLabel),	\
			(SD_EvtSignalOff_signalId), &((structAddr)->signalId),	\
			(SD_EvtSignalOff_signalLabel), &((structAddr)->signalLabel),	\
			(SD_EvtSignalOff_labelSize), &((structAddr)->labelSize))


#define SD_EvtSignalOff_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(SD_EvtSignalOff_EventLabel), &((structAddr)->EventLabel),	\
			(SD_EvtSignalOff_signalId), &((structAddr)->signalId),	\
			(SD_EvtSignalOff_signalLabel), &((structAddr)->signalLabel),	\
			(SD_EvtSignalOff_labelSize), &((structAddr)->labelSize))


#define SD_EvtSignalOff_Size		13
/* When a signal off condition has been detected then the body of the 
 * Std_MsgEvtDetected message has the following format: In the case of signal 
 * off only the last tone on edge is meaningful. labelSize - The number of 
 * valid uint8's in signalLabel */

#define SD_DetectxEvts_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	SD_DetectxEvts_ReturnAddress_t;

#define SD_DetectxEvts_Count	0x380006	/* 3670022 */
typedef	UInt32	SD_DetectxEvts_Count_t;

#define SD_DetectxEvts_varStart	0xa

#define SD_DetectxEvts_List_Type_SignalOn	0x700	/* 1792 */

#define SD_DetectxEvts_List_Type_SignalOff	0x701	/* 1793 */

#define SD_DetectxEvts_List_Type	0x380000	/* 3670016 */
typedef	UInt32	SD_DetectxEvts_List_Type_t;

#define SD_DetectxEvts_List_Label	0x380000	/* 3670016 */
typedef	UInt32	SD_DetectxEvts_List_Label_t;

#define SD_DetectxEvts_List_signalId	0x380000	/* 3670016 */
typedef	UInt32	SD_DetectxEvts_List_signalId_t;


typedef struct {
	UInt32	Type;
	UInt32	Label;
	UInt32	signalId;
} SD_DetectxEvts_List_t;

#define SD_DetectxEvts_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(SD_DetectxEvts_List_Type), &((structAddr)->Type),	\
			(SD_DetectxEvts_List_Label), &((structAddr)->Label),	\
			(SD_DetectxEvts_List_signalId), &((structAddr)->signalId))


#define SD_DetectxEvts_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(SD_DetectxEvts_List_Type), &((structAddr)->Type),	\
			(SD_DetectxEvts_List_Label), &((structAddr)->Label),	\
			(SD_DetectxEvts_List_signalId), &((structAddr)->signalId))


#define SD_DetectxEvts_List_Size		12

#define SD_DetectxEvts_List	0xd	/* 13 */

/*
 * SD_DetectxEvts (value = generic) is a message
 * for component SD.
 */


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Count;
} SD_DetectxEvts_t;

#define SD_DetectxEvts_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_DetectxEvts_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(SD_DetectxEvts_Count), &((structAddr)->Count))


#define SD_DetectxEvts_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_DetectxEvts_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(SD_DetectxEvts_Count), &((structAddr)->Count))


#define SD_DetectxEvts_Size		10

#define SD_CancelxEvts_Count	0x380000	/* 3670016 */
typedef	UInt32	SD_CancelxEvts_Count_t;

#define SD_CancelxEvts_varStart	0x4

#define SD_CancelxEvts_List_Type	0x380000	/* 3670016 */
typedef	UInt32	SD_CancelxEvts_List_Type_t;

#define SD_CancelxEvts_List_signalId	0x380000	/* 3670016 */
typedef	UInt32	SD_CancelxEvts_List_signalId_t;


typedef struct {
	UInt32	Type;
	UInt32	signalId;
} SD_CancelxEvts_List_t;

#define SD_CancelxEvts_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_CancelxEvts_List_Type), &((structAddr)->Type),	\
			(SD_CancelxEvts_List_signalId), &((structAddr)->signalId))


#define SD_CancelxEvts_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_CancelxEvts_List_Type), &((structAddr)->Type),	\
			(SD_CancelxEvts_List_signalId), &((structAddr)->signalId))


#define SD_CancelxEvts_List_Size		8

#define SD_CancelxEvts_List	0xe	/* 14 */

/*
 * SD_CancelxEvts (value = generic) is a message
 * for component SD.
 */


typedef struct {
	UInt32	Count;
} SD_CancelxEvts_t;

#define SD_CancelxEvts_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(SD_CancelxEvts_Count), &((structAddr)->Count))


#define SD_CancelxEvts_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(SD_CancelxEvts_Count), &((structAddr)->Count))


#define SD_CancelxEvts_Size		4

#define SD_Action_Label	0x380000	/* 3670016 */
typedef	UInt32	SD_Action_Label_t;

#define SD_Action_Type_RtcUseIdle	0x700	/* 1792 */

#define SD_Action_Type_RtcUseXmit	0x701	/* 1793 */

#define SD_Action_Type_RtcSuspendId	0x702	/* 1794 */

#define SD_Action_Type_RtcResumeId	0x703	/* 1795 */

#define SD_Action_Type_RtcDisableEcho	0x704	/* 1796 */

#define SD_Action_Type_RtcEnableEcho	0x705	/* 1797 */

#define SD_Action_Type_StartSilenceTimers	0x706	/* 1798 */

#define SD_Action_Type	0x380004	/* 3670020 */
typedef	UInt32	SD_Action_Type_t;

/*
 * SD_Action (value = generic) is a message
 * for component SD.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
} SD_Action_t;

#define SD_Action_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(SD_Action_Label), &((structAddr)->Label),	\
			(SD_Action_Type), &((structAddr)->Type))


#define SD_Action_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(SD_Action_Label), &((structAddr)->Label),	\
			(SD_Action_Type), &((structAddr)->Type))


#define SD_Action_Size		8
/* This action will cause the Instance to use the idle qualification template 
 * for tone detection. This is optimal when no audio is being transmitted. */
/* This action will cause the Instance to use the xmit qualification template 
 * for its tone detection. This is optimal for when the Instance is 
 * transmitting audio. In general this template is more sensitive to allow for 
 * better cut through. */
/* This action will cause the Instance to suspend signal detection on the 
 * specified by the parameter ParmSuspendId. This will deactivate detection of 
 * these signals without requiring all the detect events to be disarmed. */
/*
 * This will cause all the signals referred to by ParmSuspendId to be re-enabled.
 */
/* For use with FT_SILENCE_POSTPONE templates, instituted when fixing PT 
 * 26745. This will start the postponed silence timers. */

#define SD_EvtSilOnOff_EventLabel	0x380000	/* 3670016 */
typedef	UInt32	SD_EvtSilOnOff_EventLabel_t;

#define SD_EvtSilOnOff_signalId	0x380004	/* 3670020 */
typedef	UInt32	SD_EvtSilOnOff_signalId_t;

#define SD_EvtSilOnOff_timeStamp	0x380008	/* 3670024 */
typedef	UInt32	SD_EvtSilOnOff_timeStamp_t;

#define SD_EvtSilOnOff_Dummy	0x20000c	/* 2097164 */
typedef	UInt8	SD_EvtSilOnOff_Dummy_t;

/*
 * SD_EvtSilOnOff (value = generic) is a message
 * for component SD.
 */


typedef struct {
	UInt32	EventLabel;
	UInt32	signalId;
	UInt32	timeStamp;
	UInt8	Dummy;
} SD_EvtSilOnOff_t;

#define SD_EvtSilOnOff_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(SD_EvtSilOnOff_EventLabel), &((structAddr)->EventLabel),	\
			(SD_EvtSilOnOff_signalId), &((structAddr)->signalId),	\
			(SD_EvtSilOnOff_timeStamp), &((structAddr)->timeStamp),	\
			(SD_EvtSilOnOff_Dummy), &((structAddr)->Dummy))


#define SD_EvtSilOnOff_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(SD_EvtSilOnOff_EventLabel), &((structAddr)->EventLabel),	\
			(SD_EvtSilOnOff_signalId), &((structAddr)->signalId),	\
			(SD_EvtSilOnOff_timeStamp), &((structAddr)->timeStamp),	\
			(SD_EvtSilOnOff_Dummy), &((structAddr)->Dummy))


#define SD_EvtSilOnOff_Size		13

#define SD_Std_ComponentType	0x7	/* 7 */
/*
 * Signal Detector specific attributes Standard Attribute Types
 */

#define SD_Capability_Tone	0x1	/* 1 */

#define SD_Capability_Silence	0x2	/* 2 */

#define SD_Capability_Dtd	0x3	/* 3 */

#define SD_Capability_Pvd	0x4	/* 4 */

#define SD_Capability_Pamd	0x5	/* 5 */

#define SD_Capability_Dpd	0x6	/* 6 */
/*
 * End of all Component Definitions
 */

#define SD_Capability	0x400	/* 1024 */
typedef	QCompAttr	SD_Capability_t;

#define SD	0x7	/* 7 */

typedef struct {
	UInt32		ParmMaxTnTmpts;
	UInt32		ParmMaxTnDefs;
	UInt32		ParmMaxGroupCnt;
	UInt32		ParmEchoDefault;
	UInt32		ParmMaxSigsPerInst;
	UInt32		ParmDtmfTalkOffFlag;
	UInt32		ParmEchoDelayFactor;
	UInt32		ParmModel;
	UInt32		ParmLastCompParm;
	UInt32		ParmWaitForDnldCmplt;
	UInt32		ParmLowWall;
	UInt32		ParmMinEnergy;
	UInt32		ParmDefDomain;
	UInt32		ParmTwistMax;
	UInt32		ParmSuspendId;
	UInt32		ParmLastInstParm;

} SDparm_t;

#if defined ( SD_DEFINED )

ParmStruct SDParmTab []= {
{SD_ParmMaxTnTmpts, 16, 0, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmMaxTnTmpts), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmMaxTnDefs), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmMaxGroupCnt), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmEchoDefault), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmMaxSigsPerInst), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmDtmfTalkOffFlag), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmEchoDelayFactor), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmModel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmLastCompParm), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmWaitForDnldCmplt), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmLowWall), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmMinEnergy), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmDefDomain), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmTwistMax), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmSuspendId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(SDparm_t, ParmLastInstParm), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_sd_defs_h_) */
