#ifndef _CALL_H__
#define _CALL_H__
#include <sdsignal.h>

/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Chris Chuba
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    27-Mar-96 at 15:01:00
 * LAST-MOD:     11-Mar-03 at 10:50:33 by Baowen Chen
 * PURPOSE:
 *    This module defines various signal id's relevant to Dialogic specific
 *    technology.
 *    
 * HISTORY:
 * Date        Who   Description
 * 28-Feb-2003 BC    Task 17490: Enhanced CPA phase 1b. 
 *                   1. Re-define the PAMD ids to reflect using Springware 
 *                      pamd_spdval to indicate which PAMD type will be used 
 *                      instead of using the DM3 pamd signal Id (lower 5 
 *                      bits) to indicate the type.
 *                   2. Also added user defined SIT tone signal IDs.
 *                   3. Re-ordered the AMD_DEFAULT/AMD_FULL/AMD_QUICK to
 *                       match the Springware ACCU/FULL/QUICK.
 *                   4. Added decinal and hex values for newly defined signal IDs.
 * 03-Oct-2002 BC    Task 15850: Added new PVD/PAMD id for user defined templates.
 ***************************************************************************/

/*
 * Special Information Tone (SIT) aka, operator intercept.
 * NC - No Circuit found.
 * IC - Operator Intercep
 * VC - Vacant Circuit (non-registered number).
 * RO - ReOrder (System Busy)
 * ANY- One of the above defintions but the exact one could not be
 *      determined.
 */
enum {
   NC=1, 
   IC,
   VC,
   RO,
   ANY_SIT
};

#define  CreateSITSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_SIT_SET =CreateCountrySet(SD_SIT_START,LETTER1, LETTER2), \
   PREFIX##_SIT_NC, \
   PREFIX##_SIT_IC, \
   PREFIX##_SIT_VC, \
   PREFIX##_SIT_RO, \
   PREFIX##_SIT_ANY \
};


#define  CreateBusySet(PREFIX,LETTER1,LETTER2) \
enum { \
   PREFIX##_BUSY_SET =CreateCountrySet(SD_BUSY_START,LETTER1, LETTER2), \
   PREFIX##_BUSY, \
   PREFIX##_BUSY_FAST \
};


/*
 * Dial Tone 
 */
#define  CreateDIALSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_DIALTONE_SET =CreateCountrySet(SD_DIALTONE_START,LETTER1, LETTER2), \
   PREFIX##_DIALTONE1,  \
   PREFIX##_Dm3_DIALTONE2   \
};

#define  CreateRingingSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_RINGING_SET =CreateCountrySet(SD_RINGING_START,LETTER1, LETTER2), \
   PREFIX##_RINGING1,   \
   PREFIX##_RINGING2    \
};

enum {
   REGULAR_B=1,   /* The Regular busy */
   FAST_B         /* The Fast Busy */
};


/*
 * FAX Set (The CED Tone)
 */
#define  CreateFaxCEDSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_FAX_CED_SET =CreateCountrySet(SD_FAX_CED_START,LETTER1, LETTER2), \
   PREFIX##_FAX_CED1, \
   PREFIX##_FAX_CED2  \
};

/*
 * FAX Set (The CNG Tone)
 */
#define  CreateFaxCNGSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_FAX_CNG_SET =CreateCountrySet(SD_FAX_CNG_START,LETTER1, LETTER2), \
 PREFIX##_FAX_CNG1, \
 PREFIX##_FAX_CNG2 \
};

/*
 * PVD Set
 */
#define  CreatePVDSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_PVD_SET =CreateCountrySet(SD_PVD_START,LETTER1, LETTER2), \
 PREFIX##_PVD1, \
 PREFIX##_PVD2_USER_DEFINED, \
 PREFIX##_PVD3_USER_DEFINED, \
 PREFIX##_PVD4_USER_DEFINED, \
 PREFIX##_PVD5_USER_DEFINED \
};

/*
 * PAMD Set.
 */
#if 0
enum {
   AMD_DEFAULT=1,/* (safest and slowest) 
               Always wait till the end of the greeting */
   AMD_MEDIUM,  /* Full algorithm */
   AMD_QUICK    /* (qickest and most error prone)
               Decide as soon as the voice is detected */
};
#else /* Re-ordered to match the Springware FULL/QUICK/ACCU defines. */
enum {
   AMD_MEDIUM=1,  /* Full algorithm */
   AMD_QUICK,     /* (qickest and most error prone)
                     Decide as soon as the voice is detected */
   AMD_DEFAULT    /* (safest and slowest) 
                     Always wait till the end of the greeting */
};
#endif

#define  CreatePAMDSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_Dm3_PAMD_SET =CreateCountrySet(SD_PAMD_START,LETTER1, LETTER2), \
 PREFIX##_Dm3_PAMD_DEFAULT, \
 PREFIX##_Dm3_PAMD_MEDIUM, \
 PREFIX##_Dm3_PAMD_QUICK, \
 PREFIX##_Dm3_PAMD_USER_DEFINED, \
 PREFIX##_Dm3_PAMD_USER_DEFINED2, \
 PREFIX##_Dm3_PAMD_USER_DEFINED3, \
 PREFIX##_Dm3_PAMD_USER_DEFINED4 \
};


/*y
 * All the following macros are used to create country code variations 
 * of a specific signal set.
 */
CreateRingingSet(XX,'X','X')/* Creates all the Id's in ... XX_RINGING_SET */
CreateRingingSet(GB,'G','B')/* Creates all the Id's in ... GB_RINGING_SET */
CreateRingingSet(JP,'J','P')/* Creates all the Id's in ... JP_RINGING_SET */
CreateFaxCEDSet(XX,'X','X')/* Creates all the Id's in ... XX_FAX_CED_SET */
CreateFaxCNGSet(XX,'X','X')/* Creates all the Id's in ... XX_FAX_CNG_SET */
CreatePVDSet(XX,'X','X')   /* Creates all the Id's in ... XX_PVD_SET */
CreatePAMDSet(XX,'X','X')  /* Creates all the Id's in ... XX_PAMD_SET */
CreateDIALSet(XX,'X','X')  /* Creates all the Id's in ... XX_DIALTONE_SET */
CreateDIALSet(JP,'J','P')  /* Creates all the Id's in ... JP_DIALTONE_SET */
CreateBusySet(XX,'X','X')  /* Creates all the Id's in ... XX_BUSY_SET */
CreateBusySet(GB,'G','B')  /* Creates all the Id's in ... GB_BUSY_SET */
CreateBusySet(JP,'J','P')  /* Creates all the Id's in ... JP_BUSY_SET */
CreateSITSet(XX,'X','X')   /* Creates all the Id's in ... XX_SIT_SET */
CreateSITSet(JP,'J','P')   /* Creates all the Id's in ... JP_SIT_SET */

/* Thailand Specific Tones */
/* PT 17501 Addition of Thailand specific signal ids.*/
CreateDIALSet(TH,'T','H')   /* Creates all the Id's in ... TH_DIALTONE_SET */
CreateRingingSet(TH,'T','H')/* Creates all the Id's in ... TH_RINGING_SET */
CreateBusySet(TH,'T','H')   /* Creates all the Id's in ... TH_BUSY_SET */
CreateSITSet(TH,'T','H')    /* Creates all the Id's in ... TH_SIT_SET */

CreateSITSet(YY,'Y','Y')    /* Creates all the Id's in ... YY_SIT_SET */
#define DM3_ZIPTONE_SET  YY_SIT_SET
#define DM3_ZIPTONE      YY_SIT_NC

/*
 * All the SIT signal id definitions.
 */
#define  SIT_SET        XX_SIT_SET  /* 0x2f240, 193088 */
#define  SIT_NC         XX_SIT_NC   /* 0x2f241, 193089 */
#define  SIT_IC         XX_SIT_IC   /* 0x2f242, 193090 */
#define  SIT_VC         XX_SIT_VC   /* 0x2f243, 193091 */
#define  SIT_RO         XX_SIT_RO   /* 0x2f244, 193092 */
#define  SIT_ANY        XX_SIT_ANY  /* 0x2f245, 193093 */
/*
 * User defined SIT signal id definitions.
 */
CreateSITSet(XY,'X','Y')    /* Creates all the Id's in ... XY_SIT_SET */
#define  USER_DEFINED_SIT_SET          XY_SIT_SET /* 0x2f580, 193920 */
#define  USER_DEFINED_SIT_NC           XY_SIT_NC  /* 0x2f581, 193921 */
#define  USER_DEFINED_SIT_IC           XY_SIT_IC  /* 0x2f582, 193922 */
#define  USER_DEFINED_SIT_VC           XY_SIT_VC  /* 0x2f583, 193923 */
#define  USER_DEFINED_SIT_RO           XY_SIT_RO  /* 0x2f584, 193924 */
#define  USER_DEFINED_SIT_ANY          XY_SIT_ANY /* 0x2f585, 193925 */
CreateSITSet(XZ,'X','Z')    /* Creates all the Id's in ... XZ_SIT_SET */
#define  USER_DEFINED_SIT_SET_2        XZ_SIT_SET /* 0x2f8c0, 194752 */
#define  USER_DEFINED_SIT_NC_2         XZ_SIT_NC  /* 0x2f8c1, 194753 */
#define  USER_DEFINED_SIT_IC_2         XZ_SIT_IC  /* 0x2f8c2, 194754 */
#define  USER_DEFINED_SIT_VC_2         XZ_SIT_VC  /* 0x2f8c3, 194755 */
#define  USER_DEFINED_SIT_RO_2         XZ_SIT_RO  /* 0x2f8c4, 194756 */
#define  USER_DEFINED_SIT_ANY_2        XZ_SIT_ANY /* 0x2f8c5, 194757 */
CreateSITSet(YX,'Y','X')    /* Creates all the Id's in ... YX_SIT_SET */
#define  USER_DEFINED_SIT_SET_3        YX_SIT_SET /* 0x2f260, 193120 */
#define  USER_DEFINED_SIT_NC_3         YX_SIT_NC  /* 0x2f261, 193121 */
#define  USER_DEFINED_SIT_IC_3         YX_SIT_IC  /* 0x2f262, 193122 */
#define  USER_DEFINED_SIT_VC_3         YX_SIT_VC  /* 0x2f263, 193123 */
#define  USER_DEFINED_SIT_RO_3         YX_SIT_RO  /* 0x2f264, 193124 */
#define  USER_DEFINED_SIT_ANY_3        YX_SIT_ANY /* 0x2f265, 193125 */
CreateSITSet(ZX,'Z','X')    /* Creates all the Id's in ... ZX_SIT_SET */
#define  USER_DEFINED_SIT_SET_4        ZX_SIT_SET /* 0x2f280, 193152 */
#define  USER_DEFINED_SIT_NC_4         ZX_SIT_NC  /* 0x2f281, 193153 */
#define  USER_DEFINED_SIT_IC_4         ZX_SIT_IC  /* 0x2f282, 193154 */
#define  USER_DEFINED_SIT_VC_4         ZX_SIT_VC  /* 0x2f283, 193155 */
#define  USER_DEFINED_SIT_RO_4         ZX_SIT_RO  /* 0x2f284, 193156 */
#define  USER_DEFINED_SIT_ANY_4        ZX_SIT_ANY /* 0x2f285, 193157 */

/*
 * All the BUSY signal id definitions.
 */
#define  BUSY_SET       XX_BUSY_SET
#define  BUSY           XX_BUSY        /* The regular busy signal */
#define  BUSY_FAST      XX_BUSY_FAST

/*
 * All the RINGING signal id definitions.
 */
#define  RINGING_SET    XX_RINGING_SET
#define  RINGING1       XX_RINGING1   /* Single ring by convention */
#define  RINGING2       XX_RINGING2   /* Double Ring by convention */

/*
 * All the DIALTONE signal id definitions.
 */
#define  DIALTONE_SET   XX_DIALTONE_SET
#define  DIALTONE1      XX_DIALTONE1
#define  Dm3_DIALTONE2      XX_Dm3_DIALTONE2
#define  DIALTONE2      Dm3_DIALTONE2

/*
 * All the FAX CED signal id definitions.
 */
#define  FAX_CED_SET    XX_FAX_CED_SET
#define  FAX_CED1       XX_FAX_CED1
#define  FAX_CED2       XX_FAX_CED2

/*
 * All the FAX CNG signal id definitions.
 */
#define  FAX_CNG_SET    XX_FAX_CNG_SET
#define  FAX_CNG1       XX_FAX_CNG1
#define  FAX_CNG2       XX_FAX_CNG2

/*
 * All the PVD signal id definitions.
 */
#define  PVD_SET              XX_PVD_SET            
#define  PVD1                 XX_PVD1              /* 0x1f4c1, 128193. */
#define  PVD2_USER_DEFINED    XX_PVD2_USER_DEFINED /* 0x1f4c2, 128194. */ 
#define  PVD3_USER_DEFINED    XX_PVD3_USER_DEFINED /* 0x1f4c3, 128195. */ 
#define  PVD4_USER_DEFINED    XX_PVD4_USER_DEFINED /* 0x1f4c4, 128196. */ 
#define  PVD5_USER_DEFINED    XX_PVD5_USER_DEFINED /* 0x1f4c5, 128197. */ 

/*
 * All the PAMD signal id definitions.
 */
#define  Dm3_PAMD_SET               XX_Dm3_PAMD_SET            
#define  Dm3_PAMD_DEFAULT           XX_Dm3_PAMD_DEFAULT       /* 0x1a041,106561 */
#define  Dm3_PAMD_MEDIUM            XX_Dm3_PAMD_MEDIUM        /* 0x1a042,106562 */
#define  Dm3_PAMD_QUICK             XX_Dm3_PAMD_QUICK         /* 0x1a043,106563 */
#define  Dm3_PAMD_USER_DEFINED      XX_Dm3_PAMD_USER_DEFINED  /* 0x1a044,106564 */
#define  Dm3_PAMD_USER_DEFINED2     XX_Dm3_PAMD_USER_DEFINED2 /* 0x1a045,106565 */
#define  Dm3_PAMD_USER_DEFINED3     XX_Dm3_PAMD_USER_DEFINED3 /* 0x1a046,106566 */
#define  Dm3_PAMD_USER_DEFINED4     XX_Dm3_PAMD_USER_DEFINED4 /* 0x1a047,106567 */

#define  PAMD_SET           Dm3_PAMD_SET
#define  PAMD_DEFAULT       Dm3_PAMD_DEFAULT

#endif

