/*******************************************************************************
*
*	File:		setupReq.h	
*
*	Function:	None
*
*	Description:	Defines for setup request message bound for CCS.
*
*
*******************************************************************************/
#ifndef _SETUPREQ_H
#define _SETUPREQ_H

#if defined(PRI_DPNSS) || defined(PRI_DASS2)
#include "MkCallBlk.h"
#include "seginfo.h"

/*
*  Function prototypes
*/

int setupReq(BYTE a_BChanID,
		  BYTE a_SIC,
					 BOOLEAN a_SendingComplete_b,
								char * a_SelectionField_p,
										  BYTE *a_OutMsg_p);
#else
/*
*	Function prototypes
*/
int setupReq(char *,
             char *,
             BYTE layer1Protocol,	/* G.711 Alaw or Mulaw */
             BYTE DChanID,
             BYTE BChanID,
             BOOLEAN complete,
             BYTE *outMsg);

int setupRequest(char *destAddr,      /* Destination address */
                 char *origAddr,      /* Orignation address */
                 BYTE layer1Protocol, /* G.711 Alaw or Mulaw */
                 BYTE exclusive,      /* channel exclusive flag */
                 BYTE BChanID,        /* B channel id */
                 BOOLEAN complete,    /* For Euro-ISDN, if Setup is complete */
                 BYTE bearerCaps,     /* bearer capabilities */
                 BYTE *outMsg);       /* Output ieData body */

int setupRequest2(
	char *destAddr, 		/* Called Party Number (Destination address) */
	BYTE calledType,		/* Called Party Number Type */
	BYTE calledPlan,		/* Called Party Number Plan */
	char *origAddr, 		/* Calling Party Number (Origination address) */
	BYTE callingType,		/* Calling Party Number Type */
	BYTE callingPlan,		/* Calling Party Number Plan */
	BYTE callingPresentation,	/* Calling Party Number Presentation */
	BYTE callingScreening,		/* Calling Party Number Screening */
	BYTE layer1Protocol,	/* G.711 Alaw or Mulaw */
	BYTE exclusive,      /* channel exclusive flag */
	BYTE BChanID,        /* B channel id */
	BOOLEAN complete,    /* For Euro-ISDN, if Setup is complete */
   BYTE bearerCaps,     /* bearer capabilities */
   BYTE bearerRate,     /* info transfer rate */
	BYTE *outMsg,        /* Output ieData body */
	int ccsInstNum);

/*
*	Defines for buffers, lengths, etc.
*/
#define SREQ_MAX_BUFFER		420		/*add'n of max IE values*/

#endif


#endif
