/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         sigdlocs.h
 * AUTHOR:       Art Elwell
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    24-Aug-00 at 18:03:04
 * PURPOSE:
 *
 * HISTORY:
 * Date			Who	Description
 * 12-Feb-03   AK    Added error code for query tone function. If write
 * message fails report error
 * 11-Sep-02   JB    Added error codes 360-362 for DTI16
 * 05-Mar-02   AR    New Error codes for CreateXTones and DeleteXTones.
 *                   SIGDET_LOC_355 to SIGDET_LOC_359
 *                   (Task-12758:PT-N/A)
 * 07-Jan-02   BC    Task#11877, Merged Luna into the Sigdet baseline. Added
 *                   the Luna specific error message from SIGDET_LOC_502 to
 *                   SIGDET_LOC_509. 
 * 06-NOV-01   AR    Task#11085, Added new error from SIGDET_LOC_351 to SIGDET_LOC_354
 * 15-AUG-01   XKM   Task9459, Added new error from SIGDET_LOC_347 to SIGDET_LOC_350
 *                   for Std_MsgClearPendingAction message support.
 * 30-Jul-01   AR    Added new error from SIGDET_LOC_338 to SIGDET_LOC_346
 * 31-May-01   XKM   Added new error from SIGDET_LOC_333 to SIGDET_LOC_337
 *                   for SignalCount event. 
 * 30-May-01   BC    Added new error code from SIGDET_LOC_331 to SIGDET_LOC_332.
 * 10-May-01   BC    Added new error from SIGDET_LOC_323 to SIGDET_LOC_330
 *                   for extended messages.
 * 18-Apr-01   AR    Added new error SIGDET_LOC_321 and SIGDET_LOC_322 for sdDetermineModel
 * 26-Feb-01   BC    Added new error SIGDET_LOC_320 for DelayFactor.
 * 14-Feb-01   BC    Added new errors for new sigdet code. The newly defined
 *                   error codes are from  SIGDET_LOC_312 to SIGDET_LOC_319. 
 * 13-Apr-00   AE    Initial Version
 ***************************************************************************/

#if !defined(_sigdetLocations_h)
#define _sigdetLocations_h 1

#include "qmiscapi.h"

void sigdetErrKillTask ( Uint24 errTag );
void sigdetErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc );
void sigdetErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                               int arg1, int arg2, int arg3, int arg4 );
void sigdetErrWarning ( Uint24 errTag );
void sigdetErrInstWarning ( Uint24 errTag, QCompDesc *pDesc );
void sigdetErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                              int arg1, int arg2, int arg3, int arg4 );
void sigdetErrAdvisory ( Uint24 errTag );
void sigdetErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc );
void sigdetErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                               int arg1, int arg2, int arg3, int arg4 );


#if !defined(_SIGDET_C__)
extern char *sigdetLocationsFileName;
#else
char *sigdetLocationsFileName = "sigdlocs.h";
/******************************************************************************
 *       NAME : sigdetErrKillTask
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_KILLTASK.
s *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrKillTask ( Uint24 errTag )
{
   qError (QERR_KILLTASK, errTag, sigdetLocationsFileName);
}

/******************************************************************************
 *       NAME : sigdetErrInstKillTask
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_KILLTASK, errTag, sigdetLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : sigdetErrArgsKillTask
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
   int count=4;
   qErrorArgs (QERR_KILLTASK, errTag, sigdetLocationsFileName, pDesc, count, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : sigdetErrWarning
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrWarning ( Uint24 errTag )
{
  qError (QERR_WARNING, errTag, sigdetLocationsFileName);
}

/******************************************************************************
 *       NAME : sigdetErrInstWarning
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrInstWarning ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_WARNING, errTag, sigdetLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : sigdetErrArgsWarning
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_WARNING, errTag, sigdetLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : sigdetErrAdvisory
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrAdvisory ( Uint24 errTag )
{
  qError (QERR_ADVISORY, errTag, sigdetLocationsFileName);
}

/******************************************************************************
 *       NAME : sigdetErrInstAdvisory
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_ADVISORY, errTag, sigdetLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : sigdetErrArgsAdvisory
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void sigdetErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_ADVISORY, errTag, sigdetLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

#endif



#define SIGDET_LOC_000	0x800000 /* sigdet:.c:(),
				    */

#define SIGDET_LOC_001	0x800001 /* sigdet:bufdet.c:
				    During initialization, the modulus for the hash
                function is not close to the full size of the hash table */

#define SIGDET_LOC_002	0x800002 /* sigdet:bufdet.c:
				    Unrecognized transaction in QFTimerExpired */

#define SIGDET_LOC_003	0x800003 /* sigdet:bufdet.c:
				    qClusterByComp failurewhile trying to determine which cluster
                this instance is in */

#define SIGDET_LOC_004	0x800004 /* sigdet:bufdet.c:+
				    qCompAllocate failure */

#define SIGDET_LOC_005	0x800005 /* sigdet:bufdet.c:
				    qHostExitCmplt failure */

#define SIGDET_LOC_006	0x800006 /* sigdet:bufdet.c:
				    Unexpected message type */

#define SIGDET_LOC_007	0x800007 /* sigdet:bufdet.c:
				    Unexpected message  */

#define SIGDET_LOC_008	0x800008 /* sigdet:bufdet.c:
				    qCompRegister failure */

#define SIGDET_LOC_009	0x800009 /* sigdet:bufdet.c:
				    RtcCreatePool failure */

#define SIGDET_LOC_010	0x800010 /* sigdet:bufmgt.c: 
                Unknown format for terminating null */

#define SIGDET_LOC_011	0x800011 /* sigdet:bufmgt.c: 
                Unable to allocate message 
                SB_MsgRetrieveCmplt, qMsgAllocate FAILURE*/

#define SIGDET_LOC_012	0x800012 /* sigdet:bufmgt.c: 
                Unknow SB format */   

#define SIGDET_LOC_013	0x800013 /* sigdet:bufmgt.c: 
                Unable to allocate message 
                SB_Detected, qMsgAllocate FAILURE*/

#define SIGDET_LOC_014	0x800014 /* sigdet:bufmgt.c: 
                SB_Detected_put failure */   

#define SIGDET_LOC_015	0x800015 /* sigdet:bufmgt.c: 
                Unable to send SB_Detected, 
                qMsgWrite FAILURE */

#define SIGDET_LOC_016	0x800016 /* sigdet:bufmgt.c: 
                Unable to allocate message 
                SB_Detected, qMsgAllocate FAILURE*/

#define SIGDET_LOC_017	0x800017 /* sigdet:bufmgt.c: 
                qMsgFree failure */

#define SIGDET_LOC_018	0x800018 /* sigdet:bufmgt.c: 
                no terminating conditions occurred
                and we cannot start another timer*/

#define SIGDET_LOC_019	0x800019 /* sigdet:bufmgt.c: 
                qMsgAllocate failed for MIN_MSG_SIZE */

#define SIGDET_LOC_020	0x800020 /* sigdet:bufmgt.c: 
                Output message type has not been set */

#define SIGDET_LOC_021	0x800021 /* sigdet:bufpattn.c: 
                Unknown state */

#define SIGDET_LOC_022	0x800022 /* sigdet:bufpattn.c: 
                Unable to allocate message 
                Std_MsgEvtDetected, qMsgAllocate FAILURE*/

#define SIGDET_LOC_023	0x800023 /* sigdet:bufpattn.c: 
                Unable to allocate message 
                Std_MsgEvtDetected, qMsgAllocate FAILURE*/

#define SIGDET_LOC_024	0x800024 /* sigdet:bufpattn.c: 
                Unable to allocate storage for
                the free list of pattern detect nodes */

#define SIGDET_LOC_025	0x800025 /* sigdet:bufsbmsg.c: 
                RtcDisarmRTC FAILURE */

#define SIGDET_LOC_026	0x800026 /* sigdet:bufsbmsg.c: 
                Unable to allocate message 
                Std_MsgDetectEvtCmplt, qMsgAllocate FAILURE*/

#define SIGDET_LOC_027	0x800027 /* sigdet:bufsbmsg.c: 
                Unable to allocate message 
                Std_MsgEvtDetected, qMsgAllocate FAILURE*/

#define SIGDET_LOC_028	0x800028 /* sigdet:bufsbmsg.c: 
                Unable to allocate message 
                Std_MsgDetectEvtCmplt, qMsgAllocate FAILURE*/

#define SIGDET_LOC_029	0x800029 /* sigdet:bufsbmsg.c: 
                Failed during allocation of instance database */

#define SIGDET_LOC_030	0x800030 /* sigdet:bufsbmsg.c:(),
                qCompInstanceRegister FAILURE */

#define SIGDET_LOC_031	0x800031 /* sigdet:bufsbmsg.c:(),
                Failure during allocation of tone template ref buffer */

#define SIGDET_LOC_032	0x800032 /* sigdet:bufsbmsg.c:(),
                Failure during allocation of tone template ref delta buffer */

#define SIGDET_LOC_033	0x800033 /* sigdet:bufsbmsg.c:(),
                sbMsgError called */

#define SIGDET_LOC_034	0x800034 /* sigdet:ca_det.c:(),
                Failed during allocation of instance database */

#define SIGDET_LOC_035	0x800035 /* sigdet:ca_det.c:(),
                qCompInstanceRegister FAILURE */

#define SIGDET_LOC_036	0x800036 /* sigdet:ca_det.c:(),
                caMsgError called */

#define SIGDET_LOC_037	0x800037 /* sigdet:ca_det.c:(),
                qClusterByComp FAILURE */

#define SIGDET_LOC_038	0x800038 /* sigdet:ca_det.c:(),
                qCompAllocate FAILURE */

#define SIGDET_LOC_039	0x800039 /* sigdet:ca_det.c:(),
                qHostExitCmplt FAILURE */

#define SIGDET_LOC_040	0x800040 /* sigdet:ca_det.c:(),
                Unexpected message type */

#define SIGDET_LOC_041	0x800041 /* sigdet:ca_det.c:(),
                processCaMsg called */

#define SIGDET_LOC_042	0x800042 /* sigdet:ca_det.c:(),
                Unable to allocate
                SD_CancelEvt, qMsgAllocate FAILURE */

#define SIGDET_LOC_043	0x800043 /* sigdet:ca_det.c:(),
                Unable to allocate
                MIN_MSG_SIZE, qMsgAllocate FAILURE */

#define SIGDET_LOC_044	0x800044 /* sigdet:ca_det.c:(),
                Unable to allocate
                Std_MsgError, qMsgAllocate FAILURE */

#define SIGDET_LOC_045	0x800045 /* sigdet:ca_det.c:(),
                qFTimerSet FAILURE */

#define SIGDET_LOC_046	0x800046 /* sigdet:ca_det.c:(),
                qFTimerSet FAILURE */

#define SIGDET_LOC_047	0x800047 /* sigdet:ca_det.c:(),
                Unable to allocate
                Std_MsgError, qMsgAllocate FAILURE */

#define SIGDET_LOC_048	0x800048 /* sigdet:ca_det.c:(),
                qFTimerSet FAILURE */

#define SIGDET_LOC_049	0x800049 /* sigdet:ca_det.c:(),
                Unable to allocate
                Std_MsgError, qMsgAllocate FAILURE */

#define SIGDET_LOC_050	0x800050 /* sigdet:ca_det.c:(),
                Unable to allocate
                Std_MsgEvtDetected, qMsgAllocate FAILURE */

#define SIGDET_LOC_051	0x800051 /* sigdet:ca_det.c:(),
                Unable to allocate
                Std_MsgEvtDetected, qMsgAllocate FAILURE */

#define SIGDET_LOC_052	0x800052 /* sigdet:ca_det.c:(),
                qMsgFree FAILURE */

#define SIGDET_LOC_053	0x800053 /* sigdet:ca_det.c:(),
                qFTimerSet FAILURE */

#define SIGDET_LOC_054	0x800054 /* sigdet:ca_det.c:(),
                Unable to allocate
                Std_MsgError, qMsgAllocate FAILURE */

#define SIGDET_LOC_055	0x800055 /* sigdet:ca_det.c:(),
                endCallAnalysis FAILURE */

#define SIGDET_LOC_056	0x800056 /* sigdet:ca_det.c:(),
                Illegal State */

#define SIGDET_LOC_057	0x800057 /* sigdet:ca_det.c:(),
                qTaskCompSelf FAILURE */

#define SIGDET_LOC_058	0x800058 /* sigdet:ca_det.c:(),
                qCompRegister FAILURE */

#define SIGDET_LOC_059	0x800059 /* sigdet:ca_det.c:(),
                Unexpected/unknown message type */

#define SIGDET_LOC_060	0x800060 /* sigdet:ca_det.c:(),
                qMsgFree failure */

#define SIGDET_LOC_061	0x800061 /* sigdet:gtdalg.c:(),
                Unable to allocate tone ref in single tone case,
                malloc FAILURE */

#define SIGDET_LOC_062	0x800062 /* sigdet:gtdalg.c:(),
                Tone ref count has become equal to TNREF_COUNT */

#define SIGDET_LOC_063	0x800063 /* sigdet:gtdalg.c:(),
                Hash table index too large */

#define SIGDET_LOC_064	0x800064 /* sigdet:gtdalg.c:(),
                Unable to allocate tone ref in dual tone case,
                malloc FAILURE */

#define SIGDET_LOC_065	0x800065 /* sigdet:gtdalg.c:(),
                Tone ref count has become equal to TNREF_COUNT */

#define SIGDET_LOC_066	0x800066 /* sigdet:gtdalg.c:(),
                Tone Def not found */

#define SIGDET_LOC_067	0x800067 /* sigdet:gtdalg.c:(),
                Hash table index too large */

#define SIGDET_LOC_068	0x800068 /* sigdet:gtdalg.c:(),
                Tone Def not found */

#define SIGDET_LOC_069	0x800069 /* sigdet:gtdalg.c:(),
                Tone Def not found */

#define SIGDET_LOC_070	0x800070 /* sigdet:gtdalg.c:(),
                Hash table index too large */

#define SIGDET_LOC_071	0x800071 /* sigdet:gtdalg.c:(),
                Tone Def not found */

#define SIGDET_LOC_072	0x800072 /* sigdet:gtdalg.c:(),
                Number of GTD templates has reached maximum */

#define SIGDET_LOC_073	0x800073 /* sigdet:gtdalg.c:(),
                gtdCreateTone FAILURE */

#define SIGDET_LOC_074	0x800074 /* sigdet:gtdalg.c:(),
                gtdCreateTone FAILURE */

#define SIGDET_LOC_075	0x800075 /* sigdet:gtdalg.c:(),
                qMemCalloc failure */

#define SIGDET_LOC_076	0x800076 /* sigdet:gtdalg.c:(),
                Illegal State */

#define SIGDET_LOC_077	0x800077 /* sigdet:gtdalg.c:(),
                Illegal State */

#define SIGDET_LOC_078	0x800078 /* sigdet:gtdalg.c:(),
                Illegal State */

#define SIGDET_LOC_079	0x800079 /* sigdet:gtdalg.c:(),
                Illegal State */

#define SIGDET_LOC_080	0x800080 /* sigdet:gtdalg.c:(),
                Tone template index out-of-range */

#define SIGDET_LOC_081	0x800081 /* sigdet:gtdalg.c:(),
                Tone template index out-of-range */

#define SIGDET_LOC_082	0x800082 /* sigdet:gtdmain.c:(),
                qGStreamRead FAILURE  */

#define SIGDET_LOC_083	0x800083 /* sigdet:gtdmain.c:(),
                gtdMsgError called */

#define SIGDET_LOC_084	0x800084 /* sigdet:gtdmain.c:(),
                gtdCreateTone FAILURE */

#define SIGDET_LOC_085	0x800085 /* sigdet:gtdmain.c:(),
                qGStreamOpen FAILURE */

#define SIGDET_LOC_086	0x800086 /* sigdet:gtdmain.c:(),
                Unable to allocate WA_MsgSetupRpt, 
                qMsgAllocate FAILURE */
                                    
#define SIGDET_LOC_087	0x800087 /* sigdet:gtdmain.c:(),
                Unable to send WA_MsgSetupRpt, 
                qMsgWrite FAILURE */

#define SIGDET_LOC_088	0x800088 /* sigdet:gtdmain.c:(),
                Unexpected/unknown message type */

#define SIGDET_LOC_089	0x800089 /* sigdet:gtdmain.c:(),
                qMsgFree FAILURE */

#define SIGDET_LOC_090	0x800090 /* sigdet:gtdmain.c:(),
                Unable to  allocate the local memory buffers 
                which get the FFT data DMA'd into it from global memory */

#define SIGDET_LOC_091	0x800091 /* sigdet:gtdmain.c:(),
                Unexpected/unknown message type */

#define SIGDET_LOC_092	0x800092 /* sigdet:gtdmain.c:(),
                QNO_POOL_AVAILABLE for qPoolFind(QMemXFER,FFT_REC_DATA_SIZE) */

#define SIGDET_LOC_093	0x800093 /* sigdet:gtdmain.c:(),
                QPOOL_EXHAUSTED for fftData = qPoolAlloc(poolId) */

#define SIGDET_LOC_094	0x800094 /* sigdet:gtdmain.c:(),
                Unable to allocate message
                Recorder_MsgStartCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_095	0x800095 /* sigdet:gtdmain.c:(),
                Unable to send Recorder_MsgStartCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_096	0x800096 /* sigdet:gtdmain.c:(),
                Unexpected message type in RecState_Opening state */

#define SIGDET_LOC_097	0x800097 /* sigdet:gtdmain.c:(),
                Input message transaction id is greater than gtdComp.waCount */

#define SIGDET_LOC_098	0x800098 /* sigdet:gtdmain.c:(),
                WA instance id is greater than maximum */

#define SIGDET_LOC_099	0x800099 /* sigdet:gtdmain.c:(),
                GTDALG: SP Stopped sending messages  */

#define SIGDET_LOC_100	0x800100 /* sigdet:gtdmain.c:(),
                dBMOffset(minerg) paramter is less than zero  */

#define SIGDET_LOC_101	0x800101 /* sigdet:gtdmain.c:(),
                dBMOffset(minerg) paramter is greater than MAX_ELTS_DBMTOWA */

#define SIGDET_LOC_102	0x800102 /* sigdet:gtdmain.c:(),
                qGStreamClose FAILURE */

#define SIGDET_LOC_103	0x800103 /* sigdet:gtdmain.c:(),
                Unable to allocate message Recorder_MsgStopped,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_104	0x800104 /* sigdet:gtdmain.c:(),
                Unable to send message Recorder_MsgStopped,
                qMsgWrite FAILURE */

#define SIGDET_LOC_105	0x800105 /* sigdet:gtdmain.c:(),
                qPoolFree FAILURE */

#define SIGDET_LOC_106	0x800106 /* sigdet:gtdmain.c:(),
                Invalid gtdFftRecord state */

#define SIGDET_LOC_107	0x800107 /* sigdet:gtdmain.c:(),
                qGStreamIndexWrite FAILURE */

#define SIGDET_LOC_108	0x800108 /* sigdet:gtdmain.c:(),
                qGStreamAdvanceWrite FAILURE  */

#define SIGDET_LOC_109	0x800109 /* sigdet:gtdmain.c:(),
                qGStreamIndexWrite FAILURE */

#define SIGDET_LOC_110	0x800110 /* sigdet:gtdmain.c:(),
                qGStreamAdvanceWrite FAILURE  */

#define SIGDET_LOC_111	0x800111 /* sigdet:gtdmain.c:(),
                qGStreamIndexWrite FAILURE */

#define SIGDET_LOC_112	0x800112 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_PamdDetected,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_113	0x800113 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_PamdDetected,
                qMsgWrite FAILURE */

#define SIGDET_LOC_114	0x800114 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_PvdDetected,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_115	0x800115 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_PvdDetected,
                qMsgWrite FAILURE */

#define SIGDET_LOC_116	0x800116 /* sigdet:gtdmain.c:(),
                Tome template list pointer is empty */

#define SIGDET_LOC_117	0x800117 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_ToneOn,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_118	0x800118 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_ToneOn,
                qMsgWrite FAILURE */

#define SIGDET_LOC_119	0x800119 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_ToneOff,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_120	0x800120 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_ToneOff,
                qMsgWrite FAILURE */

#define SIGDET_LOC_121	0x800121 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_ToneOn,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_122	0x800122 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_ToneOn,
                qMsgWrite FAILURE */

#define SIGDET_LOC_123	0x800123 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_ToneOff,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_124	0x800124 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_ToneOff,
                qMsgWrite FAILURE */

#define SIGDET_LOC_125	0x800125 /* sigdet:gtdmain.c:(),
                qCompDeregister FAILURE */

#define SIGDET_LOC_126	0x800126 /* sigdet:gtdmain.c:(),
                qCompRegister FAILURE*/

#define SIGDET_LOC_127	0x800127 /* sigdet:gtdmain.c:(),
                Unable to allocate message WA_MsgUseTxSt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_128	0x800128 /* sigdet:gtdmain.c:(),
                Unable to allocate message WA_MsgStart,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_129	0x800129 /* sigdet:gtdmain.c:(),
                Unable to send message WA_MsgStart,
                qMsgWrite FAILURE */

#define SIGDET_LOC_130	0x800130 /* sigdet:gtdmain.c:(),
                Unable to allocate message WA_MsgStop,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_131	0x800131 /* sigdet:gtdmain.c:(),
                Unable to send message WA_MsgStop,
                qMsgWrite FAILURE */

#define SIGDET_LOC_132	0x800132 /* sigdet:gtdmain.c:(),
                PVD number out of range  */

#define SIGDET_LOC_133	0x800133 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_StopCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_134	0x800134 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_StopCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_135	0x800135 /* sigdet:gtdmain.c:(),
                Unable to allocate message WA_MsgStart,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_136	0x800136 /* sigdet:gtdmain.c:(),
                Unable to send message WA_MsgStart,
                qMsgWrite FAILURE */

#define SIGDET_LOC_137	0x800137 /* sigdet:gtdmain.c:(),
                Unable to allocate message GTD_StartCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_138	0x800138 /* sigdet:gtdmain.c:(),
                Unable to send message GTD_StartCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_139	0x800139 /* sigdet:gtdmain.c:(),
                Unexpected WA_MsgRpt */

#define SIGDET_LOC_140	0x800140 /* sigdet:.c:(),
                Not used  */

#define SIGDET_LOC_141	0x800141 /* sigdet:gtdpamd.c:(),
                Inout argument indicating PAMD/PVD is zero */

#define SIGDET_LOC_142	0x800142 /* sigdet:gtdpamd.c:(),
                Unknown algorithm type requested */

#define SIGDET_LOC_143	0x800143 /* sigdet:gtdpamd.c:(),
                amd_state is AMD_PVD_ST - This is only a 
                transition state and is called directly from 
                either AMD_RINGON_ST or AMD_RINGOFF_ST */

#define SIGDET_LOC_144	0x800144 /* sigdet:gtdpamd.c:(),
                Unknown amd_state */

#define SIGDET_LOC_145	0x800145 /* sigdet:sigcad.c:(),
                Signal ID not in table */

#define SIGDET_LOC_146	0x800146 /* sigdet:sigcad.c:(),
                Unable to allocate SD_EvtSignalOn,
                qMsgAllocate FAILURE*/

#define SIGDET_LOC_147	0x800147 /* sigdet:sigcad.c:(),
                Unable to send SD_EvtSignalOn,
                qMsgWrite FAILURE*/

#define SIGDET_LOC_148	0x800148 /* sigdet:sigcad.c:(),
                Unable to allocate SD_EvtSignalOff,
                qMsgAllocate FAILURE*/

#define SIGDET_LOC_149	0x800149 /* sigdet:sigcad.c:(),
                Unable to send SD_EvtSignalOff,
                qMsgWrite FAILURE*/

#define SIGDET_LOC_150	0x800150 /* sigdet:sigcad.c:(),
                ToneTrackAlloc: invalid entry (either TN_TRACK_SENTINEL
                or TN_TRACK_DISABLED)  */

#define SIGDET_LOC_151	0x800151 /* sigdet:sigcad.c:(),
                ToneTrackFree: invalid entry (either TN_TRACK_SENTINEL
                or TN_TRACK_DISABLED)  */

#define SIGDET_LOC_152	0x800152 /* sigdet:sigcad.c:(),
                ToneTrackAlloc: the free list is empty */

#define SIGDET_LOC_153	0x800153 /* sigdet:sigcad.c:(),
                Invalid ToneTrack state */

#define SIGDET_LOC_154	0x800154 /* sigdet:sigcad.c:(),
                Invalid ToneTrack state */

#define SIGDET_LOC_155	0x800155 /* sigdet:sigcad.c:(),
                Invalid ToneTrack state */

#define SIGDET_LOC_156	0x800156 /* sigdet:sigdet.c:(),
                Unable to allocate tone template ref,
                malloc FAILURE*/

#define SIGDET_LOC_157	0x800157 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx FAILURE*/

#define SIGDET_LOC_158	0x800158 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx FAILURE */

#define SIGDET_LOC_159	0x800159 /* sigdet:sigdet.c:(),
                Failure in freeing tone template*/

#define SIGDET_LOC_160	0x800160 /* sigdet:sigdet.c:(),
                Failure in freeing tone template */

#define SIGDET_LOC_161	0x800161 /* sigdet:sigdet.c:(),
                Unable to add entry into the set table*/

#define SIGDET_LOC_162	0x800162 /* sigdet:sigdet.c:(),
                Hash table FAILURE*/

#define SIGDET_LOC_163	0x800163 /* sigdet:sigdet.c:(),
                Hash table FAILURE */

#define SIGDET_LOC_164	0x800164 /* sigdet:sigdet.c:(),
                BIT_FINDFIRSTSETex FAILURE*/

#define SIGDET_LOC_165	0x800165 /* sigdet:sigdet.c:(),
                sdCreateToneSetAdd: hash value is not ENTRY_FREE an not ENTRY_IDSET */

#define SIGDET_LOC_166	0x800166 /* sigdet:sigdet.c:(),
                Failure freeing the setNumber in thebitIdSetTable */

#define SIGDET_LOC_167	0x800167 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx:BAD LEAK key(%d) and index(%d) found */

#define SIGDET_LOC_168	0x800168 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx:ENTRY_TONE and key != qToneSignalTmplts[ivalue].id*/

#define SIGDET_LOC_169	0x800169 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx:ENTRY_PVD and key != qPvdSignalTmplts[ivalue].id */

#define SIGDET_LOC_170	0x800170 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx:ENTRY_PAMD and key != qPamdSignalTmplts[ivalue].signalId */

#define SIGDET_LOC_171	0x800171 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx:ENTRY_IDSET and key != sigComp.idSetTable[ivalue].id*/

#define SIGDET_LOC_172	0x800172 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx:key = %d has no type associated. type = %d */

#define SIGDET_LOC_173	0x800173 /* sigdet:sigdet.c:(),
                qCompDeregister FAILURE */  

#define SIGDET_LOC_174	0x800174 /* sigdet:sigdet.c:(),
                qCompDeregister FAILURE */  

#define SIGDET_LOC_175	0x800175 /* sigdet:sigdet.c:(),
                Unable to allocate the memory for the global Tone Definition 
                to Tone Template lookup table,
                malloc failure */  

#define SIGDET_LOC_176	0x800176 /* sigdet:sigdet.c:(),
                Unable to allocate the memory for the idSet table,
                malloc failure */  

#define SIGDET_LOC_177	0x800177 /* sigdet:sigdet.c:(),
                The mask indicates that the id is in the hash table but it
                can't be found */

#define SIGDET_LOC_178	0x800178 /* sigdet:sigdet.c:(),
                qClusterSlotInfo FAILURE */

#define SIGDET_LOC_179	0x800179 /* sigdet:sigdet.c:(),
                qClusterByComp FAILURE */

#define SIGDET_LOC_180	0x800180 /* sigdet:sigdet.c:(),
                qClusterSlotInfo FAILURE */

#define SIGDET_LOC_181	0x800181 /* sigdet:sigdet.c:(),
                Unable to allocate GTD_Start,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_182	0x800182 /* sigdet:sigdet.c:(),
                Unable to send GTD_Start,
                qMsgWrite FAILURE */

#define SIGDET_LOC_183	0x800183 /* sigdet:sigdet.c:(),
                Unable to allocate GTD_Stop,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_184	0x800184 /* sigdet:sigdet.c:(),
                Unable to send GTD_Start,
                qMsgWrite FAILURE */

#define SIGDET_LOC_185	0x800185 /* sigdet:sigdet.c:(),
                Could not find the cluster of sigdet
                qClusterByComp FAILURE */

#define SIGDET_LOC_186	0x800186 /* sigdet:sigdet.c:(),
                qHostExitCmplt FAILURE */

#define SIGDET_LOC_187	0x800187 /* sigdet:sigdet.c:(),
                more than two activate messages */

#define SIGDET_LOC_188	0x800188 /* sigdet:sigdet.c:(),
                means the FSM wasn't implemented properly */

#define SIGDET_LOC_189	0x800189 /* sigdet:sigdet.c:(),
                means the FSM wasn't implemented properly */

#define SIGDET_LOC_190	0x800190 /* sigdet:sigdet.c:(),
                fewer than 0 deactivate messages */

#define SIGDET_LOC_191	0x800191 /* sigdet:sigdet.c:(),
                means the FSM wasn't implemented properly */

#define SIGDET_LOC_192	0x800192 /* sigdet:sigdet.c:(),
                Unexpected message */

#define SIGDET_LOC_193	0x800193 /* sigdet:sigdet.c:(),
                processGtdToneOn:Tone Template List is empty */

#define SIGDET_LOC_194	0x800194 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgEvtDetected,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_195	0x800195 /* sigdet:sigdet.c:(),
                Unable to send SD_EvtSignalOn,
                qMsgWrite FAILURE */

#define SIGDET_LOC_196	0x800196 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgEvtDetected,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_197	0x800197 /* sigdet:sigdet.c:(),
                Unable to send SD_EvtSignalOn,
                qMsgWrite FAILURE */

#define SIGDET_LOC_198	0x800198 /* sigdet:sigdet.c:(),
                GTD_StopCmplt received with active state other than RI_STOPPING */

#define SIGDET_LOC_199	0x800199 /* sigdet:sigdet.c:(),
                GTD_StartCmplt received with active state other than RI_STARTING */

#define SIGDET_LOC_200	0x800200 /* sigdet:sigdet.c:(),
                Unexpected message type */

#define SIGDET_LOC_201	0x800201 /* sigdet:sigdet.c:(),
                Unable to allocate GTD_SilEnd,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_202	0x800202 /* sigdet:sigdet.c:(),
                Unable to send GTD_SilEnd,
                qMsgWrite FAILURE */

#define SIGDET_LOC_203	0x800203 /* sigdet:sigdet.c:(),
                sdGtdStart: Tone not disabled */

#define SIGDET_LOC_204	0x800204 /* sigdet:sigdet.c:(),
                Unable to allocate GTD_SilStart,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_205	0x800205 /* sigdet:sigdet.c:(),
                Unable to send GTD_SilStart,
                qMsgWrite FAILURE */

#define SIGDET_LOC_206	0x800206 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgSetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_207	0x800207 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgSetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_208	0x800208 /* sigdet:sigdet.c:(),
                Unable to allocate memory for output message  ,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_209	0x800209 /* sigdet:sigdet.c:(),
                Unable to send output message,
                qMsgWrite FAILURE */

#define SIGDET_LOC_210	0x800210 /* sigdet:sigdet.c:(),
                Unable to allocate memory for output message  ,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_211	0x800211 /* sigdet:sigdet.c:(),
                Unable to send output message,
                qMsgWrite FAILURE */

#define SIGDET_LOC_212	0x800212 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_213	0x800213 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_214	0x800214 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_215	0x800215 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_216	0x800216 /* sigdet:sigdet.c:(),
                Unable to allocate SD_MsgCreatePvdSigCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_217	0x800217 /* sigdet:sigdet.c:(),
                Unable to send SD_MsgCreatePvdSigCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_218	0x800218 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_219	0x800219 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_220	0x800220 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_221	0x800221 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_222	0x800222 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_223	0x800223 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_224	0x800224 /* sigdet:sigdet.c:(),
                Unable to allocate SD_MsgCreatePamdSigCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_225	0x800225 /* sigdet:sigdet.c:(),
                Unable to send SD_MsgCreatePamdSigCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_226	0x800226 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx FAILURE */

#define SIGDET_LOC_227	0x800227 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx FAILURE */

#define SIGDET_LOC_228	0x800228 /* sigdet:sigdet.c:(),
                sdRemoveToneTmplt: Tone Ref not found */

#define SIGDET_LOC_229	0x800229 /* sigdet:sigdet.c:(),
                sdRemoveToneTmplt: Tone Ref not found */

#define SIGDET_LOC_230	0x800230 /* sigdet:sigdet.c:(),
                Freeing the toneTmpltNum FAILURE */

#define SIGDET_LOC_231	0x800231 /* sigdet:sigdet.c:(),
                maxEntries not zero */

#define SIGDET_LOC_232	0x800232 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_233	0x800233 /* sigdet:sigdet.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_234	0x800234 /* sigdet:sigdet.c:(),
                Unable to allocate SD_MsgWAInfoCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_235	0x800235 /* sigdet:sigdet.c:(),
                Unable to send SD_MsgWAInfoCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_236	0x800236 /* sigdet:sigdet.c:(),
                Unable to allocate SD_MsgFlushSignalsCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_237	0x800237 /* sigdet:sigdet.c:(),
                Unable to send SD_MsgFlushSignalsCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_238	0x800238 /* sigdet:sigdet.c:(),
                sdSignalIdToIndexEx FAILURE */

#define SIGDET_LOC_239	0x800239 /* sigdet:sigdet.c:(),
                Unable to allocate SD_MsgCreateToneCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_240	0x800240 /* sigdet:sigdet.c:(),
                Unable to send  SD_MsgCreateToneCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_241	0x800241 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_242	0x800242 /* sigdet:sigdet.c:(),
                Unable to send  Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_243	0x800243 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_244	0x800244 /* sigdet:sigdet.c:(),
                Unable to send  Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_245	0x800245 /* sigdet:sigdet.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_246	0x800246 /* sigdet:sigdet.c:(),
                Unable to send  Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_247	0x800247 /* sigdet:sigdet.c:(),
                sdDeleteToneSetDelete FAILURE */

#define SIGDET_LOC_248	0x800248 /* sigdet:sigdet.c:(),
                Unable to allocate SD_MsgDeleteToneCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_249	0x800249 /* sigdet:sigdet.c:(),
                Unable to send  SD_MsgDeleteToneCmplt,
                qMsgWrite FAILURE */

#define SIGDET_LOC_250	0x800250 /* sigdet:sigdet.c:(),
                SIGDET: Received a setQual Msg */

#define SIGDET_LOC_251	0x800251 /* sigdet:sigdet.c:(),
                SIGDET: Received a getQual Msg */

#define SIGDET_LOC_252	0x800252 /* sigdet:sigdet.c:(),
                SIGDET: SD_MsgCreatePvdSignal Received */

#define SIGDET_LOC_253	0x800253 /* sigdet:sigdet.c:(),
                SIGDET: SD_MsgCreatePamdSignal Received */

#define SIGDET_LOC_254	0x800254 /* sigdet:sigdet.c:(),
                SIGDET: Unsupported message */

#define SIGDET_LOC_255	0x800255 /* sigdet:sigdet.c:(),
                Unable to allocate Recorder_MsgStart,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_256	0x800256 /* sigdet:sigdet.c:(),
                Unable to send  Recorder_MsgStart,
                qMsgWrite FAILURE */

#define SIGDET_LOC_257	0x800257 /* sigdet:sigdet.c:(),
                Unexpected message */

#define SIGDET_LOC_258	0x800258 /* sigdet:sigdet.c:(),
                qTaskCompSelf FAILURE */

#define SIGDET_LOC_259	0x800259 /* sigdet:sigdet.c:(),
                qCompRegister FAILURE */

#define SIGDET_LOC_260	0x800260 /* sigdet:sigdet.c:(),
                Component index exceeds component table size */

#define SIGDET_LOC_261	0x800261 /* sigdet:sigdet.c:(),
                GTD Component number exceeds component table size */

#define SIGDET_LOC_262	0x800262 /* sigdet:sigdet.c:(),
                Unable to create an array of buffer component 
                structures based on the argument from the task create 
                function,
                malloc FAILURE */

#define SIGDET_LOC_263	0x800263 /* sigdet:sigdet.c:(),
                qCompRegister FAILURE */

#define SIGDET_LOC_264	0x800264 /* sigdet:sigdet.c:(),
                Component index exceeds component table size */

#define SIGDET_LOC_265	0x800265 /* sigdet:sigsdmsg.c:(),
                Unable to allocate GTD_StartAlg,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_266	0x800266 /* sigdet:sigsdmsg.c:(),
                Unable to send GTD_StartAlg,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_267	0x800267 /* sigdet:sigsdmsg.c:(),
                Unable to allocate GTD_StartAlg,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_268	0x800268 /* sigdet:sigsdmsg.c:(),
                Unable to send GTD_StartAlg,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_269	0x800269 /* sigdet:sigsdmsg.c:(),
                Unable to allocate GTD_StopAlg,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_270	0x800270 /* sigdet:sigsdmsg.c:(),
                Unable to send GTD_StopAlg,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_271	0x800271 /* sigdet:sigsdmsg.c:(),
                sdCreateToneSetAdd FAILURE */

#define SIGDET_LOC_272	0x800272 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgInitCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_273	0x800273 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgInitCmplt,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_274	0x800274 /* sigdet:sigsdmsg.c:(),
                FAILURE Initally making all the ToneTmplts flags as free */

#define SIGDET_LOC_275	0x800275 /* sigdet:sigsdmsg.c:(),
                FAILURE Initally making all the set table entry flags as free */

#define SIGDET_LOC_276	0x800276 /* sigdet:sigsdmsg.c:(),
                sdSilencePreserver FAILURE */

#define SIGDET_LOC_277	0x800277 /* sigdet:sigsdmsg.c:(),
                Error in creating tone signal templates */

#define SIGDET_LOC_278	0x800278 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgSetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_279	0x800279 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgSetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_280	0x800280 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgInit,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_281	0x800281 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgInit,
                qMsgWrite FAILURE */

#define SIGDET_LOC_282	0x800282 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgError,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_283	0x800283 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgError,
                qMsgWrite FAILURE */

#define SIGDET_LOC_284	0x800284 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgSetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_285	0x800285 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgSetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_286	0x800286 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgSetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_287	0x800287 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgSetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_288	0x800288 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgGetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_289	0x800289 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgGetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_290	0x800290 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgGetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_291	0x800291 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgGetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_292	0x800292 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgSetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_293	0x800293 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgGetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_294	0x800294 /* sigdet:sigsdmsg.c:(),
                Unable to allocate Std_MsgSetParm,
                qMsgAllocate FAILURE */

#define SIGDET_LOC_295	0x800295 /* sigdet:sigsdmsg.c:(),
                Unable to send Std_MsgSetParm,
                qMsgWrite FAILURE */

#define SIGDET_LOC_296	0x800296 /* sigdet:sigsdmsg.c:(),
                Bad RTC action */

#define SIGDET_LOC_297	0x800297 /* sigdet:gtemain.c:(),
        failure to allocate WA_MsgStart message */

#define SIGDET_LOC_298	0x800298 /* sigdet:sigdet.c:(),
        Model chosen is Roc501 but the cluster is Trc kind */

#define SIGDET_LOC_299	0x800299 /* sigdet:sigdet.c:(),
        Model chosen is Trc but the cluster is non-Trc kind */

#define SIGDET_LOC_300	0x800300 /* sigdet:sigdet.c:(),
        Cluster Model is TRC and Got active on Ri2 */

#define SIGDET_LOC_301	0x800301 /* sigdet:sigdet.c:(),
        Got Active on Ri2 while it is active currently */

#define SIGDET_LOC_302	0x800302 /* sigdet:sigdet.c:(),
        Failed to do QClusterSlotInfo on Ri2 when recvd QClusterActive */

#define SIGDET_LOC_303	0x800303 /* sigdet:sigdet.c:(),
        Got Active on Ri1 while it is active currently */

#define SIGDET_LOC_304	0x800304 /* sigdet:sigdet.c:(),
        Failed to do QClusterSlotInfo on Ri1 when recvd QClusterActive */

#define SIGDET_LOC_305	0x800305 /* sigdet:sigdet.c:(),
        Could not find the cluster of sigdet in StartStopFSM */

#define SIGDET_LOC_306	0x800306 /* sigdet:sigdet.c:(),
        failed to get CStreamID of Ni port */

#define SIGDET_LOC_307	0x800307 /* sigdet:sigdet.c:(),
        Got QClusterActive on port sigdet doesn't understand */

#define SIGDET_LOC_308	0x800308 /* sigdet:sigdet.c:(),
        Cluster Model is TRC and Got inactive on Ri2 */

#define SIGDET_LOC_309	0x800309 /* sigdet:sigdet.c:(),
        Got Inactive on Ri2 while it is inactive currently */

#define SIGDET_LOC_310	0x800310 /* sigdet:sigdet.c:(),
        Got Inactive on Ri1 while it is active currently */

#define SIGDET_LOC_311	0x800311 /* sigdet:sigdet.c:(),
        QClusterInactive on port sigdet doesn't understand */
#define SIGDET_LOC_312	0x800312 /* sigdet:sigdet.c:(),
        qPvdSignalTmplts's id not match the one in hashIdTable */

#define SIGDET_LOC_313	0x800313 /* sigdet:sigdet.c:(),
        qPamdSignalTmplts's id not match the one in hashIdTable */

#define SIGDET_LOC_314	0x800314 /* sigdet:sigdet.c:(),
        qToneSignalTmplts'id not match the one in hashIdTable */

#define SIGDET_LOC_315	0x800315 /* sigdet:sigdet.c:(),
        idSetTable'set id not match the one in hashIdTable */

#define SIGDET_LOC_316	0x800316 /* sigdet:sigdet.c:(),
        Can not match the entry type to any one of the pre-defined in sdUpdateRefCount */

#define SIGDET_LOC_317	0x800317 /* sigdet:sigdet.c:(),
        Can not allocate memory for gtd ref in sdAddToneToGtdRefList */

#define SIGDET_LOC_318	0x800318 /* sigdet:sigdet.c:(),
        signal id has no type associated in sdSignalIdToTmpltEntry*/

#define SIGDET_LOC_319	0x800319 /* sigdet:sigdet.c:(),
        id in the hashIdTable not match the one in the templates. */

#define SIGDET_LOC_320	0x800320 /* sigdet:sigdet.c:(),
        failure to get teh DelayFactor from kernel*/

#define SIGDET_LOC_321	0x800321 /* sigdet:sigdet:.c:(),
        failure from qCluseterPortCurrentTalker in sdDetermineModel */

#define SIGDET_LOC_322	0x800322 /* sigdet:sigdet:.c:(),
        the isTalkerPresent is false after calling qClusterPortCurrentTalker
        in sdDetermineModel */

#define SIGDET_LOC_323	0x800323 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgSetParm_get() of sbMsgSetParm()*/

#define SIGDET_LOC_324	0x800324 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgSetxParms_get() of sbMsgSetxParms()*/

#define SIGDET_LOC_325	0x800325 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgCancelxEvts_get() of sbMsgCancelxEvts()*/

#define SIGDET_LOC_326	0x800326 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgCancelxEvts_List_get() of sbMsgCancelxEvts()*/

#define SIGDET_LOC_327	0x800327 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgDetectxEvts_get() of sbMsgDetectxEvts()*/

#define SIGDET_LOC_328	0x800328 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgDetectxEvts_List_get() of sbMsgDetectxEvts()*/

#define SIGDET_LOC_329	0x800329 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgSetxParms_List_get() of sbMsgSetxParms()*/

#define SIGDET_LOC_330	0x800330 /* sigdet:sigsdmsg.c:(),
        failure in SD_DetectxEvts_List_get()*/

#define SIGDET_LOC_331	0x800331 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgDetectxEvts_List_get() of sbMsgDetectxEvts()*/

#define SIGDET_LOC_332	0x800332 /* sigdet:bufsbmsg.c:(),
        failure in Std_MsgDetectxEvts_List_get() of sbMsgDetectxEvts()*/

#define SIGDET_LOC_333  0x800331 /* sigdet:bufmgt.c: qMsgAllocate()
        failure in sbSendEvtSignalCount()*/

#define SIGDET_LOC_334  0x800332 /* sigdet:bufmgt.c: SB_SignalCount_put(),
        failure in sbSendEvtSignalCount()*/

#define SIGDET_LOC_335  0x800333 /* sigdet:bufmgt.c: qMsgWrite(),
        failure in sbSendEvtSignalCount()*/

#define SIGDET_LOC_336  0x800334 /* sigdet:bufmgt.c: qMsgAllocate(),
        failure in sbSendEvtSignalCount()*/

#define SIGDET_LOC_337  0x800335 /* sigdet:bufmgt.c: qMsgFree(),
        failure in sbSendEvtSignalCount()*/


#define SIGDET_LOC_338	0x800338 /* gtdmain.c in gtdFctStart(),
failure qMsgAllocate WA_MsgUseTxSt*/

#define SIGDET_LOC_339	0x800339 /* gtdmain.c.in gtdFctStart(),
failure in qMsgAllocate WA_MsgStart in EC case*/

#define SIGDET_LOC_340	0x800340 /* gtdmain.c: in gtdFctStart(),
failure in qMsgAllocate WA_MsgStart in NON EC case*/

#define SIGDET_LOC_341	0x800341 /* gtdmain.c: in gtdFctStart() 
failure *status != 0 meaning two starts in row */

#define SIGDET_LOC_342	0x800342 /* gtdmain.c: in gtdFctStop()
failure in qMsgAllocate WA_MsgStop*/

#define SIGDET_LOC_343	0x800343 /* gtdmain.c: in gtdFctStop()
failure in qMsgWrite WA_MsgStop*/

#define SIGDET_LOC_344	0x800344 /* gtdmain.c: in gtdFctStop()
failure *status != 1 meaning two stops in row */

#define SIGDET_LOC_345	0x800345 /* sigdet:.c: in sdFctStartCmplt()
failure received back to back WA_MsgStartCmplt*/

#define SIGDET_LOC_346	0x800346 /* sigdet:.c: in sdFctStopCmplt()
failure received back to back WA_MsgStopCmplt*/

#define SIGDET_LOC_347	0x800347 /* sigdet: bufsbmsg.c: qMsgAllocate(),
        failure in sbMsgCancelRTCEvt()*/

#define SIGDET_LOC_348	0x800348 /* sigdet: bufsbmsg.c: Std_MsgClearPendingAction_put()
        failure in sbMsgCancelRTCEvt()*/

#define SIGDET_LOC_349	0x800349 /* sigdet: bufsbmsg.c: qMsgFree()
        failure in sbMsgCancelRTCEvt()*/

#define SIGDET_LOC_350	0x800350 /* sigdet: bufsbmsg.c: qMsgWrite()
        failure in sbMsgCancelRTCEvt()*/


#define SIGDET_LOC_351	0x800351 /* gtdmain.c: gtdFctRefInActive : qMsgAllocate failure */

#define SIGDET_LOC_352	0x800352 /* gtdmain.c: gtdFctRefInActive: qMsgWrite failure */

#define SIGDET_LOC_353	0x800353 /* gtdmain.c: gtdFctRefActive: qMsgAllocate failure */

#define SIGDET_LOC_354	0x800354 /* gtdmain.c: gtdFctActive: qMsgWrite failure */

#define SIGDET_LOC_355	0x800355 /* sigdet.c: case SD_MsgCreateXTones. qMsgAllocate failure */

#define SIGDET_LOC_356	0x800356 /* sigdet.c: case SD_MsgCreateXTones. qMsgWrite failure */

#define SIGDET_LOC_357	0x800357 /* sigdet.c: case SD_MsgCreateXTones. qMsgFree failure */

#define SIGDET_LOC_358	0x800358 /* sigdet.c: sdSendStdMsgEx qMsgAllocate failure */

#define SIGDET_LOC_359	0x800359 /* sigdet.c: sdSendStdMsgEx qMsgWrite failure */

#define SIGDET_LOC_360	0x800360 /* sigdet:gtdmain.c-gtdCompMsg.WA
                                    Index is greater than number of WA Comps.
                                    
                                    failure */

#define SIGDET_LOC_361	0x800361 /* sigdet:gtdmain.c-gtdCompMsg,Null pointer
                                    failure */

#define SIGDET_LOC_362	0x800362 /* sigdet:gtdmain.c-gtdCompMsg,instance is
                                    greater than max number of instances
                                    failure */

#define SIGDET_LOC_363	0x800363 /* sigdet: sigdet.c Failed to do
                                    qClusterSlotInfo on Ri1,
                                    failure */

#define SIGDET_LOC_364	0x800364 /* sigdet:sigdet.c Could not find the
                                    cluster of sigdet in StartDelayedFSM
                                    failure */

#define SIGDET_LOC_365	0x800365 /* sigdet: sigdet.c failed to get CStreamID 
                                    of Ni port (StartDelayedFSM)
                                    failure */

#define SIGDET_LOC_366	0x800366 /* sigdet:compfile.c:(),
failure */

#define SIGDET_LOC_367	0x800367 /* sigdet:compfile.c:(),
failure */

#define SIGDET_LOC_368	0x800368 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_369	0x800369 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_370	0x800370 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_371	0x800371 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_372	0x800372 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_373	0x800373 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_374	0x800374 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_375	0x800375 /* sigdet:.c:(),
failureE*/

#define SIGDET_LOC_376	0x800376 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_377	0x800377 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_378	0x800378 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_379	0x800379 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_380	0x800380 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_381	0x800381 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_382	0x800382 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_383	0x800383 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_384	0x800384 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_385	0x800385 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_386	0x800386 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_387	0x800387 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_388	0x800388 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_389	0x800389 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_390	0x800390 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_391	0x800391 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_392	0x800392 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_393	0x800393 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_394	0x800394 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_395	0x800395 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_396	0x800396 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_397	0x800397 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_398	0x800398 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_399	0x800399 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_400	0x800400 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_401	0x800401 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_402	0x800402 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_403	0x800403 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_404	0x800404 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_405	0x800405 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_406	0x800406 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_407	0x800407 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_408	0x800408 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_409	0x800409 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_410	0x800410 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_411	0x800411 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_412	0x800412 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_413	0x800413 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_414	0x800414 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_415	0x800415 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_416	0x800416 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_417	0x800417 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_418	0x800418 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_419	0x800419 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_420	0x800420 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_421	0x800421 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_422	0x800422 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_423	0x800423 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_424	0x800424 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_425	0x800425 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_426	0x800426 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_427	0x800427 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_428	0x800428 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_429	0x800429 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_430	0x800430 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_431	0x800431 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_432	0x800432 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_433	0x800433 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_434	0x800434 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_435	0x800435 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_436	0x800436 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_437	0x800437 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_438	0x800438 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_439	0x800439 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_440	0x800440 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_441	0x800441 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_442	0x800442 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_443	0x800443 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_444	0x800444 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_445	0x800445 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_446	0x800446 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_447	0x800447 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_448	0x800448 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_449	0x800449 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_450	0x800450 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_451	0x800451 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_452	0x800452 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_453	0x800453 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_454	0x800454 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_455	0x800455 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_456	0x800456 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_457	0x800457 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_458	0x800458 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_459	0x800459 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_460	0x800460 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_461	0x800461 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_462	0x800462 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_463	0x800463 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_464	0x800464 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_465	0x800465 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_466	0x800466 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_467	0x800467 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_468	0x800468 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_469	0x800469 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_470	0x800470 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_471	0x800471 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_472	0x800472 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_473	0x800473 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_474	0x800474 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_475	0x800475 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_476	0x800476 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_477	0x800477 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_478	0x800478 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_479	0x800479 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_480	0x800480 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_481	0x800481 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_482	0x800482 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_483	0x800483 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_484	0x800484 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_485	0x800485 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_486	0x800486 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_487	0x800487 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_488	0x800488 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_489	0x800489 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_490	0x800490 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_491	0x800491 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_492	0x800492 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_493	0x800493 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_494	0x800494 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_495	0x800495 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_496	0x800496 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_497	0x800497 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_498	0x800498 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_499	0x800499 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_500	0x800500 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_501	0x800501 /* sigdet:.c:(),
failure */

#define SIGDET_LOC_502	0x800502 /* sigdet:bufdet.c:
				    RtcDeletePool failure */

#define SIGDET_LOC_503	0x800503 /* sigdet:ca_det.c:
				    RtcDeletePool failure */

#define SIGDET_LOC_504	0x800504 /* sigdet:sigsdmsg.c:
				    RtcDeletePool failure */

#define SIGDET_LOC_505	0x800505 /* sigdet:siginit.c:
				    qMsgAllocate failure */

#define SIGDET_LOC_506	0x800506 /* sigdet:siginit.c:
				    qMsgWrite failure */

#define SIGDET_LOC_507	0x800507 /* sigdet:siginit.c:
				    qMsgAllocate failure */

#define SIGDET_LOC_508	0x800508 /* sigdet:siginit.c:
				    qMsgWrite failure */

#define SIGDET_LOC_509	0x800509 /* sigdet:bufsbmsg.c:
				    qMsgFree failure on msgClearAct*/

#define SIGDET_LOC_510  0x800510 /* sigdet.c qMsgAllocate failure in Query tone */

#define SIGDET_LOC_511  0x800511 /*sigdet.c qMsgWrite failure in Query Tone */
#endif

