/**
 * @file  sm_mtkevts.h
 * @date  May 8, 2007
 * @brief Stream Manipulation Media Toolkit Library Events
 *
 * DIALOGIC CONFIDENTIAL      
 * Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to
 * the source code ("Material") are owned by Dialogic Corporation or its 
 * suppliers or licensors.  Title to the Material remains with Dialogic 
 * Corporation or its suppliers and licensors.  The Material contains trade
 * secrets and proprietary and confidential information of Dialogic or its 
 * suppliers and licensors.  The Material is protected by worldwide copyright
 * and trade secret laws and treaty provisions.  No part of the Material may be
 * used, copied, reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way without Dialogic's prior express written
 * permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual 
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise.  Any license under such intellectual property rights must be
 * express and approved by Dialogic in writing.
 */

#ifndef _SMMTKEVTS_H_
#define _SMMTKEVTS_H_

/**
 * Mask for all SM events
 */
#define SMEV_MASK                       0x5000L

/**
 * Mask for all SM error events
 */
#define SMEV_ERROR_MASK                 (SMEV_MASK | 0x100)

/**
 * Define success events
 */
#define SMEV_ADD_OVERLAY                (SMEV_MASK | 0x01)  /*!> successful addition of overlays */
#define SMEV_REMOVE_OVERLAY             (SMEV_MASK | 0x02)  /*!> successful removal of overlays */
#define SMEV_REMOVE_ALL_OVERLAYS        (SMEV_MASK | 0x03)  /*!> successful removal of all overlays */
#define SMEV_DISABLE_EVENT              (SMEV_MASK | 0x04)  /*!> successful disabling of event */
#define SMEV_ENABLE_EVENT               (SMEV_MASK | 0x05)  /*!> successful enabling of event */

/**
 * Notification events
 */
#define SMEV_OVERLAY_COMPLETED          (SMEV_MASK | 0x30)  /*!> overlay completion */

/**
 * Last event code (not real event)
 */
#define SMEV_LAST_EVENT                 (SMEV_MASK | 0xFF)

/**
 * General failure event
 * Indicates general failure during response processing
 * It may be anything ranging from memory errors to implementation assertions
 * May be generated as a response to any request
 */
#define SMEV_ERROR                      (SMEV_ERROR_MASK | 0x00) /*!> General failure event */
#define SMEV_LAST_EVENT_ERROR           (SMEV_ERROR_MASK | 0xFF) /*!> General failure event */

/**
 * Define specific failure events
 * Generated when an error occurs during processing of a particular request 
 */
#define SMEV_ADD_OVERLAY_FAIL           (SMEV_ERROR_MASK | 0x01) /*!> addition of overlays failed */
#define SMEV_REMOVE_OVERLAY_FAIL        (SMEV_ERROR_MASK | 0x02) /*!> removal of overlays failed */
#define SMEV_REMOVE_ALL_OVERLAYS_FAIL   (SMEV_ERROR_MASK | 0x03) /*!> removal of all overlays failed */
#define SMEV_DISABLE_EVENT_FAIL         (SMEV_ERROR_MASK | 0x04)  /*!> disabling of event failed */
#define SMEV_ENABLE_EVENT_FAIL          (SMEV_ERROR_MASK | 0x05)  /*!> enabling of event failed */

#endif /* _SMMTKEVTS_H_ */

