/*Copyright (c) 1995-2001. Intel Corporation. All Rights Reserved. All names, 
 * products, and services mentioned herein are the trademarks or registered 
 * trademarks of their respective organizations and are the sole property of 
 * their respective owners */

/*
 * This file was automatically generated from stddefs.mdl.
 * Author: "DM3"
 * Version: "Revision A1.9"
 * Date: Mon Mar 25 09:27:37 2002
 * The output was written to stddefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_stddefs_h_)
#define _stddefs_h_ 1

#ifdef __cplusplus
extern "C" {
#endif

/* This file describes the list of Standard Mercury Messages and Parameters 
 * that Mercury Components and their Instances may support. */
/* Ack bit definition. This value is OR'd with MsgType value if a Std_MsgAck 
 * message is used as a Response to a command. */

#define	Std_AckReq  0x00200000

/* 
 * Standard Message Definitions
 */

#define Std_MsgError_ErrorMsg	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgError_ErrorMsg_t;

#define Std_MsgError_ErrorCode	0x380004	/* 3670020 */
typedef	UInt32	Std_MsgError_ErrorCode_t;

#define Std_MsgError_Data	0x381808	/* 3676168 */
typedef	UInt32	Std_MsgError_Data_t[4];

/*
 * Std_MsgError (value = 0) is a message of generic use.
 */


typedef struct {
	UInt32	ErrorMsg;
	UInt32	ErrorCode;
	UInt32	Data[4];
} Std_MsgError_t;

#define Std_MsgError_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Std_MsgError_ErrorMsg), &((structAddr)->ErrorMsg),	\
			(Std_MsgError_ErrorCode), &((structAddr)->ErrorCode),	\
			(Std_MsgError_Data), &((structAddr)->Data))


#define Std_MsgError_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Std_MsgError_ErrorMsg), &((structAddr)->ErrorMsg),	\
			(Std_MsgError_ErrorCode), &((structAddr)->ErrorCode),	\
			(Std_MsgError_Data), &((structAddr)->Data))


#define Std_MsgError_Size		24

#define Std_MsgError	0	/* 0 */
/* The Std_MsgError message may be sent by any Component or Instance that 
 * detects any kind of error on an incoming command or as a command is being 
 * processed. Components and Instances should also be able to receive this 
 * message as a valid reply to any command it may send to other Components or 
 * Instances. ErrorMsg - message type where error was detected. If the error 
 * was an asynchronous error not due to any command, then this field should be 
 * set to 0. ErrorCode - reason for error. Standard Errors are listed in 
 * section 8. Component Specific error codes are defined in the individual 
 * Mercury Component Interface Specifications. Data - any extra data to report 
 * as qualification of the error. */
/*
 * The Std_MsgAck message may be used as a Response to a Command.
 */

/*
 * Std_MsgAck (value = 0x1) is a message of generic use.
 */

#define Std_MsgAck_Size		0

#define Std_MsgAck	0x1	/* 1 */
/* The Std_MsgComtest command is sent to establish a communications path with 
 * a Component or Instance and may be used as a primitive debug feature. */

/*
 * Std_MsgComtest (value = 0x2) is a message of generic use.
 */

#define Std_MsgComtest_Size		0

#define Std_MsgComtest	0x2	/* 2 */
/* The Std_MsgComtestCmplt message is sent as a response to the Std_MsgComtest 
 * command. */

/*
 * Std_MsgComtestCmplt (value = 0x3) is a message of generic use.
 */

#define Std_MsgComtestCmplt_Size		0

#define Std_MsgComtestCmplt	0x3	/* 3 */
/* The Std_MsgInit message is sent to a Component or Instance to initialize it 
 * in whatever proprietary way is appropriate. For Components, this command is 
 * sent by the host download utility at startup time. The Component will 
 * usually create its Instances when it receives this message. This command 
 * message may optionally be sent to an Instance, usually by its parent 
 * Component, to initialize it. This command should only be sent once at 
 * initialization time. */

/*
 * Std_MsgInit (value = 0x4) is a message of generic use.
 */

#define Std_MsgInit_Size		0

#define Std_MsgInit	0x4	/* 4 */
/* The Std_MsgInitCmplt message is sent as a response to the Std_MsgInit 
 * command if the Component or Instance successfully initializes. */

/*
 * Std_MsgInitCmplt (value = 0x5) is a message of generic use.
 */

#define Std_MsgInitCmplt_Size		0

#define Std_MsgInitCmplt	0x5	/* 5 */
/* The Std_MsgExit message is sent to a Component or Instance shut it down in 
 * whatever proprietary way is appropriate. This command is usually sent at 
 * shutdown time when a Mercury Load Module is about to be unloaded. The module 
 * exit function will usually send this message to all of the Components in 
 * that module. The Components may then forward this to the Instances supported 
 * by that component. This command should be accepted at all times. */

/*
 * Std_MsgExit (value = 0x6) is a message of generic use.
 */

#define Std_MsgExit_Size		0

#define Std_MsgExit	0x6	/* 6 */
/* The Std_MsgExitCmplt message is sent as a response to the Std_MsgExit 
 * command if the Component or Instance successfully shuts down. */

/*
 * Std_MsgExitCmplt (value = 0x7) is a message of generic use.
 */

#define Std_MsgExitCmplt_Size		0

#define Std_MsgExitCmplt	0x7	/* 7 */

#define Std_MsgSetParm_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgSetParm_Num_t;

#define Std_MsgSetParm_Val	0x380004	/* 3670020 */
typedef	UInt32	Std_MsgSetParm_Val_t;

/*
 * Std_MsgSetParm (value = 0x8) is a message of generic use.
 */


typedef struct {
	QParm	Num;
	UInt32	Val;
} Std_MsgSetParm_t;

#define Std_MsgSetParm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgSetParm_Num), &((structAddr)->Num),	\
			(Std_MsgSetParm_Val), &((structAddr)->Val))


#define Std_MsgSetParm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgSetParm_Num), &((structAddr)->Num),	\
			(Std_MsgSetParm_Val), &((structAddr)->Val))


#define Std_MsgSetParm_Size		8

#define Std_MsgSetParm	0x8	/* 8 */
/* The Std_MsgSetParm message is sent to a Component or Instance to change the 
 * value of one of its parameters. The parameter is defined as the tuple of Num 
 * and Val. Num - parameter number to set. Val - parameter value to set. */
/* The Std_MsgSetParmCmplt message is sent as a response to the Std_MsgSetParm 
 * command if the Component or Instance successfully sets the parameter. */

/*
 * Std_MsgSetParmCmplt (value = 0x9) is a message of generic use.
 */

#define Std_MsgSetParmCmplt_Size		0

#define Std_MsgSetParmCmplt	0x9	/* 9 */

#define Std_MsgSetxParms_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetxParms_Count_t;

#define Std_MsgSetxParms_varStart	0x4

#define Std_MsgSetxParms_List_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgSetxParms_List_Num_t;

#define Std_MsgSetxParms_List_Val	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetxParms_List_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Std_MsgSetxParms_List_t;

#define Std_MsgSetxParms_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgSetxParms_List_Num), &((structAddr)->Num),	\
			(Std_MsgSetxParms_List_Val), &((structAddr)->Val))


#define Std_MsgSetxParms_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgSetxParms_List_Num), &((structAddr)->Num),	\
			(Std_MsgSetxParms_List_Val), &((structAddr)->Val))


#define Std_MsgSetxParms_List_Size		8

#define Std_MsgSetxParms_List	0	/* 0 */

/*
 * Std_MsgSetxParms (value = 0xa) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgSetxParms_t;

#define Std_MsgSetxParms_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgSetxParms_Count), &((structAddr)->Count))


#define Std_MsgSetxParms_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgSetxParms_Count), &((structAddr)->Count))


#define Std_MsgSetxParms_Size		4

#define Std_MsgSetxParms	0xa	/* 10 */
/* The Std_MsgSetxParms message is sent to a Component or Instance to change 
 * the values of one or more of its parameters. Parameters are expressed as 
 * tuples of Num and Val in List. Count - number of parameters to set List - 
 * parameter list. Num - parameter number(s). Val - parameter value(s). */
/* The Std_MsgSetxParmsCmplt message is sent as a response to the 
 * Std_MsgSetxParms command if the Component or Instance successfully updates 
 * the parameter(s). */

/*
 * Std_MsgSetxParmsCmplt (value = 0xb) is a message of generic use.
 */

#define Std_MsgSetxParmsCmplt_Size		0

#define Std_MsgSetxParmsCmplt	0xb	/* 11 */

#define Std_MsgSetParmDef_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgSetParmDef_Num_t;

/*
 * Std_MsgSetParmDef (value = 0xc) is a message of generic use.
 */


typedef struct {
	QParm	Num;
} Std_MsgSetParmDef_t;

#define Std_MsgSetParmDef_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgSetParmDef_Num), &((structAddr)->Num))


#define Std_MsgSetParmDef_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgSetParmDef_Num), &((structAddr)->Num))


#define Std_MsgSetParmDef_Size		4

#define Std_MsgSetParmDef	0xc	/* 12 */
/* The Std_MsgSetParmDef message is sent to a Component or Instance to set the 
 * value of a single parameter to its default value. Num - parameter number. */
/* The Std_MsgSetParmDefCmplt message is sent as a response to the 
 * Std_MsgSetParmDef command if the Component or Instance successfully sets the 
 * parameter to its default value. */

/*
 * Std_MsgSetParmDefCmplt (value = 0xd) is a message of generic use.
 */

#define Std_MsgSetParmDefCmplt_Size		0

#define Std_MsgSetParmDefCmplt	0xd	/* 13 */

#define Std_MsgSetxParmsDef_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetxParmsDef_Count_t;

#define Std_MsgSetxParmsDef_varStart	0x4

#define Std_MsgSetxParmsDef_List_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgSetxParmsDef_List_Num_t;


typedef struct {
	QParm	Num;
} Std_MsgSetxParmsDef_List_t;

#define Std_MsgSetxParmsDef_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgSetxParmsDef_List_Num), &((structAddr)->Num))


#define Std_MsgSetxParmsDef_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgSetxParmsDef_List_Num), &((structAddr)->Num))


#define Std_MsgSetxParmsDef_List_Size		4

#define Std_MsgSetxParmsDef_List	0x1	/* 1 */

/*
 * Std_MsgSetxParmsDef (value = 0xe) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgSetxParmsDef_t;

#define Std_MsgSetxParmsDef_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgSetxParmsDef_Count), &((structAddr)->Count))


#define Std_MsgSetxParmsDef_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgSetxParmsDef_Count), &((structAddr)->Count))


#define Std_MsgSetxParmsDef_Size		4

#define Std_MsgSetxParmsDef	0xe	/* 14 */
/* The Std_MsgSetxParmsDef message is sent to a Component or Instance to set 
 * the value of one or more of its parameters to its default value. Count - 
 * number of parameters to set to default List - parameter list. Num - 
 * parameter number. */
/* The Std_MsgSetxParmsDefCmplt message is sent as a response to the 
 * Std_MsgSetxParmsDef command if the Component or Instance successfully sets 
 * the parameter(s) to the default value(s). */

/*
 * Std_MsgSetxParmsDefCmplt (value = 0xf) is a message of generic use.
 */

#define Std_MsgSetxParmsDefCmplt_Size		0

#define Std_MsgSetxParmsDefCmplt	0xf	/* 15 */
/* The Std_MsgSetAllParmsDef message is sent to a Component or Instance to set 
 * the value of all of its parameters to their default values. */

/*
 * Std_MsgSetAllParmsDef (value = 0x10) is a message of generic use.
 */

#define Std_MsgSetAllParmsDef_Size		0

#define Std_MsgSetAllParmsDef	0x10	/* 16 */
/* The Std_MsgSetAllParmsDefCmplt message is sent as a response to the 
 * Std_MsgSetAllParmsDef command if the Component or Instance successfully sets 
 * all the parameters to their default value. */

/*
 * Std_MsgSetAllParmsDefCmplt (value = 0x11) is a message of generic use.
 */

#define Std_MsgSetAllParmsDefCmplt_Size		0

#define Std_MsgSetAllParmsDefCmplt	0x11	/* 17 */

#define Std_MsgGetParm_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgGetParm_Num_t;

/*
 * Std_MsgGetParm (value = 0x12) is a message of generic use.
 */


typedef struct {
	QParm	Num;
} Std_MsgGetParm_t;

#define Std_MsgGetParm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgGetParm_Num), &((structAddr)->Num))


#define Std_MsgGetParm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgGetParm_Num), &((structAddr)->Num))


#define Std_MsgGetParm_Size		4

#define Std_MsgGetParm	0x12	/* 18 */
/* The Std_MsgGetParm message is sent to a Component or Instance to read the 
 * value of one of its parameters. Num - parameter number to read. */

#define Std_MsgGetParmCmplt_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgGetParmCmplt_Num_t;

#define Std_MsgGetParmCmplt_Val	0x380004	/* 3670020 */
typedef	UInt32	Std_MsgGetParmCmplt_Val_t;

#define Std_MsgGetParmCmplt_TextSize	0x380008	/* 3670024 */
typedef	UInt32	Std_MsgGetParmCmplt_TextSize_t;

#define Std_MsgGetParmCmplt_varStart	0xc

#define Std_MsgGetParmCmplt_Text	0x500000	/* 5242880 */
typedef	Char	Std_MsgGetParmCmplt_Text_t;

/*
 * Std_MsgGetParmCmplt (value = 0x13) is a message of generic use.
 */


typedef struct {
	QParm	Num;
	UInt32	Val;
	UInt32	TextSize;
} Std_MsgGetParmCmplt_t;

#define Std_MsgGetParmCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Std_MsgGetParmCmplt_Num), &((structAddr)->Num),	\
			(Std_MsgGetParmCmplt_Val), &((structAddr)->Val),	\
			(Std_MsgGetParmCmplt_TextSize), &((structAddr)->TextSize))


#define Std_MsgGetParmCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Std_MsgGetParmCmplt_Num), &((structAddr)->Num),	\
			(Std_MsgGetParmCmplt_Val), &((structAddr)->Val),	\
			(Std_MsgGetParmCmplt_TextSize), &((structAddr)->TextSize))


#define Std_MsgGetParmCmplt_Size		12

#define Std_MsgGetParmCmplt	0x13	/* 19 */
/* The Std_MsgGetParmCmplt message is sent as a response to the Std_MsgGetParm 
 * command if the Component or Instance successfully reads the requested 
 * parameter. The parameter value is returned as part of the message. Num - 
 * parameter number read Val - parameter value read TextSize - size of the 
 * optional text string Text - optional text string, associated with the 
 * version parameter; if not present, the TextSize will be zero */

#define Std_MsgGetxParms_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgGetxParms_Count_t;

#define Std_MsgGetxParms_varStart	0x4

#define Std_MsgGetxParms_List_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgGetxParms_List_Num_t;

#define Std_MsgGetxParms_List_Val	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgGetxParms_List_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Std_MsgGetxParms_List_t;

#define Std_MsgGetxParms_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgGetxParms_List_Num), &((structAddr)->Num),	\
			(Std_MsgGetxParms_List_Val), &((structAddr)->Val))


#define Std_MsgGetxParms_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgGetxParms_List_Num), &((structAddr)->Num),	\
			(Std_MsgGetxParms_List_Val), &((structAddr)->Val))


#define Std_MsgGetxParms_List_Size		8

#define Std_MsgGetxParms_List	0x2	/* 2 */

/*
 * Std_MsgGetxParms (value = 0x14) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgGetxParms_t;

#define Std_MsgGetxParms_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgGetxParms_Count), &((structAddr)->Count))


#define Std_MsgGetxParms_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgGetxParms_Count), &((structAddr)->Count))


#define Std_MsgGetxParms_Size		4

#define Std_MsgGetxParms	0x14	/* 20 */
/* The Std_MsgGetxParms message is sent to a Component or Instance to read the 
 * values of one or more of its parameters. Parameters are represented as 
 * tuples of Num and Val. Count - number of parameters to read. List - 
 * parameter list Num - parameter number(s) to read. Val - dummy placeholder 
 * for parameter value when read. */

#define Std_MsgGetxParmsCmplt_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgGetxParmsCmplt_Count_t;

#define Std_MsgGetxParmsCmplt_varStart	0x4

#define Std_MsgGetxParmsCmplt_List_Num	0x880000	/* 8912896 */
typedef	QParm	Std_MsgGetxParmsCmplt_List_Num_t;

#define Std_MsgGetxParmsCmplt_List_Val	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgGetxParmsCmplt_List_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Std_MsgGetxParmsCmplt_List_t;

#define Std_MsgGetxParmsCmplt_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgGetxParmsCmplt_List_Num), &((structAddr)->Num),	\
			(Std_MsgGetxParmsCmplt_List_Val), &((structAddr)->Val))


#define Std_MsgGetxParmsCmplt_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgGetxParmsCmplt_List_Num), &((structAddr)->Num),	\
			(Std_MsgGetxParmsCmplt_List_Val), &((structAddr)->Val))


#define Std_MsgGetxParmsCmplt_List_Size		8

#define Std_MsgGetxParmsCmplt_List	0x3	/* 3 */

/*
 * Std_MsgGetxParmsCmplt (value = 0x15) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgGetxParmsCmplt_t;

#define Std_MsgGetxParmsCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgGetxParmsCmplt_Count), &((structAddr)->Count))


#define Std_MsgGetxParmsCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgGetxParmsCmplt_Count), &((structAddr)->Count))


#define Std_MsgGetxParmsCmplt_Size		4

#define Std_MsgGetxParmsCmplt	0x15	/* 21 */
/* The Std_MsgGetxParmsCmplt message is sent as a response to the 
 * Std_MsgGetxParms command if the Component or Instance successfully read all 
 * the parameters requested. The parameter values are returned as part of the 
 * message. Count - number of parameters read. List - parameter list Num - 
 * parameter number(s). Val - parameter value(s). */

#define Std_MsgDetectEvt_RetAddr	0x800000	/* 8388608 */
typedef	QCompDesc	Std_MsgDetectEvt_RetAddr_t;

#define Std_MsgDetectEvt_Type	0x380006	/* 3670022 */
typedef	UInt32	Std_MsgDetectEvt_Type_t;

#define Std_MsgDetectEvt_Label	0x38000a	/* 3670026 */
typedef	UInt32	Std_MsgDetectEvt_Label_t;

/*
 * Std_MsgDetectEvt (value = 0x16) is a message of generic use.
 */


typedef struct {
	QCompDesc	RetAddr;
	UInt32	Type;
	UInt32	Label;
} Std_MsgDetectEvt_t;

#define Std_MsgDetectEvt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Std_MsgDetectEvt_RetAddr), &((structAddr)->RetAddr),	\
			(Std_MsgDetectEvt_Type), &((structAddr)->Type),	\
			(Std_MsgDetectEvt_Label), &((structAddr)->Label))


#define Std_MsgDetectEvt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Std_MsgDetectEvt_RetAddr), &((structAddr)->RetAddr),	\
			(Std_MsgDetectEvt_Type), &((structAddr)->Type),	\
			(Std_MsgDetectEvt_Label), &((structAddr)->Label))


#define Std_MsgDetectEvt_Size		14

#define Std_MsgDetectEvt	0x16	/* 22 */
/* The Std_MsgDetectEvt message is sent to request the reporting of an event. 
 * This may be used for simply expressing interest in asynchronous events or 
 * for Run Time Control. The source address and transaction ID of this message 
 * are used by the receiver to uniquely identify this request. They are also 
 * used when canceling the request. A transaction ID if 0 is used by convention 
 * to simply enable asychronous events that are not used for Run Time Control. 
 * RetAddr - the address to send the Std_MsgEvtDetected message. Type - the 
 * event type to be enabled. Label - an event label to be returned in the 
 * Std_MsgEvtDetected message understood by the one receiving that message. */
/* The Std_MsgDetectEvtCmplt message is sent as a response to the 
 * Std_MsgDetectEvt command if the Component or Instance can successfully 
 * enable the event. */

/*
 * Std_MsgDetectEvtCmplt (value = 0x17) is a message of generic use.
 */

#define Std_MsgDetectEvtCmplt_Size		0

#define Std_MsgDetectEvtCmplt	0x17	/* 23 */

#define Std_MsgDetectxEvts_RetAddr	0x800000	/* 8388608 */
typedef	QCompDesc	Std_MsgDetectxEvts_RetAddr_t;

#define Std_MsgDetectxEvts_Count	0x380006	/* 3670022 */
typedef	UInt32	Std_MsgDetectxEvts_Count_t;

#define Std_MsgDetectxEvts_varStart	0xa

#define Std_MsgDetectxEvts_List_Type	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgDetectxEvts_List_Type_t;

#define Std_MsgDetectxEvts_List_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgDetectxEvts_List_Label_t;


typedef struct {
	UInt32	Type;
	UInt32	Label;
} Std_MsgDetectxEvts_List_t;

#define Std_MsgDetectxEvts_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgDetectxEvts_List_Type), &((structAddr)->Type),	\
			(Std_MsgDetectxEvts_List_Label), &((structAddr)->Label))


#define Std_MsgDetectxEvts_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgDetectxEvts_List_Type), &((structAddr)->Type),	\
			(Std_MsgDetectxEvts_List_Label), &((structAddr)->Label))


#define Std_MsgDetectxEvts_List_Size		8

#define Std_MsgDetectxEvts_List	0x4	/* 4 */

/*
 * Std_MsgDetectxEvts (value = 0x18) is a message of generic use.
 */


typedef struct {
	QCompDesc	RetAddr;
	UInt32	Count;
} Std_MsgDetectxEvts_t;

#define Std_MsgDetectxEvts_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgDetectxEvts_RetAddr), &((structAddr)->RetAddr),	\
			(Std_MsgDetectxEvts_Count), &((structAddr)->Count))


#define Std_MsgDetectxEvts_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgDetectxEvts_RetAddr), &((structAddr)->RetAddr),	\
			(Std_MsgDetectxEvts_Count), &((structAddr)->Count))


#define Std_MsgDetectxEvts_Size		10

#define Std_MsgDetectxEvts	0x18	/* 24 */
/* The Std_MsgDetectxEvts message is sent to enable the reporting of multiple 
 * events. This may be used for simply expressing interest in asynchronous 
 * events or for Run Time Control. The source address and transaction ID of 
 * this message are used by the receiver to uniquely identify this request. 
 * They are also used when canceling the request. The events are represented as 
 * tuples of Type and Label. A transaction ID if 0 is used by convention to 
 * simply enable asychronous events that are not used for Run Time Control. 
 * ReturnAddress - the address to send the Std_MsgEvtDetected message. Count - 
 * the number of events to report. List - the list of events to report. Type - 
 * the event type to be enabled. Label - an event label to be returned in the 
 * Std_MsgEvtDetected message understood by the one receiving that message. */
/* The Std_MsgDetectxEvtsCmplt message is sent as a response to the 
 * Std_MsgDetectxEvts command if the Component or Instance can successfully 
 * enable the event(s). */

/*
 * Std_MsgDetectxEvtsCmplt (value = 0x19) is a message of generic use.
 */

#define Std_MsgDetectxEvtsCmplt_Size		0

#define Std_MsgDetectxEvtsCmplt	0x19	/* 25 */

#define Std_MsgCancelEvt_Type	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgCancelEvt_Type_t;

/*
 * Std_MsgCancelEvt (value = 0x1a) is a message of generic use.
 */


typedef struct {
	UInt32	Type;
} Std_MsgCancelEvt_t;

#define Std_MsgCancelEvt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgCancelEvt_Type), &((structAddr)->Type))


#define Std_MsgCancelEvt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgCancelEvt_Type), &((structAddr)->Type))


#define Std_MsgCancelEvt_Size		4

#define Std_MsgCancelEvt	0x1a	/* 26 */
/* The Std_MsgCancelEvt message is sent to cancel the reporting of a single 
 * event that had been set up using a particular transaction ID from a 
 * particular source address. Type - the event type to cancel. */
/* The Std_MsgCancelEvtCmplt message is sent as a response to the 
 * Std_MsgCancelEvt command if the Component or Instance can successfully 
 * cancel the event. */

/*
 * Std_MsgCancelEvtCmplt (value = 0x1b) is a message of generic use.
 */

#define Std_MsgCancelEvtCmplt_Size		0

#define Std_MsgCancelEvtCmplt	0x1b	/* 27 */

#define Std_MsgCancelxEvts_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgCancelxEvts_Count_t;

#define Std_MsgCancelxEvts_varStart	0x4

#define Std_MsgCancelxEvts_List_Type	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgCancelxEvts_List_Type_t;


typedef struct {
	UInt32	Type;
} Std_MsgCancelxEvts_List_t;

#define Std_MsgCancelxEvts_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgCancelxEvts_List_Type), &((structAddr)->Type))


#define Std_MsgCancelxEvts_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgCancelxEvts_List_Type), &((structAddr)->Type))


#define Std_MsgCancelxEvts_List_Size		4

#define Std_MsgCancelxEvts_List	0x5	/* 5 */

/*
 * Std_MsgCancelxEvts (value = 0x1c) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgCancelxEvts_t;

#define Std_MsgCancelxEvts_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgCancelxEvts_Count), &((structAddr)->Count))


#define Std_MsgCancelxEvts_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgCancelxEvts_Count), &((structAddr)->Count))


#define Std_MsgCancelxEvts_Size		4

#define Std_MsgCancelxEvts	0x1c	/* 28 */
/* The Std_MsgCancelxEvts message is sent to disable the reporting of multiple 
 * events. The events must have been previously enabled using the same 
 * transaction Id and source address as used for this command. Count - the 
 * number of events to disable. List - the list of events to disable. Type - 
 * the event type to be disable. */
/* The Std_MsgCancelxEvtsCmplt message is sent as a response to the 
 * Std_MsgCancelxEvts command if the Component or Instance can successfully 
 * disabled the event(s). */

/*
 * Std_MsgCancelxEvtsCmplt (value = 0x1d) is a message of generic use.
 */

#define Std_MsgCancelxEvtsCmplt_Size		0

#define Std_MsgCancelxEvtsCmplt	0x1d	/* 29 */
/* The Std_MsgCancelAllEvts message is sent to cancel the reporting of all 
 * events that have been set up with a particular transaction ID from a 
 * particular source address. */

/*
 * Std_MsgCancelAllEvts (value = 0x1e) is a message of generic use.
 */

#define Std_MsgCancelAllEvts_Size		0

#define Std_MsgCancelAllEvts	0x1e	/* 30 */
/* The Std_MsgCancelAllEvtsCmplt message is sent as a response to the 
 * Std_MsgCancelAllEvts command if the Component or Instance can successfully 
 * cancel the events. */

/*
 * Std_MsgCancelAllEvtsCmplt (value = 0x1f) is a message of generic use.
 */

#define Std_MsgCancelAllEvtsCmplt_Size		0

#define Std_MsgCancelAllEvtsCmplt	0x1f	/* 31 */

#define Std_MsgEvtDetected_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgEvtDetected_Label_t;

#define Std_MsgEvtDetected_Data	0x382004	/* 3678212 */
typedef	UInt32	Std_MsgEvtDetected_Data_t[5];

/*
 * Std_MsgEvtDetected (value = 0x20) is a message of generic use.
 */


typedef struct {
	UInt32	Label;
	UInt32	Data[5];
} Std_MsgEvtDetected_t;

#define Std_MsgEvtDetected_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgEvtDetected_Label), &((structAddr)->Label),	\
			(Std_MsgEvtDetected_Data), &((structAddr)->Data))


#define Std_MsgEvtDetected_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgEvtDetected_Label), &((structAddr)->Label),	\
			(Std_MsgEvtDetected_Data), &((structAddr)->Data))


#define Std_MsgEvtDetected_Size		24

#define Std_MsgEvtDetected	0x20	/* 32 */
/* The Std_MsgEvtDetected message is sent when an event that was previously 
 * requested with the Std_MsgDetectEvt message occurs. Label - the event label 
 * to send back which was requested in the Std_MsgDetectEvt command. Data - any 
 * extra data associated with this event. The receiver of this data must be 
 * able to interpret it. */

#define Std_MsgArmRTC_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgArmRTC_Label_t;

#define Std_MsgArmRTC_Action	0x380004	/* 3670020 */
typedef	UInt32	Std_MsgArmRTC_Action_t;

/*
 * Std_MsgArmRTC (value = 0x21) is a message of generic use.
 */


typedef struct {
	UInt32	Label;
	UInt32	Action;
} Std_MsgArmRTC_t;

#define Std_MsgArmRTC_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgArmRTC_Label), &((structAddr)->Label),	\
			(Std_MsgArmRTC_Action), &((structAddr)->Action))


#define Std_MsgArmRTC_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgArmRTC_Label), &((structAddr)->Label),	\
			(Std_MsgArmRTC_Action), &((structAddr)->Action))


#define Std_MsgArmRTC_Size		8

#define Std_MsgArmRTC	0x21	/* 33 */
/* The Std_MsgArmRTC message is sent to inform a Component Instance to expect 
 * to receive a single Std_MsgEvtDetected message and what to do once it 
 * arrives. The source address and transaction ID of this message are used by 
 * the receiver to uniquely identify this request. They are also used when 
 * canceling the request. The transaction Id and Label combination must be 
 * unique in the system to avoid collision. At a minimum the transaction ID 
 * should not equal 0. Label - the event label to expect in the 
 * Std_MsgEvtDetected message. Action - the action to take once this event has 
 * been received. */
/* The Std_MsgArmRTCCmplt message is sent as a response to the Std_MsgArmRTC 
 * command if the Component or Instance can successfully arm itself to receive 
 * the event. */

/*
 * Std_MsgArmRTCCmplt (value = 0x22) is a message of generic use.
 */

#define Std_MsgArmRTCCmplt_Size		0

#define Std_MsgArmRTCCmplt	0x22	/* 34 */

#define Std_MsgArmxRTCs_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgArmxRTCs_Count_t;

#define Std_MsgArmxRTCs_varStart	0x4

#define Std_MsgArmxRTCs_List_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgArmxRTCs_List_Label_t;

#define Std_MsgArmxRTCs_List_Action	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgArmxRTCs_List_Action_t;


typedef struct {
	UInt32	Label;
	UInt32	Action;
} Std_MsgArmxRTCs_List_t;

#define Std_MsgArmxRTCs_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Std_MsgArmxRTCs_List_Label), &((structAddr)->Label),	\
			(Std_MsgArmxRTCs_List_Action), &((structAddr)->Action))


#define Std_MsgArmxRTCs_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Std_MsgArmxRTCs_List_Label), &((structAddr)->Label),	\
			(Std_MsgArmxRTCs_List_Action), &((structAddr)->Action))


#define Std_MsgArmxRTCs_List_Size		8

#define Std_MsgArmxRTCs_List	0x6	/* 6 */

/*
 * Std_MsgArmxRTCs (value = 0x23) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgArmxRTCs_t;

#define Std_MsgArmxRTCs_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgArmxRTCs_Count), &((structAddr)->Count))


#define Std_MsgArmxRTCs_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgArmxRTCs_Count), &((structAddr)->Count))


#define Std_MsgArmxRTCs_Size		4

#define Std_MsgArmxRTCs	0x23	/* 35 */
/* The Std_MsgArmxRTCs message is sent to inform the Component Instance to 
 * expect to receive multiple Std_MsgEvtDetected messages and what to do once 
 * they arrive. The source address and transaction ID of this message are used 
 * by the receiver to uniquely identify this request. They are also used when 
 * canceling the request. The transaction Id and Label combination must be 
 * unique in the system to avoid collision. At a minimum the transaction ID 
 * should not equal 0. Count - the number of events to expect. List - the list 
 * of events to expect. Label - the event label to expect in the 
 * Std_MsgEvtDetected message. Action - the action to take once this event has 
 * been received. */
/* The Std_MsgArmxRTCsCmplt message is sent as a response to the 
 * Std_MsgArmxRTCs command if the Component or Instance can successfully arm 
 * itself to receive the events. */

/*
 * Std_MsgArmxRTCsCmplt (value = 0x24) is a message of generic use.
 */

#define Std_MsgArmxRTCsCmplt_Size		0

#define Std_MsgArmxRTCsCmplt	0x24	/* 36 */

#define Std_MsgDisarmRTC_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgDisarmRTC_Label_t;

/*
 * Std_MsgDisarmRTC (value = 0x25) is a message of generic use.
 */


typedef struct {
	UInt32	Label;
} Std_MsgDisarmRTC_t;

#define Std_MsgDisarmRTC_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgDisarmRTC_Label), &((structAddr)->Label))


#define Std_MsgDisarmRTC_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgDisarmRTC_Label), &((structAddr)->Label))


#define Std_MsgDisarmRTC_Size		4

#define Std_MsgDisarmRTC	0x25	/* 37 */
/* The Std_MsgDisarmRTC message is sent to disable the arming for a single RTC 
 * event that has been set up using a particular transaction ID from a 
 * particular source address. Label - event label to disarm. */
/* The Std_MsgDisarmRTCCmplt message is sent as a response to the 
 * Std_MsgDisarmRTC command if the Component or Instance can successfully 
 * disarm for the RTC event. */

/*
 * Std_MsgDisarmRTCCmplt (value = 0x26) is a message of generic use.
 */

#define Std_MsgDisarmRTCCmplt_Size		0

#define Std_MsgDisarmRTCCmplt	0x26	/* 38 */

#define Std_MsgDisarmxRTCs_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgDisarmxRTCs_Count_t;

#define Std_MsgDisarmxRTCs_varStart	0x4

#define Std_MsgDisarmxRTCs_List_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgDisarmxRTCs_List_Label_t;


typedef struct {
	UInt32	Label;
} Std_MsgDisarmxRTCs_List_t;

#define Std_MsgDisarmxRTCs_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgDisarmxRTCs_List_Label), &((structAddr)->Label))


#define Std_MsgDisarmxRTCs_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgDisarmxRTCs_List_Label), &((structAddr)->Label))


#define Std_MsgDisarmxRTCs_List_Size		4

#define Std_MsgDisarmxRTCs_List	0x7	/* 7 */

/*
 * Std_MsgDisarmxRTCs (value = 0x27) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgDisarmxRTCs_t;

#define Std_MsgDisarmxRTCs_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgDisarmxRTCs_Count), &((structAddr)->Count))


#define Std_MsgDisarmxRTCs_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgDisarmxRTCs_Count), &((structAddr)->Count))


#define Std_MsgDisarmxRTCs_Size		4

#define Std_MsgDisarmxRTCs	0x27	/* 39 */
/* The Std_MsgDisarmxRTCs message is sent to inform the Component Instance to 
 * to disable the arming for multiple RTC events that have been set up using a 
 * particular transaction ID from a particular source address. Count - number 
 * of events to expect. List - list of events to expect. Label - event label to 
 * disarm. */
/* The Std_MsgDisarmxRTCsCmplt message is sent as a response to the 
 * Std_MsgDisarmxRTCs command if the Component or Instance can successfully 
 * disarm itself from revceiving the events. */

/*
 * Std_MsgDisarmxRTCsCmplt (value = 0x28) is a message of generic use.
 */

#define Std_MsgDisarmxRTCsCmplt_Size		0

#define Std_MsgDisarmxRTCsCmplt	0x28	/* 40 */
/* The Std_MsgDisarmAllRTCs message is sent to disable the arming for all RTC 
 * events that has been set up using a particular transaction ID from a 
 * particular source address. */

/*
 * Std_MsgDisarmAllRTCs (value = 0x29) is a message of generic use.
 */

#define Std_MsgDisarmAllRTCs_Size		0

#define Std_MsgDisarmAllRTCs	0x29	/* 41 */
/* The Std_MsgDisarmAllRTCsCmplt message is sent as a response to the 
 * Std_MsgDisarmAllRTCs command if the Component or Instance can successfully 
 * disarm for all events. */

/*
 * Std_MsgDisarmAllRTCsCmplt (value = 0x2a) is a message of generic use.
 */

#define Std_MsgDisarmAllRTCsCmplt_Size		0

#define Std_MsgDisarmAllRTCsCmplt	0x2a	/* 42 */
/* The Std_MsgExecute message is sent as a command to enable a Component or 
 * Instance to execute any function that may be encapsulated in the message. 
 * How this message is interpreted is completely proprietary to the Component 
 * writer using it. */

/*
 * Std_MsgExecute (value = 0x2b) is a message of generic use.
 */

#define Std_MsgExecute_Size		0

#define Std_MsgExecute	0x2b	/* 43 */
/* The Std_MsgExecuteCmplt message must be sent as a response to the 
 * Std_MsgExecute message if the Component or Instance can successfully execute 
 * and a response is requested. */

/*
 * Std_MsgExecuteCmplt (value = 0x2c) is a message of generic use.
 */

#define Std_MsgExecuteCmplt_Size		0

#define Std_MsgExecuteCmplt	0x2c	/* 44 */

#define Std_MsgGetVParm_Count	0x280000	/* 2621440 */
typedef	UInt16	Std_MsgGetVParm_Count_t;

#define Std_MsgGetVParm_varStart	0x2

#define Std_MsgGetVParm_ParmId	0x880000	/* 8912896 */
typedef	QParm	Std_MsgGetVParm_ParmId_t;

/*
 * Std_MsgGetVParm (value = 0x2d) is a message of generic use.
 */


typedef struct {
	UInt16	Count;
} Std_MsgGetVParm_t;

#define Std_MsgGetVParm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgGetVParm_Count), &((structAddr)->Count))


#define Std_MsgGetVParm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgGetVParm_Count), &((structAddr)->Count))


#define Std_MsgGetVParm_Size		2

#define Std_MsgGetVParm	0x2d	/* 45 */
/* The Std_MsgGetVParm message is similar to the Std_MsgGetParm and 
 * Std_MsgGetxParms messages in that it requests the value of one or more 
 * parameters from a Component or Instance. The GetVParm message extends the 
 * concept of parameters to allow for parameters of varying data types. The 
 * FieldDef field in the GetVParmCmplt message specifies the MMDL definition 
 * for the parameter value which may be any MMDL data type including arrays. 
 * See Std_MsgGetVParmCmplt for more information. The message body consists of 
 * a count specifying the number of parameter identifiers in the message, 
 * followed by the list of ParmId fields. Count - the number of parameters to 
 * get. ParmId - the identifier for an individual parameter. */

#define Std_MsgGetVParmCmplt_Count	0x280000	/* 2621440 */
typedef	UInt16	Std_MsgGetVParmCmplt_Count_t;

#define Std_MsgGetVParmCmplt_varStart	0x2

#define Std_MsgGetVParmCmplt_ParmId	0x880000	/* 8912896 */
typedef	QParm	Std_MsgGetVParmCmplt_ParmId_t;

#define Std_MsgGetVParmCmplt_FieldDef	0x300000	/* 3145728 */
typedef	UInt24	Std_MsgGetVParmCmplt_FieldDef_t;

#define Std_MsgGetVParmCmplt_Value	0x200000	/* 2097152 */
typedef	UInt8	Std_MsgGetVParmCmplt_Value_t;

/*
 * Std_MsgGetVParmCmplt (value = 0x2e) is a message of generic use.
 */


typedef struct {
	UInt16	Count;
} Std_MsgGetVParmCmplt_t;

#define Std_MsgGetVParmCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgGetVParmCmplt_Count), &((structAddr)->Count))


#define Std_MsgGetVParmCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgGetVParmCmplt_Count), &((structAddr)->Count))


#define Std_MsgGetVParmCmplt_Size		2

#define Std_MsgGetVParmCmplt	0x2e	/* 46 */
/* The Std_MsgGetVParmCmplt message is similar to the Std_MsgGetParmCmplt and 
 * Std_MsgGetxParmsCmplt messages in that it contains the value of one or more 
 * parameters in a Component or Instance. The GetVParmCmplt message extends the 
 * concept of parameters to allow for parameters of varying data types. The 
 * FieldDef field in the message specifies the MMDL definition for the 
 * parameter's data type. The message body consists of a count specifying the 
 * number of parameters in the message, followed by a ParmId, FieldDef, and 
 * Value tuple for each parameter. The uint8 Value field in the definition is a 
 * placeholder and the FieldDef field defines the actual data type for Value. 
 * FieldDef is a MMDL data type specifier which can be taken from an MMDL 
 * generated header or built using the QFieldDefSet() macro defined in 
 * qkernel/include/qmsg.h. Count - the number of parameters in the message 
 * ParmId - the identifier for the parameter FieldDef - the MMDL field type 
 * definition for the value of the parameter Value - a variable length field 
 * holding the value to set the parameter to. The FieldDef field defines the 
 * length and data type of the Value field. */

#if 0
Std_MsgGetVParmCmplt_t			msgArgs;
LCON_ParmQSlacLongParm_t		longParm;
LCON_ParmRingDetectInterval_t		ringDetInterval;
Std_MsgGetVParmCmplt_ParmId_t		parmId;
Std_MsgGetVParmCmplt_FieldDef_t	fieldDef;
Uint24 offset;
offset = 0;
Std_MsgGetVParmCmplt_get(msgp, &msgArgs, offset);
offset = Std_MsgGetVParmCmplt_varstart;
for (count=0; count < msgArgs.count; count++ ) {
	qMsgVarFieldGet(msgp, 2, &offset, 
			Std_MsgGetVParmCmplt_ParmId, &parmId,
			Std_MsgGetVParmCmplt_FieldDef, &fieldDef);
	switch (parmId) {
	case LCON_ParmQSlacLongParm:
		qMsgVarFieldGet(msgp, 1, &offset, fieldDef, &longParm);
		break;
	case LCON_ParmRingDetectInterval:
		qMsgVarFieldGet(msgp, 1, &offset, fieldDef, &ringDetInterval);
		break;

	default:
		/* Handle unexpected parameter */
		break;
	}
#endif


#define Std_MsgSetVParm_Count	0x280000	/* 2621440 */
typedef	UInt16	Std_MsgSetVParm_Count_t;

#define Std_MsgSetVParm_varStart	0x2

#define Std_MsgSetVParm_ParmId	0x880000	/* 8912896 */
typedef	QParm	Std_MsgSetVParm_ParmId_t;

#define Std_MsgSetVParm_FieldDef	0x300000	/* 3145728 */
typedef	UInt24	Std_MsgSetVParm_FieldDef_t;

#define Std_MsgSetVParm_Value	0x200000	/* 2097152 */
typedef	UInt8	Std_MsgSetVParm_Value_t;

/*
 * Std_MsgSetVParm (value = 0x2f) is a message of generic use.
 */


typedef struct {
	UInt16	Count;
} Std_MsgSetVParm_t;

#define Std_MsgSetVParm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgSetVParm_Count), &((structAddr)->Count))


#define Std_MsgSetVParm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgSetVParm_Count), &((structAddr)->Count))


#define Std_MsgSetVParm_Size		2

#define Std_MsgSetVParm	0x2f	/* 47 */
/* The Std_MsgSetVParm message is similar to the Std_MsgSetParm and 
 * Std_MsgSetxParms messages in that it sets the value of one or more 
 * parameters in a Component or Instance. The SetVParm message extends the 
 * concept of parameters to allow for parameters of varying data types. The 
 * FieldDef field in the message specifies the MMDL definition for the 
 * parameter value. The message body consists of a count specifying the number 
 * of parameters in the message, followed by a ParmId, FieldDef, and Value 
 * tuple for each parameter. The uint8 value field in the definition is a 
 * placeholder and the actual data type for value is defined by the FieldDef 
 * field. FieldDef is a MMDL data type specifier which can be taken from an 
 * MMDL generated header or built using the QFieldDefSet() macro defined in 
 * qkernel/include/qmsg.h. Count - the number of parameters to set, which are 
 * in the variable part of the message ParmId - the identifier for an 
 * individual parameter FieldDef - the MMDL field type definition for the value 
 * of an individual parameter Value - a variable length field holding the value 
 * to set the individual parameter to. The FieldDef field defines the length 
 * and data type of the Value field. */
/* The Std_MsgSetVParmCmplt message is sent as a response to the 
 * Std_MsgSetVParm command if the Component or Instance successfully sets the 
 * parameter. */

/*
 * Std_MsgSetVParmCmplt (value = 0x30) is a message of generic use.
 */

#define Std_MsgSetVParmCmplt_Size		0

#define Std_MsgSetVParmCmplt	0x30	/* 48 */

#define Std_MsgClearPendingAction_Label	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgClearPendingAction_Label_t;

/*
 * Std_MsgClearPendingAction (value = 0x31) is a message of generic use.
 */


typedef struct {
	UInt32	Label;
} Std_MsgClearPendingAction_t;

#define Std_MsgClearPendingAction_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgClearPendingAction_Label), &((structAddr)->Label))


#define Std_MsgClearPendingAction_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgClearPendingAction_Label), &((structAddr)->Label))


#define Std_MsgClearPendingAction_Size		4

#define Std_MsgClearPendingAction	0x31	/* 49 */
/* The Std_ MsgClearPendingAction message is sent to direct the Component to 
 * clear pending RTC actions associated with the instance receiving this 
 * message. Label - event label to clear the action. */

#define Std_MsgSetActLbls_Count	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetActLbls_Count_t;

#define Std_MsgSetActLbls_varStart	0x4

#define Std_MsgSetActLbls_ALR_labelLow	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetActLbls_ALR_labelLow_t;

#define Std_MsgSetActLbls_ALR_labelHigh	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetActLbls_ALR_labelHigh_t;

#define Std_MsgSetActLbls_ALR_action	0x380000	/* 3670016 */
typedef	UInt32	Std_MsgSetActLbls_ALR_action_t;


typedef struct {
	UInt32	labelLow;
	UInt32	labelHigh;
	UInt32	action;
} Std_MsgSetActLbls_ALR_t;

#define Std_MsgSetActLbls_ALR_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Std_MsgSetActLbls_ALR_labelLow), &((structAddr)->labelLow),	\
			(Std_MsgSetActLbls_ALR_labelHigh), &((structAddr)->labelHigh),	\
			(Std_MsgSetActLbls_ALR_action), &((structAddr)->action))


#define Std_MsgSetActLbls_ALR_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Std_MsgSetActLbls_ALR_labelLow), &((structAddr)->labelLow),	\
			(Std_MsgSetActLbls_ALR_labelHigh), &((structAddr)->labelHigh),	\
			(Std_MsgSetActLbls_ALR_action), &((structAddr)->action))


#define Std_MsgSetActLbls_ALR_Size		12

#define Std_MsgSetActLbls_ALR	0x8	/* 8 */

/*
 * Std_MsgSetActLbls (value = 0x32) is a message of generic use.
 */


typedef struct {
	UInt32	Count;
} Std_MsgSetActLbls_t;

#define Std_MsgSetActLbls_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Std_MsgSetActLbls_Count), &((structAddr)->Count))


#define Std_MsgSetActLbls_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Std_MsgSetActLbls_Count), &((structAddr)->Count))


#define Std_MsgSetActLbls_Size		4

#define Std_MsgSetActLbls	0x32	/* 50 */
/* The Std_MsgSetActLbls message is sent to set the action and its associated 
 * label range. This allows components to associate actions with labels at 
 * component level without going through the instance based RTC arming of 
 * actions which has memory implications. It also reduces the number of 
 * messages as the setting of label ranges is done once at component level 
 * instead of setting up of arm for actions at instance level. Notice, this 
 * message (Std_MsgSetActLbls) is mainly intended to be supported at the 
 * component level only. The explanation of the field of the message is as 
 * follows: Count - the number of Action Label Ranges (ALRs) ALR - The 
 * structure of Action Label Range with following fields labelLow - The minimum 
 * value of the label range. labelHigh - The maximum value of the label range. 
 * action - The action to associate with this range. */
/* Std_MsgSetActLblsCmplt message is sent as a response to the 
 * Std_MsgSetActLbls command if the Component or Instance successfully executes 
 * the message. */
/* 
 * Standard Parameter Definitions
 */

/*
 * Std_MsgSetActLblsCmplt (value = 0x33) is a message of generic use.
 */

#define Std_MsgSetActLblsCmplt_Size		0

#define Std_MsgSetActLblsCmplt	0x33	/* 51 */
/* The version number of the Component. For Intel Components, the format of 
 * the version number may be found in Section 2.2 of Ref #5 with the exception 
 * that the number is in Hex rather than ASCII. e.g. Version 3.60 Alpha 4.15 is 
 * represented as 0x23600415 */

#define Std_ParmVersion	0	/* 0 */
typedef	UInt32	Std_ParmVersion_t;
/*
 * The vendor ID of the Component.
 */

#define Std_ParmVendor	0x1	/* 1 */
typedef	UInt32	Std_ParmVendor_t;
/*
 * The maximum number of Instances supported by this Component
 */

#define Std_ParmMaxInst	0x2	/* 2 */
typedef	UInt32	Std_ParmMaxInst_t;
/* The number of Instances to create or already created. This parameter can be 
 * set at any time, but it only takes effect when the instance is initialized 
 * (with Std_MsgInit). */

#define Std_ParmInstNum	0x3	/* 3 */
typedef	UInt32	Std_ParmInstNum_t;
/*
 * The starting Instance number
 */
/* 
 * Standard Error Code Definitions
 */

#define Std_ParmStartInst	0x4	/* 4 */
typedef	UInt32	Std_ParmStartInst_t;
/*
 * No errror
 */

#define Std_ErrNone	0	/* 0 */
/*
 * System level error occurred while executing a command.
 */

#define Std_ErrSystem	0x1	/* 1 */
/* Component or Instance was busy executing a previous command when another 
 * command was received. */

#define Std_ErrBusy	0x2	/* 2 */
/*
 * Unexpected message was received. 
 */

#define Std_ErrUnexpectedMsg	0x3	/* 3 */
/*
 * Error creating instances.
 */

#define Std_ErrInstCreate	0x4	/* 4 */
/*
 * Instances in use.
 */

#define Std_ErrInstInUse	0x5	/* 5 */

#define Std_ErrParmNum	0x6	/* 6 */

#define ErrParm_Msg	0x380000	/* 3670016 */
typedef	UInt32	ErrParm_Msg_t;

#define ErrParm_Code	0x380004	/* 3670020 */
typedef	UInt32	ErrParm_Code_t;

#define ErrParm_Num	0x380008	/* 3670024 */
typedef	UInt32	ErrParm_Num_t;

#define ErrParm_Val	0x38000c	/* 3670028 */
typedef	UInt32	ErrParm_Val_t;

/*
 * ErrParm (value = generic) is a message of generic use.
 */


typedef struct {
	UInt32	Msg;
	UInt32	Code;
	UInt32	Num;
	UInt32	Val;
} ErrParm_t;

#define ErrParm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(ErrParm_Msg), &((structAddr)->Msg),	\
			(ErrParm_Code), &((structAddr)->Code),	\
			(ErrParm_Num), &((structAddr)->Num),	\
			(ErrParm_Val), &((structAddr)->Val))


#define ErrParm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(ErrParm_Msg), &((structAddr)->Msg),	\
			(ErrParm_Code), &((structAddr)->Code),	\
			(ErrParm_Num), &((structAddr)->Num),	\
			(ErrParm_Val), &((structAddr)->Val))


#define ErrParm_Size		16
/* Invalid parameter number was specified in one of the parameter service 
 * messages. The invalid parameter number and value pair is returned in the 
 * Std_MsgError message. */
/* Invalid parameter value was specified in one of the parameter service 
 * messages. The invalid parameter number and value is returned in the 
 * Std_MsgError message. Uses same message format as for Std_ErrParmNum error. */

#define Std_ErrParmValue	0x7	/* 7 */

#define Std_ErrEvtType	0x8	/* 8 */

#define ErrEvt_Msg	0x380000	/* 3670016 */
typedef	UInt32	ErrEvt_Msg_t;

#define ErrEvt_Code	0x380004	/* 3670020 */
typedef	UInt32	ErrEvt_Code_t;

#define ErrEvt_Type	0x380008	/* 3670024 */
typedef	UInt32	ErrEvt_Type_t;

/*
 * ErrEvt (value = generic) is a message of generic use.
 */


typedef struct {
	UInt32	Msg;
	UInt32	Code;
	UInt32	Type;
} ErrEvt_t;

#define ErrEvt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(ErrEvt_Msg), &((structAddr)->Msg),	\
			(ErrEvt_Code), &((structAddr)->Code),	\
			(ErrEvt_Type), &((structAddr)->Type))


#define ErrEvt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(ErrEvt_Msg), &((structAddr)->Msg),	\
			(ErrEvt_Code), &((structAddr)->Code),	\
			(ErrEvt_Type), &((structAddr)->Type))


#define ErrEvt_Size		12
/* Invalid event type was specified in one of the event handling messages. The 
 * invalid event type is returned in the Std_MsgError message. */

#define Std_ErrRTCAction	0x9	/* 9 */

#define ErrRTC_Msg	0x380000	/* 3670016 */
typedef	UInt32	ErrRTC_Msg_t;

#define ErrRTC_Code	0x380004	/* 3670020 */
typedef	UInt32	ErrRTC_Code_t;

#define ErrRTC_Label	0x380008	/* 3670024 */
typedef	UInt32	ErrRTC_Label_t;

#define ErrRTC_Action	0x38000c	/* 3670028 */
typedef	UInt32	ErrRTC_Action_t;

/*
 * ErrRTC (value = generic) is a message of generic use.
 */


typedef struct {
	UInt32	Msg;
	UInt32	Code;
	UInt32	Label;
	UInt32	Action;
} ErrRTC_t;

#define ErrRTC_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(ErrRTC_Msg), &((structAddr)->Msg),	\
			(ErrRTC_Code), &((structAddr)->Code),	\
			(ErrRTC_Label), &((structAddr)->Label),	\
			(ErrRTC_Action), &((structAddr)->Action))


#define ErrRTC_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(ErrRTC_Msg), &((structAddr)->Msg),	\
			(ErrRTC_Code), &((structAddr)->Code),	\
			(ErrRTC_Label), &((structAddr)->Label),	\
			(ErrRTC_Action), &((structAddr)->Action))


#define ErrRTC_Size		16
/* Invalid Run Time Control action was specified in one of the event handling 
 * messages. The invalid RTC label and action pair are returned in the 
 * Std_MsgError message. */
/* Invalid event label was specified when using one of the event handling 
 * messages. The invalid event label is returned in the Std_MsgError message. 
 * Uses same message format as for Std_ErrRTCAction with the Action field 
 * having no meaning. */

#define Std_ErrEvtLabel	0xa	/* 10 */
/* A Label and Transaction ID pair that is already in use was specified in one 
 * of the ArmRTC messages. Sender should change one or both and resend message. */

#define Std_ErrLabelTrans	0xb	/* 11 */
/* A standard message that is not supported has been received. For example, 
 * the player does not support the Std_MsgSetxParms message. If this message is 
 * received, the player should return a Std_MsgError message with the error 
 * code field set to Std_ErrUnsupportedMsg. */

#define Std_ErrUnsupportedMsg	0xc	/* 12 */
/*
 * An attempt has been made to set a read-only parameter.
 */

#define Std_ErrParmReadOnly	0xd	/* 13 */
/*
 * An attempt has been made to read a write-only parameter.
 */

#define Std_ErrParmWriteOnly	0xe	/* 14 */
/*
 * An attempt has been made to cancel an event that was never enabled.
 */

#define Std_ErrNotEnabled	0xf	/* 15 */
/* An 'x' message (Std_MsgSetxParms, Std_MsgGetxParms, Std_MsgDetectxEvts, 
 * Std_MsgCancelxEvts) that contains an empty parameter/event list has been 
 * received. */

#define Std_ErrListEmpty	0x10	/* 16 */
/*
 * Range specified is not correct.
 */

#define Std_ErrInvRange	0x11	/* 17 */
/* Action specified is not correct i.e. the component does not understand this 
 * action. */
/*
 * Standard Attribute Types
 */

#define Std_ErrInvAction	0x12	/* 18 */
/* Unique identifier for the Type of the Component. An example of Component 
 * Type would be Decoder. */

#define Std_ComponentType	0	/* 0 */
typedef	QCompAttr	Std_ComponentType_t;
/*
 * Given a particular Type, this is the Id which uniquely identifies this type.
 */

#define Std_ComponentId	0x1	/* 1 */
typedef	QCompAttr	Std_ComponentId_t;

#define Std_VendorId_Dialogic	0x1	/* 1 */
/*
 * The unique Vendor Id for a Component. Dialogic is VendorId 0x1
 */

#define Std_VendorId	0x2	/* 2 */
typedef	QCompAttr	Std_VendorId_t;
/*
 * Uniquely identifies a cluster type. 
 */

#ifdef __cplusplus
}
#endif

/*
 * End of all Standard Component Definitions
 */

#define Std_ClusterType	0x3	/* 3 */
typedef	QCompAttr	Std_ClusterType_t;

#endif /* !defined(_stddefs_h_) */
