
/*
 * This file was automatically generated from tgendefs.txt.
 * Author: "Luke Kiernan"
 * Version: "Revision A0.8"
 * Date: Wed Oct 16 12:18:40 2002
 * The output was written to tgendefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_tgendefs_h_)
#define _tgendefs_h_ 1
/* This file describes the list of Mercury messages, parameters and equates 
 * supported by the Mercury Tone Generator Component and its Instances. */
/*
 * Include Signal Id definition file
 */

#include "sdsignal.h"

/*
 * Tone Generator Component Definition
 */
/* The Std_VendofID attribute will be set to Dialogic. The Tone Generator uses 
 * messages from the Standard Kernel Message Set, the Standard Component 
 * Message Set and the Standard Waveform Generator Component Message Set. */
/*
 * 	Mercury Kernel Standard Message Set defined in mercdefs.doc
 * 	*/
/*
 * 	Standard Component Message Set defined in stddefs.doc.
 * 	*/
/*
 * 	Waveform Generator Component Message Set defined in wavegen.doc
 * 	*/
/* Waveform Generator Component Type used when trying to allocate a Waveform 
 * Generator Instance (TBD) */
/* 
 * Tone Generator Message Definitions
 */

#define Tgen_MsgCreateTone_SignalId	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgCreateTone_SignalId_t;

#define Tgen_MsgCreateTone_SegCount	0x380004	/* 3670020 */
typedef	UInt32	Tgen_MsgCreateTone_SegCount_t;

#define Tgen_MsgCreateTone_SignalLabel	0x201808	/* 2103304 */
typedef	UInt8	Tgen_MsgCreateTone_SignalLabel_t[4];

#define Tgen_MsgCreateTone_varStart	0xc

#define Tgen_MsgCreateTone_segs_SignalType	0x280000	/* 2621440 */
typedef	UInt16	Tgen_MsgCreateTone_segs_SignalType_t;
/* {0:4000} */

#define Tgen_MsgCreateTone_segs_Freq1	0x280000	/* 2621440 */
typedef	UInt16	Tgen_MsgCreateTone_segs_Freq1_t;
/* {-128:127} */

#define Tgen_MsgCreateTone_segs_Amp1	0x80000	/* 524288 */
typedef	Int16	Tgen_MsgCreateTone_segs_Amp1_t;
/* {0:4000} */

#define Tgen_MsgCreateTone_segs_Freq2	0x280000	/* 2621440 */
typedef	UInt16	Tgen_MsgCreateTone_segs_Freq2_t;
/* {-128:127} */

#define Tgen_MsgCreateTone_segs_Amp2	0x80000	/* 524288 */
typedef	Int16	Tgen_MsgCreateTone_segs_Amp2_t;
/* {0:4800000} */

#define Tgen_MsgCreateTone_segs_OnDuration	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgCreateTone_segs_OnDuration_t;
/* {0:4800000} */

#define Tgen_MsgCreateTone_segs_OffDuration	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgCreateTone_segs_OffDuration_t;
/* {0:65535} */

#define Tgen_MsgCreateTone_segs_Reps	0x280000	/* 2621440 */
typedef	UInt16	Tgen_MsgCreateTone_segs_Reps_t;
/* {-31:1} */

#define Tgen_MsgCreateTone_segs_NextSeg	0x180000	/* 1572864 */
typedef	Int32	Tgen_MsgCreateTone_segs_NextSeg_t;


typedef struct {
	UInt16	SignalType;
	UInt16	Freq1;
	Int16	Amp1;
	UInt16	Freq2;
	Int16	Amp2;
	UInt32	OnDuration;
	UInt32	OffDuration;
	UInt16	Reps;
	Int32	NextSeg;
} Tgen_MsgCreateTone_segs_t;

#define Tgen_MsgCreateTone_segs_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(Tgen_MsgCreateTone_segs_SignalType), &((structAddr)->SignalType),	\
			(Tgen_MsgCreateTone_segs_Freq1), &((structAddr)->Freq1),	\
			(Tgen_MsgCreateTone_segs_Amp1), &((structAddr)->Amp1),	\
			(Tgen_MsgCreateTone_segs_Freq2), &((structAddr)->Freq2),	\
			(Tgen_MsgCreateTone_segs_Amp2), &((structAddr)->Amp2),	\
			(Tgen_MsgCreateTone_segs_OnDuration), &((structAddr)->OnDuration),	\
			(Tgen_MsgCreateTone_segs_OffDuration), &((structAddr)->OffDuration),	\
			(Tgen_MsgCreateTone_segs_Reps), &((structAddr)->Reps),	\
			(Tgen_MsgCreateTone_segs_NextSeg), &((structAddr)->NextSeg))


#define Tgen_MsgCreateTone_segs_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(Tgen_MsgCreateTone_segs_SignalType), &((structAddr)->SignalType),	\
			(Tgen_MsgCreateTone_segs_Freq1), &((structAddr)->Freq1),	\
			(Tgen_MsgCreateTone_segs_Amp1), &((structAddr)->Amp1),	\
			(Tgen_MsgCreateTone_segs_Freq2), &((structAddr)->Freq2),	\
			(Tgen_MsgCreateTone_segs_Amp2), &((structAddr)->Amp2),	\
			(Tgen_MsgCreateTone_segs_OnDuration), &((structAddr)->OnDuration),	\
			(Tgen_MsgCreateTone_segs_OffDuration), &((structAddr)->OffDuration),	\
			(Tgen_MsgCreateTone_segs_Reps), &((structAddr)->Reps),	\
			(Tgen_MsgCreateTone_segs_NextSeg), &((structAddr)->NextSeg))


#define Tgen_MsgCreateTone_segs_Size		24

#define Tgen_MsgCreateTone_segs	0	/* 0 */

/*
 * Tgen_MsgCreateTone (value = 0x500) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt32	SignalId;
	UInt32	SegCount;
	UInt8	SignalLabel[4];
} Tgen_MsgCreateTone_t;

#define Tgen_MsgCreateTone_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Tgen_MsgCreateTone_SignalId), &((structAddr)->SignalId),	\
			(Tgen_MsgCreateTone_SegCount), &((structAddr)->SegCount),	\
			(Tgen_MsgCreateTone_SignalLabel), &((structAddr)->SignalLabel))


#define Tgen_MsgCreateTone_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Tgen_MsgCreateTone_SignalId), &((structAddr)->SignalId),	\
			(Tgen_MsgCreateTone_SegCount), &((structAddr)->SegCount),	\
			(Tgen_MsgCreateTone_SignalLabel), &((structAddr)->SignalLabel))


#define Tgen_MsgCreateTone_Size		12

#define Tgen_MsgCreateTone	0x500	/* 1280 */
/* The MsgCreateTone message is sent to create a tone signal consisting of one 
 * or more tone segments. SignalId - identifier for one complete tone. This 
 * must be unique for all instances. SegCount - number of segments describing 
 * this tone. SignalLabel - an optional four character string identifier for 
 * each tone template. SignalType - type of signal to be generated. See Section 
 * 5.1 for explanation. */

#define	Tgen_MAXNUMSEGS    4
#define	Tgen_MAXLABELSIZE  4


#define	SigType_Singletone	0x1
#define	SigType_Dualtone	0x2
#define	SigType_AMTone	0x3
#define	SigType_Noise	0x4
#define	SigType_Impulse	0x5
#define	SigType_Silence	0x6


#define	Tgen_AddToneSeg_EOS	0xffff

/* Freq1 - frequency of first component of tone. (units Hz) Amp1 - amplitude 
 * of first component of tone. (units 0.25 dB relative to TLP0) Freq2 - 
 * frequency of second component of tone. (units Hz) Amp2 - amplitude of second 
 * component of tone. (units 0.25 dB relative to TLP0) OnDuration - duration of 
 * tone (units 0.125 msecs, 0 means play tone continuously) OffDuration - 
 * duration of silence (units 0.125 msecs, 0 means play silence continuously). 
 * Reps - number of repititions for segment. 0 means play segment continuously. 
 * NextSeg - relative number of next segment. 0 means play segment 
 * continuously. Tgen_AddToneSeg_EOS means last segment. */
/* The MsgCreateToneCmplt message is sent as a response to the MsgCreateTone 
 * command when the specified tone signal been created. */

/*
 * Tgen_MsgCreateToneCmplt (value = 0x501) is an output message
 * for component Tgen.
 */

#define Tgen_MsgCreateToneCmplt_Size		0

#define Tgen_MsgCreateToneCmplt	0x501	/* 1281 */

#define Tgen_MsgDeleteTone_SignalId	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgDeleteTone_SignalId_t;

/*
 * Tgen_MsgDeleteTone (value = 0x502) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt32	SignalId;
} Tgen_MsgDeleteTone_t;

#define Tgen_MsgDeleteTone_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgDeleteTone_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgDeleteTone_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgDeleteTone_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgDeleteTone_Size		4

#define Tgen_MsgDeleteTone	0x502	/* 1282 */
/*
 * The MsgDeleteTone message is sent to delete a tone signal.
 * SignalId	-	Signal Id to delete.
 *  */
/* The MsgDeleteToneCmplt message is sent as a response to the MsgDeleteTone 
 * command when the specified tone signal has been deleted. */

/*
 * Tgen_MsgDeleteToneCmplt (value = 0x503) is an output message
 * for component Tgen.
 */

#define Tgen_MsgDeleteToneCmplt_Size		0

#define Tgen_MsgDeleteToneCmplt	0x503	/* 1283 */

#define Tgen_MsgPlayTone_SignalId	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlayTone_SignalId_t;

/*
 * Tgen_MsgPlayTone (value = 0x504) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt32	SignalId;
} Tgen_MsgPlayTone_t;

#define Tgen_MsgPlayTone_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlayTone_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgPlayTone_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlayTone_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgPlayTone_Size		4

#define Tgen_MsgPlayTone	0x504	/* 1284 */
/*
 * The MsgPlayTone message is sent to start playing a tone signal.
 * SignalId	-	signal Id of tone signals to play.
 *  */

#define Tgen_MsgPlayToneCmplt_Reason_EOD	0x1	/* 1 */

#define Tgen_MsgPlayToneCmplt_Reason_UserStop	0x2	/* 2 */

#define Tgen_MsgPlayToneCmplt_Reason_Rtc	0x3	/* 3 */

#define Tgen_MsgPlayToneCmplt_Reason	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlayToneCmplt_Reason_t;

#define Tgen_MsgPlayToneCmplt_RtcLabel	0x380004	/* 3670020 */
typedef	UInt32	Tgen_MsgPlayToneCmplt_RtcLabel_t;

/*
 * Tgen_MsgPlayToneCmplt (value = 0x505) is an output message
 * for component Tgen.
 */


typedef struct {
	UInt32	Reason;
	UInt32	RtcLabel;
} Tgen_MsgPlayToneCmplt_t;

#define Tgen_MsgPlayToneCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlayToneCmplt_Reason), &((structAddr)->Reason),	\
			(Tgen_MsgPlayToneCmplt_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_MsgPlayToneCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlayToneCmplt_Reason), &((structAddr)->Reason),	\
			(Tgen_MsgPlayToneCmplt_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_MsgPlayToneCmplt_Size		8

#define Tgen_MsgPlayToneCmplt	0x505	/* 1285 */
/* The MsgPlayToneCmplt message is sent as a response to the MsgPlayTone 
 * command when playback of the specified tone signal has completed. Reason - 
 * reason for stopping. RtcLabel - if Reason is Rtc then this is the EventLabel 
 * of the event which caused the playing of the tone to stop. */

#define Tgen_MsgPlaySequence_Count	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlaySequence_Count_t;

#define Tgen_MsgPlaySequence_varStart	0x4

#define Tgen_MsgPlaySequence_List_SignalId	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlaySequence_List_SignalId_t;


typedef struct {
	UInt32	SignalId;
} Tgen_MsgPlaySequence_List_t;

#define Tgen_MsgPlaySequence_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlaySequence_List_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgPlaySequence_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlaySequence_List_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgPlaySequence_List_Size		4

#define Tgen_MsgPlaySequence_List	0	/* 0 */

/*
 * Tgen_MsgPlaySequence (value = 0x506) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt32	Count;
} Tgen_MsgPlaySequence_t;

#define Tgen_MsgPlaySequence_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlaySequence_Count), &((structAddr)->Count))


#define Tgen_MsgPlaySequence_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlaySequence_Count), &((structAddr)->Count))


#define Tgen_MsgPlaySequence_Size		4

#define Tgen_MsgPlaySequence	0x506	/* 1286 */
/*
 * The MsgPlaySequence message is sent to play a sequence of tone signals.
 * Count	-	number of tone signals to play.
 * Id	-	signal Ids of tone signals to play.
 *  */

#define Tgen_MsgPlaySequenceCmplt_Reason_EOD	0x1	/* 1 */

#define Tgen_MsgPlaySequenceCmplt_Reason_UserStop	0x2	/* 2 */

#define Tgen_MsgPlaySequenceCmplt_Reason_Rtc	0x3	/* 3 */

#define Tgen_MsgPlaySequenceCmplt_Reason	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlaySequenceCmplt_Reason_t;

#define Tgen_MsgPlaySequenceCmplt_RtcLabel	0x380004	/* 3670020 */
typedef	UInt32	Tgen_MsgPlaySequenceCmplt_RtcLabel_t;

/*
 * Tgen_MsgPlaySequenceCmplt (value = 0x507) is an output message
 * for component Tgen.
 */


typedef struct {
	UInt32	Reason;
	UInt32	RtcLabel;
} Tgen_MsgPlaySequenceCmplt_t;

#define Tgen_MsgPlaySequenceCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlaySequenceCmplt_Reason), &((structAddr)->Reason),	\
			(Tgen_MsgPlaySequenceCmplt_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_MsgPlaySequenceCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlaySequenceCmplt_Reason), &((structAddr)->Reason),	\
			(Tgen_MsgPlaySequenceCmplt_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_MsgPlaySequenceCmplt_Size		8

#define Tgen_MsgPlaySequenceCmplt	0x507	/* 1287 */
/* The MsgPlaySequenceCmplt message is sent as a response to the 
 * MsgPlaySequence command when playback of the specified sequence of tone 
 * signals has completed. Reason - reason for stopping. RtcLabel - if Reason is 
 * Rtc then this is the EventLabel of the event which caused the playing of the 
 * tone to stop. */

#define Tgen_MsgDial_Count	0x200000	/* 2097152 */
typedef	UInt8	Tgen_MsgDial_Count_t;

#define Tgen_MsgDial_varStart	0x1

#define Tgen_MsgDial_String_Character	0x200000	/* 2097152 */
typedef	UInt8	Tgen_MsgDial_String_Character_t;


typedef struct {
	UInt8	Character;
} Tgen_MsgDial_String_t;

#define Tgen_MsgDial_String_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgDial_String_Character), &((structAddr)->Character))


#define Tgen_MsgDial_String_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgDial_String_Character), &((structAddr)->Character))


#define Tgen_MsgDial_String_Size		1

#define Tgen_MsgDial_String	0x1	/* 1 */

/*
 * Tgen_MsgDial (value = 0x508) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt8	Count;
} Tgen_MsgDial_t;

#define Tgen_MsgDial_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgDial_Count), &((structAddr)->Count))


#define Tgen_MsgDial_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgDial_Count), &((structAddr)->Count))


#define Tgen_MsgDial_Size		1

#define Tgen_MsgDial	0x508	/* 1288 */
/* The MsgDial message is sent to start playing a string of tones defined by a 
 * null terminated ASCII string. The characters in the string are the labels of 
 * the predefined tones and are separated by a white space. The ParmSignalSet 
 * is used to decide which tone signal to play if two tone signals have the 
 * same Signal Label. Count - The total number Char's in the string including 
 * the NULL. Character - character of label to play. */

#define Tgen_MsgDialCmplt_Reason_EOD	0x1	/* 1 */

#define Tgen_MsgDialCmplt_Reason_UserStop	0x2	/* 2 */

#define Tgen_MsgDialCmplt_Reason_Rtc	0x3	/* 3 */

#define Tgen_MsgDialCmplt_Reason	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgDialCmplt_Reason_t;

#define Tgen_MsgDialCmplt_RtcLabel	0x380004	/* 3670020 */
typedef	UInt32	Tgen_MsgDialCmplt_RtcLabel_t;

/*
 * Tgen_MsgDialCmplt (value = 0x509) is an output message
 * for component Tgen.
 */


typedef struct {
	UInt32	Reason;
	UInt32	RtcLabel;
} Tgen_MsgDialCmplt_t;

#define Tgen_MsgDialCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgDialCmplt_Reason), &((structAddr)->Reason),	\
			(Tgen_MsgDialCmplt_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_MsgDialCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgDialCmplt_Reason), &((structAddr)->Reason),	\
			(Tgen_MsgDialCmplt_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_MsgDialCmplt_Size		8

#define Tgen_MsgDialCmplt	0x509	/* 1289 */
/* The MsgDialCmplt message is sent as a response to the MsgDial command when 
 * playback of the specified string of tones has completed. Reason - reason for 
 * stopping. RtcLabel - if Reason is Rtc then this is the EventLabel of the 
 * event which caused the playing of the tone to stop. */
/* The MsgStop message is sent to stop whatever play function is active in the 
 * Tone Generator. */

/*
 * Tgen_MsgStop (value = 0x50a) is an input message
 * for component Tgen.
 */

#define Tgen_MsgStop_Size		0

#define Tgen_MsgStop	0x50a	/* 1290 */
/* A request to get the wave generator address associated with a tone 
 * generator instance */

/*
 * Tgen_MsgWgenInfo (value = 0x50b) is an input message
 * for component Tgen.
 */

#define Tgen_MsgWgenInfo_Size		0

#define Tgen_MsgWgenInfo	0x50b	/* 1291 */

#define Tgen_MsgWgenInfoCmplt_Node	0x200000	/* 2097152 */
typedef	UInt8	Tgen_MsgWgenInfoCmplt_Node_t;

#define Tgen_MsgWgenInfoCmplt_Board	0x200001	/* 2097153 */
typedef	UInt8	Tgen_MsgWgenInfoCmplt_Board_t;

#define Tgen_MsgWgenInfoCmplt_Processor	0x200002	/* 2097154 */
typedef	UInt8	Tgen_MsgWgenInfoCmplt_Processor_t;

#define Tgen_MsgWgenInfoCmplt_Component	0x200003	/* 2097155 */
typedef	UInt8	Tgen_MsgWgenInfoCmplt_Component_t;

#define Tgen_MsgWgenInfoCmplt_Instance	0x200004	/* 2097156 */
typedef	UInt8	Tgen_MsgWgenInfoCmplt_Instance_t;

#define Tgen_MsgWgenInfoCmplt_PCMcoding	0x300005	/* 3145733 */
typedef	UInt24	Tgen_MsgWgenInfoCmplt_PCMcoding_t;

#define Tgen_MsgWgenInfoCmplt_streamID	0x300008	/* 3145736 */
typedef	UInt24	Tgen_MsgWgenInfoCmplt_streamID_t;

/*
 * Tgen_MsgWgenInfoCmplt (value = 0x50c) is an output message
 * for component Tgen.
 */


typedef struct {
	UInt8	Node;
	UInt8	Board;
	UInt8	Processor;
	UInt8	Component;
	UInt8	Instance;
	UInt24	PCMcoding;
	UInt24	streamID;
} Tgen_MsgWgenInfoCmplt_t;

#define Tgen_MsgWgenInfoCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(Tgen_MsgWgenInfoCmplt_Node), &((structAddr)->Node),	\
			(Tgen_MsgWgenInfoCmplt_Board), &((structAddr)->Board),	\
			(Tgen_MsgWgenInfoCmplt_Processor), &((structAddr)->Processor),	\
			(Tgen_MsgWgenInfoCmplt_Component), &((structAddr)->Component),	\
			(Tgen_MsgWgenInfoCmplt_Instance), &((structAddr)->Instance),	\
			(Tgen_MsgWgenInfoCmplt_PCMcoding), &((structAddr)->PCMcoding),	\
			(Tgen_MsgWgenInfoCmplt_streamID), &((structAddr)->streamID))


#define Tgen_MsgWgenInfoCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(Tgen_MsgWgenInfoCmplt_Node), &((structAddr)->Node),	\
			(Tgen_MsgWgenInfoCmplt_Board), &((structAddr)->Board),	\
			(Tgen_MsgWgenInfoCmplt_Processor), &((structAddr)->Processor),	\
			(Tgen_MsgWgenInfoCmplt_Component), &((structAddr)->Component),	\
			(Tgen_MsgWgenInfoCmplt_Instance), &((structAddr)->Instance),	\
			(Tgen_MsgWgenInfoCmplt_PCMcoding), &((structAddr)->PCMcoding),	\
			(Tgen_MsgWgenInfoCmplt_streamID), &((structAddr)->streamID))


#define Tgen_MsgWgenInfoCmplt_Size		11

#define Tgen_MsgWgenInfoCmplt	0x50c	/* 1292 */
/* Returns the actual wave generator address associated with an instance of 
 * the tone generator. Sent in response to a WgenInfo message. */
/* A request to get the wave generator ID's associated with the R2MF forward 
 * and backward sets */

/*
 * Tgen_MsgR2MFSet (value = 0x50d) is an input message
 * for component Tgen.
 */

#define Tgen_MsgR2MFSet_Size		0

#define Tgen_MsgR2MFSet	0x50d	/* 1293 */

#define Tgen_MsgR2MFSetCmplt_Forward	0x207800	/* 2127872 */
typedef	UInt8	Tgen_MsgR2MFSetCmplt_Forward_t[16];

#define Tgen_MsgR2MFSetCmplt_Backward	0x207810	/* 2127888 */
typedef	UInt8	Tgen_MsgR2MFSetCmplt_Backward_t[16];

/*
 * Tgen_MsgR2MFSetCmplt (value = 0x50e) is an output message
 * for component Tgen.
 */


typedef struct {
	UInt8	Forward[16];
	UInt8	Backward[16];
} Tgen_MsgR2MFSetCmplt_t;

#define Tgen_MsgR2MFSetCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgR2MFSetCmplt_Forward), &((structAddr)->Forward),	\
			(Tgen_MsgR2MFSetCmplt_Backward), &((structAddr)->Backward))


#define Tgen_MsgR2MFSetCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgR2MFSetCmplt_Forward), &((structAddr)->Forward),	\
			(Tgen_MsgR2MFSetCmplt_Backward), &((structAddr)->Backward))


#define Tgen_MsgR2MFSetCmplt_Size		32

#define Tgen_MsgR2MFSetCmplt	0x50e	/* 1294 */
/* Returns the actual wave generator ID's associated with the R2MF set. Sent 
 * in response to a R2MFSet message. */

#define Tgen_MsgDialx_Count	0x200000	/* 2097152 */
typedef	UInt8	Tgen_MsgDialx_Count_t;

#define Tgen_MsgDialx_ParmCount	0x200001	/* 2097153 */
typedef	UInt8	Tgen_MsgDialx_ParmCount_t;

#define Tgen_MsgDialx_varStart	0x2

#define Tgen_MsgDialx_String_Character	0x200000	/* 2097152 */
typedef	UInt8	Tgen_MsgDialx_String_Character_t;


typedef struct {
	UInt8	Character;
} Tgen_MsgDialx_String_t;

#define Tgen_MsgDialx_String_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgDialx_String_Character), &((structAddr)->Character))


#define Tgen_MsgDialx_String_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgDialx_String_Character), &((structAddr)->Character))


#define Tgen_MsgDialx_String_Size		1

#define Tgen_MsgDialx_String	0x2	/* 2 */

#define Tgen_MsgDialx_ParmList_Num	0x880000	/* 8912896 */
typedef	QParm	Tgen_MsgDialx_ParmList_Num_t;

#define Tgen_MsgDialx_ParmList_Val	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgDialx_ParmList_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Tgen_MsgDialx_ParmList_t;

#define Tgen_MsgDialx_ParmList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgDialx_ParmList_Num), &((structAddr)->Num),	\
			(Tgen_MsgDialx_ParmList_Val), &((structAddr)->Val))


#define Tgen_MsgDialx_ParmList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgDialx_ParmList_Num), &((structAddr)->Num),	\
			(Tgen_MsgDialx_ParmList_Val), &((structAddr)->Val))


#define Tgen_MsgDialx_ParmList_Size		8

#define Tgen_MsgDialx_ParmList	0x1	/* 1 */

/*
 * Tgen_MsgDialx (value = 0x50f) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt8	Count;
	UInt8	ParmCount;
} Tgen_MsgDialx_t;

#define Tgen_MsgDialx_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgDialx_Count), &((structAddr)->Count),	\
			(Tgen_MsgDialx_ParmCount), &((structAddr)->ParmCount))


#define Tgen_MsgDialx_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgDialx_Count), &((structAddr)->Count),	\
			(Tgen_MsgDialx_ParmCount), &((structAddr)->ParmCount))


#define Tgen_MsgDialx_Size		2

#define Tgen_MsgDialx	0x50f	/* 1295 */
/* The MsgDial message is sent to set a list of parameters and, then, start 
 * playing a string of tones defined by a null terminated ASCII string. The 
 * characters in the string are the labels of the predefined tones and are 
 * separated by a white space. The ParmSignalSet is used to decide which tone 
 * signal to play if two tone signals have the same Signal Label. Count - The 
 * total number Characters in the string including the NULL. Character - 
 * character of label to play. ParmCount - The number of parameters to be set. 
 * ParmList - The key/value pairs of the parameters to be set. */

#define Tgen_MsgPlayTonex_SignalId	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlayTonex_SignalId_t;

#define Tgen_MsgPlayTonex_ParmCount	0x200004	/* 2097156 */
typedef	UInt8	Tgen_MsgPlayTonex_ParmCount_t;

#define Tgen_MsgPlayTonex_varStart	0x5

#define Tgen_MsgPlayTonex_ParmList_Num	0x880000	/* 8912896 */
typedef	QParm	Tgen_MsgPlayTonex_ParmList_Num_t;

#define Tgen_MsgPlayTonex_ParmList_Val	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlayTonex_ParmList_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Tgen_MsgPlayTonex_ParmList_t;

#define Tgen_MsgPlayTonex_ParmList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlayTonex_ParmList_Num), &((structAddr)->Num),	\
			(Tgen_MsgPlayTonex_ParmList_Val), &((structAddr)->Val))


#define Tgen_MsgPlayTonex_ParmList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlayTonex_ParmList_Num), &((structAddr)->Num),	\
			(Tgen_MsgPlayTonex_ParmList_Val), &((structAddr)->Val))


#define Tgen_MsgPlayTonex_ParmList_Size		8

#define Tgen_MsgPlayTonex_ParmList	0x2	/* 2 */

/*
 * Tgen_MsgPlayTonex (value = 0x510) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	ParmCount;
} Tgen_MsgPlayTonex_t;

#define Tgen_MsgPlayTonex_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlayTonex_SignalId), &((structAddr)->SignalId),	\
			(Tgen_MsgPlayTonex_ParmCount), &((structAddr)->ParmCount))


#define Tgen_MsgPlayTonex_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlayTonex_SignalId), &((structAddr)->SignalId),	\
			(Tgen_MsgPlayTonex_ParmCount), &((structAddr)->ParmCount))


#define Tgen_MsgPlayTonex_Size		5

#define Tgen_MsgPlayTonex	0x510	/* 1296 */
/* The MsgPlayTone message is sent to set a list of parameters and, then, 
 * start playing a tone signal. SignalId - signal Id of tone signals to play. 
 * ParmCount - The number of parameters to be set. ParmList - The key/value 
 * pairs of the parameters to be set. */

#define Tgen_MsgPlaySequencex_Count	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlaySequencex_Count_t;

#define Tgen_MsgPlaySequencex_ParmCount	0x200004	/* 2097156 */
typedef	UInt8	Tgen_MsgPlaySequencex_ParmCount_t;

#define Tgen_MsgPlaySequencex_varStart	0x5

#define Tgen_MsgPlaySequencex_List_SignalId	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlaySequencex_List_SignalId_t;


typedef struct {
	UInt32	SignalId;
} Tgen_MsgPlaySequencex_List_t;

#define Tgen_MsgPlaySequencex_List_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlaySequencex_List_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgPlaySequencex_List_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Tgen_MsgPlaySequencex_List_SignalId), &((structAddr)->SignalId))


#define Tgen_MsgPlaySequencex_List_Size		4

#define Tgen_MsgPlaySequencex_List	0x3	/* 3 */

#define Tgen_MsgPlaySequencex_ParmList_Num	0x880000	/* 8912896 */
typedef	QParm	Tgen_MsgPlaySequencex_ParmList_Num_t;

#define Tgen_MsgPlaySequencex_ParmList_Val	0x380000	/* 3670016 */
typedef	UInt32	Tgen_MsgPlaySequencex_ParmList_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} Tgen_MsgPlaySequencex_ParmList_t;

#define Tgen_MsgPlaySequencex_ParmList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlaySequencex_ParmList_Num), &((structAddr)->Num),	\
			(Tgen_MsgPlaySequencex_ParmList_Val), &((structAddr)->Val))


#define Tgen_MsgPlaySequencex_ParmList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlaySequencex_ParmList_Num), &((structAddr)->Num),	\
			(Tgen_MsgPlaySequencex_ParmList_Val), &((structAddr)->Val))


#define Tgen_MsgPlaySequencex_ParmList_Size		8

#define Tgen_MsgPlaySequencex_ParmList	0x3	/* 3 */

/*
 * Tgen_MsgPlaySequencex (value = 0x511) is an input message
 * for component Tgen.
 */


typedef struct {
	UInt32	Count;
	UInt8	ParmCount;
} Tgen_MsgPlaySequencex_t;

#define Tgen_MsgPlaySequencex_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlaySequencex_Count), &((structAddr)->Count),	\
			(Tgen_MsgPlaySequencex_ParmCount), &((structAddr)->ParmCount))


#define Tgen_MsgPlaySequencex_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_MsgPlaySequencex_Count), &((structAddr)->Count),	\
			(Tgen_MsgPlaySequencex_ParmCount), &((structAddr)->ParmCount))


#define Tgen_MsgPlaySequencex_Size		5

#define Tgen_MsgPlaySequencex	0x511	/* 1297 */
/* The MsgPlaySequence message is sent to set a list of parameters and, then, 
 * play a sequence of tone signals. Count - number of tone signals to play. Id 
 * - signal Ids of tone signals to play. ParmCount - The number of parameters 
 * to be set. ParmList - The key/value pairs of the parameters to be set. */
/* 
 * Tone Generator Parameter Definitions
 */
/*
 * Default playback level of tones. (absolute)
 */

#define Tgen_ParmTLP0	0x500	/* 1280 */
typedef	UInt32	Tgen_ParmTLP0_t;
/* When two or more signalId's map to the same ASCII label's this parameter is 
 * used to resolve the difference for all operations involving the label such 
 * as MsgDial. if only one signal Id is found with this label then this 
 * parameter is not relevant, that Id will always be used. By default the DTMF 
 * set is used. */

#define Tgen_ParmSignalSet	0x501	/* 1281 */
typedef	UInt32	Tgen_ParmSignalSet_t;

#define Tgen_ParmMaxSignalIds_def	0x80	/* 128 */
/* Maximum number of tone template definitions that may be defined for 
 * generation. The maximum is 256 templates. */

#define Tgen_ParmMaxSignalIds	0x502	/* 1282 */
typedef	UInt32	Tgen_ParmMaxSignalIds_t;
/* The maximum number of tones for one play sequence or dial message. The 
 * maximum and default value is 40. */
/* 
 * Tone Generator Error Code Definitions
 */

#define Tgen_ParmMaxSeqLen	0x503	/* 1283 */
typedef	UInt32	Tgen_ParmMaxSeqLen_t;
/* Invalid SignalId specified. Signal Id specified in Val field in error 
 * message. See below. */

#define Tgen_ErrSignalId	0x500	/* 1280 */
/*
 * Invalid Signal type. Signal Type in Val field in error message. See below.
 */

#define Tgen_ErrSignalType	0x501	/* 1281 */
/* Invalid frequency specified. Frequency in Val field in error message. 
 * Segment where error occured in Seg field in error message. See below. */

#define Tgen_ErrFrequency	0x502	/* 1282 */
/* Invalid amplitude specified. Amplitude in Val field in error message. 
 * Segment where error occured in Seg field in error message. See below */

#define Tgen_ErrAmplitude	0x503	/* 1283 */
/* Invalid next segment specified. Segmane in Val field in error message. 
 * Segment where error occured in Seg field in error message. See below. */

#define Tgen_ErrNextSeg	0x504	/* 1284 */

#define Tgen_ErrInvLabel	0x505	/* 1285 */

#define Tgen_DialErr_Msg	0x380000	/* 3670016 */
typedef	UInt32	Tgen_DialErr_Msg_t;

#define Tgen_DialErr_Code	0x380004	/* 3670020 */
typedef	UInt32	Tgen_DialErr_Code_t;

#define Tgen_DialErr_Label	0x201808	/* 2103304 */
typedef	UInt8	Tgen_DialErr_Label_t[4];

/*
 * Tgen_DialErr (value = generic) is a message
 * for component Tgen.
 */


typedef struct {
	UInt32	Msg;
	UInt32	Code;
	UInt8	Label[4];
} Tgen_DialErr_t;

#define Tgen_DialErr_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Tgen_DialErr_Msg), &((structAddr)->Msg),	\
			(Tgen_DialErr_Code), &((structAddr)->Code),	\
			(Tgen_DialErr_Label), &((structAddr)->Label))


#define Tgen_DialErr_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Tgen_DialErr_Msg), &((structAddr)->Msg),	\
			(Tgen_DialErr_Code), &((structAddr)->Code),	\
			(Tgen_DialErr_Label), &((structAddr)->Label))


#define Tgen_DialErr_Size		12
/*
 * Invalid label defined in dial string.
 */
/* Multiple tone signals with the same label enabled. Error message in DialErr 
 * format. */

#define Tgen_ErrMultiLabel	0x506	/* 1286 */
/*
 * The segment described in a create tone message was invalid
 */

#define Tgen_ErrBadTSD	0x507	/* 1287 */
/*
 * Maximum number of tone signals already creared.
 */
/*
 * Error message format
 */

#define Tgen_ErrMaxSignals	0x508	/* 1288 */

#define Tgen_Err_Msg	0x380000	/* 3670016 */
typedef	UInt32	Tgen_Err_Msg_t;

#define Tgen_Err_Code	0x380004	/* 3670020 */
typedef	UInt32	Tgen_Err_Code_t;

#define Tgen_Err_Val	0x380008	/* 3670024 */
typedef	UInt32	Tgen_Err_Val_t;

#define Tgen_Err_Seg	0x38000c	/* 3670028 */
typedef	UInt32	Tgen_Err_Seg_t;

/*
 * Tgen_Err (value = generic) is a message
 * for component Tgen.
 */


typedef struct {
	UInt32	Msg;
	UInt32	Code;
	UInt32	Val;
	UInt32	Seg;
} Tgen_Err_t;

#define Tgen_Err_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Tgen_Err_Msg), &((structAddr)->Msg),	\
			(Tgen_Err_Code), &((structAddr)->Code),	\
			(Tgen_Err_Val), &((structAddr)->Val),	\
			(Tgen_Err_Seg), &((structAddr)->Seg))


#define Tgen_Err_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Tgen_Err_Msg), &((structAddr)->Msg),	\
			(Tgen_Err_Code), &((structAddr)->Code),	\
			(Tgen_Err_Val), &((structAddr)->Val),	\
			(Tgen_Err_Seg), &((structAddr)->Seg))


#define Tgen_Err_Size		16
/*
 * Standard Attribute Definitions
 */

#define Tgen_Std_ComponentType	0x5	/* 5 */
/*
 * Component Type Defintion.
 */
/*
 * Mercury Tone Generator Specific Attributes
 */
/* 
 * Tone Generator Event Type Definitions. 
 */

#define Tgen_Event_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	Tgen_Event_ReturnAddress_t;

#define Tgen_Event_Type_EvtStarted	0x6	/* 6 */

#define Tgen_Event_Type_EvtStopped	0x7	/* 7 */

#define Tgen_Event_Type	0x380006	/* 3670022 */
typedef	UInt32	Tgen_Event_Type_t;

#define Tgen_Event_Label	0x38000a	/* 3670026 */
typedef	UInt32	Tgen_Event_Label_t;

/*
 * Tgen_Event (value = generic) is a message
 * for component Tgen.
 */


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Type;
	UInt32	Label;
} Tgen_Event_t;

#define Tgen_Event_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Tgen_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(Tgen_Event_Type), &((structAddr)->Type),	\
			(Tgen_Event_Label), &((structAddr)->Label))


#define Tgen_Event_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Tgen_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(Tgen_Event_Type), &((structAddr)->Type),	\
			(Tgen_Event_Label), &((structAddr)->Label))


#define Tgen_Event_Size		14
/*
 * EvtStarted is generated when a tone starts playing.
 */

#define Tgen_EvtStopped_EventLabel	0x380000	/* 3670016 */
typedef	UInt32	Tgen_EvtStopped_EventLabel_t;

#define Tgen_EvtStopped_Reason_EOD	0x1	/* 1 */

#define Tgen_EvtStopped_Reason_UserStop	0x2	/* 2 */

#define Tgen_EvtStopped_Reason_Rtc	0x3	/* 3 */

#define Tgen_EvtStopped_Reason	0x380004	/* 3670020 */
typedef	UInt32	Tgen_EvtStopped_Reason_t;

#define Tgen_EvtStopped_RtcLabel	0x380008	/* 3670024 */
typedef	UInt32	Tgen_EvtStopped_RtcLabel_t;

/*
 * Tgen_EvtStopped (value = generic) is a message
 * for component Tgen.
 */


typedef struct {
	UInt32	EventLabel;
	UInt32	Reason;
	UInt32	RtcLabel;
} Tgen_EvtStopped_t;

#define Tgen_EvtStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Tgen_EvtStopped_EventLabel), &((structAddr)->EventLabel),	\
			(Tgen_EvtStopped_Reason), &((structAddr)->Reason),	\
			(Tgen_EvtStopped_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_EvtStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Tgen_EvtStopped_EventLabel), &((structAddr)->EventLabel),	\
			(Tgen_EvtStopped_Reason), &((structAddr)->Reason),	\
			(Tgen_EvtStopped_RtcLabel), &((structAddr)->RtcLabel))


#define Tgen_EvtStopped_Size		12
/* EvtStopped is generated when playback of a tone or sequence of tones has 
 * stopped. The reason for stopping is in the data field of the message. */
/* 
 * Tone Generator Run Time Control Actions Definitions
 */

#define Tgen_Action_Label	0x380000	/* 3670016 */
typedef	UInt32	Tgen_Action_Label_t;

#define Tgen_Action_Type_RtcStop	0x4	/* 4 */

#define Tgen_Action_Type	0x380004	/* 3670020 */
typedef	UInt32	Tgen_Action_Type_t;

/*
 * Tgen_Action (value = generic) is a message
 * for component Tgen.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
} Tgen_Action_t;

#define Tgen_Action_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Tgen_Action_Label), &((structAddr)->Label),	\
			(Tgen_Action_Type), &((structAddr)->Type))


#define Tgen_Action_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Tgen_Action_Label), &((structAddr)->Label),	\
			(Tgen_Action_Type), &((structAddr)->Type))


#define Tgen_Action_Size		8
/*
 * RtcStop is a RTC Action to stop playback of a tone or tone sequence.
 */

/* Tgen_MsgDial_String_varStart is defined to avoid possible 
   backwards compatibility issues */
#define Tgen_MsgDial_String_varStart  Tgen_MsgDial_varStart

/*
 * End of all Mercury Tone Generator Component Definitions
 */

#define Tgen	0x5	/* 5 */

typedef struct {
	UInt32		ParmTLP0;
	UInt32		ParmSignalSet;
	UInt32		ParmMaxSignalIds;
	UInt32		ParmMaxSeqLen;

} Tgenparm_t;

#if defined ( Tgen_DEFINED )

ParmStruct TgenParmTab []= {
{Tgen_ParmTLP0, 4, 0, 0, 0, 0},
 {0x380000, offsetof(Tgenparm_t, ParmTLP0), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Tgenparm_t, ParmSignalSet), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Tgenparm_t, ParmMaxSignalIds), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Tgenparm_t, ParmMaxSeqLen), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_tgendefs_h_) */
