#ifndef _TS_DEF_H_
#define _TS_DEF_H_ 1
/****************************************************************************
*                              NOTICE
*  This source code contains proprietary and confidential information, 
*  and is the property of the Dialogic Corporation.
*
*  This program has been distributed under license agreement and any 
*  unauthorized use or distribution is prohibited.
*
*  Copyright 1997-2000 by Dialogic, An Intel Company. All rights reserved.
 ***************************************************************************/
/****************************************************************************
 * FILE:		ts_def.h         
 * AUTHOR:       
 * ORG:          
 * ORIG-DATE:    
 * LAST-MOD:	2/10/00 
 * PURPOSE:	
 *               
 * HISTORY:
 * Date			Who		Description
 *
 ***************************************************************************/

#define TS_DEC_STAT_SIZE	178
#define TS_ENC_STAT_SIZE	384
#define TS_DEC_WORK_X_SIZE	156
#define TS_ENC_WORK_X_SIZE	388
#define TS_DEC_WORK_Y_SIZE	665
#define TS_ENC_WORK_Y_SIZE	879
#define TS_TABLE_SIZE		633
#define TS_CODE_FRAME_SIZE	32

/* the total IDM for decoder */
#define TS_DEC_IDM_X	TS_DEC_WORK_X_SIZE
#define TS_DEC_IDM_Y	(TS_DEC_WORK_Y_SIZE + TS_DEC_STAT_SIZE)

/* the total IDM for encoder */
#define TS_ENC_IDM_X	TS_ENC_WORK_X_SIZE
#define TS_ENC_IDM_Y	(TS_ENC_WORK_Y_SIZE + TS_ENC_STAT_SIZE)

/* find the max X IDM between decoder and encoder */
#if TS_DEC_IDM_X > TS_ENC_IDM_X
#define TS_IDM_X TS_DEC_IDM_X
#else
#define TS_IDM_X TS_ENC_IDM_X
#endif

/* find the max Y IDM between decoder and encoder */
#if TS_DEC_IDM_Y > TS_ENC_IDM_Y
#define TS_IDM_Y TS_DEC_IDM_Y
#else
#define TS_IDM_Y TS_ENC_IDM_Y
#endif

/* find the max between X and Y */
#if TS_IDM_X > TS_IDM_Y
#define TS_SHARED_IDM  TS_IDM_X
#else
#define TS_SHARED_IDM  TS_IDM_Y
#endif

typedef struct{
        Uint24 *pMemX;
        Uint24 memXSize;
        Uint24 *pMemY;
        Uint24 memYSize;
} TS_MEM_DESC_t;

typedef struct{
	TS_MEM_DESC_t wstate;
	TS_MEM_DESC_t work;
	TS_MEM_DESC_t state;
	TS_MEM_DESC_t table;
} TS_DEC_MEM_t, *TS_DEC_HANDLE_t;

typedef struct{
	TS_MEM_DESC_t wstate;
	TS_MEM_DESC_t work;
	TS_MEM_DESC_t state;
	TS_MEM_DESC_t table;
} TS_ENC_MEM_t, *TS_ENC_HANDLE_t;


/* Prototypes of the functions of speech encoder visible from outside */

/* Table Initialization */

void  TS_Init(Uint24 *pScratch_x, Uint24 *pScratch_y, Uint24 *pTable);



/* Swap encoder states from state (external) memory to work (internal)
   memory */

void  TS_ActivateEncoder(TS_ENC_HANDLE_t enc_hdl);
void  TS_ActivateDecoder(TS_DEC_HANDLE_t dec_hdl);

/* Swap encoder states from work (internal) memory to state (external)
   memory */

void  TS_DeactivateEncoder(TS_ENC_HANDLE_t enc_hdl);
void  TS_DeactivateDecoder(TS_DEC_HANDLE_t dec_hdl);

/* True Speech Encoder function call */
 
void  TS_Encoder(TS_ENC_HANDLE_t enc_hdl, Int24 *pPCM, Uint24 *pEncodedData);

void  TS_Decoder(TS_DEC_HANDLE_t dec_hdl, Uint24 *pEncodedData, Int24 *pPCM);


/* Encoder -Decoder Initialization */
/* Encoder instance initialization function */

void TS_Create_Encoder( TS_ENC_HANDLE_t enc_hdl,
			Uint24 *pWState, Uint24 *pState); 
			
void TS_Create_Decoder( TS_DEC_HANDLE_t dec_hdl,
			Uint24 *pWState, Uint24 *pState);
			
#endif
