
/*
 * This file was automatically generated from tscdefs.txt.
 * Author: "DM3 TSP Team"
 * Version: "Revision A.69"
 * Date: Wed Jun 25 11:19:17 2003
 * The output was written to tscdefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_tscdefs_h_)
#define _tscdefs_h_ 1
/* This file describes the list of Mercury messages, parameters and equates 
 * supported by the Mercury Telephony Service Channel Component and its 
 * Instances. */

/* Patch to correct Char type output by MMDL */
#ifndef Char
#define Char char
#endif

/* 
 * TSC Component Type Definition 
 */
/* The TSC Component uses messages from the Standard Kernel Message Set, the 
 * Standard Component Message Set, and the Mercury Channel Protocol Message 
 * Set. */
/*
 * Mercury Kernel Standard Message Set defined in mercdefs.doc
 */
/*
 * Standard Component Message Set defined in stddefs.doc.
 */

/*
 * COMPONENT TSC (value = 0x12) uses:
 *	MESSAGE Std_MsgArmRTC
 *	MESSAGE Std_MsgArmRTCCmplt
 *	MESSAGE Std_MsgArmxRTCs
 *	MESSAGE Std_MsgArmxRTCsCmplt
 *	MESSAGE Std_MsgCancelEvt
 *	MESSAGE Std_MsgCancelEvtCmplt
 *	MESSAGE Std_MsgComtest
 *	MESSAGE Std_MsgComtestCmplt
 *	MESSAGE Std_MsgDetectEvt
 *	MESSAGE Std_MsgDetectEvtCmplt
 *	MESSAGE Std_MsgDetectxEvts
 *	MESSAGE Std_MsgDetecxtEvtsCmplt
 *	MESSAGE Std_MsgDisarmRTC
 *	MESSAGE Std_MsgDisarmRTCCmplt
 *	MESSAGE Std_MsgDisarmxRTCs
 *	MESSAGE Std_MsgDisarmxRTCsCmplt
 *	MESSAGE Std_MsgError
 *	MESSAGE Std_MsgEvtDetected
 *	MESSAGE Std_MsgGetParm
 *	MESSAGE Std_MsgGetParmCmplt
 *	MESSAGE Std_MsgInit
 *	MESSAGE Std_MsgInitCmplt
 *	MESSAGE Std_MsgSetParm
 *	MESSAGE Std_MsgSetParmCmplt
 *	MESSAGE Std_MsgSetParmDef
 *	MESSAGE Std_MsgSetParmDefCmplt
Need this close comment to work around an MMDL bug  */
/*
 * Channel Protocol Message Set defined in cprodefs.h.
 */
 /* Need this open comment to work around an MMDL bug 
 *	MESSAGE MsgAcceptCall
 *	MESSAGE MsgAnswerCall
 *	MESSAGE MsgBlindTransferCall
 *	MESSAGE MsgCancelTransfer
 *	MESSAGE MsgCancelComplete
 *	MESSAGE MsgCompleteCall
 *	MESSAGE MsgCompleteTransfer
 *	MESSAGE MsgDropCall
 *	MESSAGE MsgGetCallInfo
 *	MESSAGE MsgGetCallInfoCmplt
 *	MESSAGE MsgGetCallState
 *	MESSAGE MsgGetCallStateCmplt
 *	MESSAGE MsgGetChanState
 *	MESSAGE MsgGetChanStateCmplt
 *	MESSAGE MsgHoldCall
 *	MESSAGE MsgHoldCallAck
 *	MESSAGE MsgHoldCallRej
 *	MESSAGE MsgMakeCall
 *	MESSAGE MsgMakeCallCmplt
 *	MESSAGE MsgParkCall
 *	MESSAGE MsgParkCallCmplt
 *	MESSAGE MsgPickupCall
 *	MESSAGE MsgPickupCallCmplt
 *	MESSAGE MsgReconnectCall
 *	MESSAGE MsgRedirectCall
 *	MESSAGE MsgReleaseCall
 *	MESSAGE MsgRejectCall
 *	MESSAGE MsgRetrieveCall
 *	MESSAGE MsgRetrieveCallAck
 *	MESSAGE MsgRetrieveCallRej
 *	MESSAGE MsgSetChanState
 *	MESSAGE MsgSetChanStateCmplt
 *	MESSAGE MsgInitTransfer
 *	MESSAGE MsgWaitCall
 *	MESSAGE EvtCallInfo
 *	MESSAGE EvtCallState
 *	MESSAGE MsgProceedCall
 *	MESSAGE MsgSetMWI
 *	MESSAGE MsgSetMWICmplt
 */
/* 
 * TSC Message Definitions
 */

#define TSC_MsgAcceptCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgAcceptCall_CallId_t;

/*
 * TSC_MsgAcceptCall (value = 0x1200) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgAcceptCall_t;

#define TSC_MsgAcceptCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgAcceptCall_CallId), &((structAddr)->CallId))


#define TSC_MsgAcceptCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgAcceptCall_CallId), &((structAddr)->CallId))


#define TSC_MsgAcceptCall_Size		4

#define TSC_MsgAcceptCall	0x1200	/* 4608 */
/* This command accepts the specified call (CallId). If the call is not in the 
 * Offered state then the response to this command will be an error. If the 
 * call is in the Offered state, then the call state will transition to 
 * Accepted if the call is accepted successfully. CallId Identifier of the call 
 * to accept. This is the ID that was given to the Client when it was notified 
 * of the incoming (Offered) call. */

#define TSC_MsgAnswerCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgAnswerCall_CallId_t;

#define TSC_MsgAnswerCall_NumRings	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgAnswerCall_NumRings_t;

#define TSC_MsgAnswerCall_varStart	0x8

#define TSC_MsgAnswerCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgAnswerCall_KVSet_t;

/*
 * TSC_MsgAnswerCall (value = 0x1201) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	NumRings;
} TSC_MsgAnswerCall_t;

#define TSC_MsgAnswerCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgAnswerCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgAnswerCall_NumRings), &((structAddr)->NumRings))


#define TSC_MsgAnswerCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgAnswerCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgAnswerCall_NumRings), &((structAddr)->NumRings))


#define TSC_MsgAnswerCall_Size		8

#define TSC_MsgAnswerCall	0x1201	/* 4609 */
/* This command instructs the Protocol to answer the call identified by 
 * CallId. If the call is not in the Offered state then the response to this 
 * command will be an error. If the call is in the Offered state, then the call 
 * state will transition to Connected if the call is successfully answered. The 
 * call state will transition to Idle if the remote party drops the call prior 
 * to the completion of the answer operation. CallId Identifier of the call to 
 * answer. This is the ID that was given to the Client when it was notified of 
 * the incoming (Offered) call. NumRings The number of rings to wait prior to 
 * answering the call. If number of rings has already been received at the time 
 * the command is received, then the call will be answered immediately. Note: 
 * This field is currently not implemented. KVSet An optional Key-Value set 
 * specifying protocol-specific parameters for the operation. This field is a 
 * "place holder" for a KVSet structure. If no KVSet is appended to the message 
 * then leave this field out of the message.. This is only supported by the 
 * NetTSC component. */

#define TSC_MsgBlindTransferCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgBlindTransferCall_CallId_t;

#define TSC_MsgBlindTransferCall_DestAddr	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgBlindTransferCall_DestAddr_t[128];

#define TSC_MsgBlindTransferCall_OrigAddr	0x53f884	/* 5503108 */
typedef	Char	TSC_MsgBlindTransferCall_OrigAddr_t[128];

#define TSC_MsgBlindTransferCall_CallProgress_Disabled	0	/* 0 */

#define TSC_MsgBlindTransferCall_CallProgress_Enabled	0x1	/* 1 */

#define TSC_MsgBlindTransferCall_CallProgress	0x200104	/* 2097412 */
typedef	UInt8	TSC_MsgBlindTransferCall_CallProgress_t;

/*
 * TSC_MsgBlindTransferCall (value = 0x1202) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	Char	DestAddr[128];
	Char	OrigAddr[128];
	UInt8	CallProgress;
} TSC_MsgBlindTransferCall_t;

#define TSC_MsgBlindTransferCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_MsgBlindTransferCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgBlindTransferCall_DestAddr), &((structAddr)->DestAddr),	\
			(TSC_MsgBlindTransferCall_OrigAddr), &((structAddr)->OrigAddr),	\
			(TSC_MsgBlindTransferCall_CallProgress), &((structAddr)->CallProgress))


#define TSC_MsgBlindTransferCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_MsgBlindTransferCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgBlindTransferCall_DestAddr), &((structAddr)->DestAddr),	\
			(TSC_MsgBlindTransferCall_OrigAddr), &((structAddr)->OrigAddr),	\
			(TSC_MsgBlindTransferCall_CallProgress), &((structAddr)->CallProgress))


#define TSC_MsgBlindTransferCall_Size		261

#define TSC_MsgBlindTransferCall	0x1202	/* 4610 */
/* This command performs a blind transfer of the call specified by CallId to 
 * the destination specified by DestAddr. CallId Identifies the call to 
 * transfer (the object of the transfer operation). DestAddr The destination 
 * for the transfer. OrigAddr Address of the originator of the transfer. (This 
 * may be an optional parameter; refer to the Protocol Implementation notes). 
 * CallProgress Enables or disables call progress monitoring. If this is 
 * enabled then the progress of the call is monitored using call analysis and 
 * the transfer is only completed if a connection is successfully made to the 
 * destination address (e.g. someone answers the call). If the connection is 
 * not successful then the call will revert to the original party (state change 
 * from HoldPendXfer to Connected). */

#define TSC_MsgCancelTransfer_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgCancelTransfer_CallId_t;

/*
 * TSC_MsgCancelTransfer (value = 0x1203) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgCancelTransfer_t;

#define TSC_MsgCancelTransfer_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgCancelTransfer_CallId), &((structAddr)->CallId))


#define TSC_MsgCancelTransfer_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgCancelTransfer_CallId), &((structAddr)->CallId))


#define TSC_MsgCancelTransfer_Size		4

#define TSC_MsgCancelTransfer	0x1203	/* 4611 */
/* This command cancels a supervised transfer that is being performed. It can 
 * only be issued after the initiation of a supervised transfer and the receipt 
 * of a MsgInitTransferCmplt response. CallId Identifies the consultation call 
 * associated with the supervised transfer. */

#define TSC_MsgCancelComplete_CmpltId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgCancelComplete_CmpltId_t;

/*
 * TSC_MsgCancelComplete (value = 0x1204) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CmpltId;
} TSC_MsgCancelComplete_t;

#define TSC_MsgCancelComplete_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgCancelComplete_CmpltId), &((structAddr)->CmpltId))


#define TSC_MsgCancelComplete_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgCancelComplete_CmpltId), &((structAddr)->CmpltId))


#define TSC_MsgCancelComplete_Size		4

#define TSC_MsgCancelComplete	0x1204	/* 4612 */
/* This command cancels a previously initiated complete-call operation. 
 * CmpltId The completion identifier returned when the complete-call operation 
 * was initiated. */

#define TSC_MsgCompleteCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgCompleteCall_CallId_t;

#define TSC_MsgCompleteCall_Mode_CampOn	0x2	/* 2 */

#define TSC_MsgCompleteCall_Mode_CallBack	0x3	/* 3 */

#define TSC_MsgCompleteCall_Mode	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgCompleteCall_Mode_t;

/*
 * TSC_MsgCompleteCall (value = 0x1205) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Mode;
} TSC_MsgCompleteCall_t;

#define TSC_MsgCompleteCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgCompleteCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgCompleteCall_Mode), &((structAddr)->Mode))


#define TSC_MsgCompleteCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgCompleteCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgCompleteCall_Mode), &((structAddr)->Mode))


#define TSC_MsgCompleteCall_Size		8

#define TSC_MsgCompleteCall	0x1205	/* 4613 */
/* This command requests the switch or network continue attempting to complete 
 * the specified call (CallId). The call must have failed to complete (e.g.; 
 * the call is in the Failed state).. CallId The call identifier of the call to 
 * be completed. Mode The completion mode to use for the call completion 
 * service. */

#define TSC_MsgCompleteCallCmplt_CmpltId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgCompleteCallCmplt_CmpltId_t;

/*
 * TSC_MsgCompleteCallCmplt (value = 0x1206) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CmpltId;
} TSC_MsgCompleteCallCmplt_t;

#define TSC_MsgCompleteCallCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgCompleteCallCmplt_CmpltId), &((structAddr)->CmpltId))


#define TSC_MsgCompleteCallCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgCompleteCallCmplt_CmpltId), &((structAddr)->CmpltId))


#define TSC_MsgCompleteCallCmplt_Size		4

#define TSC_MsgCompleteCallCmplt	0x1206	/* 4614 */
/* This is the response to the MsgCompleteCall command. It indicates that a 
 * call-completion operation has been successfully initiated. CmpltId The 
 * call-completion identifier returned by the network to track the call 
 * completion operation. This identifier is used if the command 
 * MsgCancelComplete is issued. */

#define TSC_MsgCompleteTransfer_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgCompleteTransfer_CallId_t;

#define TSC_MsgCompleteTransfer_ConCallId	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgCompleteTransfer_ConCallId_t;

/*
 * TSC_MsgCompleteTransfer (value = 0x1207) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	ConCallId;
} TSC_MsgCompleteTransfer_t;

#define TSC_MsgCompleteTransfer_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgCompleteTransfer_CallId), &((structAddr)->CallId),	\
			(TSC_MsgCompleteTransfer_ConCallId), &((structAddr)->ConCallId))


#define TSC_MsgCompleteTransfer_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgCompleteTransfer_CallId), &((structAddr)->CallId),	\
			(TSC_MsgCompleteTransfer_ConCallId), &((structAddr)->ConCallId))


#define TSC_MsgCompleteTransfer_Size		8

#define TSC_MsgCompleteTransfer	0x1207	/* 4615 */
/* This command completes a transfer that was initiated by MsgInitTransfer. 
 * The consultation call (ConCallId) that was initiated to the transfer 
 * destination is connected to the call that was the object of the transfer 
 * (CallId). The call state for both calls transitions to the Idle state. 
 * CallId Call identifier of the call that is the object of the transfer 
 * operation (transferee). ConCallId Identifies the consultation call 
 * associated with the supervised transfer. */

#define TSC_MsgDefineBSet_SetId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgDefineBSet_SetId_t;

#define TSC_MsgDefineBSet_LineId	0x200001	/* 2097153 */
typedef	UInt8	TSC_MsgDefineBSet_LineId_t;

#define TSC_MsgDefineBSet_StartChannelId	0x200002	/* 2097154 */
typedef	UInt8	TSC_MsgDefineBSet_StartChannelId_t;

#define TSC_MsgDefineBSet_NumChannels	0x200003	/* 2097155 */
typedef	UInt8	TSC_MsgDefineBSet_NumChannels_t;

#define TSC_MsgDefineBSet_BaseProtocol	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgDefineBSet_BaseProtocol_t;

#define TSC_MsgDefineBSet_InboundVariantId	0x200008	/* 2097160 */
typedef	UInt8	TSC_MsgDefineBSet_InboundVariantId_t;

#define TSC_MsgDefineBSet_OutboundVariantId	0x200009	/* 2097161 */
typedef	UInt8	TSC_MsgDefineBSet_OutboundVariantId_t;

#define TSC_MsgDefineBSet_DChannelDesc	0x80000a	/* 8388618 */
typedef	QCompDesc	TSC_MsgDefineBSet_DChannelDesc_t;

#define TSC_MsgDefineBSet_AdminGroup	0x380010	/* 3670032 */
typedef	UInt32	TSC_MsgDefineBSet_AdminGroup_t;

#define TSC_MsgDefineBSet_Width	0x200014	/* 2097172 */
typedef	UInt8	TSC_MsgDefineBSet_Width_t;

#define TSC_MsgDefineBSet_varStart	0x15

#define TSC_MsgDefineBSet_BChanId_Null	0	/* 0 */

#define TSC_MsgDefineBSet_BChanId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgDefineBSet_BChanId_t;

#define TSC_MsgDefineBSet_SlotId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgDefineBSet_SlotId_t;

#define TSC_MsgDefineBSet_Direction_Inbound	0x1	/* 1 */

#define TSC_MsgDefineBSet_Direction_Outbound	0x2	/* 2 */

#define TSC_MsgDefineBSet_Direction_Both	0x3	/* 3 */

#define TSC_MsgDefineBSet_Direction	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgDefineBSet_Direction_t;

#define TSC_MsgDefineBSet_Count	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgDefineBSet_Count_t;

/*
 * TSC_MsgDefineBSet (value = 0x1208) is an input message
 * for component TSC.
 */


typedef struct {
	UInt8	SetId;
	UInt8	LineId;
	UInt8	StartChannelId;
	UInt8	NumChannels;
	UInt32	BaseProtocol;
	UInt8	InboundVariantId;
	UInt8	OutboundVariantId;
	QCompDesc	DChannelDesc;
	UInt32	AdminGroup;
	UInt8	Width;
} TSC_MsgDefineBSet_t;

#define TSC_MsgDefineBSet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 10, &(offset),	\
			(TSC_MsgDefineBSet_SetId), &((structAddr)->SetId),	\
			(TSC_MsgDefineBSet_LineId), &((structAddr)->LineId),	\
			(TSC_MsgDefineBSet_StartChannelId), &((structAddr)->StartChannelId),	\
			(TSC_MsgDefineBSet_NumChannels), &((structAddr)->NumChannels),	\
			(TSC_MsgDefineBSet_BaseProtocol), &((structAddr)->BaseProtocol),	\
			(TSC_MsgDefineBSet_InboundVariantId), &((structAddr)->InboundVariantId),	\
			(TSC_MsgDefineBSet_OutboundVariantId), &((structAddr)->OutboundVariantId),	\
			(TSC_MsgDefineBSet_DChannelDesc), &((structAddr)->DChannelDesc),	\
			(TSC_MsgDefineBSet_AdminGroup), &((structAddr)->AdminGroup),	\
			(TSC_MsgDefineBSet_Width), &((structAddr)->Width))


#define TSC_MsgDefineBSet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 10, &(offset),	\
			(TSC_MsgDefineBSet_SetId), &((structAddr)->SetId),	\
			(TSC_MsgDefineBSet_LineId), &((structAddr)->LineId),	\
			(TSC_MsgDefineBSet_StartChannelId), &((structAddr)->StartChannelId),	\
			(TSC_MsgDefineBSet_NumChannels), &((structAddr)->NumChannels),	\
			(TSC_MsgDefineBSet_BaseProtocol), &((structAddr)->BaseProtocol),	\
			(TSC_MsgDefineBSet_InboundVariantId), &((structAddr)->InboundVariantId),	\
			(TSC_MsgDefineBSet_OutboundVariantId), &((structAddr)->OutboundVariantId),	\
			(TSC_MsgDefineBSet_DChannelDesc), &((structAddr)->DChannelDesc),	\
			(TSC_MsgDefineBSet_AdminGroup), &((structAddr)->AdminGroup),	\
			(TSC_MsgDefineBSet_Width), &((structAddr)->Width))


#define TSC_MsgDefineBSet_Size		21

#define TSC_MsgDefineBSet	0x1208	/* 4616 */
/* 
 * This command defines a bearer channel set. 
 */
/* This is the response to the command MsgDefineBSet. It indicates that the 
 * Bearer Channel Set has been successfully defined. */

/*
 * TSC_MsgDefineBSetCmplt (value = 0x1209) is an output message
 * for component TSC.
 */

#define TSC_MsgDefineBSetCmplt_Size		0

#define TSC_MsgDefineBSetCmplt	0x1209	/* 4617 */

#define TSC_MsgDetectEvtSet_RetAddr	0x800000	/* 8388608 */
typedef	QCompDesc	TSC_MsgDetectEvtSet_RetAddr_t;

#define TSC_MsgDetectEvtSet_Type	0x380006	/* 3670022 */
typedef	UInt32	TSC_MsgDetectEvtSet_Type_t;

#define TSC_MsgDetectEvtSet_Label	0x38000a	/* 3670026 */
typedef	UInt32	TSC_MsgDetectEvtSet_Label_t;

#define TSC_MsgDetectEvtSet_Count	0x38000e	/* 3670030 */
typedef	UInt32	TSC_MsgDetectEvtSet_Count_t;

#define TSC_MsgDetectEvtSet_varStart	0x12

#define TSC_MsgDetectEvtSet_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDetectEvtSet_Id_t;

/*
 * TSC_MsgDetectEvtSet (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	QCompDesc	RetAddr;
	UInt32	Type;
	UInt32	Label;
	UInt32	Count;
} TSC_MsgDetectEvtSet_t;

#define TSC_MsgDetectEvtSet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_MsgDetectEvtSet_RetAddr), &((structAddr)->RetAddr),	\
			(TSC_MsgDetectEvtSet_Type), &((structAddr)->Type),	\
			(TSC_MsgDetectEvtSet_Label), &((structAddr)->Label),	\
			(TSC_MsgDetectEvtSet_Count), &((structAddr)->Count))


#define TSC_MsgDetectEvtSet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_MsgDetectEvtSet_RetAddr), &((structAddr)->RetAddr),	\
			(TSC_MsgDetectEvtSet_Type), &((structAddr)->Type),	\
			(TSC_MsgDetectEvtSet_Label), &((structAddr)->Label),	\
			(TSC_MsgDetectEvtSet_Count), &((structAddr)->Count))


#define TSC_MsgDetectEvtSet_Size		18
/* This is a message body template for the Std_MsgDetectEvt message. This 
 * template enables Std_MsgEvtDetected event generation for the specified event 
 * type and extends the Std_MsgDetectEvt message to allow a set of conditions 
 * to be specified.. The message contains a list of identifiers which are used 
 * to specify the set of conditions that must be meet in order for the event to 
 * be generated. For example, for the event type 
 * TSC_EvtCallInfoSet_Type_CallInfoSet the Id list represents a set of Call 
 * Information Identifiers. A Std_MsgEvtDetected message is sent once all of 
 * the pieces of call information are available accompanied by the value of 
 * each call information element (see TSC_EvtCallInfoSet, Section 7.37). The 
 * event is generated once per call, and only once all of the specified call 
 * information elements are available. For the event type 
 * TSC_EvtCallInfoSet_Type_IESet, the Id list represents a sequential list of 
 * Q.931 Information Element identifiers. If one or more of the Q.931 
 * information elements in the set is present in a received message then a 
 * Std_MsgEvtDetected message is sent using a TSC_EvtCallInfoSet body with all 
 * of the received information element as the payload. This event is generated 
 * whenever one or more of the Q.931 information elements is received. For the 
 * event type TSC_EvtCallInfoSet_Type_ISDNMsgSet, the Id list represents a 
 * sequential list of Q.931 Message identifiers. Whenever one of the Q.931 
 * messages is received a Std_MsgEvtDetected message is sent using a 
 * TSC_EvtCallInfoSet body with the message as its payload. This event is 
 * generated whenever one of the Q.931 messages is received. RetAddr The 
 * address to send the Std_MsgEvtDetected message to when the event is 
 * detected. Type The event type to enable (e.g. 
 * TSC_EvtCallInfoSet_Type_CallInfoSet). Label The label to send in the 
 * Std_MsgEvtDetected message. Count The number of Call Information Identifiers 
 * in the varstart section of the message. Id Identifies the Call information 
 * element, Q.931 Information Element, or Q.931 Message to report. The varstart 
 * section of the message is a list of these identifiers which specifies the 
 * set of elements or messages to generate the Std_MsgEvtDetected event for. */

#define TSC_MsgDropCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDropCall_CallId_t;

#define TSC_MsgDropCall_Reason	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgDropCall_Reason_t;

#define TSC_MsgDropCall_varStart	0x8

#define TSC_MsgDropCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDropCall_KVSet_t;

/*
 * TSC_MsgDropCall (value = 0x120a) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Reason;
} TSC_MsgDropCall_t;

#define TSC_MsgDropCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgDropCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgDropCall_Reason), &((structAddr)->Reason))


#define TSC_MsgDropCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgDropCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgDropCall_Reason), &((structAddr)->Reason))


#define TSC_MsgDropCall_Size		8

#define TSC_MsgDropCall	0x120a	/* 4618 */
/* This message instructs the TSC Instance to drop or disconnect call 
 * specified by CallId. If the operation is successful then the call state will 
 * transition to Idle. CallId Identifies the call to drop. Reason Indicates the 
 * reason that the call is being dropped. Possible values are defined in Table 
 * 4. Call State Reasons, Section 13.3. KVSet An optional Key-Value set 
 * specifying protocol-specific parameters for the operation. This field is a 
 * "place holder" for a KVSet structure. If no KVSet is appended to the message 
 * then leave this field out of the message. NOTE: This is currently only 
 * supported by NetTSC. */

#define TSC_MsgGetCallInfo_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetCallInfo_CallId_t;

#define TSC_MsgGetCallInfo_Count	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgGetCallInfo_Count_t;

#define TSC_MsgGetCallInfo_varStart	0x8

#define TSC_MsgGetCallInfo_InfoId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetCallInfo_InfoId_t;

/*
 * TSC_MsgGetCallInfo (value = 0x120b) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Count;
} TSC_MsgGetCallInfo_t;

#define TSC_MsgGetCallInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgGetCallInfo_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetCallInfo_Count), &((structAddr)->Count))


#define TSC_MsgGetCallInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgGetCallInfo_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetCallInfo_Count), &((structAddr)->Count))


#define TSC_MsgGetCallInfo_Size		8

#define TSC_MsgGetCallInfo	0x120b	/* 4619 */
/* This message is an inquiry requesting stored call information related to 
 * the call specified by CallId. One or more InfoId fields may be specified to 
 * request one or more call information elements (the size of the message is 
 * used to determine how many call information elements are being requested). 
 * The InfoId field indicates the specific information that is requested. 
 * CallId Identifies the call to obtain information on. Count Specifies the 
 * number of information elements being requested (1 to 32). InfoId Identifies 
 * the information to return. One more InfoId fields may be present (as 
 * specified in the Count field). */

#define TSC_MsgGetCallInfoCmplt_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetCallInfoCmplt_CallId_t;

#define TSC_MsgGetCallInfoCmplt_Count	0x200004	/* 2097156 */
typedef	UInt8	TSC_MsgGetCallInfoCmplt_Count_t;

#define TSC_MsgGetCallInfoCmplt_varStart	0x5

#define TSC_MsgGetCallInfoCmplt_CallInfo	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetCallInfoCmplt_CallInfo_t;

/*
 * TSC_MsgGetCallInfoCmplt (value = 0x120c) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt8	Count;
} TSC_MsgGetCallInfoCmplt_t;

#define TSC_MsgGetCallInfoCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgGetCallInfoCmplt_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetCallInfoCmplt_Count), &((structAddr)->Count))


#define TSC_MsgGetCallInfoCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgGetCallInfoCmplt_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetCallInfoCmplt_Count), &((structAddr)->Count))


#define TSC_MsgGetCallInfoCmplt_Size		5

#define TSC_MsgGetCallInfoCmplt	0x120c	/* 4620 */
/* This is the response to the MsgGetCallInfo request. The varstart section of 
 * the message contains one CallInfo structure for each of the call information 
 * elements specified in the request. CallId The call that the call information 
 * is associated with. Count The number of CallInfo structures in the variable 
 * body of the message. CallInfo This is a place holder for the CallInfo 
 * structure. The CallInfo structure is a variable length array of the Call 
 * Information elements requested in the original MsgGetCallInfo. See section 
 * 8.1, for a definition of the CallInfo structure. */

#define TSC_MsgGetCallState_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetCallState_CallId_t;

/*
 * TSC_MsgGetCallState (value = 0x120d) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgGetCallState_t;

#define TSC_MsgGetCallState_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgGetCallState_CallId), &((structAddr)->CallId))


#define TSC_MsgGetCallState_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgGetCallState_CallId), &((structAddr)->CallId))


#define TSC_MsgGetCallState_Size		4

#define TSC_MsgGetCallState	0x120d	/* 4621 */
/* This message requests the current state of the call specified by CallId. 
 * The current state will be returned in the MsgGetCallStateCmplt response. 
 * Call states are listed in the table in section 13.2. CallId Identifies the 
 * call to obtain the state of. */

#define TSC_MsgGetCallStateCmplt_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetCallStateCmplt_CallId_t;

#define TSC_MsgGetCallStateCmplt_CallState	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgGetCallStateCmplt_CallState_t;

#define TSC_MsgGetCallStateCmplt_Reason	0x380008	/* 3670024 */
typedef	UInt32	TSC_MsgGetCallStateCmplt_Reason_t;

/*
 * TSC_MsgGetCallStateCmplt (value = 0x120e) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	CallState;
	UInt32	Reason;
} TSC_MsgGetCallStateCmplt_t;

#define TSC_MsgGetCallStateCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_MsgGetCallStateCmplt_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetCallStateCmplt_CallState), &((structAddr)->CallState),	\
			(TSC_MsgGetCallStateCmplt_Reason), &((structAddr)->Reason))


#define TSC_MsgGetCallStateCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_MsgGetCallStateCmplt_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetCallStateCmplt_CallState), &((structAddr)->CallState),	\
			(TSC_MsgGetCallStateCmplt_Reason), &((structAddr)->Reason))


#define TSC_MsgGetCallStateCmplt_Size		12

#define TSC_MsgGetCallStateCmplt	0x120e	/* 4622 */
/* This is the response to the command MsgGetChanState. The chanState field 
 * contains the current call state. The possible values for call state are 
 * listed in the table in section 13.2). CallId Identifies call that call state 
 * belongs to. CallState Current Call state. Reason Reason for the transition 
 * to the current call state (if any). */
/* This message requests the current channel state. The current state will be 
 * returned in the MsgGetChanStateCmplt response. The possible channel states 
 * are listed in the table in section 13.4. */

/*
 * TSC_MsgGetChanState (value = 0x120f) is an input message
 * for component TSC.
 */

#define TSC_MsgGetChanState_Size		0

#define TSC_MsgGetChanState	0x120f	/* 4623 */

#define TSC_MsgGetChanStateCmplt_ChanState	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetChanStateCmplt_ChanState_t;

/*
 * TSC_MsgGetChanStateCmplt (value = 0x1210) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	ChanState;
} TSC_MsgGetChanStateCmplt_t;

#define TSC_MsgGetChanStateCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgGetChanStateCmplt_ChanState), &((structAddr)->ChanState))


#define TSC_MsgGetChanStateCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgGetChanStateCmplt_ChanState), &((structAddr)->ChanState))


#define TSC_MsgGetChanStateCmplt_Size		4

#define TSC_MsgGetChanStateCmplt	0x1210	/* 4624 */
/* This is the response to the command MsgGetChanState. The ChanState field 
 * contains the current channel state. The possible channel states are defined 
 * in section 13.4. ChanState Current channel state. */

#define TSC_MsgHoldCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgHoldCall_CallId_t;

#define TSC_MsgHoldCall_varStart	0x4

#define TSC_MsgHoldCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgHoldCall_KVSet_t;

/*
 * TSC_MsgHoldCall (value = 0x1211) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgHoldCall_t;

#define TSC_MsgHoldCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgHoldCall_CallId), &((structAddr)->CallId))


#define TSC_MsgHoldCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgHoldCall_CallId), &((structAddr)->CallId))


#define TSC_MsgHoldCall_Size		4

#define TSC_MsgHoldCall	0x1211	/* 4625 */
/* This message requests that the call identified by CallId be placed on hold. 
 * The client should ensure that the call is in the Active state prior to 
 * issuing this command (or in a Protocol defined state from which a transition 
 * to Hold is valid). CallId Identifies the call to put on hold. KVSet An 
 * optional Key-Value set specifying protocol-specific parameters for the 
 * operation. This field is a "place holder" for a KVSet structure. If no KVSet 
 * is appended to the message then leave this field out of the message.. This 
 * is only supported by the NetTSC component. */

#define TSC_MsgInitTransfer_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgInitTransfer_CallId_t;

#define TSC_MsgInitTransfer_DestAddr	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgInitTransfer_DestAddr_t[128];

#define TSC_MsgInitTransfer_OrigAddr	0x53f884	/* 5503108 */
typedef	Char	TSC_MsgInitTransfer_OrigAddr_t[128];

#define TSC_MsgInitTransfer_CallProgress_Disabled	0	/* 0 */

#define TSC_MsgInitTransfer_CallProgress_Enabled	0x1	/* 1 */

#define TSC_MsgInitTransfer_CallProgress	0x200104	/* 2097412 */
typedef	UInt8	TSC_MsgInitTransfer_CallProgress_t;

/*
 * TSC_MsgInitTransfer (value = 0x1212) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	Char	DestAddr[128];
	Char	OrigAddr[128];
	UInt8	CallProgress;
} TSC_MsgInitTransfer_t;

#define TSC_MsgInitTransfer_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_MsgInitTransfer_CallId), &((structAddr)->CallId),	\
			(TSC_MsgInitTransfer_DestAddr), &((structAddr)->DestAddr),	\
			(TSC_MsgInitTransfer_OrigAddr), &((structAddr)->OrigAddr),	\
			(TSC_MsgInitTransfer_CallProgress), &((structAddr)->CallProgress))


#define TSC_MsgInitTransfer_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_MsgInitTransfer_CallId), &((structAddr)->CallId),	\
			(TSC_MsgInitTransfer_DestAddr), &((structAddr)->DestAddr),	\
			(TSC_MsgInitTransfer_OrigAddr), &((structAddr)->OrigAddr),	\
			(TSC_MsgInitTransfer_CallProgress), &((structAddr)->CallProgress))


#define TSC_MsgInitTransfer_Size		261

#define TSC_MsgInitTransfer	0x1212	/* 4626 */
/* This command initiates a supervised transfer of the call specified by 
 * CallId to the destination specified by DestAddr. In a supervised transfer 
 * the originating party is connected to the destination address, and the call 
 * that is the object of the transfer (CallId) is put on hold. The originating 
 * party now has the choice of either completing or canceling the transfer 
 * operation (achieved respectively with MsgCompleteTransfer and 
 * MsgCancelTransfer). CallId Identifies the call to transfer. DestAddr The 
 * destination for the transfer. OrigAddr Address of the originator of the 
 * transfer. (This may be an optional parameter; refer to the Protocol 
 * Implementation notes). CallProgress Enables or disables call progress 
 * monitoring. If this is enabled then the progress of the consultation call is 
 * monitored using call analysis. */

#define TSC_MsgInitTransferCmplt_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgInitTransferCmplt_CallId_t;

/*
 * TSC_MsgInitTransferCmplt (value = 0x1213) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgInitTransferCmplt_t;

#define TSC_MsgInitTransferCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgInitTransferCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgInitTransferCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgInitTransferCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgInitTransferCmplt_Size		4

#define TSC_MsgInitTransferCmplt	0x1213	/* 4627 */
/* This is the response to MsgInitTransfer. The call that was the object of 
 * the supervised transfer operation is now on hold, and a consultation call 
 * has been initiated. The CallId argument is the identifier of the 
 * consultation call. The client now has the choice of either completing or 
 * canceling the transfer operation (achieved respectively with 
 * MsgCompleteTransfer and MsgCancelTransfer). CallId The consultation call 
 * identifier. */

#define TSC_MsgMakeCall_DestAddr	0x53f800	/* 5502976 */
typedef	Char	TSC_MsgMakeCall_DestAddr_t[128];

#define TSC_MsgMakeCall_OrigAddr	0x53f880	/* 5503104 */
typedef	Char	TSC_MsgMakeCall_OrigAddr_t[128];

#define TSC_MsgMakeCall_CallProgress_Disabled	0	/* 0 */

#define TSC_MsgMakeCall_CallProgress_Enabled	0x1	/* 1 */

#define TSC_MsgMakeCall_CallProgress_PreOnly	0x2	/* 2 */

#define TSC_MsgMakeCall_CallProgress_PostOnly	0x3	/* 3 */

#define TSC_MsgMakeCall_CallProgress	0x200100	/* 2097408 */
typedef	UInt8	TSC_MsgMakeCall_CallProgress_t;

#define TSC_MsgMakeCall_varStart	0x101

#define TSC_MsgMakeCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgMakeCall_KVSet_t;

/*
 * TSC_MsgMakeCall (value = 0x1214) is an input message
 * for component TSC.
 */


typedef struct {
	Char	DestAddr[128];
	Char	OrigAddr[128];
	UInt8	CallProgress;
} TSC_MsgMakeCall_t;

#define TSC_MsgMakeCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_MsgMakeCall_DestAddr), &((structAddr)->DestAddr),	\
			(TSC_MsgMakeCall_OrigAddr), &((structAddr)->OrigAddr),	\
			(TSC_MsgMakeCall_CallProgress), &((structAddr)->CallProgress))


#define TSC_MsgMakeCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_MsgMakeCall_DestAddr), &((structAddr)->DestAddr),	\
			(TSC_MsgMakeCall_OrigAddr), &((structAddr)->OrigAddr),	\
			(TSC_MsgMakeCall_CallProgress), &((structAddr)->CallProgress))


#define TSC_MsgMakeCall_Size		257

#define TSC_MsgMakeCall	0x1214	/* 4628 */
/* This message initiates a call to the specified destination address 
 * (DestAddr). A MsgMakeCallCmplt response will be sent in response to this 
 * message along with a Call ID to be used to track the call. DestAddr 
 * Destination address for the call. OrigAddr Address of the originator of the 
 * call. (This may be an optional parameter; refer to the Protocol 
 * Implementation notes). CallProgress Determines whether call progress is 
 * monitored prior to the call being completed (connected) (e.g. Busy, 
 * Ringback, and SIT tones) and post-connection call analysis is run once the 
 * call is connected (e.g. PVD and PAMD). Defaults to Disabled. KVSet An 
 * optional Key-Value set specifying protocol-specific parameters for the 
 * operation. This field is a "place holder" for a KVSet structure. If no KVSet 
 * is appended to the message then leave this field out of the message. */

#define TSC_MsgMakeCallCmplt_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgMakeCallCmplt_CallId_t;

/*
 * TSC_MsgMakeCallCmplt (value = 0x1215) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgMakeCallCmplt_t;

#define TSC_MsgMakeCallCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgMakeCallCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgMakeCallCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgMakeCallCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgMakeCallCmplt_Size		4

#define TSC_MsgMakeCallCmplt	0x1215	/* 4629 */
/* This message is the response to the command MsgMakeCall. It indicates the a 
 * call has been initiated and provides the identifier for the call (CallId). 
 * CallId Identifier of the call that has been initiated.. */

#define TSC_MsgParkCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgParkCall_CallId_t;

#define TSC_MsgParkCall_ParkAddr	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgParkCall_ParkAddr_t[128];

/*
 * TSC_MsgParkCall (value = 0x1216) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	Char	ParkAddr[128];
} TSC_MsgParkCall_t;

#define TSC_MsgParkCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgParkCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgParkCall_ParkAddr), &((structAddr)->ParkAddr))


#define TSC_MsgParkCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgParkCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgParkCall_ParkAddr), &((structAddr)->ParkAddr))


#define TSC_MsgParkCall_Size		132

#define TSC_MsgParkCall	0x1216	/* 4630 */
/* This command instructs the protocol to "park" the specified call (CallId) 
 * at the address specified (ParkAddr). The call identifier associated with the 
 * call must be released by the client. When the call is picked up 
 * (MsgPickupCall) from the park address, a new call identifier will be 
 * returned. CallId The call identifier to park. ParkAddr Address to park call 
 * at. If this is NULL then the default parking address will be used (if one 
 * exists). If no default address exists, or if the address is invalid, then 
 * ErrParmValue will be returned via the standard error message. */

#define TSC_MsgParkCallCmplt_ParkId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgParkCallCmplt_ParkId_t;

#define TSC_MsgParkCallCmplt_ParkAddr	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgParkCallCmplt_ParkAddr_t[128];

/*
 * TSC_MsgParkCallCmplt (value = 0x1217) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	ParkId;
	Char	ParkAddr[128];
} TSC_MsgParkCallCmplt_t;

#define TSC_MsgParkCallCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgParkCallCmplt_ParkId), &((structAddr)->ParkId),	\
			(TSC_MsgParkCallCmplt_ParkAddr), &((structAddr)->ParkAddr))


#define TSC_MsgParkCallCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgParkCallCmplt_ParkId), &((structAddr)->ParkId),	\
			(TSC_MsgParkCallCmplt_ParkAddr), &((structAddr)->ParkAddr))


#define TSC_MsgParkCallCmplt_Size		132

#define TSC_MsgParkCallCmplt	0x1217	/* 4631 */
/* This is the response to the command MsgParkCall. This message indicates 
 * that the call identifier has been successfully parked. ParkId The park 
 * identifier for the call (used when picking the call up from the park). Note 
 * that this is not a call identifier; The park identifier identifies which 
 * park the call is in at the park address. ParkAddr The address at which the 
 * call was parked (used when picking the call up from the park). */

#define TSC_MsgPickupCall_ParkId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgPickupCall_ParkId_t;

#define TSC_MsgPickupCall_ParkAddr	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgPickupCall_ParkAddr_t[128];

/*
 * TSC_MsgPickupCall (value = 0x1218) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	ParkId;
	Char	ParkAddr[128];
} TSC_MsgPickupCall_t;

#define TSC_MsgPickupCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgPickupCall_ParkId), &((structAddr)->ParkId),	\
			(TSC_MsgPickupCall_ParkAddr), &((structAddr)->ParkAddr))


#define TSC_MsgPickupCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgPickupCall_ParkId), &((structAddr)->ParkId),	\
			(TSC_MsgPickupCall_ParkAddr), &((structAddr)->ParkAddr))


#define TSC_MsgPickupCall_Size		132

#define TSC_MsgPickupCall	0x1218	/* 4632 */
/* This command instructs the protocol to "pick-up" the parked call (ParkId) 
 * from the specified park address (ParkAddr). ParkId Parking identifier of the 
 * call to pick up. This is a identifier returned in the MsgParkCallCmplt 
 * response when the call was parked. It identifies which park the call is in 
 * at the park address. ParkAddr Address to pick up call from. If this is NULL 
 * then the default parking address will be used (if one exists). If no default 
 * exists, or if the park address is invalid, then ErrParmValue will be 
 * returned via the standard error message. */

#define TSC_MsgPickupCallCmplt_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgPickupCallCmplt_CallId_t;

/*
 * TSC_MsgPickupCallCmplt (value = 0x1219) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgPickupCallCmplt_t;

#define TSC_MsgPickupCallCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgPickupCallCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgPickupCallCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgPickupCallCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgPickupCallCmplt_Size		4

#define TSC_MsgPickupCallCmplt	0x1219	/* 4633 */
/* This is the response to the command MsgPickupCall. It indicates that the 
 * call has been successfully picked up, and that the call has been assigned 
 * the call identifier CallId. CallId Call identifier generated for the call 
 * that was picked up. */

#define TSC_MsgReconnectCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgReconnectCall_CallId_t;

/*
 * TSC_MsgReconnectCall (value = 0x121a) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgReconnectCall_t;

#define TSC_MsgReconnectCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgReconnectCall_CallId), &((structAddr)->CallId))


#define TSC_MsgReconnectCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgReconnectCall_CallId), &((structAddr)->CallId))


#define TSC_MsgReconnectCall_Size		4

#define TSC_MsgReconnectCall	0x121a	/* 4634 */
/* This message retrieves the held call specified by CallId and makes it the 
 * active (Connected) call. If another call is currently active then it will be 
 * dropped. CallId Specifies the call to reconnect (retrieve). */

#define TSC_MsgRedirectCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRedirectCall_CallId_t;

#define TSC_MsgRedirectCall_DestAddr	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgRedirectCall_DestAddr_t[128];

/*
 * TSC_MsgRedirectCall (value = 0x121b) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	Char	DestAddr[128];
} TSC_MsgRedirectCall_t;

#define TSC_MsgRedirectCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgRedirectCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRedirectCall_DestAddr), &((structAddr)->DestAddr))


#define TSC_MsgRedirectCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgRedirectCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRedirectCall_DestAddr), &((structAddr)->DestAddr))


#define TSC_MsgRedirectCall_Size		132

#define TSC_MsgRedirectCall	0x121b	/* 4635 */
/* This message redirects an offered call (CallId) to the specified address 
 * (DestAddr). This command allows the client to redirect an incoming call 
 * after receiving call-related information such as ANI or DNIS. CallId 
 * Specifies the call to redirect. DestAddr The address to redirect the call 
 * to. */

#define TSC_MsgReleaseCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgReleaseCall_CallId_t;

#define TSC_MsgReleaseCall_Reason	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgReleaseCall_Reason_t;

/*
 * TSC_MsgReleaseCall (value = 0x121c) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Reason;
} TSC_MsgReleaseCall_t;

#define TSC_MsgReleaseCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgReleaseCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgReleaseCall_Reason), &((structAddr)->Reason))


#define TSC_MsgReleaseCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgReleaseCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgReleaseCall_Reason), &((structAddr)->Reason))


#define TSC_MsgReleaseCall_Size		8

#define TSC_MsgReleaseCall	0x121c	/* 4636 */
/* This command releases the call identifier CallId. Whenever the application 
 * no longer requires a call identifier (i.e. when the call has been terminated 
 * and the information associated with the call has been retrieved or is no 
 * longer needed), the call identifier must be released back to the TSC 
 * Component so that it, and the resources associated with it, can be re-used 
 * for another call. If necessary, this command will perform a Drop Call 
 * operation on the call. CallId The call identifier to release. Reason 
 * Indicates the reason that the call is being released. This field is used if 
 * the release operation results in the call being dropped and then released. 
 * Possible values are defined in Table 4. Call State Reasons, Section 13.3. */

#define TSC_MsgRejectCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRejectCall_CallId_t;

#define TSC_MsgRejectCall_Reason_Busy	0x2	/* 2 */

#define TSC_MsgRejectCall_Reason_Congestion	0x3	/* 3 */

#define TSC_MsgRejectCall_Reason_NumUnavailable	0x4	/* 4 */

#define TSC_MsgRejectCall_Reason_Operator	0x5	/* 5 */

#define TSC_MsgRejectCall_Reason_NumVacant	0x6	/* 6 */

#define TSC_MsgRejectCall_Reason	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgRejectCall_Reason_t;

#define TSC_MsgRejectCall_varStart	0x8

#define TSC_MsgRejectCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRejectCall_KVSet_t;

/*
 * TSC_MsgRejectCall (value = 0x121d) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Reason;
} TSC_MsgRejectCall_t;

#define TSC_MsgRejectCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgRejectCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRejectCall_Reason), &((structAddr)->Reason))


#define TSC_MsgRejectCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgRejectCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRejectCall_Reason), &((structAddr)->Reason))


#define TSC_MsgRejectCall_Size		8

#define TSC_MsgRejectCall	0x121d	/* 4637 */
/* This message requests that the call specified by CallId be rejected. This 
 * is only valid if the call is currently incoming and has not been answered. 
 * CallId Identifies the call to reject. reason The reason for the rejection 
 * (e.g.; busy, congestion, number unavailable, etc.). KVSet An optional 
 * Key-Value set specifying protocol-specific parameters for the operation. 
 * This field is a "place holder" for a KVSet structure. If no KVSet is 
 * appended to the message then leave this field out of the message.. This is 
 * only supported by the NetTSC component. */

#define TSC_MsgRetrieveCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRetrieveCall_CallId_t;

#define TSC_MsgRetrieveCall_ChannelId	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgRetrieveCall_ChannelId_t;

#define TSC_MsgRetrieveCall_varStart	0x8

#define TSC_MsgRetrieveCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRetrieveCall_KVSet_t;

/*
 * TSC_MsgRetrieveCall (value = 0x121e) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	ChannelId;
} TSC_MsgRetrieveCall_t;

#define TSC_MsgRetrieveCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgRetrieveCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRetrieveCall_ChannelId), &((structAddr)->ChannelId))


#define TSC_MsgRetrieveCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgRetrieveCall_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRetrieveCall_ChannelId), &((structAddr)->ChannelId))


#define TSC_MsgRetrieveCall_Size		8

#define TSC_MsgRetrieveCall	0x121e	/* 4638 */
/* This message retrieves the held call specified by CallId and makes it the 
 * active (Connected) call. If another call is currently active then it will be 
 * put on Hold. This command can be used to "alternate" between a call that is 
 * on hold, and an active call. CallId Specifies the call to retrieve. 
 * ChannelId Id of channel for retrieving the call (Optional). KVSet An 
 * optional Key-Value set specifying protocol-specific parameters for the 
 * operation. This field is a "place holder" for a KVSet structure. If no KVSet 
 * is appended to the message then leave this field out of the message.. This 
 * is only supported by the NetTSC component. */

#define TSC_MsgSetChanState_state_InService	0x100	/* 256 */

#define TSC_MsgSetChanState_state_OutOfService	0x101	/* 257 */

#define TSC_MsgSetChanState_state_FinishCalls	0x102	/* 258 */

#define TSC_MsgSetChanState_state_InService_NoMaintMsg	0x103	/* 259 */

#define TSC_MsgSetChanState_state_OutOfService_NoMaintMsg	0x104	/* 260 */

#define TSC_MsgSetChanState_state_FinishCalls_NoMaintMsg	0x105	/* 261 */

#define TSC_MsgSetChanState_state	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetChanState_state_t;

/*
 * TSC_MsgSetChanState (value = 0x121f) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	state;
} TSC_MsgSetChanState_t;

#define TSC_MsgSetChanState_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgSetChanState_state), &((structAddr)->state))


#define TSC_MsgSetChanState_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgSetChanState_state), &((structAddr)->state))


#define TSC_MsgSetChanState_Size		4

#define TSC_MsgSetChanState	0x121f	/* 4639 */
/* This message sets the Channel state. This is used to take a channel into or 
 * out of service. state The state to set the channel to. Valid values are 
 * TSC_MsgSetChanState_State_InService, TSC_MsgSetChanState_State_OutOfService, 
 * TSC_MsgSetChanState_State_FinishCalls, 
 * TSC_MsgSetChanState_State_InService_NoMaintMsg, 
 * TSC_MsgSetChanState_State_OutOfService_NoMaintMsg, 
 * TSC_MsgSetChanState_State_FinishCalls_NoMaintMsg. */
/* This is the response to the command MsgSetChanState. This message indicates 
 * that the channel state has been successfully set. */

/*
 * TSC_MsgSetChanStateCmplt (value = 0x1220) is an output message
 * for component TSC.
 */

#define TSC_MsgSetChanStateCmplt_Size		0

#define TSC_MsgSetChanStateCmplt	0x1220	/* 4640 */
/* This message asks the protocol to wait for an incoming call. It has the 
 * effect of enabling the generation of an EvtCallState event to the client, 
 * for the next call that is Offered, and then disabling it once the event has 
 * been generated. */

/*
 * TSC_MsgWaitCall (value = 0x1221) is an input message
 * for component TSC.
 */

#define TSC_MsgWaitCall_Size		0

#define TSC_MsgWaitCall	0x1221	/* 4641 */

#define TSC_EvtCallInfo_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtCallInfo_Label_t;

#define TSC_EvtCallInfo_Type_BearerChanId	0x1200	/* 4608 */

#define TSC_EvtCallInfo_Type_CalledId	0x1201	/* 4609 */

#define TSC_EvtCallInfo_Type_CalledIdType	0x1202	/* 4610 */

#define TSC_EvtCallInfo_Type_CalledIdCategory	0x1203	/* 4611 */

#define TSC_EvtCallInfo_Type_CalledSubId	0x1204	/* 4612 */

#define TSC_EvtCallInfo_Type_CalledSubIdType	0x1205	/* 4613 */

#define TSC_EvtCallInfo_Type_CallerId	0x1206	/* 4614 */

#define TSC_EvtCallInfo_Type_CallerIdType	0x1207	/* 4615 */

#define TSC_EvtCallInfo_Type_CallerIdCategory	0x1208	/* 4616 */

#define TSC_EvtCallInfo_Type_CallerSubId	0x1209	/* 4617 */

#define TSC_EvtCallInfo_Type_CallerSubIdType	0x120a	/* 4618 */

#define TSC_EvtCallInfo_Type_Charge	0x120b	/* 4619 */

#define TSC_EvtCallInfo_Type_ChargeType	0x120c	/* 4620 */

#define TSC_EvtCallInfo_Type_Display	0x120d	/* 4621 */

#define TSC_EvtCallInfo_Type_Language	0x120e	/* 4622 */

#define TSC_EvtCallInfo_Type_LineId	0x120f	/* 4623 */

#define TSC_EvtCallInfo_Type_Origin	0x1210	/* 4624 */

#define TSC_EvtCallInfo_Type_Rate	0x1211	/* 4625 */

#define TSC_EvtCallInfo_Type_Reason	0x1212	/* 4626 */

#define TSC_EvtCallInfo_Type_RedirectedId	0x1213	/* 4627 */

#define TSC_EvtCallInfo_Type_RedirectedIdType	0x1214	/* 4628 */

#define TSC_EvtCallInfo_Type_RedirectingId	0x1215	/* 4629 */

#define TSC_EvtCallInfo_Type_RedirectingIdType	0x1216	/* 4630 */

#define TSC_EvtCallInfo_Type_CallAnalysis	0x1217	/* 4631 */

#define TSC_EvtCallInfo_Type_InfoTransferCap	0x1218	/* 4632 */

#define TSC_EvtCallInfo_Type_InfoTransferRate	0x1219	/* 4633 */

#define TSC_EvtCallInfo_Type_Layer1Protocol	0x121a	/* 4634 */

#define TSC_EvtCallInfo_Type_CallerName	0x1220	/* 4640 */

#define TSC_EvtCallInfo_Type_DateTime	0x1221	/* 4641 */

#define TSC_EvtCallInfo_Type_CallerNumberAbsenceReason	0x1222	/* 4642 */

#define TSC_EvtCallInfo_Type_CallerNameAbsenceReason	0x1223	/* 4643 */

#define TSC_EvtCallInfo_Type_PublicMsg	0x1224	/* 4644 */

#define TSC_EvtCallInfo_Type_VisualIndicator	0x1225	/* 4645 */

#define TSC_EvtCallInfo_Type_CallQualifier	0x1226	/* 4646 */

#define TSC_EvtCallInfo_Type_RedirectReason	0x1227	/* 4647 */

#define TSC_EvtCallInfo_Type_CallerIdExtended	0x1228	/* 4648 */

#define TSC_EvtCallInfo_Type_DDId	0x1229	/* 4649 */

#define TSC_EvtCallInfo_Type_DDIdExtended	0x122a	/* 4650 */

#define TSC_EvtCallInfo_Type_OriginalCallerId	0x122b	/* 4651 */

#define TSC_EvtCallInfo_Type_OriginalCallerIdExtended	0x122c	/* 4652 */

#define TSC_EvtCallInfo_Type_Detected_SigId	0x122d	/* 4653 */

#define TSC_EvtCallInfo_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtCallInfo_Type_t;

#define TSC_EvtCallInfo_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtCallInfo_Timestamp_t;

#define TSC_EvtCallInfo_CallId	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtCallInfo_CallId_t;

#define TSC_EvtCallInfo_InfoId	0x380010	/* 3670032 */
typedef	UInt32	TSC_EvtCallInfo_InfoId_t;

#define TSC_EvtCallInfo_varStart	0x14

#define TSC_EvtCallInfo_Value	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtCallInfo_Value_t;

#define TSC_EvtCallInfo_ValueStr	0x53f800	/* 5502976 */
typedef	Char	TSC_EvtCallInfo_ValueStr_t[128];

/*
 * TSC_EvtCallInfo (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	CallId;
	UInt32	InfoId;
} TSC_EvtCallInfo_t;

#define TSC_EvtCallInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(TSC_EvtCallInfo_Label), &((structAddr)->Label),	\
			(TSC_EvtCallInfo_Type), &((structAddr)->Type),	\
			(TSC_EvtCallInfo_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtCallInfo_CallId), &((structAddr)->CallId),	\
			(TSC_EvtCallInfo_InfoId), &((structAddr)->InfoId))


#define TSC_EvtCallInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(TSC_EvtCallInfo_Label), &((structAddr)->Label),	\
			(TSC_EvtCallInfo_Type), &((structAddr)->Type),	\
			(TSC_EvtCallInfo_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtCallInfo_CallId), &((structAddr)->CallId),	\
			(TSC_EvtCallInfo_InfoId), &((structAddr)->InfoId))


#define TSC_EvtCallInfo_Size		20
/* This is an asynchronous event that delivers call-related information to the 
 * client as the information becomes available. The body of the message 
 * consists of the information identifier, the information type, and a variable 
 * body that contains the information. The InfoId field identifies the specific 
 * call information, and also defines the type of data contained in the 
 * variable body of the message and hence the field name that should be used to 
 * access that data (i.e.; InfoType is one of value16, value32, or digitStr). 
 * Label The RTC label specified when this event type was enabled for 
 * detection. Type The RTC event type. Timestamp The board-level time at which 
 * the event was generated. Units of 1 msecs. CallId Identifies the call that 
 * the information is associated with. InfoId Identifies information that has 
 * been returned. Value A 32 bit unsigned integer value. ValueStr A character 
 * string used to return digit string information such as ANI, DTMF, and DNIS. */

#define TSC_EvtCallInfoSet_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtCallInfoSet_Label_t;

#define TSC_EvtCallInfoSet_Type_CallInfoSet	0x121b	/* 4635 */

#define TSC_EvtCallInfoSet_Type_IESet	0x121c	/* 4636 */

#define TSC_EvtCallInfoSet_Type_ISDNMsgSet	0x121d	/* 4637 */

#define TSC_EvtCallInfoSet_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtCallInfoSet_Type_t;

#define TSC_EvtCallInfoSet_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtCallInfoSet_Timestamp_t;

#define TSC_EvtCallInfoSet_CallId	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtCallInfoSet_CallId_t;

#define TSC_EvtCallInfoSet_Count	0x380010	/* 3670032 */
typedef	UInt32	TSC_EvtCallInfoSet_Count_t;

#define TSC_EvtCallInfoSet_varStart	0x14

#define TSC_EvtCallInfoSet_CallInfo	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtCallInfoSet_CallInfo_t;

#define TSC_EvtCallInfoSet_MessageType	0x200000	/* 2097152 */
typedef	UInt8	TSC_EvtCallInfoSet_MessageType_t;

#define TSC_EvtCallInfoSet_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_EvtCallInfoSet_Data_t;

/*
 * TSC_EvtCallInfoSet (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	CallId;
	UInt32	Count;
} TSC_EvtCallInfoSet_t;

#define TSC_EvtCallInfoSet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(TSC_EvtCallInfoSet_Label), &((structAddr)->Label),	\
			(TSC_EvtCallInfoSet_Type), &((structAddr)->Type),	\
			(TSC_EvtCallInfoSet_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtCallInfoSet_CallId), &((structAddr)->CallId),	\
			(TSC_EvtCallInfoSet_Count), &((structAddr)->Count))


#define TSC_EvtCallInfoSet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(TSC_EvtCallInfoSet_Label), &((structAddr)->Label),	\
			(TSC_EvtCallInfoSet_Type), &((structAddr)->Type),	\
			(TSC_EvtCallInfoSet_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtCallInfoSet_CallId), &((structAddr)->CallId),	\
			(TSC_EvtCallInfoSet_Count), &((structAddr)->Count))


#define TSC_EvtCallInfoSet_Size		20
/* This is a message body template for the Std_MsgEvtDetect message. This 
 * template extends the Std_MsgEvtDetected message body to support sets of 
 * information such as call information, ISDN message, and ISDN Information 
 * Elements. TSC_EvtCallInfoSet an asynchronous event that is used to deliver a 
 * number of different types of call-related information sets to the client. 
 * The types of sets are: CallInfoSet The event body consists of a list of one 
 * or more call information elements. Each element is a TSC_CallInfo structure 
 * that contains the call information identifier, the information size, and the 
 * information value in a variable length Uint8 array. Note that this event 
 * will only be generated once every member of the set is available. IESet The 
 * body of the event message is the MessageType field followed by a list of one 
 * or more ISDN information elements in Q.931 format. The list is in numerical 
 * order based on the IE identifier, and an information element may be present 
 * multiple times in the list. The MessageType field specifies the Q.931 
 * message in which the Information Elements were received. ISDNMsgSet The body 
 * of the event message is the MessageType field followed by all of the Q.931 
 * ISDN Information Elements received in the message. Field definitions: Label 
 * The RTC label specified when this event type was enabled for detection (via 
 * Std_MsgDetectEvt using a TSC_MsgDetectEvtSet message body). Type The RTC 
 * event type. Possible values are: TSC_EvtCallInfoSet_Type_CallInfoSet, 
 * TSC_EvtCallInfoSet_Type_IESet, or TSC_EvtCallInfoSet_Type_ISDNMsgSet. 
 * Timestamp The board-level time at which the event was generated. Units of 1 
 * msecs. CallId Identifies the call that the information is associated with. 
 * Count The number of items in the variable section of the message (i.e. the 
 * number of elements in variable length list). CallInfo Filler field. This is 
 * replaced with a list of one or more TSC_CallInfo structures, TSC_IE 
 * structures, or Q.931 ISDN messages as raw Uin8 data arrays. MessageType Only 
 * present for TSC_EvtCallInfoSet_Type_IESet and 
 * TSC_EvtCallInfoSet_Type_ISDNMsg events. This is the Q.931 ISDN Message Type 
 * that the IE's were extracted from. This field is the first field in the 
 * variable part of the message. The rest of the message is the list of 
 * Information Elements. Data Only present for TSC_EvtCallInfoSet_Type_IESet 
 * and TSC_EvtCallInfoSet_Type_ISDNMsg events. This represents the variable 
 * length Uint8 array which holds the information elements for the event. The 
 * CallInfo structure contains the information identifier, and the raw data 
 * that makes up that information. The CallInfo Data section may be a simple 
 * type (Uint8, Uint32, etc), or it may be a structure. The actual definition 
 * of this is dependant on the Call Information Identifier and specified in 
 * section 13.1. Id The Call Information Identifier. Uniquely identifies the 
 * information. Length The amount of data in the variable data section. This 
 * specifies the number of Uint8 data fields that carry the raw value for the 
 * call information. Data The value of the call information. This is a variable 
 * length array whose size is specified by the Length field. Note that the 
 * format of the data is determined from the Call Information Identifier by 
 * association (i.e. it is not encoded in the identifier). */

#define TSC_EvtCallState_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtCallState_Label_t;

#define TSC_EvtCallState_Type_Null	0x1230	/* 4656 */

#define TSC_EvtCallState_Type_Accepted	0x1231	/* 4657 */

#define TSC_EvtCallState_Type_Connected	0x1232	/* 4658 */

#define TSC_EvtCallState_Type_ConnectedPendXfer	0x1233	/* 4659 */

#define TSC_EvtCallState_Type_Delivered	0x1234	/* 4660 */

#define TSC_EvtCallState_Type_Dialing	0x1235	/* 4661 */

#define TSC_EvtCallState_Type_Disconnected	0x1236	/* 4662 */

#define TSC_EvtCallState_Type_DialReady	0x1237	/* 4663 */

#define TSC_EvtCallState_Type_Failed	0x1238	/* 4664 */

#define TSC_EvtCallState_Type_Idle	0x1239	/* 4665 */

#define TSC_EvtCallState_Type_Initiated	0x123a	/* 4666 */

#define TSC_EvtCallState_Type_Offered	0x123b	/* 4667 */

#define TSC_EvtCallState_Type_Hold	0x123c	/* 4668 */

#define TSC_EvtCallState_Type_OnHoldPendXfer	0x123d	/* 4669 */

#define TSC_EvtCallState_Type_Originated	0x123e	/* 4670 */

#define TSC_EvtCallState_Type_Proceeding	0x123f	/* 4671 */

#define TSC_EvtCallState_Type_Unknown	0x1240	/* 4672 */

#define TSC_EvtCallState_Type_Alerting	0x1241	/* 4673 */

#define TSC_EvtCallState_Type_IncomingProceeding	0x1242	/* 4674 */

#define TSC_EvtCallState_Type_Rejected	0x1243	/* 4675 */

#define TSC_EvtCallState_Type_Detected	0x1244	/* 4676 */

#define TSC_EvtCallState_Type_DialTone	0x1245	/* 4677 */

#define TSC_EvtCallState_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtCallState_Type_t;

#define TSC_EvtCallState_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtCallState_Timestamp_t;

#define TSC_EvtCallState_CallId	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtCallState_CallId_t;

#define TSC_EvtCallState_CallState	0x380010	/* 3670032 */
typedef	UInt32	TSC_EvtCallState_CallState_t;

#define TSC_EvtCallState_Reason	0x380014	/* 3670036 */
typedef	UInt32	TSC_EvtCallState_Reason_t;

/*
 * TSC_EvtCallState (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	CallId;
	UInt32	CallState;
	UInt32	Reason;
} TSC_EvtCallState_t;

#define TSC_EvtCallState_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(TSC_EvtCallState_Label), &((structAddr)->Label),	\
			(TSC_EvtCallState_Type), &((structAddr)->Type),	\
			(TSC_EvtCallState_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtCallState_CallId), &((structAddr)->CallId),	\
			(TSC_EvtCallState_CallState), &((structAddr)->CallState),	\
			(TSC_EvtCallState_Reason), &((structAddr)->Reason))


#define TSC_EvtCallState_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(TSC_EvtCallState_Label), &((structAddr)->Label),	\
			(TSC_EvtCallState_Type), &((structAddr)->Type),	\
			(TSC_EvtCallState_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtCallState_CallId), &((structAddr)->CallId),	\
			(TSC_EvtCallState_CallState), &((structAddr)->CallState),	\
			(TSC_EvtCallState_Reason), &((structAddr)->Reason))


#define TSC_EvtCallState_Size		24
/* This is an asynchronous event that indicates a change in call state. The 
 * CallState field contains the new call state. Call states are listed in the 
 * table in section 13.1). Label The RTC label specified when this event type 
 * was enabled for detection. Type The RTC event type. Timestamp The 
 * board-level time at which the event was generated. Units of 1 msecs. CallId 
 * Identifies the call on which the call state transition occurred. CallState 
 * New Call state (table in section 0). Reason The reason for the Call State 
 * transition (table in section 13.3). */

#define TSC_EvtChanState_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtChanState_Label_t;

#define TSC_EvtChanState_Type_Active	0x1260	/* 4704 */

#define TSC_EvtChanState_Type_ActivePending	0x1261	/* 4705 */

#define TSC_EvtChanState_Type_Alarm	0x1262	/* 4706 */

#define TSC_EvtChanState_Type_OutOfService	0x1263	/* 4707 */

#define TSC_EvtChanState_Type_Maintenance	0x1264	/* 4708 */

#define TSC_EvtChanState_Type_OutOfServiceLocal	0x1265	/* 4709 */

#define TSC_EvtChanState_Type_MaintenanceLocal	0x1266	/* 4710 */

#define TSC_EvtChanState_Type_Idle	0x1267	/* 4711 */

#define TSC_EvtChanState_Type_IdlePending	0x1268	/* 4712 */

#define TSC_EvtChanState_Type_Null	0x1269	/* 4713 */

#define TSC_EvtChanState_Type_Unknown	0x126a	/* 4714 */

#define TSC_EvtChanState_Type_OutOfServiceMediaDetached	0x126c	/* 4716 */

#define TSC_EvtChanState_Type_OutOfServiceRemote	0x126d	/* 4717 */

#define TSC_EvtChanState_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtChanState_Type_t;

#define TSC_EvtChanState_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtChanState_Timestamp_t;

#define TSC_EvtChanState_ChanState	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtChanState_ChanState_t;

/*
 * TSC_EvtChanState (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	ChanState;
} TSC_EvtChanState_t;

#define TSC_EvtChanState_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_EvtChanState_Label), &((structAddr)->Label),	\
			(TSC_EvtChanState_Type), &((structAddr)->Type),	\
			(TSC_EvtChanState_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtChanState_ChanState), &((structAddr)->ChanState))


#define TSC_EvtChanState_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_EvtChanState_Label), &((structAddr)->Label),	\
			(TSC_EvtChanState_Type), &((structAddr)->Type),	\
			(TSC_EvtChanState_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtChanState_ChanState), &((structAddr)->ChanState))


#define TSC_EvtChanState_Size		16
/* This is an asynchronous event that indicates a change in the channel state. 
 * The ChanState field contains the new channel state. Channel states are 
 * listed in the table in section 13.4). Label The RTC label specified when 
 * this event type was enabled for detection. Type The RTC event type. 
 * Timestamp The board-level time at which the event was generated. Units of 1 
 * msecs. ChanState New Channel state. */

#define TSC_EvtTrace_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtTrace_Label_t;

#define TSC_EvtTrace_Type_CallControl	0x126b	/* 4715 */

#define TSC_EvtTrace_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtTrace_Type_t;

#define TSC_EvtTrace_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtTrace_Timestamp_t;

#define TSC_EvtTrace_MsgType	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtTrace_MsgType_t;

#define TSC_EvtTrace_varStart	0x10

#define TSC_EvtTrace_Body	0x200000	/* 2097152 */
typedef	UInt8	TSC_EvtTrace_Body_t;

/*
 * TSC_EvtTrace (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	MsgType;
} TSC_EvtTrace_t;

#define TSC_EvtTrace_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_EvtTrace_Label), &((structAddr)->Label),	\
			(TSC_EvtTrace_Type), &((structAddr)->Type),	\
			(TSC_EvtTrace_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtTrace_MsgType), &((structAddr)->MsgType))


#define TSC_EvtTrace_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_EvtTrace_Label), &((structAddr)->Label),	\
			(TSC_EvtTrace_Type), &((structAddr)->Type),	\
			(TSC_EvtTrace_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtTrace_MsgType), &((structAddr)->MsgType))


#define TSC_EvtTrace_Size		16
/* This is an asynchronous event that reports on a tracing condition. Label 
 * The RTC label specified when this event type was enabled for detection. Type 
 * The RTC event type. Timestamp The board-level time at which the event was 
 * generated. Units of 1 msecs. MsgType The message type that resulted in the 
 * event. Body A variable length body that contains the message the caused the 
 * trace event. */

#define TSC_MsgSendISDN_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSendISDN_CallId_t;

#define TSC_MsgSendISDN_MessageType	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgSendISDN_MessageType_t;

#define TSC_MsgSendISDN_DataLength	0x380008	/* 3670024 */
typedef	UInt32	TSC_MsgSendISDN_DataLength_t;

#define TSC_MsgSendISDN_varStart	0xc

#define TSC_MsgSendISDN_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgSendISDN_Data_t;

/*
 * TSC_MsgSendISDN (value = 0x1222) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	MessageType;
	UInt32	DataLength;
} TSC_MsgSendISDN_t;

#define TSC_MsgSendISDN_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_MsgSendISDN_CallId), &((structAddr)->CallId),	\
			(TSC_MsgSendISDN_MessageType), &((structAddr)->MessageType),	\
			(TSC_MsgSendISDN_DataLength), &((structAddr)->DataLength))


#define TSC_MsgSendISDN_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_MsgSendISDN_CallId), &((structAddr)->CallId),	\
			(TSC_MsgSendISDN_MessageType), &((structAddr)->MessageType),	\
			(TSC_MsgSendISDN_DataLength), &((structAddr)->DataLength))


#define TSC_MsgSendISDN_Size		12

#define TSC_MsgSendISDN	0x1222	/* 4642 */
/* This message sends an arbitrary call-associated Q.931 ISDN Message. The 
 * Q.931 header is built by the protocol from the MessageType and CallId. 
 * MessageType The Q.931 ISDN Message Type. This identifies the type of ISDN 
 * message to send. CallId Identifies the call to send the message with. This 
 * is translated into the appropriate Call Reference Number before the message 
 * is sent. DataLength Length of the uint8 Data array that follows. Data This 
 * field is a place holder. The variable body of the message consists of zero 
 * or more Q.931 format ISDN Information Elements in sequential order. These 
 * are used as the body of the ISDN message. */
/* This message is sent response to the command TSC_MsgSendISDN. It indicates 
 * that the TSC_MsgSendISDN has been successfully sent and that no errors 
 * occurred. */

/*
 * TSC_MsgSendISDNCmplt (value = 0x1223) is an output message
 * for component TSC.
 */

#define TSC_MsgSendISDNCmplt_Size		0

#define TSC_MsgSendISDNCmplt	0x1223	/* 4643 */

#define TSC_MsgDial_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDial_CallId_t;

#define TSC_MsgDial_DigitString	0x53f804	/* 5502980 */
typedef	Char	TSC_MsgDial_DigitString_t[128];

#define TSC_MsgDial_CallProgress_Disabled	0	/* 0 */

#define TSC_MsgDial_CallProgress_Enabled	0x1	/* 1 */

#define TSC_MsgDial_CallProgress	0x200084	/* 2097284 */
typedef	UInt8	TSC_MsgDial_CallProgress_t;

#define TSC_MsgDial_EndOfDigits_FALSE	0	/* 0 */

#define TSC_MsgDial_EndOfDigits_TRUE	0x1	/* 1 */

#define TSC_MsgDial_EndOfDigits_AUTO	0x2	/* 2 */

#define TSC_MsgDial_EndOfDigits	0x200085	/* 2097285 */
typedef	UInt8	TSC_MsgDial_EndOfDigits_t;

#define TSC_MsgDial_varStart	0x86

#define TSC_MsgDial_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDial_KVSet_t;

/*
 * TSC_MsgDial (value = 0x1224) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	Char	DigitString[128];
	UInt8	CallProgress;
	UInt8	EndOfDigits;
} TSC_MsgDial_t;

#define TSC_MsgDial_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_MsgDial_CallId), &((structAddr)->CallId),	\
			(TSC_MsgDial_DigitString), &((structAddr)->DigitString),	\
			(TSC_MsgDial_CallProgress), &((structAddr)->CallProgress),	\
			(TSC_MsgDial_EndOfDigits), &((structAddr)->EndOfDigits))


#define TSC_MsgDial_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_MsgDial_CallId), &((structAddr)->CallId),	\
			(TSC_MsgDial_DigitString), &((structAddr)->DigitString),	\
			(TSC_MsgDial_CallProgress), &((structAddr)->CallProgress),	\
			(TSC_MsgDial_EndOfDigits), &((structAddr)->EndOfDigits))


#define TSC_MsgDial_Size		134

#define TSC_MsgDial	0x1224	/* 4644 */
/* 
 * This message directs a TSC output a digit sequence.
 * Message Definition Item
 * Description 
 * CallId
 * Identifies the TSC Call Object.
 * DigitString
 * An ASCIIZ string of digit labels.
 * CallProgress
 * Determines whether call progress is monitored prior to the 
 * call being completed (connected) (e.g. Busy, Ringback, and 
 * SIT tones) and post-connection call analysis is run once the 
 * call is connected (e.g. PVD and PAMD). Defaults to 
 * Disabled.
 * EndOfDigits
 * Specifies if the far end should be notified that all digits have 
 * been sent.
 *  
 */

#define TSC_MsgDialCmplt_Reason_Normal	0	/* 0 */

#define TSC_MsgDialCmplt_Reason_UserStop	0x1	/* 1 */

#define TSC_MsgDialCmplt_Reason_Abnormal	0x2	/* 2 */

#define TSC_MsgDialCmplt_Reason	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDialCmplt_Reason_t;

/*
 * TSC_MsgDialCmplt (value = 0x1225) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	Reason;
} TSC_MsgDialCmplt_t;

#define TSC_MsgDialCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgDialCmplt_Reason), &((structAddr)->Reason))


#define TSC_MsgDialCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgDialCmplt_Reason), &((structAddr)->Reason))


#define TSC_MsgDialCmplt_Size		4

#define TSC_MsgDialCmplt	0x1225	/* 4645 */
/* This is the response to the command MsgDial. It is sent when the TSC 
 * sequence being dialed completes or is terminated by a MsgDialStop command. 
 * Message Definition Item Description Reason Reason dialing stopped Normal, or 
 * UserStop */

#define TSC_MsgDialStop_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgDialStop_CallId_t;

/*
 * TSC_MsgDialStop (value = 0x1226) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgDialStop_t;

#define TSC_MsgDialStop_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgDialStop_CallId), &((structAddr)->CallId))


#define TSC_MsgDialStop_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgDialStop_CallId), &((structAddr)->CallId))


#define TSC_MsgDialStop_Size		4

#define TSC_MsgDialStop	0x1226	/* 4646 */
/* 
 * This message directs a TSC stop any currently active dial operation.
 * Message Definition Item
 * Description 
 * CallId
 * Identifies the TSC Call Object.
 *  
 */

#define TSC_MsgModuleRegister_MemSize	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleRegister_MemSize_t;

#define TSC_MsgModuleRegister_ModuleName	0x518804	/* 5343236 */
typedef	Char	TSC_MsgModuleRegister_ModuleName_t[50];

/*
 * TSC_MsgModuleRegister (value = 0x1227) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	MemSize;
	Char	ModuleName[50];
} TSC_MsgModuleRegister_t;

#define TSC_MsgModuleRegister_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgModuleRegister_MemSize), &((structAddr)->MemSize),	\
			(TSC_MsgModuleRegister_ModuleName), &((structAddr)->ModuleName))


#define TSC_MsgModuleRegister_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgModuleRegister_MemSize), &((structAddr)->MemSize),	\
			(TSC_MsgModuleRegister_ModuleName), &((structAddr)->ModuleName))


#define TSC_MsgModuleRegister_Size		54

#define TSC_MsgModuleRegister	0x1227	/* 4647 */
/* This message registers a hotload module with the module manager, assigns a 
 * module identifier, and allocates memory for the module on board. The 
 * TSC_MsgModuleRegister complete returns the module Identifier and the start 
 * of the memory block for the module. Message Definition Item Description 
 * MemSize The size of the module in bytes (octets). ModuleName The filename of 
 * the module. */

#define TSC_MsgModuleRegisterCmplt_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleRegisterCmplt_Id_t;

#define TSC_MsgModuleRegisterCmplt_LocateAddress	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgModuleRegisterCmplt_LocateAddress_t;

/*
 * TSC_MsgModuleRegisterCmplt (value = 0x1228) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	Id;
	UInt32	LocateAddress;
} TSC_MsgModuleRegisterCmplt_t;

#define TSC_MsgModuleRegisterCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgModuleRegisterCmplt_Id), &((structAddr)->Id),	\
			(TSC_MsgModuleRegisterCmplt_LocateAddress), &((structAddr)->LocateAddress))


#define TSC_MsgModuleRegisterCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgModuleRegisterCmplt_Id), &((structAddr)->Id),	\
			(TSC_MsgModuleRegisterCmplt_LocateAddress), &((structAddr)->LocateAddress))


#define TSC_MsgModuleRegisterCmplt_Size		8

#define TSC_MsgModuleRegisterCmplt	0x1228	/* 4648 */
/* This is the response to MsgModuleRegister and indicates that the module was 
 * successfully registered. Message Definition Item Description Id The module 
 * identifier to use to load and unload this module. LocateAddress This is the 
 * absolute address to locate the module at prior to loading it. */

#define TSC_MsgModuleLoad_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleLoad_Id_t;

#define TSC_MsgModuleLoad_EntryPoint	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgModuleLoad_EntryPoint_t;

#define TSC_MsgModuleLoad_ExitPoint	0x380008	/* 3670024 */
typedef	UInt32	TSC_MsgModuleLoad_ExitPoint_t;

#define TSC_MsgModuleLoad_MemSize	0x38000c	/* 3670028 */
typedef	UInt32	TSC_MsgModuleLoad_MemSize_t;

#define TSC_MsgModuleLoad_varStart	0x10

#define TSC_MsgModuleLoad_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgModuleLoad_Data_t;

/*
 * TSC_MsgModuleLoad (value = 0x1229) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	Id;
	UInt32	EntryPoint;
	UInt32	ExitPoint;
	UInt32	MemSize;
} TSC_MsgModuleLoad_t;

#define TSC_MsgModuleLoad_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_MsgModuleLoad_Id), &((structAddr)->Id),	\
			(TSC_MsgModuleLoad_EntryPoint), &((structAddr)->EntryPoint),	\
			(TSC_MsgModuleLoad_ExitPoint), &((structAddr)->ExitPoint),	\
			(TSC_MsgModuleLoad_MemSize), &((structAddr)->MemSize))


#define TSC_MsgModuleLoad_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_MsgModuleLoad_Id), &((structAddr)->Id),	\
			(TSC_MsgModuleLoad_EntryPoint), &((structAddr)->EntryPoint),	\
			(TSC_MsgModuleLoad_ExitPoint), &((structAddr)->ExitPoint),	\
			(TSC_MsgModuleLoad_MemSize), &((structAddr)->MemSize))


#define TSC_MsgModuleLoad_Size		16

#define TSC_MsgModuleLoad	0x1229	/* 4649 */
/* This is used to load the module after it has been registered via 
 * MsgModuleRegister. Message Definition Item Description Id The module 
 * identifier to use to load and unload this module. EntryPoint The address of 
 * the entry function for this module. ExitPoint The address of the exit 
 * function for this module MemSize Size of the payload Data This is the module 
 * or portion of the module to be loaded */
/* This is used to indicate successful loading of a portion of data by 
 * MsgModuleLoad. */

/*
 * TSC_MsgModuleLoadCmplt (value = 0x122a) is an output message
 * for component TSC.
 */

#define TSC_MsgModuleLoadCmplt_Size		0

#define TSC_MsgModuleLoadCmplt	0x122a	/* 4650 */

#define TSC_MsgModuleUnload_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleUnload_Id_t;

/*
 * TSC_MsgModuleUnload (value = 0x122b) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	Id;
} TSC_MsgModuleUnload_t;

#define TSC_MsgModuleUnload_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgModuleUnload_Id), &((structAddr)->Id))


#define TSC_MsgModuleUnload_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgModuleUnload_Id), &((structAddr)->Id))


#define TSC_MsgModuleUnload_Size		4

#define TSC_MsgModuleUnload	0x122b	/* 4651 */
/* 
 * This is used to unload the module after it has been loaded via MsgModuleLoad.
 *  
 * Message Definition
 * Item Description 
 * Id
 * The module identifier to use to load and unload this module.
 * 
 * 
 * 
 */
/* This is the response to MsgModuleUnload and indicates that the module was 
 * successfully unloaded. */

/*
 * TSC_MsgModuleUnloadCmplt (value = 0x122c) is an output message
 * for component TSC.
 */

#define TSC_MsgModuleUnloadCmplt_Size		0

#define TSC_MsgModuleUnloadCmplt	0x122c	/* 4652 */

#define TSC_MsgProceedCall_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgProceedCall_CallId_t;

#define TSC_MsgProceedCall_varStart	0x4

#define TSC_MsgProceedCall_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgProceedCall_KVSet_t;

/*
 * TSC_MsgProceedCall (value = 0x122d) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgProceedCall_t;

#define TSC_MsgProceedCall_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgProceedCall_CallId), &((structAddr)->CallId))


#define TSC_MsgProceedCall_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgProceedCall_CallId), &((structAddr)->CallId))


#define TSC_MsgProceedCall_Size		4

#define TSC_MsgProceedCall	0x122d	/* 4653 */
/* This command informs the originating side that the destination party has 
 * been successfully identified by the remote Network side. If the call is not 
 * in the Offered state then the response to this command will be an error. If 
 * the call is in the Offered state, then the call state will transition to 
 * IncomingProceeding. CallId Identifier of the call to accept. This is the ID 
 * that was given to the Client when it was notified of the incoming (Offered) 
 * call. KVSet An optional Key-Value set specifying protocol-specific 
 * parameters for the operation. This field is a "place holder" for a KVSet 
 * structure. If no KVSet is appended to the message then leave this field out 
 * of the message. */

#define TSC_MsgRemotePing_TargetDesc	0x800000	/* 8388608 */
typedef	QCompDesc	TSC_MsgRemotePing_TargetDesc_t;

/*
 * TSC_MsgRemotePing (value = 0x122e) is an input message
 * for component TSC.
 */


typedef struct {
	QCompDesc	TargetDesc;
} TSC_MsgRemotePing_t;

#define TSC_MsgRemotePing_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgRemotePing_TargetDesc), &((structAddr)->TargetDesc))


#define TSC_MsgRemotePing_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgRemotePing_TargetDesc), &((structAddr)->TargetDesc))


#define TSC_MsgRemotePing_Size		6

#define TSC_MsgRemotePing	0x122e	/* 4654 */
/* This command will send a comtest message to the specified address and time 
 * the response. The time taken from sending the Std_MsgComtest and receiving 
 * the Std_MsgComtestCmplt is returned in the TSC_MsgRemotePingCmplt message. 
 * TargetDesc The Component or Instance to send the Std_MsgComtest to. */

#define TSC_MsgRemotePingCmplt_Time	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRemotePingCmplt_Time_t;

/*
 * TSC_MsgRemotePingCmplt (value = 0x122f) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	Time;
} TSC_MsgRemotePingCmplt_t;

#define TSC_MsgRemotePingCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgRemotePingCmplt_Time), &((structAddr)->Time))


#define TSC_MsgRemotePingCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgRemotePingCmplt_Time), &((structAddr)->Time))


#define TSC_MsgRemotePingCmplt_Size		4

#define TSC_MsgRemotePingCmplt	0x122f	/* 4655 */
/* This command will send a comtest message to the specified address and time 
 * the response. The time taken from sending the Std_MsgComtest and receiving 
 * the Std_MsgComtestCmplt is returned in the TSC_MsgRemotePingCmplt message. 
 * Time The time between sending the Std_MsgComtest and receiving the response. 
 * Units of milliseconds. */

#define TSC_MsgSetMWI_State_ON	0	/* 0 */

#define TSC_MsgSetMWI_State_OFF	0x1	/* 1 */

#define TSC_MsgSetMWI_State	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetMWI_State_t;

/*
 * TSC_MsgSetMWI (value = 0x1230) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	State;
} TSC_MsgSetMWI_t;

#define TSC_MsgSetMWI_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgSetMWI_State), &((structAddr)->State))


#define TSC_MsgSetMWI_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgSetMWI_State), &((structAddr)->State))


#define TSC_MsgSetMWI_Size		4

#define TSC_MsgSetMWI	0x1230	/* 4656 */
/* This command sends a channel message to turn on or off the MWI on a 
 * terminal set. This command is supported by Loop start office protocols. This 
 * message instructs the terminal to turn on or off the message waiting 
 * indicator on it. The LS_FXO message is sent using FSK format and hence the 
 * terminal needs to support the FSK data reception for this message to work. 
 * State State can be ON or OFF. */

#define TSC_MsgSetMWICmplt_Reason_Normal	0	/* 0 */

#define TSC_MsgSetMWICmplt_Reason_Abnormal	0x1	/* 1 */

#define TSC_MsgSetMWICmplt_Reason	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetMWICmplt_Reason_t;

/*
 * TSC_MsgSetMWICmplt (value = 0x1231) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	Reason;
} TSC_MsgSetMWICmplt_t;

#define TSC_MsgSetMWICmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgSetMWICmplt_Reason), &((structAddr)->Reason))


#define TSC_MsgSetMWICmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgSetMWICmplt_Reason), &((structAddr)->Reason))


#define TSC_MsgSetMWICmplt_Size		4

#define TSC_MsgSetMWICmplt	0x1231	/* 4657 */
/* The reply message to MsgSetMWI. The reason field holds the completion 
 * status of the command. Reason Reason can be Normal or Abnormal. */

#define TSC_MsgTraceGet_Type	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgTraceGet_Type_t;

/*
 * TSC_MsgTraceGet (value = 0x1232) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	Type;
} TSC_MsgTraceGet_t;

#define TSC_MsgTraceGet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgTraceGet_Type), &((structAddr)->Type))


#define TSC_MsgTraceGet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgTraceGet_Type), &((structAddr)->Type))


#define TSC_MsgTraceGet_Size		4

#define TSC_MsgTraceGet	0x1232	/* 4658 */
/* This command asks a TSC instance for the contents its circular trace 
 * buffer. There may be more than one type of trace buffer, and the Type field 
 * in the message specifies which buffer to retrieve. Type Type of TSC trace 
 * buffer to retrieve. */

#define TSC_MsgTraceGetCmplt_Type	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgTraceGetCmplt_Type_t;

#define TSC_MsgTraceGetCmplt_EventCount	0x280004	/* 2621444 */
typedef	UInt16	TSC_MsgTraceGetCmplt_EventCount_t;

#define TSC_MsgTraceGetCmplt_varStart	0x6

#define TSC_MsgTraceGetCmplt_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgTraceGetCmplt_Data_t;

/*
 * TSC_MsgTraceGetCmplt (value = 0x1233) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	Type;
	UInt16	EventCount;
} TSC_MsgTraceGetCmplt_t;

#define TSC_MsgTraceGetCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgTraceGetCmplt_Type), &((structAddr)->Type),	\
			(TSC_MsgTraceGetCmplt_EventCount), &((structAddr)->EventCount))


#define TSC_MsgTraceGetCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgTraceGetCmplt_Type), &((structAddr)->Type),	\
			(TSC_MsgTraceGetCmplt_EventCount), &((structAddr)->EventCount))


#define TSC_MsgTraceGetCmplt_Size		6

#define TSC_MsgTraceGetCmplt	0x1233	/* 4659 */
/* 
 * This is the response to TSC_MsgTraceGet.  The 
 * Type	Type of TSC trace buffer in the variable body
 * EventCount	Number of events in the trace buffer
 * Data	Variable length data containing the trace events
 */

#define TSC_EvtTraceBoard_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtTraceBoard_Label_t;

#define TSC_EvtTraceBoard_Type_CAS	0x1280	/* 4736 */

#define TSC_EvtTraceBoard_Type_CallControl	0x1281	/* 4737 */

#define TSC_EvtTraceBoard_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtTraceBoard_Type_t;

#define TSC_EvtTraceBoard_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtTraceBoard_Timestamp_t;

#define TSC_EvtTraceBoard_BufCount	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtTraceBoard_BufCount_t;

#define TSC_EvtTraceBoard_varStart	0x10

#define TSC_EvtTraceBoard_Body	0x200000	/* 2097152 */
typedef	UInt8	TSC_EvtTraceBoard_Body_t;

/*
 * TSC_EvtTraceBoard (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	BufCount;
} TSC_EvtTraceBoard_t;

#define TSC_EvtTraceBoard_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_EvtTraceBoard_Label), &((structAddr)->Label),	\
			(TSC_EvtTraceBoard_Type), &((structAddr)->Type),	\
			(TSC_EvtTraceBoard_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtTraceBoard_BufCount), &((structAddr)->BufCount))


#define TSC_EvtTraceBoard_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_EvtTraceBoard_Label), &((structAddr)->Label),	\
			(TSC_EvtTraceBoard_Type), &((structAddr)->Type),	\
			(TSC_EvtTraceBoard_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtTraceBoard_BufCount), &((structAddr)->BufCount))


#define TSC_EvtTraceBoard_Size		16
/* This is an asynchronous event that is generated whenever the board level 
 * trace buffer is filled. It is part of the low cost (CPU) trace mechanism in 
 * the TSP that provides always on tracing capabilities for all TSC channels. 
 * The board level trace buffer can hold approximately 100 instance trace 
 * buffers, depending on the type of instance trace buffer (CAS or 
 * CallControl). This event will be generated at most once every 10 seconds if 
 * the system is running a high performance call rate test (e.g. 6 second 
 * calls) across 120 channels. Label The RTC label specified when this event 
 * type was enabled for detection. Type The RTC event type. Timestamp The 
 * board-level time at which the event was generated. Units of 1 msecs. 
 * BufCount The number of instance trace buffers in the variable payload. Body 
 * A variable length payload that contains zero or more instance trace buffers. 
 * Each trace buffer has a TSC_EvtTraceHeader structure followed by the 
 * contents of the instances circular trace buffer. */

#define TSC_EvtTraceHeader_Instance	0x280000	/* 2621440 */
typedef	UInt16	TSC_EvtTraceHeader_Instance_t;

#define TSC_EvtTraceHeader_EventCount	0x280002	/* 2621442 */
typedef	UInt16	TSC_EvtTraceHeader_EventCount_t;

#define TSC_EvtTraceHeader_BufferSize	0x280004	/* 2621444 */
typedef	UInt16	TSC_EvtTraceHeader_BufferSize_t;


typedef struct {
	UInt16	Instance;
	UInt16	EventCount;
	UInt16	BufferSize;
} TSC_EvtTraceHeader_t;

#define TSC_EvtTraceHeader_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_EvtTraceHeader_Instance), &((structAddr)->Instance),	\
			(TSC_EvtTraceHeader_EventCount), &((structAddr)->EventCount),	\
			(TSC_EvtTraceHeader_BufferSize), &((structAddr)->BufferSize))


#define TSC_EvtTraceHeader_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_EvtTraceHeader_Instance), &((structAddr)->Instance),	\
			(TSC_EvtTraceHeader_EventCount), &((structAddr)->EventCount),	\
			(TSC_EvtTraceHeader_BufferSize), &((structAddr)->BufferSize))


#define TSC_EvtTraceHeader_Size		6

#define TSC_EvtTraceHeader	0x1200	/* 4608 */
/* Every trace buffer in the body of the message has a header that specifies 
 * the instance the trace is from, the number of events in the trace buffer, 
 * and the total number of bytes in the buffer. Instance The instance that the 
 * buffer belongs to. EventCount The number of trace events in the buffer. 
 * BufferSize The total size of the trace buffer in bytes. */

#define TSC_MsgAttach_Count	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgAttach_Count_t;

#define TSC_MsgAttach_varStart	0x1

#define TSC_MsgAttach_MediaInfo_ComponentType	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgAttach_MediaInfo_ComponentType_t;

#define TSC_MsgAttach_MediaInfo_InstDesc	0x800000	/* 8388608 */
typedef	QCompDesc	TSC_MsgAttach_MediaInfo_InstDesc_t;


typedef struct {
	UInt32	ComponentType;
	QCompDesc	InstDesc;
} TSC_MsgAttach_MediaInfo_t;

#define TSC_MsgAttach_MediaInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgAttach_MediaInfo_ComponentType), &((structAddr)->ComponentType),	\
			(TSC_MsgAttach_MediaInfo_InstDesc), &((structAddr)->InstDesc))


#define TSC_MsgAttach_MediaInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgAttach_MediaInfo_ComponentType), &((structAddr)->ComponentType),	\
			(TSC_MsgAttach_MediaInfo_InstDesc), &((structAddr)->InstDesc))


#define TSC_MsgAttach_MediaInfo_Size		10

#define TSC_MsgAttach_MediaInfo	0x1201	/* 4609 */

/*
 * TSC_MsgAttach (value = 0x1234) is an input message
 * for component TSC.
 */


typedef struct {
	UInt8	Count;
} TSC_MsgAttach_t;

#define TSC_MsgAttach_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgAttach_Count), &((structAddr)->Count))


#define TSC_MsgAttach_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgAttach_Count), &((structAddr)->Count))


#define TSC_MsgAttach_Size		1

#define TSC_MsgAttach	0x1234	/* 4660 */
/* The TSC_MsgAttach message is sent to a TSC/CHP Instance to enable a TSP TOC 
 * to attach the specified media instances it needs for performing call 
 * control. Media resources are expressed as tuples of ComponentType and 
 * InstDesc in List. Once a call is established, the attached media instances 
 * may be detached and re-used for establishing another call by attaching to 
 * another TSP TOC, for instance. Count - number of items in parameter list, 
 * maximum of 256 currently. MediaInfo - parameter list structure. 
 * ComponentType - Standard Component Types. (Eg. 5 for TGEN, 10 for CA etc.) 
 * InstDesc - Fully qualified media component instance descriptor from a free 
 * ROC cluster. */
/* The Tsc_MsgAttachCmplt message is sent as a response to the Tsc_MsgAttach 
 * command if the TOC Instance successfully attaches the media resource 
 * instances to its cluster. */

/*
 * TSC_MsgAttachCmplt (value = 0x1235) is an output message
 * for component TSC.
 */

#define TSC_MsgAttachCmplt_Size		0

#define TSC_MsgAttachCmplt	0x1235	/* 4661 */
/* The TSC_MsgDetach message is sent to a Instance to enable a TSC TOC to 
 * detach all media instances it no longer needs for performing call control. 
 * All media resources normally required for call control is detached together. */

/*
 * TSC_MsgDetach (value = 0x1236) is an input message
 * for component TSC.
 */

#define TSC_MsgDetach_Size		0

#define TSC_MsgDetach	0x1236	/* 4662 */
/* The Tsc_MsgDetachCmplt message is sent as a response to the Tsc_MsgDetach 
 * command if the TOC Instance successfully frees the media resource instances 
 * to which its cluster was attached. */

/*
 * TSC_MsgDetachCmplt (value = 0x1237) is an output message
 * for component TSC.
 */

#define TSC_MsgDetachCmplt_Size		0

#define TSC_MsgDetachCmplt	0x1237	/* 4663 */

#define TSC_MsgModuleCheckStatus_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleCheckStatus_Id_t;

/*
 * TSC_MsgModuleCheckStatus (value = 0x1238) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	Id;
} TSC_MsgModuleCheckStatus_t;

#define TSC_MsgModuleCheckStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgModuleCheckStatus_Id), &((structAddr)->Id))


#define TSC_MsgModuleCheckStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgModuleCheckStatus_Id), &((structAddr)->Id))


#define TSC_MsgModuleCheckStatus_Size		4

#define TSC_MsgModuleCheckStatus	0x1238	/* 4664 */
/* This is the response to MsgModuleRegister and indicates that the module was 
 * successfully registered. Message Definition Item Description Id The module 
 * identifier to use to load and unload this module. */

#define TSC_MsgModuleCheckStatusCmplt_ModuleName	0x518800	/* 5343232 */
typedef	Char	TSC_MsgModuleCheckStatusCmplt_ModuleName_t[50];

#define TSC_MsgModuleCheckStatusCmplt_Id	0x380032	/* 3670066 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_Id_t;

#define TSC_MsgModuleCheckStatusCmplt_LocateAddress	0x380036	/* 3670070 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_LocateAddress_t;

#define TSC_MsgModuleCheckStatusCmplt_fillAddress	0x38003a	/* 3670074 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_fillAddress_t;

#define TSC_MsgModuleCheckStatusCmplt_EntryPoint	0x38003e	/* 3670078 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_EntryPoint_t;

#define TSC_MsgModuleCheckStatusCmplt_ExitPoint	0x380042	/* 3670082 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_ExitPoint_t;

#define TSC_MsgModuleCheckStatusCmplt_MemSize	0x380046	/* 3670086 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_MemSize_t;

#define TSC_MsgModuleCheckStatusCmplt_sizeLoaded	0x38004a	/* 3670090 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_sizeLoaded_t;

#define TSC_MsgModuleCheckStatusCmplt_state	0x38004e	/* 3670094 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_state_t;

#define TSC_MsgModuleCheckStatusCmplt_UseCount	0x380052	/* 3670098 */
typedef	UInt32	TSC_MsgModuleCheckStatusCmplt_UseCount_t;

/*
 * TSC_MsgModuleCheckStatusCmplt (value = 0x1239) is an output message
 * for component TSC.
 */


typedef struct {
	Char	ModuleName[50];
	UInt32	Id;
	UInt32	LocateAddress;
	UInt32	fillAddress;
	UInt32	EntryPoint;
	UInt32	ExitPoint;
	UInt32	MemSize;
	UInt32	sizeLoaded;
	UInt32	state;
	UInt32	UseCount;
} TSC_MsgModuleCheckStatusCmplt_t;

#define TSC_MsgModuleCheckStatusCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 10, &(offset),	\
			(TSC_MsgModuleCheckStatusCmplt_ModuleName), &((structAddr)->ModuleName),	\
			(TSC_MsgModuleCheckStatusCmplt_Id), &((structAddr)->Id),	\
			(TSC_MsgModuleCheckStatusCmplt_LocateAddress), &((structAddr)->LocateAddress),	\
			(TSC_MsgModuleCheckStatusCmplt_fillAddress), &((structAddr)->fillAddress),	\
			(TSC_MsgModuleCheckStatusCmplt_EntryPoint), &((structAddr)->EntryPoint),	\
			(TSC_MsgModuleCheckStatusCmplt_ExitPoint), &((structAddr)->ExitPoint),	\
			(TSC_MsgModuleCheckStatusCmplt_MemSize), &((structAddr)->MemSize),	\
			(TSC_MsgModuleCheckStatusCmplt_sizeLoaded), &((structAddr)->sizeLoaded),	\
			(TSC_MsgModuleCheckStatusCmplt_state), &((structAddr)->state),	\
			(TSC_MsgModuleCheckStatusCmplt_UseCount), &((structAddr)->UseCount))


#define TSC_MsgModuleCheckStatusCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 10, &(offset),	\
			(TSC_MsgModuleCheckStatusCmplt_ModuleName), &((structAddr)->ModuleName),	\
			(TSC_MsgModuleCheckStatusCmplt_Id), &((structAddr)->Id),	\
			(TSC_MsgModuleCheckStatusCmplt_LocateAddress), &((structAddr)->LocateAddress),	\
			(TSC_MsgModuleCheckStatusCmplt_fillAddress), &((structAddr)->fillAddress),	\
			(TSC_MsgModuleCheckStatusCmplt_EntryPoint), &((structAddr)->EntryPoint),	\
			(TSC_MsgModuleCheckStatusCmplt_ExitPoint), &((structAddr)->ExitPoint),	\
			(TSC_MsgModuleCheckStatusCmplt_MemSize), &((structAddr)->MemSize),	\
			(TSC_MsgModuleCheckStatusCmplt_sizeLoaded), &((structAddr)->sizeLoaded),	\
			(TSC_MsgModuleCheckStatusCmplt_state), &((structAddr)->state),	\
			(TSC_MsgModuleCheckStatusCmplt_UseCount), &((structAddr)->UseCount))


#define TSC_MsgModuleCheckStatusCmplt_Size		86

#define TSC_MsgModuleCheckStatusCmplt	0x1239	/* 4665 */
/* 
 * This is used to check the status of a module.
 *  
 * Message Definition
 * Item Description 
 * ModuleName
 * The filename of the module located at Id
 * Id
 * The module identifier to use to load and unload this module.
 * LocateAddress
 * The memory location where this module is located
 * fillAddress
 * Location to load module (used during loading)
 * EntryPoint
 * The address of the entry function for this module
 * ExitPoint
 * The address of the exit function for this module
 * MemSize
 * Size of the payload
 * sizeLoaded
 * How much of the module has been loaded
 * State
 * Current state of the module
 * Data
 * This is the module or portion of the module to be loaded
 * 
 */
/* This message determines how many modules are loaded and what the maximum 
 * number allowed is. */

/*
 * TSC_MsgModuleCheckCount (value = 0x123a) is an input message
 * for component TSC.
 */

#define TSC_MsgModuleCheckCount_Size		0

#define TSC_MsgModuleCheckCount	0x123a	/* 4666 */

#define TSC_MsgModuleCheckCountCmplt_RegisterCount	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleCheckCountCmplt_RegisterCount_t;

#define TSC_MsgModuleCheckCountCmplt_MaxModules	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgModuleCheckCountCmplt_MaxModules_t;

/*
 * TSC_MsgModuleCheckCountCmplt (value = 0x123b) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	RegisterCount;
	UInt32	MaxModules;
} TSC_MsgModuleCheckCountCmplt_t;

#define TSC_MsgModuleCheckCountCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgModuleCheckCountCmplt_RegisterCount), &((structAddr)->RegisterCount),	\
			(TSC_MsgModuleCheckCountCmplt_MaxModules), &((structAddr)->MaxModules))


#define TSC_MsgModuleCheckCountCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgModuleCheckCountCmplt_RegisterCount), &((structAddr)->RegisterCount),	\
			(TSC_MsgModuleCheckCountCmplt_MaxModules), &((structAddr)->MaxModules))


#define TSC_MsgModuleCheckCountCmplt_Size		8

#define TSC_MsgModuleCheckCountCmplt	0x123b	/* 4667 */
/* 
 * This is the response to MsgModuleCheckCount.
 *  
 * Message Definition
 * Item Description 
 * RegisterCount
 * The number of modules registered
 * MaxModules
 * The maximum number of modules allowed.
 * 
 */

#define TSC_MsgModuleStart_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgModuleStart_Id_t;

/*
 * TSC_MsgModuleStart (value = 0x123c) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	Id;
} TSC_MsgModuleStart_t;

#define TSC_MsgModuleStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgModuleStart_Id), &((structAddr)->Id))


#define TSC_MsgModuleStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgModuleStart_Id), &((structAddr)->Id))


#define TSC_MsgModuleStart_Size		4

#define TSC_MsgModuleStart	0x123c	/* 4668 */
/* 
 * This is used to start the module after it has been loaded via MsgModuleLoad.
 *  
 * Message Definition
 * Item Description 
 * Id
 * The module identifier to use to load and unload this module.
 * 
 * 
 * 
 */
/* This is the response to MsgModuleStart and indicates that the module was 
 * successfully started. */

/*
 * TSC_MsgModuleStartCmplt (value = 0x123d) is an output message
 * for component TSC.
 */

#define TSC_MsgModuleStartCmplt_Size		0

#define TSC_MsgModuleStartCmplt	0x123d	/* 4669 */

#define TSC_MsgHoldCallAck_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgHoldCallAck_CallId_t;

#define TSC_MsgHoldCallAck_varStart	0x4

#define TSC_MsgHoldCallAck_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgHoldCallAck_KVSet_t;

/*
 * TSC_MsgHoldCallAck (value = 0x123e) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgHoldCallAck_t;

#define TSC_MsgHoldCallAck_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgHoldCallAck_CallId), &((structAddr)->CallId))


#define TSC_MsgHoldCallAck_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgHoldCallAck_CallId), &((structAddr)->CallId))


#define TSC_MsgHoldCallAck_Size		4

#define TSC_MsgHoldCallAck	0x123e	/* 4670 */
/* This message Acknowledges the request for putting the call specified by 
 * CallId to Hold. This message is sent in response to a hold request from the 
 * remote side. CallId Identifies the call to put on hold. KVSet An optional 
 * Key-Value set specifying protocol-specific parameters for the operation. 
 * This field is a "place holder" for a KVSet structure. If no KVSet is 
 * appended to the message then leave this field out of the message.. This is 
 * only supported by the NetTSC component. */

#define TSC_MsgHoldCallRej_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgHoldCallRej_CallId_t;

#define TSC_MsgHoldCallRej_Reason	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgHoldCallRej_Reason_t;

#define TSC_MsgHoldCallRej_varStart	0x8

#define TSC_MsgHoldCallRej_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgHoldCallRej_KVSet_t;

/*
 * TSC_MsgHoldCallRej (value = 0x123f) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Reason;
} TSC_MsgHoldCallRej_t;

#define TSC_MsgHoldCallRej_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgHoldCallRej_CallId), &((structAddr)->CallId),	\
			(TSC_MsgHoldCallRej_Reason), &((structAddr)->Reason))


#define TSC_MsgHoldCallRej_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgHoldCallRej_CallId), &((structAddr)->CallId),	\
			(TSC_MsgHoldCallRej_Reason), &((structAddr)->Reason))


#define TSC_MsgHoldCallRej_Size		8

#define TSC_MsgHoldCallRej	0x123f	/* 4671 */
/* This message Rejects the request for putting the call specified by CallId 
 * to Hold. This message is sent in response to a hold request from the remote 
 * side. CallId Identifies the call to put on hold. Reason Cause for rejection. 
 * KVSet An optional Key-Value set specifying protocol-specific parameters for 
 * the operation. This field is a "place holder" for a KVSet structure. If no 
 * KVSet is appended to the message then leave this field out of the message.. 
 * This is only supported by the NetTSC component. */

#define TSC_EvtFeatureReq_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtFeatureReq_Label_t;

#define TSC_EvtFeatureReq_Type_HoldIncoming	0x1270	/* 4720 */

#define TSC_EvtFeatureReq_Type_HoldRejected	0x1271	/* 4721 */

#define TSC_EvtFeatureReq_Type_HoldTimeOut	0x1272	/* 4722 */

#define TSC_EvtFeatureReq_Type_RetIncoming	0x1273	/* 4723 */

#define TSC_EvtFeatureReq_Type_RetRejected	0x1274	/* 4724 */

#define TSC_EvtFeatureReq_Type_RetTimeOut	0x1275	/* 4725 */

#define TSC_EvtFeatureReq_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtFeatureReq_Type_t;

#define TSC_EvtFeatureReq_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtFeatureReq_Timestamp_t;

#define TSC_EvtFeatureReq_CallId	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtFeatureReq_CallId_t;

#define TSC_EvtFeatureReq_EvtValue	0x380010	/* 3670032 */
typedef	UInt32	TSC_EvtFeatureReq_EvtValue_t;

#define TSC_EvtFeatureReq_Reason	0x380014	/* 3670036 */
typedef	UInt32	TSC_EvtFeatureReq_Reason_t;

/*
 * TSC_EvtFeatureReq (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	CallId;
	UInt32	EvtValue;
	UInt32	Reason;
} TSC_EvtFeatureReq_t;

#define TSC_EvtFeatureReq_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(TSC_EvtFeatureReq_Label), &((structAddr)->Label),	\
			(TSC_EvtFeatureReq_Type), &((structAddr)->Type),	\
			(TSC_EvtFeatureReq_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtFeatureReq_CallId), &((structAddr)->CallId),	\
			(TSC_EvtFeatureReq_EvtValue), &((structAddr)->EvtValue),	\
			(TSC_EvtFeatureReq_Reason), &((structAddr)->Reason))


#define TSC_EvtFeatureReq_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(TSC_EvtFeatureReq_Label), &((structAddr)->Label),	\
			(TSC_EvtFeatureReq_Type), &((structAddr)->Type),	\
			(TSC_EvtFeatureReq_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtFeatureReq_CallId), &((structAddr)->CallId),	\
			(TSC_EvtFeatureReq_EvtValue), &((structAddr)->EvtValue),	\
			(TSC_EvtFeatureReq_Reason), &((structAddr)->Reason))


#define TSC_EvtFeatureReq_Size		24
/* This is an asynchronous event that indicates the remote side's response or 
 * request for a specific (supplementary) feature. Label The RTC label 
 * specified when this event type was enabled for detection. Type The RTC event 
 * type. Timestamp The board-level time at which the event was generated. Units 
 * of 1 msecs. CallId Identifies the call for which this event is applicable. 
 * EvtValue Value for this Event Type. Reason The reason for this event 
 * generation. (table in section 13.3). */

#define TSC_MsgSetupAck_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetupAck_CallId_t;

#define TSC_MsgSetupAck_varStart	0x4

#define TSC_MsgSetupAck_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetupAck_KVSet_t;

/*
 * TSC_MsgSetupAck (value = 0x1240) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgSetupAck_t;

#define TSC_MsgSetupAck_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgSetupAck_CallId), &((structAddr)->CallId))


#define TSC_MsgSetupAck_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgSetupAck_CallId), &((structAddr)->CallId))


#define TSC_MsgSetupAck_Size		4

#define TSC_MsgSetupAck	0x1240	/* 4672 */
/* This command message acknowledges the specified call (CallId). If the call 
 * is not in the OFFERED state with the appropriate feature bitmask bit 
 * enabled, then the response to this command will be an error. If the call is 
 * in the OFFERED state with the appropriate feature bitmask bit enabled, then 
 * the call will respond with the appropriate setup acknowledgement to the 
 * network, and wait for more call information. CallId Identifier of the call 
 * to accept. This is the ID that was given to the Client when it was notified 
 * of the incoming OFFERED call. KVSet An optional Key-Value set specifying 
 * protocol-specific parameters for the operation. This field is a "place 
 * holder" for a KVSet structure. If no KVSet is appended to the message then 
 * leave this field out of the message. */

#define TSC_MsgGetMoreDigits_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGetMoreDigits_CallId_t;

#define TSC_MsgGetMoreDigits_NumberOfDigits	0x200004	/* 2097156 */
typedef	UInt8	TSC_MsgGetMoreDigits_NumberOfDigits_t;

#define TSC_MsgGetMoreDigits_LastRequest_FALSE	0	/* 0 */

#define TSC_MsgGetMoreDigits_LastRequest_TRUE	0x1	/* 1 */

#define TSC_MsgGetMoreDigits_LastRequest	0x200005	/* 2097157 */
typedef	UInt8	TSC_MsgGetMoreDigits_LastRequest_t;

/*
 * TSC_MsgGetMoreDigits (value = 0x1241) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt8	NumberOfDigits;
	UInt8	LastRequest;
} TSC_MsgGetMoreDigits_t;

#define TSC_MsgGetMoreDigits_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_MsgGetMoreDigits_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetMoreDigits_NumberOfDigits), &((structAddr)->NumberOfDigits),	\
			(TSC_MsgGetMoreDigits_LastRequest), &((structAddr)->LastRequest))


#define TSC_MsgGetMoreDigits_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_MsgGetMoreDigits_CallId), &((structAddr)->CallId),	\
			(TSC_MsgGetMoreDigits_NumberOfDigits), &((structAddr)->NumberOfDigits),	\
			(TSC_MsgGetMoreDigits_LastRequest), &((structAddr)->LastRequest))


#define TSC_MsgGetMoreDigits_Size		6

#define TSC_MsgGetMoreDigits	0x1241	/* 4673 */
/* This message directs a TSC to request more call information from the 
 * telephony network. Message Definition Item Description CallId Identifies the 
 * TSC Call Object. NumberOfDigits Determines the number of digits to request. 
 * If 0, all remaining digits will be requested. Otherwise, the specified 
 * number of fixed digits will be requested. Last Request The identifier used 
 * to signify whether any subsequent requests will be made. If TRUE, no more 
 * digits will be requested. Otherwise, subsequent requests could be made. */

#define TSC_MsgSetAlarmMask_Linenum	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgSetAlarmMask_Linenum_t;

#define TSC_MsgSetAlarmMask_Alarm_mask	0x380001	/* 3670017 */
typedef	UInt32	TSC_MsgSetAlarmMask_Alarm_mask_t;

/*
 * TSC_MsgSetAlarmMask (value = 0x1242) is an input message
 * for component TSC.
 */


typedef struct {
	UInt8	Linenum;
	UInt32	Alarm_mask;
} TSC_MsgSetAlarmMask_t;

#define TSC_MsgSetAlarmMask_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgSetAlarmMask_Linenum), &((structAddr)->Linenum),	\
			(TSC_MsgSetAlarmMask_Alarm_mask), &((structAddr)->Alarm_mask))


#define TSC_MsgSetAlarmMask_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgSetAlarmMask_Linenum), &((structAddr)->Linenum),	\
			(TSC_MsgSetAlarmMask_Alarm_mask), &((structAddr)->Alarm_mask))


#define TSC_MsgSetAlarmMask_Size		5

#define TSC_MsgSetAlarmMask	0x1242	/* 4674 */
/* The TSC_MsgSetAlarmMask message is sent to the TSC component to enable 
 * blocking alarms for a particular trunk. Linenum - trunk number, maximum of 
 * 16 currently. Alarm_mask - Mask specifying blocking alarms for trunk. */
/* The Tsc_MsgSetAlarmMaskCmplt message is sent as a response to the 
 * Tsc_MsgSetAlarmMask command if the TSC successfully updates the alarm mask 
 * for the trunk number in its internal alarm mask array. */

/*
 * TSC_MsgSetAlarmMaskCmplt (value = 0x1243) is an output message
 * for component TSC.
 */

#define TSC_MsgSetAlarmMaskCmplt_Size		0

#define TSC_MsgSetAlarmMaskCmplt	0x1243	/* 4675 */

#define TSC_MsgGetAlarmMask_Linenum	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgGetAlarmMask_Linenum_t;

/*
 * TSC_MsgGetAlarmMask (value = 0x1244) is an input message
 * for component TSC.
 */


typedef struct {
	UInt8	Linenum;
} TSC_MsgGetAlarmMask_t;

#define TSC_MsgGetAlarmMask_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgGetAlarmMask_Linenum), &((structAddr)->Linenum))


#define TSC_MsgGetAlarmMask_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgGetAlarmMask_Linenum), &((structAddr)->Linenum))


#define TSC_MsgGetAlarmMask_Size		1

#define TSC_MsgGetAlarmMask	0x1244	/* 4676 */
/* The TSC_MsgGetAlarmMask message is sent to the TSC component to query the 
 * alarm mask for blocking alarms for a particular trunk. Linenum - DM3 trunk 
 * number, maximum of 16 currently */

#define TSC_MsgGetAlarmMaskCmplt_Linenum	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgGetAlarmMaskCmplt_Linenum_t;

#define TSC_MsgGetAlarmMaskCmplt_Alarm_mask	0x380001	/* 3670017 */
typedef	UInt32	TSC_MsgGetAlarmMaskCmplt_Alarm_mask_t;

/*
 * TSC_MsgGetAlarmMaskCmplt (value = 0x1245) is an output message
 * for component TSC.
 */


typedef struct {
	UInt8	Linenum;
	UInt32	Alarm_mask;
} TSC_MsgGetAlarmMaskCmplt_t;

#define TSC_MsgGetAlarmMaskCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgGetAlarmMaskCmplt_Linenum), &((structAddr)->Linenum),	\
			(TSC_MsgGetAlarmMaskCmplt_Alarm_mask), &((structAddr)->Alarm_mask))


#define TSC_MsgGetAlarmMaskCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgGetAlarmMaskCmplt_Linenum), &((structAddr)->Linenum),	\
			(TSC_MsgGetAlarmMaskCmplt_Alarm_mask), &((structAddr)->Alarm_mask))


#define TSC_MsgGetAlarmMaskCmplt_Size		5

#define TSC_MsgGetAlarmMaskCmplt	0x1245	/* 4677 */
/* The Tsc_MsgGetAlarmMaskCmplt message is sent as a successful response to 
 * the Tsc_MsgGetAlarmMask command message. */

#define TSC_MsgResetLineDevice_state	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgResetLineDevice_state_t;

/*
 * TSC_MsgResetLineDevice (value = 0x1246) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	state;
} TSC_MsgResetLineDevice_t;

#define TSC_MsgResetLineDevice_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgResetLineDevice_state), &((structAddr)->state))


#define TSC_MsgResetLineDevice_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgResetLineDevice_state), &((structAddr)->state))


#define TSC_MsgResetLineDevice_Size		4

#define TSC_MsgResetLineDevice	0x1246	/* 4678 */
/* The Tsc_MsgResetLineDevice message is sent to a TSC instance to instruct 
 * the instance to take whatever actions are necessary to drop all calls on the 
 * channel and return the call state to Idle. hold request from the remote 
 * side. state The desired state the channel should be in after callstate is 
 * returned to idle. These values are the same as for TSC_MsgSetChanState. */
/* The Tsc_MsgResetLineDeviceCmplt message is sent as a successful response to 
 * Tsc_MsgResetLineDevice. */

/*
 * TSC_MsgResetLineDeviceCmplt (value = 0x1247) is an output message
 * for component TSC.
 */

#define TSC_MsgResetLineDeviceCmplt_Size		0

#define TSC_MsgResetLineDeviceCmplt	0x1247	/* 4679 */

#define TSC_MsgGCExtension_Int1Val	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgGCExtension_Int1Val_t;

#define TSC_MsgGCExtension_Int2Val	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgGCExtension_Int2Val_t;

#define TSC_MsgGCExtension_Int3Val	0x380008	/* 3670024 */
typedef	UInt32	TSC_MsgGCExtension_Int3Val_t;

#define TSC_MsgGCExtension_Str1Val	0x53f80c	/* 5502988 */
typedef	Char	TSC_MsgGCExtension_Str1Val_t[128];

#define TSC_MsgGCExtension_Str2Val	0x53f88c	/* 5503116 */
typedef	Char	TSC_MsgGCExtension_Str2Val_t[128];

/*
 * TSC_MsgGCExtension (value = 0x1248) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	Int1Val;
	UInt32	Int2Val;
	UInt32	Int3Val;
	Char	Str1Val[128];
	Char	Str2Val[128];
} TSC_MsgGCExtension_t;

#define TSC_MsgGCExtension_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(TSC_MsgGCExtension_Int1Val), &((structAddr)->Int1Val),	\
			(TSC_MsgGCExtension_Int2Val), &((structAddr)->Int2Val),	\
			(TSC_MsgGCExtension_Int3Val), &((structAddr)->Int3Val),	\
			(TSC_MsgGCExtension_Str1Val), &((structAddr)->Str1Val),	\
			(TSC_MsgGCExtension_Str2Val), &((structAddr)->Str2Val))


#define TSC_MsgGCExtension_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(TSC_MsgGCExtension_Int1Val), &((structAddr)->Int1Val),	\
			(TSC_MsgGCExtension_Int2Val), &((structAddr)->Int2Val),	\
			(TSC_MsgGCExtension_Int3Val), &((structAddr)->Int3Val),	\
			(TSC_MsgGCExtension_Str1Val), &((structAddr)->Str1Val),	\
			(TSC_MsgGCExtension_Str2Val), &((structAddr)->Str2Val))


#define TSC_MsgGCExtension_Size		268

#define TSC_MsgGCExtension	0x1248	/* 4680 */
/* This command message tells the firmware to send a CMD_Extension signal to 
 * the underlying PDK Protocol. Int1Val First integer. Int2Val Second integer. 
 * Int3Val Third integer. Str1Val First string. Str2Val Second string. */
/* This message is sent in response to MsgGCExtension as acknowledgement. It 
 * does not indicate completion of the underlying CMD_Extension signal. */

/*
 * TSC_MsgGCExtensionCmplt (value = 0x1249) is an output message
 * for component TSC.
 */

#define TSC_MsgGCExtensionCmplt_Size		0

#define TSC_MsgGCExtensionCmplt	0x1249	/* 4681 */

#define TSC_EvtGCExtension_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_EvtGCExtension_Label_t;

#define TSC_EvtGCExtension_Type_Extension	0x1250	/* 4688 */

#define TSC_EvtGCExtension_Type	0x380004	/* 3670020 */
typedef	UInt32	TSC_EvtGCExtension_Type_t;

#define TSC_EvtGCExtension_Timestamp	0x380008	/* 3670024 */
typedef	UInt32	TSC_EvtGCExtension_Timestamp_t;

#define TSC_EvtGCExtension_Int1Val	0x38000c	/* 3670028 */
typedef	UInt32	TSC_EvtGCExtension_Int1Val_t;

#define TSC_EvtGCExtension_Int2Val	0x380010	/* 3670032 */
typedef	UInt32	TSC_EvtGCExtension_Int2Val_t;

#define TSC_EvtGCExtension_Int3Val	0x380014	/* 3670036 */
typedef	UInt32	TSC_EvtGCExtension_Int3Val_t;

#define TSC_EvtGCExtension_Str1Val	0x53f818	/* 5503000 */
typedef	Char	TSC_EvtGCExtension_Str1Val_t[128];

#define TSC_EvtGCExtension_Str2Val	0x53f898	/* 5503128 */
typedef	Char	TSC_EvtGCExtension_Str2Val_t[128];

/*
 * TSC_EvtGCExtension (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
	UInt32	Timestamp;
	UInt32	Int1Val;
	UInt32	Int2Val;
	UInt32	Int3Val;
	Char	Str1Val[128];
	Char	Str2Val[128];
} TSC_EvtGCExtension_t;

#define TSC_EvtGCExtension_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 8, &(offset),	\
			(TSC_EvtGCExtension_Label), &((structAddr)->Label),	\
			(TSC_EvtGCExtension_Type), &((structAddr)->Type),	\
			(TSC_EvtGCExtension_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtGCExtension_Int1Val), &((structAddr)->Int1Val),	\
			(TSC_EvtGCExtension_Int2Val), &((structAddr)->Int2Val),	\
			(TSC_EvtGCExtension_Int3Val), &((structAddr)->Int3Val),	\
			(TSC_EvtGCExtension_Str1Val), &((structAddr)->Str1Val),	\
			(TSC_EvtGCExtension_Str2Val), &((structAddr)->Str2Val))


#define TSC_EvtGCExtension_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 8, &(offset),	\
			(TSC_EvtGCExtension_Label), &((structAddr)->Label),	\
			(TSC_EvtGCExtension_Type), &((structAddr)->Type),	\
			(TSC_EvtGCExtension_Timestamp), &((structAddr)->Timestamp),	\
			(TSC_EvtGCExtension_Int1Val), &((structAddr)->Int1Val),	\
			(TSC_EvtGCExtension_Int2Val), &((structAddr)->Int2Val),	\
			(TSC_EvtGCExtension_Int3Val), &((structAddr)->Int3Val),	\
			(TSC_EvtGCExtension_Str1Val), &((structAddr)->Str1Val),	\
			(TSC_EvtGCExtension_Str2Val), &((structAddr)->Str2Val))


#define TSC_EvtGCExtension_Size		280
/* This asynchronous event is sent when the PDK engine receives SIG_Extension 
 * from the underlying protocol. Label The RTC label specified when this event 
 * type was enabled for detection. Type The RTC event type. Timestamp The 
 * board-level time at which the event was generated. Units of 1 msecs. Int1Val 
 * First integer. Int2Val Second integer. Int3Val Third integer. Str1Val First 
 * string. Str2Val Second string. */

#define TSC_MsgRetrieveCallAck_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRetrieveCallAck_CallId_t;

#define TSC_MsgRetrieveCallAck_ChannelId	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgRetrieveCallAck_ChannelId_t;

#define TSC_MsgRetrieveCallAck_varStart	0x8

#define TSC_MsgRetrieveCallAck_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRetrieveCallAck_KVSet_t;

/*
 * TSC_MsgRetrieveCallAck (value = 0x124a) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	ChannelId;
} TSC_MsgRetrieveCallAck_t;

#define TSC_MsgRetrieveCallAck_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgRetrieveCallAck_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRetrieveCallAck_ChannelId), &((structAddr)->ChannelId))


#define TSC_MsgRetrieveCallAck_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgRetrieveCallAck_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRetrieveCallAck_ChannelId), &((structAddr)->ChannelId))


#define TSC_MsgRetrieveCallAck_Size		8

#define TSC_MsgRetrieveCallAck	0x124a	/* 4682 */
/* This message sends the acknowledgement to an incoming Retrieve request for 
 * the specified CallId. CallId Specifies the call to retrieve. ChannelId Id of 
 * channel for retrieving the call (Optional). KVSet An optional Key-Value set 
 * specifying protocol-specific parameters for the operation. This field is a 
 * "place holder" for a KVSet structure. If no KVSet is appended to the message 
 * then leave this field out of the message.. This is only supported by the 
 * NetTSC component. */

#define TSC_MsgRetrieveCallRej_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRetrieveCallRej_CallId_t;

#define TSC_MsgRetrieveCallRej_Reason	0x380004	/* 3670020 */
typedef	UInt32	TSC_MsgRetrieveCallRej_Reason_t;

#define TSC_MsgRetrieveCallRej_varStart	0x8

#define TSC_MsgRetrieveCallRej_KVSet	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgRetrieveCallRej_KVSet_t;

/*
 * TSC_MsgRetrieveCallRej (value = 0x124b) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
	UInt32	Reason;
} TSC_MsgRetrieveCallRej_t;

#define TSC_MsgRetrieveCallRej_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgRetrieveCallRej_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRetrieveCallRej_Reason), &((structAddr)->Reason))


#define TSC_MsgRetrieveCallRej_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgRetrieveCallRej_CallId), &((structAddr)->CallId),	\
			(TSC_MsgRetrieveCallRej_Reason), &((structAddr)->Reason))


#define TSC_MsgRetrieveCallRej_Size		8

#define TSC_MsgRetrieveCallRej	0x124b	/* 4683 */
/* This message rejects an incoming Retrieve request for the specified CallId. 
 * CallId Specifies the call to retrieve. Reason Cause for rejection. KVSet An 
 * optional Key-Value set specifying protocol-specific parameters for the 
 * operation. This field is a "place holder" for a KVSet structure. If no KVSet 
 * is appended to the message then leave this field out of the message.. This 
 * is only supported by the NetTSC component. */

#define TSC_MsgSetupTransfer_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetupTransfer_CallId_t;

/*
 * TSC_MsgSetupTransfer (value = 0x124c) is an input message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgSetupTransfer_t;

#define TSC_MsgSetupTransfer_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgSetupTransfer_CallId), &((structAddr)->CallId))


#define TSC_MsgSetupTransfer_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgSetupTransfer_CallId), &((structAddr)->CallId))


#define TSC_MsgSetupTransfer_Size		4

#define TSC_MsgSetupTransfer	0x124c	/* 4684 */
/* This message instructs the protocol to place the current call on hold and 
 * prepare to start a second outbound call. CallId Specifies the currently 
 * active call to place on hold. */

#define TSC_MsgSetupTransferCmplt_CallId	0x380000	/* 3670016 */
typedef	UInt32	TSC_MsgSetupTransferCmplt_CallId_t;

/*
 * TSC_MsgSetupTransferCmplt (value = 0x124d) is an output message
 * for component TSC.
 */


typedef struct {
	UInt32	CallId;
} TSC_MsgSetupTransferCmplt_t;

#define TSC_MsgSetupTransferCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgSetupTransferCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgSetupTransferCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgSetupTransferCmplt_CallId), &((structAddr)->CallId))


#define TSC_MsgSetupTransferCmplt_Size		4

#define TSC_MsgSetupTransferCmplt	0x124d	/* 4685 */
/* This message is a response to the successful execution of MsgSetupTransfer. 
 * CallId Specifies the new CallId generated as a result of the SetupTransfer 
 * message. */

#define TSC_MsgTxRxSignalingGet_portId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgTxRxSignalingGet_portId_t;

#define TSC_MsgTxRxSignalingGet_channelId	0x200001	/* 2097153 */
typedef	UInt8	TSC_MsgTxRxSignalingGet_channelId_t;

/*
 * TSC_MsgTxRxSignalingGet (value = 0x124e) is an input message
 * for component TSC.
 */


typedef struct {
	UInt8	portId;
	UInt8	channelId;
} TSC_MsgTxRxSignalingGet_t;

#define TSC_MsgTxRxSignalingGet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgTxRxSignalingGet_portId), &((structAddr)->portId),	\
			(TSC_MsgTxRxSignalingGet_channelId), &((structAddr)->channelId))


#define TSC_MsgTxRxSignalingGet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgTxRxSignalingGet_portId), &((structAddr)->portId),	\
			(TSC_MsgTxRxSignalingGet_channelId), &((structAddr)->channelId))


#define TSC_MsgTxRxSignalingGet_Size		2

#define TSC_MsgTxRxSignalingGet	0x124e	/* 4686 */
/* This message initiates the detection of the current states of the TX and RX 
 * bits on a particular timeslot on the port. The channelId parameter is 
 * numbered from 1 through 24 for a T1 port and 1 through 15 and 17 through 31 
 * for an E1 port. Timeslot 16 is invalid for an E1 port. The firmware will 
 * return MsgTxRxSignalingGetCmplt to the user application, upon getting the 
 * current state of the bits from the DM3 hardware. */

#define TSC_MsgTxRxSignalingGetCmplt_portId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgTxRxSignalingGetCmplt_portId_t;

#define TSC_MsgTxRxSignalingGetCmplt_channelId	0x200001	/* 2097153 */
typedef	UInt8	TSC_MsgTxRxSignalingGetCmplt_channelId_t;

#define TSC_MsgTxRxSignalingGetCmplt_signalBits	0x200002	/* 2097154 */
typedef	UInt8	TSC_MsgTxRxSignalingGetCmplt_signalBits_t;

/*
 * TSC_MsgTxRxSignalingGetCmplt (value = 0x124f) is an output message
 * for component TSC.
 */


typedef struct {
	UInt8	portId;
	UInt8	channelId;
	UInt8	signalBits;
} TSC_MsgTxRxSignalingGetCmplt_t;

#define TSC_MsgTxRxSignalingGetCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_MsgTxRxSignalingGetCmplt_portId), &((structAddr)->portId),	\
			(TSC_MsgTxRxSignalingGetCmplt_channelId), &((structAddr)->channelId),	\
			(TSC_MsgTxRxSignalingGetCmplt_signalBits), &((structAddr)->signalBits))


#define TSC_MsgTxRxSignalingGetCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_MsgTxRxSignalingGetCmplt_portId), &((structAddr)->portId),	\
			(TSC_MsgTxRxSignalingGetCmplt_channelId), &((structAddr)->channelId),	\
			(TSC_MsgTxRxSignalingGetCmplt_signalBits), &((structAddr)->signalBits))


#define TSC_MsgTxRxSignalingGetCmplt_Size		3

#define TSC_MsgTxRxSignalingGetCmplt	0x124f	/* 4687 */
/* This is the completion message for the corresponding MsgTxRxSignalingGet. 
 * The message returns the current ABCD signaling bit values being transmitted 
 * and received on the given timeslot of the given T1 or E1 port. The lower 
 * four bits (bits 0 3) of the variable signalBits contain the signaling bits 
 * currently being received on the given T1 or E1 timeslot. The upper four bits 
 * (bits 4 7) of the variable signalBits contain the signaling bits currently 
 * being transmitted on the given T1 or E1 timeslot. */

#define TSC_MsgTxRxSignalingGetAll_portId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgTxRxSignalingGetAll_portId_t;

/*
 * TSC_MsgTxRxSignalingGetAll (value = 0x1250) is an input message
 * for component TSC.
 */


typedef struct {
	UInt8	portId;
} TSC_MsgTxRxSignalingGetAll_t;

#define TSC_MsgTxRxSignalingGetAll_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(TSC_MsgTxRxSignalingGetAll_portId), &((structAddr)->portId))


#define TSC_MsgTxRxSignalingGetAll_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(TSC_MsgTxRxSignalingGetAll_portId), &((structAddr)->portId))


#define TSC_MsgTxRxSignalingGetAll_Size		1

#define TSC_MsgTxRxSignalingGetAll	0x1250	/* 4688 */
/* This message initiates the detection of the current states of the TX and RX 
 * bits on all timeslots on the port. The firmware will return 
 * MsgTxRxSignalingGetAllCmplt to the user application, upon getting the 
 * current state of the bits of all timeslots on the trunk from the DM3 
 * hardware. */

#define TSC_MsgTxRxSignalingGetAllCmplt_portId	0x200000	/* 2097152 */
typedef	UInt8	TSC_MsgTxRxSignalingGetAllCmplt_portId_t;

#define TSC_MsgTxRxSignalingGetAllCmplt_signalBits	0x20f801	/* 2160641 */
typedef	UInt8	TSC_MsgTxRxSignalingGetAllCmplt_signalBits_t[32];

/*
 * TSC_MsgTxRxSignalingGetAllCmplt (value = 0x1251) is an output message
 * for component TSC.
 */


typedef struct {
	UInt8	portId;
	UInt8	signalBits[32];
} TSC_MsgTxRxSignalingGetAllCmplt_t;

#define TSC_MsgTxRxSignalingGetAllCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_MsgTxRxSignalingGetAllCmplt_portId), &((structAddr)->portId),	\
			(TSC_MsgTxRxSignalingGetAllCmplt_signalBits), &((structAddr)->signalBits))


#define TSC_MsgTxRxSignalingGetAllCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_MsgTxRxSignalingGetAllCmplt_portId), &((structAddr)->portId),	\
			(TSC_MsgTxRxSignalingGetAllCmplt_signalBits), &((structAddr)->signalBits))


#define TSC_MsgTxRxSignalingGetAllCmplt_Size		33

#define TSC_MsgTxRxSignalingGetAllCmplt	0x1251	/* 4689 */
/* This is the completion message for the corresponding 
 * MsgTxRxSignalingGetAll. The message returns the current ABCD signaling bit 
 * values being transmitted and received on all timeslots of the given T1 or E1 
 * port. The lower four bits (bits 0 3) of each valid element of the array 
 * signalBits contain the signaling bits currently being received on the given 
 * T1 or E1 timeslot. The upper four bits (bits 4 7) of each valid element of 
 * the array signalBits contain the signaling bits currently being transmitted 
 * on the given T1 or E1 timeslot. */
/* Call Information Identifier */

#define TSC_CallInfo_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Id_t;

#define TSC_CallInfo_State_Unavailable	0	/* 0 */

#define TSC_CallInfo_State_Available	0x1	/* 1 */

#define TSC_CallInfo_State	0x200004	/* 2097156 */
typedef	UInt8	TSC_CallInfo_State_t;
/* MDL Data Type definition for Data section */

#define TSC_CallInfo_Type	0x300005	/* 3145733 */
typedef	UInt24	TSC_CallInfo_Type_t;
/* Length of KVSet body in octets */

#define TSC_CallInfo_Length	0x280008	/* 2621448 */
typedef	UInt16	TSC_CallInfo_Length_t;

#define TSC_CallInfo_varStart	0xa
/* Call Information Value */

#define TSC_CallInfo_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_Data_t;

#define TSC_CallInfo_BearerChanId	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_BearerChanId_t;

#define TSC_CallInfo_CalledId	0x23f800	/* 2357248 */
typedef	UInt8	TSC_CallInfo_CalledId_t[128];

#define TSC_CallInfo_CalledIdType	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CalledIdType_t;

#define TSC_CallInfo_CalledIdCategory	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CalledIdCategory_t;

#define TSC_CallInfo_CalledSubId	0x20f800	/* 2160640 */
typedef	UInt8	TSC_CallInfo_CalledSubId_t[32];

#define TSC_CallInfo_CalledSubIdType	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CalledSubIdType_t;

#define TSC_CallInfo_CallerId	0x23f800	/* 2357248 */
typedef	UInt8	TSC_CallInfo_CallerId_t[128];

#define TSC_CallInfo_CallerIdType	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CallerIdType_t;

#define TSC_CallInfo_CallerIdCategory	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CallerIdCategory_t;

#define TSC_CallInfo_CallerSubId	0x20f800	/* 2160640 */
typedef	UInt8	TSC_CallInfo_CallerSubId_t[32];

#define TSC_CallInfo_CallerSubIdType	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CallerSubIdType_t;

#define TSC_CallInfo_Charge	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Charge_t;

#define TSC_CallInfo_ChargeType	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_ChargeType_t;

#define TSC_CallInfo_Display	0x27f800	/* 2619392 */
typedef	UInt8	TSC_CallInfo_Display_t[256];

#define TSC_CallInfo_Language	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Language_t;

#define TSC_CallInfo_LineId	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_LineId_t;

#define TSC_CallInfo_Origin_Inbound	0	/* 0 */

#define TSC_CallInfo_Origin_Outbound	0x1	/* 1 */

#define TSC_CallInfo_Origin_Conference	0x2	/* 2 */

#define TSC_CallInfo_Origin	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Origin_t;

#define TSC_CallInfo_Rate	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Rate_t;

#define TSC_CallInfo_Reason_Direct	0	/* 0 */

#define TSC_CallInfo_Reason_Forward	0x1	/* 1 */

#define TSC_CallInfo_Reason_ForwardBusy	0x2	/* 2 */

#define TSC_CallInfo_Reason_ForwardNoAnswer	0x3	/* 3 */

#define TSC_CallInfo_Reason_Pickup	0x4	/* 4 */

#define TSC_CallInfo_Reason_Redirect	0x5	/* 5 */

#define TSC_CallInfo_Reason_Completion	0x6	/* 6 */

#define TSC_CallInfo_Reason_Transfer	0x7	/* 7 */

#define TSC_CallInfo_Reason_Message	0x8	/* 8 */

#define TSC_CallInfo_Reason_Unknown	0x9	/* 9 */

#define TSC_CallInfo_Reason_Unavailable	0xa	/* 10 */

#define TSC_CallInfo_Reason	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Reason_t;

#define TSC_CallInfo_RedirectedId	0x23f800	/* 2357248 */
typedef	UInt8	TSC_CallInfo_RedirectedId_t[128];

#define TSC_CallInfo_RedirectedIdType	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_RedirectedIdType_t;

#define TSC_CallInfo_RedirectingId	0x23f800	/* 2357248 */
typedef	UInt8	TSC_CallInfo_RedirectingId_t[128];

#define TSC_CallInfo_RedirectingIdType	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_RedirectingIdType_t;

#define TSC_CallInfo_CallAnalysis_Unknown	0	/* 0 */

#define TSC_CallInfo_CallAnalysis_PVD	0x1	/* 1 */

#define TSC_CallInfo_CallAnalysis_PAMD	0x2	/* 2 */

#define TSC_CallInfo_CallAnalysis_FAX	0x3	/* 3 */

#define TSC_CallInfo_CallAnalysis_Cadence	0x4	/* 4 */

#define TSC_CallInfo_CallAnalysis	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_CallAnalysis_t;

#define TSC_CallInfo_InfoTransferCap	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_InfoTransferCap_t;

#define TSC_CallInfo_InfoTransferRate	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_InfoTransferRate_t;

#define TSC_CallInfo_Layer1Protocol	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_Layer1Protocol_t;

#define TSC_CallInfo_FacilityIE	0x23f800	/* 2357248 */
typedef	UInt8	TSC_CallInfo_FacilityIE_t[128];

#define TSC_CallInfo_CalledIdPlan	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CalledIdPlan_t;

#define TSC_CallInfo_CallerIdPlan	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_CallerIdPlan_t;

#define TSC_CallInfo_RedirectedIdPlan	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_RedirectedIdPlan_t;

#define TSC_CallInfo_RedirectingIdPlan	0x200000	/* 2097152 */
typedef	UInt8	TSC_CallInfo_RedirectingIdPlan_t;

#define TSC_CallInfo_CallerName	0x21f800	/* 2226176 */
typedef	UInt8	TSC_CallInfo_CallerName_t[64];

#define TSC_CallInfo_DateTime	0x20f800	/* 2160640 */
typedef	UInt8	TSC_CallInfo_DateTime_t[32];

#define TSC_CallInfo_CallerNumberAbsenceReason	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_CallerNumberAbsenceReason_t;

#define TSC_CallInfo_CallerNameAbsenceReason	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_CallerNameAbsenceReason_t;

#define TSC_CallInfo_PublicMsg	0x21f800	/* 2226176 */
typedef	UInt8	TSC_CallInfo_PublicMsg_t[64];

#define TSC_CallInfo_VisualIndicator	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_VisualIndicator_t;

#define TSC_CallInfo_CallQualifier	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_CallQualifier_t;

#define TSC_CallInfo_RedirectReason	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_RedirectReason_t;

#define TSC_CallInfo_CallerIdExtended	0x201800	/* 2103296 */
typedef	UInt8	TSC_CallInfo_CallerIdExtended_t[4];

#define TSC_CallInfo_DDId	0x21f800	/* 2226176 */
typedef	UInt8	TSC_CallInfo_DDId_t[64];

#define TSC_CallInfo_DDIdExtended	0x201800	/* 2103296 */
typedef	UInt8	TSC_CallInfo_DDIdExtended_t[4];

#define TSC_CallInfo_OriginalCallerId	0x21f800	/* 2226176 */
typedef	UInt8	TSC_CallInfo_OriginalCallerId_t[64];

#define TSC_CallInfo_OriginalCallerIdExtended	0x201800	/* 2103296 */
typedef	UInt8	TSC_CallInfo_OriginalCallerIdExtended_t[4];

#define TSC_CallInfo_Detected_SigId	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_Detected_SigId_t;

#define TSC_CallInfo_CallReference	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfo_CallReference_t;


typedef struct {
	UInt32	Id;
	UInt8	State;
	UInt24	Type;
	UInt16	Length;
} TSC_CallInfo_t;

#define TSC_CallInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_CallInfo_Id), &((structAddr)->Id),	\
			(TSC_CallInfo_State), &((structAddr)->State),	\
			(TSC_CallInfo_Type), &((structAddr)->Type),	\
			(TSC_CallInfo_Length), &((structAddr)->Length))


#define TSC_CallInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_CallInfo_Id), &((structAddr)->Id),	\
			(TSC_CallInfo_State), &((structAddr)->State),	\
			(TSC_CallInfo_Type), &((structAddr)->Type),	\
			(TSC_CallInfo_Length), &((structAddr)->Length))


#define TSC_CallInfo_Size		10

#define TSC_CallInfo	0x1202	/* 4610 */
/* The CallInfo structure contains the information identifier, and the raw 
 * data that makes up that information. The CallInfo Data section may be a 
 * simple type (Uint8, Uint32, etc), or it may be a structure. The actual 
 * definition of this is dependant on the Call Information Identifier and 
 * specified in section 13.1. Id The Call Information Identifier. Uniquely 
 * identifies the information. State The state of the call information. This 
 * indicates whether the requested information was available or not. The Data 
 * field will contain valid data when the state is 
 * TSC_CallInfo_State_Available, otherwise the data is invalid (i.e. just 
 * padding data). Type This is an MMDL data field definition that defines the 
 * format and size of the Data field. See qmsg.h and the MMDL reference for a 
 * complete definition. This field is provided for optional use to allow 
 * generic parsing of the CallInfo structure. Used only for Mercury TSP - 
 * NetTSP application should ignore this field. Length Length of data in byte. 
 * Used only for NetTSP - TSP applications should ignore this field. Data The 
 * value of the call information. This is a variable length field whose size 
 * and data type is specified by the Type field. This field is used to 
 * transport generic arrays of Uint8 data. */

#define TSC_CallInfoSet_InfoSize	0x380000	/* 3670016 */
typedef	UInt32	TSC_CallInfoSet_InfoSize_t;

#define TSC_CallInfoSet_Count	0x380004	/* 3670020 */
typedef	UInt32	TSC_CallInfoSet_Count_t;

#define TSC_CallInfoSet_Members	0x381808	/* 3676168 */
typedef	UInt32	TSC_CallInfoSet_Members_t[4];


typedef struct {
	UInt32	InfoSize;
	UInt32	Count;
	UInt32	Members[4];
} TSC_CallInfoSet_t;

#define TSC_CallInfoSet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(TSC_CallInfoSet_InfoSize), &((structAddr)->InfoSize),	\
			(TSC_CallInfoSet_Count), &((structAddr)->Count),	\
			(TSC_CallInfoSet_Members), &((structAddr)->Members))


#define TSC_CallInfoSet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(TSC_CallInfoSet_InfoSize), &((structAddr)->InfoSize),	\
			(TSC_CallInfoSet_Count), &((structAddr)->Count),	\
			(TSC_CallInfoSet_Members), &((structAddr)->Members))


#define TSC_CallInfoSet_Size		24

#define TSC_CallInfoSet	0x1203	/* 4611 */
/* The CallInfoSet structure provides a concise representation of a set for 
 * call information identifiers. It provides for a set of up to 128 members 
 * using bit-based operation of the members array (4*32=128 bits). This 
 * structure is used for internal messaging. Field Description Size The total 
 * data size that the set represents (in bytes). Count Number of members in the 
 * set. Members Bit-set array for membership (1=member, 0=not). */

#define TSC_Facility_ServiceDescriptor	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_ServiceDescriptor_t;
/* Network Facility extension */

#define TSC_Facility_NetExtension	0x200001	/* 2097153 */
typedef	UInt8	TSC_Facility_NetExtension_t;
/* Indicates validity of NetExtension field */

#define TSC_Facility_NetExtenstionPresent	0x200002	/* 2097154 */
typedef	UInt8	TSC_Facility_NetExtenstionPresent_t;

#define TSC_Facility_NetProtocolProfile	0x200003	/* 2097155 */
typedef	UInt8	TSC_Facility_NetProtocolProfile_t;
/* Indicates validity of NetProtocolProfile field */

#define TSC_Facility_NetProtocolProfilePresent	0x200004	/* 2097156 */
typedef	UInt8	TSC_Facility_NetProtocolProfilePresent_t;

#define TSC_Facility_Interpretation	0x200005	/* 2097157 */
typedef	UInt8	TSC_Facility_Interpretation_t;
/* Indicates validity of Interpretation field */

#define TSC_Facility_InterpretationPresent	0x200006	/* 2097158 */
typedef	UInt8	TSC_Facility_InterpretationPresent_t;
/* Number of components that follow */

#define TSC_Facility_Count	0x200007	/* 2097159 */
typedef	UInt8	TSC_Facility_Count_t;

#define TSC_Facility_varStart	0x8
/* Facility component */

#define TSC_Facility_Comp_Type	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_Comp_Type_t;

#define TSC_Facility_Comp_InvokeTag	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_Comp_InvokeTag_t;

#define TSC_Facility_Comp_InvokeId	0x380000	/* 3670016 */
typedef	UInt32	TSC_Facility_Comp_InvokeId_t;
/* Number of data elements that follow */

#define TSC_Facility_Comp_Count	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_Comp_Count_t;


typedef struct {
	UInt8	Type;
	UInt8	InvokeTag;
	UInt32	InvokeId;
	UInt8	Count;
} TSC_Facility_Comp_t;

#define TSC_Facility_Comp_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(TSC_Facility_Comp_Type), &((structAddr)->Type),	\
			(TSC_Facility_Comp_InvokeTag), &((structAddr)->InvokeTag),	\
			(TSC_Facility_Comp_InvokeId), &((structAddr)->InvokeId),	\
			(TSC_Facility_Comp_Count), &((structAddr)->Count))


#define TSC_Facility_Comp_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(TSC_Facility_Comp_Type), &((structAddr)->Type),	\
			(TSC_Facility_Comp_InvokeTag), &((structAddr)->InvokeTag),	\
			(TSC_Facility_Comp_InvokeId), &((structAddr)->InvokeId),	\
			(TSC_Facility_Comp_Count), &((structAddr)->Count))


#define TSC_Facility_Comp_Size		7

#define TSC_Facility_Comp	0x1205	/* 4613 */
/* Facility component data element */

#define TSC_Facility_Element_Tag	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_Element_Tag_t;
/* Length of the uint8 Data array that follows */

#define TSC_Facility_Element_Length	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_Element_Length_t;


typedef struct {
	UInt8	Tag;
	UInt8	Length;
} TSC_Facility_Element_t;

#define TSC_Facility_Element_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_Facility_Element_Tag), &((structAddr)->Tag),	\
			(TSC_Facility_Element_Length), &((structAddr)->Length))


#define TSC_Facility_Element_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_Facility_Element_Tag), &((structAddr)->Tag),	\
			(TSC_Facility_Element_Length), &((structAddr)->Length))


#define TSC_Facility_Element_Size		2

#define TSC_Facility_Element	0x1206	/* 4614 */
/* variable length array of element data */

#define TSC_Facility_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_Facility_Data_t;


typedef struct {
	UInt8	ServiceDescriptor;
	UInt8	NetExtension;
	UInt8	NetExtenstionPresent;
	UInt8	NetProtocolProfile;
	UInt8	NetProtocolProfilePresent;
	UInt8	Interpretation;
	UInt8	InterpretationPresent;
	UInt8	Count;
} TSC_Facility_t;

#define TSC_Facility_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 8, &(offset),	\
			(TSC_Facility_ServiceDescriptor), &((structAddr)->ServiceDescriptor),	\
			(TSC_Facility_NetExtension), &((structAddr)->NetExtension),	\
			(TSC_Facility_NetExtenstionPresent), &((structAddr)->NetExtenstionPresent),	\
			(TSC_Facility_NetProtocolProfile), &((structAddr)->NetProtocolProfile),	\
			(TSC_Facility_NetProtocolProfilePresent), &((structAddr)->NetProtocolProfilePresent),	\
			(TSC_Facility_Interpretation), &((structAddr)->Interpretation),	\
			(TSC_Facility_InterpretationPresent), &((structAddr)->InterpretationPresent),	\
			(TSC_Facility_Count), &((structAddr)->Count))


#define TSC_Facility_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 8, &(offset),	\
			(TSC_Facility_ServiceDescriptor), &((structAddr)->ServiceDescriptor),	\
			(TSC_Facility_NetExtension), &((structAddr)->NetExtension),	\
			(TSC_Facility_NetExtenstionPresent), &((structAddr)->NetExtenstionPresent),	\
			(TSC_Facility_NetProtocolProfile), &((structAddr)->NetProtocolProfile),	\
			(TSC_Facility_NetProtocolProfilePresent), &((structAddr)->NetProtocolProfilePresent),	\
			(TSC_Facility_Interpretation), &((structAddr)->Interpretation),	\
			(TSC_Facility_InterpretationPresent), &((structAddr)->InterpretationPresent),	\
			(TSC_Facility_Count), &((structAddr)->Count))


#define TSC_Facility_Size		8

#define TSC_Facility	0x1204	/* 4612 */
/* This call information structure contains the information present in the 
 * Facilities IE in a Setup Indication message. This is the format used for the 
 * call information element CallInfo_Facility. The structure consists of two 
 * levels; the facility header and one or more components, and one or more data 
 * elements within each component. Each data element is followed by a variable 
 * length array of Uint8s (Element_Data), the size of which is specified by the 
 * Element Length The value of each field is switch specific. Refer to the 
 * Facilities IE documentation for each switch. Field Description */
/* 
 * TSC Parameter Definitions 
 */
/* 
 * The identifier of the Bearer Channel that the 
 * TSC Instance is associated with. 
 */

#define TSC_ParmBearerChanId	0x1200	/* 4608 */
typedef	UInt32	TSC_ParmBearerChanId_t;
/* 
 * This identifies the Bearer Channel Set in which 
 * the Bearer Channel is a member. 
 */

#define TSC_ParmBearerChanSet	0x1201	/* 4609 */
typedef	UInt32	TSC_ParmBearerChanSet_t;
/* 
 * The identifier of the Line Device that the TSC 
 * Instance is associated with (and to which the 
 * Bearer Channel belongs). 
 */

#define TSC_ParmLineId	0x1202	/* 4610 */
typedef	UInt32	TSC_ParmLineId_t;

#define TSC_ParmProtocolBase_Default	0	/* 0 */

#define TSC_ParmProtocolBase_T1_CAS	0x1	/* 1 */

#define TSC_ParmProtocolBase_ISDN	0x2	/* 2 */

#define TSC_ParmProtocolBase_H323	0x3	/* 3 */

#define TSC_ParmProtocolBase_IS95	0x4	/* 4 */

#define TSC_ParmProtocolBase_IS131	0x5	/* 5 */

#define TSC_ParmProtocolBase_PDK	0x6	/* 6 */

#define TSC_ParmProtocolBase_R2MFC	0x6	/* 6 */

#define TSC_ParmProtocolBase_CircaAnalog	0x7	/* 7 */

#define TSC_ParmProtocolBase_BRI_ISDN	0x8	/* 8 */
/* 
 * This parameter defines the protocol family that 
 * the TSC Instance implements. 
 * Note  PDK and R2MFC are the same. 
 * Circa Analog Protocol supports Circa L feature 
 * phones. Please refer to CircaProtocolDefs and 
 * CircaControllerdefs for more information. 
 */

#define TSC_ParmProtocolBase	0x1203	/* 4611 */
typedef	UInt32	TSC_ParmProtocolBase_t;
/* 
 * This parameter identifies the variant of the 
 * protocol family that a TSC Instance is using for 
 * inbound calls. This can be set to 0 to disable 
 * inbound calls. 
 */

#define TSC_ParmInboundVariantId	0x1204	/* 4612 */
typedef	UInt32	TSC_ParmInboundVariantId_t;
/* 
 * This parameter identifies the variant of the 
 * protocol family that a TSC Instance is using for 
 * outbound calls. This can be set to 0 to disable 
 * inbound calls. 
 */

#define TSC_ParmOutboundVariantId	0x1205	/* 4613 */
typedef	UInt32	TSC_ParmOutboundVariantId_t;
/* 
 * This is the host configuration identifier 
 * assigned by the System Administrator. 
 * This provides a way of grouping TSC Instances 
 * into arbitrary groupings. 
 */

#define TSC_ParmAdminGroup	0x1206	/* 4614 */
typedef	UInt32	TSC_ParmAdminGroup_t;
/*
 * The logical timeslot that the channel is using. 
 */

#define TSC_ParmSlotId	0x1207	/* 4615 */
typedef	UInt32	TSC_ParmSlotId_t;
/*
 * Level of debugging enabled in instance.  
 * Default = 0 (none). 
 */

#define TSC_ParmDebugLevel	0x1208	/* 4616 */
typedef	UInt32	TSC_ParmDebugLevel_t;

#define TSC_ParmEncoding_Alaw	0x1	/* 1 */

#define TSC_ParmEncoding_Mulaw	0x2	/* 2 */
/* 
 * Channel Encoding - Mulaw or Alaw. 
 */

#define TSC_ParmEncoding	0x1209	/* 4617 */
typedef	UInt32	TSC_ParmEncoding_t;
/* Channel Resource Loading Strategy 
 * If enabled resources are acquired on per call 
 * basis. They also are released once call goes to 
 * the connected state and does not need them.
 * [GSK]+. By default it is disabled.*/

#define TSC_ParmDynamicResourceLoading	0x120a	/* 4618 */
typedef	UInt32	TSC_ParmDynamicResourceLoading_t;

#define TSC_ParmClearChannel_Default	0	/* 0 */

#define TSC_ParmClearChannel_Disabled	0	/* 0 */

#define TSC_ParmClearChannel_Enabled	0x1	/* 1 */
/* Parameter used to track the Line 
 * signaling type for each component. */

#define TSC_ParmClearChannel	0x120b	/* 4619 */
typedef	UInt32	TSC_ParmClearChannel_t;

#define TSC_ParmChannel_Gain_Base_Min	0xffffffe1	/* -31 */

#define TSC_ParmChannel_Gain_Base_Max	0x1f	/* 31 */

#define TSC_ParmChannel_Gain_Base_Default	0xfffffffd	/* -3 */
/*
 * This parameter contains the base gain 
 * value that the interface is set to upon 
 * initialization. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmChannel_Gain_Base	0x120c	/* 4620 */
typedef	Int32	TSC_ParmChannel_Gain_Base_t;
/*
 * This parameter contains the current gain 
 * setting of the interface and the current gain 
 * of the interface is controlled by this 
 * parameter. This parameter can be written 
 * after the TSC Instance is allocated.
 */

#define TSC_ParmChannel_Gain	0x120d	/* 4621 */
typedef	Int32	TSC_ParmChannel_Gain_t;
/*
 * This parameter is used to make relative 
 * adjustments to the value of the 
 * 'Channel_Gain' parameter. This parameter 
 * can be written after the TSC Instance is 
 * allocated.
 */

#define TSC_ParmChannel_Gain_Adjust	0x120e	/* 4622 */
typedef	Int32	TSC_ParmChannel_Gain_Adjust_t;

#define TSC_ParmChannel_Gain_Min_Min	0xffffffe1	/* -31 */

#define TSC_ParmChannel_Gain_Min_Max	0x1f	/* 31 */

#define TSC_ParmChannel_Gain_Min_Default	0xfffffff7	/* -9 */
/*
 * This parameter contains the minimum gain 
 * value that the 'Channel_Gain' parameter 
 * may be set to. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmChannel_Gain_Min	0x120f	/* 4623 */
typedef	Int32	TSC_ParmChannel_Gain_Min_t;

#define TSC_ParmChannel_Gain_Max_Min	0xffffffe1	/* -31 */

#define TSC_ParmChannel_Gain_Max_Max	0x1f	/* 31 */

#define TSC_ParmChannel_Gain_Max_Default	0x6	/* 6 */
/*
 * This parameter contains the maximum gain 
 * value that the 'Channel_Gain' parameter 
 * may be set to. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmChannel_Gain_Max	0x1210	/* 4624 */
typedef	Int32	TSC_ParmChannel_Gain_Max_t;
/*
 * This parameter contains a switch that will 
 * enable the reporting of the status of the 
 * station lines through the alarm mechanism. 
 * This parameter is used in MSI1200.
 */

#define TSC_ParmEnableAlarmReport	0x1211	/* 4625 */
typedef	UInt32	TSC_ParmEnableAlarmReport_t;
/*
 * This parameter contains the number of the 
 * stations in an MSI1200 environment.
 * This parameter is used in MSI1200.
 */

#define TSC_ParmNumberOfStations	0x1212	/* 4626 */
typedef	UInt32	TSC_ParmNumberOfStations_t;

#define TSC_ParmTxChannel_Gain_Base_Min	0xffffffe1	/* -31 */

#define TSC_ParmTxChannel_Gain_Base_Max	0x1f	/* 31 */

#define TSC_ParmTxChannel_Gain_Base_Default	0xfffffffd	/* -3 */
/*
 * This parameter contains the base gain 
 * value that the interface is set to upon 
 * initialization. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmTxChannel_Gain_Base	0x1213	/* 4627 */
typedef	Int32	TSC_ParmTxChannel_Gain_Base_t;
/*
 * This parameter contains the current gain 
 * setting of the interface and the current gain 
 * of the interface is controlled by this 
 * parameter. This parameter can be written 
 * after the TSC Instance is allocated.
 */

#define TSC_ParmTxChannel_Gain	0x1214	/* 4628 */
typedef	Int32	TSC_ParmTxChannel_Gain_t;
/*
 * This parameter is used to make relative 
 * adjustments to the value of the 
 * 'Channel_Gain' parameter. This parameter 
 * can be written after the TSC Instance is 
 * allocated.
 */

#define TSC_ParmTxChannel_Gain_Adjust	0x1215	/* 4629 */
typedef	Int32	TSC_ParmTxChannel_Gain_Adjust_t;

#define TSC_ParmTxChannel_Gain_Min_Min	0xffffffe1	/* -31 */

#define TSC_ParmTxChannel_Gain_Min_Max	0x1f	/* 31 */

#define TSC_ParmTxChannel_Gain_Min_Default	0xfffffff7	/* -9 */
/*
 * This parameter contains the minimum gain 
 * value that the 'Channel_Gain' parameter 
 * may be set to. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmTxChannel_Gain_Min	0x1216	/* 4630 */
typedef	Int32	TSC_ParmTxChannel_Gain_Min_t;

#define TSC_ParmTxChannel_Gain_Max_Min	0xffffffe1	/* -31 */

#define TSC_ParmTxChannel_Gain_Max_Max	0x1f	/* 31 */

#define TSC_ParmTxChannel_Gain_Max_Default	0x6	/* 6 */
/*
 * This parameter contains the maximum gain 
 * value that the 'Channel_Gain' parameter 
 * may be set to. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmTxChannel_Gain_Max	0x1217	/* 4631 */
typedef	Int32	TSC_ParmTxChannel_Gain_Max_t;

#define TSC_ParmRxChannel_Gain_Base_Min	0xffffffe1	/* -31 */

#define TSC_ParmRxChannel_Gain_Base_Max	0x1f	/* 31 */

#define TSC_ParmRxChannel_Gain_Base_Default	0xfffffffd	/* -3 */
/*
 * This parameter contains the base gain 
 * value that the interface is set to upon 
 * initialization. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmRxChannel_Gain_Base	0x1218	/* 4632 */
typedef	Int32	TSC_ParmRxChannel_Gain_Base_t;
/*
 * This parameter contains the current gain 
 * setting of the interface and the current gain 
 * of the interface is controlled by this 
 * parameter. This parameter can be written 
 * after the TSC Instance is allocated.
 */

#define TSC_ParmRxChannel_Gain	0x1219	/* 4633 */
typedef	Int32	TSC_ParmRxChannel_Gain_t;
/*
 * This parameter is used to make relative 
 * adjustments to the value of the 
 * 'Channel_Gain' parameter. This parameter 
 * can be written after the TSC Instance is 
 * allocated.
 */

#define TSC_ParmRxChannel_Gain_Adjust	0x121a	/* 4634 */
typedef	Int32	TSC_ParmRxChannel_Gain_Adjust_t;

#define TSC_ParmRxChannel_Gain_Min_Min	0xffffffe1	/* -31 */

#define TSC_ParmRxChannel_Gain_Min_Max	0x1f	/* 31 */

#define TSC_ParmRxChannel_Gain_Min_Default	0xfffffff7	/* -9 */
/*
 * This parameter contains the minimum gain 
 * value that the 'Channel_Gain' parameter 
 * may be set to. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmRxChannel_Gain_Min	0x121b	/* 4635 */
typedef	Int32	TSC_ParmRxChannel_Gain_Min_t;

#define TSC_ParmRxChannel_Gain_Max_Min	0xffffffe1	/* -31 */

#define TSC_ParmRxChannel_Gain_Max_Max	0x1f	/* 31 */

#define TSC_ParmRxChannel_Gain_Max_Default	0x6	/* 6 */
/*
 * This parameter contains the maximum gain 
 * value that the 'Channel_Gain' parameter 
 * may be set to. This parameter can be 
 * written after the TSC Instance is allocated.
 */

#define TSC_ParmRxChannel_Gain_Max	0x121c	/* 4636 */
typedef	Int32	TSC_ParmRxChannel_Gain_Max_t;

#define TSC_ParmRxChannel_Onhook_Gain_Min	0xffffffe1	/* -31 */

#define TSC_ParmRxChannel_Onhook_Gain_Max	0x1f	/* 31 */

#define TSC_ParmRxChannel_Onhook_Gain_Default	0xfffffffa	/* -6 */
/*
 * This parameter is used by the Analog TSP to 
 * configure the receive gain levels for the onhook 
 * audio path.  The onhook audio path is used for 
 * CallerID reception for the US.
 */

#define TSC_ParmRxChannel_Onhook_Gain	0x121d	/* 4637 */
typedef	Int32	TSC_ParmRxChannel_Onhook_Gain_t;
/*
 * This parameter is used by the Analog TSP to 
 * enable or disable various features during run-
 * time
 */

#define TSC_ParmRunTimeAnalogConfig	0x121e	/* 4638 */
typedef	UInt32	TSC_ParmRunTimeAnalogConfig_t;
/*
 * This parameter is used by the PDK TSP to 
 * enable or disable various protocol trace 
 * logging.
 */
/* 
 * TSC Instance Parameter Structure 
 */

#define TSC_ParmSetProtocolTrace	0x121f	/* 4639 */
typedef	UInt32	TSC_ParmSetProtocolTrace_t;

#define TSC_Parm_LineId	0x380000	/* 3670016 */
typedef	UInt32	TSC_Parm_LineId_t;

#define TSC_Parm_BearerChanSet	0x380004	/* 3670020 */
typedef	UInt32	TSC_Parm_BearerChanSet_t;

#define TSC_Parm_BearerChanId	0x380008	/* 3670024 */
typedef	UInt32	TSC_Parm_BearerChanId_t;

#define TSC_Parm_ProtocolBase	0x38000c	/* 3670028 */
typedef	UInt32	TSC_Parm_ProtocolBase_t;

#define TSC_Parm_InboundVariantId	0x380010	/* 3670032 */
typedef	UInt32	TSC_Parm_InboundVariantId_t;

#define TSC_Parm_OutboundVariantId	0x380014	/* 3670036 */
typedef	UInt32	TSC_Parm_OutboundVariantId_t;

#define TSC_Parm_AdminGroup	0x380018	/* 3670040 */
typedef	UInt32	TSC_Parm_AdminGroup_t;

#define TSC_Parm_SlotId	0x38001c	/* 3670044 */
typedef	UInt32	TSC_Parm_SlotId_t;

#define TSC_Parm_Encoding	0x380020	/* 3670048 */
typedef	UInt32	TSC_Parm_Encoding_t;

#define TSC_Parm_DynamicResourceLoading	0x380024	/* 3670052 */
typedef	UInt32	TSC_Parm_DynamicResourceLoading_t;

#define TSC_Parm_ClearChannel	0x380028	/* 3670056 */
typedef	UInt32	TSC_Parm_ClearChannel_t;

#define TSC_Parm_Channel_Gain_Base	0x18002c	/* 1572908 */
typedef	Int32	TSC_Parm_Channel_Gain_Base_t;

#define TSC_Parm_Channel_Gain	0x180030	/* 1572912 */
typedef	Int32	TSC_Parm_Channel_Gain_t;

#define TSC_Parm_Channel_Gain_Adjust	0x180034	/* 1572916 */
typedef	Int32	TSC_Parm_Channel_Gain_Adjust_t;

#define TSC_Parm_Channel_Gain_Min	0x180038	/* 1572920 */
typedef	Int32	TSC_Parm_Channel_Gain_Min_t;

#define TSC_Parm_Channel_Gain_Max	0x18003c	/* 1572924 */
typedef	Int32	TSC_Parm_Channel_Gain_Max_t;

#define TSC_Parm_EnableAlarmReport	0x380040	/* 3670080 */
typedef	UInt32	TSC_Parm_EnableAlarmReport_t;

#define TSC_Parm_NumberOfStations	0x380044	/* 3670084 */
typedef	UInt32	TSC_Parm_NumberOfStations_t;


typedef struct {
	UInt32	LineId;
	UInt32	BearerChanSet;
	UInt32	BearerChanId;
	UInt32	ProtocolBase;
	UInt32	InboundVariantId;
	UInt32	OutboundVariantId;
	UInt32	AdminGroup;
	UInt32	SlotId;
	UInt32	Encoding;
	UInt32	DynamicResourceLoading;
	UInt32	ClearChannel;
	Int32	Channel_Gain_Base;
	Int32	Channel_Gain;
	Int32	Channel_Gain_Adjust;
	Int32	Channel_Gain_Min;
	Int32	Channel_Gain_Max;
	UInt32	EnableAlarmReport;
	UInt32	NumberOfStations;
} TSC_Parm_t;

#define TSC_Parm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 18, &(offset),	\
			(TSC_Parm_LineId), &((structAddr)->LineId),	\
			(TSC_Parm_BearerChanSet), &((structAddr)->BearerChanSet),	\
			(TSC_Parm_BearerChanId), &((structAddr)->BearerChanId),	\
			(TSC_Parm_ProtocolBase), &((structAddr)->ProtocolBase),	\
			(TSC_Parm_InboundVariantId), &((structAddr)->InboundVariantId),	\
			(TSC_Parm_OutboundVariantId), &((structAddr)->OutboundVariantId),	\
			(TSC_Parm_AdminGroup), &((structAddr)->AdminGroup),	\
			(TSC_Parm_SlotId), &((structAddr)->SlotId),	\
			(TSC_Parm_Encoding), &((structAddr)->Encoding),	\
			(TSC_Parm_DynamicResourceLoading), &((structAddr)->DynamicResourceLoading),	\
			(TSC_Parm_ClearChannel), &((structAddr)->ClearChannel),	\
			(TSC_Parm_Channel_Gain_Base), &((structAddr)->Channel_Gain_Base),	\
			(TSC_Parm_Channel_Gain), &((structAddr)->Channel_Gain),	\
			(TSC_Parm_Channel_Gain_Adjust), &((structAddr)->Channel_Gain_Adjust),	\
			(TSC_Parm_Channel_Gain_Min), &((structAddr)->Channel_Gain_Min),	\
			(TSC_Parm_Channel_Gain_Max), &((structAddr)->Channel_Gain_Max),	\
			(TSC_Parm_EnableAlarmReport), &((structAddr)->EnableAlarmReport),	\
			(TSC_Parm_NumberOfStations), &((structAddr)->NumberOfStations))


#define TSC_Parm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 18, &(offset),	\
			(TSC_Parm_LineId), &((structAddr)->LineId),	\
			(TSC_Parm_BearerChanSet), &((structAddr)->BearerChanSet),	\
			(TSC_Parm_BearerChanId), &((structAddr)->BearerChanId),	\
			(TSC_Parm_ProtocolBase), &((structAddr)->ProtocolBase),	\
			(TSC_Parm_InboundVariantId), &((structAddr)->InboundVariantId),	\
			(TSC_Parm_OutboundVariantId), &((structAddr)->OutboundVariantId),	\
			(TSC_Parm_AdminGroup), &((structAddr)->AdminGroup),	\
			(TSC_Parm_SlotId), &((structAddr)->SlotId),	\
			(TSC_Parm_Encoding), &((structAddr)->Encoding),	\
			(TSC_Parm_DynamicResourceLoading), &((structAddr)->DynamicResourceLoading),	\
			(TSC_Parm_ClearChannel), &((structAddr)->ClearChannel),	\
			(TSC_Parm_Channel_Gain_Base), &((structAddr)->Channel_Gain_Base),	\
			(TSC_Parm_Channel_Gain), &((structAddr)->Channel_Gain),	\
			(TSC_Parm_Channel_Gain_Adjust), &((structAddr)->Channel_Gain_Adjust),	\
			(TSC_Parm_Channel_Gain_Min), &((structAddr)->Channel_Gain_Min),	\
			(TSC_Parm_Channel_Gain_Max), &((structAddr)->Channel_Gain_Max),	\
			(TSC_Parm_EnableAlarmReport), &((structAddr)->EnableAlarmReport),	\
			(TSC_Parm_NumberOfStations), &((structAddr)->NumberOfStations))


#define TSC_Parm_Size		72

#define TSC_Parm	0x1205	/* 4613 */
/* 
 * TSC Standard Attribute values 
 */

#define TSC_DIALOGIC	0x1	/* 1 */
/* 
 * Identifier that uniquely identifies the component type (e.g. the 
 * vendor that provides the component).
 */

#define TSC_Std_ComponentType	0x12	/* 18 */
/* Component Type.  Identifies component. */
/* 
 * TSC Cluster Attributes 
 */
/* 
 * Cluster attribute indicating the Network Line that the TSP cluster 
 * is associated with.  Values [1-4].
 */

#define TSC_AttrLineId	0x1200	/* 4608 */
typedef	QCompAttr	TSC_AttrLineId_t;
/* 
 * Cluster attribute indicating the Bearer Channel that the TSP 
 * cluster is associated with.  The Bearer Channel is relative to the 
 * Line Id. Values [0-255].  Note that the actual bearer channel Id 
 * assigned to a particular TSP cluster is arbitray and part of the 
 * client-based configuration in bearer channel set definitions.
 */

#define TSC_AttrChanId	0x1201	/* 4609 */
typedef	QCompAttr	TSC_AttrChanId_t;
/* 
 * The Administration group assigned to the channel during 
 * configuration.  This id is set via the AdminGroup field of the 
 * Bearer Channel Set definition message, and also via SetParm. 
 */

#define TSC_AttrAdminGroup	0x1202	/* 4610 */
typedef	QCompAttr	TSC_AttrAdminGroup_t;
/* 
 * The base protocol the cluster is executing.  This is one of 
 * TSC_ParmProtocolBase_T1_CAS, 
 * TSC_ParmProtocolBase_ISDN,
 * TSC_ParmProtocolBase_BRI_ISDN, 
 * TSC_ParmProtocolBase_H323,
 * TSC_ParmProtocolBase_R2MFC, 
 * TSC_ParmProtocolBase_IS95,
 * TSC_ParmProtocolBase_IS131.
 */

#define TSC_AttrProtocolBase	0x1203	/* 4611 */
typedef	QCompAttr	TSC_AttrProtocolBase_t;
/* 
 * Cluster attribute indicating the physical timeslot that the TSP 
 * cluster is associated with.  The timeslot is relative to the Line Id. 
 * Values [1-31].
 */

#define TSC_AttrSlotId	0x1204	/* 4612 */
typedef	QCompAttr	TSC_AttrSlotId_t;

#define TSC_RTC_Label	0x380000	/* 3670016 */
typedef	UInt32	TSC_RTC_Label_t;

#define TSC_RTC_Action_Min	0x1	/* 1 */

#define TSC_RTC_Action_DropCall	0x1	/* 1 */

#define TSC_RTC_Action_ChanOOSImmediate	0x2	/* 2 */

#define TSC_RTC_Action_ChanOOSFinishCalls	0x3	/* 3 */

#define TSC_RTC_Action_ReleaseCall	0x4	/* 4 */

#define TSC_RTC_Action_Max	0x5	/* 5 */

#define TSC_RTC_Action	0x380004	/* 3670020 */
typedef	UInt32	TSC_RTC_Action_t;

/*
 * TSC_RTC (value = generic) is a message
 * for component TSC.
 */


typedef struct {
	UInt32	Label;
	UInt32	Action;
} TSC_RTC_t;

#define TSC_RTC_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_RTC_Label), &((structAddr)->Label),	\
			(TSC_RTC_Action), &((structAddr)->Action))


#define TSC_RTC_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_RTC_Label), &((structAddr)->Label),	\
			(TSC_RTC_Action), &((structAddr)->Action))


#define TSC_RTC_Size		8

#define TSC_KVSet_Key_NULL	0	/* 0 */

#define TSC_KVSet_Key_IE	0x1201	/* 4609 */

#define TSC_KVSet_Key_CallInfo	0x1202	/* 4610 */

#define TSC_KVSet_Key_VariantParm	0x1203	/* 4611 */

#define TSC_KVSet_Key_EndOfDigits	0x1204	/* 4612 */

#define TSC_KVSet_Key	0x380000	/* 3670016 */
typedef	UInt32	TSC_KVSet_Key_t;

#define TSC_KVSet_Length	0x380004	/* 3670020 */
typedef	UInt32	TSC_KVSet_Length_t;

#define TSC_KVSet_varStart	0x8

#define TSC_KVSet_Value	0x200000	/* 2097152 */
typedef	UInt8	TSC_KVSet_Value_t;


typedef struct {
	UInt32	Key;
	UInt32	Length;
} TSC_KVSet_t;

#define TSC_KVSet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_KVSet_Key), &((structAddr)->Key),	\
			(TSC_KVSet_Length), &((structAddr)->Length))


#define TSC_KVSet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_KVSet_Key), &((structAddr)->Key),	\
			(TSC_KVSet_Length), &((structAddr)->Length))


#define TSC_KVSet_Size		8

#define TSC_KVSet	0x1206	/* 4614 */
/* Information Element Identifier */

#define TSC_IE_Id	0x200000	/* 2097152 */
typedef	UInt8	TSC_IE_Id_t;
/*  Length of IE data section */

#define TSC_IE_Length	0x200001	/* 2097153 */
typedef	UInt8	TSC_IE_Length_t;

#define TSC_IE_varStart	0x2
/* Contents of Information Element */

#define TSC_IE_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_IE_Data_t;


typedef struct {
	UInt8	Id;
	UInt8	Length;
} TSC_IE_t;

#define TSC_IE_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_IE_Id), &((structAddr)->Id),	\
			(TSC_IE_Length), &((structAddr)->Length))


#define TSC_IE_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_IE_Id), &((structAddr)->Id),	\
			(TSC_IE_Length), &((structAddr)->Length))


#define TSC_IE_Size		2

#define TSC_IE	0x1207	/* 4615 */
/* Variant Parameter Identifier */

#define TSC_VariantParm_Id	0x380000	/* 3670016 */
typedef	UInt32	TSC_VariantParm_Id_t;
/* MDL Data Type definition for Data section */

#define TSC_VariantParm_Type	0x300004	/* 3145732 */
typedef	UInt24	TSC_VariantParm_Type_t;

#define TSC_VariantParm_varStart	0x7
/* Placeholder for parameter value */

#define TSC_VariantParm_Data	0x200000	/* 2097152 */
typedef	UInt8	TSC_VariantParm_Data_t;


typedef struct {
	UInt32	Id;
	UInt24	Type;
} TSC_VariantParm_t;

#define TSC_VariantParm_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(TSC_VariantParm_Id), &((structAddr)->Id),	\
			(TSC_VariantParm_Type), &((structAddr)->Type))


#define TSC_VariantParm_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(TSC_VariantParm_Id), &((structAddr)->Id),	\
			(TSC_VariantParm_Type), &((structAddr)->Type))


#define TSC_VariantParm_Size		7

#define TSC_VariantParm	0x1208	/* 4616 */

#ifndef defined_CallInfo
#define defined_CallInfo

/* Call Information Identifier fields */
#define CIDF_TYPE	0xFF000000	/* ID Type field in identifier	*/
#define CIDT_UINT	0x01000000	/* Identifier for uint values		*/
#define CIDT_STRING	0x02000000	/* Identifier for String values	*/

/* Enumeration of values for Call Information identifiers */
typedef enum {
	CIDV_NULL = 0x00, 
	CIDV_BearerChanId = 0x01,
	CIDV_CalledId,
	CIDV_CalledIdType,
	CIDV_CalledIdCategory,
	CIDV_CalledSubId, 
	CIDV_CalledSubIdType, 
	CIDV_CallerId,
	CIDV_CallerIdType,
	CIDV_CallerIdCategory,
	CIDV_CallerSubId, 
	CIDV_CallerSubIdType,
	CIDV_Charge,
	CIDV_ChargeType,
	CIDV_Display,
	CIDV_Language,
	CIDV_LineId,
	CIDV_Origin,
	CIDV_Rate,
	CIDV_Reason,
	CIDV_RedirectedId,
	CIDV_RedirectedIdType,
	CIDV_RedirectingId,
	CIDV_RedirectingIdType,
	CIDV_CallAnalysis,
	CIDV_InfoTransferCap, 
	CIDV_InfoTransferRate, 
	CIDV_Layer1Protocol, 
	CIDV_Facility,
	CIDV_FacilityIE,
	CIDV_CallerIdPlan,
	CIDV_CalledIdPlan, 
	CIDV_RedirectedIdPlan, 
	CIDV_RedirectingIdPlan, 
	CIDV_UUI,
	CIDV_TxCoder,
	CIDV_RxCoder,
	CIDV_PhoneList,
	CIDV_CallDurationTime,
	CIDV_RTCPInfo,
	CIDV_NonStdParm,
	CIDV_VendorInfo, 
	CIDV_CallReference,

/* FSK Caller ID Support fields*/
	CIDV_CallerName,
	CIDV_DateTime,
	CIDV_CallerNumberAbsenceReason,
    CIDV_CallerNameAbsenceReason,
	CIDV_PublicMsg,
	CIDV_VisualIndicator,
	CIDV_CallQualifier,
	CIDV_RedirectReason,
	CIDV_CallerIdExtended,
	CIDV_DDId,
	CIDV_DDIdExtended,
	CIDV_OriginalCallerId,
	CIDV_OriginalCallerIdExtended,
/* End FSK Caller ID Support GIRISH 01/04/1999 */ 
 
	CIDV_DTMFDiscarded,
	CIDV_LostPackets,
	CIDV_Jitter,
	CIDV_RoundTripLatency,
	CIDV_ConferenceID,
	CIDV_ConferenceGoal,
	CIDV_IPOnly,
	CIDV_Detected_SigId,

	CIDV_MAX	/* End Sentinel.  Put new identifiers before this */
} E_CID_values;

/* Macro to build Call Info Identifier (CallInfo_IDENTIFIER) */
#define DEF_CallInfo(Type, Name)	CallInfo_##Name = (CIDT_##Type | CIDV_##Name)

/* Call information identifers */
typedef enum {
	CallInfo_NULL=CIDV_NULL,
	DEF_CallInfo(UINT,	BearerChanId),
	DEF_CallInfo(STRING,	CalledId),
	DEF_CallInfo(UINT,	CalledIdType),
	DEF_CallInfo(UINT,	CalledIdCategory),
	DEF_CallInfo(STRING,	CalledSubId),
	DEF_CallInfo(UINT,	CalledSubIdType),
	DEF_CallInfo(STRING,	CallerId),
	DEF_CallInfo(UINT,	CallerIdType),
	DEF_CallInfo(UINT,	CallerIdCategory),
	DEF_CallInfo(STRING,	CallerSubId),
	DEF_CallInfo(UINT,	CallerSubIdType),
	DEF_CallInfo(UINT,	Charge),
	DEF_CallInfo(UINT,	ChargeType),
	DEF_CallInfo(STRING,	Display),
	DEF_CallInfo(UINT,	Language),
	DEF_CallInfo(UINT,	LineId),
	DEF_CallInfo(UINT,	Origin),
	DEF_CallInfo(UINT,	Rate),
	DEF_CallInfo(UINT,	Reason),
	DEF_CallInfo(STRING,	RedirectedId),
	DEF_CallInfo(UINT,	RedirectedIdType),
	DEF_CallInfo(STRING,	RedirectingId),
	DEF_CallInfo(UINT,	RedirectingIdType),
	DEF_CallInfo(UINT,	CallAnalysis),
	DEF_CallInfo(UINT,	InfoTransferCap),
	DEF_CallInfo(UINT,	InfoTransferRate),
	DEF_CallInfo(UINT,	Layer1Protocol), 
	CallInfo_Facility = CIDV_Facility, 
	CallInfo_FacilityIE = CIDV_FacilityIE,
	CallInfo_CalledIdPlan = CIDV_CalledIdPlan,
	CallInfo_CallerIdPlan = CIDV_CallerIdPlan,
	CallInfo_RedirectedIdPlan = CIDV_RedirectedIdPlan,
	CallInfo_RedirectingIdPlan = CIDV_RedirectingIdPlan,
 
	/* NetTSC VoIP call information identifiers */
	CallInfo_UUI=CIDV_UUI,
	CallInfo_TxCoder=CIDV_TxCoder,
	CallInfo_RxCoder=CIDV_RxCoder,
	CallInfo_PhoneList=CIDV_PhoneList,
	CallInfo_CallDurationTime=CIDV_CallDurationTime,
	CallInfo_RTCPInfo=CIDV_RTCPInfo, 
	CallInfo_NonStdParm = CIDV_NonStdParm,
	CallInfo_VendorInfo = CIDV_VendorInfo,
	DEF_CallInfo(UINT,	CallReference),

      /* FSK Caller ID  Support  fields. */
	DEF_CallInfo(STRING,	CallerName),
   	DEF_CallInfo(STRING,	DateTime),
	DEF_CallInfo(UINT,	CallerNumberAbsenceReason),
	DEF_CallInfo(UINT,	CallerNameAbsenceReason),
	DEF_CallInfo(STRING,	PublicMsg),
	DEF_CallInfo(UINT,	VisualIndicator),
	DEF_CallInfo(UINT,	CallQualifier),
	DEF_CallInfo(UINT,	RedirectReason),
	DEF_CallInfo(STRING,	CallerIdExtended),
	DEF_CallInfo(STRING,	DDId),
	DEF_CallInfo(STRING,	DDIdExtended),
	DEF_CallInfo(STRING,	OriginalCallerId),
	DEF_CallInfo(STRING,	OriginalCallerIdExtended),
	DEF_CallInfo(UINT,	Detected_SigId), /* [GSK]+ MsgDial 5/4/00 Corrected , brought 1/3/1*/

	/* NetTSC VoIP QoS information identifiers */
	CallInfo_QoSDTMFDiscarded = CIDV_DTMFDiscarded,
	CallInfo_QoSLostPackets = CIDV_LostPackets,
	CallInfo_QoSJitter = CIDV_Jitter,
	CallInfo_QoSRoundTripLatency,
	CallInfo_ConferenceID = CIDV_ConferenceID,
	CallInfo_ConferenceGoal = CIDV_ConferenceGoal,
	CallInfo_IPOnly = CIDV_IPOnly,
	CallInfo_Max = CIDV_MAX	/* Max call info id.  Put new ids before this. */
} E_CallInfo;

#undef DEF_CID
#endif


#ifndef defined_CallState
#define defined_CallState

/* Call State Values */
typedef enum {
	CallState_Null = 0, 
	CallState_Accepted,
	CallState_Connected,
	CallState_ConnectedPendXfer,
	CallState_Delivered,
	CallState_Dialing,
	CallState_Disconnected,
	CallState_DialReady,
	CallState_Failed,
	CallState_Idle,
	CallState_Initiated,
	CallState_Offered,
	CallState_Hold,
	CallState_HoldPendXfer,
	CallState_Originated,
	CallState_Proceeding,
	CallState_Unknown, 
	CallState_Alerting,
    CallState_IncomingProceeding,
/* New Callstates Added [Ci]+ and [GSK]+ */
	CallState_Rejected,
	CallState_Detected,
	CallState_DialTone,
	CallState_Max	/* Max call state.  Put new states before this. */
} E_CallState;
#endif


#ifndef defined_CallStateR
#define defined_CallStateR

/* Call State Reason values */
typedef enum {
	CallStateR_Busy = 0x01,
	CallStateR_CallCompletion,
	CallStateR_Canceled,
	CallStateR_Congestion,
	CallStateR_DestBusy,
	CallStateR_DestAddrBad,
	CallStateR_DestOutOfOrder,
	CallStateR_DestUnobtainable,
	CallStateR_Forward,
	CallStateR_Incompatible,
	CallStateR_IncomingCall,
	CallStateR_NewCall,
	CallStateR_NoAnswer,
	CallStateR_Normal,
	CallStateR_NetworkAlarm,
	CallStateR_PickUp,
	CallStateR_ProtocolError,
	CallStateR_Redirection,
	CallStateR_RemoteTermination,
	CallStateR_Rejection,
	CallStateR_SIT,
	CallStateR_SITCustIrreg,
	CallStateR_SITNoCircuit,
	CallStateR_SITReorder,
	CallStateR_Transfer,
	CallStateR_Unavailable,
	CallStateR_Unknown,
	CallStateR_UnallocatedNumber,
	CallStateR_NoRoute,
	CallStateR_NumberChanged,
	CallStateR_OutOfOrder,
	CallStateR_InvalidFormat,
	CallStateR_ChanUnavailable, 
	CallStateR_ChanUnacceptable,
	CallStateR_ChanNotImplemented,
	CallStateR_NoChan,
	CallStateR_NoResponse,
	CallStateR_FacilityNotSubscribed,
	CallStateR_FacilityNotImplemented,
	CallStateR_ServiceNotImplemented,
	CallStateR_BarredInbound,
	CallStateR_BarredOutbound,
	CallStateR_DestIncompatible,
	CallStateR_BearerCapUnavailable,
	CallStateR_NormalUnspecified,
	CallStateR_ReqTimedout,
	CallStateR_RemoteRetrieve,
	CallStateR_RemoteReconnect,
	CallStateR_LocalTimeout,
	CallStateR_Ack,
	CallStateR_Max			/* End marker */
} E_CallStateReason;
#endif


#ifndef defined_ChanState
#define defined_ChanState

/* Channel State values */
typedef enum {
	ChanState_Active = 0x01,
	ChanState_ActivePending,
	ChanState_Alarm,
	ChanState_OutOfService,
	ChanState_Maintenance,
	ChanState_OutOfServiceLocal,
	ChanState_MaintenanceLocal,
	ChanState_Idle,
	ChanState_IdlePending,
	ChanState_Null, 
	ChanState_FinishingCalls, 
	ChanState_Unknown,
	ChanState_OutOfServiceMediaDetached,
	ChanState_OutOfServiceRemote,
	ChanState_Max	/* Max chan state.  Put new states before this. */
} E_ChanState;
#endif


#ifndef defined_RunTimeAnalog
#define defined_RunTimeAnalog

#define TSC_ANALOG_DISABLE_TONE_DISCONNECT_SUPERVISION 	 	0x00000001
#define TSC_ANALOG_ENABLE_TONE_DISCONNECT_SUPERVISION		0x80000001
#define TSC_ANALOG_DISABLE_DIAL_TONE_DETECTION			0x00000002
#define TSC_ANALOG_ENABLE_DIAL_TONE_DETECTION			0x80000002


#endif


#define TSC_ErrNone	0	/* 0 */

#define TSC_ErrUnknownMsg	0x1200	/* 4608 */
/* 
 * This error indicates that the call identifier specified for a particular 
 * command was not valid.  No call matching the call identifier exists on 
 * the TSC Instance that received the command.
 */

#define TSC_ErrCallIdentifier	0x1201	/* 4609 */
/*
 * This error indicates that the call state is not valid for the requested 
 * operation that.
 */

#define TSC_ErrCallState	0x1202	/* 4610 */
/* 
 * Channel state is not valid for the operation (e.g., there is an active call 
 * on the channel). 
 */

#define TSC_ErrChanState	0x1203	/* 4611 */
/* 
 * This error indicates that the command can not be completed as there 
 * are no resources available. 
 */

#define TSC_ErrExhausted	0x1204	/* 4612 */
/* 
 * The specified identifier is already in use. 
 */

#define TSC_ErrIdentifierInUse	0x1205	/* 4613 */

#define TSC_ErrNotEnabled	0x1206	/* 4614 */
/*
 * A system error has occurred.
 */

#define TSC_ErrSystem	0x1207	/* 4615 */
/*
 * The Call Operation is not supported.
 */

#define TSC_ErrUnsupportedOp	0x1208	/* 4616 */
/* 
 * This error reports that the Protocol Variant identifier provided for the 
 * operation is invalid (undefined) 
 */

#define TSC_ErrVariantId	0x1209	/* 4617 */
/* 
 * The TSC received a Std_MsgInit message and it was not in the 
 * initialization state (i.e. already done Std_MsgInit).
 */

#define TSC_ErrNotInitState	0x120a	/* 4618 */
/*
 * An invalid, message specific, identifier was specified. 
 */

#define TSC_ErrIdentifier	0x120b	/* 4619 */
/* 
 * Too many channels specified in the Bearer Channel Set.  Cannot define 
 * more channels than can be supported by a line. 
 */

#define TSC_ErrChannelRange	0x120c	/* 4620 */
/*
 * An invalid, message specific, parameter value was specified. 
 */

#define TSC_ErrBadParm	0x120d	/* 4621 */
/* 
 * A client attempted to write (Std_MsgSetParm) a read-only parameter. 
 */

#define TSC_ErrReadOnly	0x120e	/* 4622 */
/* 
 * A client attempted to read (Std_MsgGetParm) a write-only parameter. 
 */

#define TSC_ErrWriteOnly	0x120f	/* 4623 */
/*
 * The key value set specified is not supported by the command. 
 */

#define TSC_ErrKVSetNotSupported	0x1210	/* 4624 */
/*
 * This value specifies that the message IE is either too long or there's too 
 * many KVSets in the call setup message.
 */

#define TSC_ErrMsgTooLong	0x1211	/* 4625 */
/* 
 * The module ID specified for a Load or Unload operation is invalid.
 */

#define TSC_ErrModuleIdInvalid	0x1212	/* 4626 */
/* 
 * The module failed to start. 
 */

#define TSC_ErrModuleStartFailed	0x1213	/* 4627 */
/* The module failed to exit. Unload operation failed. */

#define TSC_ErrModuleExitFailed	0x1214	/* 4628 */
/* 
 * No module is registered for the specified module ID.
 */

#define TSC_ErrModuleNotRegistered	0x1215	/* 4629 */
/* Unable to load the module because it is already loaded */

#define TSC_ErrModuleAlreadyLoaded	0x1216	/* 4630 */
/* Unable to unload the module because it is already unloading */

#define TSC_ErrModuleUnloading	0x1217	/* 4631 */
/* 
 * Unable to load the module because the memSize in the Load message 
 * does not match the memSize that the module was registered with. 
 */

#define TSC_ErrModuleSizeIncorrect	0x1218	/* 4632 */
/*
 * Error  Failed to allocate a component - CAS.
 */

#define TSC_ErrCASAlloc	0x1219	/* 4633 */
/*
 * Error  Failed to allocate a component - CallerId.
 */

#define TSC_ErrCallerIdAlloc	0x121a	/* 4634 */
/*
 * Error  Failed to allocate a component - SignalDetector.
 */

#define TSC_ErrSignalDetectorAlloc	0x121b	/* 4635 */
/*
 * Error  Failed to allocate a component - SignalBufferDtmf.
 */

#define TSC_ErrSignalBufferDtmfAlloc	0x121c	/* 4636 */
/*
 * Error  Failed to allocate a component - SignalBufferMf.
 */

#define TSC_ErrSignalBufferMfAlloc	0x121d	/* 4637 */
/*
 * Error  Failed to allocate a component - Tonegen.
 */

#define TSC_ErrTonegenAlloc	0x121e	/* 4638 */
/*
 * Error  Failed to release a component - CAS.
 */

#define TSC_ErrCASRelease	0x121f	/* 4639 */
/*
 * Error  Failed to release a component - SignalDetector.
 */

#define TSC_ErrSignalDetectorRelease	0x1220	/* 4640 */
/*
 * Error  Failed to release a component - SignalBufferDtmf.
 */

#define TSC_ErrSignalBufferDtmfRelease	0x1221	/* 4641 */
/*
 * Error  Failed to release a component - SignalBufferMf.
 */

#define TSC_ErrSignalBufferMfRelease	0x1222	/* 4642 */
/*
 * Error  Failed to release a component - Tonegen.
 */

#define TSC_ErrTonegenRelease	0x1223	/* 4643 */
/* 
 * Error  unable to send message due to transport failure (e.g. inter-
 * board message failed because destination board does not exist)
 */

#define TSC_ErrUndelivered	0x1224	/* 4644 */
/* 
 * Error  unable to send message due to Feature being disabled in the 
 * firmware.
 */

#define TSC_ErrFeatureDisabled	0x1225	/* 4645 */
/* 
 * Error  All media component instances that the TSP needs for call 
 * control have not been attached via the TSC_MsgAttach message.
 */

#define TSC_ErrMediaMissing	0x1226	/* 4646 */
/* 
 * Error  unable to detach media component instances or attach new 
 * ones since the previously attached media instances are currently being 
 * used by the TSP for call control of the current call. This error will be 
 * implemented in the next phase of the TOC/ROC feature.
 */

#define TSC_ErrMediaInUse	0x1227	/* 4647 */
/* 
 * The module has already been started. 
 */

#define TSC_ErrModuleAlreadyStarted	0x1228	/* 4648 */
/* 
 * The module has not been loaded 
 */

#define TSC_ErrModuleNotLoaded	0x1229	/* 4649 */
/* 
 * Error -- unable to complete operation because no protocol is defined 
 * for that channel.
 */

#define TSC_ErrNoProtocol	0x122a	/* 4650 */
/* 
 * Error  The requested call information is not available.
 */

#define TSC_ErrCallInfoUnavailable	0x122b	/* 4651 */
/* 
 * Error  The protocol failed to respond.
 */
/* 
 * End of all Mercury TSC Component Definitions 
 */

#define TSC_ErrProtocolResponseFailed	0x122c	/* 4652 */

#define TSC	0x12	/* 18 */

typedef struct {
	UInt32		ParmBearerChanId;
	UInt32		ParmBearerChanSet;
	UInt32		ParmLineId;
	UInt32		ParmProtocolBase;
	UInt32		ParmInboundVariantId;
	UInt32		ParmOutboundVariantId;
	UInt32		ParmAdminGroup;
	UInt32		ParmSlotId;
	UInt32		ParmDebugLevel;
	UInt32		ParmEncoding;
	UInt32		ParmDynamicResourceLoading;
	UInt32		ParmClearChannel;
	Int32		ParmChannel_Gain_Base;
	Int32		ParmChannel_Gain;
	Int32		ParmChannel_Gain_Adjust;
	Int32		ParmChannel_Gain_Min;
	Int32		ParmChannel_Gain_Max;
	UInt32		ParmEnableAlarmReport;
	UInt32		ParmNumberOfStations;
	Int32		ParmTxChannel_Gain_Base;
	Int32		ParmTxChannel_Gain;
	Int32		ParmTxChannel_Gain_Adjust;
	Int32		ParmTxChannel_Gain_Min;
	Int32		ParmTxChannel_Gain_Max;
	Int32		ParmRxChannel_Gain_Base;
	Int32		ParmRxChannel_Gain;
	Int32		ParmRxChannel_Gain_Adjust;
	Int32		ParmRxChannel_Gain_Min;
	Int32		ParmRxChannel_Gain_Max;
	Int32		ParmRxChannel_Onhook_Gain;
	UInt32		ParmRunTimeAnalogConfig;
	UInt32		ParmSetProtocolTrace;

} TSCparm_t;

#if defined ( TSC_DEFINED )

ParmStruct TSCParmTab []= {
{TSC_ParmBearerChanId, 32, 0, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmBearerChanId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmBearerChanSet), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmLineId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmProtocolBase), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmInboundVariantId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmOutboundVariantId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmAdminGroup), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmSlotId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmDebugLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmEncoding), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmDynamicResourceLoading), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmClearChannel), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmChannel_Gain_Base), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmChannel_Gain), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmChannel_Gain_Adjust), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmChannel_Gain_Min), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmChannel_Gain_Max), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmEnableAlarmReport), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmNumberOfStations), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmTxChannel_Gain_Base), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmTxChannel_Gain), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmTxChannel_Gain_Adjust), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmTxChannel_Gain_Min), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmTxChannel_Gain_Max), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmRxChannel_Gain_Base), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmRxChannel_Gain), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmRxChannel_Gain_Adjust), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmRxChannel_Gain_Min), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmRxChannel_Gain_Max), PARM_READWRITE, 0, 0, 0},
 {0x180000, offsetof(TSCparm_t, ParmRxChannel_Onhook_Gain), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmRunTimeAnalogConfig), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(TSCparm_t, ParmSetProtocolTrace), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_tscdefs_h_) */
