/****************************************************************************
 *		Copyright (c) 2000 Dialogic Corp., an Intel Company.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:			tsp_tsclocations.h
 * AUTHOR:		DM3 TSP Team
 * ORG:			Dialogic Corporation
 * ORIG-DATE:	11-Apr-00
 * LAST-MOD:	11-Apr-00 at 18:28:51 by Darran Hunt
 * PURPOSE:		This header file contains the location tags and error
 *					strings for the qError reports in the tsccomp.c file.
 *					(Part of the TSC component for CAS protocols).
 *
 * HISTORY:
 * Date			Who	Description
 * 04-Feb-02   PJS   Changed name of header file to accomodate for flattened
 *                   header file structure required for all components.
 * 11-Apr-00	DNH	Initial version based on Rev 0.7 of the qError 
 *							API Users Guide.
 *							
 ***************************************************************************/

/* Multiple include protection */
#ifndef _tsp_tsclocations_h_
#define _tsp_tsclocations_h_

#ifdef __cplusplus
extern "C" {
#endif

#define TSC_LOC_0001 0x800101	/* TSC:tsccomp.c getsdlpid - instance %d out of range (max=%d) */
#define TSC_LOC_0002 0x800102	/* TSC:tsccomp.c getsdlpid - instance %d not registered */
#define TSC_LOC_0003 0x800103	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0004 0x800104	/* TSC:tsccomp.c qCompAllocate failed */
#define TSC_LOC_0005 0x800105	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0006 0x800106	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0007 0x800107	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0008 0x800108	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0009 0x800109	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0010 0x80010a	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0011 0x80010b	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0012 0x80010c	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0013 0x80010d	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0014 0x80010e	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0015 0x80010f	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0016 0x800110	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0017 0x800111	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0018 0x800112	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0019 0x800113	/* TSC:tsccomp.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0020 0x800114	/* TSC:tsccomp.c DetectxEvts - more than %d events requested */
#define TSC_LOC_0021 0x800115	/* TSC:tsccomp.c DetectxEvts - qMsgVarFieldPut failed */
#define TSC_LOC_0022 0x800116	/* TSC:tsccomp.c DetectxEvts - label != transaction */
#define TSC_LOC_0023 0x800117	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0024 0x800118	/* TSC:tsccomp.c LineMgt - Failed to find LineAdmin, qErrNo=0x%x */
#define TSC_LOC_0025 0x800119	/* TSC:tsccomp.c Failed to register instances, qErrNo=0x%x */
#define TSC_LOC_0026 0x80011a	/* TSC:tsccomp.c tscStdMsgInit - tscGetParm(Encoding) failed */
#define TSC_LOC_0027 0x80011b	/* TSC:tsccomp.c tscStdMsgInit - tscGetParm(ProtocolBase) failed */
#define TSC_LOC_0028 0x80011c	/* TSC:tsccomp.c tscStdMsgInit - tscGetParm(InboundVarId) failed */
#define TSC_LOC_0029 0x80011d	/* TSC:tsccomp.c tscStdMsgInit - tscGetParm(OutboundVarId) failed */
#define TSC_LOC_0030 0x80011e	/* TSC:tsccomp.c qClusterCreate failed, qErrNo=0x%x */
#define TSC_LOC_0031 0x80011f	/* TSC:tsccomp.c Failed to allocate TSC.%d, qErrNo=0x%x */
#define TSC_LOC_0032 0x800120	/* TSC:tsccomp.c tscStdMsgInit - tscGetParm(ProtocolBase) failed */
#define TSC_LOC_0033 0x800121	/* TSC:tsccomp.c qClusterCreate failed, qErrNo=0x%x */
#define TSC_LOC_0034 0x800122	/* TSC:tsccomp.c Failed to allocate TSC.%d, qErrNo=0x%x */
#define TSC_LOC_0035 0x800123	/* TSC:tsccomp.c defineBSet - Too many channels, max=%d - see fcd */
#define TSC_LOC_0036 0x800124	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0037 0x800125	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0038 0x800126	/* TSC:tsccomp.c tscGetParm(NumInstances) failed */
#define TSC_LOC_0039 0x800127	/* TSC:tsccomp.c Failed to find CHP, qErrNo = 0x%x */
#define TSC_LOC_0040 0x800128	/* TSC:tsccomp.c Received too many Std_MsgInitCmplts */
#define TSC_LOC_0041 0x800129	/* TSC:tsccomp.c LCON_MsgGetAlarms VarFieldPut failed */
#define TSC_LOC_0042 0x80012a	/* TSC:tsccomp.c Received too many Std_MsgInitCmplts */
#define TSC_LOC_0043 0x80012b	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0044 0x80012c	/* TSC:tsccomp.c qMsgWrite failed - dest = %x.%x.%x.%x */
#define TSC_LOC_0045 0x80012d	/* TSC:tsccomp.c qCompRegister failed, qErrNo=0x%x */
#define TSC_LOC_0046 0x80012e	/* TSC:tsccomp.c Failed to create TSC RTC pool, qErrNo=0x%x */
#define TSC_LOC_0047 0x80012f	/* TSC:tsccomp.c Failed to find TSC_ParmEncoding */
#define TSC_LOC_0048 0x800130	/* TSC:tsccomp.c qMsgRead failed, qErrNo=0x%x */
#define TSC_LOC_0049 0x800131	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0050 0x800132	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0051 0x800133	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0052 0x800134	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0053 0x800135	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0054 0x800136	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0055 0x800137	/* TSC:tsputils.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0056 0x800138	/* TSC:tspcallinfo.c TSC_Facility_put failed */
#define TSC_LOC_0057 0x800139	/* TSC:tspcallinfo.c TSC_Facility_Comp_put failed */
#define TSC_LOC_0058 0x80013a	/* TSC:tspcallinfo.c TSC_Facility_Element_put failed */
#define TSC_LOC_0059 0x80013b	/* TSC:tspcallinfo.c tspFacilityPut - qMsgVarFieldPut failed */
#define TSC_LOC_0060 0x80013c	/* TSC:tspcallinfo.c tspFacilityPut - Facility size greater than %d */
#define TSC_LOC_0061 0x80013d	/* TSC:tspcallinfo.c TSC_Facility_get failed */
#define TSC_LOC_0062 0x80013e	/* TSC:tspcallinfo.c TSC_Facility_Comp_get failed */
#define TSC_LOC_0063 0x80013f	/* TSC:tspcallinfo.c TSC_Facility_Element_get failed */
#define TSC_LOC_0064 0x800140	/* TSC:tspcallinfo.c tspFacilityGet - qMsgVarFieldGet failed */
#define TSC_LOC_0065 0x800141	/* TSC:tspcallinfo.c tspFacilityGet - Facility size greater than %d */
#define TSC_LOC_0066 0x800142	/* TSC:tspcallinfo.c TSC_CallInfo_put failed */
#define TSC_LOC_0067 0x800143	/* TSC:tspcallinfo.c tspCallInfoWriteBody - qMsgVarFieldPut failed */
#define TSC_LOC_0068 0x800144	/* TSC:tspcallinfo.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0069 0x800145	/* TSC:tspcallinfo.c qMsgWrite failed - dest instance = %x */
#define TSC_LOC_0070 0x800146	/* TSC:tspcallinfo.c qMsgAllocate failed - bufsize = %d */
#define TSC_LOC_0071 0x800148	/* TSC:tspcallinfo.c No more entries available in Call info Event table */
#define TSC_LOC_0072 0x800149	/* TSC:tspcallinfo.c ADT gu_T_CALLINFOEVENTS_add - out of RTC entries: event 0x%x */
#define TSC_LOC_0073 0x80014a	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0074 0x80014b	/* TSC:tsccomp.c Wrong Total Line count from Lineadmin component */
#define TSC_LOC_0075 0x80014c	/* TSC:tsccomp.c Received too many LCON_MsgConfigureLineCmplts */
#define TSC_LOC_0076 0x80014d	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0077 0x80014e	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0078 0x80014f	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0079 0x800150	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0080 0x800151	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0081 0x800152	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */
#define TSC_LOC_0082 0x800153	/* TSC:tsccomp.c qMemCalloc failed - bufsize = %d */


#ifdef __cplusplus
}
#endif

#endif		/* _tsp_tsclocations_h_ End multiple include protection */
