#ifndef _vad_def_h_
#define _vad_def_h_

#define VAD_MAX_FRAME_SIZE		30
#define VAD_STATE_SIZE			29
#define VAD_IDM_SIZE			68
#define VAD_MEM_SIZE			40  /* sizeof(VADMem_t) + 
									sizeof(PCMData_t) + frameSize * sizeof(int) */
#define Speech_Hang        63       /* offset in constants table */
#define EN_Speech_Hang     47
#define SpeechProb_Open    61
#define SpeechProb_Close   64
#define Nflor_LowThresh    33
#define Nflor_HighThresh   32

#define VAD_SPCH_HANG      200      /* default parm's value */
#define VAD_SPCH_HANG_EN   30
#define VAD_SPCH_PRO_OPEN  0x4a3d70
#define VAD_SPCH_PRO_CLOSE 0x31eb85
#define VAD_NFLOR_LOW      0x420
#define VAD_NFLOR_HIGH     0xccccc

typedef struct vad_state{
	int frameSize;					/* frame size in ms */
	int VarTbl[VAD_STATE_SIZE];
	void *pVADMem;
	void *pPCMData;
	void *pMemInt;
} VAD_STATE_t, *VAD_HANDLE_t;

void dlgc_vad_init();
void dlgc_vad_update_parm( int ParmName, int ParmValue);
void dlgc_vad_create(VAD_HANDLE_t handle, int frameSize, int *pMemEx, void *pMemInt);
int dlgc_vad_invoke(VAD_HANDLE_t handle, int *pPCMBuf);

#endif
