/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007-2013 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
* CHANGE HISTORY
* Date		Who	Task#			Description
* 05-Aug-2013 KY  CR46765  Support of unknown size video. Reinitialize the XCF decoder when a change in frame size is detected.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef __VIDEODEFS_H__
#define __VIDEODEFS_H__

#define VIDEODEFS_VERSION 1

typedef enum tagVIDEO_CODING
{
    VIDEO_CODING_H263               = 1,        /* H263 */
    VIDEO_CODING_H263_1998          = 2,
    VIDEO_CODING_MP4V_ES            = 3,        /* MPEG4 */
    VIDEO_CODING_H264               = 4,        /* H264 */
    VIDEO_CODING_DEFAULT            = VIDEO_CODING_H263,

    /* the enums below are for backwards compatibility */
    EMM_VIDEO_CODING_UNDEFINED      = 0,
    EMM_VIDEO_CODING_DEFAULT        = VIDEO_CODING_H263,
    EMM_VIDEO_CODING_H263           = VIDEO_CODING_H263,
    EMM_VIDEO_CODING_H263_1998      = VIDEO_CODING_H263_1998,
    EMM_VIDEO_CODING_MP4V_ES        = VIDEO_CODING_MP4V_ES,
    EMM_VIDEO_CODING_H264           = VIDEO_CODING_H264,
} eVIDEO_CODING, eMM_VIDEO_CODING;

typedef enum tagVIDEO_PROFILE
{
    VIDEO_PROFILE_0_H263            = 0,        /* H263 Profile 0 */
    VIDEO_PROFILE_1_H263            = 1,        /* H263 Profile 1 */
    VIDEO_PROFILE_2_H263            = 2,        /* H263 Profile 2 */
    VIDEO_PROFILE_3_H263            = 3,        /* H263 Profile 3 */
    VIDEO_PROFILE_4_H263            = 4,        /* H263 Profile 4 */
    VIDEO_PROFILE_5_H263            = 5,        /* H263 Profile 5 */
    VIDEO_PROFILE_6_H263            = 6,        /* H263 Profile 6 */
    VIDEO_PROFILE_7_H263            = 7,        /* H263 Profile 7 */
    VIDEO_PROFILE_8_H263            = 8,        /* H263 Profile 8 */
    VIDEO_PROFILE_9_H263            = 9,        /* H263 Profile 9 */
    VIDEO_PROFILE_LEVEL_SP0_MPEG4   = 0x08,     /* MPEG4 Simple Profile/Level 0 */
    VIDEO_PROFILE_LEVEL_SP1_MPEG4   = 0x01,     /* MPEG4 Simple Profile/Level 1 */
    VIDEO_PROFILE_LEVEL_SP2_MPEG4   = 0x02,     /* MPEG4 Simple Profile/Level 2 */
    VIDEO_PROFILE_LEVEL_SP3_MPEG4   = 0x03,     /* MPEG4 Simple Profile/Level 3 */
    VIDEO_PROFILE_LEVEL_ASP0_MPEG4  = 0xF0,     /* MPEG4 Advanced Simple Profile/Level 0 */
    VIDEO_PROFILE_LEVEL_ASP1_MPEG4  = 0xF1,     /* MPEG4 Advanced Simple Profile/Level 1 */
    VIDEO_PROFILE_LEVEL_ASP2_MPEG4  = 0xF2,     /* MPEG4 Advanced Simple Profile/Level 2 */
    VIDEO_PROFILE_LEVEL_ASP3_MPEG4  = 0xF3,     /* MPEG4 Advanced Simple Profile/Level 3 */
    VIDEO_PROFILE_LEVEL_ASP4_MPEG4  = 0xF4,     /* MPEG4 Advanced Simple Profile/Level 4 */
    VIDEO_PROFILE_LEVEL_ASP5_MPEG4  = 0xF5,     /* MPEG4 Advanced Simple Profile/Level 5 */
    VIDEO_PROFILE_LEVEL_ASP3B_MPEG4 = 0xF7,     /* MPEG4 Advanced Simple Profile/Level 3b */
    VIDEO_PROFILE_BASELINE_H264     = 66,       /* H264 Baseline Profile */
    VIDEO_PROFILE_DEFAULT           = VIDEO_PROFILE_0_H263,

    /* the enums below are for backwards compatibility */
    EMM_VIDEO_PROFILE_UNDEFINED     = 0,
    EMM_VIDEO_PROFILE_DEFAULT       = VIDEO_PROFILE_0_H263,
    EMM_VIDEO_PROFILE_0             = VIDEO_PROFILE_0_H263,
    EMM_VIDEO_PROFILE_1             = VIDEO_PROFILE_1_H263,
    EMM_VIDEO_PROFILE_2             = VIDEO_PROFILE_2_H263,
    EMM_VIDEO_PROFILE_3             = VIDEO_PROFILE_3_H263,
    EMM_VIDEO_PROFILE_4             = VIDEO_PROFILE_4_H263,
    EMM_VIDEO_PROFILE_5             = VIDEO_PROFILE_5_H263,
    EMM_VIDEO_PROFILE_6             = VIDEO_PROFILE_6_H263,
    EMM_VIDEO_PROFILE_7             = VIDEO_PROFILE_7_H263,
    EMM_VIDEO_PROFILE_8             = VIDEO_PROFILE_8_H263,
    EMM_VIDEO_PROFILE_9             = VIDEO_PROFILE_9_H263,
} eVIDEO_PROFILE, eMM_VIDEO_PROFILE;

typedef enum tagVIDEO_LEVEL
{
    VIDEO_LEVEL_10_H263             = 10,       /* H263 Level 10 */
    VIDEO_LEVEL_20_H263             = 20,       /* H263 Level 20 */
    VIDEO_LEVEL_30_H263             = 30,       /* H263 Level 30 */
    VIDEO_LEVEL_40_H263             = 40,       /* H263 Level 40 */
    VIDEO_LEVEL_45_H263             = 45,       /* H263 Level 45 */
    VIDEO_LEVEL_50_H263             = 50,       /* H263 Level 50 */
    VIDEO_LEVEL_60_H263             = 60,       /* H263 Level 60 */
    VIDEO_LEVEL_70_H263             = 70,       /* H263 Level 70 */

    VIDEO_LEVEL_1_H264              = 10,      /* H264 Level 1 */
    VIDEO_LEVEL_1_B_H264            = 9,      /* H264 Level 1b=9 */
    VIDEO_LEVEL_1_1_H264            = 11,      /* H264 Level 1.1 */
    VIDEO_LEVEL_1_2_H264            = 12,      /* H264 Level 1.2 */
    VIDEO_LEVEL_1_3_H264            = 13,      /* H264 Level 1.3 */
    VIDEO_LEVEL_2_0_H264            = 20,      /* H264 Level 2.0 */  
    VIDEO_LEVEL_2_1_H264            = 21,      /* H264 Level 2.1 */
    VIDEO_LEVEL_2_2_H264            = 22,      /* H264 Level 2.2 */ //vga 16fps
    VIDEO_LEVEL_3_0_H264            = 30,      /* H264 Level 3.0 */ //VGA 33fps
    VIDEO_LEVEL_3_1_H264            = 31,      /* H264 Level 3.0 */ //VGA 33fps

    VIDEO_LEVEL_DEFAULT             = VIDEO_LEVEL_10_H263,

    /* the enums below are for backwards compatibility */
    EMM_VIDEO_LEVEL_UNDEFINED       = 0,
    EMM_VIDEO_LEVEL_DEFAULT         = VIDEO_LEVEL_10_H263,
    EMM_VIDEO_LEVEL_10              = VIDEO_LEVEL_10_H263,
    EMM_VIDEO_LEVEL_20              = VIDEO_LEVEL_20_H263,
    EMM_VIDEO_LEVEL_30              = VIDEO_LEVEL_30_H263,
    EMM_VIDEO_LEVEL_40              = VIDEO_LEVEL_40_H263,
    EMM_VIDEO_LEVEL_45              = VIDEO_LEVEL_45_H263,
    EMM_VIDEO_LEVEL_50              = VIDEO_LEVEL_50_H263,
    EMM_VIDEO_LEVEL_60              = VIDEO_LEVEL_60_H263,
    EMM_VIDEO_LEVEL_70              = VIDEO_LEVEL_70_H263
} eVIDEO_LEVEL, eMM_VIDEO_LEVEL;


typedef enum tagVIDEO_IMAGE_WIDTH
{
    VIDEO_IMAGE_WIDTH_UNKNOWN       = 0,                   /* Size unknown (for API) */
    VIDEO_IMAGE_WIDTH_UNKNOWN_SIZE  = 99,                  /* Size unknown */

    VIDEO_IMAGE_WIDTH_128           = 128,                  /* Sub-QCIF */
    VIDEO_IMAGE_WIDTH_SQCIF         = 128,                  /* Sub-QCIF */
    VIDEO_IMAGE_WIDTH_176           = 176,                  /* QCIF */
    VIDEO_IMAGE_WIDTH_QCIF          = 176,                  /* QCIF */
    VIDEO_IMAGE_WIDTH_352           = 352,                  /* CIF */
    VIDEO_IMAGE_WIDTH_CIF           = 352,                  /* CIF */
    VIDEO_IMAGE_WIDTH_VGA           = 640,                  /* VGA */
    
    VIDEO_IMAGE_WIDTH_SQVGA         = 400,                  /* SQVGA */
    VIDEO_IMAGE_WIDTH_400           = 400,                  /* SQVGA */
    VIDEO_IMAGE_WIDTH_QVGA          = 320,                  /* QVGA */
    VIDEO_IMAGE_WIDTH_320           = 320,                  /* QVGA */
    VIDEO_IMAGE_WIDTH_WQVGA         = 432,                  /* WQVGA */
    VIDEO_IMAGE_WIDTH_432           = 432,                  /* WQVGA */
    VIDEO_IMAGE_WIDTH_W288P         = 512,                  /* W288p */
    VIDEO_IMAGE_WIDTH_512           = 512,                  /* W288p */
    
    VIDEO_IMAGE_WIDTH_NHD           = 640,                  /* NHD */
    VIDEO_IMAGE_WIDTH_448P          = 576,                  /* 448P */
    VIDEO_IMAGE_WIDTH_576           = 576,                  /* 448P */
    VIDEO_IMAGE_WIDTH_SD            = 720,                  /* SD */
    VIDEO_IMAGE_WIDTH_720           = 720,                  /* SD */

    VIDEO_IMAGE_WIDTH_768           = 768,                  /* W448P */
    VIDEO_IMAGE_WIDTH_W448P         = 768,                  /* W448P */
    
    VIDEO_IMAGE_WIDTH_640           = 640,                  /* VGA */ // or NHD
    VIDEO_IMAGE_WIDTH_704           = 704,                  /* 4CIF */
    VIDEO_IMAGE_WIDTH_4CIF          = 704,                  /* 4CIF */
    VIDEO_IMAGE_WIDTH_960           = 960,                  /* 4:3 720p */
    VIDEO_IMAGE_WIDTH_1280          = 1280,                 /* 16:9 720p */
    VIDEO_IMAGE_WIDTH_1408          = 1408,                 /* 16CIF */
    VIDEO_IMAGE_WIDTH_16CIF         = 1408,                 /* 16CIF */
    VIDEO_IMAGE_WIDTH_1920          = 1920,                 /* 16:9 1080i/p */
    VIDEO_IMAGE_WIDTH_DEFAULT       = VIDEO_IMAGE_WIDTH_176,

    /* the enums below are for backwards compatibility */
    EMM_VIDEO_IMAGE_WIDTH_UNDEFINED = VIDEO_IMAGE_WIDTH_176,
    EMM_VIDEO_IMAGE_WIDTH_DEFAULT   = VIDEO_IMAGE_WIDTH_176,
    EMM_VIDEO_IMAGE_WIDTH_128       = VIDEO_IMAGE_WIDTH_128,
    EMM_VIDEO_IMAGE_WIDTH_176       = VIDEO_IMAGE_WIDTH_176,
    EMM_VIDEO_IMAGE_WIDTH_352       = VIDEO_IMAGE_WIDTH_352,
    EMM_VIDEO_IMAGE_WIDTH_704       = VIDEO_IMAGE_WIDTH_704,
    EMM_VIDEO_IMAGE_WIDTH_1408      = VIDEO_IMAGE_WIDTH_1408
} eVIDEO_IMAGE_WIDTH, eMM_VIDEO_IMAGE_WIDTH;

typedef enum tagVIDEO_IMAGE_HEIGHT
{
    VIDEO_IMAGE_HEIGHT_UNKNOWN      = 0,                   /* Size unknown (for API) */
    VIDEO_IMAGE_HEIGHT_UNKNOWN_SIZE = 99,                  /* Size unknown */

    VIDEO_IMAGE_HEIGHT_96           = 96,                   /* Sub-QCIF */
    VIDEO_IMAGE_HEIGHT_SQCIF        = 96,                   /* Sub-QCIF */
    VIDEO_IMAGE_HEIGHT_144          = 144,                  /* QCIF */
    VIDEO_IMAGE_HEIGHT_QCIF         = 144,                  /* QCIF */
    VIDEO_IMAGE_HEIGHT_288          = 288,                  /* CIF */
    VIDEO_IMAGE_HEIGHT_CIF          = 288,                  /* CIF */
    VIDEO_IMAGE_HEIGHT_480          = 480,                  /* VGA */
    VIDEO_IMAGE_HEIGHT_VGA          = 480,                  /* VGA */
    
    VIDEO_IMAGE_HEIGHT_SQVGA        = 300,                  /* SQVGA */
    VIDEO_IMAGE_HEIGHT_300          = 300,                  /* SQVGA */
    VIDEO_IMAGE_HEIGHT_QVGA         = 240,                  /* QVGA */
    VIDEO_IMAGE_HEIGHT_240          = 240,                  /* QVGA */
    VIDEO_IMAGE_HEIGHT_WQVGA        = 240,                  /* WQVGA */
    VIDEO_IMAGE_HEIGHT_W288P        = 288,                  /* W288P */
    VIDEO_IMAGE_HEIGHT_NHD          = 360,                  /* NHD */
    VIDEO_IMAGE_HEIGHT_360          = 360,                  /* NHD */
    VIDEO_IMAGE_HEIGHT_448P         = 448,                  /* 448P */
    VIDEO_IMAGE_HEIGHT_W448P        = 448,                  /* W448P */
    VIDEO_IMAGE_HEIGHT_448          = 448,                  /* (w)448P */
    VIDEO_IMAGE_HEIGHT_SD           = 480,                  /* SD */
    
    VIDEO_IMAGE_HEIGHT_576          = 576,                  /* 4CIF */
    VIDEO_IMAGE_HEIGHT_4CIF         = 576,                  /* 4CIF */
    VIDEO_IMAGE_HEIGHT_720          = 720,                  /* 720p */
    VIDEO_IMAGE_HEIGHT_1080         = 1080,                 /* 1080p */
    VIDEO_IMAGE_HEIGHT_1152         = 1152,                 /* 16CIF */
    VIDEO_IMAGE_HEIGHT_16CIF        = 1152,                 /* 16CIF */
    VIDEO_IMAGE_HEIGHT_DEFAULT      = VIDEO_IMAGE_HEIGHT_144,

    /* the enums below are for backwards compatibility */
    EMM_VIDEO_IMAGE_HEIGHT_UNDEFINED= VIDEO_IMAGE_HEIGHT_144,
    EMM_VIDEO_IMAGE_HEIGHT_DEFAULT  = VIDEO_IMAGE_HEIGHT_144,
    EMM_VIDEO_IMAGE_HEIGHT_96       = VIDEO_IMAGE_HEIGHT_96,
    EMM_VIDEO_IMAGE_HEIGHT_144      = VIDEO_IMAGE_HEIGHT_144,
    EMM_VIDEO_IMAGE_HEIGHT_288      = VIDEO_IMAGE_HEIGHT_288,
    EMM_VIDEO_IMAGE_HEIGHT_576      = VIDEO_IMAGE_HEIGHT_576,
    EMM_VIDEO_IMAGE_HEIGHT_1152     = VIDEO_IMAGE_HEIGHT_1152
} eVIDEO_IMAGE_HEIGHT, eMM_VIDEO_IMAGE_HEIGHT;

typedef enum tagEMM_VIDEO_BITRATE 
{
    /* NOTE: Custom bitrates (other than the ones in this enum list) are allowed.  
       The value will need to be cast as a eVIDEO_BITRATE type */

    VIDEO_BITRATE_DEFAULT           =      0,  /* default = 50kbps */
    VIDEO_BITRATE_40K               =  40000,  /*  40kbps */
    VIDEO_BITRATE_64K               =  64000,  /*  64kbps */
    VIDEO_BITRATE_128K              = 128000,  /* 128kbps */
    VIDEO_BITRATE_192K              = 192000,  /* 192kbps */
    VIDEO_BITRATE_256K              = 256000, 
    VIDEO_BITRATE_350K              = 350000, 
    VIDEO_BITRATE_384K              = 384000,  /* 384kbps */
    VIDEO_BITRATE_512K              = 512000, 
    VIDEO_BITRATE_768K              = 768000,  /* 768kbps */

    VIDEO_BITRATE_800K              = 800000,  
    VIDEO_BITRATE_1000K              = 1000000,
    VIDEO_BITRATE_1200K              = 1200000,
    VIDEO_BITRATE_1500K              = 1500000,
    VIDEO_BITRATE_1800K              = 1800000,
    VIDEO_BITRATE_2000K              = 2000000,


    /* the enums below are for backwards compatibility */
    EMM_VIDEO_BITRATE_UNDEFINED     = 0,
    EMM_VIDEO_BITRATE_DEFAULT       = VIDEO_BITRATE_DEFAULT
} eVIDEO_BITRATE, eMM_VIDEO_BITRATE;

typedef enum tagVIDEO_FRAMESPERSEC
{
    VIDEO_FRAMESPERSEC_5            = 0x50000,              
    VIDEO_FRAMESPERSEC_6            = 0x60000,              
    VIDEO_FRAMESPERSEC_7_5          = 0x78000,              /* 7.5 fps */
    VIDEO_FRAMESPERSEC_10           = 0xA0000,              
    VIDEO_FRAMESPERSEC_12           = 0xC0000,              
    VIDEO_FRAMESPERSEC_15           = 0xF0000,              
    VIDEO_FRAMESPERSEC_24           = 0x180000,             
    VIDEO_FRAMESPERSEC_25           = 0x190000,             
    VIDEO_FRAMESPERSEC_2997         = 0x1D0061,             /* 29.97 fps */
    VIDEO_FRAMESPERSEC_30           = 0x1E0000,             
    VIDEO_FRAMESPERSEC_DEFAULT      = VIDEO_FRAMESPERSEC_15,

    /* the enums below are for backwards compatibility */
    EMM_VIDEO_FRAMESPERSEC_UNDEFINED= VIDEO_FRAMESPERSEC_15,
    EMM_VIDEO_FRAMESPERSEC_DEFAULT  = VIDEO_FRAMESPERSEC_15,
    EMM_VIDEO_FRAMESPERSEC_5        = VIDEO_FRAMESPERSEC_5,
    EMM_VIDEO_FRAMESPERSEC_6        = VIDEO_FRAMESPERSEC_6,
    EMM_VIDEO_FRAMESPERSEC_7_5      = VIDEO_FRAMESPERSEC_7_5,
    EMM_VIDEO_FRAMESPERSEC_12       = VIDEO_FRAMESPERSEC_12,
    EMM_VIDEO_FRAMESPERSEC_15       = VIDEO_FRAMESPERSEC_15,
    EMM_VIDEO_FRAMESPERSEC_24       = VIDEO_FRAMESPERSEC_24,
    EMM_VIDEO_FRAMESPERSEC_25       = VIDEO_FRAMESPERSEC_25,
    EMM_VIDEO_FRAMESPERSEC_2997     = VIDEO_FRAMESPERSEC_2997,
    EMM_VIDEO_FRAMESPERSEC_30       = VIDEO_FRAMESPERSEC_30
} eVIDEO_FRAMESPERSEC, eMM_VIDEO_FRAMESPERSEC;

typedef enum tagVIDEO_SAMPLING_RATE
{
    VIDEO_SAMPLING_RATE_90000   = 1,                    /* 90KHz */
    VIDEO_SAMPLING_RATE_DEFAULT = VIDEO_SAMPLING_RATE_90000
}eVIDEO_SAMPLING_RATE;

typedef enum tagH264_ACCEPT_REDUNDAND_SILCES
{
    ACCEPT_REDUNDAND_SLICES_FALSE  = 0,
    ACCEPT_REDUNDAND_SLICES_TRUE   = 1,                    
    ACCEPT_REDUNDAND_SLICES_DEFAULT = ACCEPT_REDUNDAND_SLICES_FALSE
}eH264_ACCEPT_REDUNDAND_SLICES;

typedef enum tagH264_PROFILE_IOP
{
    H264_PROFILE_IOP_NONE   = 0,
    H264_PROFILE_IOP_CONSTRAINT_SET0   = 0x80,
    H264_PROFILE_IOP_CONSTRAINT_SET1   = 0x40,
    H264_PROFILE_IOP_CONSTRAINT_SET2   = 0x20,
    H264_PROFILE_IOP_CONSTRAINT_SET3   = 0x10,
    H264_PROFILE_IOP_CONSTRAINT_SET4   = 0x08,
    H264_PROFILE_IOP_DEFAULT = H264_PROFILE_IOP_NONE
}eH264_PROFILE_IOP;

typedef enum tagH264_PACKETIZATION_MODE
{
    H264_PACKETIZATION_MODE_SINGLE_NAL   = 0,                    
    H264_PACKETIZATION_MODE_NON_INTERLEAVED  = 1,                    
    H264_PACKETIZATION_MODE_INTERLEAVED   = 2,                    
    H264_PACKETIZATION_MODE_DEFAULT = H264_PACKETIZATION_MODE_NON_INTERLEAVED 
}eH264_PACKETIZATION_MODE;

#define H264_MAX_NAL_UNIT_SIZE_DEFAULT 1400

#endif /*__VIDEODEFS_H__*/
