#!/bin/bash
#
#  Script:			DM3_cfg.sh
#  Instance:		hsw_1
#  %version:		6 %
#  Description:		
#  %created_by:		mazzafep %
#  %date_created:	Fri Apr 09 11:11:46 2004 %

# Per-board internal data records
# Numbers are fields within each record
# fo<whatever> are field offsets within each board record
# this script uses cut to extract them so first index is 1
declare -i foSLOT=1;	# 1 Slot - returned from valid_boards.awk
declare -i foBOR=1;	# BOR is Beginning Of Record, keep equal to first item offset
declare -i foMODEL=2;	# 2 Model - returned from model.awk
declare -i foLOGID=3;	# 3 Logical ID - returned from valid_boards.awk
declare -i foPCD=4;	# 4 PCD - default returned from valid_boards.awk
declare -i foFCD=5;	# 5 FCD - default returned from valid_boards.awk
declare -i foBM=6;	# 6 Bus Master Status - default returned from valid_boards.awk
declare -i foTDM=7;	# 7 TDM Bus Type - default returned from valid_boards.awk
declare -i foPCM=8;	# 8 PCM Encoding - default returned from valid_boards.awk
declare -i foBCR=9;	# 9 Bus Clock Rate - Master Only - default returned from valid_boards.awk
declare -i foG1CR=10;	# 10 Group 1 Clock Rate - Master Only - default returned from valid_boards.awk
declare -i foG2CR=11;	# 11 Group 2 Clock Rate - Master Only - default returned from valid_boards.awk
declare -i foG3CR=12;	# 12 Group 3 Clock Rate - Master Only - default returned from valid_boards.awk
declare -i foG4CR=13;	# 13 Group 4 Clock Rate - Master Only - default returned from valid_boards.awk
declare -i foCS=14;	# 14 Clock Source - Master Only - default returned from valid_boards.awk
declare -i foCL=15;	# 15 CT Bus Clock Line - Master Only - default returned from valid_boards.awk
declare -i foBIP=16;	# 16 Board IP Address - default returned from valid_boards.awk
declare -i foBSM=17;	# 17 Board Subnet Mask - default returned from valid_boards.awk
declare -i foBN=18;	# 18 Board Name - default returned from valid_boards.awk
declare -i foHIP=19;	# 19 Host IP Address - default returned from valid_boards.awk
declare -i foHN=20;	# 20 Host Name - default returned from valid_boards.awk
declare -i foHUID=21;	# 21 Host User ID - default returned from valid_boards.awk
declare -i foGIP=22;	# 22 Gateway IP Address - default returned from valid_boards.awk
declare -i foACT=23;	# 23 Active - default returned from valid_boards.awk
declare -i foTI=24;	# 24 Telephony Interface - returned from model.awk
declare -i foCNAME=25;	# 25 Common Name -  returned from model.awk
declare -i foNIC=26;	# 26 NIC Present -  returned from model.awk
declare -i foPSLOT=27;	# 27 Physical Slot
declare -i foPCI=28;	# 28 PCI Bus Number
declare -i foNTI=29;	# 29 Number of Telephony Interfaces -  returned from model.awk
declare -i foEOR=29;	# EOR is End Of Record, keep equal to last item offset

# field offsets for GLOBAL_TDM_SETTINGS record
declare -i foSLOT=1;		# 1 Slot - Slot of PRIMARY clock master
declare -i foBOR=1;		# BOR is Beginning Of Record, keep equal to first item offset
declare -i foMODEL=2;		# 2 Model - Model of PRIMARY clock master
declare -i foLOGID=3;		# 3 Logical ID - Logical ID of PRIMARY clock master
declare -i foNRSLOT=4;		# 4 Slot of NetRef Board - defaults to PRIMARY board
declare -i foNRMODEL=5;		# 5 NetRef Model - defaults to PRIMARY board
declare -i foNRLOGID=6; 	# 6 NetRef Logical ID - Logical ID of NetRef board
declare -i foTDM=7;		# 7 TDM Bus Type
declare -i foPCM=8;		# 8 PCM Encoding - default matches PRIMARY
declare -i foBCR=9;		# 9 Bus Clock Rate - Master Only - Fixed by Bus Type
declare -i foG1CR=10;		# 10 Group 1 Clock Rate - Master Only - matches BCR currently
declare -i foG2CR=11;		# 11 Group 2 Clock Rate - Master Only - matches BCR currently
declare -i foG3CR=12;		# 12 Group 3 Clock Rate - Master Only - matches BCR currently
declare -i foG4CR=13;		# 13 Group 4 Clock Rate - Master Only - matches BCR currently
declare -i foCS=14;		# 14 Clock Source - Clock Source of PRIMARY clock master
declare -i foCL=15;		# 15 CT Bus Clock Line - Clock Line of PRIMARY clock master
declare -i foNRCS=16;		# 16 NetRefFrom Clock Source - NetRef Only - defaults to 1
declare -i foBUS=17;		# 17 Bus Number - Currently fixed at 1
declare -i foNR1FSLOT=18;	# 18 Slot of NetRef1Fallback
declare -i foNR1FMODEL=19;	# 19 Model of NetRef1Fallback
declare -i foNR1FLOGID=20;	# 20 Logical ID of NetRef1Fallback
declare -i foNR1FCS=21;		# 21 Clock Source of NetRef1Fallback
declare -i foNR1FCNAME=22;	# 22 Common Name of NetRef1Fallback
declare -i foNR1FNTI=23;	# 23 Number of Telephony Interfaces NR1F
declare -i foPNTI=24;		# 24 PRIMARY Master NTI
declare -i foCNAME=25;		# 25 PRIMARY Master Common Name
declare -i foNRCNAME=26;	# 26 NetRef Common Name
declare -i foF7=27;		# 23 Reserved for future TDM parameters
declare -i foPCI=28;		# 28 PCI Bus Number
declare -i foNRNTI=29;		# 29 Number of Telephony Interfaces -  returned from model.awk
declare -i foSupported=30       #from model.awk for runtime support of the board
declare -i foUTILITY_TAG=31; # 31 from model.awk for the trunk configuration, CRC support etc flag. This will be 5th entry in the model.awk
declare -i foEOR=31;		# EOR is End Of Record, keep equal to last item offset

# path variables for tools and data files
DD=/usr/dialogic
DD_BIN=$DD/bin
DD_CFG=$DD/cfg
DD_DATA=$DD/data
USR_BIN=/usr/bin
BIN=/bin
PAGER=$USR_BIN/less
CLEAR=$USR_BIN/clear
#CLEAR=""
HELP_FILE="$DD_BIN/DM3_cfg_help.txt"

# global variables and data structures
declare VERSION="1.28 Beta"
declare -i NUM_VALID_BOARDS=0;
declare VALID_BOARDS;
declare SLOTS_FOUND;
declare SLOT;
declare GLOBAL_TDM_SETTINGS;
declare PCD_LIST;
declare SCD_FILE_NAME=$DD_CFG/pyramid.scd;
declare NO_CHANGE;
declare UNSAVED_CHANGE;
declare WARNINGS;
declare MODEL_TDM;

function ShowHelp () { 
	$CLEAR;
	grep $1 $HELP_FILE | $PAGER
 } # end function ShowHelp

function Check4Boards () { 
	SLOTS_FOUND=`$DD_BIN/listboards -l2 -q 2>/dev/null | awk -f $DD_BIN/valid_boards.awk | sort -k1 -t: -n`;
	VALID_BOARDS="";
	for SLOT in $SLOTS_FOUND
	do
		NUM_VALID_BOARDS=$NUM_VALID_BOARDS+1;
		VALID_BOARDS=$VALID_BOARDS`echo $SLOT | cut -d: -f$foSLOT`"|";
	done
 } # end function Check4Boards

function GetPCDList () {
	cd $DD_DATA
	PCD_LIST=`grep -E -r -l "ModelType[ 	]*:[ 	]*$1([ 	;]|$)" *.pcd`
	cd -
	return;
 } # end function GetPCDList

function GetField () {
echo `echo $1 | cut -d: -f$2`;
return
 }

function ChangeField () {
declare NewRecord="";
declare -i PREV=$2-1;
declare -i POST=$2+1;
case $2 in
${foBOR})
	NewRecord=$3":"`echo $1 | cut -d: -f${POST}-$foEOR`
;;
${foEOR})
	NewRecord=`echo $1 | cut -d: -f${foBOR}-$PREV`":"$3":"
;;
*)
	NewRecord=`echo $1 | cut -d: -f${foBOR}-$PREV`":"$3":"`echo $1 | cut -d: -f${POST}-$foEOR`
;;
esac

echo $NewRecord;
return;
 }

function set_TDM_defaults () {
GLOBAL_TDM_SETTINGS=":::::::::::::::::::::::::::::"
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foSLOT "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foMODEL "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foLOGID "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foTDM $1`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foPCM "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foBCR "8"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG1CR "8"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG2CR "8"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG3CR "8"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG4CR "8"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCS "OSC"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCL "CT_A"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foBUS "1"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FMODEL "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1CNAME "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foPNTI "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCNAME "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME "NA"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foF7 "NOT_SET"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foPCI "1"`;
GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRNTI "NA"`;
 }

function PopulateData () {
declare PRIMARY_FOUND=false;
	SLOTS_TMP="";
	for SLOT in $SLOTS_FOUND
	do
		THUMBWHEEL=`GetField $SLOT $foSLOT`;
		MODEL_INFO=`$DD_BIN/listboards -l2 --iPHYS $THUMBWHEEL --oROM 2>/dev/null | awk -f $DD_BIN/model.awk`;
		MODEL=`echo $MODEL_INFO | cut -d: -f1`;
		MODEL_TDM=`echo $MODEL_INFO | cut -d: -f2`;
		MODEL_CNAME=`echo $MODEL_INFO | cut -d: -f3`;
		MODEL_NTI=`echo $MODEL_INFO | cut -d: -f4`;
		MODEL_TI=`echo $MODEL_INFO | cut -d: -f5`;
		MODEL_NIC=`echo $MODEL_INFO | cut -d: -f6`;
		MODEL_UTILITY_TAG=`echo $MODEL_INFO | cut -d: -f8`;

		SLOT=`ChangeField $SLOT $foUTILITY_TAG $MODEL_UTILITY_TAG`;
		SLOT=`ChangeField $SLOT $foMODEL $MODEL`;
		SLOT=`ChangeField $SLOT $foTI $MODEL_TI`;
		SLOT=`ChangeField $SLOT $foNTI $MODEL_NTI`;
		SLOT=`ChangeField $SLOT $foTDM $MODEL_TDM`;
		case $MODEL_TI in
		"T1") NEW_PCM="MULAW";
		;;
		"E1") NEW_PCM="ALAW";
		;;
		*) NEW_PCM="NOT_SET";
		;;
		esac
		SLOT=`ChangeField $SLOT $foPCM $NEW_PCM`;
		SLOT=`ChangeField $SLOT $foCNAME $MODEL_CNAME`;
		SLOT=`ChangeField $SLOT $foNIC $MODEL_NIC`;
		SLOT=`ChangeField $SLOT $foHN $HOSTNAME`;
		SLOTS_TMP="$SLOTS_TMP $SLOT";
		if ( test `GetField $SLOT $foBM` = "PRIMARY" ) then
			PRIMARY_FOUND=true;
			GLOBAL_TDM_SETTINGS=$SLOT;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foBUS "1"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foPNTI $MODEL_NTI`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRNTI "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FMODEL "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCNAME "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI "NA"`;
		fi
	done
	SLOTS_FOUND=$SLOTS_TMP;
	if ( test $PRIMARY_FOUND =  false ) then
		set_TDM_defaults $MODEL_TDM;
		# No Primary, set reasonable defaults for TDM
	fi
 } # end function PopulateData

function edit_NR () { 

if ( test `GetField $GLOBAL_TDM_SETTINGS $foCS` != "NETREF_1" \
	-a `GetField $GLOBAL_TDM_SETTINGS $foCS` != "NETREF_2" ) then
	$CLEAR;
	echo "A NETREF board is not used unless the PRIMARY Board";
	echo "uses a Clock Source of NETREF 1 or 2. If you wish to";
	echo "use a NETREF board please set the PRIMARY Clock Source";
	echo "to NETREF 1 or 2 first.";
	echo "Press Enter to Continue";
	read ack;
	return;
fi
declare VALID_NR;
while true
do
	VALID_NR=false;
	$CLEAR;
	echo "          .......................................         ";
	echo "                    Select NetRef Board                   ";
	echo "          .......................................         ";
	echo "__________________________________________________________";
	echo "PCI   Logical   Clock            Model";
	echo "Slot    ID      Status";
	for SLOT in $SLOTS_FOUND
	do
	if ( test `GetField $SLOT $foNTI` = "Unknown" \
	-o `GetField $SLOT $foNTI` = "0" ) then
		continue
		# cant be a netref, no network interface
	else
		declare -i NTI=`GetField $SLOT $foNTI`
	fi
		echo `GetField $SLOT $foSLOT`\
"	"`GetField $SLOT $foLOGID`\
"	"`GetField $SLOT $foBM`\
"    	"`GetField $SLOT $foCNAME`;
	done
	echo "__________________________________________________________";
	echo ".  Select the Slot number of one of the boards shown to  .";
	echo ".  provide the NetRef Signal. This will only be used if  .";
	echo ".  the PRIMARY clock master uses a NETREF clock source.  .";
	echo "__________________________________________________________";
	read NEW_NR;
	case $NEW_NR in
	[0-9]|1[0-9])
		for SLOT in $SLOTS_FOUND
		do
			if ( test `GetField $SLOT $foSLOT` = $NEW_NR ) then
				VALID_NR=true;
				break;	
			fi
		done
		if ( test $VALID_NR = true ) then
			break;
		fi
	;;
	"?") ShowHelp '^NR'
	;;
	*) return
	;;
	esac
done
	NEW_NRSLOT=`GetField $SLOT $foSLOT`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT $NEW_NRSLOT`;
	NEW_NRLOGID=`GetField $SLOT $foLOGID`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID $NEW_NRLOGID`;
	NEW_NRMODEL=`GetField $SLOT $foMODEL`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL $NEW_NRMODEL`;
	NEW_NRCNAME=`GetField $SLOT $foCNAME`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME $NEW_NRCNAME`;
	NEW_NRNTI=`GetField $SLOT $foNTI`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRNTI $NEW_NRNTI`;
	declare -i CS=`GetField $GLOBAL_TDM_SETTINGS $foNRCS`
	if (test `GetField $GLOBAL_TDM_SETTINGS $foNRSLOT` = `GetField $GLOBAL_TDM_SETTINGS $foNR1FSLOT`) then
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT "NOT_SET"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FMODEL "NOT_SET"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID "NOT_SET"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS "NOT_SET"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCNAME "NOT_SET"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI "NOT_SET"`;
	fi
	if ( test $CS -gt $NEW_NRNTI \
	-o $CS -le 0 ) then
		NEW_NRCS="1";
	else
		NEW_NRCS=$CS;
	fi
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS $NEW_NRCS`;
	return;

 } # end function edit_NR

function edit_NRCS () { 
declare -i NTI=`GetField $GLOBAL_TDM_SETTINGS $foNRNTI`
while true
do
	$CLEAR;
	echo ".........................................";
	echo ".        Set NetRef Clock Source        .";
	echo ".........................................";
	echo "_________________________________________";
	echo "Valid only if PRIMARY clock master is set";
	echo "to NetRef and a NETREF board has been    ";
	echo "selected.                                ";
	echo "Select a value in this range:"
	echo "_________________________________________";
	echo "1 - Trunk 1"
	echo "through"
	echo "$NTI - Trunk $NTI"
	echo "_________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_NRCS;
	case $NEW_NRCS in
	[0-9]*)
		declare -i CS=$NEW_NRCS
		if ( test $CS -le $NTI -a $CS -gt 0 ) then
			break;
		fi
	;;
	"?") ShowHelp '^NRCS'
	;;
	*) return
	;;
	esac
done
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS $NEW_NRCS`;
	return;
 } # end function edit_NRCS

function edit_NR1F () { 

if ( test `GetField $GLOBAL_TDM_SETTINGS $foCS` != "NETREF_1" \
	-o `GetField $GLOBAL_TDM_SETTINGS $foNRSLOT` = "NOT_SET" \
	-o `GetField $GLOBAL_TDM_SETTINGS $foNRSLOT` = "NA" ) then
	$CLEAR;
	echo "A NETREF Fallback board is not used unless the PRIMARY";
	echo "Board uses a Clock Source of NETREF 1 and a NetRef board";
	echo "has been selected. If you wish to set a NetRef1 Fallback";
	echo "board please set the PRIMARY Clock Source to NETREF 1 and";
	echo "select a NetRef board first.";
	echo "Press Enter to Continue";
	read ack;
	return;
fi
declare VALID_NR1F;
while true
do
	VALID_NR1F=false;
	$CLEAR;
	echo "           .....................................          ";
	echo "               Select NetRef1 Fallback Board              ";
	echo "           .....................................          ";
	echo "__________________________________________________________";
	echo "PCI   Logical   Clock            Model";
	echo "Slot    ID      Status";
	for SLOT in $SLOTS_FOUND
	do
	if ( test `GetField $SLOT $foNTI` = "Unknown" \
	-o `GetField $SLOT $foSLOT` = `GetField $GLOBAL_TDM_SETTINGS $foNRSLOT` \
	-o `GetField $SLOT $foNTI` = "0" ) then
		continue
		# cant be a fallback, no network interface
		# or it is already the netref
	else
		declare -i NTI=`GetField $SLOT $foNTI`
	fi
		echo `GetField $SLOT $foSLOT`\
"	"`GetField $SLOT $foLOGID`\
"	"`GetField $SLOT $foBM`\
"    	"`GetField $SLOT $foCNAME`;
	done
	echo "__________________________________________________________";
	echo ".  Select the Slot number of one of the boards shown to  .";
	echo ".  act as the NetRef Fallback. This will only be used if .";
	echo ".  the PRIMARY clock master uses a NETREF clock source.  .";
	echo ".  If no boards are shown it means there are none that   .";
	echo ".  are appropriate to act as the Fallback board.         .";
	echo "__________________________________________________________";
	read NEW_NR1F;
	case $NEW_NR1F in
	[0-9]|1[0-9])
		for SLOT in $SLOTS_FOUND
		do
			if ( test `GetField $SLOT $foSLOT` = $NEW_NR1F ) then
				VALID_NR1F=true;
				break;	
			fi
		done
		if ( test $VALID_NR1F = true ) then
			break;
		fi
	;;
	"?") ShowHelp '^NR1F'
	;;
	*) return
	;;
	esac
done
	NEW_NR1FSLOT=`GetField $SLOT $foSLOT`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT $NEW_NR1FSLOT`;
	NEW_NR1FLOGID=`GetField $SLOT $foLOGID`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID $NEW_NR1FLOGID`;
	NEW_NR1FCNAME=`GetField $SLOT $foCNAME`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCNAME $NEW_NR1FCNAME`;
	NEW_NR1FNTI=`GetField $SLOT $foNTI`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI $NEW_NR1FNTI`;
	declare -i CS=`GetField $GLOBAL_TDM_SETTINGS $foNR1FCS`
	if ( test $CS -gt $NEW_NR1FNTI \
	-o $CS -le 0 ) then
		NEW_NR1FCS="1";
	else
		NEW_NR1FCS=$CS;
	fi
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS $NEW_NR1FCS`;
	return;

 } # end function edit_NR1F

function edit_NR1FCS () { 
declare -i NTI=`GetField $GLOBAL_TDM_SETTINGS $foNR1FNTI`
while true
do
	$CLEAR;
	echo ".........................................";
	echo ".    Set NetRef Fallback Clock Source   .";
	echo ".........................................";
	echo "_________________________________________";
	echo "Valid only if PRIMARY clock master is set";
	echo "to NetRef and a NETREF Fallback board has";
	echo "been selected.                           ";
	echo "Select a value in this range:"
	echo "_________________________________________";
	echo "1 - Trunk 1"
	echo "through"
	echo "$NTI - Trunk $NTI"
	echo "_________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_NR1FCS;
	case $NEW_NR1FCS in
	[0-9]*)
		declare -i CS=$NEW_NR1FCS
		if ( test $CS -le $NTI -a $CS -gt 0 ) then
			break;
		fi
	;;
	"?") ShowHelp '^NR1FCS'
	;;
	*) return
	;;
	esac
done
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS $NEW_NR1FCS`;
	return;
 } # end function edit_NR1FCS

function ShowAllBoards () { 
	$CLEAR;
	echo "         ........................................           ";
	echo "           DM Board Configuration - Main Screen             ";
	echo "         ........................................           ";
	echo "    This is a summary of the current board configuration    ";
	echo "____________________________________________________________";
	echo "PCI    Board                  Logical      PCD";
	echo "Slot  Enabled    Model          ID      File Name";
	for SLOT in $SLOTS_FOUND
	do
	echo `GetField $SLOT $foSLOT`\
"	"`GetField $SLOT $foACT`\
"	"`GetField $SLOT $foCNAME`\
"	"`GetField $SLOT $foLOGID`\
"	"`GetField $SLOT $foPCD`;
done
	echo "____________________________________________________________";
	echo "T        -    TDM BUS SETTINGS  -       "`GetField $GLOBAL_TDM_SETTINGS $foTDM`;
	echo "____________________________________________________________";
	echo ".     You must configure or disable each board shown.      ."
	echo ".     When a board is configured a valid PCD file name     ."
	echo ".     is displayed in the PCD File Name column.            ."
	echo "____________________________________________________________";
 } # end function ShowAllBoards

function ShowClockOpts () { 
declare OLD_TDM=$GLOBAL_TDM_SETTINGS;
while true
do
	$CLEAR;
echo "               ..............................              ";
echo "                Modify TDM Bus Configuration               ";
echo "               ..............................              ";
echo "These are the current TDM related settings for the system. ";
echo "Set a clock master on the Modify Board page for that board.";
echo "____________________________________________________________";
echo "(read only)........Clock Master: (Slot "`GetField $GLOBAL_TDM_SETTINGS $foSLOT`") "`GetField $GLOBAL_TDM_SETTINGS $foCNAME`;
echo "(read only)......Bus Clock Rate: "`GetField $GLOBAL_TDM_SETTINGS $foBCR`;
echo "____________________________________________________________";
echo "1) ......................TDM Bus Type: "`GetField $GLOBAL_TDM_SETTINGS $foTDM`;
echo "2) ..............Primary Clock Source: "`GetField $GLOBAL_TDM_SETTINGS $foCS`;
echo "3) .........Primary CT Bus Clock Line: "`GetField $GLOBAL_TDM_SETTINGS $foCL`;
echo "4) ......................NetRef Board: (Slot "`GetField $GLOBAL_TDM_SETTINGS $foNRSLOT`") "`GetField $GLOBAL_TDM_SETTINGS $foNRCNAME`;
echo "5) .........NetRef Clock Source Trunk: "`GetField $GLOBAL_TDM_SETTINGS $foNRCS`;
echo "6) ............NetRef1 Fallback Board: (Slot "`GetField $GLOBAL_TDM_SETTINGS $foNR1FSLOT`") "`GetField $GLOBAL_TDM_SETTINGS $foNR1FCNAME`;
echo "7) ...NR1 Fallback Clock Source Trunk: "`GetField $GLOBAL_TDM_SETTINGS $foNR1FCS`;
echo "____________________________________________________________";
echo "Enter the number of the parameter to modify.";
echo "S to Save and return to the Main Screen, or";
echo "C to Cancel and return to the Main Screen.";
	read REPLY;
	case $REPLY in
	1) edit_TDM $GLOBAL_TDM_SETTINGS ;;
	2) edit_CS $GLOBAL_TDM_SETTINGS ;;
	3) edit_CL $GLOBAL_TDM_SETTINGS ;;
	4) edit_NR $GLOBAL_TDM_SETTINGS ;;
	5) edit_NRCS $GLOBAL_TDM_SETTINGS ;;
	6) edit_NR1F $GLOBAL_TDM_SETTINGS ;;
	7) edit_NR1FCS $GLOBAL_TDM_SETTINGS ;;
	s|S) update_SLOTS "-1" $GLOBAL_TDM_SETTINGS ; break ;;
	c|C) GLOBAL_TDM_SETTINGS=$OLD_TDM; break ;;
	*) echo ;;
	esac
done
return 0;
 } # end function ShowClockOpts

function ShowNICOpts () { 
declare OLD_SLOT=$1;
NIC_PRESENT=`GetField $1 $foNIC`;
if (test $NIC_PRESENT = "No") then
	$CLEAR;
	echo "This Board does not normally have a NIC to set up!"
	echo "If you have a unique model that does have a NIC,"
	echo "you will need to edit the SCD file manually."
	echo "Hit Enter to continue."
	read ack;
	return 1;
fi
while true
do
	$CLEAR;
echo "    ..................................................      ";
echo "     Modify Network Interface Connector Configuration       ";
echo "    ..................................................      ";
echo "   These are the current settings for the board selected.   ";
echo "_____________________________________________________________";
echo "(read only).......Physical Slot: "`GetField $1 $foSLOT`;
echo "(read only)...............Model: "`GetField $1 $foCNAME`;
echo "_____________________________________________________________";
echo "1) ............Board IP Address: "`GetField $SLOT $foBIP`;
echo "2) ...........Board Subnet Mask: "`GetField $SLOT $foBSM`;
echo "3) ..................Board Name: "`GetField $SLOT $foBN`;
echo "4) .............Host IP Address: "`GetField $SLOT $foHIP`;
echo "5) ...................Host Name: "`GetField $SLOT $foHN`;
echo "6) ................Host User ID: "`GetField $SLOT $foHUID`;
echo "7) ..........Gateway IP Address: "`GetField $SLOT $foGIP`;
echo "_____________________________________________________________";
echo "Enter the number of the parameter to modify.";
echo "S to Save and return to the Modify Board Settings Screen, or";
echo "C to Cancel and return to the Modify Board Settings Screen.";
	read REPLY;
	case $REPLY in
	1) edit_BIP $SLOT ;;
	2) edit_BSM $SLOT ;;
	3) edit_BN $SLOT ;;
	4) edit_HIP $SLOT ;;
	5) edit_HN $SLOT ;;
	6) edit_HUID $SLOT ;;
	7) edit_GIP $SLOT ;;
	s|S) update_SLOTS $1 $SLOT ; break ;;
	c|C) SLOT=$OLD_SLOT; break ;;
	*) echo ;;
	esac
done
return 0;
 } # end function ShowNICOpts

function validate_IP () { 
declare -i D1;
declare -i D2;
declare -i D3;
declare -i D4;
D1=`echo $1 | cut -d. -f1`;
D2=`echo $1 | cut -d. -f2`;
D3=`echo $1 | cut -d. -f3`;
D4=`echo $1 | cut -d. -f4`;
if (test $D1 -ge 256 -o $D1 -lt 0) then
	echo -1;
	return -1;
fi
if (test $D2 -ge 256 -o $D2 -lt 0) then
	echo -1;
	return -1;
fi
if (test $D3 -ge 256 -o $D3 -lt 0) then
	echo -1;
	return -1;
fi
if (test $D4 -ge 256 -o $D4 -lt 0) then
	echo -1;
	return -1;
fi
echo 0;
return 0;
 } # end function validate_IP

function edit_BIP () { 
while true
do
	$CLEAR;
	echo "..........................................................."
	echo ".                 Set Board IP Address                    ."
	echo "..........................................................."
	echo "___________________________________________________________"
	echo "The board IP address must be in the format 123.456.789.012."
	echo "___________________________________________________________"
	echo "Currently: "`GetField $SLOT $foBIP`
	echo "___________________________________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_BIP;
	case $NEW_BIP in
	[0-9]*)
		IP_GOOD=`validate_IP $NEW_BIP`
		if (test $IP_GOOD -eq 0 ) then
			SLOT=`ChangeField $SLOT $foBIP $NEW_BIP`;
			return;
		else
			echo "$NEW_BIP is not a validly formatted"
			echo "IP address. Hit Enter to try again"
			read ack
		fi
	;;
	"?") ShowHelp '^BIP'
	;;
	*) return
	;;
	esac
done
 } #end function edit_BIP 

function edit_BSM () { 
while true
do
	$CLEAR;
	echo "............................................................"
	echo ".                 Set Board Subnet Mask                    ."
	echo "............................................................"
	echo "____________________________________________________________"
	echo "The board Subnet Mask IP address must be in the format:     "
	echo " 123.456.789.012.                                           "
	echo "____________________________________________________________"
	echo "Currently: "`GetField $SLOT $foBSM`
	echo "____________________________________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_BSM;
	case $NEW_BSM in
	[0-9]*)
		IP_GOOD=`validate_IP $NEW_BSM`
		if (test $IP_GOOD -eq 0 ) then
			SLOT=`ChangeField $SLOT $foBSM $NEW_BSM`;
			return;
		else
			echo "$NEW_BSM is not a validly formatted"
			echo "IP address. Hit Enter to try again"
			read ack
		fi
	;;
	"?") ShowHelp '^BSM'
	;;
	*) return
	;;
	esac
done
 } #end function edit_BSM

function edit_BN  () { 
while true
do
	$CLEAR;
	echo ".................................................................."
	echo ".                      Set Board Name                            ."
	echo ".................................................................."
	echo "__________________________________________________________________"
	echo "Choose a name for the Network Interface Connector (NIC)."
	echo "You can use the default name displayed or you can choose any name."
	echo "__________________________________________________________________"
	echo "Currently: "`GetField $SLOT $foBN`
	echo "__________________________________________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_BN;
	case $NEW_BN in
	[a-zA-Z0-9_]*)
		SLOT=`ChangeField $SLOT $foBN $NEW_BN`;
		return;
	;;
	"?") ShowHelp '^NICNAME'
	;;
	*) return
	;;
	esac
done
 } #end function edit_BN

function edit_HIP () { 
while true
do
	$CLEAR;
	echo ".........................................................."
	echo ".                  Set Host IP Address                   ."
	echo ".........................................................."
	echo "__________________________________________________________"
	echo "The host IP address must be in the format 123.456.789.012."
	echo "__________________________________________________________"
	echo "Currently: "`GetField $SLOT $foHIP`
	echo "__________________________________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_HIP;
	IP_GOOD=`validate_IP $NEW_HIP`
	case $NEW_HIP in
	[0-9]*)
		if (test $IP_GOOD -eq 0 ) then
			SLOT=`ChangeField $SLOT $foHIP $NEW_HIP`;
			return;
		else
			echo "$NEW_HIP is not a validly formatted"
			echo "IP address. Hit Enter to try again"
			read ack
		fi
	;;
	"?") ShowHelp '^HIP'
	;;
	*) return
	;;
	esac
done
 } #end function edit_HIP

function edit_HN () { 
while true
do
	$CLEAR;
	echo "..........................."
	echo ".      Set Host Name      ."
	echo "..........................."
	echo "___________________________"
	echo "Enter the name of the host." 
	echo "___________________________"
	echo "Currently: "`GetField $SLOT $foHN`
	echo "___________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_HN;
	case $NEW_HN in
	[a-zA-Z0-9_]*)
		SLOT=`ChangeField $SLOT $foHN $NEW_HN`;
		return;
	;;
	"?") ShowHelp '^HOST'
	;;
	*) return
	;;
	esac
done
 } #end function edit_HN

function edit_HUID () { 
while true
do
	$CLEAR;
	echo "...........................................................";
	echo ".                  Set Host User ID                       ."
	echo "...........................................................";
	echo "___________________________________________________________";
	echo "Enter any name with valid log-on access to the host system.";
	echo "___________________________________________________________";
	echo "Currently: "`GetField $SLOT $foHUID`
	echo "___________________________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_HUID;
	case $NEW_HUID in
	[a-zA-Z0-9_]*)
		SLOT=`ChangeField $SLOT $foHUID $NEW_HUID`;
		return;
	;;
	"?") ShowHelp '^HUID'
	;;
	*) return
	;;
	esac
done
 } #end function edit_HUID

function edit_GIP () { 
while true
do
	$CLEAR;
	echo ".............................................................";
	echo ".                Set Gateway IP Address                     .";
	echo ".............................................................";
	echo "_____________________________________________________________";
	echo "The gateway IP address must be in the format 123.456.789.012.";
	echo "_____________________________________________________________";
	echo "Currently: "`GetField $SLOT $foGIP`
	echo "_____________________________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_GIP;
	IP_GOOD=`validate_IP $NEW_GIP`
	case $NEW_GIP in
	[0-9]*)
		if (test $IP_GOOD -eq 0 ) then
			SLOT=`ChangeField $SLOT $foGIP $NEW_GIP`;
			return;
		else
			echo "$NEW_GIP is not a validly formatted"
			echo "IP address. Hit Enter to try again"
			read ack
		fi
	;;
	"?") ShowHelp '^GIP'
	;;
	*) return
	;;
	esac
done
 } #end function edit_GIP

function ShowOneBoard () { 
for SLOT in $SLOTS_FOUND
do
TMP=`GetField $SLOT $foSLOT`;
	if ( test $TMP -eq $1 ) then
		declare OLD_SLOT=$SLOT;
		while true
		do
			$CLEAR;
echo "                     .........................                     ";
echo "                       Modify Board Settings                       ";
echo "                     .........................                     ";
echo "      These are the current settings for the board selected.       ";
echo "___________________________________________________________________";
echo "(read only).....Physical Slot: "`GetField $SLOT $foSLOT`;
echo "(read only).............Model: "`GetField $SLOT $foCNAME`;
echo "___________________________________________________________________";
echo ". A PCD file must be selected. The corresponding FCD file will    .";
echo ". be automatically selected. Other parameters can be modified,    .";
echo ". or the default values shown will be used. To view the default   .";
echo ". values for the NIC Configuration, select that item.             .";
echo "___________________________________________________________________";
echo "1) ................Logical ID: "`GetField $SLOT $foLOGID`;
echo "2) .............Board Enabled: "`GetField $SLOT $foACT`;
echo "3) .............PCD File Name: "`GetField $SLOT $foPCD`;
echo "4) .............FCD File Name: "`GetField $SLOT $foFCD`;
echo "5) ..............PCM Encoding: "`GetField $SLOT $foPCM`;
echo "6) ........TDM Clock Function: "`GetField $SLOT $foBM`;
echo "7) .........NIC Configuration	(IPT w/onboard NIC only)";
echo "___________________________________________________________________";
echo "Enter the number of the parameter to modify, S to Save and return to"
echo "the Main Screen, or C to Cancel and return to the Main Screen.";
			read REPLY;
			case $REPLY in
			1) edit_LOGID $SLOT ;;
			2) edit_ACT $SLOT ;;
			3) 
				edit_PCD $SLOT
			;;
			4) edit_FCD $SLOT ;;
			5) edit_PCM $SLOT ;;
			6) edit_BM $SLOT ;;
			7) ShowNICOpts $SLOT ;;
			s|S) update_SLOTS $1 $SLOT ; break ;;
			c|C) SLOT=$OLD_SLOT; break ;;
			*) echo ;;
			esac
		done
		return 0;
	fi
done 
return -1; # couldnt match slot if exiting here
 } # end function ShowOneBoard

function update_SLOTS () { 
UNSAVED_CHANGE=true;
declare -i SLOT_NUM;
declare SLOTS_TMP="";
declare SLOT_TMP="";
	if (test $1 = "-1" ) then
		#GLOBAL_TDM_SETTINGS=$2;
		return;
		# only here to record unsaved change
	fi
	for SLOT_RECORD in $SLOTS_FOUND
	do
		SLOT_NUM=`GetField $SLOT_RECORD $foSLOT`;
		SLOT_1=`GetField $1 $foSLOT`;
		if (test $SLOT_1 -eq $SLOT_NUM ) then
			SLOT_TMP=$2;
		else
			SLOT_TMP=$SLOT_RECORD;
		fi
		SLOTS_TMP="$SLOTS_TMP $SLOT_TMP";
	done
	SLOTS_FOUND=$SLOTS_TMP;
 } # end function update_SLOTS

function edit_LOGID () { 
while true
do
	$CLEAR;
	echo "................................."
	echo ".     Set Board Logical ID      ."
	echo "................................."
	echo "_________________________________"
	echo "The board logical ID must be a"
	echo "unique positive integer from 1-16"
	echo "_________________________________"
	echo "Currently: "`GetField $SLOT $foLOGID`
	echo "_________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_LOGID;
	case $NEW_LOGID in
	[1-9]|1[0-6])
		SLOT=`ChangeField $SLOT $foLOGID $NEW_LOGID`;
		return;
	;;
	"?") ShowHelp '^LOGID'
	;;
	"") return
	;;
	*) echo "Entry not in legal range of 1-16!"
	   echo "Please hit enter to try again"
	   read ack;
	;;
	esac
done
 } # end function edit_LOGID

function edit_NST () { 
while true
do
	if ( test `GetField $SLOT $foNST` = "100BT" ) then
		NST="100Base-T"
	elif ( test `GetField $SLOT $foNST` = "1000BT" ) then
		NST="1000Base-T"
	fi
	$CLEAR;
	echo "..............................................................";
	echo ".                Set Network Type and Speed                  .";
	echo "..............................................................";
	echo "______________________________________________________________";
	echo "Choose 1 if you are connected to a 100Base-T network.";
	echo "Choose 2 if you are connected to a 1000Base-T network.";
	echo "______________________________________________________________";
	echo "1 - 100Base-T"
	echo "2 - 1000Base-T"
	echo "______________________________________________________________";
	echo "Currently: $NST"
	echo "______________________________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen: "
	read NEW_NST;
	case $NEW_NST in
	1)
		NEW_NST="100BT"
		break;
	;;
	2)
		NEW_NST="1000BT"
		break;
	;;
	"?") ShowHelp '^NST'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foNST $NEW_NST`;
	return;
 } # end function edit_NST

function edit_ACT () { 
while true
do
	$CLEAR;
	echo "..............................................................";
	echo ".                  Enable or Disable Board                   .";
	echo "..............................................................";
	echo "______________________________________________________________";
	echo "Choose 1 if you want to enable this board.";
	echo "Selecting 2 will disable the board and comment out the board";
	echo "parameters in the System Configuration Description (SCD) file.";
	echo "______________________________________________________________";
	echo "1 - Yes, I want to enable this board"
	echo "2 - No, I want to disable this board"
	echo "______________________________________________________________";
	echo "Currently: "`GetField $SLOT $foACT`
	echo "______________________________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen: "
	read NEW_ACT;
	case $NEW_ACT in
	1)
		NEW_ACT="Yes"
		break;
	;;
	2)
		NEW_ACT="No"
		break;
	;;
	"?") ShowHelp '^ACT'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foACT $NEW_ACT`;
	return;
 } # end function edit_ACT

function edit_PCD () { 
while true
do
	MODEL_TYPE=`GetField $SLOT $foMODEL`
	$CLEAR;
	echo "...................................................................."
	echo ".                     Specify the PCD File                         ."
	echo "...................................................................."
	echo "____________________________________________________________________"
	echo "A Product Configuration Description (PCD) file must be selected"
	echo "in order to configure your board. The corresponding Feature "
	echo "Configuration Description (FCD) file will be automatically selected."
	echo "For features available in specific PCD files, see the Release Guide."
	echo "The following PCD files are valid for your board:"
	echo "____________________________________________________________________"
	GetPCDList $MODEL_TYPE;
	i=1;
	for PCD in $PCD_LIST
	do
		echo "$i - $PCD";
		i=$i+1;
	done
	i=$i-1;
	echo "Currently: "`GetField $SLOT $foPCD`
	echo "____________________________________________________________________"
	echo ""
	echo "You have several options :"
	echo "------------------------"
	echo "# - Enter the number of the PCD file you want to select from the list above to use one of the supplied single protocol files or your own previoulsy created file"
	
	
	UtilityTag=`GetField $SLOT $foUTILITY_TAG`
	if (test  $UtilityTag) then
		echo "d - Create new PCD files with multiple protocols for the trunks."
	fi
	echo "? - Help"
	echo  "Enter - Return to the previous screen"
	echo ""
	read NEW_PCD;
	case $NEW_PCD in
	[1-9]*)
		if ( test $NEW_PCD -ge 1 -a $NEW_PCD -le $i ) then
			NEW_PCD=`echo $PCD_LIST | cut -d" " -f$NEW_PCD`
			break;
		fi
	;;
	D|d)
		DmvbTag=`echo $UtilityTag | grep "TC_COMET"`
		if (test $DmvbTag) then
			$CLEAR;
			NumTrunks=`GetField $SLOT $foNRNTI`
			LogicalId=`GetField $SLOT $foLOGID`
			PcdFile=`GetField $SLOT $foPCD`
			if(test $PcdFile) then 
 				if (test $PcdFile = "NOT_SET") then
				      ConfigGen -f -d -u $UtilityTag -m $MODEL_TYPE -n $NumTrunks -l $LogicalId 
				      RC=$?
				else

			    	    ConfigGen -f -d -u $UtilityTag -m $MODEL_TYPE  -n $NumTrunks -l $LogicalId -p $PcdFile
				    RC=$?
				fi
			else
			    ConfigGen -f -d -u $UtilityTag -m $MODEL_TYPE  -n $NumTrunks -l $LogicalId
			    RC=$?
			fi
			#if successfule get the pcd file name
			if (test RC==0) then
				#ConfigGen creates a file and puts the pcd file name in it.
				if (test -w $DD_BIN/ConfigGenTempFile) then
					COMPOSITE_PCD_NAME=`cat $DD_BIN/ConfigGenTempFile`
					SLOT=`ChangeField $SLOT $foPCD $COMPOSITE_PCD_NAME`
					#SLOT=`GetField $SLOT $foPCD $NEW_PCD`;
					#echo $NEW_PCD
					# Always match fcd by default
					NEW_FCD=`echo $COMPOSITE_PCD_NAME | cut -d. -f1`".fcd";
					#echo $NEW_FCD
					SLOT=`ChangeField $SLOT $foFCD $NEW_FCD`;
					rm $DD_BIN/ConfigGenTempFile
				fi
			fi
		else
			TempTag=`echo $UtilityTag | grep "TC_QUAD_COMET"`
			if (test $TempTag) then
				DTI16_PCD $SLOT
			fi
		fi
		return;
	;;
	"?") ShowHelp '^PCD'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foPCD $NEW_PCD`;
	# Always match fcd by default
	NEW_FCD=`echo $NEW_PCD | cut -d. -f1`".fcd";
	SLOT=`ChangeField $SLOT $foFCD $NEW_FCD`;
	return;
 } # end function edit_PCD

function DTI16_PCD () { 
declare COMPOSITE_PCD_NAME="";
declare -i NUM=0;
declare -a TRUNK_MAP;
declare -a TRUNK_TYPE;
declare -a PROTOCOL;
declare -i i;
declare -i j;
GetPCDList 4608
i=1;
for PCD in $PCD_LIST
do
	if (test $PCD = `echo $PCD | sed -e 's/^dti16_isdn//'`) then
		echo $PCD > /dev/null
	else
		PROTOCOL[$i]=`echo $PCD | cut -d. -f1`
		TRUNK_MAP[$i]=0;
		NUM=$NUM+1;
		i=$i+1;
	fi
done

i=1;
while (test $i -le $NUM)
do
case ${PROTOCOL[$i]} in
dti16_isdn_4ess) TRUNK_TYPE[$i]="T" ;;
dti16_isdn_5ess) TRUNK_TYPE[$i]="T" ;;
dti16_isdn_dms) TRUNK_TYPE[$i]="T" ;;
dti16_isdn_qsigt1) TRUNK_TYPE[$i]="T" ;;
dti16_isdn_ntt) TRUNK_TYPE[$i]="T" ;;
dti16_isdn_ni2) TRUNK_TYPE[$i]="T" ;;
dti16_isdn_net5) TRUNK_TYPE[$i]="E" ;;
dti16_isdn_qsige1) TRUNK_TYPE[$i]="E" ;;
*) TRUNK_TYPE[$i]="U" ;;
esac
i=$i+1;
done

while true
do
	$CLEAR;
	echo "...................................................................."
	echo ".              Create a Composite DTI16 PCD File                   ."
	echo "...................................................................."
	echo "____________________________________________________________________"
	echo "Choose your configuration from the list below.                      "
	echo "A T or E is used to mark each selection's trunk type. Within each   "
	echo "group all protocols must be of the same trunk type, either T1 or E1."
	echo "The total is limited to 16 in 4 groups of 4.                        "
	echo "Currently only ISDN protocols are supported.                        "
	echo "The corresponding Feature Configuration Description (FCD) file will "
	echo "be automatically created.                                           "
	echo "For features available in specific PCD files, see the Release Guide."
	echo "The following configurations are valid to combine                   "
	echo "____________________________________________________________________"
	echo "Entry              Trunks			Description               "
	echo "____________________________________________________________________"
	echo "	____________________|1|1|1||1|1|1|1||                             "
	echo "	|1|2|3|4||5|6|7|8||9|0|1|2||3|4|5|6||                             "
	echo "	+-+-+-+-++-+-+-+-++-+-+-+-++-+-+-+-++                             "
	i=1
	while (test $i -le $NUM)
	do
		echo -n "$i	|"
		j=0;
		while (test $j -lt 16)
		do
			if (test $(((${TRUNK_MAP[$i]} >> $j) & 1)) -eq 1) then
				echo -n ${TRUNK_TYPE[$i]};
			else
				echo -n " "
			fi
			if (test $((($j+1)%4)) -eq 0) then
				echo -n "||"
			else
				echo -n " "
			fi
			j=$j+1;
		done
		echo "	${PROTOCOL[$i]}"
		i=$i+1;
	done
	echo "____________________________________________________________________"
	echo "Enter an Entry:Trunk pair, e.g. 1:8, to indicate what configuration "
	echo "should be supported on each trunk. A range of trunks can be entered "
	echo "with a dash, i.e. 1:5-8 assigns configuration 1 to trunks 5-8. A    "
	echo "trunk number of zero clears that entry: 1:0 would clear whatever.   "
	echo "trunks had configuration 1 assigned.                                "
	echo "Enter a new value, press ? for help, or press                       "
	echo -n "S to save or C to Cancel and return to the Modify Board screen:  "
	read NEW_NUM;
	P=`echo $NEW_NUM | cut -d: -f1`
	RANGE="`echo $NEW_NUM | cut -d: -f2`"
	case $RANGE in
	0)
		i=1;
		TRUNK_MAP[$P]=0x0;
	;;
	[1-9]-[1-9]|[1-9]-1[0-6]|1[0-6]-1[0-6])
		if (test $P -gt 0 -a $P -le $NUM) then
			START=`echo $RANGE | cut -d- -f1`
			END=`echo $RANGE | cut -d- -f2`
			if (test $START -gt 0 -a $START -lt 16 -a $END -gt 1 -a $END -le 16 -a $START -lt $END) then
				i=$START
				while (test $i -le $END)
				do
					TRUNK_MAP[$P]=$((${TRUNK_MAP[$P]} | (1 << ($i-1))))
					i=$i+1;
				done
			else
				$CLEAR
				echo "Invalid Entry: Trunk number or range not recognized.   ";
				echo "Please select a range whose start is less than its end,";
				echo "and whose start and end are in the 1 to 16 range.      ";
				echo "Hit enter to continue.                                 ";
				read ACK;
			fi
		else
			$CLEAR
			echo "Invalid Entry: Protocol number out of range.";
			echo "Please select a protocol between 1 and $NUM.";
			echo "Hit enter to continue.";
			read ACK;
		fi
	;;
	[1-9]|1[0-6])
		if (test $P -gt 0 -a $P -le $NUM) then
			TRUNK_MAP[$P]=$((${TRUNK_MAP[$P]} | (1 << ($RANGE-1))))
		else
			$CLEAR
			echo "Invalid Entry: Protocol number out of range.";
			echo "Please select a protocol between 1 and $NUM.";
			echo "Hit enter to continue.";
			read ACK;
		fi
	;;
	c|C)
		return
	;;
	s|S)
		$CLEAR
		MAP="";
		echo "Generating File, Please wait a moment."
		i=1;
		declare -a GROUP;
		GROUP[1]="";
		GROUP[2]="";
		GROUP[3]="";
		GROUP[4]="";
		declare -i WHOLE_MAP=0;
		while (test $i -le $NUM)
		do
			if (test  ${TRUNK_MAP[$i]} -gt 0) then
				if (test  $((${TRUNK_MAP[$i]} & $WHOLE_MAP)) -eq 0) then
					if (test $((${TRUNK_MAP[$i]} & 0xF)) -gt 0 -a "${GROUP[1]}" = "") then
						GROUP[1]=${TRUNK_TYPE[$i]};
					elif (test $((${TRUNK_MAP[$i]} & 0xF)) -gt 0 -a "${GROUP[1]}" != "" -a "${GROUP[1]}" != "${TRUNK_TYPE[$i]}" ) then
						$CLEAR
						echo "Invalid Entry: E1 and T1 trunk types";
						echo "cannot be mixed within a block of 4."
						echo "Location: trunk group 1-4";
						echo "Please fix this and try again."
						echo "Hit enter to continue.";
						read ACK;
						continue 2;
					fi
					if (test $((${TRUNK_MAP[$i]} & 0xF0)) -gt 0 -a "${GROUP[2]}" = "") then
						GROUP[2]=${TRUNK_TYPE[$i]};
					elif (test $((${TRUNK_MAP[$i]} & 0xF0)) -gt 0 -a "${GROUP[2]}" != "" -a "${GROUP[2]}" != "${TRUNK_TYPE[$i]}" ) then
						$CLEAR
						echo "Invalid Entry: E1 and T1 trunk types";
						echo "cannot be mixed within a block of 4."
						echo "Location: trunk group 5-8";
						echo "Please fix this and try again."
						echo "Hit enter to continue.";
						read ACK;
						continue 2;
					fi
					if (test $((${TRUNK_MAP[$i]} & 0xF00)) -gt 0 -a "${GROUP[3]}" = "") then
						GROUP[3]=${TRUNK_TYPE[$i]};
					elif (test $((${TRUNK_MAP[$i]} & 0xF00)) -gt 0 -a "${GROUP[3]}" != "" -a "${GROUP[3]}" != "${TRUNK_TYPE[$i]}" ) then
						$CLEAR
						echo "Invalid Entry: E1 and T1 trunk types";
						echo "cannot be mixed within a block of 4."
						echo "Location: trunk group 9-12";
						echo "Please fix this and try again."
						echo "Hit enter to continue.";
						read ACK;
						continue 2;
					fi
					if (test $((${TRUNK_MAP[$i]} & 0xF000)) -gt 0 -a "${GROUP[4]}" = "") then
						GROUP[4]=${TRUNK_TYPE[$i]};
					elif (test $((${TRUNK_MAP[$i]} & 0xF000)) -gt 0 -a "${GROUP[4]}" != "" -a "${GROUP[4]}" != "${TRUNK_TYPE[$i]}" ) then
						$CLEAR
						echo "Invalid Entry: E1 and T1 trunk types";
						echo "cannot be mixed within a block of 4."
						echo "Location: trunk group 13-16";
						echo "Please fix this and try again."
						echo "Hit enter to continue.";
						read ACK;
						continue 2;
					fi
					WHOLE_MAP=$((${TRUNK_MAP[$i]} | $WHOLE_MAP))
					MAP="$MAP -m$i ${TRUNK_MAP[$i]} -p$i ${PROTOCOL[$i]}"
				else
					$CLEAR
					echo "Invalid Entry: ${PROTOCOL[$i]} is specified for one.";
					echo "or more trunks that already have a protocol assigned."
					echo "Please fix this and try again."
					echo "Hit enter to continue.";
					read ACK;
					continue 2;
				fi
			fi
			i=$i+1
		done
		OLD_DIR=`pwd`;
		cd $DD_BIN;
		COMPOSITE_PCD_NAME=`tclsh $DD_BIN/dti16_cfg.tcl $MAP`
		cd $OLD_DIR
		SLOT=`ChangeField $SLOT $foPCD $COMPOSITE_PCD_NAME`;
		break
	;;
	"?") ShowHelp '^DTI16_PCD'
	;;
	*)
		$CLEAR
		echo "Invalid Entry: Trunk number or range not recognized.";
		echo "Please select a trunk between 1 and 16,";
		echo "or a range whose start is less than its end."
		echo "Hit enter to continue.";
		read ACK;
	;;
	esac
done
# Always match fcd by default
	NEW_FCD=`echo $COMPOSITE_PCD_NAME | cut -d. -f1`".fcd";
	SLOT=`ChangeField $SLOT $foFCD $NEW_FCD`;
	return;
} # end DTI16_PCD

function edit_FCD () { 
while true
do
	$CLEAR;
	echo "................................................";
	echo ".            Specify the FCD File              ."
	echo "................................................";
	echo "________________________________________________"
	echo "The FCD file should match the PCD file used!"
	echo "Using other FCD files may prevent downloading."
	echo "A matching FCD/PCD pair are selected when you"
	echo "choose a PCD file. You should change this only"
	echo "if you have specific need, and knowledge that a"
	echo "different file is required for your application." 
	echo "________________________________________________"
	echo "Currently: "`GetField $SLOT $foFCD`
	echo "________________________________________________"
	echo "0 to specify no FCD file (not recommended)"
	echo "Enter the new name or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_FCD;
	case $NEW_FCD in
	0)
		NEW_FCD="";
		break;
	;;
	"")
		return;
	;;
	"?") ShowHelp '^FCD'
	;;
	*)
		if ( test -e $DD_DATA/$NEW_FCD ) then
			break;
		fi
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foFCD $NEW_FCD`;
	return;
 } # end function edit_FCD

function edit_BM () { 
while true
do
	$CLEAR;
	echo "......................................................................";
	echo ".                   Set TDM Bus Master Status                        ."
	echo "......................................................................";
	echo "______________________________________________________________________";
	echo "Select one of the following:"
	echo "______________________________________________________________________";
	echo "1 - PRIMARY (This board will act as Clock Master)"
	echo "2 - SECONDARY (CT Bus Only, backup Clock Master if the Primary fails)"
	echo "3 - SLAVE (always gets Clock from another board)"
	echo "______________________________________________________________________";
	echo "Currently: "`GetField $SLOT $foBM`
	echo "______________________________________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_BM;
	case $NEW_BM in
	1)
		NEW_BM="PRIMARY";
		break;
	;;
	2)
		NEW_BM="SECONDARY";
		break;
	;;
	3)
		NEW_BM="SLAVE";
		break;
	;;
	"?") ShowHelp '^BM'
	;;
	*) return
	;;
	esac
done
SLOT=`ChangeField $SLOT $foBM $NEW_BM`;
if (test $NEW_BM = "PRIMARY" ) then
	NEW_SLOT=`GetField $SLOT $foSLOT`
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foSLOT $NEW_SLOT`;
	NEW_MODEL=`GetField $SLOT $foMODEL`
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foMODEL $NEW_MODEL`;
	NEW_LOGID=`GetField $SLOT $foLOGID`
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foLOGID $NEW_LOGID`;
	NEW_CNAME=`GetField $SLOT $foCNAME`
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCNAME $NEW_CNAME`;
	NEW_PNTI=`GetField $SLOT $foNTI`
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foPNTI $NEW_PNTI`;
fi
return;

 } # end function edit_BM

function edit_TDM () { 
declare CR;
declare -i PREV;
declare -i POST;
while true
do
	CL_CURRENT=`GetField $1 $foCL`;
	$CLEAR;
	echo "................................................"
	echo ".              Set TDM Bus Type                ."
	echo "................................................"
	echo "________________________________________________"
	echo "This value is used for the Primary Clock Master."
	echo "Select one of the following:"
	echo "________________________________________________"
	echo "1 - H100"
	echo "2 - H110"
	echo "3 - SCBUS"
	echo "________________________________________________"
	echo "Currently: "`GetField $GLOBAL_TDM_SETTINGS $foTDM`
	echo "________________________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen: "
	read NEW_TDM;
	case $NEW_TDM in
	1)
		NEW_TDM="H100"
		CR="8";
		if (test $CL_CURRENT = "NA") then
			NEW_CL="CT_A";
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCL $NEW_CL`;
		fi
		if ( `GetField $GLOBAL_TDM_SETTINGS $foCS` = "NETREF_2" ) then
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCS "NOT_SET"`;
		fi
		break;
	;;
	2)
		NEW_TDM="H110"
		CR="8";
		if (test $CL_CURRENT = "NA") then
			NEW_CL="CT_A";
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCL $NEW_CL`;
		fi
		break;
	;;
	3)
		NEW_TDM="SCBUS"
		CR="4";
		if ( test `GetField $GLOBAL_TDM_SETTINGS $foCS` = "NETREF_1" \
		-o `GetField $GLOBAL_TDM_SETTINGS $foCS` = "NETREF_2" ) then
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCS "NOT_SET"`;
		fi
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCL "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME "NA"`;
		break;
	;;
	"?") ShowHelp '^TDM'
	;;
	*) return
	;;
	esac
done
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foTDM $NEW_TDM`;
	# Always set clock rates to appropriate default
	NEW_BCR=$CR;
	NEW_G1CR=$CR;
	NEW_G2CR=$CR;
	NEW_G3CR=$CR;
	NEW_G4CR=$CR;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foBCR $NEW_BCR`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG1CR $NEW_G1CR`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG2CR $NEW_G2CR`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG3CR $NEW_G3CR`;
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foG4CR $NEW_G4CR`;
	return;
 } # end function edit_TDM

function edit_PCM () { 
while true
do
	$CLEAR;
	echo "..............................................................."
	echo ".                 Set PCM Encoding Method                     ."
	echo "..............................................................."
	echo "_______________________________________________________________"
	echo "Use the default value unless NOT_SET is displayed."
	echo "NOT_SET indicates that the PCM encoding cannot be determined."
	echo "This usually occurs because the board does not have a telephony"
	echo "network front end (e.g., resource-only board)."
	echo "Select one of the following:"
	echo "_______________________________________________________________"
	echo "1 - MULAW (standard for T1)"
	echo "2 - ALAW (standard for E1)"
	echo "_______________________________________________________________"
	echo "Currently: "`GetField $SLOT $foPCM`
	echo "_______________________________________________________________"
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen: "
	read NEW_PCM;
	case $NEW_PCM in
	1)
		NEW_PCM="MULAW"
		break;
	;;
	2)
		NEW_PCM="ALAW"
		break;
	;;
	"?") ShowHelp '^PCM'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foPCM $NEW_PCM`;
	return;
 } # end function edit_PCM

function edit_BCR () { 
# CURRENTLY THIS FUNCTION IS UNUSED AS ONLY ONE
# VALUE PER BUS TYPE IS SUPPORTED AT THIS TIME
while true
do
	$CLEAR;
	echo "TDM Bus Clock Rate"
	echo "Must be one of:"
	echo "8 (H100 and H110 only)"
	echo "4 (SCBUS only)"
	echo "Currently: "`GetField $SLOT $foBCR`
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_BCR;
	case $NEW_BCR in
	4)
		break;
	;;
	8)
		break;
	;;
	"?") ShowHelp '^BCR'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foBCR $NEW_BCR`;
	return;
 } # end function edit_BCR

function edit_G1CR () { 
# CURRENTLY THIS FUNCTION IS UNUSED AS ONLY
# ONE VALUE IS SUPPORTED AT THIS TIME
while true
do
	$CLEAR;
	echo "Group 1 Clock Rate"
	echo "Must be one of:"
	echo "8 (H100 and H110 only)"
	echo "Currently: "`GetField $SLOT $foG1CR`
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_G1CR;
	case $NEW_G1CR in
	8)
		break;
	;;
	"?") ShowHelp '^GxCR'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foG1CR $NEW_G1CR`;
	return;
 } # end function edit_G1CR

function edit_G2CR () { 
# CURRENTLY THIS FUNCTION IS UNUSED AS ONLY
# ONE VALUE IS SUPPORTED AT THIS TIME
while true
do
	$CLEAR;
	echo "Group 2 Clock Rate"
	echo "Must be one of:"
	echo "8 (H100 and H110 only)"
	echo "Currently: "`GetField $SLOT $foG2CR`
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_G2CR;
	case $NEW_G2CR in
	8)
		break;
	;;
	"?") ShowHelp '^GxCR'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foG1CR $NEW_G2CR`;
	return;
 } # end function edit_G2CR

function edit_G3CR () { 
# CURRENTLY THIS FUNCTION IS UNUSED AS ONLY
# ONE VALUE IS SUPPORTED AT THIS TIME
while true
do
	$CLEAR;
	echo "Group 3 Clock Rate"
	echo "Must be one of:"
	echo "8 (H100 and H110 only)"
	echo "Currently: "`GetField $SLOT $foG3CR`
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_G3CR;
	case $NEW_G3CR in
	8)
		break;
	;;
	"?") ShowHelp '^GxCR'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foG1CR $NEW_G3CR`;
	return;
 } # end function edit_G3CR

function edit_G4CR () { 
# CURRENTLY THIS FUNCTION IS UNUSED AS ONLY
# ONE VALUE IS SUPPORTED AT THIS TIME
while true
do
	$CLEAR;
	echo "Group 4 Clock Rate"
	echo "Must be one of:"
	echo "8 (H100 and H110 only)"
	echo "Currently: "`GetField $SLOT $foG4CR`
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_G4CR;
	case $NEW_G4CR in
	8)
		break;
	;;
	"?") ShowHelp '^GxCR'
	;;
	*) return
	;;
	esac
done
	SLOT=`ChangeField $SLOT $foG1CR $NEW_G4CR`;
	return;
 } # end function edit_G4CR

function edit_CS () { 
declare -i NTI=`GetField $GLOBAL_TDM_SETTINGS $foPNTI`
while true
do
	$CLEAR;
	echo ".........................................";
	echo ".           Set Clock Source            .";
	echo ".........................................";
	echo "_________________________________________";
	echo "Select one of the following:"
	echo "_________________________________________";
	echo "O - Oscillator (board's internal clock)"
	echo "1-$NTI - Trunk 1-$NTI"
	echo "N1 - NETREF 1"
	echo "N2 - NETREF 2 (H110 only)"
	echo "_________________________________________";
	echo "Currently: "`GetField $GLOBAL_TDM_SETTINGS $foCS`
	echo "_________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_CS;
	case $NEW_CS in
	[0-9]*)
		declare -i CS=$NEW_CS
		echo $CS $NTI
		if ( test $CS -le $NTI -a $CS -gt 0 ) then
			break;
		fi
	;;
	O|o|0)
		NEW_CS="OSC";
		break;
	;;
	[Nn]1)
		NEW_CS="NETREF_1";
		break;
	;;
	[Nn]2)
		NEW_CS="NETREF_2";
		break;
	;;
	"?") ShowHelp '^CS'
	;;
	*) return
	;;
	esac
done
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCS $NEW_CS`;
	if ( test $NEW_CS = "NETREF_1" \
	-o $NEW_CS = "NETREF_2" ) then
		declare FOUND=false;
		for SLOT in $SLOTS_FOUND
		do
			if ( test `GetField $SLOT $foBM` = "PRIMARY" ) then
				FOUND=true;
				NEW_SLOT=`GetField $SLOT $foSLOT`;
				GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT $NEW_SLOT`;
				NEW_MODEL=`GetField $SLOT $foMODEL`;
				GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL $NEW_MODEL`;
				NEW_LOGID=`GetField $SLOT $foLOGID`;
				GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID $NEW_LOGID`;
				GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS "1"`;
				NEW_CNAME=`GetField $SLOT $foCNAME`;
				GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME $NEW_CNAME`;
				NEW_NTI=`GetField $SLOT $foNTI`;
				GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRNTI $NEW_NTI`;
			fi
		done
		if ( test $FOUND = false ) then
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRNTI "NOT_SET"`;
		fi
		if (test $NEW_CS = "NETREF_2") then
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FMODEL "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCNAME "NA"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI "NA"`;
		else
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FMODEL "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCNAME "NOT_SET"`;
			GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI "NOT_SET"`;
		fi
	else
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRSLOT "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRMODEL "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRLOGID "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCS "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRCNAME "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNRNTI "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FSLOT "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FMODEL "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FLOGID "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCS "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FCNAME "NA"`;
		GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foNR1FNTI "NA"`;
	fi
	return;
 } # end function edit_CS

function edit_CL () { 
while true
do
	$CLEAR;
	echo "............................................................";
	echo ".             Set Primary CT Bus Clock Line                .";
	echo "............................................................";
	echo "____________________________________________________________";
	echo "Specify whether the primary clock will use Line A or Line B.";
	echo "Select one of the following:"
	echo "____________________________________________________________";
	echo "1 - CT_A"
	echo "2 - CT_B"
	echo "____________________________________________________________";
	echo "Currently: "`GetField $GLOBAL_TDM_SETTINGS $foCL`
	echo "____________________________________________________________";
	echo "Enter a new value or press ? for help or"
	echo -n "press Enter to return to the previous screen:"
	read NEW_CL;
	case $NEW_CL in
	1)
		NEW_CL="CT_A";
		break;
	;;
	2)
		NEW_CL="CT_B";
		break;
	;;
	"?") ShowHelp '^CL'
	;;
	*) return
	;;
	esac
done
	GLOBAL_TDM_SETTINGS=`ChangeField $GLOBAL_TDM_SETTINGS $foCL "$NEW_CL"`;
	return;
 } # end function edit_CL

function NewConfig () { 
	echo in function NewConfig
 } # end function NewConfig

function LoadConfig () { 
	echo in function LoadConfig
 } # end function LoadConfig

function SaveConfig () { 
$CLEAR
if ( test -w $SCD_FILE_NAME ) then
	SHORT_SCD=`basename $SCD_FILE_NAME`
	SHORT_OLD_SCD=$SHORT_SCD"_"`date +%Y%j%H%M`
	OLD_SCD=$SCD_FILE_NAME"_"`date +%Y%j%H%M`
	echo "An SCD file named $SHORT_SCD already exists."
	echo "If you answer yes, the previous version will be"
	echo "renamed $SHORT_OLD_SCD."
	echo " "
	echo "Rename existing"
	echo $SCD_FILE_NAME
	echo "to"
	echo $OLD_SCD
	echo -n "and write new $SHORT_SCD ? [y|n]"
	read OW
	case $OW in
	y|Y)
		mv $SCD_FILE_NAME $OLD_SCD
		echo "; SCD File" > $SCD_FILE_NAME
		echo "; written on `date`" >> $SCD_FILE_NAME
		echo "; written by DM3_cfg.sh $VERSION" >> $SCD_FILE_NAME
		echo "Writing SCD Parameters..."
	;;
	*)
		return -1;
	;;
	esac
elif ( test -r $SCD_FILE_NAME ) then
	echo "$SCD_FILE_NAME is Read-Only"
	echo "You must choose a different filename"
	echo "or change the permissions on this file"
	echo "Press enter to continue"
	read ack
	return -1;
else
	echo "; SCD File" > $SCD_FILE_NAME
	echo "; written on `date`" >> $SCD_FILE_NAME
	echo "; written by DM3_cfg.sh $VERSION" >> $SCD_FILE_NAME
fi

echo "NumStreams	: 4000" >> $SCD_FILE_NAME;
echo "NumBindHandles	: 4000" >> $SCD_FILE_NAME;
echo ""

echo "[TDMBus 0] {" >> $SCD_FILE_NAME
echo $COMMENT"TDMBusType	: `GetField $GLOBAL_TDM_SETTINGS $foTDM`" >> $SCD_FILE_NAME
echo $COMMENT"BusCR		: `GetField $GLOBAL_TDM_SETTINGS $foBCR`" >> $SCD_FILE_NAME
if ( test `GetField $GLOBAL_TDM_SETTINGS $foTDM` = "H100" \
	-o `GetField $GLOBAL_TDM_SETTINGS $foTDM` = "H110" ) then
	echo $COMMENT"Group1CR	: `GetField $GLOBAL_TDM_SETTINGS $foG1CR`" >> $SCD_FILE_NAME
	echo $COMMENT"Group2CR	: `GetField $GLOBAL_TDM_SETTINGS $foG2CR`" >> $SCD_FILE_NAME
	echo $COMMENT"Group3CR	: `GetField $GLOBAL_TDM_SETTINGS $foG3CR`" >> $SCD_FILE_NAME
	echo $COMMENT"Group4CR	: `GetField $GLOBAL_TDM_SETTINGS $foG4CR`" >> $SCD_FILE_NAME
	echo $COMMENT"PrimaryLines	: `GetField $GLOBAL_TDM_SETTINGS $foCL`" >> $SCD_FILE_NAME
fi
echo "}" >> $SCD_FILE_NAME

for SLOT in $SLOTS_FOUND
do
if ( test `GetField $SLOT $foACT` = "Yes" ) then
	COMMENT=""
else
	COMMENT="; "
fi
echo $COMMENT"[Board `GetField $SLOT $foLOGID`] {" >> $SCD_FILE_NAME
echo $COMMENT"PCDName		: `GetField $SLOT $foPCD`" >> $SCD_FILE_NAME
echo $COMMENT"FCDName		: `GetField $SLOT $foFCD`" >> $SCD_FILE_NAME
echo $COMMENT"PCMEncoding	: `GetField $SLOT $foPCM`" >> $SCD_FILE_NAME
echo $COMMENT"SlotNumber	: `GetField $SLOT $foSLOT`" >> $SCD_FILE_NAME
echo $COMMENT"BusType		: PCI" >> $SCD_FILE_NAME
echo $COMMENT"LogFile		: board`GetField $SLOT $foLOGID`.log" >> $SCD_FILE_NAME
echo $COMMENT"DisplayConfig	: YES" >> $SCD_FILE_NAME
echo $COMMENT"TimeToSendMsg	: 50" >> $SCD_FILE_NAME
echo $COMMENT"MasterStatus	: `GetField $SLOT $foBM`" >> $SCD_FILE_NAME

if ( test `GetField $SLOT $foBM` = "PRIMARY" ) then
	echo $COMMENT"DeriveClockFrom	: `GetField $GLOBAL_TDM_SETTINGS $foCS`" >> $SCD_FILE_NAME
fi

if ( test `GetField $SLOT $foSLOT` = `GetField $GLOBAL_TDM_SETTINGS $foNRSLOT` ) then
	if ( test `GetField $GLOBAL_TDM_SETTINGS $foCS` = "NETREF_1" ) then
		echo $COMMENT"NetRef1		: YES" >> $SCD_FILE_NAME
		echo $COMMENT"NetRef1From	: `GetField $GLOBAL_TDM_SETTINGS $foNRCS`" >> $SCD_FILE_NAME
		echo $COMMENT"NetRef1CR	: 1" >> $SCD_FILE_NAME
	elif ( test `GetField $GLOBAL_TDM_SETTINGS $foCS` = "NETREF_2" ) then
		echo $COMMENT"NetRef2		: YES" >> $SCD_FILE_NAME
		echo $COMMENT"NetRef2From	: `GetField $GLOBAL_TDM_SETTINGS $foNRCS`" >> $SCD_FILE_NAME
		echo $COMMENT"NetRef2CR	: 1" >> $SCD_FILE_NAME
	fi
fi

if ( test `GetField $SLOT $foSLOT` = `GetField $GLOBAL_TDM_SETTINGS $foNR1FSLOT` ) then
		echo $COMMENT"NetRef1Fallback		: YES" >> $SCD_FILE_NAME
		echo $COMMENT"NetRef1FromFallback	: `GetField $GLOBAL_TDM_SETTINGS $foNR1FCS`" >> $SCD_FILE_NAME
		#echo $COMMENT"NetRef1CR		: 1" >> $SCD_FILE_NAME
fi

if ( test `GetField $SLOT $foNIC` = "Yes" ) then
	echo $COMMENT" [NIC 1] {" >> $SCD_FILE_NAME
	echo $COMMENT"  IPAddress		: `GetField $SLOT $foBIP`" >> $SCD_FILE_NAME
	echo $COMMENT"  SubnetMask		: `GetField $SLOT $foBSM`" >> $SCD_FILE_NAME
	echo $COMMENT"  TargetName		: `GetField $SLOT $foBN`" >> $SCD_FILE_NAME
	echo $COMMENT"  HostIPAddress		: `GetField $SLOT $foHIP`" >> $SCD_FILE_NAME
	echo $COMMENT"  HostName		: `GetField $SLOT $foHN`" >> $SCD_FILE_NAME
	echo $COMMENT"  UserName		: `GetField $SLOT $foHUID`" >> $SCD_FILE_NAME
	echo $COMMENT"  GatewayIPAddress	: `GetField $SLOT $foGIP`" >> $SCD_FILE_NAME
	echo $COMMENT" }" >> $SCD_FILE_NAME
fi
echo $COMMENT"}" >> $SCD_FILE_NAME
done
UNSAVED_CHANGE=false;
NO_CHANGE=false;
return 0;
 } # end function SaveConfig

function ChangeSCD () { 
$CLEAR;
DIRNAME=`dirname $SCD_FILE_NAME`;
BASENAME=`basename $SCD_FILE_NAME`;
echo "Change SCD filename"
echo "................................................"
echo "WARNING: You accessed this hidden function by"
echo "entering X at the main screen. It is recommended"
echo "that you do NOT change the SCD filename from"
echo "the default of pyramid.scd."
echo "................................................"
echo "SCD file location $DIRNAME";
echo "Change SCD file name (currently $BASENAME)";
echo "Hit Enter to exit without changing";
echo -n "New SCD Filename: "
read NEW_NAME;
case $NEW_NAME in 
"") return 0;
;;
[a-zA-Z0-9]*.scd)
	if ( test ! -e $DIRNAME/$NEW_NAME ) then
		SCD_FILE_NAME=$DIRNAME/$NEW_NAME;
		return 0;
	elif ( test -w $DIRNAME/$NEW_NAME ) then
		echo "Filename Exists!"
		echo "Are you sure? [y/n]"
		read ack
		case $ack in
		y|Y)
			SCD_FILE_NAME=$DIRNAME/$NEW_NAME;
			return 0;
		;;
		*)
			return -1;
		;;
		esac
	else
		echo "Filename Exists and is Read-Only!"
		echo "You must choose a different filename"
		echo "or change the permissions on this file"
		echo "Press enter to continue"
		read ack
		return -1;
	fi
;;
[a-zA-Z0-9_]*)
	NEW_NAME=$NEW_NAME".scd"
	if ( test ! -e $DIRNAME/$NEW_NAME ) then
		SCD_FILE_NAME=$DIRNAME/$NEW_NAME;
		return 0;
	elif ( test -w $DIRNAME/$NEW_NAME ) then
		echo "Filename Exists!"
		echo "Are you sure? [y/n]"
		read ack
		case $ack in
		y|Y)
			SCD_FILE_NAME=$DIRNAME/$NEW_NAME;
			return 0;
		;;
		*)
			return -1;
		;;
		esac
	else
		echo "Filename Exists and is Read-Only!"
		echo "You must choose a different filename"
		echo "or change the permissions on this file"
		echo "Press enter to continue"
		read ack
		return -1;
	fi
;;
esac
 } # end function ChangeSCD

function ConsistencyCheck () { 
declare -i NUM_ACTIVE=0;
declare -i NUM_MASTERS=0;
declare -i NUM_PCD_NOT_SET=0;
declare LOGIDS="";
WARNINGS=false;
for SLOT in $SLOTS_FOUND
do
	if ( test `GetField $SLOT $foACT` = "Yes" ) then
		NUM_ACTIVE=$NUM_ACTIVE+1;
		if ( test `GetField $SLOT $foPCD` = "NOT_SET" ) then
			NUM_PCD_NOT_SET=$NUM_PCD_NOT_SET+1;
		fi
		if ( test `GetField $SLOT $foBM` = "PRIMARY" ) then
			NUM_MASTERS=$NUM_MASTERS+1;
		fi
		echo `GetField $SLOT $foLOGID` >> /tmp/tmp.LOGID;
	fi
done
$CLEAR;
if (test $NUM_ACTIVE -eq 0 ) then
	WARNINGS=true;
	echo "-------------------------------------------------"
	echo "WARNING: You have no active boards specified!"
	echo "-------------------------------------------------"
else
	if (test $NUM_MASTERS -eq 0) then
		WARNINGS=true;
		echo "-------------------------------------------------"
		echo "WARNING: You do not have an active board"
		echo "specified as the PRIMARY clock master!"
		echo "If you plan to use a non-DM3 board as the"
		echo "clock master in this system you can enter"
		echo "yes to clear this warning. Otherwise press"
		echo "enter to continue the consistency check."
		echo "-------------------------------------------------"
		echo "Do you plan to use a non-DM3 clock master? y|n"
		read ack
		case $ack in
		y|Y|"Yes"|"YES"|"yes")
			WARNINGS=false;
		;;
		*)
			echo "No Clock Master Chosen";
		;;
		esac
	fi
	if (test $NUM_MASTERS -gt 1) then
		WARNINGS=true;
		echo "-------------------------------------------------"
		echo "WARNING: You have more than one active board"
		echo "specified as the PRIMARY clock master!"
		echo "-------------------------------------------------"
	fi
	if (test $NUM_PCD_NOT_SET -gt 0) then
		WARNINGS=true;
		echo "-------------------------------------------------"
		echo "WARNING: You do not have a PCD file specified"
		echo "for $NUM_PCD_NOT_SET active boards!"
		echo "-------------------------------------------------"
	fi
	DUP_LOGIDS=`sort /tmp/tmp.LOGID | uniq -d`;
	if (test ${#DUP_LOGIDS} -ne 0 ) then
		WARNINGS=true;
		echo "-------------------------------------------------"
		echo "WARNING: The following Logical IDs:"
		echo $DUP_LOGIDS
		echo "are duplicates."
		echo "Logical IDs should be unique."
		echo "-------------------------------------------------"
	fi
fi
if (test -e /tmp/tmp.LOGID) then
	rm /tmp/tmp.LOGID
fi
if (test $WARNINGS = true) then
	echo "Do you wish to continue despite these warnings?"
	echo "Doing so will create an SCD file that will cause a"
	echo "failure if you attempt to download boards with it."
	echo "Y to continue, Enter to resume without saving"
	read ack
	case $ack in
	y|Y|"Yes"|"YES"|"yes")
		return 0;
	;;
	*)
		return -1;
	;;
	esac
fi
return 0;
 } # end function ConsistencyCheck

function MainMenu () { 
declare -i EXIT_CODE;
EXIT_CODE=0;
	echo "Enter the slot number of the board to configure,";
	echo "T to change TDM Bus Settings, S to Save and quit,";
	echo -n "or Q to Quit without saving: ";
	read ACTION
	case $ACTION in
	X)
		ChangeSCD;	
	;;
	s|S)
		ConsistencyCheck && SaveConfig;
		$CLEAR;
		if ( test $NO_CHANGE = true ) then
			EXIT_CODE=$EXIT_CODE+1;
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "! You have NOT CONFIGURED your boards !"
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo " "
		fi
		if ( test $UNSAVED_CHANGE = true ) then
			EXIT_CODE=$EXIT_CODE+2;
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "!   You have NOT SAVED your changes   !"
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo " "
		fi
		if ( test $WARNINGS = true ) then
			EXIT_CODE=$EXIT_CODE+4;
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "!    You have unresolved WARNINGS     !"
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo " "
			
		fi
		if ( test $EXIT_CODE -ne 0 ) then
			echo -n "Are you sure you want to Quit? [y|n]"
			read ack
			case $ack in
			y|Y|"Yes"|"yes"|"YES")
				echo $EXIT_CODE;
				exit $EXIT_CODE;
			;;
			*)
				echo "resuming...";
			;;
			esac
		else
			exit 0
		fi
	;;
	q|Q)
		$CLEAR;
		if ( test $NO_CHANGE = true ) then
			EXIT_CODE=$EXIT_CODE+1;
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "! You have NOT CONFIGURED your boards !"
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo " "
		fi
		if ( test $UNSAVED_CHANGE = true ) then
			EXIT_CODE=$EXIT_CODE+2;
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "!   You have NOT SAVED your changes   !"
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo " "
		fi
		if ( test $WARNINGS = true ) then
			EXIT_CODE=$EXIT_CODE+4;
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo "!    You have unresolved WARNINGS     !"
			echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			echo " "
			
		fi
		echo -n "Are you sure you want to Quit? [y|n]"
		read ack
		case $ack in
		y|Y|"Yes"|"yes"|"YES")
			echo $EXIT_CODE;
			exit $EXIT_CODE;
		;;
		*)
			echo "resuming...";
		;;
		esac
	;;
	[0-9]*)
		declare -i i=1;
		declare -i TMP;
		while ( test $i -le $NUM_VALID_BOARDS )
		do
			TMP=`echo $VALID_BOARDS | cut -d"|" -f"$i"`;
			if ( test $TMP -eq $ACTION ) then
				ShowOneBoard $ACTION;
				break;
			else
				i=$i+1;
			fi
		done
	;;
	T|t)
		ShowClockOpts;
	;;
	*)
	;;
	esac
	return 0;
 } # end function MainMenu

# MAIN LOOP
$CLEAR
echo "..........................................................";
echo "                        IMPORTANT!                        ";
echo "This application generates a System Configuration file for";
echo "Intel NetStructure DM Series Boards at Installation time. ";
echo "The use of this utility post-Installation will result in  ";
echo "the resetting of many parameters to Install-time defaults,";
echo "and require the re-entry of any changed parameters.       ";
echo "                                                          ";
echo "Your previous, automatically saved, configuration files   ";
echo "are available in the cfg directory.                       ";
echo "..........................................................";
echo -n "press Enter to continue:"
Check4Boards;
PopulateData;
read ACK;
UNSAVED_CHANGE=false;
WARNINGS=false;
NO_CHANGE=true;
while true
do
	ShowAllBoards;
	MainMenu;
done
