#!/usr/bin/perl -w

use Socket;


#SNMP Command line defaults

my $AGENT_HOST = "146.152.80.185";
my $AGENT_PORT= ":161";
my $AGENT_VERSION = "1";
my $AGENT_COMM_READ= "Craftsperson";
my $AGENT_COMM_WRITE= "Administrator";
my $AGENT_USERNAME= "Administrator";
my $AGENT_PASSPHRASE= "Administrator";
my $AGENT_CONTEXT = "auth";
my $CLIENT_MIBDIR  = "/usr/share/snmp/mibs/";
my $AGENT_PASSWORD= "Administrator";
my $AGENT_ENCRYPT_PROTO= "MD5";
my $AGENT_SECLEVEL = "authNoPriv";

my $NETTOOL ="../netsnmptools/";
my $SNMP_GETCMD= "${NETTOOL}snmpget";
my $SNMP_SETCMD= "snmpset";
my $SNMP_WALKCMD= "snmpwalk";
my $SNMP_TABLECMD= "snmptable";

my $sysVar;
my $sysNameGetCmd;

my $argvCnt;

#Funtion defitions

sub myHelp
{
	
	print "NAME \n";
	print "		bm - board manager perl script on top of snmp client\n";
	print "SYNOPSIS\n";
	print "	bm \[options] \[-t\] \[-v\] \[-u\] \[-p\] \n";
	print "DESCRIPTION\n";
	print "		This perl scripts wraps various snmp client commands \n";
	print "		such as snmpget, snmpset, snmptable. This perl  \n";
	print "		script basically hides any snmp manager cli complexity\n";
	
	
	print "Options: \n";
	print "	-get = get information \n";
	print "		-i = interface \n";
	print "			-t = interface type [media, ds1, ether, all, mib2] all=default\n";
	print "			ex:  perl bm.pl -get -i -t media\n";
	print "		-s = system \n";
	print "			-t = type [status,all] all=default\n";
	print "			ex:  perl bm.pl -get -s -t status\n";
	print "		-h = hardware \n";
	print "			-t = type [base,amc,bled, aled] amc=default\n";
	print "			base = baseboard, bled = baseboard LEDS\n";
	print "			aled = amc LEDS\n";
	print "			ex:  perl bm.pl -get -h -t base\n";
	print "		-p = pstn \n";
	print "			-t = type [limit] limit=default\n";
	print "			limit = trunk limits\n";
	print "			ex:  perl bm.pl -get -p -t limit\n";
	print "\n";
	print "	-set = set information \n";
	print "		-m = Media  \n";
	print "			-t = type  [service] service=default\n";
	print "			-v = value [start,stop] start=default\n";
	print "			ex:  perl bm.pl -set -m -t service -v start\n";
	print "		-p = pstn  \n";
	print "			-t = type  [limit] limit=default\n";
	print "			-v = value [1..16] \n";
	print "			ex:  perl bm.pl -set -p -t limit -v 4\n";
	print "		-a = ip address\n";
	print "			-from = [if#,ipaddr]\n";
	print "			-to   = [if#,ipaddr]\n";
	print "			if# = interface number \n";
	print "			ex:  perl bm.pl -set -a -from 1,146.152.80.1 -to 1,146.152.0.1\n";
	print "		-a = ip address\n";
	print "			-t = type  [dsp] dsp=default\n";
	print "			-file = [filename]\n";
	print "			ex:  perl bm.pl -set -a -dsp -file mindspeed.cfg\n";
	print "		-i = interface [ifindex]\n";
	print "			-s = status [up,down] up=default\n";
	print "			ex:  perl bm.pl -set -i 1 -s down\n";
	print "\n";
	print "	-t   = Target Blade [ip[:port]] ex: -t 127.0.0.1:161 \n";
	print "	-v   = snmp version [1,2,3] ex: -v 1  \n";
	print "	-u   = username [string] ex: -u Admin ... applies only to V3  \n";
	print "	-p   = password [string] ex: -p Admin ... applies to all protocol v1,v2,v3\n";
}
sub doSet
{
	print "SET \n";
	$localArg = shift @ARGV;	
	if ( defined $localArg ) {
	   	if ( $localArg eq "-") {
			print "Error missing one of :-i,-s, -a, -h \n";
	   	} elsif ( $localArg eq "-i") {
			GetInterfaces();
	   	} elsif ( $localArg eq "-s") {
			GetSystem();	
	   	} elsif ( $localArg eq "-a") {
	   	} elsif ( $localArg eq "-h") {
		} else {
			print "Error missing one of :-i,-s, -a, -h \n";
		} 
	} else {
		print "Error missing one of :-i,-s, -a, -h \n";
	} 

}


my @ipAddrTable;

sub GetExtIpAddress
{
@ipAddrTable=`${SNMP_TABLECMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ipmsExtIfIpAddrTable`;
}

sub GetSystemData
{
	my @mibSys;
	my $sysDescrVal;
	my $sysTimeTickVal;
	my $reqT=$_[0];
	print "Please wait while System Paramneters are retrieved\n";

		@ipmsSys= `${SNMP_WALKCMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ipmsSysEnv`;

	if ( $reqT eq "all" ) {
 
		@mibSys= `${SNMP_WALKCMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} system`;

		my $pstnTrunkLimit= `${SNMP_GETCMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ipmsExtIfSetNumOfPSTNTrunks.0`;

		print "$pstnTrunkLimit \n";
		$pstnTrunkLimit =~ /INTEGER:\s*(.+)$/;
		my $sysTrunkLimit= $1;

		$mibSys[2] =~ /(\d{1}:\d{2}:\d{2}\.\d{2})$/;
		$sysTimeTickVal = $1;

		$mibSys[0] =~ /STRING:\s*(.+)$/;
		$sysDescrVal = $1;

		$mibSys[3] =~ /STRING:\s*(.+)$/;
		my $sysContactVal = $1;

		$mibSys[4] =~ /STRING:\s*(.+)$/;
		my $sysNameVal = $1;

		$mibSys[5] =~ /STRING:\s*(.+)$/;
		my $sysLocVal = $1;

		$ipmsSys[0] =~ /STRING:\s*(.+)$/;
		my $ipmsSysModelVal = $1;

		$ipmsSys[1] =~ /STRING:\s*(.+)$/;
		my $ipmsSysVendorVal = $1;

		$ipmsSys[2] =~ /STRING:\s*(.+)$/;
		my $ipmsSysSNVal = $1;

		$ipmsSys[3] =~ /STRING:\s*(.+)$/;
		my $ipmsSysFFVal = $1;

		$ipmsSys[4] =~ /INTEGER:\s*(.+)$/;
		my $ipmsSysRdyVal = $1;

		$ipmsSys[5] =~ /INTEGER:\s*(.+)$/;
		my $ipmsSysLBVal = $1;

		$ipmsSys[6] =~ /INTEGER:\s*(.+)$/;
		my $ipmsSysRSVal = $1;

		$ipmsSys[7] =~ /STRING:\s*(.+)$/;
		my $ipmsSysLicenseVal = $1;

 
		print "****************************************************************************** \n";
		print "** System Description  = $sysDescrVal \n";
		print "** System Time Running = $sysTimeTickVal \n";
		print "** System Contact      = $sysContactVal \n";
		print "** System Name         = $sysNameVal \n";
		print "** System Location     = $sysLocVal \n";
		print "** System Model        = $ipmsSysModelVal\n";
		print "** System Vendor       = $ipmsSysVendorVal\n";
		print "** System Serial Number= $ipmsSysSNVal\n";
		print "** System Form Factor  = $ipmsSysFFVal\n";
		print "** System Ready        = $ipmsSysRdyVal\n";
		print "** System Last Boot    = $ipmsSysLBVal\n";
		print "** System Run Status   = $ipmsSysRSVal\n";
		print "** System License      = $ipmsSysLicenseVal\n";
		print "** System PSTN Trunk Limit = = $sysTrunkLimit\n";
		print "****************************************************************************** \n";
	} else {
		$ipmsSys[4] =~ /INTEGER:\s*(.+)$/;
		my $ipmsSysRdyVal = $1;

		$ipmsSys[6] =~ /INTEGER:\s*(.+)$/;
		my $ipmsSysRSVal = $1;
		print "****************************************************************************** \n";
		print "** System Run Status   = $ipmsSysRSVal\n";
		print "** System Ready        = $ipmsSysRdyVal\n";
		print "****************************************************************************** \n";

	}
}

sub GetAllTypesInterfaces
{
	my $ifType=$_[0];
	if ($ifType eq "mib2" ) {
		$ifType="";
	}

	my @ifTable;
	print "Please wait while ".$ifType." Interfaces are retrieved\n";
	@ifTable = `${SNMP_TABLECMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ifTable`;

	my @arr;
	my @macArr;
	my @ipArr;
	my $val1,
	my $val2;
	my @packMac;
	my $packMacRow;
	my $matchedIpAddr;

	GetExtIpAddress();

	print "Index	Description	Status 		MAC			IP Address\n";
	for (my $ir=0; $ir < @ifTable; $ir++) {
	 	if ($ir > 2) {
			@arr = split(" ", $ifTable[$ir]); 	
			if ( $arr[1] =~ /$ifType/i  ) 	{
				if ($arr[1] eq "Ds1" ) {
					$packMacRow = 0; 
				} else {
					@macArr = split(":", $arr[5]);
					for (my $y=0; $y < @macArr; $y++) {
						$packMac[$y] = pack("H*", $macArr[$y]);
					}
					$packMacRow = join("",@packMac);
					#$packMacArr[$ir] = $packMacRow;
				}

				$matchedIpAddr =0;
				for (my $x=0; $x < @ipAddrTable; $x++ ) {
					if ( $x gt "2" ) {
						@ipArr = split(" ", $ipAddrTable[$x]);
						$val2 = $arr[0];
						$val1 = $ipArr[1];
						if ( $val1 eq $val2  ) 	{
							$matchedIpAddr = $ipArr[0];		
							last;
						}
					}
				  }
				if ( defined $matchedIpAddr ) {
	 				printf( "%02d %12s %10s %30s %18s\n", $arr[0],$arr[1],$arr[6],$packMacRow, $matchedIpAddr);
				}else {
	 				printf( "%02d %12s %10s %30s %18s\n", $arr[0],$arr[1],$arr[6],$packMacRow, 0);
				}
			}
		}
	}
}

sub GetBaseHW
{
	my $reqT=$_[0];
	print "Please wait while Baseboard Hardware System Paramneters are retrieved\n";

		my @HwSys= `${SNMP_WALKCMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ipmsAtcaHardware`;

		$HwSys[0] =~ /STRING:\s*(.+)$/;
		my $bbDesc = $1;

		$HwSys[1] =~ /STRING:\s*(.+)$/;
		my $bbVendor = $1;

		$HwSys[2] =~ /STRING:\s*(.+)$/;
		my $bbSN= $1;

		$HwSys[3] =~ /STRING:\s*(.+)$/;
		my $bbVer= $1;

		$HwSys[4] =~ /STRING:\s*(.+)$/;
		my $bbIpmc= $1;

		$HwSys[5] =~ /STRING:\s*(.+)$/;
		my $bbLoc= $1;
 
		print "****************************************************************************** \n";
		print "** Baseboard Description        = $bbDesc \n";
		print "** Baseboard Vendor             = $bbVendor \n";
		print "** Baseboard Serial Number      = $bbSN\n";
		print "** Baseboard Version            = $bbVer\n";
		print "** Baseboard IPMC Version       = $bbIpmc\n";
		print "** Baseboard Chassis Location   = $bbLoc\n";
		print "****************************************************************************** \n";
}


sub GetAmcHW
{
	my $ifType=$_[0];
	my @arr;
	print "Please wait while AMC Hardware Table is retrieved\n";
	@amcTable = `${SNMP_TABLECMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ipmsHwAmcTable`;

	print "Bay Location        Description	      Vendor       Version         MMC Version      Status \n";
	for (my $ir=0; $ir < @amcTable; $ir++) {
	 	if ($ir > 2) {
			@arr = split(" ", $amcTable[$ir]); 	
	 		printf( "%10s %22s %9s %16s %18s %8s\n", $arr[0], $arr[1],$arr[2],$arr[3], $arr[4], $arr[5]);
		}
	}
}

sub GetBledHW
{
	my $ifType=$_[0];
	my @arr;
	print "Please wait while AMC Hardware Table is retrieved\n";
	@amcTable = `${SNMP_TABLECMD} -v${AGENT_VERSION} -c ${AGENT_COMM_WRITE} -M /root/jmcruz2/mibs -m ALL ${AGENT_HOST}${AGENT_PORT} ipmsHwAmcTable`;

	print "Bay Location        Description	      Vendor       Version         MMC Version      Status \n";
	for (my $ir=0; $ir < @amcTable; $ir++) {
	 	if ($ir > 2) {
			@arr = split(" ", $amcTable[$ir]); 	
	 		printf( "%10s %22s %9s %16s %18s %8s\n", $arr[0], $arr[1],$arr[2],$arr[3], $arr[4], $arr[5]);
		}
	}
}


sub GetHardware
{
	my $localArg = shift @ARGV;	
	if ( defined $localArg ) {
	   	if ( $localArg eq "-") {
			print "${localArg} \n";
			print "Error expected -t \n";
	   	} elsif ( $localArg eq "-t") {
			$localArg = shift @ARGV;	
			if ( defined $localArg ) {
				if ( $localArg eq "base" ) {
					GetBaseHW();
				} elsif ( $localArg eq "amc" ) {
					GetAmcHW();
				} elsif ( $localArg eq "bled" ) {
					GetBledHW();
				}  elsif ( $localArg eq "aled" ) {
				} else {
					GetAmcHW();
					print "Error expected one of : base, amc, bled, aled \n";
				}
			}else {
					GetAmcHW();
			}
		} else {
			print "${localArg} \n";
			print "Error expected -t \n";
		} 
	} else {
		print "Error expected -t \n";
	} 
}

sub GetInterfaces
{
	my $localArg = shift @ARGV;	
	if ( defined $localArg ) {
	   	if ( $localArg eq "-") {
			print "${localArg} \n";
			print "Error expected -t \n";
	   	} elsif ( $localArg eq "-t") {
			print "${localArg} \n";
			$localArg = shift @ARGV;	
	
			if ( defined $localArg ) {
				if ( $localArg eq "media" ) {
					GetAllTypesInterfaces("media");
				} elsif ( $localArg eq "ds1" ) {
					GetAllTypesInterfaces("ds1");
				} elsif ( $localArg eq "ether" ) {
					GetAllTypesInterfaces("eth");
				}  elsif ( $localArg eq "mib2" ) {
					GetAllTypesInterfaces("mib2");
				}  elsif ( $localArg eq "all" ) {
					GetAllTypesInterfaces("mib2");
				} else {
					GetAllTypesInterfaces("mib2");
					print "Error expected one of : media, ds1, ether, all or mib2 \n";

				}
			}else {
				GetAllTypesInterfaces("mib2");
			}
		} else {
			print "${localArg} \n";
			print "Error expected -t \n";
		} 
	} else {
		print "Error expected -t \n";
	} 
}

sub GetSystem
{
	my $localArg = shift @ARGV;	
	if ( defined $localArg ) {
	   	if ( $localArg eq "-") {
			print "${localArg} \n";
			print "Error expected -t \n";
	   	} elsif ( $localArg eq "-t") {
			print "${localArg} \n";
			$localArg = shift @ARGV;	
	
			if ( defined $localArg ) {
				if ( $localArg eq "all" ) {
					GetSystemData("all");
				} elsif ( $localArg eq "status" ) {
					GetSystemData("status");
				} else {
					print "Error expected one of : all , status \n";
				}
			}else {
				GetSystemData("all");
			}
		} else {
			print "${localArg} \n";
			print "Error expected -t \n";
		} 
	} else {
		print "Error expected -t \n";
	} 
}


sub doGet
{
	$localArg = shift @ARGV;	
	if ( defined $localArg ) {
	   	if ( $localArg eq "-") {
			print "Error missing one of :-i,-s, -h \n";
	   	} elsif ( $localArg eq "-i") {
			GetInterfaces();
	   	} elsif ( $localArg eq "-s") {
			GetSystem();	
	   	} elsif ( $localArg eq "-h") {
			GetHardware();	
		} else {
			print "Error missing one of :-i,-s, -h \n";
		} 
	} else {
		print "Error missing one of :-i,-s, -h \n";
	} 
	
}


sub generateMindSpeedIPXmlFile
{
	my @macs;
	my @ips;
	my $NUMDSPS=4;

	$macs[0]= uc(shift @ARGV);	
	$macs[1]= uc(shift @ARGV);	
	$macs[2]= uc(shift @ARGV);	
	$macs[3]= uc(shift @ARGV);	

	$ips[0]= shift @ARGV;	
	$ips[1]= shift @ARGV;	
	$ips[2]= shift @ARGV;	
	$ips[3]= shift @ARGV;	


	if ( ( !defined $macs[0] ) || ( !defined $macs[1] ) || ( !defined $macs[2] ) || ( !defined $macs[3] ) ) {
		exit 1;
	}

	if ( ( !defined $ips[0] ) || ( !defined $ips[1] ) || ( !defined $ips[2] ) || ( !defined $ips[3] )  ){
		exit 2;
	}

	#Create TABLE XML Headers
	open FH, ">/usr/dialogic/cfg/mitconfig/ipms_mit_dsp_cfg.xml" or die "Could not open Media IP XML File $!\n";
	print FH "<Table>\n";


	for (my $i=0; $i < $NUMDSPS ; $i++) {
		print FH "<Row>\n";
			print FH "      <Param>\n";
        			print FH "        <ParamID>4611<\/ParamID> \n";
        			print FH "        <ParamDescription>MAC_ADDR_ID<\/ParamDescription> \n";
        			print FH "        <ParamIsKey>TRUE<\/ParamIsKey>\n";
        			print FH "        <ParamType>BMI_DATATYPE_POINTERCHAR<\/ParamType>\n";
        			print FH "        <ParamValue>$macs[$i]<\/ParamValue>\n";
        		print FH "      <\/Param>\n";

			print FH "      <Param>\n";
        			print FH "        <ParamID>262402<\/ParamID> \n";
        			print FH "        <ParamDescription>IP_ADDRESS<\/ParamDescription> \n";
        			print FH "        <ParamIsKey>FALSE<\/ParamIsKey>\n";
        			print FH "        <ParamType>BMI_DATATYPE_POINTERCHAR<\/ParamType>\n";
        			print FH "        <ParamValue>$ips[$i]<\/ParamValue>\n";
        		print FH "      <\/Param>\n";
		print FH "<\/Row>\n";
	}

	print FH "<\/Table>"; print FH "\n";
	close FH;
}

sub doMindSpeedCal
{
	my $myip = shift @ARGV;	
	my $mymsk = shift @ARGV;	
	my $mymac = shift @ARGV;	

	if ( !defined $myip) {
		print "Error : <ip> <netmask> <mac>  \n";
		exit 1;
	}
	if ( !defined $mymsk) {
		print "Error : <ip> <netmask> <mac>  \n";
		exit 1;
	}
	if ( !defined $mymac) {
		print "Error : <ip> <netmask> <mac>  \n";
		exit 1;
	}

	my $ipAddr = unpack('N', inet_aton($myip) );
	my $subnetMask= unpack('N', inet_aton($mymsk) );
	my $subNet= $ipAddr& $subnetMask;

	#calculate the mind speed macs based on the amc mac	
	my $myBase= 256;
	my @macvalArr = split(":", $mymac);
	my $myint;
	my $remainder;
	my $carryOver;
	my $index;

	#mac address are calculated as follow:
	#given the passed in mac address add 2 for the first mac
	#and increment by one from here up...
	my @incVal = (2, 3, 4, 5);
	my @rdyMacArr;
	my @finalMacStr;
	my $numOfDsp=4;
	my $findex;

	for ( $findex=0; $findex < $numOfDsp ; $findex++) {
		$index=int(@macvalArr) - 1;
		$remainder=0;
		$carryOver=0;
		$myint =0;
		while ( $index != -1 ) {
			$myint = hex( $macvalArr[$index] );		
			if ( $index == 5 ) {	
				$myint = int($myint) + int($incVal[$findex]); 
			}
			$myint = int($myint) + int($carryOver);
			$remainder= ($myint - (int($myint / $myBase) * $myBase) )  ;
			$carryOver= int ( ($myint ) / int($myBase) );
			my $chex = sprintf("%x", $carryOver);
			my $rhex = sprintf("%x", $remainder);

			$rdyMacArr[$index] = sprintf("%02s",$rhex);	
			$index--;
		}
		$finalMacStr[$findex] = 
			sprintf("%s:%s:%s:%s:%s:%s",$rdyMacArr[0],$rdyMacArr[1],$rdyMacArr[2],$rdyMacArr[3],$rdyMacArr[4],$rdyMacArr[5]);
	}
	my $subNetString= join('.',unpack('C4', pack("N", $subNet)));
	print "$subNetString $finalMacStr[0] $finalMacStr[1] $finalMacStr[2] $finalMacStr[3] \n";
}

sub MyCmdLine
{
#	my $param1 = shift;		# shift @_
	$argvCnt = @ARGV;
	my $myarg;
	if ( $argvCnt == 0) {
		myHelp();
		exit 1;
	} else  { 
		$myarg = shift @ARGV;	
		if ( $myarg eq "-get" ) {
			doGet();
		} elsif  ( $myarg eq  "-set" ) {
			print "SET $myarg \n";
			doSet();
		} elsif  ( $myarg eq  "-mcal" ) {
			doMindSpeedCal();
		} elsif  ( $myarg eq  "-mgen" ) {
			generateMindSpeedIPXmlFile();
		} else {
			print "Invalid command argument ${myarg} \n";
		}
	 }
}


MyCmdLine();

exit 0;
 

