#!/bin/sh

#set -x

# TODO: check for enough free disk space
  echo "Gathering system information..."

  trname="trouble_report$$"
  trdir="/tmp/$trname"
  mkdir $trdir

  # what hardware do we have
  echo "Hardware config..."
  lspci -v >> $trdir/lspci.log
  if [ -e "/etc/sysconfig/hwconf" ]
  then
      cp /etc/sysconfig/hwconf $trdir/hwconf
  fi

  # what is the interface status
  echo "Network config..."
  ls /etc/sysconfig/network-scripts/ifcfg-* &> /dev/null
  if [ $? -eq 0 ] 
  then
      cp /etc/sysconfig/network-scripts/ifcfg-* $trdir/
  fi
  ifconfig >> $trdir/ifconfig.log

  # gather interface names from ifconfig, see what ethtool says about each
  for ifn in `ifconfig | grep "Link encap" | grep -v "lo" | cut -d' ' -f 1`
  do
    echo "ethtool $ifn"    >> $trdir/ethtool.log
    ethtool $ifn           >> $trdir/ethtool.log
    echo "ethtool -i $ifn" >> $trdir/ethtool.log
    ethtool -i $ifn        >> $trdir/ethtool.log
    echo "ethtool -S $ifn" >> $trdir/ethtool.log
    ethtool -S $ifn        >> $trdir/ethtool.log
    echo "ethtool -g $ifn" >> $trdir/ethtool.log
    ethtool -g $ifn        >> $trdir/ethtool.log
  done

  # dump the routes, arp table
  route -n > $trdir/route.log
  arp   -n > $trdir/arp.log
  sysctl -A > $trdir/sysctl.log
  if [ -e /usr/dialogic/bin/ifext ]
  then
    /usr/dialogic/bin/ifext > $trdir/ifext.log
  fi

  # See what's running
  echo "Process state..."
  ps aux > $trdir/ps.log

  # save the message logs
  echo "Message logs..."
  if [ -e /usr/dialogic ]
  then
    tar -cvzf $trdir/logs.tgz \
        /var/log/messages   \
        /var/log/ngmit.log  \
        /usr/dialogic/log/* \
        &> /dev/null
  else
    tar -cvzf $trdir/logs.tgz \
        /var/log/messages   \
        &> /dev/null
  fi

  if [ -e /usr/dialogic ]
  then
    # dialogic specific files
    echo "Dialogic product config..."
    if [ -e "/usr/dialogic/data/Hmp.Uconfig" ] 
    then
      cp /usr/dialogic/data/Hmp.Uconfig $trdir/Hmp.Uconfig
    fi

    tar -cvzf $trdir/cfg.tgz \
      /usr/dialogic/cfg \
      /usr/dialogic/data/*.pcd \
      /usr/dialogic/data/*.fcd \
      /usr/dialogic/data/*.config \
      /usr/dialogic/conf \
      &> /dev/null

    echo "ssp.mlm"                     > $trdir/version.log
    getver /usr/dialogic/data/ssp.mlm >> $trdir/version.log

    devmapdump > $trdir/devmapdump.log
  else
    echo "No Dialogic product installed..."
  fi

  echo "Generating trouble report in file $PWD/trouble_report$$.tgz"
  tar -C /tmp -cvzf $PWD/trouble_report$$.tgz  $trname &> /dev/null

# TODO: noclean param would be nice
  echo "Cleaning up"
  rm -rf $trdir

  echo "Done"


# STILL Missing
#  1. DSP core dump (needs external program)
#  2. Ping DSPs     (needs knowledge of network; can get from systl)
#  2. FRU info
#  3. Is SELinux enabled (?)
#  4. Fabric BIOS setting (?)
#  5. Output from CLI: show license, show system, show interface ds1
