var jsonReply;
var LicenseDir;

$(document).ready(function() 
{
	GetLicenseData();

	jQuery("#Delete").click(function(event)
	{
                jQuery('#main-menu-list').load("./deleteLicenseFile.html");
		event.preventDefault();
	});
	jQuery("#Refresh").click(function(event)
	{
		GetLicenseData();
		event.preventDefault();
	});
	jQuery("#Activate").click(function(event)
	{
		ApplyNewLicenseFileName();
		event.preventDefault();
	});
});

function ApplyNewLicenseFileName() 
{
	var replyMsg = new Object;
	replyMsg.oam = new Object;
	replyMsg.oam.selectedLicInput = CurrentActiveFileName;
	var jsonMsg = window.JSON.stringify(replyMsg);
	var data = post_SetFormData_Async("systemLicenseTab.html", "setLicenseData", jsonMsg, GetLicenseData);
}

function removeChecks() 
{
	jQuery('.GridItemLic').each(function() 
	{
		jQuery(this).removeAttr('checked');
	});
}

function GetLicenseData() 
{
	jsonReply = post_GetFormData_Async("systemLicenseTab.html", "getLicenseData", UpdatePageWithDynamicData);
}

function UpdatePageWithDynamicData(text)
{
	var FileNameTemp;
	var FileLocIndex;
	jsonReply=text;

	//Painting TopLeft Div
	for (var i=0; i < jsonReply.oam.scalars.length; i++)
	{
		if (jsonReply.oam.scalars[i].ClientId == "nodeLicInput")
			jQuery("p:eq(5)").text(jsonReply.oam.scalars[i].Value);
		if (jsonReply.oam.scalars[i].ClientId == "selectedLicInput")
		{
			FileNameTemp = jsonReply.oam.scalars[i].Value;
			var FileNameTemp_Split = FileNameTemp.split("/");
			CurrentActiveFileName = FileNameTemp_Split[FileNameTemp_Split.length-1];
			jQuery("p:eq(3)").text(CurrentActiveFileName);
		}
		if (jsonReply.oam.scalars[i].ClientId == "TxChangeLicenseDir")
		{
			LicenseDir = jsonReply.oam.scalars[i].Value;
			jQuery("p:eq(13)").text(LicenseDir);
		}
		//	jQuery("p:eq(13)").text(jsonReply.oam.scalars[i].Value);
	}
	FileLocIndex =  GetFileIndexInFileProperties(CurrentActiveFileName);
	jQuery("p:eq(7)").text(convertLicCat(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxLicenseCategory));
	jQuery("p:eq(9)").text(convertLicType(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxPropLicType));
	jQuery("p:eq(11)").text(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxPropLicExpire);

	//Painting TopRight Div
	UpdateLicenseFeatureGrid(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxPropLicProdOpts, "Grid_TopRight", ".FlyingData1");

	//Painting BottomRight Div
	UpdateLicenseFeatureGrid(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxPropLicProdOpts, "Grid_BottomRight",  ".FlyingData3");

	//Painting BottomLeft Div
	ShowAvailableLicenseFiles();
}

function ShowAvailableLicenseFiles()
{
	var htmltext = "<table class=GridAvailLic id=\"GridAvailLic\" name=\"GridAvailLic\" cellspacing=\"2\" border=\"0\"> <thead class=theadfix> <tr><th scope=\"col\" style=\"width:18px\"> </th> <th scope=\"col\" style=\"width:278px;color:white\">Available Licenses</th> <th scope=\"col\" style=\"width:95px;color:white\">Category</th> <th scope=\"col\" style=\"width:85px;color:white\">Type</th> <th scope=\"col\" style=\"width:85px;color:white\">Expiration</th> </tr> </thead> <tbody class=tbodyScroll>";
	var radiotext;
	var scripttext;

	for (var i=0; i< jsonReply.oam.TbLicFileProperties.length; i++)
	{
		radiotext = "<td style=\"width:1px\"> <input class=GridItemLic type=\"radio\" value=\"" + jsonReply.oam.TbLicFileProperties[i].TxPropLicFileName +"\"/> </td>";
		htmltext =  htmltext + "<tr>" + radiotext + 
		"<td> <p style=\"text-align:left;height:20px;margin:0px;padding:0px;width:278px !important;overflow:hidden\">" + jsonReply.oam.TbLicFileProperties[i].TxPropLicFileName + "</p> </td>" +
		"<td style=\"width:95px\">" + convertLicCat(jsonReply.oam.TbLicFileProperties[i].TxLicenseCategory) + "</td>" +
		"<td style=\"width:85px\">" + convertLicType(jsonReply.oam.TbLicFileProperties[i].TxPropLicType) + "</td>" +
		"<td style=\"width:85px\">" + jsonReply.oam.TbLicFileProperties[i].TxPropLicExpire + "</td>" + "</tr>";
	}
	htmltext = htmltext + "</tbody> </table>";

/*	this is the script that is below ... place this in ready function and test it when it works bring it back in the below format..
	jQuery('.GridItemLic').click(function()
	{
		removeChecks();
		jQuery(this).attr('checked', 'checked');
		var FileLocIndex = GetFileIndexInFileProperties(jQuery(this).val());
		CurrentActiveFileName = jQuery(this).val();
		//Painting BottomRight Div
		UpdateLicenseFeatureGrid(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxPropLicProdOpts, "Grid_BottomRight",  ".FlyingData3");
	});

	jQuery('.GridItemLic').each(function() 
	{
		if (CurrentActiveFileName == jQuery(this).val())
		{
			jQuery(this).attr('checked', 'checked');
		}
	});
*/

	scripttext = " <script type=\"text\/javascript\"> jQuery(\'.GridItemLic\').click(function() { removeChecks(); jQuery(this).attr(\'checked\', \'checked\'); var FileLocIndex = GetFileIndexInFileProperties(jQuery(this).val()); CurrentActiveFileName = jQuery(this).val(); UpdateLicenseFeatureGrid(jsonReply.oam.TbLicFileProperties[FileLocIndex].TxPropLicProdOpts, \"Grid_BottomRight\",  \".FlyingData3\"); }); jQuery(\'.GridItemLic\').each(function() { if (CurrentActiveFileName == jQuery(this).val()) { jQuery(this).attr(\'checked\', \'checked\'); } }); </script> ";

	htmltext = htmltext + scripttext;
	jQuery('.GridAvailLic').remove();
	jQuery(htmltext).insertAfter(jQuery('.FlyingData2'));
	jQuery('.GridAvailLic').scrollTop();
}

function UpdateLicenseFeatureGrid(LicenseFeatureSet, GridName, DivLocation)
{
	var htmltext = "<table class=\"" + GridName + "\" cellspacing=\"2\" border=\"0\"> <thead class=theadfix2> <tr><th scope=\"col\" style=\"color:white\">Feature</th> <th scope=\"col\"  style=\"color:white\">Count</th> </tr> </thead> <tbody class=tbodyScroll2> ";
	var re = /\w+/g;
	if (LicenseFeatureSet == undefined)
		LicenseFeatureSet = "undefined undefined";

	var xyz = LicenseFeatureSet.split(",");
	var len = xyz.length;
	if ( len > 1)
		len = len - 1;

	for (var i=0; i < len; i= i+1) 
	{
		var temp = xyz[i];
		if (temp != "")
		{
		var result0, result1; 
		// alert(result[0]);
		// alert(result[1]);
		var result = temp.match(re);
		if (result[0] != "3G")
		{
			result0 = result[0];
			result1 = result[1];
		}
		else
		{
			result0 = result[0]+"-"+result[1];
			result1 = result[2];
		}
		if ( result0 != "estimated")
		{
			htmltext =  htmltext + "<tr>" + "<td>" + result0+ "</td>" + "<td>" + result1 + "</td>" + "</tr>";	
		}
		else
		{
			htmltext =  htmltext + "<tr>" + "<td>" + result0+ "</td>" + "<td>" + "" + "</td>" + "</tr>";	
		}
		}
	}
	htmltext = htmltext + "</tbody> </table>";
	jQuery("."+GridName).remove();
	jQuery(htmltext).insertAfter(jQuery(DivLocation));
	jQuery("."+GridName).scrollTop();
}


function GetFileIndexInFileProperties(FileNameToLookup)
{
	var i=0;

	for (i=0 ; i < jsonReply.oam.TbLicFileProperties.length; i++ )
	{
		if ( jsonReply.oam.TbLicFileProperties[i].TxPropLicFileName == FileNameToLookup ) 
		{
			return i;
		}
	}
	return 0;
}

function convertLicType(lType)
{
	var Types=["Verification", "Evaluation", "Purchased", "Emergency", "Trial", "Unknown"];

	if ((lType >= 0) && (lType <6))
		return (Types[lType]);
	return "Undefined";
}

function convertLicCat(lType)
{
	var vLCatArray=["Node Specific", "Board Lock", "OEM", "Unknown Mechanism"];

	if ((lType >= 0) && (lType <4))
		return (vLCatArray[lType]);
	return "Unknown";
}

