/*
    Copyright (C) 2000-2003.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          CCTDasiException.h %
*    %version:       22 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Thu Apr 17 22:56:51 2003 %
*    ===================================================================
*/

#ifndef __CCTDasiException_H__
#define __CCTDasiException_H__

#ifndef lint
static const char    *_hsw_1_CCTDasiException_h = "@(#) %filespec: CCTDasiException.h-22 %  (%full_filespec: CCTDasiException.h-22:incl:hsw#1 %)";
#endif

#include <exception>

#include "DlgDasiClientLib.h"

namespace DASI
{
    /**
     * All DASI objects throw a CCTDasiException object if an error occurs.
     * The exception object will contain the error id and error description
     * from the object that generated the exception.  The DASI exception object
     * does not modify any error id's or error descriptions, but rather just
     * translates the many different exceptions within the system into one.
     * Applications will only have to catch CCTDasiException in their application
     * to obtain any error from the OA&M system.
     *
     * @version 1.0
     * @since 1.0
     *
     * @stereotype implementationClass
     */
    class DLGDASICLIENT_API CCTDasiException
    {
    public:

        /**
         * The CCTDasiException constructor initializes the administrative framework exception
         *  object for administrative operations.
         *
         * @param dlgSysError a long : Error code identifiaction.
         * @param errDesc a constant char * : Error code string description.
         *
         * @version 1.0
         * @since 1.0
         */

        CCTDasiException( /*in*/ long lDlgSysError,
                          /*in*/ const char * szErrorDesc = NULL)
        {
            m_dlgSysError = lDlgSysError;

            if ( szErrorDesc == NULL )
            {
                m_errDesc = " ";
            }
            else
            {
                m_errDesc = szErrorDesc;
            }
        }


        /**
         * The CCTDasiException destructor deinitializes the administrative framework exception
         * object for administrative operations.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~CCTDasiException() {};


        /**
         * Retrieves the error code which caused the exception.
         *
         * @return constant long : The error code which caused the exception.
         *
         * @version 1.0
         * @since 1.0
         */
        const long GetErrorCode() { return m_dlgSysError; };


        /**
         * Retrieves the error description of the error code which caused the exception.
         *
         * @return A reference to a constant std::string& : The error description.
         *
         * @version 1.0
         * @since 1.0
         */
        const std::string GetErrorMsg() { return m_errDesc; };


        /**
         * Contains the error code.
         * @version 1.0
         * @since 1.0
         */
        long m_dlgSysError;

        /**
         * Contains the description of the error code.
         * @version 1.0
         * @since 1.0
         */
        std::string m_errDesc;
    }; // End class CDasiException
} //end of namespace

#endif // CTDasiException_H

