/*
    Copyright (C) 2000-2003.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          ICTBus.h %
*    %version:       25 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Thu Apr 17 22:56:56 2003 %
*    ===================================================================
*/

#ifndef __ICTBUS_H__
#define __ICTBUS_H__

#ifndef lint
static char    *_hsw_1_ICTBus_h = "@(#) %filespec: ICTBus.h-25 %  (%full_filespec: ICTBus.h-25:incl:hsw#1 %)";
#endif

#include <string>
#include <list>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"
#include "ICTBoard.h"
#include "ICTClockAgent.h"

namespace DASI
{
    typedef struct _tagCTBusConfiguration
    {
        short               bustype;
        short               scBusClockRate;
        short               group1ClockRate;
        short               group2ClockRate;
        short               group3ClockRate;
        short               group4ClockRate;
        bool                MVIPCompatLinesActive;
        bool                SCBusCompatLinesActive;
        long                primaryMaster;
        long                primaryClockSource;
        long                secondaryMaster;
        long                secondaryClockSource;
        short               primaryLines;
        long                netrefBoard;
        long                netrefSource;
        short               netrefClockRate;
        long                netref2Board;
        long                netref2Source;
        short               netref2ClockRate;
        bool                termination;
        short				pcmEncoding;
    } CTBUSCONFIGURATION;

    typedef struct _tagCTBusAttributes
    {
        std::string     busName;
        short           clockDaemonMode;
        long            baseTimeslot;
    } CTBUSATTRIBUTES;

    /**
     * An ICTBus object is used to access all information with respect to the CTBus.
     *
     * @exception CCTDasiException
     *
     * @version 1.0
     * @since 1.0
     * @stereotype interface
     */

    class DLGDASICLIENT_API ICTBus
    {
    public:
        /**
         * The ICTBus destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @brief Destructor
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~ICTBus() {};

        /// Retrieves the CTBus ID.
        virtual AUID GetID() = 0;

        /// Retrieves all boards.
        virtual ICTBOARDLIST* GetAllBoards() = 0;

        /// Retrieves all installed boards.
        virtual ICTBOARDLIST* GetAllInstalledBoards() = 0;

        /// Retrieves the TDMBus attributes.
        virtual CTBUSATTRIBUTES* GetTDMBusAttributes() = 0;

        /// Retrieves the clock deamon resolved TDMBus configuration.
        virtual CTBUSCONFIGURATION* GetResolvedTDMBusConfiguration() = 0;

        /// Retrieves the user defined TDMBus configuration.
        virtual CTBUSCONFIGURATION* GetUserTDMBusConfiguration() = 0;

        /// Retrieves the clock master fallback list.
        virtual ICTCLOCKAGENTLIST* GetClockMasterFallbackList() = 0;

        /// Retrieves the reference fallback list.
        virtual ICTCLOCKAGENTLIST* GetReferenceFallbackList() = 0;

        /// Updates the clock deamon resolved TDMBus configuration.
        virtual void SetResolvedTDMBusConfiguration(/*in*/ const CTBUSCONFIGURATION& rCTBusConfig) = 0;

        /// Updates the user defined TDMBus configuration.
        virtual void SetUserTDMBusConfiguration(/*in*/ const CTBUSCONFIGURATION& rCTBusConfig) = 0;

        /// Updates the TDMBus attributes.
        virtual void SetTDMBusAttributes(/*in*/ const CTBUSATTRIBUTES& rCTBusAttr) = 0;

        /// Updates the clock master fallback list.
        virtual void SetClockMasterFallbackList(/*in*/ ICTCLOCKAGENTLIST& rClockAgentList) = 0;

        /// Updates the reference fallback list.
        virtual void SetReferenceFallbackList(/*in*/ ICTCLOCKAGENTLIST& rClockAgentList) = 0;

    private:

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTBoard lnkICTBoard; */
};

    /// List of pointers to ICTBus objects.
    typedef std::list<ICTBus*> ICTBUSLIST;
    typedef ICTBUSLIST::iterator ICTBUSLIST_ITER;
}
#endif //ICTBUS_H

