/*
    Copyright (C) 2000-2001.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */


/*
    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
    ===================================================================
    name     : %name %
    version  : %version %
    state    : %state %
    full_name: %full_name %
    creater  : %name %
    mod_date : %date_modified %
    ===================================================================
*/


#ifndef ICTDM3IPLINKBOARD_H
#define ICTDM3IPLINKBOARD_H

#include <list>
#include <string>

#include "dlgctypes.h"
#include "dlgcstructs.h"

#include "DlgDasiClientLib.h"
#include "ICTDm3Board.h"

#include "CCTDasiException.h"

using namespace std;

namespace DASI
{
    /**
     * @stereotype interface
     * @version 1.0
     * @since 1.0
     */
    class DLGDASICLIENT_API ICTDm3IplinkBoard : virtual public ICTDm3Board
    {
    public:

        virtual void Save() = 0;

        virtual void Retrieve() = 0;

        virtual DM3NETWORKATTRIBUTESLIST* GetAllNetworkAttributes() = 0;
 
        virtual const DM3NETWORKATTRIBUTES& GetNetworkAttributes() = 0;

        virtual void SetNetworkAttributes(/*in*/ const DM3NETWORKATTRIBUTES& rDM3NetworkAttr) = 0;

    }; // End class ICTDm3IplinkBoard

} // End namespace DASI

#endif //ICTDM3IPLINKBOARD_H



