/************************************************************************* 
 *    Copyright (c) 2007 - 2012 Dialogic Corp.
 *    All rights Reserved
 *************************************************************************
 * file name : LicensedFeatures.h 
 * This file contains the license feature name definitions and enumerations
 **************************************************************************/

#ifndef _LICENSED_FEATURES_H_
#define _LICENSED_FEATURES_H_

#define LM_FEATURE_NAME_BASIC_VOICE					"Voice"
#define LM_FEATURE_NAME_LBR							"Enhanced_RTP"
#define LM_FEATURE_NAME_CONFERENCE					"Conferencing"
#define LM_FEATURE_NAME_CSP							"Speech_Integration"
#define LM_FEATURE_NAME_FAX							"Fax"
#define LM_FEATURE_NAME_RTP							"RTP_G_711"
#define LM_FEATURE_NAME_MM							"Multimedia"
#define LM_FEATURE_NAME_IPCC						"IP_Call_Control"
#define LM_FEATURE_NAME_AMRNB						"AMR_NB"
#define LM_FEATURE_NAME_NATIVE_AUDIO				"Native_Audio"
#define LM_FEATURE_NAME_NATIVE_RTP					"Native_RTP"
#define LM_FEATURE_NAME_MUX3G						"3G-324M"
#define LM_FEATURE_NAME_H263						"H263"
#define LM_FEATURE_NAME_MPEG4						"MPEG4"
#define LM_FEATURE_NAME_VIDEO_CONFERENCING  		"Video_Conferencing"
#define LM_FEATURE_NAME_AMR_WB						"AMR_WB"
#define LM_FEATURE_NAME_G722						"G_722"
#define LM_FEATURE_NAME_SRTP_TLS					"SRTP_TLS"
#define LM_FEATURE_NAME_AUDIO_MM					"Audio_MM"
#define LM_FEATURE_NAME_HDVOICE_CONFERENCING	    "HDVoice_Conferencing"
#define LM_FEATURE_NAME_MM_VLE2                     "MM_VLE2"
#define LM_FEATURE_NAME_VXC_VLE2				    "VXC_VLE2"
#define LM_FEATURE_NAME_VCNF_VLE2                   "VCNF_VLE2"
#define LM_FEATURE_NAME_MM_VLE3                     "MM_VLE3"
#define LM_FEATURE_NAME_VXC_VLE3				    "VXC_VLE3"
#define LM_FEATURE_NAME_VCNF_VLE3                   "VCNF_VLE3"
#define LM_FEATURE_NAME_JSR309                      "JSR309"
#define LM_FEATURE_NAME_SIP_TO_SIP		            "SIP_to_SIP"
#define LM_FEATURE_NAME_V34			                "V_34"
#define LM_FEATURE_NAME_SBC			                "SBC_Capability"

// Short feature names for license file and config file creation name
#define LM_FEATURE_SHORT_NAME_BASIC_VOICE			"v"
#define LM_FEATURE_SHORT_NAME_LBR					"e"
#define LM_FEATURE_SHORT_NAME_CONFERENCE			"c"
#define LM_FEATURE_SHORT_NAME_CSP					"s"
#define LM_FEATURE_SHORT_NAME_FAX					"f"
#define LM_FEATURE_SHORT_NAME_RTP					"r"
#define LM_FEATURE_SHORT_NAME_MM					"m"
#define LM_FEATURE_SHORT_NAME_IPCC					"i"
#define LM_FEATURE_SHORT_NAME_AMRNB					"a"
#define LM_FEATURE_SHORT_NAME_NATIVE_AUDIO			"u"
#define LM_FEATURE_SHORT_NAME_NATIVE_RTP			"n"
#define LM_FEATURE_SHORT_NAME_MUX3G					"g"
#define LM_FEATURE_SHORT_NAME_H263					"h"
#define LM_FEATURE_SHORT_NAME_MPEG4					"p"
#define LM_FEATURE_SHORT_NAME_VIDEO_CONFERENCING	"d"
#define LM_FEATURE_SHORT_NAME_AMR_WB				"w"
#define LM_FEATURE_SHORT_NAME_G722					"b"
#define LM_FEATURE_SHORT_NAME_SRTP_TLS				"t"
#define LM_FEATURE_SHORT_NAME_AUDIO_MM				"u"		// Same as LM_FEATURE_SHORT_NAME_NATIVE_AUDIO
#define LM_FEATURE_SHORT_NAME_HDVOICE_CONFERENCING	"x"
#define LM_FEATURE_SHORT_NAME_MM_VLE2               "j"
#define LM_FEATURE_SHORT_NAME_VXC_VLE2			    "k"
#define LM_FEATURE_SHORT_NAME_VCNF_VLE2             "l"
#define LM_FEATURE_SHORT_NAME_MM_VLE3               "o"
#define LM_FEATURE_SHORT_NAME_VXC_VLE3			    "q"
#define LM_FEATURE_SHORT_NAME_VCNF_VLE3             "y"
#define LM_FEATURE_SHORT_NAME_JSR309                "z"
#define LM_FEATURE_SHORT_NAME_SBC			        "sb"
#define LM_FEATURE_SHORT_NAME_SIP_TO_SIP		    "ss"

/* Enum for Feature types. */
/* !!! Any change in the order of LicenseFeatureEnum will affect KBL !!!*/
typedef enum
{
	LM_FEATURE_BASIC_VOICE			= 0,		/* IPVSC/711 + FSK (Modem) */
	LM_FEATURE_LBR					= 1,		/* low bit rate encoder*/
	LM_FEATURE_CONFERENCE			= 2,
	LM_FEATURE_CSP					= 3,
	LM_FEATURE_FAX					= 4,
	LM_FEATURE_RTP					= 5,
	LM_FEATURE_MM					= 6,
	LM_FEATURE_IPCC					= 7,
	LM_FEATURE_AMRNB				= 8,
	LM_FEATURE_NATIVE_AUDIO			= 9,
	LM_FEATURE_NATIVE_RTP			= 10,
	LM_FEATURE_MUX3G				= 11,
	LM_FEATURE_H263					= 12, 
	LM_FEATURE_MPEG4				= 13,
	LM_FEATURE_VIDEO_CONFERENCING	= 14,  
	LM_FEATURE_AMR_WB				= 15,
	LM_FEATURE_G722					= 16,
	LM_FEATURE_SRTP_TLS				= 17,
	LM_FEATURE_AUDIO_MM				= 18,
	LM_FEATURE_HDVOICE_CONFERENCING	= 19,
	LM_FEATURE_MM_VLE2				= 20,
	LM_FEATURE_VXC_VLE2             = 21,
    LM_FEATURE_VCNF_VLE2            = 22,
    LM_FEATURE_MM_VLE3              = 23, 
    LM_FEATURE_VXC_VLE3             = 24,
    LM_FEATURE_VCNF_VLE3            = 25, 
    LM_FEATURE_JSR309               = 26,
    LM_FEATURE_SIP_TO_SIP	        = 27, 
    LM_FEATURE_SBC		            = 28, 

	LM_NOMATCH
}LicenseFeatureEnum;

/* Feature Enum to Name mapping table, updated with every new licensable feature  */

static const char *FeatureNameTable[LM_NOMATCH + 1] = { LM_FEATURE_NAME_BASIC_VOICE,
                                                  LM_FEATURE_NAME_LBR,
									              LM_FEATURE_NAME_CONFERENCE,
                                                  LM_FEATURE_NAME_CSP,
                                                  LM_FEATURE_NAME_FAX,
                                                  LM_FEATURE_NAME_RTP,
                                                  LM_FEATURE_NAME_MM,
                                                  LM_FEATURE_NAME_IPCC,
                                                  LM_FEATURE_NAME_AMRNB,
                                                  LM_FEATURE_NAME_NATIVE_AUDIO,
                                                  LM_FEATURE_NAME_NATIVE_RTP,
                                                  LM_FEATURE_NAME_MUX3G,
												  LM_FEATURE_NAME_H263, 
												  LM_FEATURE_NAME_MPEG4, 
												  LM_FEATURE_NAME_VIDEO_CONFERENCING, 
												  LM_FEATURE_NAME_AMR_WB,
												  LM_FEATURE_NAME_G722,
												  LM_FEATURE_NAME_SRTP_TLS,
												  LM_FEATURE_NAME_AUDIO_MM,
												  LM_FEATURE_NAME_HDVOICE_CONFERENCING,
												  LM_FEATURE_NAME_MM_VLE2,
												  LM_FEATURE_NAME_VXC_VLE2,
												  LM_FEATURE_NAME_VCNF_VLE2,
												  LM_FEATURE_NAME_MM_VLE3,
												  LM_FEATURE_NAME_VXC_VLE3,
												  LM_FEATURE_NAME_VCNF_VLE3,
                                                  LM_FEATURE_NAME_JSR309,
												  LM_FEATURE_NAME_SIP_TO_SIP,
												  LM_FEATURE_NAME_SBC,
                                                  NULL
									                    };

static const char *FeatureShortNameTable[LM_NOMATCH + 1] = { 
												  LM_FEATURE_SHORT_NAME_BASIC_VOICE,
                                                  LM_FEATURE_SHORT_NAME_LBR,
									              LM_FEATURE_SHORT_NAME_CONFERENCE,
                                                  LM_FEATURE_SHORT_NAME_CSP,
                                                  LM_FEATURE_SHORT_NAME_FAX,
                                                  LM_FEATURE_SHORT_NAME_RTP,
                                                  LM_FEATURE_SHORT_NAME_MM,
                                                  LM_FEATURE_SHORT_NAME_IPCC,
                                                  LM_FEATURE_SHORT_NAME_AMRNB,
                                                  LM_FEATURE_SHORT_NAME_NATIVE_AUDIO,
                                                  LM_FEATURE_SHORT_NAME_NATIVE_RTP,
                                                  LM_FEATURE_SHORT_NAME_MUX3G,
												  LM_FEATURE_SHORT_NAME_H263, 
												  LM_FEATURE_SHORT_NAME_MPEG4, 
												  LM_FEATURE_SHORT_NAME_VIDEO_CONFERENCING,  
												  LM_FEATURE_SHORT_NAME_AMR_WB,
												  LM_FEATURE_SHORT_NAME_G722,
												  LM_FEATURE_SHORT_NAME_SRTP_TLS,
												  LM_FEATURE_SHORT_NAME_AUDIO_MM,
												  LM_FEATURE_SHORT_NAME_HDVOICE_CONFERENCING,
												  LM_FEATURE_SHORT_NAME_MM_VLE2,
												  LM_FEATURE_SHORT_NAME_VXC_VLE2,
												  LM_FEATURE_SHORT_NAME_VCNF_VLE2,
												  LM_FEATURE_SHORT_NAME_MM_VLE3,
												  LM_FEATURE_SHORT_NAME_VXC_VLE3,
												  LM_FEATURE_SHORT_NAME_VCNF_VLE3,
                                                  LM_FEATURE_SHORT_NAME_JSR309,
												  LM_FEATURE_SHORT_NAME_SIP_TO_SIP,
												  LM_FEATURE_SHORT_NAME_SBC,
                                                  NULL
									                    };

static __inline char *GetFeatureNameFromEnum(LicenseFeatureEnum FeatureEnum)
{ return((char *)(FeatureNameTable[FeatureEnum]));  }; 

#endif
