/*******************************************************************************
*
*	File:		MkCallBlk.h
*
*	Description:	Structure of data used in setupReq. Define for parameters 
*			in MakeCall block.  
*
*******************************************************************************/
#ifndef _MKCALLBLK_H
#define _MKCALLBLK_H


#define INTRUSION_WITHOUT_PRIOR_VALIDATION   1
#define INTRUSION_WITH_PRIOR_VALIDATION      2
#define ENQUIRY_CALL                         4
#define DIVERSION_VALIDATION                 8
#define DIVERTING                            16

typedef enum {
  TEXT_TYPE_NOT_PRESENT=0,
  TEXT_TYPE_NAME,
  TEXT_TYPE_MESSAGE,
  TEXT_TYPE_REASON
} TextType_t;

typedef enum {
  DIVERTING_IMMEDIATE=0,
  DIVERTING_ON_BUSY,
  DIVERTING_ON_NO_REPLY
} DivertingMode_t;


typedef struct _CCS_MakeCallBlk_t {
  BYTE              m_SIC;
  char              *m_Text_p;
  TextType_t        m_TextType;
  BYTE              m_SupServicesFlag;
  BYTE              m_IntrusionCapabilityLevel;
  BYTE              m_LineCategory; /* 1 - Ordinary ; 2 - Decadic ; 3 - ISDN ; ... )  */
  DivertingMode_t   m_DivertingMode;
  char              *m_NominatedExtension;
} CCS_MakeCallBlk_t;

#endif
