#define  CALL_AMP_19    (-19*4)  /* 0.25dB units */
#define  CALL_AMP_24    (-24*4)  /* 0.25dB units */

/*
  ********* SIT Tone IC - Operator Intercept
  */
{SIT_IC,                 /* Signal Id (For now use simple values) */
 {"IC"},                    /* The Signal Label */
    3,
 {          /* Tone Segment list */
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        913,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        300,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        1370,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,          /* Amplitude B (dB) */
        300,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        0x7f,                    /* Next Segment */
        1776,                    /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,          /* Amplitude B (dB) */
        270,                     /* On Duration (msecs) */
        0}
 }
 
},

/*
  ********* SIT Tone NC - No Circuit
  */
{SIT_NC,                 /* Signal Id (For now use simple values) */
 {"NC"},                    /* The Signal Label */
    3,
 {          /* Tone Segment list */
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        985,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                     /* Amplitude B (dB) */
        380,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        1428,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        380,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        0x7f,                    /* Next Segment */
        1776,                    /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        380,                  /* On Duration (msecs) */
        0}
 }
 
},

/*
  ********* SIT Tone VC - Vacant Tone
  */
{SIT_VC,                 /* Signal Id (For now use simple values) */
 {"VC"},                 /* The Signal Label */
    3,
 {          /* Tone Segment list */
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        985,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,      /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        380,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        1370,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        270,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        0x7f,                    /* Next Segment */
        1776,                    /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        380,                     /* On Duration (msecs) */
        0}
 }
 
},
/*
  ********* SIT Tone RO - Re-Order (system Busy)
  */
{SIT_RO,                 /* Signal Id (For now use simple values) */
 {"RO"},                    /* The Signal Label */
    3,
 {          /* Tone Segment list */
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        913,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        270,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        1,                       /* Next Segment */
        1428,                     /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        270,                     /* On Duration (msecs) */
        0},
    {0,                       /* Tone Id (from Wgen) */
        2,                       /* Signal Type (3 = Dualtone), 2=single tone */
        1,                       /* Segment count */
        0x7f,                    /* Next Segment */
        1776,                    /* Frequency A (Hz) */
        SINGLE_TONE_AMP,          /* Amplitude A (dB) */
        0,                    /* Frequency B (Hz) */
        0,                    /* Amplitude B (dB) */
        380,                  /* On Duration (msecs) */
        0}
 }
 
},

/*
 * Call Analysis Busy Tone
 */
{BUSY,                 /* Signal Id (For now use simple values) */
 {"B"},                    /* The Signal Label */
    1,
{{0,                       /* Tone Id (from Wgen) */
  3,                       /* Signal Type (3 = Dualtone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  480,                     /* Frequency A (Hz) */
  CALL_AMP_24,          /* Amplitude A (dB) */
  620,                    /* Frequency B (Hz) */
  CALL_AMP_24,          /* Amplitude B (dB) */
  500,        /* On Duration (msecs) */
  500}}},     /* Off Duration (msecs) */

{BUSY_FAST,                 /* Signal Id (For now use simple values) */
 {"F"},                    /* The Signal Label */
    1,
{{0,                       /* Tone Id (from Wgen) */
  3,                       /* Signal Type (3 = Dualtone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  480,                     /* Frequency A (Hz) */
  CALL_AMP_24,          /* Amplitude A (dB) */
  620,                    /* Frequency B (Hz) */
  CALL_AMP_24,          /* Amplitude B (dB) */
  250,        /* On Duration (msecs) */
  250}}},     /* Off Duration (msecs) */

/*
 * Call Analysis Ringback Tone (Single Ringback).
 */
{RINGING1,                 /* Signal Id (For now use simple values) */
 {"R"},                    /* The Signal Label */
    1,
{{0,                       /* Tone Id (from Wgen) */
  3,                       /* Signal Type (3 = Dualtone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  440,                     /* Frequency A (Hz) */
  CALL_AMP_19,          /* Amplitude A (dB) */
  480,                    /* Frequency B (Hz) */
  CALL_AMP_19,          /* Amplitude B (dB) */
  1200,        /* On Duration (msecs) */
  3300}}},     /* Off Duration (msecs) */



/*
 * Call Analysis Ringback Tone (Double Ringback).
 */
{RINGING2,                 /* Signal Id (For now use simple values) */
 {"r"},                    /* The Signal Label */
    2,
{{0,                       /* Tone Id (from Wgen) */
     3,                       /* Signal Type (3 = Dualtone) */
     1,                       /* Segment count */
     1,                    /* Next Segment */
     440,                     /* Frequency A (Hz) */
     CALL_AMP_19,          /* Amplitude A (dB) */
     480,                    /* Frequency B (Hz) */
     CALL_AMP_19,          /* Amplitude B (dB) */
     500,        /* On Duration (msecs) */
     500},
 {0,                       /* Tone Id (from Wgen) */
     3,                       /* Signal Type (3 = Dualtone) */
     1,                       /* Segment count */
     -1,                    /* Next Segment */
     440,                     /* Frequency A (Hz) */
     CALL_AMP_19,          /* Amplitude A (dB) */
     480,                    /* Frequency B (Hz) */
     CALL_AMP_19,          /* Amplitude B (dB) */
     500,           /* On Duration (msecs) */
     2000}},
   },



/*
 * Call Analysis Busy Tone
 */
{GB_BUSY,                 /* Signal Id (For now use simple values) */
 {"GB_B"},                    /* The Signal Label */
    1,
{{0,                       /* Tone Id (from Wgen) */
  3,                       /* Signal Type (3 = Dualtone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  480,                     /* Frequency A (Hz) */
  CALL_AMP_24,          /* Amplitude A (dB) */
  620,                    /* Frequency B (Hz) */
  CALL_AMP_24,          /* Amplitude B (dB) */
  375,        /* On Duration (msecs) */
  375}}},     /* Off Duration (msecs) */


/*
 * Call Analysis Busy Tone
 */
{GB_BUSY_FAST,                 /* Signal Id (For now use simple values) */
 {"GB_F"},                    /* The Signal Label */
    1,
 {{0,                       /* Tone Id (from Wgen) */
  3,                       /* Signal Type (3 = Dualtone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  480,                     /* Frequency A (Hz) */
  CALL_AMP_24,          /* Amplitude A (dB) */
  620,                    /* Frequency B (Hz) */
  CALL_AMP_24,          /* Amplitude B (dB) */
  225,        /* On Duration (msecs) */
  525}}},     /* Off Duration (msecs) */


/*
 * The dial tone
 */
{DIALTONE1,                 /* Signal Id (For now use simple values) */
 {"DL1"},                    /* The Signal Label */
    1,
  {{0,                       /* Tone Id (from Wgen) */
  3,                       /* Signal Type (3 = Dualtone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  350,                     /* Frequency A (Hz) */
  CALL_AMP_24,          /* Amplitude A (dB) */
  440,                    /* Frequency B (Hz) */
  CALL_AMP_24,          /* Amplitude B (dB) */
  1000,        /* On Duration (msecs) */
  0}}},     /* Off Duration (msecs) */


{FAX_CNG1,                 /* Signal Id (For now use simple values) */
 {""},                    /* The Signal Label */
    1,
 {          /* Tone Segment list */
    {0,                       /* Tone Id (from Wgen) */
     2,                       /* Signal Type (3 = Dualtone), 2=single tone */
     5,                       /* Segment count */
     1,                       /* Next Segment */
    1100,                     /* Frequency A (Hz) */
    SINGLE_TONE_AMP,          /* Amplitude A (dB) */
    0,                    /* Frequency B (Hz) */
    0,                    /* Amplitude B (dB) */
    500,                     /* On Duration (msecs) */
    3000},
  }},

/*
 * The japanese dial tone
 */
{JP_DIALTONE1,                 /* Signal Id (For now use simple values) */
 {"JPDL"},                    /* The Signal Label */
    1,
	{{0,                       /* Tone Id (from Wgen) */
  2,                       /* Signal Type (2 = Singletone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  400,                     /* Frequency A (Hz) */
  SINGLE_TONE_AMP,         /* Amplitude A (dB) */
  0,                    /* Frequency B (Hz) */
  0,                    /* Amplitude B (dB) */
  1000,        /* On Duration (msecs) */
  0}}},     /* Off Duration (msecs) */

/*
 * The japanese ringing tone
 */
{JP_RINGING1,                 /* Signal Id (For now use simple values) */
 {"JP_R"},                    /* The Signal Label */
    1,
	{{0,                       /* Tone Id (from Wgen) */
  2,                       /* Signal Type (2 = Singletone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  400,                     /* Frequency A (Hz) */
  SINGLE_TONE_AMP,         /* Amplitude A (dB) */
  0,                    /* Frequency B (Hz) */
  0,                    /* Amplitude B (dB) */
  1000,        /* On Duration (msecs) */
  2000}}},     /* Off Duration (msecs) */

/*
 * The japanese busy tone
 */
{JP_BUSY,                 /* Signal Id (For now use simple values) */
 {"JP_B"},                    /* The Signal Label */
    1,
	{{0,                       /* Tone Id (from Wgen) */
  2,                       /* Signal Type (2 = Singletone) */
  10,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  400,                     /* Frequency A (Hz) */
  SINGLE_TONE_AMP,         /* Amplitude A (dB) */
  0,                    /* Frequency B (Hz) */
  0,                    /* Amplitude B (dB) */
  500,        /* On Duration (msecs) */
  500}}},     /* Off Duration (msecs) */

/*
 * The japanese SIT tone
 */
{JP_SIT_ANY,                 /* Signal Id (For now use simple values) */
 {"JPST"},                    /* The Signal Label */
    1,
	{{0,                       /* Tone Id (from Wgen) */
  2,                       /* Signal Type (2 = Singletone) */
  3,                       /* Segment count */
  0x7F,                    /* Next Segment (There is none) */
  400,                     /* Frequency A (Hz) */
  SINGLE_TONE_AMP,         /* Amplitude A (dB) */
  0,                    /* Frequency B (Hz) */
  0,                    /* Amplitude B (dB) */
  100,        /* On Duration (msecs) */
  100}}},     /* Off Duration (msecs) */
