/**       
 * @file  cnfevts.h
 * @brief Conferencing API event definitions
 * @date  Jan. 24, 2007
 *
 * DIALOGIC CONFIDENTIAL      
 * Copyright (C) 2005-2011 Dialogic Corporation. All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to
 * the source code ("Material") are owned by Dialogic Corporation or its 
 * suppliers or licensors.  Title to the Material remains with Dialogic 
 * Corporation or its suppliers and licensors.  The Material contains trade
 * secrets and proprietary and confidential information of Dialogic or its 
 * suppliers and licensors.  The Material is protected by worldwide copyright
 * and trade secret laws and treaty provisions.  No part of the Material may be
 * used, copied, reproduced, modified, published, uploaded, posted, transmitted,
 * distributed, or disclosed in any way without Dialogic's prior express written
 * permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual 
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise.  Any license under such intellectual property rights must be
 * express and approved by Dialogic in writing.
 */

#ifndef  _CNFEVTS_H_
#define  _CNFEVTS_H_


#define CNFEV_BASE             0xC000L                   ///< Start of success
                                                         ///< conference events
                                                         ///< range.

#define CNFEV_LAST_EVENT       (CNFEV_BASE | 0xFF)       ///< End of success
                                                         ///< conference events
                                                         ///< range.

#define CNFEV_ERROR_BASE       (CNFEV_BASE | 0x0100)     ///< Start of failure
                                                         ///< conference events
                                                         ///< range.

#define CNFEV_LAST_EVENT_ERROR (CNFEV_ERROR_BASE | 0xFF) ///< End of failure
                                                         ///< conference events
                                                         ///< range.

/*
 * Success event definitions
 */
 
#define CNFEV_OPEN                        (CNFEV_BASE | 0x01) ///< Board opened
#define CNFEV_OPEN_CONF                   (CNFEV_BASE | 0x02) ///< Conference opened
#define CNFEV_OPEN_PARTY                  (CNFEV_BASE | 0x04) ///< Party opened
#define CNFEV_ADD_PARTY                   (CNFEV_BASE | 0x06) ///< Party added
#define CNFEV_REMOVE_PARTY                (CNFEV_BASE | 0x07) ///< Party removed
#define CNFEV_GET_ATTRIBUTE               (CNFEV_BASE | 0x08) ///< Got attributes
#define CNFEV_SET_ATTRIBUTE               (CNFEV_BASE | 0x09) ///< Attributes set
#define CNFEV_ENABLE_EVENT                (CNFEV_BASE | 0x0A) ///< Events enabled
#define CNFEV_DISABLE_EVENT               (CNFEV_BASE | 0x0B) ///< Events disabled
#define CNFEV_GET_DTMF_CONTROL            (CNFEV_BASE | 0x0C) ///< DTMF control retrieved
#define CNFEV_SET_DTMF_CONTROL            (CNFEV_BASE | 0x0D) ///< DTMF control set
#define CNFEV_GET_ACTIVE_TALKER           (CNFEV_BASE | 0x0E) ///< Active talkers retrieved
#define CNFEV_GET_PARTY_LIST              (CNFEV_BASE | 0x0F) ///< Party list retrieved
#define CNFEV_GET_DEVICE_COUNT            (CNFEV_BASE | 0x10) ///< Device count retrieved
#define CNFEV_RESET_DEVICES               (CNFEV_BASE | 0x11) ///< Devices reset
#define CNFEV_GET_VIDEO_LAYOUT            (CNFEV_BASE | 0x12) ///< Got video layout
#define CNFEV_SET_VIDEO_LAYOUT            (CNFEV_BASE | 0x13) ///< Video layout set
#define CNFEV_GET_VISIBLE_PARTY_LIST      (CNFEV_BASE | 0x14) ///< Got visible party list
#define CNFEV_SET_VISIBLE_PARTY_LIST      (CNFEV_BASE | 0x15) ///< Visible party list set
#define CNFEV_LISTEN                      (CNFEV_BASE | 0x16) ///< Party device listening
#define CNFEV_UNLISTEN                    (CNFEV_BASE | 0x17) ///< Party device listening stopped
#define CNFEV_GET_PRIVILEGE_TALKER        (CNFEV_BASE | 0x18) ///< Privilege talkers retrieved
#define CNFEV_PARSE_OVERLAY_XML_FILE      (CNFEV_BASE | 0x19) ///< Parse XML file passed

/*
 * notification event definitions
 */

#define CNFEV_CONF_OPENED                 (CNFEV_BASE | 0x30) ///< Conference opened notification event
#define CNFEV_CONF_CLOSED                 (CNFEV_BASE | 0x31) ///< Conference closed notification event
#define CNFEV_PARTY_ADDED                 (CNFEV_BASE | 0x32) ///< Party added notification event
#define CNFEV_PARTY_REMOVED               (CNFEV_BASE | 0x33) ///< Party removed notification event
#define CNFEV_DTMF_DETECTED               (CNFEV_BASE | 0x34) ///< DTMF detected notification event
#define CNFEV_ACTIVE_TALKER               (CNFEV_BASE | 0x35) ///< Active talker notification event
#define CNFEV_PARTY_OPENED                (CNFEV_BASE | 0x36) ///< Party opened notification event
#define CNFEV_PARTY_CLOSED                (CNFEV_BASE | 0x37) ///< Party closed notification event
#define CNFEV_EXCEEDED_CONF_LICENSE       (CNFEV_BASE | 0x38) ///< Exceeded Conf Lic notification event
#define CNFEV_OVERLAY_CONTENT_EXPIRED     (CNFEV_BASE | 0x39) ///< Overlay content expired notification event

/*
 * Error event definitions
 */
 
#define CNFEV_ERROR                       (CNFEV_ERROR_BASE | 0x00) ///< General error
#define CNFEV_OPEN_FAIL                   (CNFEV_ERROR_BASE | 0x01) ///< Open board failure
#define CNFEV_OPEN_CONF_FAIL              (CNFEV_ERROR_BASE | 0x02) ///< Open conference failure
#define CNFEV_OPEN_PARTY_FAIL             (CNFEV_ERROR_BASE | 0x04) ///< Open party failure
#define CNFEV_ADD_PARTY_FAIL              (CNFEV_ERROR_BASE | 0x06) ///< Add party failure
#define CNFEV_REMOVE_PARTY_FAIL           (CNFEV_ERROR_BASE | 0x07) ///< Remove party failure
#define CNFEV_GET_ATTRIBUTE_FAIL          (CNFEV_ERROR_BASE | 0x08) ///< Get attributes failure
#define CNFEV_SET_ATTRIBUTE_FAIL          (CNFEV_ERROR_BASE | 0x09) ///< Set attributes failure
#define CNFEV_ENABLE_EVENT_FAIL           (CNFEV_ERROR_BASE | 0x0A) ///< Enable events failure
#define CNFEV_DISABLE_EVENT_FAIL          (CNFEV_ERROR_BASE | 0x0B) ///< Disable events failure
#define CNFEV_GET_DTMF_CONTROL_FAIL       (CNFEV_ERROR_BASE | 0x0C) ///< Get DTMF control failure
#define CNFEV_SET_DTMF_CONTROL_FAIL       (CNFEV_ERROR_BASE | 0x0D) ///< Set DTMF control failure
#define CNFEV_GET_ACTIVE_TALKER_FAIL      (CNFEV_ERROR_BASE | 0x0E) ///< Get active talker failure
#define CNFEV_GET_PARTY_LIST_FAIL         (CNFEV_ERROR_BASE | 0x0F) ///< Get party list failure
#define CNFEV_GET_DEVICE_COUNT_FAIL       (CNFEV_ERROR_BASE | 0x10) ///< Get device count failure
#define CNFEV_RESET_DEVICES_FAIL          (CNFEV_ERROR_BASE | 0x11) ///< Reset devices failure
#define CNFEV_GET_VIDEO_LAYOUT_FAIL       (CNFEV_ERROR_BASE | 0x12) ///< Get video layout failure
#define CNFEV_SET_VIDEO_LAYOUT_FAIL       (CNFEV_ERROR_BASE | 0x13) ///< Set video layout failure
#define CNFEV_GET_VISIBLE_PARTY_LIST_FAIL (CNFEV_ERROR_BASE | 0x14) ///< Get visible party list failure
#define CNFEV_SET_VISIBLE_PARTY_LIST_FAIL (CNFEV_ERROR_BASE | 0x15) ///< Set visible party list failure
#define CNFEV_LISTEN_FAIL                 (CNFEV_ERROR_BASE | 0x16) ///< Party device listening failure
#define CNFEV_UNLISTEN_FAIL               (CNFEV_ERROR_BASE | 0x17) ///< Party device unlistening failure
#define CNFEV_GET_PRIVILEGE_TALKER_FAIL   (CNFEV_ERROR_BASE | 0x18) ///< Get privilege talker list failure
#define CNFEV_PARSE_OVERLAY_XML_FILE_FAIL (CNFEV_ERROR_BASE | 0x19) ///< Parse XML file failure
 
#endif /* _CNFEVTS_H_ */
