#if !defined(__CODERS_H__)
#define __CODERS_H__
/* 





DM3 Standard Coders Interface Specification













Sign Off Authorization


Chris Chuba	__________________________________	Date:	__________
Group Leader	Signature

Arthur Elwell	__________________________________	Date:	__________
Author/DM3 SW Engineer	Signature






	Date:	07/29/2002
	Revision	1.18
	Filename: 	Coderdef.doc
	Author: 	Arthur Elwell
	Document #: 	SWS-0837


INTEL CONFIDENTIAL

TABLE OF CONTENTS
1 Overview	3
1.1 Revision History	3
1.2 Purpose	5
1.3 Scope	5
1.4 References	5
2 Theory of Operation	6
2.1 Function of Coders	6
2.2 Adding a New Coder	6
3 Environmental Requirements	7
3.1	Processor	7
4 Definition Set	8
4.1 CoderInfo_t	9
4.2 coderStatus	10
5 Function Set	11
5.1 coderGetInfo	11
5.2 coderGetInfoByIndex	12
6 Coder Equates	13
7 Attributes	27
8 Miscellaneous Equates	28
9 Coders Table for Host	32
	
1 Overview
This document describes the programming interface used by the DM3 Coders Component ("coders"). This is the DM3 Component that provides information regarding the supported encoders and decoders. The DM3 Coders Component is a functional interface and sends and receives no messages. It is intended for use with DM3 Platform components. 
In addition to the written description of each element, this word processor document may be saved as a text-only file to become a C header file. The C header file of equates, and definitions, is then used by any component that wishes to utilize this Component.  
1.1 Revision History

REVISION HISTORY
Rev.
Date of Change
Description of Change
Rev Originator
0.1
2/17/98
Initial Release
Arthur Elwell
0.2
5/12/98
Add G723 and G729
Catherine Cai
0.3
5/27/98
Add G729a
Catherine Cai
0.4
7/9/1998
Added Linear PCM defines only
Arthur Elwell
0.5
8/11/1998
Modified coderInfo_t structure, added coderGetInfoByIndex
Arthur Elwell
0.6
10/29/1998
Moved includes of dec_defs.h> and enc_defs.h to be for resources only.
Arthur Elwell
0.7
11/4/98
Fixed typo of CODERS_WAVE_FORMAT_4M16_NAME
Ray Bailey
0.8
5/16/99
Allowed CODER_VendorId, CODER_Variant, and AllowDefAllocation
Ray Bailey
0.9
7/15/99
Add WAV to Standard bundle, create a 12ms bundle and add GSM 6.10 and G7.26 ADPCM to this 12ms bundle
Catherine Cai
1.0
8/31/99
Added RTP encoding to GSM 06.10 codec
Murat Eren
1.1
7/25/00
Added G.726 multiple rate and Dallas codec
Ling Chen
1.2
9/15/00
Changed the Dallas codec status to DefAllocationNotAllowed
Arthur Elwell
1.3
9/30/00
Added TrueSpeech codec
Ling Chen
1.4
10/10/2000
Add the G711, G721 and Dallas bit reversal codec for 8-bit word bit reversal and 16-bit word bit reversal
Catherine Cai
1.5
01/25/2001
Add G721 16 bit nibble reverse and IMA Codec
Bing Leng
1.6
02/01/2001
Moved G723 and G729 to Coders_30ms bundle and changed the path for enc_defs.h and decs_def.h file
Himanshu Patel
1.7
02/20/2001
Changed CODERS_G721_16BIT_REV_BYTE_SWAP to CODERS_G721_16BIT_REV_NIBBLE_SWAP
Ranjan
1.8  
02/20/2001
Complete the changes from CODERS_G721_16BIT_REV_BYTE_SWAP to CODERS_G721_16BIT_REV_NIBBLE_SWAP
Bing Leng
1.8.1
2/21/2001
Add 3 more field in the codersInfo structure, framesize, minFramePerBlcok and maxFramePerBlcok, only initialization for the basic coder (g711, oki and wav)
Catherine Cai
1.9.1
03/02/01
Added QARM Condition which was manually added to Coders.h in Continuus 
Himanshu
1.10
04/11/2001
&
4/25/2001
1. Eliminate the mimDataRequired in codesInfo structure,
2. Eliminate the componentAttribute in codesInfo structure,
3. Combine the Decoder and Encoder list to one codesInfo list,
4. Add CODER_MULAW64, CODERS_ALAW64, CODERS_MULAW48, CODERS_ALAW48, CODERS_OKI32, CODERS_OKI24, 
5. Changed the G729D, 729E to CODERS_G729 and G729AD, G729AE to CODERS_G729As,
6. Changed  the CODERS_G723D to CODERS_G723, CODERS_G723E_HI to CODERS_G723HI, and CODERS_G723E_LO to CODERS_G723LO,
7. Remove the all WAV define except two we are supporting, 11k 8bit and 11k 16bit,
8. Added Dallas Bundle.
9. Removed the VSF coder bundle,
10. Eliminate the minFramePerBlock in the codersInfo structure,
11. Add hard coded number for each coderType enum.
12. Make the enumeration backward compatible. 

Catherine Cai
1.10.1
9/17/2001
Add the linear 8k sampling rate 16-bit/sample define
Catherine Cai
1.11
10/29/01
Added MaxEncBytesPerBlock to the codesInfo structure for each coder type
Changed MaxDecoderFrameSize to MaxDecBytesPerBlock in the codesInfo structure for each coder type
Added the old G723 definition names temporarily to avoid compilation problems.
Removed TTS coder type
Removed vendorIDAttribute
Removed languageAttribute
Removed textAttribute
Removed variantAttribute
Created a sparse table so CP does not have to search through the table.  The coder type can be directly indexed into the table.  Should save MIPS for little increase in memory.
Ranjan
1.12
02/08/2002
Added Glenayre Coder Definition
Himanshu
1.13
03/07/2002
Corrected Defines for Glenayre
Himanshu
1.14
03/26/2002
1.Corrected coder_type value in the table for CODERS_G711_ALAW_NAME entry.
Himanshu
1.15
03/26/2002
Created new table for host to access coders definitions. 
Any new entry into enum DLGCCoderTypes table,Please update the DLGCCoderTable[].

Himanshu
1.16
05/16/2002
Added preprocess flag for DLGCCoderTable to compile only for HOST.
Himanshu
1.17
07/12/2002
Changed CODER_Bundle_Dallas to CODER_Bundle_20ms and changed DefAllocationNotAllowed to DefAllocationAllowed for Dallas coder family 
(Ptr# 27257)
Himanshu
1.18
07/29/2002
Add CODERS_LINEAR_8K_8BIT to DM3 and make CODERS_LINEAR_8K_16BIT work for both LUNA and DM3
Jiangang
1.2 Purpose
The purpose of this document is to describe the functional interface between the Dialogic Vox Resources, resident, both, on the DM3 platform's control processor (CP), and the signal processors, and the DM3 Coders Component.
This document will be used by the developers of the DM3Standard Vox Components (Player, Recorder, Decoder and Encoder),  as well as by technology partners adding new audio coders and using the standard interface provided.
1.3 Scope
This document defines all of the messages that the Standard Audio Decoder Components may send and receive. It also defines all of the parameters that apply to these Components.
1.4 References
SWS-0143				Standard Interface Specification for Mercury Components by Luke Kiernan
2 Theory of Operation
2.1 Function of Coders
TBD
2.2 Adding a New Coder
The following assumes that the appropriate steps contained in The Component Developer's Guide have been followed, if the new Coder is to be part of a new component, or, that the new Coder will be added to the set of coders in the Dialogic Standard Decoder or Encoder Frameworks. For a new coder to be added, its combination of type and componentAttribute must be unique.
* Add any fields, necessary for the new coder, to the CoderInfo_t structure.
* Add the coder equates specific to the new coder to section 6. Coder Equates.
* Surround the new coder equates with conditional compilation delimiters for processor specific compilations.
* Update the coders.c code module to include the new coder information. If new fields have been added to the structure, then the original data structures must be updated to include the new fields.
3 Environmental Requirements
3.1	Processor
The DM3 Coders Component functions execute on the control processor, and the signal processor.
4 Definition Set
The following definitions are made using standard C language syntax with accompanying textual descriptions.
*/
#if defined(__Q_INKERNEL__)
#include "qcpu.h"
#include <dec_defs.h>
#include <enc_defs.h>

typedef Uint24 coder_t;

/*



4.1 CoderInfo_t

		
*/

typedef	struct coderInfo_s {
		char 	*name;
		coder_t	type;
		Int32	coderBundleAttribute;
		Int32	allowDefAllocation;
		Int32	FrameSize;
		Int32	maxDecBytesPerBlock;
		Int32 	maxEncBytesPerBlock;
	} coderInfo_t;

/*
	
 Description
	The coderInfo_t structure type carries the relevant information about the coder. 
* name 	A string containing the ASCII representation of the Coder name.
* type 		The identifier used to uniquely specify the coder algorithm (e.g., MULAW64D or OKI32E).
* coderBundleAttribute	The attribute which identifies a group of associated coders.
* allowDefAllocation	Indicate whether the decoder by default should be allocated during initialization. 
* FrameSize	The frame size in bytes.  For waveform codec, it depends on which task period of this codec is running on.  E.g. For Mulaw64, it is 96 bytes if running on the 12ms task period.
* MaxDecBytesPerBlock	The maximum number of bytes in a block that the host can stream to the resource for Play/Decode. 
* MaxEncBytesPerBlock	The maximum number of bytes in a block that the host can expect from the resource for Record/Encode.
* 

4.2 coderStatus

		
*/
typedef 	enum coderStatus_t {
		CoderValid=0,
		CoderInvalid=1,
	   CoderOutOfRange=2
	} coderStatus;

/*
	
 Description
	The coderStatus enumeration type is used as the return type of the coder functions to convey the status of the coder. 
5 Function Set
The following functions are defined using standard C language syntax, with accompanying textual descriptions. 
5.1 coderGetInfo

		
*/
	coderStatus 	coderGetInfo(coder_t  inputCoder, coderInfo_t  *coderInfo);
/*
	
 Description
	Purpose
This access function is used to retrieve information about a coder which has the type inputCoder. coderGetInfo is intended for use by firmware component developers.
	Input
inputCoder	The Coder Type of the coder to be queried.
	Output
coderInfo 	A structure containing the coder information if the Coder Type is found.
	Return
Returns CoderValid if the input coder is in the list of valid coders, otherwise, CoderInvalid is returned.
	Error conditions
None
	Cautions
None.


5.2 coderGetInfoByIndex

		
*/
	coderStatus 	coderGetInfoByIndex (Uint32  coderIndex, coderInfo_t  *pCoderInfo);
/*
	
 Description
	Purpose
This access function is used to retrieve coder information, sequentially, from the internal list of coders. coderGetInfoByIndex is  intended for use by firmware component developers.
	Input
coderIndex	The index of the next coder to be queried. To do a query from the beginning of the list, this should be set to zero
	Output
pCoderInfo  	A structure containing the coder information.
	Return
Returns CoderValid if the input coder is in the list of valid coders, otherwise, CoderInvalid is returned.
	Error conditions
None
	Cautions
None.
*/
#endif    /* #if defined(__Q_INKERNEL__) */
/*

6 Coder Equates
*/
enum DLGCCoderTypes {
/*
This table gives the Coder Type definitions for Dialogic Standard Coders.

Coder
Coder Type Definition
MuLaw 64k Decoder

*/ 
MULAW64D=1,
/*
MuLaw 64k Encoder

*/
MULAW64E =2,
/*
OKI 32k Decoder
*/
OKI32D=3,
/*

OKI 32k Encoder

*/
OKI32E=4,
/*

ALaw 64k Decoder

*/
ALAW64D=5,
/*

ALaw 64k Encoder

*/
ALAW64E=6, 
/*

OKI 24k Decoder

*/
OKI24D=7,
/*

OKI 24k Encoder

*/
OKI24E=8,
/*

MuLaw 48k Decoder

*/
MULAW48D=9,
/*

MuLaw 48k Encoder

*/
MULAW48E=10,
/*

ALaw 48k Decoder

*/
ALAW48D=11,
/*
ALaw 48k Encoder

*/
ALAW48E=12,
/*
Discontinue of enum, intention leave as blank

G723.1 Coder
*/
CODERS_G723=14,
/*
G723.1 High Rate Coder
*/
CODERS_G723HI=15,
/*
G723.1 Low Rate Coder
*/
CODERS_G723LO=16,
/*
G729 
*/
CODERS_G729=17,
/*
G729a 
*/
CODERS_G729A=18,
/*
Discontinue of enum, intention leave as blank

Discontinue of enum, intention leave as blank

11.025 kHz, mono, 8-bit
*/
CODERS_WAVE_FORMAT_1M08=21,
/*
11.025 kHz, mono, 16-bit
*/
CODERS_WAVE_FORMAT_1M16=22,
/*
8kHz, 16-bit linear pcm
*/
CODERS_LINEAR_8K_16BIT=23,
/*
8kHz, 8-bit linear pcm
*/
CODERS_LINEAR_8K_8BIT=24,
/*
Discontinue of enum, intention leave as blank

Discontinue of enum, intention leave as blank

G711 Mulaw 64kbps
*/
CODERS_MULAW64=27,
/*
G711 Mulaw 48kbps
*/
CODERS_MULAW48=28,
/*
G711 Alaw 64kbps
*/
CODERS_ALAW64=29,
/*
G711 Alaw 48kbps
*/
CODERS_ALAW48=30,
/*

OKI ADPCM 32kbps

*/
CODERS_OKI32=31,
/*

OKI ADPCM 24kbps

*/
CODERS_OKI24=32,
/*
G726 ADPCM default rate
*/
CODERS_G726=33,
/*
Full Rate GSM 6.10
*/
CODERS_FULL_RATE_GSM_610=34,
/*
Full Rate GSM RTP
*/
CODERS_FULL_RATE_GSM_RTP=35,
/*
Dallas ADPCM
*/
CODERS_DALLAS=36,
/*
G726 ADPCM, 16kps rate
*/
CODERS_G726_16K=37,
/*
G726 ADPCM, 24kps rate
*/
CODERS_G726_24K=38,
/*
G726 ADPCM, 32kps rate
*/
CODERS_G726_32K=39,
/*
G726 ADPCM, 40kps rate
*/
CODERS_G726_40K=40,
/*
TrueSpeech 
*/
CODERS_TRUESPEECH=41,
/*
Dallas ADPCM 8-bit reversal
*/
CODERS_DALLAS_8BIT_REV=42,
/*
Dallas ADPCM 16-bit reversal
*/
CODERS_DALLAS_16BIT_REV=43,
/*
G711 Mulaw
*/
CODERS_G711_MULAW=44,
/*
G711 Mulaw 8-bit reversal
*/
CODERS_G711_MULAW_8BIT_REV=45,
/*
G711 Mulaw 16-bit reversal
*/
CODERS_G711_MULAW_16BIT_REV=46,
/*
G711 Alaw
*/
CODERS_G711_ALAW=47,
/*
G711 Alaw 8-bit reversal
*/
CODERS_G711_ALAW_8BIT_REV=48,
/*
G711 Alaw 16-bit reversal
*/
CODERS_G711_ALAW_16BIT_REV=49,
/*
G721 ADPCM, 32kbps
*/
CODERS_G721=50,
/*
G721 ADPCM, 32kbps, 8-bit reversal
*/
CODERS_G721_8BIT_REV=51,
/*
G721 ADPCM, 32kbps, 16-bit reversal
*/
CODERS_G721_16BIT_REV=52,
/*
G721 ADPCM, 32kbps, 16-bit reversal and byte swap
*/
CODERS_G721_16BIT_REV_NIBBLE_SWAP=53,
/*
IMA Coder
*/
CODERS_IMA=54,
/*
GLENAYRE Coder
*/
CODERS_GLENAYRE=55,
/*
G723.1 Decoder (temporary to be deleted later)
*/
G723D=56,
/*
G723.1 High Rate Encoder (temporary to be deleted later)
*/
G723E_HI=57,
/*
G723.1 Low Rate Encoder (temporary to be deleted later)
*/
G723E_LO=58,
/*
G729 Decoder (temporary to be deleted later)
*/
G729D=59,
/*
G729 Encoder (temporary to be deleted later)
*/
G729E=60,
/*
G729a Decoder (temporary to be deleted later)
*/
G729AD=61,
/*
G729a Encoder (temporary to be deleted later)
*/
G729AE=62,

};




/* The following table gives the characteristic definitions for Decoders
Coder
Definitions
MuLaw 64k Decoder

*/
#define MULAW64D_NAME "MuLaw 64k Decoder"
#define CODERS_FRMSIZ_8K_G711 96
#define CODERS_MAX_FRM_8K_G711 42
#define CODERS_MAX_DEC_BYTES_8K_G711 4032
/*
MuLaw 64k Encoder
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define MULAW64E_NAME "MuLaw 64k Encoder"
#define CODERS_MAX_ENC_BYTES_8K_G711 3840
/*

OKI 32k Decoder

*/
#define OKI32D_NAME "OKI 32k Decoder"
#define CODERS_FRMSIZ_32K_OKI 48
#define CODERS_MAX_FRM_32K_OKI 84
#define CODERS_MAX_DEC_BYTES_32K_OKI 4032
/*

OKI 32k Encoder
(framesize, and max frames per block using the OKI 32 Decoder)
*/
#define OKI32E_NAME "OKI 32k Encoder"
#define CODERS_MAX_ENC_BYTES_32K_OKI 3936
/*

ALaw 64k Decoder
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define ALAW64D_NAME "ALaw 64k Decoder"
/*

ALaw 64k Encoder
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define ALAW64E_NAME "ALaw 64k Encoder"
/*

OKI 24k Decoder

*/
#define OKI24D_NAME "OKI 24k Decoder"
#define CODERS_FRMSIZ_24K_OKI 36
#define CODERS_MAX_FRM_24K_OKI 112
#define CODERS_MAX_DEC_BYTES_24K_OKI 4032
/*

OKI 24k Encoder
(framesize, max frames per block using the OKI24 Decoder)
*/
#define OKI24E_NAME "OKI 24k Encoder"
#define CODERS_MAX_ENC_BYTES_24K_OKI 3960
/*

MuLaw 48k Decoder

*/
#define MULAW48D_NAME "MuLaw 48k Decoder"
#define CODERS_FRMSIZ_6K_G711 72
#define CODERS_MAX_FRM_6K_G711 56
#define CODERS_MAX_DEC_BYTES_6K_G711 4032
/*

MuLaw 48k Encoder
(framesize, max frames per block using the Mulaw48k Decoder)
*/
#define MULAW48E_NAME "MuLaw 48k Encoder"
#define CODERS_MAX_ENC_BYTES_6K_G711 3960
/*

ALaw 48k Decoder
(framesize, max frames per block using the Mulaw48k Decoder)
*/
#define ALAW48D_NAME "ALaw 48k Decoder"
/*

ALaw 48k Encoder
(framesize, max frames per block using the Mulaw48k Decoder)
*/
#define ALAW48E_NAME "ALaw 48k Encoder"
/*
TTS Decoder
( No frame size requirement for TTS, by default, the max Bstream  data size, 4032 bytes, should be sent)
*/
#define TTS_NAME "Text-To-Speech Decoder"
/*
G723.1 Coder
(framesize, max frames per block using the G723.1 Hi by default, might need to be changed)
*/
#define CODERS_G723_NAME "G723 Coder"
/*
G723.1 High Rate Coder
*/
#define CODERS_G723HI_NAME "G723 High Rate Coder"
#define CODERS_FRMSIZ_G723HI 24
#define CODERS_MAX_FRM_G723HI 168
#define CODERS_MAX_DEC_BYTES_G723HI 4032
#define CODERS_MAX_ENC_BYTES_G723HI 3984
/*
G723.1 Low Rate Coder
*/
#define CODERS_G723LO_NAME "G723 Low Rate Coder"
#define CODERS_FRMSIZ_G723LO 20
#define CODERS_MAX_FRM_G723LO 201
#define CODERS_MAX_DEC_BYTES_G723LO 4020
#define CODERS_MAX_ENC_BYTES_G723LO 3980

/*
G729 

*/
#define CODERS_G729_NAME "G729 Coder"
#define CODERS_FRMSIZ_G729 30
#define CODERS_MAX_FRM_G729 134
#define CODERS_MAX_DEC_BYTES_G729 4020
#define CODERS_MAX_ENC_BYTES_G729 3990
/*
G729a 
(framesize, max frames per block using the G729 Decoder)
*/
#define CODERS_G729A_NAME "G729A Coder"
/*
11.025 kHz, mono, 8-bit
*/
#define CODERS_WAVE_FORMAT_1M08_NAME "11.025 kHz, mono, 8-bit Coder"
#define CODERS_FRMSIZ_WAVE_1M08 132
#define CODERS_MAX_FRM_WAVE_1M08 30
#define CODERS_MAX_DEC_BYTES_WAVE_1M08 3960
#define CODERS_MAX_ENC_BYTES_WAVE_1M08 3696
/*
11.025 kHz, mono, 16-bit
*/
#define CODERS_WAVE_FORMAT_1M16_NAME "11.025 kHz, mono, 16-bit Coder"
#define CODERS_FRMSIZ_WAVE_1M16 264
#define CODERS_MAX_FRM_WAVE_1M16 15
#define CODERS_MAX_DEC_BYTES_WAVE_1M16 3960
#define CODERS_MAX_ENC_BYTES_WAVE_1M16 3432
/*
8kHz, 16-bit linear pcm
*/
#define CODERS_LINEAR_8K_16BIT_NAME "8kHZ, 16-bit linear PCM"
#define CODERS_FRMSIZ_LINEAR_8K_16BIT 192
#define CODERS_MAX_FRM_LINEAR_8K_16BIT 21
#define CODERS_MAX_DEC_BYTES_LINEAR_8K_16BIT 4032
#define CODERS_MAX_ENC_BYTES_LINEAR_8K_16BIT 3648
/*
8kHz, 8-bit linear pcm
*/
#define CODERS_LINEAR_8K_8BIT_NAME "8kHZ, 8-bit linear PCM"
#define CODERS_FRMSIZ_LINEAR_8K_8BIT 96
#define CODERS_MAX_FRM_LINEAR_8K_8BIT 42
#define CODERS_MAX_DEC_BYTES_LINEAR_8K_8BIT 4032
#define CODERS_MAX_ENC_BYTES_LINEAR_8K_8BIT 3840
/*
G711 Mulaw 64kbps
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_MULAW64_NAME "MuLaw 64kbps coder"
/*
G711 Mulaw 48kbps
(framesize, max frames per block using the Mulaw48k Decoder)
*/
#define CODERS_MULAW48_NAME "MuLaw 48kbps coder"
/*
G711 Alaw 64kbps
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_ALAW64_NAME "ALaw 64kbps coder"
/*
G711 Alaw 48kbps
(framesize, max frames per block using the Mulaw48k Decoder)
*/
#define CODERS_ALAW48_NAME "ALaw 48kbps coder"
/*
OKI ADPCM 32kbps
(framesize, and max frames per block using the OKI 32 Decoder)
*/
#define CODERS_OKI32_NAME "OKI 32kpbs Coder"
/*
OKI ADPCM 24kbps
(framesize, and max frames per block using the OKI 24 Decoder)
*/
#define CODERS_OKI24_NAME "OKI 24kpbs Coder"
/*
G726 ADPCM default rate

*/
#define CODERS_G726_NAME "G7.26 ADPCM Coder"
#define CODERS_FRMSIZ_G726_32K 80
#define CODERS_MAX_FRM_G726_32K 50
#define CODERS_MAX_DEC_BYTES_G726_32K 4000
#define CODERS_MAX_ENC_BYTES_G726_32K 3920
/*
Full Rate GSM 6.10
*/
#define CODERS_GSM_610_NAME "Full Rate GSM 6.10 Coder"
#define CODERS_FRMSIZ_GSM_610 65
#define CODERS_MAX_FRM_GSM_610 62
#define CODERS_MAX_DEC_BYTES_GSM_610 4030
#define CODERS_MAX_ENC_BYTES_GSM_610 3965
/*
Full Rate GSM RTP
*/
#define CODERS_GSM_RTP_NAME "Full Rate GSM RTP Coder"
#define CODERS_FRMSIZ_GSM_RTP 33
#define CODERS_MAX_FRM_GSM_RTP 122
#define CODERS_MAX_DEC_BYTES_GSM_RTP 4026
#define CODERS_MAX_ENC_BYTES_GSM_RTP 3993
/*
Dallas ADPCM
(framesize, and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_DALLAS_NAME "DALLAS ADPCM Coder"
/*
G726 ADPCM, 16kps rate
*/
#define CODERS_G726_16K_NAME "G7.26 16KPS Coder"
#define CODERS_FRMSIZ_G726_16K 40
#define CODERS_MAX_FRM_G726_16K 100
#define CODERS_MAX_DEC_BYTES_G726_16K 4000
#define CODERS_MAX_ENC_BYTES_G726_16K 3920
/*
G726 ADPCM, 24kps rate

*/
#define CODERS_G726_24K_NAME "G7.26 24KPS Coder"
#define CODERS_FRMSIZ_G726_24K 60
#define CODERS_MAX_FRM_G726_24K 67
#define CODERS_MAX_DEC_BYTES_G726_24K 4020
#define CODERS_MAX_ENC_BYTES_G726_24K 3900
/*
G726 ADPCM, 32kps rate
(framesize, and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_G726_32K_NAME "G7.26 32KPS Coder"
/*
G726 ADPCM, 40kps rate
*/
#define CODERS_G726_40K_NAME "G7.26 40KPS Coder"
#define CODERS_FRMSIZ_G726_40K 100
#define CODERS_MAX_FRM_G726_40K 40
#define CODERS_MAX_DEC_BYTES_G726_40K 4000
#define CODERS_MAX_ENC_BYTES_G726_40K 3800
/*
TrueSpeech
*/
#define CODERS_TRUESPEECH_NAME "TrueSpeech Coder"
#define CODERS_FRMSIZ_TRUESPEECH 32
#define CODERS_MAX_FRM_TRUESPEECH 126
#define CODERS_MAX_DEC_BYTES_TRUESPEECH 4032
#define CODERS_MAX_ENC_BYTES_TRUESPEECH 3968
/*
Dallas ADPCM 8-bit reversal
(framesize, and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_DALLAS_8BIT_REV_NAME "Dallas ADPCM 8-bit reversal"
/*
Dallas ADPCM 16-bit reversal
(framesize, and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_DALLAS_16BIT_REV_NAME "Dallas ADPCM 16-bit reversal"
/*
G711 Mulaw
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_G711_MULAW_NAME "G711 Mulaw"
/*
G711 Mulaw 8-bit reversal
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_G711_MULAW_8BIT_REV_NAME "G711 Mulaw 8-bit reversal"
/*
G711 Mulaw 16-bit reversal
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_G711_MULAW_16BIT_REV_NAME "G711 Mulaw 16-bit reversal"
/*
G711 Alaw
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_G711_ALAW_NAME "G711 Alaw"
/*
G711 Alaw 8-bit reversal
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_G711_ALAW_8BIT_REV_NAME "G711 Alaw 8-bit reversal"
/*
G711 Alaw 16-bit reversal
(framesize, max frames per block using the Mulaw64k Decoder)
*/
#define CODERS_G711_ALAW_16BIT_REV_NAME "G711 Alaw 16-bit reversal"
/*
G721 ADPCM, 32kbps
(framesize and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_G721_NAME "G721 ADPCM, 32kbps"
/*
G721 ADPCM, 32kbps, 8-bit reversal
(framesize and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_G721_8BIT_REV_NAME " G721 ADPCM, 32kbps, 8-bit reversal"
/*
G721 ADPCM, 32kbps, 16-bit reversal
(framesize and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_G721_16BIT_REV_NAME "G721 ADPCM, 32kbps, 16-bit reversal"
/*
G721 ADPCM, 32kbps, 16-bit nibble swap
(framesize and max frames per block using the ADPCM Default Rate)
*/
#define CODERS_G721_16BIT_REV_NIBBLE_SWAP_NAME "G721 ADPCM, 32kbps, 16-bit nibble reversal"
/*
IMA encoder/decoder



*/
#define CODERS_IMA_NAME "IMA encoder/decoder"
#define CODERS_FRMSIZ_IMA 64
#define CODERS_MAX_FRM_IMA 63
#define CODERS_MAX_DEC_BYTES_IMA 4032
#define CODERS_MAX_ENC_BYTES_IMA 4032
/*
GLENAYRE encoder / decoder
*/
#define CODERS_GLENAYRE_NAME "GLENNAYRE encoder/decoder"
#define CODERS_FRMSIZ_GLENAYRE 80
#define CODERS_MAX_FRM_GLENAYRE 50
#define CODERS_MAX_DEC_BYTES_GLENAYRE 4032
#define CODERS_MAX_ENC_BYTES_GLENAYRE 3920
/*
G723.1 Decoder (temporary to be deleted later)
*/
#define G723D_NAME "G723 Decoder"
/*
G723.1 High Rate Encoder (temporary to be deleted later)
*/
#define G723E_HI_NAME "G723 High Rate Encoder"
/*
G723.1 Low Rate Encoder (temporary to be deleted later)
*/
#define G723E_LO_NAME "G723 Low Rate Encoder"
/*
G729 Decoder (temporary to be deleted later)
*/
#define G729D_NAME "G729 Decoder"
/*
G729 Encoder (temporary to be deleted later)
*/
#define G729E_NAME "G729 Encoder"
/*
G729a Decoder (temporary to be deleted later)
*/
#define G729AD_NAME "G729a Decoder"
/*
G729a Encoder (temporary to be deleted later)
*/
#define G729AE_NAME "G729a Encoder"
/*

*/
enum coderBundles {
/*
The following table gives the definitions for coderBundleAttribute values.
CoderBundleAttribute
Definitions
*/
CODER_Bundle_StdDlgc  
=  1,
/*
The standard Dialogic coder bundle. This includes:
MULAW64D
MULAW64E
CODERS_MULAW64
ALAW64D
ALAW64E
CODERS_ALAW64
OKI32D
OKI32E
CODERS_OKI32
MULAW48D
MULAW48D
CODERS_MULAW48
ALAW48D
ALAW48E
CODERS_ALAW48
OKI24D
OKI24E
CODERS_OKI24
CODERS_WAVE_FORMAT_1M08
CODERS_WAVE_FORMAT_1M16
CODERS_G711_MULAW
CODERS_G711_MULAW_8BIT_REV
CODERS_G711_MULAW_16BIT_REV
CODERS_G711_ALAW
CODERS_G711_ALAW_8BIT_REV
CODERS_G711_ALAW_16BIT_REV
CODERS_LINEAR_8K_16BIT
CODERS_LINEAR_8K_8BIT
*/
CODER_Bundle_StdTTS
,/*
The Dialogic Text-To-Speech coder bundle. This includes:
TTS
*/
CODER_Bundle_Wave 
,/*
The standard Dialogic coder bundle. This includes:
CODERS_WAVE_FORMAT_1M08
CODERS_WAVE_FORMAT_1M16
Not used anymore
*/
CODER_Bundle_20ms,
/*
The 20ms  coder bundle.  This includes:
CODERS_FULL_RATE_GSM_610
CODERS_FULL_RATE_GSM_RTP
CODERS_G726_16K
CODERS_G726_24K
CODERS_G726_32K
CODERS_G726_40K
CODERS_DALLAS
CODERS_DALLAS_8BIT_REV
CODERS_DALLAS_16BIT_REV
CODERS_G721
CODERS_G721_8BIT_REV
CODERS_G721_16BIT_REV
CODERS_G721_16BIT_REV_NIBBLE_SWAP
CODERS_IMA
CODERS_GLENAYRE
*/
CODER_Bundle_30ms,
/*
The 30ms  coder bundle.  This includes:
CODERS_G723
CODERS_G723HI
CODERS_G723LO 
CODERS_G729
CODER_G729A
CODERS_TRUESPEECH
G723D
G723E_HI
G723E_LO
G729D
G729E
G729AD
G729AE
*/
};
/*



		

*/
enum defAllocation {
/*These are the choice for Default Allocation
*/
	DefAllocationNotAllowed=0,
	DefAllocationAllowed
};
/*
7 Attributes
*/
enum coderAttributeKeys {
/*
The following is a list of attribute keys for Coders:

Attribute name
Description
*/
CODER_Bundle 
= 0x2e11,/*
This key identifies a selection of coders grouped together, such as the Dialogic Standard Coders ((Law, ALaw and OKI)
*/
CODER_Language
,/*
This key identifies the language, or the dictionary to be applied to the coding. This applies, primarily, to Text-To-Speech.
*/
CODER_Text
,/*
This key identifies the text characteristics associated with the coding. This applies, primarily, to Text-To-Speech.
*/
CODER_Variant
,/*
This key identifies the variant of a language to be applied to the coding. This applies, primarily, to Text-To-Speech.
*/
CODER_VendorId
};/*
This key identifies the vendor I D for a coder.


8 Miscellaneous Equates
*/
#if defined(_Coders_C_)
static coderInfo_t coderInfo[] = {
/* { "name", coder_type,  coderBundleAttribute, allowDefAllocation, FrameSize, minFramesPerBlock, maxFramesPerBlock} */
/* we do not want to include this table for the ONYX.  Waste of memory */
#if ((QCPU == QI960)|| (QCPU == QX86) ||(QCPU == QARM) )
   {"Not In Use", -1, NULL, NULL, NULL, NULL, NULL},
   { MULAW64D_NAME, MULAW64D, CODER_Bundle_StdDlgc, DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { MULAW64E_NAME, MULAW64E, CODER_Bundle_StdDlgc, DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { OKI32D_NAME, OKI32D, CODER_Bundle_StdDlgc, DefAllocationAllowed,         CODERS_FRMSIZ_32K_OKI, CODERS_MAX_DEC_BYTES_32K_OKI, CODERS_MAX_ENC_BYTES_32K_OKI },
   { OKI32E_NAME, OKI32E, CODER_Bundle_StdDlgc, DefAllocationAllowed,     CODERS_FRMSIZ_32K_OKI, CODERS_MAX_DEC_BYTES_32K_OKI, CODERS_MAX_ENC_BYTES_32K_OKI },
   { ALAW64D_NAME, ALAW64D, CODER_Bundle_StdDlgc, DefAllocationAllowed,   CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { ALAW64E_NAME, ALAW64E, CODER_Bundle_StdDlgc, DefAllocationAllowed,   CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { OKI24D_NAME, OKI24D, CODER_Bundle_StdDlgc, DefAllocationAllowed,     CODERS_FRMSIZ_24K_OKI, CODERS_MAX_DEC_BYTES_24K_OKI, CODERS_MAX_ENC_BYTES_24K_OKI },
   { OKI24E_NAME, OKI24E, CODER_Bundle_StdDlgc, DefAllocationAllowed,     CODERS_FRMSIZ_24K_OKI, CODERS_MAX_DEC_BYTES_24K_OKI, CODERS_MAX_ENC_BYTES_24K_OKI },
   { MULAW48D_NAME, MULAW48D, CODER_Bundle_StdDlgc, DefAllocationAllowed, CODERS_FRMSIZ_6K_G711, CODERS_MAX_DEC_BYTES_6K_G711, CODERS_MAX_ENC_BYTES_6K_G711},
   { MULAW48E_NAME, MULAW48E, CODER_Bundle_StdDlgc, DefAllocationAllowed, CODERS_FRMSIZ_6K_G711, CODERS_MAX_DEC_BYTES_6K_G711, CODERS_MAX_ENC_BYTES_6K_G711},
   { ALAW48D_NAME, ALAW48D, CODER_Bundle_StdDlgc, DefAllocationAllowed,   CODERS_FRMSIZ_6K_G711, CODERS_MAX_DEC_BYTES_6K_G711, CODERS_MAX_ENC_BYTES_6K_G711},
   { ALAW48E_NAME, ALAW48E, CODER_Bundle_StdDlgc, DefAllocationAllowed,   CODERS_FRMSIZ_6K_G711, CODERS_MAX_DEC_BYTES_6K_G711, CODERS_MAX_ENC_BYTES_6K_G711},
  {"Not In Use", -1, NULL, NULL, NULL, NULL, NULL},
   { CODERS_G723_NAME, CODERS_G723, CODER_Bundle_30ms, DefAllocationAllowed, CODERS_FRMSIZ_G723HI, CODERS_MAX_DEC_BYTES_G723HI, CODERS_MAX_ENC_BYTES_G723HI },
   { CODERS_G723HI_NAME, CODERS_G723HI, CODER_Bundle_30ms, DefAllocationAllowed, CODERS_FRMSIZ_G723HI, CODERS_MAX_DEC_BYTES_G723HI, CODERS_MAX_ENC_BYTES_G723HI },
   { CODERS_G723LO_NAME, CODERS_G723LO, CODER_Bundle_30ms,  DefAllocationAllowed, CODERS_FRMSIZ_G723LO, CODERS_MAX_DEC_BYTES_G723LO, CODERS_MAX_ENC_BYTES_G723LO },
   { CODERS_G729_NAME, CODERS_G729, CODER_Bundle_30ms,  DefAllocationAllowed, CODERS_FRMSIZ_G729, CODERS_MAX_DEC_BYTES_G729, CODERS_MAX_ENC_BYTES_G729 },
   { CODERS_G729A_NAME, CODERS_G729A, CODER_Bundle_30ms,  DefAllocationAllowed, CODERS_FRMSIZ_G729, CODERS_MAX_DEC_BYTES_G729, CODERS_MAX_ENC_BYTES_G729 },
   {"Not In Use", -1, NULL, NULL, NULL, NULL, NULL},
   {"Not In Use", -1, NULL, NULL, NULL, NULL, NULL},
	{ CODERS_WAVE_FORMAT_1M08_NAME, CODERS_WAVE_FORMAT_1M08, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_WAVE_1M08, CODERS_MAX_DEC_BYTES_WAVE_1M08, CODERS_MAX_ENC_BYTES_WAVE_1M08},
   { CODERS_WAVE_FORMAT_1M16_NAME, CODERS_WAVE_FORMAT_1M16, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_WAVE_1M16, CODERS_MAX_DEC_BYTES_WAVE_1M16, CODERS_MAX_ENC_BYTES_WAVE_1M16},
   { CODERS_LINEAR_8K_16BIT_NAME, CODERS_LINEAR_8K_16BIT, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_LINEAR_8K_16BIT, CODERS_MAX_DEC_BYTES_LINEAR_8K_16BIT, CODERS_MAX_ENC_BYTES_LINEAR_8K_16BIT},
   { CODERS_LINEAR_8K_8BIT_NAME, CODERS_LINEAR_8K_8BIT, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_LINEAR_8K_8BIT, CODERS_MAX_DEC_BYTES_LINEAR_8K_8BIT, CODERS_MAX_ENC_BYTES_LINEAR_8K_8BIT},
   {"Not In Use", -1, NULL, NULL, NULL, NULL, NULL},
   {"Not In Use", -1, NULL, NULL, NULL, NULL, NULL},
   { CODERS_MULAW64_NAME, CODERS_MULAW64, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
    { CODERS_MULAW48_NAME, CODERS_MULAW48, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_6K_G711, CODERS_MAX_DEC_BYTES_6K_G711, CODERS_MAX_ENC_BYTES_6K_G711},
  { CODERS_ALAW64_NAME, CODERS_ALAW64, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
  { CODERS_ALAW48_NAME, CODERS_ALAW48, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_6K_G711, CODERS_MAX_DEC_BYTES_6K_G711, CODERS_MAX_ENC_BYTES_6K_G711},
  { CODERS_OKI32_NAME, CODERS_OKI32, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_32K_OKI, CODERS_MAX_DEC_BYTES_32K_OKI, CODERS_MAX_ENC_BYTES_32K_OKI },
  { CODERS_OKI24_NAME, CODERS_OKI24, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_24K_OKI, CODERS_MAX_DEC_BYTES_24K_OKI, CODERS_MAX_ENC_BYTES_24K_OKI },
	{ CODERS_G726_NAME, CODERS_G726, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
	{ CODERS_GSM_610_NAME, CODERS_FULL_RATE_GSM_610, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_GSM_610, CODERS_MAX_DEC_BYTES_GSM_610, CODERS_MAX_ENC_BYTES_GSM_610 },
	{ CODERS_GSM_RTP_NAME, CODERS_FULL_RATE_GSM_RTP, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_GSM_RTP, CODERS_MAX_DEC_BYTES_GSM_RTP, CODERS_MAX_ENC_BYTES_GSM_RTP},
   { CODERS_DALLAS_NAME, CODERS_DALLAS, CODER_Bundle_20ms,  DefAllocationAllowed,  CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
   { CODERS_G726_16K_NAME, CODERS_G726_16K, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_16K, CODERS_MAX_DEC_BYTES_G726_16K, CODERS_MAX_ENC_BYTES_G726_16K },
   { CODERS_G726_24K_NAME, CODERS_G726_24K, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_24K, CODERS_MAX_DEC_BYTES_G726_24K, CODERS_MAX_ENC_BYTES_G726_24K },
   { CODERS_G726_32K_NAME, CODERS_G726_32K, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
   { CODERS_G726_40K_NAME, CODERS_G726_40K, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_40K, CODERS_MAX_DEC_BYTES_G726_40K, CODERS_MAX_ENC_BYTES_G726_40K },
   { CODERS_TRUESPEECH_NAME, CODERS_TRUESPEECH, CODER_Bundle_30ms,  DefAllocationAllowed, CODERS_FRMSIZ_TRUESPEECH, CODERS_MAX_DEC_BYTES_TRUESPEECH, CODERS_MAX_ENC_BYTES_TRUESPEECH},
   { CODERS_DALLAS_8BIT_REV_NAME, CODERS_DALLAS_8BIT_REV, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
   { CODERS_DALLAS_16BIT_REV_NAME, CODERS_DALLAS_16BIT_REV, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
   { CODERS_G711_MULAW_NAME, CODERS_MULAW64, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { CODERS_G711_MULAW_8BIT_REV_NAME, CODERS_G711_MULAW_8BIT_REV, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { CODERS_G711_MULAW_16BIT_REV_NAME, CODERS_G711_MULAW_16BIT_REV, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { CODERS_G711_ALAW_NAME, CODERS_ALAW64, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { CODERS_G711_ALAW_8BIT_REV_NAME, CODERS_G711_ALAW_8BIT_REV, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
	{ CODERS_G711_ALAW_16BIT_REV_NAME, CODERS_G711_ALAW_16BIT_REV, CODER_Bundle_StdDlgc,  DefAllocationAllowed, CODERS_FRMSIZ_8K_G711, CODERS_MAX_DEC_BYTES_8K_G711, CODERS_MAX_ENC_BYTES_8K_G711},
   { CODERS_G721_NAME, CODERS_G721, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
   { CODERS_G721_8BIT_REV_NAME, CODERS_G721_8BIT_REV, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
   { CODERS_G721_16BIT_REV_NAME, CODERS_G721_16BIT_REV, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_32K, CODERS_MAX_DEC_BYTES_G726_32K, CODERS_MAX_ENC_BYTES_G726_32K },
	{ CODERS_G721_16BIT_REV_NIBBLE_SWAP_NAME, CODERS_G721_16BIT_REV_NIBBLE_SWAP, CODER_Bundle_20ms,  DefAllocationAllowed, CODERS_FRMSIZ_G726_24K,  CODERS_MAX_DEC_BYTES_G726_24K, CODERS_MAX_ENC_BYTES_G726_24K },
	{ CODERS_IMA_NAME, CODERS_IMA, CODER_Bundle_20ms,  DefAllocationAllowed,    CODERS_FRMSIZ_IMA,  CODERS_MAX_DEC_BYTES_IMA, CODERS_MAX_ENC_BYTES_IMA },
{ CODERS_GLENAYRE_NAME, CODERS_GLENAYRE, CODER_Bundle_20ms,  DefAllocationAllowed,    CODERS_FRMSIZ_GLENAYRE,  CODERS_MAX_DEC_BYTES_GLENAYRE, CODERS_MAX_ENC_BYTES_GLENAYRE },

   { G723D_NAME, G723D, CODER_Bundle_30ms, DefAllocationAllowed,              CODERS_FRMSIZ_G723HI, CODERS_MAX_DEC_BYTES_G723HI, CODERS_MAX_ENC_BYTES_G723HI},
   { G723E_HI_NAME, G723E_HI, CODER_Bundle_30ms, DefAllocationAllowed,                         CODERS_FRMSIZ_G723HI, CODERS_MAX_DEC_BYTES_G723HI, CODERS_MAX_ENC_BYTES_G723HI},
   { G723E_LO_NAME, G723E_LO, CODER_Bundle_30ms, DefAllocationAllowed,                        CODERS_FRMSIZ_G723LO, CODERS_MAX_DEC_BYTES_G723LO, CODERS_MAX_ENC_BYTES_G723LO},
   { G729D_NAME, G729D, CODER_Bundle_30ms, DefAllocationAllowed,                              CODERS_FRMSIZ_G729, CODERS_MAX_DEC_BYTES_G729, CODERS_MAX_ENC_BYTES_G729},
   { G729E_NAME, G729E, CODER_Bundle_30ms, DefAllocationAllowed,              CODERS_FRMSIZ_G729, CODERS_MAX_DEC_BYTES_G729, CODERS_MAX_ENC_BYTES_G729},
   { G729AD_NAME, G729AD, CODER_Bundle_30ms, DefAllocationAllowed,                            CODERS_FRMSIZ_G729, CODERS_MAX_DEC_BYTES_G729, CODERS_MAX_ENC_BYTES_G729},
   { G729AE_NAME, G729AE, CODER_Bundle_30ms, DefAllocationAllowed,                            CODERS_FRMSIZ_G729, CODERS_MAX_DEC_BYTES_G729, CODERS_MAX_ENC_BYTES_G729},
/* Any new entry into this table, need to update the DLGCCoderTable[] located on the last page */
#endif /* if ((QCPU == QI960)|| (QCPU == QX86) || (QCPU == QARM) ) */
   {"End of Coders List", -1,  NULL, NULL, NULL, NULL}
};
#endif  /* if defined(_Coders_C_) */
/*

9 Coders Table for Host 
*/
#if (QCPU >= QHOST)

static unsigned int DLGCCoderTable[] = {

MULAW64D,
MULAW64E ,
OKI32D,
OKI32E,
ALAW64D,
ALAW64E, 
OKI24D,
OKI24E,
MULAW48D,
MULAW48E,
ALAW48D,
ALAW48E,
CODERS_G723,
CODERS_G723HI,
CODERS_G723LO,
CODERS_G729,
CODERS_G729A,
CODERS_WAVE_FORMAT_1M08,
CODERS_WAVE_FORMAT_1M16,
CODERS_LINEAR_8K_16BIT,
CODERS_LINEAR_8K_8BIT,
CODERS_MULAW64,
CODERS_MULAW48,
CODERS_ALAW64,
CODERS_ALAW48,
CODERS_OKI32,
CODERS_OKI24,
CODERS_G726,
CODERS_FULL_RATE_GSM_610,
CODERS_FULL_RATE_GSM_RTP,
CODERS_DALLAS,
CODERS_G726_16K,
CODERS_G726_24K,
CODERS_G726_32K,
CODERS_G726_40K,
CODERS_TRUESPEECH,
CODERS_DALLAS_8BIT_REV,
CODERS_DALLAS_16BIT_REV,
CODERS_G711_MULAW,
CODERS_G711_MULAW_8BIT_REV,
CODERS_G711_MULAW_16BIT_REV,
CODERS_G711_ALAW,
CODERS_G711_ALAW_8BIT_REV,
CODERS_G711_ALAW_16BIT_REV,
CODERS_G721,
CODERS_G721_8BIT_REV,
CODERS_G721_16BIT_REV,
CODERS_G721_16BIT_REV_NIBBLE_SWAP,
CODERS_IMA,
CODERS_GLENAYRE,
G723D,
G723E_HI,
G723E_LO,
G729D,
G729E,
G729AD,
G729AE,

};	
#endif
/*


End of all DM3 Coder Component Definitions


DM3 Standard Coders Interface SpecificationSWS-0837
Revision 1.17 - 07/12/2002


INTEL CONFIDENTIAL
Page 19 of 30*/
#endif

