/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         confLocs.h
 * AUTHOR:       Ray Bailey
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    13-Apr-00 at 18:03:04
 * PURPOSE:
 *
 * HISTORY:
 * Date			Who	Description
 * 19-March-02 JB    Task 12937: PT 25739. Send Std_MsgSetxParms to CSUMS
 * 13-Apr-00          	RB	Initial Version
 ***************************************************************************/
#if !defined(_confLocations_h)
#define _confLocations_h 1

#include "qmiscapi.h"
 
/* 
 * Conf wrappers for qError( ) calls
 */
void confErrKillTask ( Uint24 errTag );
void confErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc );
void confErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );
void confErrWarning ( Uint24 errTag );
void confErrInstWarning ( Uint24 errTag, QCompDesc *pDesc );
void confErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );
void confErrAdvisory ( Uint24 errTag );
void confErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc );
void confErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 );


#if !defined(_Confcomp_C__)
extern char *confLocationsFileName;
#else 
char *confLocationsFileName = "conflocs.h";

/******************************************************************************
 *       NAME : confErrKillTask
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrKillTask ( Uint24 errTag )
{
  qError (QERR_KILLTASK, errTag, confLocationsFileName);
}

/******************************************************************************
 *       NAME : confErrInstKillTask
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_KILLTASK, errTag, confLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : confErrArgsKillTask
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
   int count=4;
   qErrorArgs (QERR_KILLTASK, errTag, confLocationsFileName, pDesc, count, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : confErrWarning
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrWarning ( Uint24 errTag )
{
  qError (QERR_WARNING, errTag, confLocationsFileName);
}

/******************************************************************************
 *       NAME : confErrInstWarning
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrInstWarning ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_WARNING, errTag, confLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : confErrArgsWarning
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_WARNING, errTag, confLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : confErrAdvisory
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrAdvisory ( Uint24 errTag )
{
  qError (QERR_ADVISORY, errTag, confLocationsFileName);
}

/******************************************************************************
 *       NAME : confErrInstAdvisory
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc )
{
  qErrorInst (QERR_ADVISORY, errTag, confLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : confErrArgsAdvisory
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void confErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                     int arg1, int arg2, int arg3, int arg4 )
{
  qErrorArgs (QERR_ADVISORY, errTag, confLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

#endif

#define CONF_LOC_000	0x800000 /* CONF:
				    */

#define CONF_LOC_001	0x800001 /* CONF::,
				    qMsgAllocate(Std_MsgSetParm) FAILED */

#define CONF_LOC_002	0x800002 /* CONF::
				    Std_MsgSetParm_put(Std_MsgSetParm) FAILED */

#define CONF_LOC_003	0x800003 /* CONF::
				    qMsgWrite(Std_MsgSetParm) FAILED */

#define CONF_LOC_004	0x800004 /* CONF:
				    Conf_ResourceCount_get FAILED */

#define CONF_LOC_005	0x800005 /* CONF:
				     qMsgAllocate(Conf_ResourceCountCmplt) FAILED */

#define CONF_LOC_006	0x800006 /* CONF:
				    Conf_ResourceCountCmplt_put FAILED*/

#define CONF_LOC_007	0x800007 /* CONF:
                qMsgWrite(Conf_ResourceCountCmplt) FAILED */

#define CONF_LOC_008	0x800008 /* CONF:
                 qClusterCreateMode() FAILED */

#define CONF_LOC_009	0x800009 /* CONF:
                 qCompAllocate(Conf) FAILED  */

#define CONF_LOC_010	0x800010 /* CONF:
                 qCompInstanceRegister FAILED */

#define CONF_LOC_011	0x800011 /* CONF:
                 qMsgRead FAILED while waiting for QResultComplete */

#define CONF_LOC_012	0x800012 /* CONF:
                 qMsgFree(QResultComplete) FAILED */   

#define CONF_LOC_013	0x800013 /* CONF:
                 Unexpected Message = 0x%x while waiting for QResultComplete */

#define CONF_LOC_014	0x800014 /* CONF:
                  qMsgAllocate(Std_MsgInit) FAILED */

#define CONF_LOC_015	0x800015 /* CONF:
                  qMsgWrite(Std_MsgInit) FAILED */

#define CONF_LOC_016	0x800016 /* CONF:
                  qMemAlloc(Component Parameter Table) FAILED, size = %02d */

#define CONF_LOC_017	0x800017 /* CONF:
                  qCompRegister(Conf) FAILED */

#define CONF_LOC_018	0x800018 /* CONF: 
                  qMsgRead(FOREVER) FAILED */

#define CONF_LOC_019	0x800019 /* CONF: 
                  (qCompInitStart("confInit") FAILED */

#define CONF_LOC_020	0x800020 /* CONF:
                  Std_MsgSetParm_get FAILED */

#define CONF_LOC_021	0x800021 /* CONF:
                  Std_MsgSetParmDef_get FAILED */

#define CONF_LOC_022	0x800022 /* CONF: 
                  Std_MsgGetParm_get FAILED */

#define CONF_LOC_023	0x800023 /* CONF:
                  qMsgAllocate(Std_MsgGetParmCmplt) FAILED */

#define CONF_LOC_024	0x800024 /* CONF: 
                  Std_MsgGetParmCmplt_put FAILED */

#define CONF_LOC_025	0x800025 /* CONF: 
                  qMsgWrite(Std_MsgGetParmCmplt) FAILED */

#define CONF_LOC_026	0x800026 /* CONF: 
                  Conf_DetectEvt_get FAILED */

#define CONF_LOC_027	0x800027 /* CONF:
                  Conf_CancelEvt_get FAILED */

#define CONF_LOC_028	0x800028 /* CONF:
                  confGetParmValue(Std_ParmInstNum) FAILED */

#define CONF_LOC_029	0x800029 /* CONF: NOT USED */

#define CONF_LOC_030	0x800030 /* CONF: 
                  confGetParmValue(Std_ParmStartInst) FAILED */

#define CONF_LOC_031	0x800031 /* CONF: 
                  qMemAlloc(instTotal * sizeof(ConfIDB_t)) FAILED, size =
                  %02d */

#define CONF_LOC_032	0x800032 /* CONF:
                  confComp received unexpected message %02xH in init_normal
                  state */

#define CONF_LOC_033	0x800033 /* CONF: 
                  qMemCalloc(maxPartyGroup * sizeof(PartyGroup_t)) FAILED,
                  size = %02d*/

#define CONF_LOC_034	0x800034 /* CONF:
                  qMemCalloc(pPG->numConf * sizeof(ConfList_t)) FAILED, size
                  = %02d  */

#define CONF_LOC_035	0x800035 /* CONF: 
                  qMemAlloc(QMemXFER,(3*pPG->numConf *  sizeof(ATNData_t)))
                  FAILED, size = %02d */

#define CONF_LOC_036	0x800036 /* CONF:
                  qMsgAllocate(Std_MsgInitCmplt) FAILED*/

#define CONF_LOC_037	0x800037 /* CONF:
                  qMsgWrite(Std_MsgInitCmplt) FAILED */

#define CONF_LOC_038	0x800038 /* CONF: 
                  confComp received unexpected message %02xH in init_waitinitcmplt state */

#define CONF_LOC_039	0x800039 /* CONF: 
                  confComp in unexpected initState %02xH*/

#define CONF_LOC_040	0x800040 /* CONF: 
                  qMsgAllocate(Std_MsgExitCmplt) FAILED   */

#define CONF_LOC_041	0x800041 /* CONF: 
                  qMsgWrite(Std_MsgExitCmplt) FAILED */

#define CONF_LOC_042	0x800042 /* CONF:
                  confComp in unexpected state %02xH */

#define CONF_LOC_043	0x800043 /* CONF:
                  qMsgFree(inMsgPtr) FAILED */

#define CONF_LOC_044	0x800044 /* CONF:
                  qMsgAllocate(Conf_GetConfListCmplt) FAILED */

#define CONF_LOC_045	0x800045 /* CONF:
                  Conf_GetConfListCmplt_put FAILED */

#define CONF_LOC_046	0x800046 /* CONF:
                  Conf_GetConfListCmplt_Pty_put FAILED */

#define CONF_LOC_047	0x800047 /* CONF:
                  qMsgWrite(Conf_GetConfListCmplt) FAILED */

#define CONF_LOC_048	0x800048 /* CONF:
                  qMsgAllocate(Std_MsgComtestCmplt) FAILED */

#define CONF_LOC_049	0x800049 /* CONF:
                  qMsgWrite(Std_MsgComtestCmplt) FAILED */

#define CONF_LOC_050	0x800050 /* CONF:
                  qCompFind(dbgTaskDesc) FAILED */

#define CONF_LOC_051	0x800051 /* CONF:
                  qMsgAllocate(Conf_EstConf) FAILED */

#define CONF_LOC_052	0x800052 /* CONF:
                  Conf_EstConf_put FAILED */

#define CONF_LOC_053	0x800053 /* CONF:
                  Conf_EstConf_Pty_put FAILED */

#define CONF_LOC_054	0x800054 /* CONF:
                   Conf_EstConf_Pty_put FAILED */

#define CONF_LOC_055	0x800055 /* CONF:
                   qMsgRead() FAILED */

#define CONF_LOC_056	0x800056 /* CONF:
                    qMsgAllocate( Std_MsgError) FAILED */

#define CONF_LOC_057	0x800057 /* CONF:
                    Std_MsgError_put FAILED */

#define CONF_LOC_058	0x800058 /* CONF:
                    qMsgWrite(Std_MsgError) FAILED */

#define CONF_LOC_059	0x800059 /* CONF:
                     qMsgAllocate(Conf_DelConfCmplt) FAILED */

#define CONF_LOC_060	0x800060 /* CONF:
                     qPoolFree(ConfPtyStruc_t) FAILED */

#define CONF_LOC_061	0x800061 /* CONF:
                     qMsgAllocate(Conf_DelConf) FAILED */

#define CONF_LOC_062	0x800062 /* CONF:
                     qMsgWrite(Conf_DelConf) FAILED  */

#define CONF_LOC_063	0x800063 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t) FAILED, size = %02d */

#define CONF_LOC_064	0x800064 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_065	0x800065 /* CONF:
                     qMsgWrite(Conf_DelConfCmplt) FAILED */

#define CONF_LOC_066	0x800066 /* CONF:
                     qMsgWrite(Conf_DeleteAllConfsCmplt) FAILED */

#define CONF_LOC_067	0x800067 /* CONF:
                     Conf_DeleteAllConfs_get FAILED */

#define CONF_LOC_068	0x800068 /* CONF:
                     qMsgAllocate(Conf_DeleteAllConfsCmplt) FAILED */

#define CONF_LOC_069	0x800069 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t)FAILED, size = %02d  */

#define CONF_LOC_070	0x800070 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED          */

#define CONF_LOC_071	0x800071 /* CONF:
                     qMsgAllocate(CSUMS_MsgStop) FAILED */

#define CONF_LOC_072	0x800072 /* CONF:
                     qMsgWrite(CSUMS_MsgStop) FAILED */

#define CONF_LOC_073	0x800073 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t)FAILED, size = %02d  */

#define CONF_LOC_074	0x800074 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_075	0x800075 /* CONF:
                     qMsgWrite(Conf_DeleteAllConfsCmplt) FAILED */

#define CONF_LOC_076	0x800076 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_077	0x800077 /* CONF:
                     Conf_EstConf_get FAILED */

#define CONF_LOC_078	0x800078 /* CONF:
                     Conf_EstConf_Pty_get FAILED */

#define CONF_LOC_079	0x800079 /* CONF:
                     qMsgAllocate(Conf_EstConfCmplt) FAILED */

#define CONF_LOC_080	0x800080 /* CONF:
                     Conf_EstConfCmplt_put FAILED */

#define CONF_LOC_081	0x800081 /* CONF:
                     Conf_EstConf_Pty_get FAILED */

#define CONF_LOC_082	0x800082 /* CONF:
                     Conf_EstConfCmplt_Pty_put FAILED */

#define CONF_LOC_083	0x800083 /* CONF:
                     qMsgAllocate(Conf_EstConfCmplt) FAILED */

#define CONF_LOC_084	0x800084 /* CONF:
                     Conf_EstConfCmplt_put FAILED */

#define CONF_LOC_085	0x800085 /* CONF:
                     qMsgAllocate(CSUMS_MsgStart) FAILED */

#define CONF_LOC_086	0x800086 /* CONF:
                     qMsgWrite(CSUMS_MsgStart) FAILED */

#define CONF_LOC_087	0x800087 /* CONF:
                     Conf_EstConfCmplt_Pty_get FAILED */

#define CONF_LOC_088	0x800088 /* CONF:
                     qMsgAllocate(Conf_AddPty) FAILED */

#define CONF_LOC_089	0x800089 /* CONF:
                     Conf_AddPty_put FAILED */

#define CONF_LOC_090	0x800090 /* CONF:
                     qMsgWrite(Conf_AddPty) FAILED */

#define CONF_LOC_091	0x800091 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_092	0x800092 /* CONF:
                     qMsgAllocate(Conf_EstConf) FAILED */

#define CONF_LOC_093	0x800093 /* CONF:
                     qMsgFree(msgType = %02d) FAILED */

#define CONF_LOC_094	0x800094 /* CONF:
                     qMsgFree(msgType = %02d) FAILED  */

#define CONF_LOC_095	0x800095 /* CONF:
                     qMsgWrite(ConfEstCmplt) FAILED */

#define CONF_LOC_096	0x800096 /* CONF:
                     confAllocEvtStatusPool(numEntries * sizeof(Conf_EvtStatusChanged_PtyDiff_t))FAILED, size = %02d          */

#define CONF_LOC_097	0x800097 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED  */

#define CONF_LOC_098	0x800098 /* CONF:
                     qPoolFree(ConfPtyStruc_t) FAILED */

#define CONF_LOC_099	0x800099 /* CONF:
                     qMsgAllocate(CSUMS_MsgStop) FAILED */

#define CONF_LOC_100	0x800100 /* CONF:
                     qMsgWrite(CSUMS_MsgStop) FAILED */

#define CONF_LOC_101	0x800101 /* CONF:
                     qMsgAllocate(Conf_EstConf) FAILED */

#define CONF_LOC_102	0x800102 /* CONF:
                     qMsgFree(msgType = %02d) FAILED        */

#define CONF_LOC_103	0x800103 /* CONF:
                     qMsgAllocate(Conf_EstConf) FAILED */

#define CONF_LOC_104	0x800104 /* CONF:
                     qMsgFree(msgType = %02d) FAILED */

#define CONF_LOC_105	0x800105 /* CONF:
                     qMsgFree(msgType = %02d) FAILED */

#define CONF_LOC_106	0x800106 /* CONF:
                     qGStreamRead FAILED for PartyGroup=%02d, gstreamId= %02d, readSize = %02d */

#define CONF_LOC_107	0x800107 /* CONF:
                     qGStreamTerminate FAILED for PartyGroup=%02d, gstreamId= %02d */

#define CONF_LOC_108	0x800108 /* CONF:
                     Conf_EvtActiveTalker_PtyIdentInfo_put FAILED         */

#define CONF_LOC_109	0x800109 /* CONF:
                     Conf_GetActiveTalkersCmplt_PtyIdentInfo_put FAILED*/

#define CONF_LOC_110	0x800110 /* CONF:
                     qMsgAllocate(Std_MsgDetectEvtCmplt) FAILED */

#define CONF_LOC_111	0x800111 /* CONF:
                     qMsgWrite(Std_MsgDetectEvtCmplt) FAILED */

#define CONF_LOC_112	0x800112 /* CONF:
                     qMsgAllocate(Std_MsgCancelEvtCmplt) FAILED */

#define CONF_LOC_113	0x800113 /* CONF:
                     qMsgWrite(Std_MsgCancelEvtCmplt) FAILED */

#define CONF_LOC_114	0x800114 /* CONF:
                     qGStreamOpen FAILED for PartyGroup = %02d, size = %02d */

#define CONF_LOC_115	0x800115 /* CONF:
                     qMsgAllocate(CSUMS_MsgActiveTalkerNotifyEnable) FAILED */

#define CONF_LOC_116	0x800116 /* CONF:
                     CSUMS_MsgActiveTalkerNotifyEnable_put FAILED */

#define CONF_LOC_117	0x800117 /* CONF:
                     qMsgWrite(CSUMS_MsgActiveTalkerNotifyEnable) FAILED */

#define CONF_LOC_118	0x800118 /* CONF:
                     qGStreamClose FAILED for partyGroup = %02d */

#define CONF_LOC_119	0x800119 /* CONF:
                     qMsgAllocate(CSUMS_MsgActiveTalkerNotifyDisable) FAILED         */

#define CONF_LOC_120	0x800120 /* CONF:
                     qMsgWrite(CSUMS_MsgActiveTalkerNotifyDisable) FAILED */

#define CONF_LOC_121	0x800121 /* CONF:
                     Conf_DetectEvt_get FAILED */

#define CONF_LOC_122	0x800122 /* CONF:
                     Conf_CancelEvt_get FAILED */

#define CONF_LOC_123	0x800123 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_124	0x800124 /* CONF:
                     Conf_EvtActiveTalker_put FAILED */

#define CONF_LOC_125	0x800125 /* CONF:
                     qMsgWrite(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_126	0x800126 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_127	0x800127 /* CONF:
                     qMsgFree(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_128	0x800128 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_129	0x800129 /* CONF:
                     Conf_EvtActiveTalker_put FAILED */

#define CONF_LOC_130	0x800130 /* CONF:
                     qMsgWrite(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_131	0x800131 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_132	0x800132 /* CONF:
                     qMsgFree(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_133	0x800133 /* CONF:
                     Conf_GetActiveTalkers_get FAILED */

#define CONF_LOC_134	0x800134 /* CONF:
                     qMsgAllocate(Conf_GetActiveTalkersCmplt) FAILED */

#define CONF_LOC_135	0x800135 /* CONF:
                     Conf_GetActiveTalkersCmplt_put FAILED */

#define CONF_LOC_136	0x800136 /* CONF:
                     qMsgWrite(Conf_GetActiveTalkersCmplt) FAILED */

#define CONF_LOC_137	0x800137 /* CONF:
                     qMsgAllocate(Conf_GetActiveTalkersCmplt) FAILED */

#define CONF_LOC_138	0x800138 /* CONF:
                     Conf_GetActiveTalkersCmplt_put FAILED */

#define CONF_LOC_139	0x800139 /* CONF:
                     qMsgWrite(Conf_GetActiveTalkersCmplt) FAILED */

#define CONF_LOC_140	0x800140 /* CONF:
                     qPoolFind(sizeof(Conf_EvtStatusChanged_PtyDiff_t) * numEntries) , numEntries=%02d, size = %02d */

#define CONF_LOC_141	0x800141 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_142	0x800142 /* CONF:
                     Conf_EvtStatusChanged_put FAILED */

#define CONF_LOC_143	0x800143 /* CONF:
                     qMsgWrite(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_144	0x800144 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_145	0x800145 /* CONF:
                     Conf_EvtStatusChanged_put FAILED */

#define CONF_LOC_146	0x800146 /* CONF:
                     qMsgWrite(Std_MsgEvtDetected) FAILED) */

#define CONF_LOC_147	0x800147 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED  */

#define CONF_LOC_148	0x800148 /* CONF:
                     qMsgFree(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_149	0x800149 /* CONF:
                     Conf_EvtStatusChanged_PtyDiff_put FAILED */

#define CONF_LOC_150	0x800150 /* CONF:
                     Conf_RmvPty_get FAILED */

#define CONF_LOC_151	0x800151 /* CONF:
                     qMsgAllocate(Conf_RmvPtyCmplt) FAILED */

#define CONF_LOC_152	0x800152 /* CONF:
                     Conf_RmvPtyCmplt_put FAILED */

#define CONF_LOC_153	0x800153 /* CONF:
                     qMsgWrite(Conf_RmvPtyCmplt) FAILED          */

#define CONF_LOC_154	0x800154 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t) FAILED, size = %02d */

#define CONF_LOC_155	0x800155 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_156	0x800156 /* CONF:
                     qPoolFree(ConfPtyStruc_t) FAILED */

#define CONF_LOC_157	0x800157 /* CONF:
                     qMsgAllocate(CSUMS_MsgRemoveParty) FAILED */

#define CONF_LOC_158	0x800158 /* CONF:
                     CSUMS_MsgRemoveParty_put FAILED */

#define CONF_LOC_159	0x800159 /* CONF:
                     qMsgWrite(CSUMS_MsgRemoveParty) FAILED */

#define CONF_LOC_160	0x800160 /* CONF:
                     qMsgAllocate(FEP_MsgStop) FAILED */

#define CONF_LOC_161	0x800161 /* CONF:
                     qMsgWrite(FEP_MsgStop) FAILED */

#define CONF_LOC_162	0x800162 /* CONF:
                     qCompFree(FEP) FAILED */

#define CONF_LOC_163	0x800163 /* CONF:
                     qCompFree(ScBus) FAILED */

#define CONF_LOC_164	0x800164 /* CONF:
                     qClusterPortRemove(ScBus(In)) FAILED */

#define CONF_LOC_165	0x800165 /* CONF:
                     qClusterPortRemove(ScBus(Out)) FAILED          */

#define CONF_LOC_166	0x800166 /* CONF:
                     qMsgFree FAILED */

#define CONF_LOC_167	0x800167 /* CONF:
                     qPoolFree(ConfPtyStruc_t) FAILED */

#define CONF_LOC_168	0x800168 /* CONF:
                     Std_MsgError_get  FAILED */

#define CONF_LOC_169	0x800169 /* CONF:
                     Std_MsgError_get  FAILED */

#define CONF_LOC_170	0x800170 /* CONF:
                     QCompInstNotify_get FAILED */

#define CONF_LOC_171	0x800171 /* CONF:
                     confInst%02d received unexpected message %02xH in deallocated state */

#define CONF_LOC_172	0x800172 /* CONF:
                     qCompAllocate(CSUMS) FAILED */

#define CONF_LOC_173	0x800173 /* CONF:
                     qMsgAllocate(Std_MsgInitCmplt) FAILED */  

#define CONF_LOC_174	0x800174 /* CONF:
                     qMsgWrite(Std_MsgInitCmplt) FAILED */

#define CONF_LOC_175	0x800175 /* CONF:
                     confInst%02d received unexpected message %02xH in init_normal state           */

#define CONF_LOC_176	0x800176 /* CONF:
                     confInst%02d Unexpected mainState %02d */

#define CONF_LOC_177	0x800177 /* CONF:
                     NOT USED  */

#define CONF_LOC_178	0x800178 /* CONF:
                     Std_MsgSetParm_get FAILED */

#define CONF_LOC_179	0x800179 /* CONF:
                     qMsgAllocate(Std_MsgSetParm) FAILED */

#define CONF_LOC_180	0x800180 /* CONF:
                     Std_MsgSetParm_put FAILED */

#define CONF_LOC_181	0x800181 /* CONF:
                     qMsgWrite(Std_MsgSetParm) FAILED */

#define CONF_LOC_182	0x800182 /* CONF:
                     Std_MsgSetParmDef_get FAILED */

#define CONF_LOC_183	0x800183 /* CONF:
                     qMsgAllocate(Std_MsgSetParmDef) FAILED */

#define CONF_LOC_184	0x800184 /* CONF:
                     qMsgWrite(Std_MsgSetParmDef) FAILED  */

#define CONF_LOC_185	0x800185 /* CONF:
                     qMsgAllocate(Std_MsgSetParm) FAILED*/

#define CONF_LOC_186	0x800186 /* CONF:
                     Std_MsgSetParm_put FAILED*/

#define CONF_LOC_187	0x800187 /* CONF:
                     qMsgWrite(Std_MsgSetParm) FAILED */

#define CONF_LOC_188	0x800188 /* CONF:
                     */

#define CONF_LOC_189	0x800189 /* CONF:
                     Std_MsgGetParm_get FAILED */

#define CONF_LOC_190	0x800190 /* CONF:
                     qMsgAllocate(Std_MsgGetParmCmplt) FAILED */

#define CONF_LOC_191	0x800191 /* CONF:
                     Std_MsgGetParmCmplt_put FAILED */

#define CONF_LOC_192	0x800192 /* CONF:
                     qMsgWrite(Std_MsgGetParmCmplt) FAILED */

#define CONF_LOC_193	0x800193 /* CONF:
                     Conf_DetectEvt_get FAILED */

#define CONF_LOC_194	0x800194 /* CONF:
                     qMsgAllocate(Std_MsgDetectEvtCmplt) FAILED */

#define CONF_LOC_195	0x800195 /* CONF:
                     qMsgWrite(Std_MsgDetectEvtCmplt) FAILED */

#define CONF_LOC_196	0x800196 /* CONF:
                     Conf_CancelEvt_get FAILED */

#define CONF_LOC_197	0x800197 /* CONF:
                     qMsgAllocate(Std_MsgCancelEvtCmplt) FAILED */

#define CONF_LOC_198	0x800198 /* CONF:
                     qMsgWrite(Std_MsgCancelEvtCmplt) FAILED */

#define CONF_LOC_199	0x800199 /* CONF:
                     Conf_AddPty_get FAILED */

#define CONF_LOC_200	0x800200 /* CONF:
                     qPoolFind(QMemNORM, sizeof(ConfPtyStruc_t)) FAILED,  size = %02d  */

#define CONF_LOC_201	0x800201 /* CONF:
                     qPoolAlloc(poolId = %02d), needed size = %02d */

#define CONF_LOC_202	0x800202 /* CONF:
                     qMsgAllocate(Conf_AddPtyCmplt) FAILED */

#define CONF_LOC_203	0x800203 /* CONF:
                     Conf_AddPtyCmplt_put FAILED */

#define CONF_LOC_204	0x800204 /* CONF:
                     qClusterPortAdd(Rin) FAILED */

#define CONF_LOC_205	0x800205 /* CONF:
                     qClusterPortAdd(Rout) FAILED */

#define CONF_LOC_206	0x800206 /* CONF:
                     qCompAllocate(ScBus) FAILED */

#define CONF_LOC_207	0x800207 /* CONF:
                     qMsgFree(Conf_AddPtyCmplt) FAILED */

#define CONF_LOC_208	0x800208 /* CONF:
                     qPoolFree(ConfPtyStruc_t) FAILED */

#define CONF_LOC_209	0x800209 /* CONF:
                     qMsgWrite(Conf_AddPtyCmplt) FAILED */

#define CONF_LOC_210	0x800210 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t) FAILED, size = %02d */

#define CONF_LOC_211	0x800211 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_212	0x800212 /* CONF:
                     qMsgAllocate(FEP_MsgStart) FAILED */

#define CONF_LOC_213	0x800213 /* CONF:
                     FEP_MsgStart_put FAILED */

#define CONF_LOC_214	0x800214 /* CONF:
                     qMsgWrite(FEP_MsgStart) FAILED */

#define CONF_LOC_215	0x800215 /* CONF:
                     qMsgAllocate(FEP_MsgStartCmplt) FAILED */

#define CONF_LOC_216	0x800216 /* CONF:
                     FEP_MsgStartCmplt_put FAILED */

#define CONF_LOC_217	0x800217 /* CONF:
                     qMsgWrite(FEP_MsgStartCmplt) FAILED */

#define CONF_LOC_218	0x800218 /* CONF:
                     Invalid SubState = %02d */

#define CONF_LOC_219	0x800219 /* CONF:
                     Invalid partyMode = %02d */

#define CONF_LOC_220	0x800220 /* CONF:
                     qMsgAllocate(CSUMS_MsgAddParty) FAILED */

#define CONF_LOC_221	0x800221 /* CONF:
                     CSUMS_MsgAddParty_put FAILED */

#define CONF_LOC_222	0x800222 /* CONF:
                     qMsgWrite(CSUMS_MsgAddParty) FAILED */

#define CONF_LOC_223	0x800223 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_224	0x800224 /* CONF:
                     CSUMS_MsgAddPartyCmplt_get FAILED */

#define CONF_LOC_225	0x800225 /* CONF:
                     Conf_AddPtyCmplt_get FAILED */

#define CONF_LOC_226	0x800226 /* CONF:
                     qMsgWrite(Conf_AddPtyCmplt) FAILED */

#define CONF_LOC_227	0x800227 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t) FAILED, size = %02d */

#define CONF_LOC_228	0x800228 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_229	0x800229 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_230	0x800230 /* CONF:
                     qMsgFree(Conf_AddPty) FAILED */

#define CONF_LOC_231	0x800231 /* CONF:
                     qMsgAllocate(Std_MsgSetParmCmplt) FAILED */

#define CONF_LOC_232	0x800232 /* CONF:
                     qMsgWrite(Std_MsgSetParmCmplt) FAILED */

#define CONF_LOC_233	0x800233 /* CONF:
                     Conf_SetPtyParm_get FAILED */

#define CONF_LOC_234	0x800234 /* CONF:
                     qMsgAllocate(Conf_SetPtyParmCmplt) FAILED */
#define CONF_LOC_235	0x800235 /* CONF:
                     Conf_SetPtyParmCmplt_put FAILED */

#define CONF_LOC_236	0x800236 /* CONF:
                     qMsgWrite(Conf_SetPtyParmCmplt) FAILED for Conf_Party_Mode  (Mode is the same section)*/

#define CONF_LOC_237	0x800237 /* CONF:
                     qMsgWrite(Conf_SetPtyParmCmplt) FAILED for Conf_Party_Mode*/

#define CONF_LOC_238	0x800238 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Party_Mode*/

#define CONF_LOC_239	0x800239 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Rx_ID*/

#define CONF_LOC_240	0x800240 /* CONF:
                     qMsgWrite(Conf_SetPtyParmCmplt) FAILED for Conf_Rx_ID*/

#define CONF_LOC_241	0x800241 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Tx_ID*/

#define CONF_LOC_242	0x800242 /* CONF:
                     qMsgWrite(Conf_SetPtyParmCmplt) FAILED for Conf_Tx_ID*/

#define CONF_LOC_243	0x800243 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Echo_Cancel_En*/

#define CONF_LOC_244	0x800244 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Echo_Cancel_Sel*/

#define CONF_LOC_245	0x800245 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED for Conf_Party_Vol*/

#define CONF_LOC_246	0x800246 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED for Conf_Party_Vol*/

#define CONF_LOC_247	0x800247 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED for Conf_Party_Vol*/

#define CONF_LOC_248	0x800248 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED for Conf_Tariff_En*/

#define CONF_LOC_249	0x800249 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED for Conf_Tariff_En*/

#define CONF_LOC_250	0x800250 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED) for Conf_Tariff_En*/

#define CONF_LOC_251	0x800251 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED forConf_AGC_En */

#define CONF_LOC_252	0x800252 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED for Conf_AGC_En*/

#define CONF_LOC_253	0x800253 /*CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED for Conf_AGC_En*/

#define CONF_LOC_254	0x800254 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Broadcast */

#define CONF_LOC_255	0x800255 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED for Conf_Broadcast_En */

#define CONF_LOC_256	0x800256 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED for Conf_Broadcast_En*/

#define CONF_LOC_257	0x800257 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED  for Conf_Broadcast_En  */

#define CONF_LOC_258	0x800258 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Coach_En */

#define CONF_LOC_259	0x800259 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED for Conf_Coach_En */

#define CONF_LOC_260	0x800260 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED for Conf_Coach_En */

#define CONF_LOC_261	0x800261 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED  for Conf_Coach_En */

#define CONF_LOC_262	0x800262 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED for Conf_Pupil_En */

#define CONF_LOC_263	0x800263 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED for Conf_Pupil_En */

#define CONF_LOC_264	0x800264 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED for Conf_Pupil_En */

#define CONF_LOC_265	0x800265 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED  for Conf_Pupil_En */

#define CONF_LOC_266	0x800266 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED during unexpected message section           */

#define CONF_LOC_267	0x800267 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_268	0x800268 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED  */

#define CONF_LOC_269	0x800269 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED  */

#define CONF_LOC_270	0x800270 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_271	0x800271 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_272	0x800272 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_273	0x800273 /* CONF:
                     Std_MsgError_get FAILED  */

#define CONF_LOC_274	0x800274 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_275	0x800275 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_276	0x800276 /* CONF:
                     qMsgWrite(Conf_SetPtyParmCmplt) FAILED after receiving CSUM_MsgSetPartyParmCmplt*/

#define CONF_LOC_277	0x800277 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t) FAILED, size = %02d */

#define CONF_LOC_278	0x800278 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_279	0x800279 /* CONF:
                     qMsgWrite(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_280	0x800280 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t) FAILED, size = %02d */

#define CONF_LOC_281	0x800281 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_282	0x800282 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_283	0x800283 /* CONF:
                     qMsgAllocate(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_284	0x800284 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_285	0x800285 /* CONF:
                     qMsgFree(Conf_SetPtyParmCmplt) FAILED */

#define CONF_LOC_286	0x800286 /* CONF:
                     Conf_GetPtyParm_get FAILED */

#define CONF_LOC_287	0x800287 /* CONF:
                     qMsgAllocate(Conf_GetPtyParmCmplt) FAILED */

#define CONF_LOC_288	0x800288 /* CONF:
                     Conf_GetPtyParmCmplt_put FAILED */

#define CONF_LOC_289	0x800289 /* CONF:
                     qMsgWrite(Conf_GetPtyParmCmplt) FAILED */

#define CONF_LOC_290	0x800290 /* CONF:
                     qMsgAllocate(Std_MsgSetParmDefCmplt) FAILED */

#define CONF_LOC_291	0x800291 /* CONF:
                     qMsgWrite(Std_MsgSetParmDefCmplt) FAILED */

#define CONF_LOC_292	0x800292 /* CONF:
                     qMsgAllocate(Std_MsgSetAllParmsDefCmplt) FAILED */

#define CONF_LOC_293	0x800293 /* CONF:
                     qMsgWrite(Std_MsgSetAllParmsDefCmplt) FAILED */

#define CONF_LOC_294	0x800294 /* CONF:
                     Conf_SetPtyParm_get FAILED */

#define CONF_LOC_295	0x800295 /* CONF:
                     qMsgAllocate(CSUMS_MsgRemoveParty) FAILED for changing to NULL Party */

#define CONF_LOC_296	0x800296 /* CONF:
                     CSUMS_MsgRemoveParty_put FAILED for changing to NULL Party */

#define CONF_LOC_297	0x800297 /* CONF:
                     qMsgWrite(CSUMS_MsgRemoveParty) FAILED for changing to NULL Party */

#define CONF_LOC_298	0x800298 /* CONF:
                     qMsgAllocate( FEP_MsgStop) FAILED for changing to NULL Party */

#define CONF_LOC_299	0x800299 /* CONF:
                     qMsgWrite( FEP_MsgStop) FAILED for changing to NULL Party */

#define CONF_LOC_300	0x800300 /* CONF:
                     qMsgFree FAILED for changing for NULL Party */

#define CONF_LOC_301	0x800301 /* CONF:
                     qMsgAllocate(FEP_MsgStart) FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_302	0x800302 /* CONF:
                     FEP_MsgStart_put FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_303	0x800303 /* CONF:
                     qMsgWrite FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_304	0x800304 /* CONF:
                     qMsgAllocate(CSUMS_MsgAddParty) FAILED for changing to FULL DUPLEX Party  */

#define CONF_LOC_305	0x800305 /* CONF:
                     CSUMS_MsgAddParty_put FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_306	0x800306 /* CONF:
                     qMsgWrite(CSUMS_MsgAddParty) FAILED for changing to FULL DUPLEX Party  */

#define CONF_LOC_307	0x800307 /* CONF:
                     qMsgAllocate(CSUMS_MsgChangeModeParty) FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_308	0x800308 /* CONF:
                     CSUMS_MsgChangeModeParty_put FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_309	0x800309 /* CONF:
                     qMsgWrite(CSUMS_MsgChangeModeParty) FAILED for changing to FULL DUPLEX Party  */

#define CONF_LOC_310	0x800310 /* CONF:
                     qMsgFree FAILED for changing to FULL DUPLEX Party */

#define CONF_LOC_311	0x800311 /* CONF:
                     qMsgAllocate(FEP_MsgStart) FAILED for changing to XMIT ONLY */

#define CONF_LOC_312	0x800312 /* CONF:
                     FEP_MsgStart_put FAILED */

#define CONF_LOC_313	0x800313 /* CONF:
                     qMsgWrite(FEP_MsgStart) FAILED for changing to XMIT ONLY */

#define CONF_LOC_314	0x800314 /* CONF:
                     qMsgAllocate(CSUMS_MsgAddParty) for changing to XMIT ONLY */

#define CONF_LOC_315	0x800315 /* CONF:
                     CSUMS_MsgAddParty_put FAILED for changing to XMIT ONLY */

#define CONF_LOC_316	0x800316 /* CONF:
                     qMsgWrite (CSUMS_MsgAddParty) FAILED for changing to XMIT ONLY */

#define CONF_LOC_317	0x800317 /* CONF:
                     qMsgAllocate(CSUMS_MsgChangeModeParty) FAILED for changing to XMIT ONLY */

#define CONF_LOC_318	0x800318 /* CONF:
                     CSUMS_MsgChangeModeParty_put FAILED for changing to XMIT ONLY */

#define CONF_LOC_319	0x800319 /* CONF:
                     qMsgWrite(CSUMS_MsgChangeModeParty) FAILED for changing to XMIT ONLY */

#define CONF_LOC_320	0x800320 /* CONF:
                     qMsgFree FAILED for changing to XMIT ONLY   */

#define CONF_LOC_321	0x800321 /* CONF:
                     qMsgAllocate(FEP_MsgStop) FAILED for changing to RECV ONLY  */

#define CONF_LOC_322	0x800322 /* CONF:
                     qMsgWrite(FEP_MsgStop) FAILED for changing to RECV ONLY */

#define CONF_LOC_323	0x800323 /* CONF:
                     qMsgAllocate(CSUMS_MsgAddParty) FAILED for changing to RECV ONLY */

#define CONF_LOC_324	0x800324 /* CONF:
                     CSUMS_MsgAddParty_put FAILED for changing to RECV ONLY */

#define CONF_LOC_325	0x800325 /* CONF:
                     qMsgWrite(CSUMS_MsgAddParty) FAILED for changing to RECV ONLY */

#define CONF_LOC_326	0x800326 /* CONF:
                     qMsgAllocate(CSUMS_MsgChangeModeParty) FAILED for changing to RECV ONLY */

#define CONF_LOC_327	0x800327 /* CONF:
                     CSUMS_MsgChangeModeParty_put FAILED for changing to RECV ONLY */

#define CONF_LOC_328	0x800328 /* CONF:
                     qMsgWrite(CSUMS_MsgChangeModeParty) FAILED for changing to RECV ONLY */

#define CONF_LOC_329	0x800329 /* CONF:
                     qMsgFree FAILED */

#define CONF_LOC_330	0x800330 /* CONF:
                     Invalid new mode = %02d  at this stage */

#define CONF_LOC_331	0x800331 /* CONF:
                     qMsgAllocate(CSUMS_MsgAddParty) FAILED */

#define CONF_LOC_332	0x800332 /* CONF:
                     CSUMS_MsgAddParty_put FAILED */

#define CONF_LOC_333	0x800333 /* CONF:
                     qMsgWrite(CSUMS_MsgAddParty) FAILED */

#define CONF_LOC_334	0x800334 /* CONF:
                     qMsgAllocate(CSUMS_MsgChangeModeParty) FAILED */

#define CONF_LOC_335	0x800335 /* CONF:
                     CSUMS_MsgChangeModeParty_put FAILED */

#define CONF_LOC_336	0x800336 /* CONF:
                     qMsgWrite(CSUMS_MsgChangeModeParty) FAILED */

#define CONF_LOC_337	0x800337 /* CONF:
                     CSUMS_MsgAddPartyCmplt_get FAILED */

#define CONF_LOC_338	0x800338 /* CONF:
                     Std_MsgError_get FAILED */

#define CONF_LOC_339	0x800339 /* CONF:
                     qMsgAllocate(Std_MsgSetxParms) FAILED  */

#define CONF_LOC_340	0x800340 /* CONF: 
                     Std_MsgSetxParms_put FAILED*/

#define CONF_LOC_341	0x800341 /* CONF: 
                     Std_MsgSetxParms_List_put FAILED */

#define CONF_LOC_342	0x800342 /* CONF:
                     Std_MsgSetxParms_List_put FAILED */

#define CONF_LOC_343	0x800343 /* CONF: 
                     Std_MsgSetxParms_List_put FAILED */

#define CONF_LOC_344	0x800344 /* CONF:
                     qMsgWrite(Std_MsgSetxParms) To FEP FAILED */

#define CONF_LOC_345	0x800345 /* CONF:
                     CSUMS instance %02d DIED*/

#define CONF_LOC_346	0x800346 /* CONF:
                     Party Handle %02d: FEP instance %02d DIED */

#define CONF_LOC_347	0x800347 /* CONF:
                     Party Handle %02d: SCBUS instance %02d DIED */
 
#define CONF_LOC_348	0x800348 /* CONF:
                     Failure to qPoolFree party after QCompExited (CSUMS)*/

#define CONF_LOC_349	0x800349 /* CONF:
                     Failure to qPoolFree party after QCompExited (ScBus) */

#define CONF_LOC_350	0x800350 /* CONF:
                     confAllocEvtStatusPool(Conf_EvtStatusChanged_PtyDiff_t)FAILED, size = %02d */

#define CONF_LOC_351	0x800351 /* CONF:
                     qMsgAllocate(Std_MsgEvtDetected) FAILED */

#define CONF_LOC_352	0x800352 /* CONF: 
                     Conf_EvtStatusChanged_put FAILED */

#define CONF_LOC_353	0x800353 /* CONF:
                     qMsgWrite(Std_MsgEvtDetected) FAILED) */

#define CONF_LOC_354	0x800354 /* CONF:
                     qPoolFree(Conf_EvtStatusChanged_PtyDiff_t) FAILED */

#define CONF_LOC_355	0x800355 /* CONF: 
                     qMsgWrite(Conf_SetPartyParm) broadcast FAILED */

#define CONF_LOC_356	0x800356 /* CONF: 
                     qMsgWrite(Conf_SetPartyParm) Coach FAILED */

#define CONF_LOC_357	0x800357 /* CONF: 
                     qMsgWrite(Conf_SetPartyParm) Pupil FAILED */

#define CONF_LOC_358	0x800358 /* CONF: 
                     Conf_GetxPtyParm_get FAILED */

#define CONF_LOC_359	0x800359 /* CONF: 
                     qMsgAllocate(Conf_GetxPtyParmCmplt) FAILED */

#define CONF_LOC_360	0x800360 /* CONF: 
                     Conf_GetxPtyParmCmplt_put FAILED */

#define CONF_LOC_361	0x800361 /* CONF:
                     Conf_GetxPtyParm_Pty_get FAILED */

#define CONF_LOC_362	0x800362 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_363	0x800363 /* CONF:
                     qMsgFree(Conf_GetxPtyParmCmplt) FAILED */

#define CONF_LOC_364	0x800364 /* CONF:
                     qMsgWrite(Conf_GetxPtyParmCmplt) FAILED */

#define CONF_LOC_365	0x800365 /* CONF:
                     Std_MsgGetxParms_get FAILED */

#define CONF_LOC_366	0x800366 /* CONF:
                     qMsgAllocate(Std_MsgGetxParmsCmplt) FAILED */

#define CONF_LOC_367	0x800367 /* CONF:
                     Std_MsgGetxParmsCmplt_put FAILED */

#define CONF_LOC_368	0x800368 /* CONF:
                     Std_MsgGetxParms_List_get FAILED */

#define CONF_LOC_369	0x800369 /* CONF:
                     qMsgFree(Std_MsgGetxParmsCmplt) FAILED */

#define CONF_LOC_370	0x800370 /* CONF:
                     Std_MsgGetxParmsCmplt_List_put FAILED */


#define CONF_LOC_371	0x800371 /* CONF:
                     qMsgWrite(Std_MsgGetxParmsCmplt) FAILED */

#define CONF_LOC_372	0x800372 /* CONF:
                     Std_MsgSetxParms_get FAILED */

#define CONF_LOC_373	0x800373 /* CONF:
                     Std_MsgSetxParms_List_get FAILED */

#define CONF_LOC_374	0x800374 /* CONF:
                     Std_MsgSetxParms_List_get FAILED */

#define CONF_LOC_375	0x800375 /* CONF:
                     qMsgAllocate(Std_MsgSetxParmsCmplt) FAILED */

#define CONF_LOC_376	0x800376 /* CONF:
                     qMsgWrite(Std_MsgSetxParmsCmplt) FAILED */

#define CONF_LOC_377	0x800377 /* CONF:
                     qMsgFree(Std_GetxParmsCmplt) FAILED  */

#define CONF_LOC_378	0x800378 /* CONF:
                     qMsgFree(Std_GetxParmsCmplt) FAILED  */

#define CONF_LOC_379	0x800379 /* CONF:
                     Conf_GetxPtyParm_get FAILED */

#define CONF_LOC_380	0x800380 /* CONF:
                     qMsgAllocate(Conf_GetxPtyParmCmplt) FAILED */

#define CONF_LOC_381	0x800381 /* CONF:
                     Conf_GetxPtyParmCmplt_put FAILED */

#define CONF_LOC_382	0x800382 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_383	0x800383 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_384	0x800384 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_385	0x800385 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_386	0x800386 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_387	0x800387 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_388	0x800388 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_389	0x800389 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_390	0x800390 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_391	0x800391 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_392	0x800392 /* CONF:
                     Conf_GetxPtyParmCmplt_Pty_put FAILED */

#define CONF_LOC_393	0x800393 /* CONF:
                     qMsgWrite(Conf_GetxPtyParmCmplt) FAILED */

#define CONF_LOC_394	0x800394 /* CONF:
                     qMsgFree(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_395	0x800395 /* CONF: 
                     qMsgFree(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_396	0x800396 /* CONF:
                     qMsgFree(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_397	0x800397 /* CONF:
                     qMsgFree(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_398	0x800398 /* CONF:
                     qMsgFree(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_399	0x800399 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED*/

#define CONF_LOC_400	0x800400 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED*/

#define CONF_LOC_401	0x800401 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED*/

#define CONF_LOC_402	0x800402 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_403	0x800403 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED */

#define CONF_LOC_404	0x800404 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_405	0x800405 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_406	0x800406 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED */

#define CONF_LOC_407	0x800407 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_408	0x800408 /* CONF:
                     qMsgFree FAILED */

#define CONF_LOC_409	0x800409 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_410	0x800410 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED */

#define CONF_LOC_411	0x800411 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_412	0x800412 /* CONF:
                     qMsgFree FAILED */

#define CONF_LOC_413	0x800413 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_414	0x800414 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED */

#define CONF_LOC_415	0x800415 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_416	0x800416 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_417	0x800417 /* CONF:
                     CSUMS_MsgSetPartyParm_put FAILED */

#define CONF_LOC_418	0x800418 /* CONF:
                     qMsgWrite(CSUMS_MsgSetPartyParm) FAILED */

#define CONF_LOC_419	0x800419 /* CONF:
                     qMsgFree FAILED */

#define CONF_LOC_420	0x800420 /* CONF:
                     Conf_SetxPtyParms_get FAILED */

#define CONF_LOC_421	0x800421 /* CONF:
                     Conf_SetxPtyParms_Pty_get FAILED */

#define CONF_LOC_422	0x800422 /* CONF:
                     qMsgAllocate(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_423	0x800423 /* CONF:
                     qMsgWrite(Conf_SetxPtyParmsCmplt) FAILED */

#define CONF_LOC_424	0x800424 /* CONF:
                     qMsgWrite(Conf_SetPtyParmsCmplt) FAILED */

#define CONF_LOC_425	0x800425 /* CONF:
                     CSUMS_MsgSetPartyParmCmplt_get FAILED */

#define CONF_LOC_426	0x800426 /* CONF:
                     CSUMS_MsgChangeModePartyCmplt_get FAILED */

#define CONF_LOC_427	0x800427 /* CONF:
                     Conf_DetectxEvts_get failed  */

#define CONF_LOC_428	0x800428 /* CONF:
                     Conf_DetectxEvts_List_get failed */

#define CONF_LOC_429	0x800429 /* CONF:
                     Conf_CancelxEvts_get failed */

#define CONF_LOC_430	0x800430 /* CONF:
                     Conf_CancelxEvts_List_get failed */

#define CONF_LOC_431	0x800431 /* CONF:
                     Conf_DetectxEvts_get failed */

#define CONF_LOC_432	0x800432 /* CONF:
				         Conf_DetectxEvts_List_get failed*/

#define CONF_LOC_433	0x800433 /* CONF:
				         qMsgAllocate(Std_MsgDetectxEvtsCmplt) failed*/

#define CONF_LOC_434	0x800434 /* CONF:
				         qMsgWrite(Std_MsgDetectxEvtsCmplt) failed*/

#define CONF_LOC_435	0x800435 /* CONF:
				         Conf_CancelxEvts_get failed*/

#define CONF_LOC_436	0x800436 /* CONF:
				         Conf_CancelxEvts_List_get failed*/

#define CONF_LOC_437	0x800437 /* CONF:
				         qMsgAllocate(Std_MsgCancelxEvtsCmplt) failed*/

#define CONF_LOC_438	0x800438 /* CONF:
				         qMsgWrite(Std_MsgCancelxEvtsCmplt) failed*/

#define CONF_LOC_439	0x800439 /* CONF:
				         Std_MsgSetxParms_List_put failed*/

#define CONF_LOC_440	0x800440 /* CONF:
				         qMsgWrite(Std_MsgSetxParms) failed*/

#define CONF_LOC_441	0x800441 /* CONF:
				         Conf_DetectEvt_get failed*/

#define CONF_LOC_442	0x800442 /* CONF:
				         Conf_DetectxEvts_get failed*/

#define CONF_LOC_443	0x800443 /* CONF:
				         Conf_DetectxEvts_List_get failed*/

#define CONF_LOC_444	0x800444 /* CONF:
				         qMsgAllocate(Std_MsgDetectxEvtsCmplt) failed*/

#define CONF_LOC_445	0x800445 /* CONF:
				         Conf_CancelEvt_get failed */

#define CONF_LOC_446	0x800446 /* CONF:
				         Conf_CancelxEvts_get failed */

#define CONF_LOC_447	0x800447 /* CONF:
				         Conf_CancelxEvts_List_get failed */

#define CONF_LOC_448	0x800448 /* CONF:
				         Std_MsgCancelxEvtsCmplt failed */

#define CONF_LOC_449	0x800449 /* CONF:
				         Conf_DetectxEvts_get failed*/

#define CONF_LOC_450	0x800450 /* CONF:
				         Conf_DetectxEvts_List_get failed*/

#define CONF_LOC_451	0x800451 /* CONF:
				         Conf_DetectxEvts_List_get failed*/

#define CONF_LOC_452	0x800452 /* CONF:
				         Conf_CancelxEvts_get failed */

#define CONF_LOC_453	0x800453 /* CONF:
				         Conf_CancelxEvts_List_get failed */

#define CONF_LOC_454	0x800454 /* CONF:
				         Conf_CancelxEvts_List_get failed */

#define CONF_LOC_455	0x800455 /* CONF:
				         FEP_MsgDTMFDigit_get failed */

#define CONF_LOC_456	0x800456 /* CONF:
				         qMsgAllocate(Std_MsgEvtDetected) failed*/

#define CONF_LOC_457	0x800457 /* CONF:
				         Conf_EvtDTMFDetection_put failed*/

#define CONF_LOC_458	0x800458 /* CONF:
                     qMsgWrite(Conf_EvtDTMFDetection) failed*/

#define CONF_LOC_459	0x800459 /* CONF:
                     qMsgWrite(Std_MsgEvtDetected) failed*/

#define CONF_LOC_460	0x800460 /* CONF:
				         qMsgFree(Std_MsgEvtDetected) failed */

#define CONF_LOC_461	0x800461 /* CONF:
                     Conf_MsgSetVolDtmf_get failed */

#define CONF_LOC_462	0x800462 /* CONF:
                     qMsgAllocate(Conf_MsgSetVolDtmfCmplt) failed */

#define CONF_LOC_463	0x800463 /* CONF:
                     qMsgWrite(Conf_MsgSetVolDtmfCmplt) failed	*/

#define CONF_LOC_464	0x800464 /* CONF:
                     qMsgAllocate(Conf_MsgGetVolDtmfCmplt) failed */

#define CONF_LOC_465	0x800465 /* CONF:
                     qMsgwrite(Conf_MsgGetVolDTMFCmplt_put) failed */

#define CONF_LOC_466	0x800466 /* CONF:
                     qMsgWrite(Conf_MsgGetVolDtmfCmplt) failed */

#define CONF_LOC_467	0x800467 /* CONF:
                     FEP_MsgDTMFDigit_get failed */

#define CONF_LOC_468	0x800468 /* CONF:
                     qMsgAllocate(CSUMS_MsgSetPartyParm) failed */

#define CONF_LOC_469	0x800469 /* CONF:
                     CSUMS_MsgSetPartyParm_put failed */

#define CONF_LOC_470	0x800470 /* CONF:
                     qMsgWrite(csumSetPtyParmMsg) failed */

#define CONF_LOC_471	0x800471 /* CONF:
                     */

#define CONF_LOC_472	0x800472 /* CONF:
				    */

#define CONF_LOC_473	0x800473 /* CONF:
                     qMsgAllocate(Std_MsgSetxParms) FAILED  */            
				    
#define CONF_LOC_474	0x800474 /* CONF:
                     Std_MsgSetxParms_put FAILED */

#define CONF_LOC_475	0x800475 /* CONF:
                     Std_MsgSetxParms_List_put FAILED
                     */

#define CONF_LOC_476	0x800476 /* CONF:
                     Std_MsgSetxParms_List_put FAILED
                     */

#define CONF_LOC_477	0x800477 /* CONF:
                     Std_MsgSetxParms_List_put FAILED
                     */

#define CONF_LOC_478	0x800478 /* CONF:
                     Std_MsgSetxParms_List_put FAILED
                     */

#define CONF_LOC_479	0x800479 /* CONF:
                     Std_MsgSetxParms_List_put FAILED
                     */

#define CONF_LOC_480	0x800480 /* CONF:
                      Std_MsgSetxParms_List_put FAILED
                     */

#define CONF_LOC_481	0x800481 /* CONF:
                     qMsgWrite(Std_MsgSetxParms) FAILED
                     */

#define CONF_LOC_482	0x800482 /* CONF:
                     qMsgAllocate(Conf_DeleteAllConfsCmplt) failed  */

#define CONF_LOC_483	0x800483 /* CONF:
				    */

#define CONF_LOC_484	0x800484 /* CONF:
				    */

#define CONF_LOC_485	0x800485 /* CONF:
				    */

#define CONF_LOC_486	0x800486 /* CONF:
				    */

#define CONF_LOC_487	0x800487 /* CONF:
				    */

#define CONF_LOC_488	0x800488 /* CONF:
				    */

#define CONF_LOC_489	0x800489 /* CONF:
				    */

#define CONF_LOC_490	0x800490 /* CONF:
				    */

#define CONF_LOC_491	0x800491 /* CONF:
				    */

#define CONF_LOC_492	0x800492 /* CONF:
				    */

#define CONF_LOC_493	0x800493 /* CONF:
				    */

#define CONF_LOC_494	0x800494 /* CONF:
				    */

#define CONF_LOC_495	0x800495 /* CONF:
				    */

#define CONF_LOC_496	0x800496 /* CONF:
				    */

#define CONF_LOC_497	0x800497 /* CONF:
				    */

#define CONF_LOC_498	0x800498 /* CONF:
				    */

#define CONF_LOC_499	0x800499 /* CONF:
				    */



#endif

