/******************************************************************************
 *     Copyright(c) 1999, '98, '96 Dialogic Corp.
 *     All Rights Reserved.
 *
 *     THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *     The copyright notice above does not evidence any actual or
 *     intended publication of such source code.
 ******************************************************************************/

/******************************************************************************
 **
 *	File:	convdesc.h
 **
 *	Author:
 *		B.Kish  May23/96
 **
 *	Purpose:
 *		This file contains the definition of the supported conversion data types.
 *		Two Media Types are associated with the conversion descriptor, an input
 *		type and an output type.
 **
 *	Notes:
 **
 *	Last Revised:
 *		$Id: convdesc.h,v 1.2 2000/11/10 22:36:52 leev Exp $
 **
 ******************************************************************************/

#ifndef __CONVDESC_H__
#define __CONVDESC_H__

/*
 *	Define the valid Media Types.		
 */
typedef enum
{
	ASCII,			/* 0 */
	RASTER,			/* 1 */
	TIFF,			/* 2 */
	SUN__TYPE,		/* 3 */
	RUN_LENGTH,		/* 4 */
	MH,			/* 5 */
	MR,			/* 6 */
	MMR,			/* 7 */
	U_LIB,			/* 8 */
	RES_RUN_LENGTH		/* 9 */ 
} MediaType; 


/*
 *	The Conversion is defined as type IN and type OUT.
 */

typedef struct
{
  MediaType in;          /* The image processor's input type */
  MediaType out;         /* The image processor's output type */
} ConversionDesc;


/*
 *	This structure allows supplemental system conversion
 *	attributes to make their way into the converters.
 */

typedef struct
{
	boolean	full_convert;	/* Default: True.  If not full, then not all image
							   libraries are used in DLL.  e.g. MMR-to-MMR. */
} SysConvAttrs;



#endif
