/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007-2014 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef __DEVMGMTLIB_H__
#define __DEVMGMTLIB_H__

#include <srllib.h>
#include <string.h>

#include "LicensedFeatures.h"
#if ((!defined EV_ASYNC) && (!defined(EV_SYNC)))
#define EV_ASYNC              0x8000
#define EV_SYNC               0x0000
#endif

#define DEV_MAXMSGSIZE 80                // Maximum size of info message string
#define DEV_MAXERRMSGSIZE DEV_MAXMSGSIZE // Maximum size of error message string

typedef enum {
	BRD_SUCCESS = 0,
	EBRD_FAILEDOPENINGDTILIB,
	EBRD_DEVICEMAPPERFAILED,
	EBRD_INVALIDPHYSICALNAME,
	EBRD_INVALIDVIRTUALNAME,
	EBRD_BUFFERTOOSMALL,
	EBRD_OUTOFMEMORY,
	EBRD_NULLPOINTERARGUMENT,
	EBRD_COMMANDNOTSUPPORTED,
	EBRD_INVALIDDEVICEHANDLE,
	EBRD_INVALIDINTERVAL,
	EBRD_INVALIDTHRESHOLD,
	EBRD_SENDALIVENOTENABLED,
	EBRD_NOTIMP,
	EBRD_IPMCONNECT_FAILED,
	EBRD_DEVBUSY,
	EBRD_INVALIDCONNTYPE,
	EBRD_IPMDISCONNECT_FAILED,
	EBRD_MAX
} T_BRDERRORVALUE;

typedef enum {
	DEV_SUCCESS = 0,
	EDEV_INVALIDDEVICEHANDLE,
	EDEV_INVALIDMODE,
	EDEV_EVENTTIMEOUT,
	EDEV_DEVICEBUSY,
	EDEV_INVALIDCONNTYPE,
	EDEV_IPM_SUBSYSTEMERR,
	EDEV_FAX_SUBSYSTEMERR,
	EDEV_IPM_INTERNALERR,
	EDEV_MM_SUBSYSTEMERR,
	EDEV_SUBSYSTEMERR,
	EDEV_INVALIDSTATE,
	EDEV_NOTCONNECTED,
    EDEV_INVALID_PARM,
	EDEV_MAX
} DEV_ERRORVALUE;

typedef struct errinfo {
	int dev_ErrValue;
	int dev_SubSystemErrValue;
	char dev_Msg[DEV_MAXERRMSGSIZE];
} DEV_ERRINFO;

typedef enum {
    DM_EVENT_CODE_SUCCESS = 0,
    DM_EVENT_CODE_INVALID_DEVICE_HANDLE,
    DM_EVENT_CODE_DX_SUBSYSTEMERR,
    DM_EVENT_CODE_IPM_SUBSYSTEMERR,
    DM_EVENT_CODE_CNF_SUBSYSTEMERR,
    DM_EVENT_CODE_M3G_SUBSYSTEMERR,
    DM_EVENT_CODE_MM_SUBSYSTEMERR,
    DM_EVENT_CODE_DTI_SUBSYSTEMERR,
    DM_EVENT_CODE_T38_SUBSYSTEMERR,
    DM_EVENT_CODE_SUBSYSTEMERR,
    DM_EVENT_CODE_INVALIDSTATE,
    DM_EVENT_CODE_NOTCONNECTED,
    DM_EVENT_CODE_MAX
} DM_EVENT_CODE;

typedef struct dmeventinfo{
    unsigned int    unVersion;
    int             nValue;
    int             nSubSystemValue;
    char            szMsg[DEV_MAXMSGSIZE];
    char            szSubSystemMsg[DEV_MAXMSGSIZE];
    char            szAdditionalInfo[DEV_MAXMSGSIZE];
} DM_EVENT_INFO, *PDM_EVENT_INFO;
typedef const DM_EVENT_INFO* CPDM_EVENT_INFO;

#define DM_EVENT_INFO_VER(v) (sizeof(DM_EVENT_INFO) << 16 | (0xFFFF & (v)))
#define DM_EVENT_INFO_VERSION_0 DM_EVENT_INFO_VER(0)
#define DM_EVENT_INFO_VERSION DM_EVENT_INFO_VERSION_0

static __inline void INIT_DM_EVENT_INFO(PDM_EVENT_INFO pStruct){
    pStruct->unVersion        = DM_EVENT_INFO_VERSION;
    pStruct->nValue           = 0;
    pStruct->nSubSystemValue = 0;
    memset((void*)(pStruct->szMsg), 0, DEV_MAXMSGSIZE);
    memset((void*)(pStruct->szSubSystemMsg), 0, DEV_MAXMSGSIZE);
    memset((void*)(pStruct->szAdditionalInfo), 0, DEV_MAXMSGSIZE);
}

typedef enum {
	DM_FULLDUP = 1,
	DM_HALFDUP
} eCONN_TYPE;

typedef enum {
	RESOURCE_TYPE_NONE,
	RESOURCE_IPM_LBR,
	RESOURCE_IPM_ALL_AUDIO_CODERS,
	RESOURCE_IPM_G711_40MS,
	RESOURCE_IPM_G711_30MS,
	RESOURCE_IPM_G711_20MS,
	RESOURCE_IPM_G711_10MS,
	RESOURCE_IPM_G723,
	RESOURCE_IPM_G726,
	RESOURCE_IPM_G729,
	RESOURCE_IPM_AMR_NB,
	RESOURCE_IPM_EVRC,
	RESOURCE_IPM_GSM_EFR,
	RESOURCE_IPM_ILBC,
	RESOURCE_IPM_QCELP,
	RESOURCE_IPM_SMV,
	RESOURCE_IPM_AMR_WB,
	RESOURCE_IPM_G729E,
	RESOURCE_MM_VIDEO_NATIVE,
	RESOURCE_IPM_G722,
	RESOURCE_IPM_OPUS,
	RESOURCE_IPM_GSM_FR,
	RESOURCE_TYPE_MAX
} eDEV_RESOURCE_TYPE;

#define MAX_CODER_RESOURCE_TYPE 64

typedef struct resourcelist {
	unsigned int version; // struct version
	int count; // number of items filled in rsList
	eDEV_RESOURCE_TYPE rsList[MAX_CODER_RESOURCE_TYPE];
} DEV_RESOURCE_LIST, *PDEV_RESOURCE_LIST;
typedef const DEV_RESOURCE_LIST* CPDEV_RESOURCE_LIST;

#define DEV_RESOURCE_LIST_VER(v) \
	((sizeof(DEV_RESOURCE_LIST) << 16) | (0xFFFF & (v)))

#define DEV_RESOURCE_LIST_VERSION_0  DEV_RESOURCE_LIST_VER(0)
#define DEV_RESOURCE_LIST_VERSION  DEV_RESOURCE_LIST_VERSION_0

static __inline void INIT_DEV_RESOURCE_LIST(PDEV_RESOURCE_LIST pStruct) {
	pStruct->version              = DEV_RESOURCE_LIST_VERSION;
	pStruct->count = 0;
}

typedef struct resourceInfo {
	eDEV_RESOURCE_TYPE resourceType; // resource type
	int curReserveCount; // current number of resourceType reserved for device
	int availableResourceCount; // number of resourceType available in pool
} ResourceInfo;

typedef struct getresourceinfoEx {
	unsigned int version; // struct version
	int count; // number of items filled in rsInfo
	ResourceInfo rsInfo[MAX_CODER_RESOURCE_TYPE];
} DEV_RESOURCE_RESERVATIONINFO_EX, *PDEV_RESOURCE_RESERVATIONINFO_EX;
typedef const DEV_RESOURCE_RESERVATIONINFO_EX* CPDEV_RESOURCE_RESERVATIONINFO_EX;

#define DEV_RESOURCE_RESERVATIONINFO_EX_VER(v) \
	((sizeof(DEV_RESOURCE_RESERVATIONINFO_EX) << 16) | (0xFFFF & (v)))

#define DEV_RESOURCE_RESERVATIONINFO_EX_VERSION_0  DEV_RESOURCE_RESERVATIONINFO_EX_VER(0)
#define DEV_RESOURCE_RESERVATIONINFO_EX_VERSION  DEV_RESOURCE_RESERVATIONINFO_EX_VERSION_0

static __inline void INIT_DEV_RESOURCE_RESERVATIONINFO_EX(PDEV_RESOURCE_RESERVATIONINFO_EX pStruct) {
	pStruct->version              = DEV_RESOURCE_RESERVATIONINFO_EX_VERSION;
	pStruct->count = 0;
}

typedef struct getresourceinfo {
	unsigned int        version;              // struct version
	eDEV_RESOURCE_TYPE  resourceType;         // Resource Type
	int                 curReserveCount;      // reservation count for dev
	int                 curReservePoolCount;  // current reserve pool count
	int                 maxReservePoolCount;  // max available pool count
} DEV_RESOURCE_RESERVATIONINFO, *PDEV_RESOURCE_RESERVATIONINFO;
typedef const DEV_RESOURCE_RESERVATIONINFO* CPDEV_RESOURCE_RESERVATIONINFO;

#define DEV_RESOURCE_RESERVATIONINFO_VER(v) \
	((sizeof(DEV_RESOURCE_RESERVATIONINFO) << 16) | (0xFFFF & (v)))

#define DEV_RESOURCE_RESERVATIONINFO_VERSION_0  DEV_RESOURCE_RESERVATIONINFO_VER(0)
#define DEV_RESOURCE_RESERVATIONINFO_VERSION  DEV_RESOURCE_RESERVATIONINFO_VERSION_0

static __inline void INIT_DEV_RESOURCE_RESERVATIONINFO(PDEV_RESOURCE_RESERVATIONINFO pStruct) {
	pStruct->version              = DEV_RESOURCE_RESERVATIONINFO_VERSION;
	pStruct->resourceType = RESOURCE_TYPE_NONE;
	pStruct->curReserveCount = 0;
	pStruct->curReservePoolCount = 0;
	pStruct->maxReservePoolCount = 0;
}


#define BRD_FAILURE -1
#define DM3_TYPE    0x81

// dev_Connect events
#define DMEV_MASK                              0x9E00          // DML events start at 0x9E00
#define DMEV_CONNECT                           (DMEV_MASK | 0x01)
#define DMEV_CONNECT_FAIL                      (DMEV_MASK | 0x02)
#define DMEV_DISCONNECT                        (DMEV_MASK | 0x03)
#define DMEV_DISCONNECT_FAIL                   (DMEV_MASK | 0x04)
#define DMEV_RESERVE_RESOURCE                  (DMEV_MASK | 0x05)
#define DMEV_RESERVE_RESOURCE_FAIL             (DMEV_MASK | 0x06)
#define DMEV_RELEASE_RESOURCE                  (DMEV_MASK | 0x07)
#define DMEV_RELEASE_RESOURCE_FAIL             (DMEV_MASK | 0x08)
#define DMEV_GET_RESOURCE_RESERVATIONINFO      (DMEV_MASK | 0x09)
#define DMEV_GET_RESOURCE_RESERVATIONINFO_FAIL (DMEV_MASK | 0x0A)

/* FlexLM license info retrieval defines and data structures */

#define MAX_FEATURES      256 /* Max features licensed */
#define LICENSED_FEATURES_VERSION 0x000  /* License Structure version */

typedef struct
{
    LicenseFeatureEnum FeatureEnum;       /* Licensed Feature Enum        */
    unsigned short     FeatureCount;      /* Licensed Feature Total Count */
    unsigned short     rfu;               /* For future use               */
}LIC_FEATURE_DATA;

/*
    Data structure used to return block of flexlm licensed features info.
*/
typedef struct
{
    unsigned long       version;        /* Licensing structure version */
    unsigned int        NumFeatures;    /* Number of features info returned. */
    LIC_FEATURE_DATA    lic_data_buf[MAX_FEATURES];/* License data buffer    */
}LIC_FEATURE_BLK, *PLIC_FEATURE_BLK;


static __inline void INIT_LICENSED_FEATURES_VERSION(PLIC_FEATURE_BLK plic_data)
{
   plic_data->NumFeatures = 0;
   plic_data->version = LICENSED_FEATURES_VERSION;
} 
#ifdef _WIN32

#ifdef LIBDM3DEVMGMT_EXPORTS
#define DEVMGMTLIB_API __declspec( dllexport )
#else
#define DEVMGMTLIB_API __declspec( dllimport )
#endif
#define DEVMGMT_CONV __cdecl

#else /* !_WIN32 */

#define DEVMGMTLIB_API extern
#define DEVMGMT_CONV

#endif /* _WIN32 */

#ifdef __cplusplus
extern "C" {
#endif

DEVMGMTLIB_API int DEVMGMT_CONV brd_Open(char *physical, long mode);
DEVMGMTLIB_API int DEVMGMT_CONV brd_VirtualToPhysicalName(char *virt, char *physical, int *len);
DEVMGMTLIB_API int DEVMGMT_CONV brd_SendAlive(int ddd, long mode);
DEVMGMTLIB_API int DEVMGMT_CONV brd_SendAliveEnable(int ddd, unsigned short interval, unsigned short threshold, long mode);
DEVMGMTLIB_API int DEVMGMT_CONV brd_SendAliveDisable(int ddd, long mode);
DEVMGMTLIB_API int DEVMGMT_CONV brd_GetAllPhysicalBoards(SRLDEVICEINFO *physicalDevs, int *count);
DEVMGMTLIB_API int DEVMGMT_CONV brd_Close(int ddd);
DEVMGMTLIB_API int DEVMGMT_CONV brd_ErrorValue( void );
DEVMGMTLIB_API char* DEVMGMT_CONV brd_ErrorMsg( void );
DEVMGMTLIB_API int DEVMGMT_CONV dev_ErrorInfo(DEV_ERRINFO *pErrInfo);
DEVMGMTLIB_API int DEVMGMT_CONV dev_Connect(int devHandle1, int devHandle2, eCONN_TYPE connType, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_Disconnect(int devHandle, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_ReserveResourceEx (int devHandle, DEV_RESOURCE_LIST *pResourceList, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_ReleaseResourceEx (int devHandle, DEV_RESOURCE_LIST *pResourceList, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_GetResourceReservationInfoEx(int devHandle, DEV_RESOURCE_RESERVATIONINFO_EX *pResourceInfo, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_ReserveResource(int devHandle, eDEV_RESOURCE_TYPE resType, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_ReleaseResource(int devHandle, eDEV_RESOURCE_TYPE resType, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_GetResourceReservationInfo(int devHandle, DEV_RESOURCE_RESERVATIONINFO *resInfo, unsigned short mode);
DEVMGMTLIB_API int DEVMGMT_CONV dev_GetLicFeatureData(PLIC_FEATURE_BLK plic_data);
DEVMGMTLIB_API int DEVMGMT_CONV dev_GetResultInfo(int devHandle, unsigned long eventType, void* pEventData, PDM_EVENT_INFO pEventInfo);
#ifdef __cplusplus
}
#endif

#endif /* __DEVMGMTLIB_H__ */
