#ifndef _DLMISC_H__
#define _DLMISC_H__
#include <sdsignal.h>

/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Chris Chuba
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    27-Mar-96 at 15:01:00
 * LAST-MOD:     Thu Aug 29 11:32:17 2002 by Amin Rhemtulla
 * PURPOSE:
 *    This module defines various signal id's relevant to Dialogic specific
 *    technology.
 *    
 * HISTORY:
 * Date        Who   Description
 * 29-Aug-02   AR    (TASK-15524:PT27713)
 *                   Added the definition SILENCE_DEB
 ***************************************************************************/

/*
 * The following beep defines are used for pre-record beep generation
 */
enum {
   BEEP_SET=SD_BEEP_START,
   BEEP_DGSD,                    /* 444hz tone */
   BEEP_DLGC                     /*1000hz tone */
};

/*
 * The following are disconnect supervision tones
 */
enum {
   DISCONNECT_SET=SD_DISCONNECT_START,
   Dm3_DISCONNECT                       /* disconnect tone */
};


/*
 * The following silence defines are used for detection of silence on 
 * intervals of various lengths generally used as a terminating condition
 * for record.
 */
enum {
   SILENCE_SET=SD_SILENCE_START,
   SILENCE_ON,                   /*10 sec continous silence */
   SILENCE_1,                    /* 1 sec. */
   SILENCE_2,                    /* 2 sec. */
   SILENCE_3,                    /* 3 sec. */
   SILENCE_5,                    /* 5 sec. */
   SILENCE_8,                    /* 8 sec. */
   SILENCE_15,                   /*15 sec. */
   SILENCE_30,                   /*30 sec. */
   SILENCE_DEB                   /*Silence Debounce: TASK-15524:PT27713 DE_SILON,DE_SILOFF R4 events support*/
};

/*
 * The following are various defines specific to the Sonoma project.
 */
enum {
   XX_DGSD_SET=SD_DGSD_START,
   XX_400HzSTONE,
   XX_444HzSTONE,
   XX_533HzSTONE,
   XX_880HzSTONE,
   XX_1320HzSTONE,
   XX_1KHzSTONE
};
#endif
