/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2000-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef __CSPLIB_H__
#define __CSPLIB_H__

/*
 * General Definitions
 */
#define VER_CSPLIB 0x1

/* Event mask id (internal) */
#define DE_CONVERGED	22	/* EC converged */

/* Event mask values */
#define DM_CONVERGED	( 1 << (DE_CONVERGED - 1) )


/*
 * Library parameters
 */
#define ECCH_XFERBUFFERSIZE	((PM_SHORT|PM_LIB|PM_DXXX|PM_CH) | 0x0005L)

#define ECCH_SILENCECOMPRESS	((PM_SHORT|PM_LIB|PM_DXXX|PM_CH) | 0x0013L)
#define ECCH_TRAILINGSILENCE	((PM_SHORT|PM_LIB|PM_DXXX|PM_CH) | 0x0014L)
#define ECCH_INITIALDATA	((PM_SHORT|PM_LIB|PM_DXXX|PM_CH) | 0x0015L)

/*
 * Firmware parameters
 */
#define ECCH_NLP		((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | 0x021CL)

#define ECCH_ADAPTMODE		((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | 0x021EL)
#define ECCH_VADINITIATED	((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | 0x021FL)

#define ECCH_ECHOCANCELLER	((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | 0x0220L)

#define ECCH_SVAD		((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | 0x0225L)
#define ECCH_CONVERGE        	((PM_SHORT|PM_FW  |PM_DXXX|PM_CH)  | 0x0226L)

#define DXCH_BARGEIN		((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | 0x021DL)
#define DXCH_SPEECHTRIGG	DXCH_SPEECHPLAYTRIGG
#define DXCH_SPEECHWINDOW	DXCH_SPEECHPLAYWINDOW


/* 
 * Events returned to the application 
 */
#define TEC_STREAM		0xE0 /* ec_stream() termination event */
#define TEC_VAD			0xE1 /* VAD energy detection event */
#define TEC_CONVERGED		0xE2 /* echo canceller converged event */
#define TEC_RESET		    0xE3
#define TEC_RESETERR	    0xE4


// 03/27/07 Use this base for all fax event codes going forward: 0x3B00
#define CSPEV_BASE		0x3B00			// Beginning base value
#define CSPEV_LAST_EVENT	(CSPEV_BASE | 0xFF)	// Last event


/* 
 *  Library error codes for ATDV_LASTERR()
 */
#define EEC_UNSUPPORTED		EDX_BADPROD /* function not supported */


/*
 * Stop codes for ec_stopch()
 */
#define SENDING			0x1
#define RECEIVING		0x2
#define FULLDUPLEX		(SENDING|RECEIVING)

typedef enum
{
   EC_INITIAL_BLK,	/* Block with the initial data
   			   (for ASR engine adjustments) [optional] */
   EC_SPEECH_BLK,	/* Block with speech */
   EC_SPEECH_LAST_BLK	/* Last block of speech before silence.
   			   The block size could be 0 in which case it
			   indicates that silence is being compressed */
} EC_BlockType;

typedef enum
{
   EC_LAST_BLK = 0x1	/* Last block of speech streamed */
} EC_BlockFlags;

typedef struct _EC_BLK_INFO
{
   EC_BlockType type;	/* see EC_BlockType */
   unsigned int flags;	/* see EC_BlockFlags */
   unsigned int size;
   unsigned long timestamp;
} EC_BLK_INFO;


/*
 * Function prototypes
 */
#ifdef __cplusplus
extern "C" {		// C Plus Plus function bindings
#define extern
#endif

extern long ATEC_TERMMSK(int ddd);
extern int ec_getxmitslot (int ddd, SC_TSINFO *tsinfop);
extern int ec_getparm (int ddd, unsigned long parm, void *valuep);
extern int ec_listen (int ddd, SC_TSINFO *tsinfop);
extern int ec_rearm (int ddd);
extern int ec_reciottdata (int ddd, DX_IOTT *iottp, DV_TPT *tptp, DX_XPB *xpbp,unsigned short mode);
extern int ec_setparm (int ddd, unsigned long parm, void *valuep);
extern int ec_stopch (int ddd, unsigned long flags, unsigned short mode);
extern int ec_resetch (int ddd, unsigned short mode);
extern int ec_stream (int ddd, DV_TPT *tptp, DX_XPB *xpbp, int (*callback) (int, char *, unsigned int), unsigned short mode);
extern int ec_unlisten (int ddd);
extern int ec_getblkinfo (EC_BLK_INFO *);

#ifdef __cplusplus
}			// C Plus Plus function bindings
#undef extern
#endif

#endif /* __CSPLIB_H__ */
