
/*
 * This file was automatically generated from fep_defs.txt.
 * Author: "Kim Davis"
 * Version: "Revision 1.9"
 * Date: Wed Feb  5 11:35:46 2003
 * The output was written to fep_defs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_fep_defs_h_)
#define _fep_defs_h_ 1
/* This file describes the list of DM3 messages, parameters and equates 
 * supported by the DM3 FEP Component and its Instances. */
/*
 * FEP Component Definition
 */
/* The FEP uses messages from the Standard Kernel Message Set, the Standard 
 * Component Message Set and the Standard Audio FES Component Message Set. */
/*
 * 	DM3 Kernel Standard Message Set defined in mercdefs.doc
 * 	*/
/*
 * 	Standard Component Message Set defined in stddefs.doc.
 * 	*/
/*
 * 	Audio FES Component Message Set defined in (TBD)
 * 	*/
/*
 * 	FES Component Type used when trying to allocate an FES Instance (TBD)
 * 	*/
/* 
 * FEP Message Definitions
 */

#define FEP_MsgStart_CStreamOutput_Off	0	/* 0 */

#define FEP_MsgStart_CStreamOutput_On	0x1	/* 1 */

#define FEP_MsgStart_CStreamOutput	0x380000	/* 3670016 */
typedef	UInt32	FEP_MsgStart_CStreamOutput_t;

#define FEP_MsgStart_OutMask	0x380004	/* 3670020 */
typedef	UInt32	FEP_MsgStart_OutMask_t;

#define FEP_MsgStart_GStreamID	0x380008	/* 3670024 */
typedef	UInt32	FEP_MsgStart_GStreamID_t;

#define FEP_MsgStart_BlockSize	0x38000c	/* 3670028 */
typedef	UInt32	FEP_MsgStart_BlockSize_t;

/*
 * FEP_MsgStart (value = 0x2b00) is an input message
 * for component FEP.
 */


typedef struct {
	UInt32	CStreamOutput;
	UInt32	OutMask;
	UInt32	GStreamID;
	UInt32	BlockSize;
} FEP_MsgStart_t;

#define FEP_MsgStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(FEP_MsgStart_CStreamOutput), &((structAddr)->CStreamOutput),	\
			(FEP_MsgStart_OutMask), &((structAddr)->OutMask),	\
			(FEP_MsgStart_GStreamID), &((structAddr)->GStreamID),	\
			(FEP_MsgStart_BlockSize), &((structAddr)->BlockSize))


#define FEP_MsgStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(FEP_MsgStart_CStreamOutput), &((structAddr)->CStreamOutput),	\
			(FEP_MsgStart_OutMask), &((structAddr)->OutMask),	\
			(FEP_MsgStart_GStreamID), &((structAddr)->GStreamID),	\
			(FEP_MsgStart_BlockSize), &((structAddr)->BlockSize))


#define FEP_MsgStart_Size		16

#define FEP_MsgStart	0x2b00	/* 11008 */
/* The MsgStart message is sent as a command to initiate echo */

#define FEP_MsgStartCmplt_blockSize	0x380000	/* 3670016 */
typedef	UInt32	FEP_MsgStartCmplt_blockSize_t;

/*
 * FEP_MsgStartCmplt (value = 0x2b01) is an output message
 * for component FEP.
 */


typedef struct {
	UInt32	blockSize;
} FEP_MsgStartCmplt_t;

#define FEP_MsgStartCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(FEP_MsgStartCmplt_blockSize), &((structAddr)->blockSize))


#define FEP_MsgStartCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(FEP_MsgStartCmplt_blockSize), &((structAddr)->blockSize))


#define FEP_MsgStartCmplt_Size		4

#define FEP_MsgStartCmplt	0x2b01	/* 11009 */
/* The MsgStartCmplt message is sent as a response to the MsgStart command 
 * when echo cancellation has started. BlockSize - This is the size of the 
 * block that is written to the G-Stream. This includes the header and this is 
 * the number of bytes that the reader must request on G-Streams to be 
 * guaranteed that the read operation will be at the start of the data header. */
/* The MsgStop message is sent to stop an ongoing echo canceller. The 
 * EvtStopped event message may be returned in addition to the MsgStopped 
 * message if this event was enabled. */

/*
 * FEP_MsgStop (value = 0x2b02) is an input message
 * for component FEP.
 */

#define FEP_MsgStop_Size		0

#define FEP_MsgStop	0x2b02	/* 11010 */

#define FEP_MsgStopped_Reason_UserStop	0x1	/* 1 */

#define FEP_MsgStopped_Reason_RtcStop	0x2	/* 2 */

#define FEP_MsgStopped_Reason_SPUnusable	0x3	/* 3 */

#define FEP_MsgStopped_Reason_Max_TimeStop	0x4	/* 4 */

#define FEP_MsgStopped_Reason	0x380000	/* 3670016 */
typedef	UInt32	FEP_MsgStopped_Reason_t;

#define FEP_MsgStopped_RtcLabel	0x380004	/* 3670020 */
typedef	UInt32	FEP_MsgStopped_RtcLabel_t;

/*
 * FEP_MsgStopped (value = 0x2b03) is an output message
 * for component FEP.
 */


typedef struct {
	UInt32	Reason;
	UInt32	RtcLabel;
} FEP_MsgStopped_t;

#define FEP_MsgStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(FEP_MsgStopped_Reason), &((structAddr)->Reason),	\
			(FEP_MsgStopped_RtcLabel), &((structAddr)->RtcLabel))


#define FEP_MsgStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(FEP_MsgStopped_Reason), &((structAddr)->Reason),	\
			(FEP_MsgStopped_RtcLabel), &((structAddr)->RtcLabel))


#define FEP_MsgStopped_Size		8

#define FEP_MsgStopped	0x2b03	/* 11011 */
/* The MsgStopped message is sent as a response to the MsgStop command or when 
 * echo canceller is stopped by an RTC event. Reason - reason why echo 
 * canceller stopped. SPUnusable - this is sent when the subcomponent is no 
 * longer unusable. RtcLabel - if Reason is Rtc then this is the EventLabel of 
 * the event which caused the echo canceller to stop. */
/* This message causes the EC state to be reset to its initial value. This 
 * will not reset any parameters or interfere with the output being generated 
 * if such output is already in progress. */

/*
 * FEP_MsgReset (value = 0x2b04) is an input message
 * for component FEP.
 */

#define FEP_MsgReset_Size		0

#define FEP_MsgReset	0x2b04	/* 11012 */
/*
 * This message acknowledges the processing if the MsgReset message.
 */

/*
 * FEP_MsgResetCmplt (value = 0x2b05) is an output message
 * for component FEP.
 */

#define FEP_MsgResetCmplt_Size		0

#define FEP_MsgResetCmplt	0x2b05	/* 11013 */
/* This message causes the EC to stop streaming data to the host in the event 
 * of a false speech detection. This command is only processed when the EC is 
 * in VAD mode. This will cause the FES component to go into pause mode. The 
 * Pre-speech buffer resident in the FES component will be reset and restarted 
 * to pre-store 250 msec of voice data. Some time later when the FES component 
 * detects speech, it will issue a message to the FEP component and also resume 
 * streaming voice data back to the host. This message is only used to stop ASR 
 * voice data streaming to the host by entering paused mode. */

/*
 * FEP_MsgPauseStream (value = 0x2b06) is an input message
 * for component FEP.
 */

#define FEP_MsgPauseStream_Size		0

#define FEP_MsgPauseStream	0x2b06	/* 11014 */
/*
 * This message acknowledges the processing if the MsgPauseStream message.
 */

/*
 * FEP_MsgPauseStreamCmplt (value = 0x2b07) is an output message
 * for component FEP.
 */

#define FEP_MsgPauseStreamCmplt_Size		0

#define FEP_MsgPauseStreamCmplt	0x2b07	/* 11015 */

#define FEP_MsgDTMFDigit_Digit	0x200000	/* 2097152 */
typedef	UInt8	FEP_MsgDTMFDigit_Digit_t;

/*
 * FEP_MsgDTMFDigit (value = 0x2b08) is an output message
 * for component FEP.
 */


typedef struct {
	UInt8	Digit;
} FEP_MsgDTMFDigit_t;

#define FEP_MsgDTMFDigit_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(FEP_MsgDTMFDigit_Digit), &((structAddr)->Digit))


#define FEP_MsgDTMFDigit_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(FEP_MsgDTMFDigit_Digit), &((structAddr)->Digit))


#define FEP_MsgDTMFDigit_Size		1

#define FEP_MsgDTMFDigit	0x2b08	/* 11016 */
/* This message reports the DTMF Digits detected by FES to the clients of FEP. 
 * The Digit are define in the Miscellaneous Equates Section. The Digit will be 
 * one of the following: FEP_DTMF_1, FEP_DTMF_2, FEP_DTMF_3, FEP_DTMF_4, 
 * FEP_DTMF_5, FEP_DTMF_6, FEP_DTMF_7, FEP_DTMF_8, FEP_DTMF_9, FEP_DTMF_0, 
 * FEP_DTMF_A, FEP_DTMF_B, FEP_DTMF_C, FEP_DTMF_D, FEP_DTMF_POUND and 
 * FEP_DTMF_STAR. */

#define FEP_MsgStartx_CStreamOutput_Off	0	/* 0 */

#define FEP_MsgStartx_CStreamOutput_On	0x1	/* 1 */

#define FEP_MsgStartx_CStreamOutput	0x380000	/* 3670016 */
typedef	UInt32	FEP_MsgStartx_CStreamOutput_t;

#define FEP_MsgStartx_OutMask	0x380004	/* 3670020 */
typedef	UInt32	FEP_MsgStartx_OutMask_t;

#define FEP_MsgStartx_GStreamID	0x380008	/* 3670024 */
typedef	UInt32	FEP_MsgStartx_GStreamID_t;

#define FEP_MsgStartx_BlockSize	0x38000c	/* 3670028 */
typedef	UInt32	FEP_MsgStartx_BlockSize_t;

#define FEP_MsgStartx_Count	0x380010	/* 3670032 */
typedef	UInt32	FEP_MsgStartx_Count_t;

#define FEP_MsgStartx_varStart	0x14

#define FEP_MsgStartx_ParmList_Num	0x880000	/* 8912896 */
typedef	QParm	FEP_MsgStartx_ParmList_Num_t;

#define FEP_MsgStartx_ParmList_Val	0x380000	/* 3670016 */
typedef	UInt32	FEP_MsgStartx_ParmList_Val_t;


typedef struct {
	QParm	Num;
	UInt32	Val;
} FEP_MsgStartx_ParmList_t;

#define FEP_MsgStartx_ParmList_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(FEP_MsgStartx_ParmList_Num), &((structAddr)->Num),	\
			(FEP_MsgStartx_ParmList_Val), &((structAddr)->Val))


#define FEP_MsgStartx_ParmList_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(FEP_MsgStartx_ParmList_Num), &((structAddr)->Num),	\
			(FEP_MsgStartx_ParmList_Val), &((structAddr)->Val))


#define FEP_MsgStartx_ParmList_Size		8

#define FEP_MsgStartx_ParmList	0	/* 0 */

/*
 * FEP_MsgStartx (value = 0x2b09) is an input message
 * for component FEP.
 */


typedef struct {
	UInt32	CStreamOutput;
	UInt32	OutMask;
	UInt32	GStreamID;
	UInt32	BlockSize;
	UInt32	Count;
} FEP_MsgStartx_t;

#define FEP_MsgStartx_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(FEP_MsgStartx_CStreamOutput), &((structAddr)->CStreamOutput),	\
			(FEP_MsgStartx_OutMask), &((structAddr)->OutMask),	\
			(FEP_MsgStartx_GStreamID), &((structAddr)->GStreamID),	\
			(FEP_MsgStartx_BlockSize), &((structAddr)->BlockSize),	\
			(FEP_MsgStartx_Count), &((structAddr)->Count))


#define FEP_MsgStartx_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(FEP_MsgStartx_CStreamOutput), &((structAddr)->CStreamOutput),	\
			(FEP_MsgStartx_OutMask), &((structAddr)->OutMask),	\
			(FEP_MsgStartx_GStreamID), &((structAddr)->GStreamID),	\
			(FEP_MsgStartx_BlockSize), &((structAddr)->BlockSize),	\
			(FEP_MsgStartx_Count), &((structAddr)->Count))


#define FEP_MsgStartx_Size		20

#define FEP_MsgStartx	0x2b09	/* 11017 */
/* MsgStartx message has been added to start the FEP MAX_TIME recording 
 * process. It has been developed so that the parameter Parm_Duration can be 
 * sent in the body of the FEP start message, therefore reducing latency. The 
 * new message MsgStartx is a generic start message allowing any number of 
 * existing parameters to be set at runtime. Count is the number of parameters 
 * which will be sent in the start message body. The structure of the parameter 
 * section contains pairs of parameter numbers and their respective parameter 
 * values. When MsgStartx is received by the FEP, the parameters are unloaded 
 * and set first. Then normal processing of the MsgStartx message contents is 
 * performed. Note: The new MsgStartx and the original MsgStart contain the 
 * same fields and carry the same information up to count and parameter 
 * structure. The MsgStartx message is sent as a command to initiate echo */
/* 
 * FEP Parameter Definitions[CC1]
 * 
 */

#define FEP_Parm_NLP_def	0x1	/* 1 */
/* This is a */

#define FEP_Parm_NLP	0x2b00	/* 11008 */
typedef	UInt24	FEP_Parm_NLP_t;

#define FEP_Parm_ADAPT_COEFFICIENTS_def	0	/* 0 */
/*0 - The EC controls adaptation,  1 - always adapt, 2 - freeze adaptation.*/

#define FEP_Parm_ADAPT_COEFFICIENTS	0x2b01	/* 11009 */
typedef	UInt24	FEP_Parm_ADAPT_COEFFICIENTS_t;

#define FEP_Parm_FILTER_LENGTH_def	0x80	/* 128 */
/*The echo tail length in 125 micros units. The default value is 
 * FEP_Parm_FILTER_LENGTH_def */

#define FEP_Parm_FILTER_LENGTH	0x2b02	/* 11010 */
typedef	UInt24	FEP_Parm_FILTER_LENGTH_t;

#define FEP_Parm_MU_CONST_def	0	/* 0 */
/*If set to 0 then the EC Component will determine this value based on the 
 * filter length. If this is non-zero then this will explicitly set the 
 * adaptation setp size of the filter. The default value is 
 * FEP_Parm_MU_CONST_def */

#define FEP_Parm_MU_CONST	0x2b03	/* 11011 */
typedef	UInt24	FEP_Parm_MU_CONST_t;

#define FEP_Parm_MU_CONST_MAX_def	0	/* 0 */
/*If set to 0 then the EC Component will determine this value. The default 
 * setting is FEP_Parm_MU_CONST_MAX_def */

#define FEP_Parm_MU_CONST_MAX	0x2b04	/* 11012 */
typedef	UInt24	FEP_Parm_MU_CONST_MAX_t;

#define FEP_ParmCngEnabled_def	0x1	/* 1 */
/* This is a */

#define FEP_ParmCngEnabled	0x2b05	/* 11013 */
typedef	UInt32	FEP_ParmCngEnabled_t;

#define FEP_ParmAgcEnabled_def	0	/* 0 */
/* This is a */

#define FEP_ParmAgcEnabled	0x2b06	/* 11014 */
typedef	UInt32	FEP_ParmAgcEnabled_t;
/*
 * The amount of data (in msecs) to buffer before sending to host. Default = TBD.
 */

#define FEP_ParmBufferSize	0x2b07	/* 11015 */
typedef	UInt32	FEP_ParmBufferSize_t;

#define FEP_ParmContainerSize_def	0xfd8	/* 4056 */
/* The minimum size of the block that will be returned in MsgStartCmplt. By 
 * default this is FEP_ParmContainerSize_def. */

#define FEP_ParmContainerSize	0x2b08	/* 11016 */
typedef	UInt32	FEP_ParmContainerSize_t;

#define FEP_Parm_Frame_Overlap_Off	0xfd9	/* 4057 */
/*Describes the amount of temporal frame overlap as in Error! Reference source 
 * not found.. */

#define FEP_Parm_Frame_Overlap	0x2b09	/* 11017 */
typedef	UInt24	FEP_Parm_Frame_Overlap_t;

#define FEP_Parm_CEP_Center_Freqs_def	0	/* 0 */
/* If set to a value other than Parm_CEP_CENTER_DEF use vendor-specified 
 * center freq's. Otherwise use default freq's as described in Error! Reference 
 * source not found.. */

#define FEP_Parm_CEP_Center_Freqs	0x2b0a	/* 11018 */
typedef	UInt24	FEP_Parm_CEP_Center_Freqs_t;

#define FEP_Parm_NCEP_def	0xd	/* 13 */
/*The NCEP value */

#define FEP_Parm_NCEP	0x2b0b	/* 11019 */
typedef	UInt24	FEP_Parm_NCEP_t;

#define FEP_Parm_FFTL_def	0x100	/* 256 */
/* The FFTL value can be 256 or 512 */

#define FEP_Parm_FFTL	0x2b0c	/* 11020 */
typedef	UInt24	FEP_Parm_FFTL_t;

#define FEP_Parm_VadTimeout_def	0x64	/* 100 */

#define FEP_Parm_VadTimeout	0x2b0d	/* 11021 */
typedef	UInt24	FEP_Parm_VadTimeout_t;

#define FEP_Parm_SpeechSnr_def	0	/* 0 */

#define FEP_Parm_SpeechSnr	0x2b0e	/* 11022 */
typedef	UInt24	FEP_Parm_SpeechSnr_t;

#define FEP_Parm_SpeechThresh_def	0xffffffd8	/* -40 */

#define FEP_Parm_SpeechThresh	0x2b0f	/* 11023 */
typedef	UInt24	FEP_Parm_SpeechThresh_t;

#define FEP_Parm_SpeechTrig_def	0xa	/* 10 */

#define FEP_Parm_SpeechTrig	0x2b10	/* 11024 */
typedef	UInt24	FEP_Parm_SpeechTrig_t;

#define FEP_Parm_SpeechWindow_def	0xa	/* 10 */

#define FEP_Parm_SpeechWindow	0x2b11	/* 11025 */
typedef	UInt24	FEP_Parm_SpeechWindow_t;

#define FEP_Parm_CStreamEnable_Off	0	/* 0 */

#define FEP_Parm_CStreamEnable	0x2b12	/* 11026 */
typedef	UInt24	FEP_Parm_CStreamEnable_t;

#define FEP_Parm_SpeechHangTime_def	0x5	/* 5 */

#define FEP_Parm_SpeechHangTime	0x2b13	/* 11027 */
typedef	UInt24	FEP_Parm_SpeechHangTime_t;

#define FEP_Parm_EnergyHangTime_def	0x1e	/* 30 */

#define FEP_Parm_EnergyHangTime	0x2b14	/* 11028 */
typedef	UInt24	FEP_Parm_EnergyHangTime_t;

#define FEP_Parm_SpeechProbOpen_def	0x666666	/* 6710886 */

#define FEP_Parm_SpeechProbOpen	0x2b15	/* 11029 */
typedef	UInt24	FEP_Parm_SpeechProbOpen_t;

#define FEP_Parm_SpeechProbClose_def	0x200000	/* 2097152 */

#define FEP_Parm_SpeechProbClose	0x2b16	/* 11030 */
typedef	UInt24	FEP_Parm_SpeechProbClose_t;

#define FEP_Parm_NoiseLowThresh_def	0xffffffbf	/* -65 */

#define FEP_Parm_NoiseLowThresh	0x2b17	/* 11031 */
typedef	UInt24	FEP_Parm_NoiseLowThresh_t;

#define FEP_Parm_NoiseHiThresh_def	0xffffffec	/* -20 */

#define FEP_Parm_NoiseHiThresh	0x2b18	/* 11032 */
typedef	UInt24	FEP_Parm_NoiseHiThresh_t;

#define FEP_Parm_SVAD_def	0	/* 0 */

#define FEP_Parm_SVAD	0x2b19	/* 11033 */
typedef	UInt24	FEP_Parm_SVAD_t;

#define FEP_Parm_DelayCompensation_def	0	/* 0 */

#define FEP_Parm_DelayCompensation	0x2b1a	/* 11034 */
typedef	UInt24	FEP_Parm_DelayCompensation_t;

#define FEP_Parm_VadOffTimeout_def	0	/* 0 */

#define FEP_Parm_VadOffTimeout	0x2b1b	/* 11035 */
typedef	UInt24	FEP_Parm_VadOffTimeout_t;

#define FEP_Parm_SpeechOffSnr_def	0	/* 0 */

#define FEP_Parm_SpeechOffSnr	0x2b1c	/* 11036 */
typedef	UInt24	FEP_Parm_SpeechOffSnr_t;

#define FEP_Parm_SpeechOffThresh_def	0	/* 0 */

#define FEP_Parm_SpeechOffThresh	0x2b1d	/* 11037 */
typedef	UInt24	FEP_Parm_SpeechOffThresh_t;

#define FEP_Parm_SpeechOffTrig_def	0	/* 0 */

#define FEP_Parm_SpeechOffTrig	0x2b1e	/* 11038 */
typedef	UInt24	FEP_Parm_SpeechOffTrig_t;

#define FEP_Parm_SpeechOffWindow_def	0	/* 0 */

#define FEP_Parm_SpeechOffWindow	0x2b1f	/* 11039 */
typedef	UInt24	FEP_Parm_SpeechOffWindow_t;

#define FEP_Parm_iDTMF_def	0	/* 0 */
/* 
 * Enable or Disable iDTMF Detection
 * Default (0 = Disable)
 *  */

#define FEP_Parm_iDTMF	0x2b20	/* 11040 */
typedef	UInt24	FEP_Parm_iDTMF_t;

#define FEP_Parm_iDTMF_TC_def	0	/* 0 */
/* Enable or Disable iDTMF Tone Clamping. If this is enabled, Parm_iDTMF must 
 * also be enabled. Default (0 = Disable) */

#define FEP_Parm_iDTMF_TC	0x2b21	/* 11041 */
typedef	UInt24	FEP_Parm_iDTMF_TC_t;

#define FEP_Parm_DynamicFESAlloc_def	0	/* 0 */
/* Enable or Disable the dynamic allocation of FES. The default value is 0 
 * which means disable dynamic allocation. The value 1 means enable dynamic 
 * allocation. This parameter is Component Init parameter. */

#define FEP_Parm_DynamicFESAlloc	0x2b22	/* 11042 */
typedef	UInt24	FEP_Parm_DynamicFESAlloc_t;

#define FEP_Parm_DTMFDigitMask_def	0	/* 0 */
/* The following Digit mask can be ORed : FEP_DTMF_MASK_1, FEP_DTMF_MASK_2, 
 * FEP_DTMF_MASK_3, FEP_DTMF_MASK_4, FEP_DTMF_MASK_5, FEP_DTMF_MASK_6, 
 * FEP_DTMF_MASK_7, FEP_DTMF_MASK_8, FEP_DTMF_MASK_9, FEP_DTMF_MASK_0, 
 * FEP_DTMF_MASK_A, FEP_DTMF_MASK_B, FEP_DTMF_MASK_C, FEP_DTMF_MASK_D, 
 * FEP_DTMF_MASK_POUND and FEP_DTMF_MASK_STAR Together with the Digit Mask one 
 * must also OR together the intended operation. The following are the 
 * operations on the Mask. FEP_DTMF_ADD_MASK, FEP_DTMF_SUB_MASK and 
 * FEP_DTMF_SET_MASK */

#define FEP_Parm_DTMFDigitMask	0x2b23	/* 11043 */
typedef	UInt24	FEP_Parm_DTMFDigitMask_t;

#define FEP_Parm_Duration_def	0	/* 0 */

#define FEP_Parm_Duration	0x2b24	/* 11044 */
typedef	UInt24	FEP_Parm_Duration_t;

#define FEP_Parm_SCSTrailingSilence_def	0xc8	/* 200 */

#define FEP_Parm_SCSTrailingSilence_minVal	0x64	/* 100 */

#define FEP_Parm_SCSTrailingSilence_maxVal	0x3e8	/* 1000 */

#define FEP_Parm_SCSTrailingSilence	0x2b25	/* 11045 */
typedef	UInt24	FEP_Parm_SCSTrailingSilence_t;

#define FEP_Parm_SCSInitialData_def	0	/* 0 */

#define FEP_Parm_SCSInitialData_minVal	0	/* 0 */

#define FEP_Parm_SCSInitialData_maxVal	0x7d0	/* 2000 */

#define FEP_Parm_SCSInitialData	0x2b26	/* 11046 */
typedef	UInt24	FEP_Parm_SCSInitialData_t;

#define FEP_Parm_SCSOnOff_SCSOff	0	/* 0 */

#define FEP_Parm_SCSOnOff_SCSOn	0x1	/* 1 */

#define FEP_Parm_SCSOnOff_def	0	/* 0 */

#define FEP_Parm_SCSOnOff	0x2b27	/* 11047 */
typedef	UInt24	FEP_Parm_SCSOnOff_t;

#define FEP_Event_ReturnAddress	0x800000	/* 8388608 */
typedef	QCompDesc	FEP_Event_ReturnAddress_t;

#define FEP_Event_Type_Converged	0x1	/* 1 */

#define FEP_Event_Type_VAD_Detected	0x2	/* 2 */

#define FEP_Event_Type_VAD_Off_Detected	0x3	/* 3 */

#define FEP_Event_Type	0x380006	/* 3670022 */
typedef	UInt32	FEP_Event_Type_t;

#define FEP_Event_Label	0x38000a	/* 3670026 */
typedef	UInt32	FEP_Event_Label_t;

/*
 * FEP_Event (value = generic) is a message
 * for component FEP.
 */


typedef struct {
	QCompDesc	ReturnAddress;
	UInt32	Type;
	UInt32	Label;
} FEP_Event_t;

#define FEP_Event_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(FEP_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(FEP_Event_Type), &((structAddr)->Type),	\
			(FEP_Event_Label), &((structAddr)->Label))


#define FEP_Event_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(FEP_Event_ReturnAddress), &((structAddr)->ReturnAddress),	\
			(FEP_Event_Type), &((structAddr)->Type),	\
			(FEP_Event_Label), &((structAddr)->Label))


#define FEP_Event_Size		14
/* 
 * FEP Run Time Control Actions Definitions
 */

#define FEP_Action_Label	0x380000	/* 3670016 */
typedef	UInt32	FEP_Action_Label_t;

#define FEP_Action_Type_RtcStop	0x270	/* 624 */

#define FEP_Action_Type	0x380004	/* 3670020 */
typedef	UInt32	FEP_Action_Type_t;

/*
 * FEP_Action (value = generic) is a message
 * for component FEP.
 */


typedef struct {
	UInt32	Label;
	UInt32	Type;
} FEP_Action_t;

#define FEP_Action_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(FEP_Action_Label), &((structAddr)->Label),	\
			(FEP_Action_Type), &((structAddr)->Type))


#define FEP_Action_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(FEP_Action_Label), &((structAddr)->Label),	\
			(FEP_Action_Type), &((structAddr)->Type))


#define FEP_Action_Size		8
/*
 * RtcStop is a RTC Action to stop echo canceller.
 */
/* 
 * FEP Error Code Definitions
 */
/*
 * Invalid StreamId was specified.
 */

#define FEP_ErrStreamID	0x2b00	/* 11008 */
/*
 * Cluster could not be activated.
 */

#define FEP_ErrClusterActivate	0x2b01	/* 11009 */
/*
 * Cluster information could not be obtained.
 */

#define FEP_ErrClusterInfo	0x2b02	/* 11010 */
/*
 * Invalid FES was specified.
 */

#define FEP_ErrFES	0x2b03	/* 11011 */
/*
 * No FES of specified type free.
 */

#define FEP_ErrNoFESFree	0x2b04	/* 11012 */
/*
 * Invalid start mode specified when starting echo canceller. 
 */

#define FEP_ErrStartMode	0x2b05	/* 11013 */
/*
 * Invalid CStream flag.
 */

#define FEP_ErrCStream	0x2b06	/* 11014 */
/*
 * Invalid GStream flag.
 */

#define FEP_ErrGStream	0x2b07	/* 11015 */
/*
 * No valid GStream or CStream specified.
 */

#define FEP_ErrNonActive	0x2b08	/* 11016 */
/*
 * Overrun detected. Stream full.
 */

#define FEP_ErrOverrun	0x2b09	/* 11017 */
/* Cannot assign C-Stream output because global C Stream enable parameter is 
 * disabled. */

#define FEP_ErrCStreamParmDisabled	0x2b0a	/* 11018 */
/*
 * More than one VAD mode was set.  
 */

#define FEP_ErrVADMode	0x2b0b	/* 11019 */
/*
 * Invalid Operation Specified in setting the DTMF Mask.
 */

#define FEP_ErrInvalidDTMFOperation	0x2b0c	/* 11020 */
/*
 * Invalid DTMF Mask Specified
 */

#define FEP_ErrInvalidMask	0x2b0d	/* 11021 */
/*
 * Error in enabling the FES for Digit Detection.
 */

#define FEP_ErrFESDTMFEnable	0x2b0e	/* 11022 */
/*
 * Error in disabling the FES for Digit Detection.
 */
/*
 * Standard Attribute Definition
 */

#define FEP_ErrFESDTMFDisable	0x2b0f	/* 11023 */

#define FEP_Std_ComponentType	0x2b	/* 43 */
/*
 * Echo Canceller features.
 */

#define FEP_Cluster_Resource	0x2b00	/* 11008 */

#define FEP_Cluster_IO	0x2b01	/* 11009 */
/* FEP_Cluster - This attribute key is associated with the cluster. 
 * FEP_ClusterResource - This value for the FEP_Cluster key is for the cluster 
 * which allocates the FEP Instance. FEP_ClusterIO - This value for the 
 * FEP_Cluster key is for the cluster which must have an SCBus. The Si port is 
 * used for EC output. The So port is used for the Transmit reference for the 
 * signal used for echo cancellation. This is commonly referred to as the Tx 
 * Reference. */

#define FEP_Cluster	0x2b00	/* 11008 */
typedef	QCompAttr	FEP_Cluster_t;
/* Front-End processing features requested. The different processing features 
 * are discussed in Error! Reference source not found.. Different FES features 
 * are requested by the bit settings defined in DM3 Front End Primary Component 
 * CIS, Section Error! Reference source not found.. */

#define FEP_Feature	0x2b01	/* 11009 */
typedef	QCompAttr	FEP_Feature_t;
/* FEP_Number - This attribute key is associated with the FEP_ClusterResource 
 * cluster. The value is the transmit timeslot for the ScBus instance in that 
 * cluster. */


#define FEP_DTMF_1      (1)
#define FEP_DTMF_2      (2)
#define FEP_DTMF_3      (3)
#define FEP_DTMF_4      (5)
#define FEP_DTMF_5      (6)
#define FEP_DTMF_6      (7)
#define FEP_DTMF_7      (9)
#define FEP_DTMF_8      (10)
#define FEP_DTMF_9      (11)
#define FEP_DTMF_0      (14)
#define FEP_DTMF_A      (4)
#define FEP_DTMF_B      (8)
#define FEP_DTMF_C      (12)
#define FEP_DTMF_D      (16)
#define FEP_DTMF_POUND  (15)
#define FEP_DTMF_STAR   (13)

#define FEP_DTMF_MASK_1      (0x1)
#define FEP_DTMF_MASK_2      (0x2)
#define FEP_DTMF_MASK_3      (0x4)
#define FEP_DTMF_MASK_4      (0x10)
#define FEP_DTMF_MASK_5      (0x20)
#define FEP_DTMF_MASK_6      (0x40)
#define FEP_DTMF_MASK_7      (0x100)
#define FEP_DTMF_MASK_8      (0x200)
#define FEP_DTMF_MASK_9      (0x400)
#define FEP_DTMF_MASK_0      (0x2000)
#define FEP_DTMF_MASK_A      (0x8)
#define FEP_DTMF_MASK_B      (0x80)
#define FEP_DTMF_MASK_C      (0x800)
#define FEP_DTMF_MASK_D      (0x8000)
#define FEP_DTMF_MASK_POUND  (0x4000)
#define FEP_DTMF_MASK_STAR   (0x1000)

#define FEP_DTMF_ADD_MASK    (0x100000)
#define FEP_DTMF_SUB_MASK    (0x200000)
#define FEP_DTMF_SET_MASK    (0x400000)


/*
 * End of all DM3 FEP Component Definitions
 */

#define FEP_Number	0x2b02	/* 11010 */
typedef	QCompAttr	FEP_Number_t;

#define FEP	0x2b	/* 43 */

typedef struct {
	UInt24		Parm_NLP;
	UInt24		Parm_ADAPT_COEFFICIENTS;
	UInt24		Parm_FILTER_LENGTH;
	UInt24		Parm_MU_CONST;
	UInt24		Parm_MU_CONST_MAX;
	UInt32		ParmCngEnabled;
	UInt32		ParmAgcEnabled;
	UInt32		ParmBufferSize;
	UInt32		ParmContainerSize;
	UInt24		Parm_Frame_Overlap;
	UInt24		Parm_CEP_Center_Freqs;
	UInt24		Parm_NCEP;
	UInt24		Parm_FFTL;
	UInt24		Parm_VadTimeout;
	UInt24		Parm_SpeechSnr;
	UInt24		Parm_SpeechThresh;
	UInt24		Parm_SpeechTrig;
	UInt24		Parm_SpeechWindow;
	UInt24		Parm_CStreamEnable;
	UInt24		Parm_SpeechHangTime;
	UInt24		Parm_EnergyHangTime;
	UInt24		Parm_SpeechProbOpen;
	UInt24		Parm_SpeechProbClose;
	UInt24		Parm_NoiseLowThresh;
	UInt24		Parm_NoiseHiThresh;
	UInt24		Parm_SVAD;
	UInt24		Parm_DelayCompensation;
	UInt24		Parm_VadOffTimeout;
	UInt24		Parm_SpeechOffSnr;
	UInt24		Parm_SpeechOffThresh;
	UInt24		Parm_SpeechOffTrig;
	UInt24		Parm_SpeechOffWindow;
	UInt24		Parm_iDTMF;
	UInt24		Parm_iDTMF_TC;
	UInt24		Parm_DynamicFESAlloc;
	UInt24		Parm_DTMFDigitMask;
	UInt24		Parm_Duration;
	UInt24		Parm_SCSTrailingSilence;
	UInt24		Parm_SCSInitialData;
	UInt24		Parm_SCSOnOff;

} FEPparm_t;

#if defined ( FEP_DEFINED )

ParmStruct FEPParmTab []= {
{FEP_Parm_NLP, 40, 0, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_NLP), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_ADAPT_COEFFICIENTS), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_FILTER_LENGTH), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_MU_CONST), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_MU_CONST_MAX), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(FEPparm_t, ParmCngEnabled), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(FEPparm_t, ParmAgcEnabled), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(FEPparm_t, ParmBufferSize), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(FEPparm_t, ParmContainerSize), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_Frame_Overlap), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_CEP_Center_Freqs), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_NCEP), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_FFTL), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_VadTimeout), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechSnr), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechThresh), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechTrig), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechWindow), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_CStreamEnable), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechHangTime), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_EnergyHangTime), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechProbOpen), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechProbClose), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_NoiseLowThresh), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_NoiseHiThresh), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SVAD), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_DelayCompensation), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_VadOffTimeout), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechOffSnr), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechOffThresh), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechOffTrig), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SpeechOffWindow), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_iDTMF), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_iDTMF_TC), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_DynamicFESAlloc), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_DTMFDigitMask), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_Duration), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SCSTrailingSilence), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SCSInitialData), PARM_READWRITE, 0, 0, 0},
 {0x300000, offsetof(FEPparm_t, Parm_SCSOnOff), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_fep_defs_h_) */
