/****************************************************************************
 *		Copyright (c) 1995 Intel Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:
 * AUTHOR:       Ray Bailey x6155
 * ORG:          Intel Corporation
 * ORIG-DATE:    30-Dec-98 at 14:52:45
 * LAST-MOD:     Wed Dec 11 19:41:15 2002 by patelhi
 * PURPOSE:
 *    This module contains all the specific code for initializing all the
 *    data structures in shared RAM.  This occurrs once after initialization
 *    if the init. process fails then an error code is returned.
 *
 * HISTORY:
 * Date                 Who      Description
 * 12/04/02           Himanshu Silence Compress Implementation
 * 29-Oct-02            hrp      Added define for FESG_BUFFER_SIZE
 * 18-Oct-94            CC       First bug fix.
 * 15-Oct-94            CC       Initial Creation.
 ***************************************************************************/

/*
 *  Get G-stream header information
 */
#include <output_mask.h>


/*****************************************************************************************************************************************
***  G-stream header information                                                                                                         *
******************************************************************************************************************************************
*** Bit  31        *  Bits 30-29      *  Bits 28 - 19            *   Bits 18 - 16        *   Bits 15 - 8         *  Bits 7 - 0           *
******************************************************************************************************************************************
*** 0x1000= GStream*  Output Format:  *  Output Features Mask:   *   Block Descriptor:   * Samples in this block * Samples in this block *
*** Output Enable  *  0x00 = ulaw     *  '1' = enabled           *   0x1 = Last Block    * - Hi Byte             * - Low Byte            *
***                *  0x01 = Alaw     *  0x1 = EC                *   0x2 = Intermediate  *                       *                       *
***                *  0x02 = linear LE*  0x2= Pre-Emphasis       *         Block  for SCS*                       *                       *
***                *  0x03 = linear BE*  0x4= Framing            *   0x4 = Initial Stream*                       *                       *
***                *                  *  0x8= End-Pointing       *         Block         *                       *                       *
***                *                  *  0x10 = Normalization    *   '1'= True           *                       *                       *
***                *                  *  0x20 = FFT              *                       *                       *                       *
***                *                  *  0x40= CEP's             *                       *                       *                       *
***                *                  *  0x200=Companding        *                       *                       *                       *
***                *                  *  0x300=DTMF Tone Clamping*                       *                       *                       *
***                *                  *                          *                       *                       *                       *
******************************************************************************************************************************************
***                *                  *  Bits 63 - 56            *   Bits 55 - 52        *   Bits  51 - 40       *   Bits 39 - 32        *
******************************************************************************************************************************************
***                *                  *  Reserved                *   Reserved            * Time Stamp in         * Time Stamp in         *                     *
***                *                  *                          *                       * this block - Hi Byte  * this block - Low Byte *                     *
***                *                  *                          *                       *                       *                       *
***                *                  *                          *                       *                       *                       *
***                *                  *                          *                       *                       *                       *
*****************************************************************************************************************************************/





#define     FESG_HEAD_SIZE       8
#define     FESG_BUFFER_SIZE     320 /* 80*4 */

/* Define for Last Block Flag   */
#define FES_LASTBLOCK               0x10000
#define FES_INTERMEDIATEBLOCK       0x20000
#define FES_INITIALBLOCK            0x40000
#define FES_CLEAR_INTERMEDIATEBLOCK 0xDFFFF
#define FES_CLEAR_INITIALBLOCK      0xBFFFF
#define FES_CLEAR_BLOCK             0x8FFFF

/*
 *  Can be used by the Host or SP
 */
#define     IS_FES_EC(gOutMask)             ((gOutMask & FE_EC) ? 1 : 0)
#define     IS_FES_PreEmphasis(gOutMask)    ((gOutMask & FE_PreEmphasis) ? 1 : 0)
#define     IS_FES_Framing(gOutMask)        ((gOutMask & FE_Framing) ? 1 : 0)
#define     IS_FES_EndPoint(gOutMask)       ((gOutMask & FE_EndPoint) ? 1 : 0)
#define     IS_FES_Norm(gOutMask)           ((gOutMask & FE_Norm) ? 1 : 0)
#define     IS_FES_FFT(gOutMask)            ((gOutMask & FE_FFT) ? 1 : 0)
#define     IS_FES_CEPs(gOutMask)           ((gOutMask & FE_CEPs) ? 1 : 0)
#define     IS_FES_GStreamEnable(gOutMask)  ((gOutMask & FE_GStreamEnable) ? 1 : 0)
#define     IS_FES_LastBlock(pHeader) \
                             (*(((Uint8 *)(pHeader))+2) & 0x1)
#define     IS_FES_SCSIntermediateBlock(pHeader) \
                             (*(((Uint8 *)(pHeader))+2) & 0x2)
#define     IS_FES_SCSInitialBlock(pHeader) \
                             (*(((Uint8 *)(pHeader))+2) & 0x4)


#define     IS_FES_Companding(gOutMask)     ((gOutMask & FE_Companding) ? 1 : 0)
#define     IS_FES_Alaw(gOutMask)           (((gOutMask & FE_LinearBE)== FE_Alaw) ? 1 : 0)
#define     IS_FES_Mulaw(gOutMask)          (((gOutMask & FE_LinearBE)== 0) ? 1 : 0)
#define     IS_FES_LinearLE(gOutMask)       (((gOutMask & FE_LinearBE)==FE_LinearLE) ? 1 : 0)
#define     IS_FES_LinearBE(gOutMask)       (((gOutMask & FE_LinearBE)==FE_LinearBE) ? 1 : 0)

/*
 * Used by the SP to set the data size
 */
#define     SET_FES_DATASIZE(gDataSize,pHeader) \
            *(((Uint24 *)(pHeader))) &= 0xFF0000; \
            (*(((Uint24 *)(pHeader))) |= (gDataSize & 0xFFFF));

/*
 * Used by the SP to set the Time Stamp Value
 */
#define     SET_FES_TIMESTAMP(gTimeStamp,pHeader) \
            *(((Uint24 *)(pHeader))+1) &= 0x0000FF; \
            (*(((Uint24 *)(pHeader))+1) |= ((gTimeStamp << 8) & 0xFFFF00)); \
            *(((Uint24 *)(pHeader))+2) &= 0x0000F0; \
            (*(((Uint24 *)(pHeader))+2) |= ((gTimeStamp >> 16) & 0xFFFFF0));


/*
 * Append the Output Format Mask to the Header
 */
#define     APPEND_OUTMASK1(gOutMask,pHeader) \
            *(((Uint24 *)(pHeader))) |= ((gOutMask & 0x1F) << 19); \
            *(((Uint24 *)(pHeader))+1) |= ((gOutMask >> 5) & 0x1F);

/*
 * Used by the Host to get the returned Output Format Mask
 */

#define     GET_OUTMASK1(pHeader,pOutMask) \
            *((Uint16 *)pOutMask)   = *(((Uint16 *)(pHeader))+1); \
            *((Uint16 *)pOutMask)   >>= 3; \
            *((Uint16 *)pOutMask)   &= 0x3FF;

#define     GET_FES_DATASIZE(pHeader,pDataSize) \
            *((Uint16 *)pDataSize) = *((Uint16 *)pHeader);

#define     GET_FES_TIMESTAMP(pHeader,pTimeStamp) \
            *(((Uint16 *)pTimeStamp)+1) = *(((Uint16 *)pHeader)+3); \
            *((Uint16 *)pTimeStamp) = *(((Uint16 *)pHeader)+2); \
            *((Uint16 *)pTimeStamp) &= 0x0fffff;

/*
 * Set G-stream header bits
 */
#define     SET_FES_EC(gOutMask)            (gOutMask |= FE_EC)
#define     SET_FES_PreEmphasis(gOutMask)   (gOutMask |= FE_PreEmphasis)
#define     SET_FES_Framing(gOutMask)       (gOutMask |= FE_Framing)
#define     SET_FES_EndPoint(gOutMask)      (gOutMask |= FE_EndPoint)
#define     SET_FES_Norm(gOutMask)          (gOutMask |= FE_Norm)
#define     SET_FES_FFT(gOutMask)           (gOutMask |= FE_FFT)
#define     SET_FES_CEPs(gOutMask)          (gOutMask |= FE_CEPs)
#define     SET_FES_GStreamEnable(gOutMask) (gOutMask |= FE_GStreamEnable)

#define     SET_FES_InitialBlock(pHeader) \
                              *(((Uint24 *)(pHeader))+0) |=  FES_INITIALBLOCK;

#define     SET_FES_IntermediateBlock(pHeader) \
                              *(((Uint24 *)(pHeader))+0) |=  FES_INTERMEDIATEBLOCK;

#define     SET_FES_LastBlock(pHeader) \
                              *(((Uint24 *)(pHeader))+0) |=  FES_LASTBLOCK;


#define     CLEAR_FES_InitialBlock(pHeader) \
                              *(((Uint24 *)(pHeader))+0) &=  FES_CLEAR_INITIALBLOCK;

#define     CLEAR_FES_IntermediateBlock(pHeader) \
                              *(((Uint24 *)(pHeader))+0) &=  FES_CLEAR_INTERMEDIATEBLOCK;

#define     CLEAR_FES_Block(pHeader) \
                              *(((Uint24 *)(pHeader))+0) &=  FES_CLEAR_BLOCK;

#define     SET_FES_Companding(gOutMask)    (gOutMask |= FE_Companding)
#define     SET_FES_Alaw(gOutMask)          (gOutMask |= FE_Alaw)
#define     SET_FES_LinearLE(gOutMask)      (gOutMask |= FE_LinearLE)
#define     SET_FES_LinearBE(gOutMask)      (gOutMask |= FE_LinearBE)















