#ifndef _G726_H_
#define _G726_H_ 1
/****************************************************************************
 *		Copyright (c) 1999 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/
/****************************************************************************
 * FILE:         G726.h
 * AUTHOR:       CUIC
 * ORIG-DATE:    15-June-1999
 * PURPOSE:      Header of G.726 Coder to be integrated into QVS
 * 
 * HISTORY:
 * Date          Who	    Description
 * 
 ***************************************************************************/

#define G726STATESIZE	70		/*state buffer in Y memory*/
#define G726WORKSIZE	70		/*working buffer is a 64-word modular*/
								/*block of both X and Y memory, start*/
								/*at the same address (a L mem block)*/

typedef enum
{
	DALLAS_ADPCM = 0,
	G726_RATE_16,
	G726_RATE_24,
	G726_RATE_32,
	G726_RATE_40
} G726RATE_t;

typedef enum
{
	G726_UNTRANS = 0,
	G726_SPEECH,
	G726_SID
}G726FRAME_t;

typedef struct
{
	Uint24	*pX_Memory;
	int	X_Memory_Size;
	Uint24	*pY_Memory;
	int	Y_Memory_Size;
}G726MEMDSCR_t;

typedef struct
{
	G726MEMDSCR_t	Buffer;
	G726MEMDSCR_t	State;
	int				DtxFlag;			/*not used now*/
	G726RATE_t		Rate;				/*not used now*/
} G726DSCR_t, *G726HANDLE_t;

typedef struct
{
    Uint24 *pData;
    int  Size;
    int  SamplesRequested;
    int  SamplesProcessed;
}G726DATA_t;
	
int	G726InitInst(G726HANDLE_t);
int	G726ResetInst(G726HANDLE_t);
int	G726Activate(G726HANDLE_t);
int	G726Deactivate(G726HANDLE_t);
int	G726Encoder(G726HANDLE_t, G726DATA_t * );
int	G726Decoder(G726HANDLE_t, G726DATA_t * );

G726HANDLE_t G726InitHandle(
			    Uint24 *pIntMem,   int IntMemSize, 
			    Uint24 *pStateBuf, int StateBufSize, 
			    int DtxFlag, 
			    G726RATE_t Rate, 
			    G726HANDLE_t G726Handle);
			    

int g726unpack( Uint24 *pPackedBuf,
		 Uint24 *pUnpackedBuf,
		 int bitsPerSample,
		 int numSamples);
		 
int g726pack(	Uint24 *pPackedBuf,
		Uint24 *pUnpackedBuf,
		int bitsPerSample,
		int numSamples);
		
void dallas_pack(Uint24 *pPacked, Uint24 *pUnpacked, int numSamples);		 
void dallas_unpack(Uint24 *pPacked, Uint24 *pUnpacked, int numSamples);

int g726type2parm(int type, int *pRate, int *pBitsPerSample);
			    
#endif
