#ifndef _G729DEF_H_
#define _G729DEF_H_ 1
/****************************************************************************
*                              NOTICE
*  This source code contains proprietary and confidential information,
*  and is the property of the Dialogic Corporation.
*
*  This program has been distributed under license agreement and any
*  unauthorized use or distribution is prohibited.
*
*  Copyright 1997-2000 by Dialogic, An Intel Company. All rights reserved.
 ***************************************************************************/
/****************************************************************************
 * FILE:		g729def.h
 * AUTHOR:
 * ORG:
 * ORIG-DATE:
 * LAST-MOD:	2/10/00
 * PURPOSE:
 *
 * HISTORY:
 * Date			Who		Description
 * 03/29/01   HP       changed G729_DTX = 1 to 0
 *
 ***************************************************************************/
/* Definitions for decoder Vad/Cng states */
typedef enum
{
	S0 =	0,	/* Speech */
	S1 =    1,	/* SID */
	S2 =    2,	/* Untransmitted */
} G729VAD_t;

/* Coder state structure. */
typedef struct
{
    Uint24     *pData;
    int        Size;
    int        DtxFlag;
    G729VAD_t  FrameState;
} G729STATE_t, *G729HANDLE_t;

/* PCM data samples frame structure. */
typedef struct
{
    int    Size;
    Int24  *pData;
    int	   SamplesRequested;
    int    SamplesProcessed;
} G729PCMFRAME_t;

/* Coded data frame structure. */
typedef struct
{
    int    Size;
    Uint24 *pData;
    int    ByteCount;
    int    FrameErasure;
    int    VadCng;
    int    Rate;
} G729DATAFRAME_t;

/* Frame info. structure */
typedef struct
{
    int FrameSize;
    int Sid;
    int Rate;
} G729FRAMEINFO_t;


#define NUM_BYTES_SPEECH_G729		10
#define NUM_BYTES_SID_G729		2
#define NUM_BYTES_UNT_G729 		0

#define G729A_ENCODER_SIZE		750
#define G729A_DECODER_SIZE		580
#define G729A_PCM_FRAME_SIZE		80
#define G729A_CODE_FRAME_SIZE	10

#define G729_DTX	0
#define G729_SPEECH	0

void	NC_G729A_Init(void);
void	NC_G729A_Delete(G729HANDLE_t);
int	NC_G729A_CreateEncoder(G729HANDLE_t);
int	NC_G729A_CreateDecoder(G729HANDLE_t);
int	NC_G729A_Enc_Load_State(G729HANDLE_t);
int	NC_G729A_Enc_Save_State(G729HANDLE_t);
int	NC_G729A_Dec_Load_State(G729HANDLE_t);
int	NC_G729A_Dec_Save_State(G729HANDLE_t);
int	NC_G729A_Encode(G729HANDLE_t, G729PCMFRAME_t *, G729DATAFRAME_t *);
int	NC_G729A_Decode(G729HANDLE_t, G729PCMFRAME_t *, G729DATAFRAME_t *);
int	NC_G729A_FrameInfo(G729DATAFRAME_t  *, G729FRAMEINFO_t  *);

#endif
