#ifndef _GSMdef_H_
#define _GSMdef_H_  1
/****************************************************************************
 *		Copyright (c) 1999 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/
/****************************************************************************
 * FILE:         GSMdef.h
 * AUTHOR:       CUIC
 * ORIG-DATE:    24-May-1999
 * PURPOSE:      Header of GSM Coder to be integrated into QVS
 * 
 * HISTORY:
 * Date          Who	    Description
 * 
 ***************************************************************************/

/* Data structure definitions based on VSR framework */

/* GSM frame and state size definitions */
#define	PCM_FRAME_SIZE                  160
#define	GSM_STATE_BUF_SIZE              230
#define GSM_UNPACKED_FRM_SIZE           76 
#define GSM_2PACKED_FRM_SIZE            65
#define GSM_PACKED_FRM_SIZE             33
#define GSM_FULL_RATE                   13000

/* PCM data samples frame structure. */
typedef struct
{
    int    size;
    Int24 *pData;
    int    SamplesRequested;
    int    SamplesProcessed;
} GSMPCMFRAME_t;

/* Coded data frame structure. */
typedef struct
{
    int     size;
    Uint24 *pData;
    int     ByteCount;
    int     FrameErasure;
    int     VadCng;
    int     Rate;
} GSMDATAFRAME_t;

/* Coder data/state area structure. */
typedef struct
{
    Uint24 *pData;
    int     size;
    int     DtxFlag;
} GSMSTATEBUF_t;


/* Interface function prototypes of GSM coder */
int GSM4QVS_CreateEncoder(GSMSTATEBUF_t *);
int GSM4QVS_CreateDecoder(GSMSTATEBUF_t *);
int GSM4QVS_Encoder(GSMSTATEBUF_t *, GSMPCMFRAME_t *, GSMDATAFRAME_t *);
int GSM4QVS_Decoder(GSMSTATEBUF_t *, GSMPCMFRAME_t *, GSMDATAFRAME_t *);

void MS_Bit_Pack(Uint24 *ParmsFrame0, Uint24 *ParmsFrame1, Uint24 *PackData );
void MS_Bit_Unpack(Uint24 *ParmsFrame0, Uint24 *ParmsFrame1, Uint24 *PackData );

void RTP_Bit_Pack( int *Parms, int *PackData );
void RTP_Bit_Unpack( int *PackData, int *Parms );

#endif

