/****************************************************************************
*                              NOTICE
*  This source code contains proprietary and confidential information,
*  and is the property of the Dialogic Corporation.
*
*  This program has been distributed under license agreement and any
*  unauthorized use or distribution is prohibited.
*

*  Copyright 1997-2000 by Dialogic, An Intel Company. All rights reserved.
 ***************************************************************************/
/****************************************************************************
 * FILE:         imadef.h
 * AUTHOR:       Patelhi
 * ORG:          Dialogic Corporation
 * ORIG-DATE:
 * LAST-MOD:     Wed Mar 14 18:05:25 2001 by patelhi
 * PURPOSE:      Definitions and prototypes of IMA Coder
 *
 * HISTORY:
 * Date          Who        Description
 * 2/9/2001    Patelhi
 ***************************************************************************/

typedef int	Word24;
typedef long int Word48;


#define IMA_FRAME		505
#define IMADEC_FRAME	256  /*Block length=256*/

#define MAXIMAINSTANCES  1
#define CODE_BLOCK_SIZE  64	  /* 256 is Multiple of 64 */

#define IMA_ENC_PCM_FRAME_SIZE		160

#define IMA_DECODER_SIZE		505
/* #define IMA_PCM_FRAME_SIZE   240 */
#define IMA_CODE_FRAME_SIZE  64

#define IMA_ENC_FRAME_SIZE_MAX 84

typedef struct
{
	  Word24 PredSample;
    Word24 StepIndex;
    Word24 Block_Cnt;
    Word24 FirstSample;
    Word24 Lastnibble;
    Word24 Lastnibble_flag;
} IMAENCODER_t, *IMAHANDLE_t;

typedef struct
{
    Word24 PredSample;
    Word24 StepIndex;
    Word24 Block_Cnt;
    Word24 PcmOut_Cnt;
} IMADECODER_t, *HANDLE_t;

#if 0
/* Coder state structure. */
typedef union
{
   IMAENCODER_t      imaEnc;
   IMADECODER_t      imaDec;
} IMASTATE_t, *IMAHANDLE_t;
#endif

Word24 lin2ima(Int24 *pData, int size, IMAHANDLE_t, UInt24 *pout_data );

Word24 ima2lin(Int24 *pData, HANDLE_t, int size, UInt24 *pout_data );

