/*****************************************************************************
 * Copyright (c) 1990-2003 Intel Corporation
 * All Rights Reserved.  All names, products, and services mentioned herein
 * are the trademarks or registered trademarks of their respective organizations
 * and are the sole property of their respective owners
 *****************************************************************************/

/*****************************************************************************
 * Filename:     isdnerr.h
 * DESCRIPTION: This file contains the error codes for the ISDN library..   
 *****************************************************************************/

#ifndef isdnerr_h_included
#define isnderr_h_included

#include "isdnos.h"

/* 
 * Bases for the various error codes
 */
#define ERR_ISDN_FW            0x100
#define ERR_ISDN_CAUSE         0x200
#define ERR_ISDN               0x300
#define ERR_ISDN_LIB           ERR_ISDN
#define ERR_ISDN_DRV           ERR_ISDN

/*
 ******************* Message passing error codes ***************************
 */
#define E_ISSUCC           0x00   /* Message acknowledged. */

/*
 **************************** Driver ***************************************
 */
#define E_ISREADY          0x01  /* Board not ready */
#define E_ISCONFIG         0x02  /* Configuration error */
#define E_ISNOINFO         0x03  /* information not available */
#define E_ISNOUSRINFOBUF   0x04  /* User information element buffer is not
                                    ready */
#define E_ISNOFACILITYBUF  0x05  /* Facility buffer is not ready */
#define E_ISBADBUFADDR     0x06  /* Bad buffer address */
#define E_ISBADTS          0x07  /* bad time slot */
#define E_ISOVERWRITE      0x08  /* over writen error */


/*
 ****************************  LIB  ****************************************
 */
#define  E_ISGLOBAL        0x81  /* global event */
#define  E_ISCALLRELATED   0x82  /* call related event */
#define  E_ISLINERELATED   0x83  /* line related event */
#define  E_ISNOSPRT        0x84  /* Function not supported on device */
#define  E_ISMAXLEN        0x85  /* exceed maximum lenght allowed */
#define  E_ISNULLPTR       0x86  /* null pointer error */
#define  E_ISNOMEM         0x87  /* out of memory */
#define  E_ISFILEOPENFAIL  0x88  /* failed to open a file, application can 
                                    check DOS 'errno' to get more 
                                    informations */
#define  E_ISTNACT         0x89  /* trace information is not activated */
#define  E_ISBADPAR        0x8A  /* bad input parameter */


#ifdef ISDN_DOS
#define  E_ISBADLINEDEV    0xC1  /* bad LINEDEV - dos only */ 
#else
#define  E_ISBADCALLID     0xC1  /* bad callid - unix and os2 only */
#endif
#define  E_ISBADCRN        0xC2  /* bad CRN */
#define  E_ISNOINFOBUF     0xC3  /* information buffer not ready */
#define  E_ISINVNETWORK    0xC4  /* invalid network type */
#define  E_LINKDOWN        0xC5  /* data link is down */
#define  E_LINKUP          0xC6  /* data link is up */
#define  E_LINKRESET       0xC7  /* data link reset */
#define  E_FB_UNAVAIL      0xC8  /* flex billing unavailable */
#define  E_ISBADIF         0xC9  /* bad interface number */
#define  E_TRACEFAIL       0xCA  /* failed to get trace information */
#define  E_UNKNOWNRESULT   0xCB  /* Unknown result code */
#define  E_ISCRNBLK        0xCC  /* failed to assigned CRNBLK */
#define  E_BADSTATE        0xCD  /* bad state */
#define  E_ABORTED         0xCE  /* task aborted */

/* 04/24/97 Using malloc to Set & RCV multiple ie buffer */
#define  E_SETTWICE        0xCF  /* SetParm(RECEIVE_INFO_BUF) twice */
#define  E_ISMISGCI        0xD0  /* miss using GetCallInfo */
#define  E_ISMISGSI        0xD1  /* miss using GetSigInfo */
#define  E_ISLSIEBUF       0xD2  /* Data may be overwrite */
/* 04/24/97 Using malloc to Set & RCV multiple ie buffer */

/*
 * Cause values
 *
 * NOTE: Not all cause values are universally supported across switch types.
 *       Before a particular cause value is used, its validity should be
 *       compared with the appropriate switch vendor specs.
 */
#define UNASSIGNED_NUMBER        0x01  /* Cause 01 */
#define NO_ROUTE                 0x02  /* Cause 02 */
#define NO_ROUTE_TO_DEST			0x03	/* Cause 03 */
#define SEND_SPECIAL_ITONE			0x04	/* Cause 04 */
#define MISDIALLED_TRUNK_PFX		0x05	/* Cause 05 */
#define CHANNEL_UNACCEPTABLE     0x06  /* Cause 06 */
#define CALL_AWARDED_IN_EST_CHAN 0x07  /* Cause 07 */
#define PREEMPTION               0x08  /* Cause 08 */
#define PREEMPTION_CHAN_RESERVED 0x09  /* Cause 09 */
#define NORMAL_CLEARING          0x10  /* Cause 16 */
#define USER_BUSY                0x11  /* Cause 17 */
#define NO_USER_RESPONDING       0x12  /* Cause 18 */
#define NO_ANSWER_FROM_USER      0x13  /* Cause 19 */
#define SUBSCRIBER_ABSENT	      0x14  /* Cause 20 */
#define CALL_REJECTED            0x15  /* Cause 21 */
#define NUMBER_CHANGED           0x16  /* Cause 22 */
#define NON_SELECTED_USR_CLEAR   0x1A  /* Cause 26 */
#define DEST_OUT_OF_ORDER        0x1B  /* Cause 27 */
#define INVALID_NUMBER_FORMAT    0x1C  /* Cause 28 */
#define FACILITY_REJECTED        0x1D  /* Cause 29 */
#define RESP_TO_STAT_ENQ         0x1E  /* Cause 30 */
#define UNSPECIFIED_CAUSE        0x1F  /* Cause 31 */
#define NO_CIRCUIT_AVAILABLE     0x22  /* Cause 34 */
#define NETWORK_OUT_OF_ORDER     0x26  /* Cause 38 */
#define PFM_CONN_OUT_OF_SERVICE  0x27  /* Cause 39 */
#define PFM_CONN_OPERATIONAL     0x28  /* Cause 40 */
#define TEMPORARY_FAILURE        0x29  /* Cause 41 */
#define NETWORK_CONGESTION       0x2A  /* Cause 42 */
#define ACCESS_INFO_DISCARDED    0x2B  /* Cause 43 */
#define REQ_CHANNEL_NOT_AVAIL    0x2C  /* Cause 44 */
#define PRE_EMPTED               0x2D  /* Cause 45 */
#define CALL_BLOCKED             0x2E  /* Cause 46 */
#define RESOURCE_UNAVAILABLE     0x2F  /* Cause 47 */
#define QOS_UNAVAILABLE          0x31  /* Cause 49 */
#define FACILITY_NOT_SUBSCRIBED  0x32  /* Cause 50 */
#define BEARER_INCOMPAT_SERVICE  0x33  /* Cause 51 */
#define OUTGOING_CALL_BARRED     0x34  /* Cause 52 */
#define OUTGOING_BARRED_IN_CUG   0x37  /* Cause 53 */ 
#define INCOMING_CALL_BARRED     0x36  /* Cause 54 */
#define INCOMING_BARRED_IN_CUG  	0x37  /* Cause 55 */ 
#define BEAR_CAP_NOT_AUTHL       0x39  /* Cause 57 */
#define BEAR_CAP_NOT_AVAIL       0x3A  /* Cause 58 */
#define INCONSISTANT_OUTB_INFO   0x3E  /* Cause 62 */
#define SERVICE_NOT_AVAIL        0x3F  /* Cause 63 */
#define CAP_NOT_IMPLEMENTED      0x41  /* Cause 65 */
#define CHAN_NOT_IMPLEMENTED     0x42  /* Cause 66 */
#define FACILITY_NOT_IMPLEMENT   0x45  /* Cause 69 */
#define RESTRICTED_DIG_INFO_ONLY 0x46  /* Cause 70 */
#define SERVICE_NOT_IMPLEMENTED  0x4F  /* Cause 79 */
#define INVALID_CALL_REF         0x51  /* Cause 81 */
#define CHAN_DOES_NOT_EXIST      0x52  /* Cause 82 */
#define BAD_CALL_ID_FOR_SUS_CALL 0x53  /* Cause 83 */
#define CALL_ID_NOT_IN_USE       0x54  /* Cause 84 */
#define NO_SUSPENDED_CALL        0x55  /* Cause 85 */
#define CALL_ID_CLEARED          0x56  /* Cause 86 */
#define NOT_MEMBER_OF_CUG        0x57  /* Cause 87 */
#define INCOMPATIBLE_DEST        0x58  /* Cause 88 */
#define NONEXISTENT_CUG          0x5A  /* Cause 90 */
#define INVALID_TRANS_NETWORK    0x5B  /* Cause 91 */
#define INVALID_MSG_UNSPEC       0x5F  /* Cause 95 */
#define MANDATORY_IE_MISSING     0x60  /* Cause 96 */
#define NONEXISTENT_MSG          0x61  /* Cause 97 */
#define WRONG_MESSAGE            0x62  /* Cause 98 */
#define BAD_INFO_ELEM            0x63  /* Cause 99 */
#define INVALID_ELEM_CONTENTS    0x64  /* Cause 100 */
#define WRONG_MSG_FOR_STATE      0x65  /* Cause 101 */
#define TIMER_EXPIRY             0x66  /* Cause 102 */
#define MANDATORY_IE_LEN_ERR     0x67  /* Cause 103 */
#define MSG_W_UNRECOGNIZED_PARAM 0x6E  /* Cause 110 */
#define PROTOCOL_ERROR           0x6F  /* Cause 111 */
#define INTERWORKING_UNSPEC      0x7F  /* Cause 127 */

/* 
   The Cause value greater than 127 is allowed to define here. There is
   no conflict with those universal defines which ranges 0 - 127 
*/
#define RESTART_ON_NON_PRIMARY 0x80                         /* Cause 128 */

#endif
