/******************************************************************************
* M3GEVTS_H:
*
* M3G API Events:  Termination and unsolicited events of 3G-324M API.
*******************************************************************************
* DIALOGIC CONFIDENTIAL	
* Copyright 2007 Dialogic Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors.  Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors.  The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors.  The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions.  No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise.  Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
* 
* Unless otherwise agreed by Dialogic in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Dialogic or Dialogic's 
* suppliers or licensors in any way.
******************************************************************************/

#ifndef _M3GEVTS_H_
#define _M3GEVTS_H_

/* M3G API Termination and unsolicited events: */
#define M3GEV_BASE                      0x1000L
#define M3GEV_OPEN_CMPLT                (M3GEV_BASE)
#define M3GEV_OPEN_FAIL                 (M3GEV_BASE | 0x01)
#define M3GEV_ENABLE_EVENTS_CMPLT       (M3GEV_BASE | 0x02)
#define M3GEV_ENABLE_EVENTS_FAIL        (M3GEV_BASE | 0x03)
#define M3GEV_DISABLE_EVENTS_CMPLT      (M3GEV_BASE | 0x04)
#define M3GEV_DISABLE_EVENTS_FAIL       (M3GEV_BASE | 0x05)
#define M3GEV_SET_PARM_CMPLT            (M3GEV_BASE | 0x06)
#define M3GEV_SET_PARM_FAIL             (M3GEV_BASE | 0x07)
#define M3GEV_GET_PARM_CMPLT            (M3GEV_BASE | 0x08)
#define M3GEV_GET_PARM_FAIL             (M3GEV_BASE | 0x09)
#define M3GEV_START_H245_CMPLT          (M3GEV_BASE | 0x0a)
#define M3GEV_START_H245_FAIL           (M3GEV_BASE | 0x0b)
#define M3GEV_FRAMING_ESTABLISHED       (M3GEV_BASE | 0x0c)
#define M3GEV_FRAMING_LOST              (M3GEV_BASE | 0x0d)
#define M3GEV_MSD_ESTABLISHED           (M3GEV_BASE | 0x0e)
#define M3GEV_MSD_FAILED                (M3GEV_BASE | 0x0f)
#define M3GEV_STOP_H245_CMPLT           (M3GEV_BASE | 0x10)
#define M3GEV_STOP_H245_FAIL            (M3GEV_BASE | 0x11)
#define M3GEV_ENDSESSION_RCVD           (M3GEV_BASE | 0x12)
#define M3GEV_ENDSESSION_SENT           (M3GEV_BASE | 0x13)
#define M3GEV_GET_LOCAL_CAPS_CMPLT      (M3GEV_BASE | 0x14)
#define M3GEV_GET_LOCAL_CAPS_FAIL       (M3GEV_BASE | 0x15)
#define M3GEV_SET_TCS_CMPLT             (M3GEV_BASE | 0x16)
#define M3GEV_SET_TCS_FAIL              (M3GEV_BASE | 0x17)
#define M3GEV_REMOTE_TCS_RCVD           (M3GEV_BASE | 0x18)
#define M3GEV_LOCAL_TCS_ACKD            (M3GEV_BASE | 0x19)
#define M3GEV_OPEN_LC_CMPLT             (M3GEV_BASE | 0x1a)
#define M3GEV_OPEN_LC_FAIL              (M3GEV_BASE | 0x1b)
#define M3GEV_REMOTE_OLC_RCVD           (M3GEV_BASE | 0x1c)
#define M3GEV_RESPOND_TO_LC_CMPLT       (M3GEV_BASE | 0x1d)
#define M3GEV_RESPOND_TO_LC_FAIL        (M3GEV_BASE | 0x1e)
#define M3GEV_CLOSE_LC_CMPLT            (M3GEV_BASE | 0x1f)
#define M3GEV_CLOSE_LC_FAIL             (M3GEV_BASE | 0x20)
#define M3GEV_REMOTE_CLOSE_LC_RCVD      (M3GEV_BASE | 0x21)
#define M3GEV_START_MEDIA_CMPLT         (M3GEV_BASE | 0x22)
#define M3GEV_START_MEDIA_FAIL          (M3GEV_BASE | 0x23)
#define M3GEV_MODIFY_MEDIA_CMPLT        (M3GEV_BASE | 0x24)
#define M3GEV_MODIFY_MEDIA_FAIL         (M3GEV_BASE | 0x25)
#define M3GEV_STOP_MEDIA_CMPLT          (M3GEV_BASE | 0x26)
#define M3GEV_STOP_MEDIA_FAIL           (M3GEV_BASE | 0x27)
#define M3GEV_SEND_H245_UII_CMPLT       (M3GEV_BASE | 0x28)
#define M3GEV_SEND_H245_UII_FAIL        (M3GEV_BASE | 0x29)
#define M3GEV_H245_UII_RCVD             (M3GEV_BASE | 0x2a)
#define M3GEV_SEND_H245_MISC_CMD_CMPLT  (M3GEV_BASE | 0x2b)
#define M3GEV_SEND_H245_MISC_CMD_FAIL   (M3GEV_BASE | 0x2c)
#define M3GEV_H245_MISC_CMD_RCVD        (M3GEV_BASE | 0x2d)
#define M3GEV_H245_REMOTE_PAUSED        (M3GEV_BASE | 0x2e)
#define M3GEV_H245_REMOTE_RESUMED       (M3GEV_BASE | 0x2f)
#define M3GEV_H245_MSD_EVT              (M3GEV_BASE | 0x30)
#define M3GEV_H245_MES_EVT              (M3GEV_BASE | 0x31)
#define M3GEV_H223_SKEW_IND_RCVD        (M3GEV_BASE | 0x32)
#define M3GEV_H223_SKEW_IND_SENT        (M3GEV_BASE | 0x33)
#define M3GEV_RESET_CMPLT               (M3GEV_BASE | 0x34)
#define M3GEV_RESET_FAIL                (M3GEV_BASE | 0x35)
#define M3GEV_START_TRACE_CMPLT         (M3GEV_BASE | 0x36)
#define M3GEV_START_TRACE_FAIL          (M3GEV_BASE | 0x37)
#define M3GEV_STOP_TRACE_CMPLT          (M3GEV_BASE | 0x38)
#define M3GEV_STOP_TRACE_FAIL           (M3GEV_BASE | 0x39)
#define M3GEV_SET_VENDORID_CMPLT        (M3GEV_BASE | 0x3a)
#define M3GEV_SET_VENDORID_FAIL         (M3GEV_BASE | 0x3b)
#define M3GEV_REMOTE_VENDORID_RCVD      (M3GEV_BASE | 0x3c)
#define M3GEV_MONA_PREF_MSG_RCVD        (M3GEV_BASE | 0x3d)
#define M3GEV_SEND_MONA_PREF_MSG        (M3GEV_BASE | 0x3e)
#define M3GEV_TX_MPC_ESTABLISHED        (M3GEV_BASE | 0x3f)
#define M3GEV_RX_MPC_ESTABLISHED        (M3GEV_BASE | 0x40)
#define M3GEV_CALL_STATISTICS           (M3GEV_BASE | 0x41)
#define M3GEV_IFRAME_RCVD               (M3GEV_BASE | 0x42)

#endif
