/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef _MMPARMS_H_
#define _MMPARMS_H_

#define MM_PM_LIB      0x10000000L          /* Library Parameter */

#define MM_PM_CH       0x00000000L          /* Channel Level Parameter */
#define MM_PM_BD       0x00800000L          /* Board Level Parameter */

#define MM_PM_TYPE_BYTE    0x00000000L      /* Byte */
#define MM_PM_TYPE_USHORT  0x20000000L      /* Unsigned Short */
#define MM_PM_TYPE_UINT    0x40000000L      /* Unsigned Int */
#define MM_PM_TYPE_STR     0x80000000L      /* String */

#define MM_PM_STR_MAXLEN   128   /* Max Length for String Parms */

#define MM_PM_MMXXX     0x05000000L   /* MM Parameter */

#define MM_LBCPRPM_BYTE     (MM_PM_LIB | MM_PM_CH | MM_PM_MMXXX | MM_PM_TYPE_BYTE)
#define MM_LBCPRPM_USHORT   (MM_PM_LIB | MM_PM_CH | MM_PM_MMXXX | MM_PM_TYPE_USHORT)
#define MM_LBCPRPM_UINT     (MM_PM_LIB | MM_PM_CH | MM_PM_MMXXX | MM_PM_TYPE_UINT)
#define MM_LBCPRPM_STR      (MM_PM_LIB | MM_PM_CH | MM_PM_MMXXX | MM_PM_TYPE_STR)

typedef enum {
	EMM_TONE_DETECTION_RX_DISABLE = 0,
	EMM_TONE_DETECTION_RX_ENABLE = 1
} eMM_DTMF_DETECTION;

/**
 * Channel and Board level Parameters
 */
typedef enum {
	/* Channel-level Parameters */
	EMM_REC_IFRAME_TIMEOUT = 0,
	EMM_TONE_DETECTION = 4,
	
	/* Board-level Parameters */
	EMM_BEEP_DURATION = 1,
	EMM_BEEP_FREQUENCY = 2,
	EMM_BEEP_AMPLITUDE = 3,

	EMM_PARM_UNDEFINED = 0xff
} eMM_PARM;

#endif /* _MMPARMS_H_ */
